UI.base.onFocus = function () {
    createjs.Tween.removeTweens(UI.base.cursor.scale);
    UI.base.cursor.alpha = 0;
};

UI.base.onNormal = function () {
};

UI.base.onkey_LEFT = function () {
    var next = null;
    if (UI.getCurrFocus().leftTo) {
        next = UI.getItem(UI.getCurrSubModule(), UI.getCurrFocus().leftTo);
    }
    UI.base.navToNext(next, "leftTo")
};

UI.base.onkey_RIGHT = function () {
    var next = null;
    if (UI.getCurrFocus().rightTo) {
        next = UI.getItem(UI.getCurrSubModule(), UI.getCurrFocus().rightTo);
    }
    UI.base.navToNext(next, "rightTo")
};

UI.base.onkey_UP = function () {
    var next = null;
    if (UI.getCurrFocus().upTo) {
        next = UI.getItem(UI.getCurrSubModule(), UI.getCurrFocus().upTo);
    }
    UI.base.navToNext(next, "upTo")
};

UI.base.onkey_DOWN = function () {
    var next = null;
    if (UI.getCurrFocus().downTo) {
        next = UI.getItem(UI.getCurrSubModule(), UI.getCurrFocus().downTo);
    }
    UI.base.navToNext(next, "downTo")
};

UI.base.navToNext = function (next, direction) {
    if (next) {
        if (next.name) {
            if (next.disable == true) {
                next = UI.getItem(UI.getCurrSubModule(), next[direction]);
                UI.base.navToNext(next, direction);
            } else {
                UI._callBubble(UI.getCurrFocus(), "onNormal", UI.getCurrFocus());
                UI.getCurrSubModule().currFocus = next;
                UI._callBubble(UI.getCurrFocus(), "onFocus", UI.getCurrFocus());
            }
        }
    } else {
        if (!UI.getCurrSubModule() || !(UI.getCurrFocus().parent)) {
            return;
        }
        next = UI.getItem(UI.getCurrSubModule(), UI.getCurrFocus().parent[direction]);
        if (next && next.name) {
            UI.base.navToNext(next, direction);
        } else {
            var nextSubModule = UI.getSubModule(UI.getCurrSubModule()[direction]);
            if (nextSubModule) {
                UI._callBubble(UI.getCurrFocus(), "onNormal", UI.getCurrFocus());
                UI.getCurrSubModule().currFocus = nextSubModule.currFocus;
                UI._callBubble(UI.getCurrFocus(), "onFocus", UI.getCurrFocus());
            }
        }
    }
};

function startAppByRemoteControl(focus, evt) {
    if(CONST.KEY.VK_ACCUWEATHER != evt.keyCode && !GLOBAL.APP_ENABLE_START_FLAG){
        DBG_ERROR("startAppByRemoteControl:not enable netflix");
        GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.APP_START_SYSLOADING_TIP;
        UI.pushGhostModule("setting", "SettingSysToast");
        return;
    }
    UI.popAllModule();
    var appName;
    switch (evt.keyCode) {
        case CONST.KEY.VK_NETFLIX:
            startThirdPartyApp(APPNAME.NETFLIX, APPNAME.NETFLIX, CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false);
            return;
        case CONST.KEY.VK_YOUTUBE:
            if (!getNetworkSatus()) {
                if (checkIsAppOn()) {
                    appControl.stopCurrentApp();
                }
                UI.pushSubModule(COMMON.MAIN, COMMON.NETWORK_TIP, true, {caller: "YOUTUBE"});
            }else{
                startThirdPartyApp(APPNAME.YOUTUBE, APPNAME.YOUTUBE, CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false);
            }
            return;
        case CONST.KEY.VK_VUDU:
            if (!getNetworkSatus()) {
                if (checkIsAppOn()) {
                    appControl.stopCurrentApp();
                }
                UI.pushSubModule(COMMON.MAIN, COMMON.NETWORK_TIP, true, {caller: "VUDU"});
            }else{
                startThirdPartyApp(APPNAME.VUDU, APPNAME.VUDU, CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false);
            }
            return;
        case CONST.KEY.VK_AMAZON:
            startThirdPartyApp(APPNAME.AMAZON, APPNAME.AMAZON, CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false);
            return;
        case CONST.KEY.VK_ACCUWEATHER:
            appName = "AccuWeather";
            break;
        case CONST.KEY.VK_FOURKNOW:
            appName = "4K Now";
            break;
        case CONST.KEY.VK_OPERASTORE:
            appName = "VEWD";
            break;
        case CONST.KEY.VK_TIKILIVE:
            appName = "TikiLive";
            break;
        case CONST.KEY.VK_BROWSER:
            appName = "TV Browser";
            break;
        case CONST.KEY.VK_DAILYMOTION:
            appName = "Dailymotion";
            break;
        case CONST.KEY.VK_SEARCH:
            appName = "SearchNOW";
            break;
        case CONST.KEY.VK_FANDANGONOW:
            appName = "FandangoNow";
            break;
        case CONST.KEY.VK_CLARO:
            appName = "Clarovideo";
            break;
        default :
            break;
    }
    var currentData = getLauncherData();
    var allAppsData = [];
    var locked = false;
    for (var i = 0; i < currentData.length; i++) {
        if (currentData[i].cmd == LauncherCMD.ALLAPP) {
            allAppsData = currentData[i].data;
        }
    }
    for (var j = 0; j < allAppsData.txts.length; j++) {
        if(appName == "4K Now" ){
            if (allAppsData.txts[j].toLowerCase().replace(" ", "") == "4know" && allAppsData.Locked[j]) {
                locked = true;
                break;
            }

        }else if(appName == "SearchNOW"){
            if (allAppsData.txts[j].toLowerCase().replace(" ", "") == "searchnow" && allAppsData.Locked[j]) {
                locked = true;
                break;
            }
        }
        else{
            if (allAppsData.txts[j] == appName && allAppsData.Locked[j]) {
                locked = true;
                break;
            }
        }

    }
    switch (evt.keyCode) {
        case CONST.KEY.VK_BROWSER:
            if(!!locked && GLOBAL.PARENTAL_LOCK_SWITCH){
                launcher.password = true;
                UI.pushSubModule("launcher", "launcherPassword",true, {caller: appName});
            }else {
                if (!getNetworkSatus()) {
                    if (checkIsAppOn()) {
                        appControl.stopCurrentApp();
                    }
                    UI.pushSubModule(COMMON.MAIN, COMMON.NETWORK_TIP, true, {caller: APPNAME.TVBROWSER});
                }else{
                    startThirdPartyApp(APPNAME.TVBROWSER, APPNAME.TVBROWSER, CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false);
                }
            }
            break;
        case CONST.KEY.VK_DAILYMOTION:
            if(!!locked && GLOBAL.PARENTAL_LOCK_SWITCH){
                launcher.password = true;
                UI.pushSubModule("launcher", "launcherPassword",true, {caller: appName});
            }else {
                if (!getNetworkSatus()) {
                    if (checkIsAppOn()) {
                        appControl.stopCurrentApp();
                    }
                    UI.pushSubModule(COMMON.MAIN, COMMON.NETWORK_TIP, true, {caller: APPNAME.DAILYMOTION});
                }else{
                    startThirdPartyApp(APPNAME.DAILYMOTION, APPNAME.DAILYMOTION, CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false);
                }
            }
            break;
        case CONST.KEY.VK_CLARO:
            if(!!locked && GLOBAL.PARENTAL_LOCK_SWITCH){
                launcher.password = true;
                UI.pushSubModule("launcher", "launcherPassword",true, {caller: appName});
            }else {
                if (!getNetworkSatus()) {
                    if (checkIsAppOn()) {
                        appControl.stopCurrentApp();
                    }
                    UI.pushSubModule(COMMON.MAIN, COMMON.NETWORK_TIP, true, {caller: APPNAME.CLAROVIDEO});
                }else{
                    startThirdPartyApp(APPNAME.CLAROVIDEO, APPNAME.CLAROVIDEO, CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false);
                }
            }
            break;
        case CONST.KEY.VK_FANDANGONOW:
            if(!!locked && GLOBAL.PARENTAL_LOCK_SWITCH){
                launcher.password = true;
                UI.pushSubModule("launcher", "launcherPassword",true, {caller: appName});
            }else {
                if (!getNetworkSatus()) {
                    if (checkIsAppOn()) {
                        appControl.stopCurrentApp();
                    }
                    UI.pushSubModule(COMMON.MAIN, COMMON.NETWORK_TIP, true, {caller: APPNAME.FANDANGONOW});
                }else{
                    startThirdPartyApp(APPNAME.FANDANGONOW, APPNAME.FANDANGONOW, CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false);
                }
            }
            break;
        case CONST.KEY.VK_ACCUWEATHER:
            if(!!locked && GLOBAL.PARENTAL_LOCK_SWITCH){
                launcher.password = true;
                UI.pushSubModule("launcher", "launcherPassword",true,{caller: appName});
            }else{
                startThirdPartyApp(APPNAME.ACCUWEATHER, APPNAME.ACCUWEATHER, CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false);
            }
            break;
        case CONST.KEY.VK_FOURKNOW:
            var appUrl = getAppUrlByName(APPNAME.APP4KNOW);
            DBG_INFO("4KNOW url is : "+appUrl);
            if(!!locked && GLOBAL.PARENTAL_LOCK_SWITCH){
                launcher.password = true;

                if(!!appUrl && appUrl=="4know-hisense"){
                    UI.pushSubModule("launcher", "launcherPassword",true, {caller: APPNAME.NEW4KNOW});
                }else{
                    UI.pushSubModule("launcher", "launcherPassword",true, {caller: APPNAME.APP4KNOW});
                }
            }else{
                if (!getNetworkSatus()) {
                    if (checkIsAppOn()) {
                        appControl.stopCurrentApp();
                    }
                    UI.pushSubModule(COMMON.MAIN, COMMON.NETWORK_TIP, true, {caller: APPNAME.APP4KNOW});
                }else{
                    try{

                        if(!!appUrl && appUrl=="4know-hisense"){
                            startThirdPartyApp(APPNAME.NEW4KNOW, "4know-hisense", CMDType.NATIVEAPP, CMDMethod.MENU, false);
                        }else{
                            startThirdPartyApp(null, APPNAME.APP4KNOW, CMDType.NATIVEAPP, CMDMethod.MENU, false,0xFFFFFF,"4k now");
                        }
                    }
                    catch(ex){
                        DBG_ERROR(ex.message);
                    }
                }
            }
            break;
        case CONST.KEY.VK_OPERASTORE:
            if(!!locked && GLOBAL.PARENTAL_LOCK_SWITCH){
                launcher.password = true;
                UI.pushSubModule("launcher", "launcherPassword",true, {caller: appName});
            }else{
                if (!getNetworkSatus()) {
                    if (checkIsAppOn()) {
                        appControl.stopCurrentApp();
                    }
                    UI.pushSubModule(COMMON.MAIN, COMMON.NETWORK_TIP, true, {caller: APPNAME.TVSTORE});
                }else{
                    startThirdPartyApp(APPNAME.TVSTORE, APPNAME.TVSTORE, CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false);
                }
            }
            break;
        case CONST.KEY.VK_SEARCH:
            if(!!locked && GLOBAL.PARENTAL_LOCK_SWITCH){
                launcher.password = true;
                UI.pushSubModule("launcher", "launcherPassword",true,{caller: appName});
            }else{
                startThirdPartyApp(APPNAME.SEARCH, "search-hisense", CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false);
            }
            break;
        case CONST.KEY.VK_TIKILIVE:
            if(!!locked && GLOBAL.PARENTAL_LOCK_SWITCH){
                launcher.password = true;
                UI.pushSubModule("launcher", "launcherPassword",true, {caller: appName});
            }else {
                var url = getAppUrlByName("TikiLive");
                if(url ==null){
                    url ="http://tikilive.com/hisense";
                }
                try{
                startThirdPartyApp(null,url, CMDType.NATIVEAPP, CMDMethod.REMOTECONTROL, false,0xFFFFFF,"TikiLive");
                }catch (e){
                    DBG_ERROR("http://tikilive.com/hisense:"+ e.message);
                }
            }
            break;
        default :
            break;
    }
}

UI.base.onkey_NETFLIX = startAppByRemoteControl;
UI.base.onkey_AMAZON = startAppByRemoteControl;
UI.base.onkey_VUDU = startAppByRemoteControl;
UI.base.onkey_YOUTUBE = startAppByRemoteControl;
UI.base.onkey_BROWSER = startAppByRemoteControl;
UI.base.onkey_DAILYMOTION = startAppByRemoteControl;
UI.base.onkey_CLARO = startAppByRemoteControl;
UI.base.onkey_FANDANGONOW = startAppByRemoteControl;
UI.base.onkey_ACCUWEATHER = startAppByRemoteControl;
UI.base.onkey_OPERASTORE = startAppByRemoteControl;
UI.base.onkey_FOURKNOW = startAppByRemoteControl;
UI.base.onkey_SEARCH = startAppByRemoteControl;
UI.base.onkey_TIKILIVE = startAppByRemoteControl;
/*add by ZZY 20161223 */
/*for the key_media , it will be used for later 51 key remote.*/
UI.base.onkey_MEDIA =function(){
    if (UI.keyState == 2) {
        return;
    }
    if (UI.getCurrModule().name == "hiMedia") {
        DBG_ALWAYS("Current module is HiMedia.");
        var deviceBrowser = UI.getSubModule("deviceBrowser");
        UI.popAllModule();
        if (!!deviceBrowser.param && deviceBrowser.param.caller == "launcher") {
            UI.pushModule("launcher");
        } else {
            openLiveTVModule();
        }
    }
    else
    {
        if(UI.isExistModule("hiMedia"))   {
            UI.popModule(true);
            hiMedia.changeByLauncher("resume");
        }else{
            UI.popAllModule();
            startThirdPartyApp(null, APPNAME.HIMEDIA, CMDType.HISENSEPAGE, CMDMethod.REMOTECONTROL, false, "#FFFFFF");
        }
    }

}

UI.base.onkey_EXIT = function () {
    try {
        //var isOpenInfobar = true;
//        if (UI.getCurrModule().name == "hiMedia") {
//            isOpenInfobar = false;
//        }
//        if (UI.getCurrModule().name == "launcher" || UI.getCurrModule().name == "base") {
//            launcher.appkeyExit = true;
//          //  launcher.mainkeyExit = true;
//        }
        UI.popAllModule();
        {
            LogReportData.LauncherRunCloseReason=1;
            DBG_INFO("logreport launcherRun close");
            //logReport('GTLauncherRun','Launcher', 0);
        }
        if (checkIsAppOn()) {
            DBG_ERROR("UI.base.onkey_EXIT:app is not stop,stop it");
            var startMethod = appControl.getCurrentStartMethod();
            if(appControl.getCurrentAPPCMD() == "https://hisense-lite-app.xumo.com/latest/index.html"
                || appControl.getCurrentAPPName() == APPNAME.OTT){
                appControl.focusCurrentApp();
                return;
            }
            appControl.stopCurrentApp();
            if(startMethod == CMDMethod.BYAPP){
                DBG_ERROR("UI.base.onkey_EXIT:app start from 4k now!")
            }else{
                appStoppedFunc = function () {
                    if(checkStartOttApp(appControl.getCurrentLocalAPPName())){
                        startOTTApp();
                    }else{
                        var obj = {
                            "name":0,
                            "url":0
                        };
                        writeFileToNative("launcher/ott.txt",objToString(obj), 1);
                        openLiveTVModule();
                        resumeDTV();
                    }

                };
            }
            return;
        }else{
            openLiveTVModule([Msg.INFO, 0]);
        }
//        if (isOpenInfobar) {
//            openLiveTVModule();
//        }
//        else {
//            openLiveTVModule([Msg.INFO, 0]);
//        }

        //switch (UI.getCurrModule().name){
        //    case "base":
        //        if (null != appGhost) {
        //            DBG_INFO('null != appGhost, appControl.stopCurrentApp()');
        //            appControl.stopCurrentApp();
        //            openLiveTVModule();
        //        }
        //        break;
        //    case "launcher":
        //
        //        launcher.popSelf(true);
        //        if (null != appGhost) {
        //            appControl.stopCurrentApp();
        //        }
        //        openLiveTVModule();
        //        break;
        //    default :
        //        UI.popAllModule();
        //        if (null == appGhost) {
        //            openLiveTVModule();
        //        }
        //        break;
        //}


    } catch (ex) {
        DBG_ERROR(ex.stack);
    }
};

UI.base.onkey_BACKSPACE = function () {
    UI.popSubModule();
};

UI.base.onkey_LAUNCHER = function () {
    if (UI.keyState == 2) {
        return;
    }
    if (!UI.launcherPreloaded) {
        return;
    }
    GLOBAL.LAUNCHER_INFO_EVENT = null;
    if (UI.getCurrModule().name == "launcher" && UI.getCurrSubModule().name!="launcherMovieDetail") {
        LogReportData.LauncherRunCloseReason=1;
        if (UI.getCurrSubModule().name == "mainTiles") {
            launcher.popSelf(true);
            return;
        }  else if (UI.isExistSubModule('mainTiles')) {
            UI.popSubModule();
            return;
        }else{
            UI.clearAllSubModule("launcher", true);
            if (launcher.caller == "base") {
                if (checkIsAppOn()) {
                    registerKeyCodesForApp();
                }
            }
            else if (launcher.caller == "hiMedia") {
                hiMedia.changeByLauncher("resume");
            }
//            launcher.popSelf(true);
        }
    }
    if (UI.getCurrModule().name == "setting" &&  UI.isExistModule("accuweather")) {
        UI.popAllModule();
        startThirdPartyApp(null, "accuweather", 37, CMDMethod.MENU, false, 0xFFFFFF,"AccuWeather", 98);
    } else if (UI.getCurrModule().name != "hiMedia" &&  UI.getCurrModule().name != "accuweather" &&  UI.getCurrModule().name != "miracast"
        &&  UI.getCurrModule().name != "searchUSO" &&  UI.getCurrModule().name != "fourknow"
        &&  UI.getCurrModule().name != "AppStore") {
        UI.popAllModule();
    }else if (UI.getCurrModule().name == "hiMedia") {
        UI.getCurrModule().changeByLauncher("pause");
    }else if(UI.getCurrSubModule().name=="launcherMovieDetail" && UI.isExistSubModule('notifications')){
        UI.popAllModule();
    }else if(UI.getCurrModule().name == "accuweather") {
        UI.getCurrModule().changeByLauncher("pause");
    }
    UI.pushModule("launcher");
    registerKeyCodesForUI();
};

UI.base.onkey_INPUT = function() {
    if (UI.keyState == 2) {
        return;
    }
    if(UI.isLoadingModule){
        DBG_ERROR("UI.isLoadingModule return!!!!");
        return;
    }
    if (UI.getCurrSubModule().name == "allInputs") {
        launcher.popSelf(true);
        return;
    }
    if (UI.getCurrModule().name != "hiMedia" &&  UI.getCurrModule().name != "accuweather"
        &&  UI.getCurrModule().name != "searchUSO" &&  UI.getCurrModule().name != "fourknow"
        &&  UI.getCurrModule().name != "AppStore") {
        LogReportData.LauncherRunCloseReason=1;
        UI.popAllModule();
    }else if (UI.getCurrModule().name == "hiMedia") {
        UI.getCurrModule().changeByLauncher("pause");
    }else if(UI.getCurrModule().name == "accuweather") {
        UI.getCurrModule().changeByLauncher("pause");
    }
    GLOBAL.LAUNCHER_INFO_EVENT = "INPUT";
    UI.pushModule("launcher");
    registerKeyCodesForUI();
};

UI.base.onkey_ALLAPP= function() {
    if (UI.keyState == 2) {
        return;
    }
    if (UI.getCurrSubModule().name == "allApps") {
        launcher.popSelf(true);
        return;
    }
    if (UI.getCurrModule().name != "hiMedia" &&  UI.getCurrModule().name != "accuweather"
        &&  UI.getCurrModule().name != "searchUSO" &&  UI.getCurrModule().name != "fourknow"
        &&  UI.getCurrModule().name != "AppStore") {
        LogReportData.LauncherRunCloseReason=1;
        UI.popAllModule();
    }else if (UI.getCurrModule().name == "hiMedia") {
        UI.getCurrModule().changeByLauncher("pause");
    }else if(UI.getCurrModule().name == "accuweather") {
        UI.getCurrModule().changeByLauncher("pause");
    }
    GLOBAL.LAUNCHER_INFO_EVENT = "APP";
    UI.pushModule("launcher");
    registerKeyCodesForUI();
};

UI.base.onkey_LIVETV = function () {
    var isOpenInfobar = true;
//    if (UI.getCurrModule().name == "hiMedia") {
//        isOpenInfobar = false;
//    }
    var ott = readFileFromNative("launcher/DefaultSource.txt", 1);
    DBG_ERROR("getOttToDefaultSource "+ JSON.stringify(ott));
    var appGhost = UI.getGhostModule(APPMODULE.CONTROL);
    if (null != appGhost) {
        UI.popAllModule();
        if(ott!=null && ott.id != 0 ){
            if(checkIsAppOn() &&(appControl.getCurrentAPPCMD() == "https://hisense-lite-app.xumo.com/latest/index.html"
                || appControl.getCurrentAPPName() == APPNAME.OTT)){
                appControl.focusCurrentApp();
                return;
            }else{
                appStoppedFunc = function () {
                    var mode = tv?model.system.getUserMode():0;
                    if(ott!=null && ott.id != 0 && mode==0){
                        var obj = {
                            "name":APPNAME.OTT,
                            "url":ott.url
                        };
                        writeFileToNative("launcher/ott.txt",objToString(obj), 1);
                        startThirdPartyApp(APPNAME.OTT,ott.url,37, CMDMethod.REMOTECONTROL, false, "#FFFFFF",APPNAME.OTT,98);

                    }else{
                        if(getLiveTVSystemDefaultInput() == "NOTSET") {
                            DBG_ERROR("user not set DefaultInput");
                            UI.pushSubModule("liveTV", "liveTVSource", true);
                            resumeDTV();
                            return;
                        } else {
                            openLiveTVModule([Msg.INFO, 0]);
                            resumeDTV();
                        }
                    }

                };
                appControl.stopCurrentApp();
                return;
            }
        }else{
            appStoppedFunc = function () {
	            if(getLiveTVSystemDefaultInput() == "NOTSET") {
                    DBG_ERROR("user not set DefaultInput");
                    UI.pushSubModule("liveTV", "liveTVSource", true);
                    resumeDTV();
                    return;
                } else {
	                if(!g_fteNoneSource.none){
	                    var defaultId = mapInputsDataByPlayId(model.source.getSystemDefaultInput());
	                    var currentId = mapInputsDataByPlayId(model.source.getCurrentSource());
	                    if(defaultId != currentId){
	                        changeSourceTo(defaultId);// model.system.getSystemDefaultInput()
	                        openLiveTVModule([Msg.WAIT_SOURCE_CHANGE, 1]);
	                    }else{
	                        DBG_INFO("get same the source")
                            var obj = {
                                "name":0,
                                "url":0
                            };
                            writeFileToNative("launcher/ott.txt",objToString(obj), 1);

	                        openLiveTVModule();
	                    }
                        resumeDTV();
	                }else{
	                    openLiveTVModule();
	                    resumeDTV();
	                }
		        }
            };
            appControl.stopCurrentApp();
        }

    }
    else {
        UI.popAllModule();
        var mode = tv?model.system.getUserMode():0;
        if(ott!=null && ott.id != 0 && mode==0){
            var obj = {
                "name":APPNAME.OTT,
                "url":ott.url
            };
            writeFileToNative("launcher/ott.txt",objToString(obj), 1);
            startThirdPartyApp(APPNAME.OTT,ott.url,37, CMDMethod.REMOTECONTROL, false, "#FFFFFF",APPNAME.OTT,98);

        }else{
            DBG_ERROR("!g_fteNoneSource.none:"+!g_fteNoneSource.none);
            if(getLiveTVSystemDefaultInput() == "NOTSET") {
                DBG_ERROR("user not set DefaultInput");
                UI.pushSubModule("liveTV", "liveTVSource", true);
                return;
            }

            if(!g_fteNoneSource.none){

                var defaultId = mapInputsDataByPlayId(model.source.getSystemDefaultInput());
                var currentId = mapInputsDataByPlayId(model.source.getCurrentSource());

                var targetSourceObj = objectFindByKey(GLOBAL.SOURCE_LIST, "id", defaultId);
                if (!!targetSourceObj) {
                    UI.callTTS(targetSourceObj.rename, 0);
                }

                if(defaultId != currentId){
                    changeSourceTo(defaultId);// model.system.getSystemDefaultInput()
                    openLiveTVModule([Msg.WAIT_SOURCE_CHANGE, 1]);
                }
                else {
                    if (isOpenInfobar) {
                        openLiveTVModule();
                    }
                    else {
                        openLiveTVModule([Msg.INFO, 0]);
                    }
                }
            } else {
                if (isOpenInfobar) {
                    openLiveTVModule();
                }
                else {
                    openLiveTVModule([Msg.INFO, 0]);
                }
            }
        }
    }


};

//UI.base.onkey_THREE = function () {
//    for (var i = 0; i < UI.loadedModule.length; i++) {
//        if (UI.loadedModule[i].name == "setting") {
//            return;
//        }
//    }
//
//    UI.popModule();
//    UI.pushModule("setting");
//};

UI.base.onkey_SLEEP=function(){
    try {
        DBG_INFO("onkey_SLEEP");
        try
        {
            var ModuleName = UI.getCurrModule().name;
            if((ModuleName == "launcher") && (launcher.isEditMode || launcher.isMoveMode || launcher.isDeleteMode)){
                DBG_INFO("launcher is in edit mode");
                return;
            }
            if(UI.getCurrModule()&&UI.getCurrSubModule().name=="SettingSysTimeSleep"){
                var SettingSysTimeSleep = UI.getSubModule("SettingSysTimeSleep");
                if(!!SettingSysTimeSleep){
                SettingSysTimeSleep.onkey_BACKSPACE();
                }
                return;
            }
        }catch (e)
        {
            DBG_ERROR(""+ e.message);
        }
        if (UI.getCurrModule().name == "setting"&&(typeof(setting) != "undefined")) {
            setting.popSelf(false);
        }
        UI.pushSubModule("setting","SettingSysTimeSleep",true);
        registerKeyCodesForUI()

    }
    catch (ex) {
        DBG_ERROR(ex.message);
    }
}
/*add by jiaguili 20160919 */
/*for the key_setting , it will be used for later 51 key remote.*/
UI.base.onkey_SETTINGS=function(){
    if (UI.keyState == 2) {
        return;
    }
    if (UI.getCurrModule().name== "setting") {
        if(UI.getCurrSubModule().name!="mainPanel")
        {
            setting.popSelf(false);
            UI.pushSubModule("setting", "mainPanel", true);
            if(UI.getCurrSubModule().name=="SettingSysTimeSleep");
            {
                registerKeyCodesForUI();
            }
        }
        else
        {
            setting.popSelf(true);
        }
        return;
    }
    else
    {
        if (UI.getCurrModule().name == "launcher"
            ||  UI.getCurrModule().name == "searchUSO" ||  UI.getCurrModule().name == "fourknow"
            ||  UI.getCurrModule().name == "AppStore" ||UI.getCurrModule().name == "miracast") {
        }else if (UI.getCurrModule().name == "hiMedia") {
            UI.getCurrModule().changeByLauncher("pause");
        }else if(UI.getCurrModule().name == "accuweather") {
            UI.getCurrModule().changeByLauncher("pause");
        }
        else {
            UI.popAllModule();
        }
    }
    UI.pushSubModule("setting", "mainPanel", true);
    registerKeyCodesForUI();
}
UI.base.onkey_FACM = function () {
    try {

        DBG_INFO('GLOBAL.FACTORY: ' + GLOBAL.FACTORY);
        if (1 == GLOBAL.FACTORY) {
            //GLOBAL.FACTORY = false; //temp add
            //UI.popSubModule();
            checkToStopFactory();
        } else if (Config.tv && 1 == model.hisfactory.getTofactoryOpition()) {
            DBG_INFO("tv && 1 == model.hisfactory.getTofactoryOpition(); FAC in U mode");
            return;
        } else {
            StartFactory();
        }

        function checkToStopFactory(keyCode) {


            if (isFileExist("his_factory_do_ok_over", 0)) {
                DBG_INFO('isFileExist("his_factory_do_ok_over", return;)');
            } else if (Config.tv && 1 == model.hisfactory.getFactoryAging()) {
                DBG_INFO("factory aging.");
            } else if (Config.tv && 8 == model.hisfactory.getFactoryCurrentSource()) {
                DBG_INFO("current source is dmp");
            } else {
                appControl.stopCurrentApp();
                UI.initLiveTV();
                //if (StrDef.UNDEFINED != typeof (liveTV)) {
                //    liveTV.initLiveTV(false);
                //    liveTV.initChannelList();
                //    openLiveTVModule([Msg.INFO, 0]);
                //}
                //else {
                //    UI.pushModule(LIVETV.MAIN);
                //}
            }
        }

    } catch (ex) {
        DBG_ERROR(ex.message);
    }
}

UI.base.runText = function(target) {
    if (target.originText) {
        if (UI.isTextRunning) {
            if (UI.runningText == target) {
                return;
            } else {
                UI.base.stopText();
            }
        }

        var tempStr = target.children[0].text;
        target.children[0].text = target.originText.substring(0, 100);
        target.originText = tempStr;

        var mask = new PIXI.Graphics();
        mask.beginFill(0xffffff, 0.5)
            .drawRect(0, 0, target.originWidth, target.children[0].height)
            .endFill();
        switch (target.children[0].style.align) {
            case "left" :
                mask.position.x = target.children[0].position.x;
                break;
            case "right" :
                mask.position.x = target.children[0].position.x - target.originWidth;
                break;
            case "center" :
                mask.position.x = target.children[0].position.x - target.originWidth / 2;
                break;
        }
        mask.position.y = target.children[0].position.y - target.children[0].height / 2;
        mask.rectWidth = target.children[0].width;
        mask.rectHeight = target.children[0].height;
        target.addChild(mask);
        target.children[0].mask = mask;

        textBound = target.children[0].getBounds();
        UI.getTween(target.children[0], true, true)
            .to({x:target.children[0].x - textBound.width - 5}, textBound.width / 30 * 1000)
            .wait(1000);
        UI.isTextRunning = true;
        UI.runningText = target;
    }
    else if (target.children) {
        for (var i = 0; i < target.children.length; i++) {
            UI.base.runText(target.children[i])
        }
    }
};

UI.base.stopText = function() {
    if (!UI.isTextRunning) {
        return;
    }
    var target = UI.runningText;
    try{
    if (target.originText) {
        createjs.Tween.removeTweens(target.children[0]);
        var tempStr = target.children[0].text;
        target.children[0].text = target.originText;
        target.originText = tempStr;
        switch (target.children[0].style.align) {
            case "left" :
                target.children[0].x = 0;
                break;
            case "right" :
                target.children[0].x = target.originWidth;
                break;
            case "center" :
                target.children[0].x = target.originWidth / 2;
                break;
        }
        target.removeChild(target.children[0].mask);
        target.children[0].mask = null;
        UI.isTextRunning = false;
        UI.runningText = null;
    } else if (target.children) {
        for (var i = 0; i < target.children.length; i++) {
            UI.base.stopText(target.children[i])
        }
    }
    }catch(e){
        DBG_ERROR("UI.base.stopText:"+ e.message);
    }
};

UI.base.findFirstTxt = function(target) {
    var txt = null;
    if (target.children) {
        for (var i = 0; i < target.children.length; i++) {
            txt = UI.base.findFirstTxt(target.children[i]);
        }
    } else if (target.text) {
        txt = target.text;
    }
    return txt;
};

UI.base.getVoiceStr = function(target) {
    var txt = "";
    if (target.selected) {
        txt = target.selected;
    }
    else if (target.switch) {
        if (target.flag) {
            txt = "[GE0005]";
        } else {
            txt = "[GE0006]";
        }
    }
    else if (target.label) {
        txt = (target.label.msgId ? target.label.msgId : target.label.text) + " " + (target.value.msgId ? target.value.msgId :target.value.text);
    }
    else if (target.percent) {
        //txt = target.percent;
    }
    else if (target.msgId) {
        //if (GLOBAL.CURRENT_LANGUAGE == "eng" || GLOBAL.CURRENT_LANGUAGE == "spa" ) {
        //    txt = target.text;
        //} else {
        //    if (target.msgId) {
        //        if (Config.ttsLanguage) {
        //            txt = Config.ttsLanguage[target.msgId];
        //        } else {
        //            txt = target.text;
        //        }
            txt = target.msgId;
        } else if (target.text != undefined && target.text != null && target.text != "") {
            txt = target.text;

        //}
    } else if (target.children) {
        for (var i = 0; i <= target.children.length - 1; i++) {
            var temStr = UI.base.getVoiceStr(target.children[i])+"";
            if (temStr && temStr.replace(/(^s*)|(s*$)/g, "").length != 0) {
                txt += temStr+":";
            }
        }
    }

    //var msgId = UI.getMsgId(txt);
    //if (msgId) {
    //    txt = txt.replace('['+msgId+']', Config.ttsLanguage[msgId]);
    //}

    //txt = UI.setTtsString(txt);

    return txt;
};

UI.base.toHiContrast = function(target) {
    if (!target || !target.children || !target.children[0]) {
        return;
    }
    if (target.children[0].bottomHeight || target.isNumberInput || target.isBg) {
        var shape = target.getChildByName("hiContrastShape");
        if (!shape) {
            shape = new PIXI.Graphics();
            shape.beginFill(0x000000)
                .drawRect(0, 0, target.width, target.height)
                .endFill();
            shape.name = "hiContrastShape";
            if (target.isNumberInput || target.isBg) {
                target.addChildAt(shape, 1);
            } else {
                target.addChild(shape);
            }
            return;
        }

    }
    for (var i = 0; i < target.children.length; i++) {
        UI.base.toHiContrast(target.children[i]);
    }
};

UI.base.toNormalContrast = function(target) {
    if (!target || !target.children || !target.children[0]) {
        return;
    }
    if (target.children[0].bottomHeight || target.isNumberInput  || target.isBg) {
        var shape = target.getChildByName("hiContrastShape");
        if (shape) {
            target.removeChild(shape);
        }
        return;
    }
    for (var i = 0; i < target.children.length; i++) {
        UI.base.toNormalContrast(target.children[i]);
    }
};

UI.base.onkey_VOICE = UI.base.onkey_VOICE_DOWN = function () {
    try{
        DBG_INFO("key onkey_VOICE");

        if(!avs_support) return;

        try {
            //notify music card
            AvsMusic.sendJsonMessage(JSON.stringify({voiceChrome: "before"}));

        } catch (ex) {
            DBG_ERROR("AVSClient notifyOtherModuleChromeShown: ex=" + ex.message);
        }
        var is_from_remote_app = (UI.currKeyValue == "VOICE_DOWN");
        if(UI.getCurrModule().name == "miracast" ){
            GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.AVS_MIRACAST_ERROR;
            UI.pushGhostModule("setting","SettingSysToastBig");
            //notify remote app
            if (is_from_remote_app) {
                pubAvsStateNotify(AVS_KEYVOICE_STATE.MIRACAST_ERROR);
            }
            return;
        }
        var info = {};
        if (!is_from_remote_app) {
            var bTAvailable = tv ? model.bluetooth.getBluetoothAvailability() : 0;
            DBG_ERROR("bTAvailable is " + bTAvailable);
            if(bTAvailable == 0)return;
            if (Hisense.File.exists("hisenseUI/disVoiceChrome", 1) && readFileFromNative("hisenseUI/disVoiceChrome", 1) == "disable") {
                DBG_ERROR("voice is " + readFileFromNative("hisenseUI/disVoiceChrome", 1));
                return;
            }

            var isBtPaired = tv ? model.bluetooth.getBtRcPaired() : [];
            if (!isBtPaired.length || isBtPaired.length < 3) {
                DBG_ERROR("isBtPaired.length is " + isBtPaired.length);
                info.helpInfoContent = "[ALX0003]";
                info.btn_right_text = "[LA0082]";
                info.destination = "BluetoothSetting";
                UI.pushSubModule("Alexa", "helpInfo", true, info);
                //notify remote app
                if (is_from_remote_app) {
                    pubAvsStateNotify(AVS_KEYVOICE_STATE.BTRC_NOT_PAIRED);
                }
                AVSClient.logReport.reportFailure(AVSClient.logReport.CONST.ERR_CODE_BTRCUNPAIR, AVSClient.logReport.CONST.ERR_TYPE_INIT);
                return;
            }
            if (isBtPaired[2] !== "connect") {
                UI.showSimpleTip("Connecting to paired remoted control...");
                //notify remote app
                if (is_from_remote_app) {
                    pubAvsStateNotify(AVS_KEYVOICE_STATE.BTRC_NOT_PAIRED);
                }
                return;
            }
        }

        if(!AVSClient.setting.getEnabled()){
            DBG_ERROR("AVSClient.setting.getEnabled() is " + AVSClient.setting.getEnabled());
            info.helpInfoContent = "[ALX0002]";
            info.btn_right_text = "[LA0082]";
            info.destination = "SettingSysAlexa";
            UI.pushSubModule("Alexa", "helpInfo", true, info);
            //notify remote app
            if (is_from_remote_app) {
                pubAvsStateNotify(AVS_KEYVOICE_STATE.AVS_DISABLE);
            }
            return;
        }
        if (AVSClient.register.getIsReplaced()) {
            DBG_ERROR("current device is replaced!");
            openMsgBoxByType(MsgBoxType.AVS_DEVICE_REPLACE);
            //notify remote app
            if (is_from_remote_app) {
                pubAvsStateNotify(AVS_KEYVOICE_STATE.NOT_REGISTER);
            }
            return;
        }

        var hisense_login_status = AVSClient.register.getRegisterStatus("hisense");
        var amazon_login_status = AVSClient.register.getRegisterStatus("amazon");
        DBG_ERROR("hisense_login_status is " + hisense_login_status + "amazon_login_status is " + amazon_login_status);
        var avsRegister = Hisense.File.exists("hisenseUI/avsRegister", 1);
        DBG_ERROR("avsRegister is " + avsRegister);
        if (getNetworkSatus() <= 0 || hisense_login_status == 100) {
            UI.pushGhostModule("Alexa", "voiceService");
            setTimeout(function () {
                UIObserver.publishMessage(UIObserver.MESSAGE_NAME.AVS_ONSPEECHSTATECHANGED, -4);
            }, 100);
            //notify remote app
            if (is_from_remote_app) {
                pubAvsStateNotify(AVS_KEYVOICE_STATE.NET_NOT_AVAILABLE);
            }
            AVSClient.logReport.reportFailure(AVSClient.logReport.CONST.ERR_CODE_INITNETERROR, AVSClient.logReport.CONST.ERR_TYPE_INIT);
            return;
        }
        if (hisense_login_status == 99) {
            openMsgBoxByType(MsgBoxType.AVS_HIS_EXPIRED);
            //notify remote app
            if (is_from_remote_app) {
                pubAvsStateNotify(AVS_KEYVOICE_STATE.NOT_REGISTER);
            }
            return;
        }
        if(!hisense_login_status||!amazon_login_status||!avsRegister){
            UI.popAllModule();
            UI.pushSubModule("Alexa" ,"register_bg",true);
            //notify remote app
            if (is_from_remote_app) {
                pubAvsStateNotify(AVS_KEYVOICE_STATE.NOT_REGISTER);
            }
            AVSClient.logReport.reportFailure(AVSClient.logReport.CONST.ERR_CODE_REGISTERERR, AVSClient.logReport.CONST.ERR_TYPE_INIT);
            return;
        }
        if (!is_from_remote_app) {
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.KEY_RELEASE, releaseVoiceKeyHandle);
            if (UI.keyState == 2) {
                return;
            }
        } else {
            UI.base.onkey_VOICE_UP = releaseVoiceKeyHandle ;
            if (UI.keyState == 2) {
                return;
            }
        }
        if(tv){
            AVSClient.speech.play();
        }
        //notify remote app
        if (is_from_remote_app) {
            pubAvsStateNotify(AVS_KEYVOICE_STATE.IDLE);
        }
        UI.pushGhostModule("Alexa", "voiceService");
    }
    catch (ex){
        DBG_ERROR(ex.message);
    }
}
function releaseVoiceKeyHandle(){
    DBG_ERROR("releaseVoiceKeyHandle:UI.currKeyValue = "+UI.currKeyValue);
    if("VOICE" == UI.currKeyValue){
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.KEY_RELEASE, releaseVoiceKeyHandle);
        AVSClient.speech.stop();
    } else if("VOICE_UP" == UI.currKeyValue){
        UI.base.onkey_VOICE_UP = null;
        AVSClient.speech.stop();
    }
}
//UI.base.onkey_VOICE_UP = function () {
//    DBG_ERROR("UI.base.onkey_VOICE_UP");
//    AVSClient.speech.stop();
//};
UI.base.onkey_VOICE_UP = null;
UI.base.onkey_KEYPADMENU = function () {
    try {
        if (UI.keyState == 2) {
            return;
        }
        //if(GLOBAL.HOTEL_MODE && GLOBAL.HOTEL_KB_LOCK){
        //    return;
        //}
        UI.popAllModule();
        var appGhost = UI.getGhostModule(APPMODULE.CONTROL);
        if (null != appGhost) {
            appControl.stopCurrentApp();
            appStoppedFunc = function(){
                DBG_INFO("onkey_KEYPADMENU");
                resumeDTV();
                GLOBAL.KEYPAD_STATE = tv?model.basicSetting.getKeypad():1;
                DBG_ERROR("onkey_KEYPADMENU"+GLOBAL.KEYPAD_STATE);
                if(!GLOBAL.KEYPAD_STATE && UI.currKeyCode == CONST.KEY.VK_KEYPAD_MENU){
                    UI.pushSubModule("mixBar", "mixBar", true,"btnOne");
                }
                else {
                    UI.pushSubModule("mixBar", "mixBar", true);
                }
            };
        }
        else {
            DBG_INFO("onkey_KEYPADMENU");
            GLOBAL.KEYPAD_STATE = tv?model.basicSetting.getKeypad():1;
            DBG_ERROR("onkey_KEYPADMENU"+GLOBAL.KEYPAD_STATE);
            if(!GLOBAL.KEYPAD_STATE && UI.currKeyCode == CONST.KEY.VK_KEYPAD_MENU){
                UI.pushSubModule("mixBar", "mixBar", true,"btnOne");
            }
            else {
                UI.pushSubModule("mixBar", "mixBar", true);
            }
        }


        //GLOBAL.MSG_BOX_TYPE = 2;
        //UI.pushSubModule("common","BluetoothRemote",true);
    }
    catch (ex) {
        DBG_ERROR(ex.message);
    }
};

/*UI.base.onkey_KEYPAD_MENU_BUTTON7 = function() {
    clearTimeout(GLOBAL.KEYPADMENU_TIMER);
    if (UI.keyState == 2) {
        return;
    }
    GLOBAL.KEYPADMENU_TIMER = setTimeout(function() {
        UI.pushSubModule("EposMessage","initStoreWithConsole",false);
    }, 3000)
};*/

/*-----------------Discrete IR Codes Remote Controller Start-----------------*/

UI.base.onkey_SERVICE_TUNER1 = function(){
   // UI.base.onkey_LIVETV();
    changeSourceByKey(["tv"]);
};
UI.base.onkey_SERVICE_TUNER2 = function(){
   // no use  current tv only has one tuner
};
UI.base.onkey_AV1 = function(){
    changeSourceByKey(["av1","av","avs"]);
};
UI.base.onkey_AV2 = function(){
    changeSourceByKey("av2");
};
UI.base.onkey_AV3 = function(){
    changeSourceByKey('av3');
};
UI.base.onkey_COMPONENT1 = function(){
    changeSourceByKey(["component1","component"]);
};
UI.base.onkey_COMPONENT2 = function(){
    changeSourceByKey(['component2']);
};
UI.base.onkey_COMPONENT31 = function(){
    changeSourceByKey(['component3']);
};
UI.base.onkey_HDMI1 = function(){
    changeSourceByKey(['hdmi1']);
};
UI.base.onkey_HDMI2 = function(){
    changeSourceByKey(['hdmi2']);
};
UI.base.onkey_HDMI3 = function(){
    changeSourceByKey(['hdmi3']);
};
UI.base.onkey_HDMI4 = function(){
    changeSourceByKey(['hdmi4']);
};
UI.base.onkey_HDMI5 = function(){
    changeSourceByKey(['hdmi5']);
};
UI.base.onkey_VGA = function(){
    changeSourceByKey(['vga']);
};

UI.base.onkey_NEC_AUTO = function () {
    try {
        if (UI.keyState == 2) {
            return;
        }
        GLOBAL.NEC_KEY = true;
        if(UI.getCurrSubModule().name == "AudioSpeaker"){
            UI.popSubModule();
            var caller = UI.getSubModule("AudioMainPanel");
            if (!caller) {
                UI.pushSubModule("setting", "AudioMainPanel", true);
            }
            return;
        }
        UI.popAllModule();
        var appGhost = UI.getGhostModule(APPMODULE.CONTROL);
        if (null != appGhost) {
            appControl.stopCurrentApp();
        }
        DBG_INFO("onkey_NEC_AUTO");
        UI.pushSubModule("setting", "AudioSpeaker", true);
    }
    catch (ex) {
        DBG_ERROR(ex.message);
    }
}
//["HDR Vivid", "HDR  Standard", "HDR Energy Saving","HDR Theater", "HDR  Game", "HDR Sports", "HDR  Calibrated"],
var HDRMode = ["[OT0098]","[OT0095]","[OT0099]","[OT0100]","[OT0094]","[SE3404]","[OT0102]"];
//["Vivid", "Standard", "Energy Saving","Theater", "Game", "Sports", "Calibrated"],
var SDRMode = ["[SE0456]", "[SE0004]", "[SE0457]", "[SE0061]", "[SE0008]", "[LA0013]", "[SE3122]"];
UI.base.onkey_PICTURE = function(){
    DBG_INFO("onkey_PICTURE");
    try {
        CheckB2BDisableFlag();
        if(!GLOBAL.B2BPicEnableFlag){
            DBG_ERROR("UI.base.onkey_PICTURE");
            return;
        }
        var ModuleName = UI.getCurrModule().name;
        if((ModuleName == "launcher") && (launcher.isEditMode || launcher.isMoveMode || launcher.isDeleteMode)){
            DBG_INFO("launcher is in edit mode");
            return;
        }
        var isHDRFlag = tv ? model.video.getHdrFlag() : 1;
        var picModeTextVec = !!isHDRFlag ?  HDRMode: SDRMode;
        var curIdx = tv?model.video.getEnumPictureMode():3;
        DBG_ERROR("model.video.getEnumPictureMode: " + curIdx);
        var GameFlag = getGameModeEnable();
        if((curIdx + 1) >= picModeTextVec.length){
            curIdx = 0
        }else if(curIdx==3 && !GameFlag){
            curIdx = curIdx +2;
        }else{
            curIdx = curIdx +1;
        }

        tv && model.video.SetPictureAdjustment(curIdx,1,1);
        DBG_INFO("model.video.SetPictureAdjustment: " + curIdx);
        GLOBAL.MTSToastStr = picModeTextVec[curIdx];
        UI.pushGhostModule("setting","MTSToast");
//        UI.base.showSimpleTip(picModeTextVec[curIdx]);
        UI.callTTS(picModeTextVec[curIdx]);
    } catch (ex) {
        DBG_ERROR(ex.message);
    }
};
UI.base.onkey_S_MODE = function(){
    try {
        CheckB2BDisableFlag();
        if(!GLOBAL.B2BSndEnableFlag){
            DBG_ERROR("UI.base.onkey_S_MODE");
            return;
        }
        var ModuleName = UI.getCurrModule().name;
        if((ModuleName == "launcher") && (launcher.isEditMode || launcher.isMoveMode || launcher.isDeleteMode)){
            DBG_INFO("launcher is in edit mode");
            return;
        }
        DBG_INFO("onkey_S_MODE");
        if((tv ? model.sound.getSpeakerArc() : 1)!= 1) return;//check whether ARC is open
//        "Standard", "Speech", "Late Night", "Music", "Theatre"
        var ModeEnum = ["[SE0004]", "[SE0062]", "[SE0542]", "[SE0060]", "[SE0061]"];
        var currSndModeIndex = tv ? model.sound.getSoundMode() : 3;
        var setSndModeIndex;
        if (currSndModeIndex + 1 >= ModeEnum.length) {
            setSndModeIndex = 0
        }
        else {
            setSndModeIndex = currSndModeIndex + 1;
        }
        DBG_INFO("setSndModeIndex:" + setSndModeIndex);
        tv && model.sound.setSoundMode(setSndModeIndex);
        GLOBAL.MTSToastStr = ModeEnum[setSndModeIndex];
        UI.pushGhostModule("setting","MTSToast");
//        UI.base.showSimpleTip(ModeEnum[setSndModeIndex]);
        UI.callTTS(ModeEnum[setSndModeIndex]);
    }
    catch (ex) {
        DBG_ERROR(ex.message);
    }

};
UI.base.onkey_ASPECT = function(){
    try {
        CheckB2BDisableFlag();
        if(!GLOBAL.B2BPicEnableFlag){
            DBG_ERROR("UI.base.onkey_ASPECT");
            return;
        }
        if(!checkAspectRatioEnAble()){return;}
        var ModuleName = UI.getCurrModule().name;
        if((ModuleName == "launcher") && (launcher.isEditMode || launcher.isMoveMode || launcher.isDeleteMode)){
            DBG_INFO("launcher is in edit mode");
            return;
        }
        var AspectRatioVec = ["[GE0012]", "[SE0080]", "[SE0049]", "[SE0463]", "[SE0467]", "[SE2901]", "[SE3127]", "[SE0464]"];
        var curIdx = tv?model.video.getEnumZoom():5;
        DBG_INFO("model.video.getEnumZoom(): " + curIdx);
        curIdx = ({0:3, 1:1, 2:6, 3:5, 4:2, 12:7, 13:0, 14:4}[curIdx]);
        DBG_INFO("getEnumZoom UI: " + curIdx);
        if(curIdx == undefined){
            curIdx=0;
        }
        var PixMapFlag =  getPixMapEnable();
        var PanaramicFlag = getPanaramicEnable();
        DBG_INFO("PixMapFlag: "+ PixMapFlag+" PanaramicFlag: "+ PanaramicFlag);

        if((curIdx + 1) >= AspectRatioVec.length){
            curIdx = 0
        }else{
            if(curIdx == 4 && !PixMapFlag && !PanaramicFlag){
                curIdx = curIdx +3;
            }else if((curIdx == 4 && !PixMapFlag && !!PanaramicFlag)
                ||(curIdx == 5 && !PanaramicFlag)){
                curIdx = curIdx +2;
            }else{
                curIdx = curIdx +1;
            }
        }
        DBG_INFO("setEnumZoom UI: " + curIdx);
        GLOBAL.MTSToastStr = AspectRatioVec[curIdx];
        UI.pushGhostModule("setting","MTSToast");
//        UI.base.showSimpleTip(AspectRatioVec[curIdx]);
        UI.callTTS(AspectRatioVec[curIdx]);
        curIdx = ({0:13, 1:1, 2:4, 3:0, 4:14, 5:3, 6:2, 7:12}[curIdx]);
        tv && model.video.setEnumZoom(curIdx);
        DBG_INFO("model.video.setEnumZoom(): " + curIdx);
    } catch (ex) {
        DBG_ERROR(ex.message);
    }
};
var picAspectRatioVec = ["Auto", "Normal", "Zoom", "Wide", "Direct", "1:1 Pixel Map", "Panoramic", "Cinema"];
UI.base.onkey_PICMODE_WIDE = function(){
    if(!checkAspectRatioEnAble()){return;}
    var curIdx = picAspectRatioVec.indexOf("Wide");
    tv && model.video.setEnumZoom(0);//3
    GLOBAL.MTSToastStr = "[SE0463]";
    UI.pushGhostModule("setting","MTSToast");
//    UI.base.showSimpleTip("[SE0463]");
    UI.callTTS("[SE0463]");
};
UI.base.onkey_PICMODE_NORMAL = function(){
    if(!checkAspectRatioEnAble()){return;}
    var curIdx = picAspectRatioVec.indexOf("Normal");
    tv && model.video.setEnumZoom(1);//1
    GLOBAL.MTSToastStr = "[SE0080]";
    UI.pushGhostModule("setting","MTSToast");
//    UI.base.showSimpleTip("[SE0080]");
    UI.callTTS("[SE0080]");
};
UI.base.onkey_PICMODE_CINEMA = function(){
    if(!checkAspectRatioEnAble()){return;}
    var curIdx = picAspectRatioVec.indexOf("Cinema");
    tv && model.video.setEnumZoom(12);//7
    GLOBAL.MTSToastStr = "[SE0464]";
    UI.pushGhostModule("setting","MTSToast");
//    UI.base.showSimpleTip("[SE0464]");
    UI.callTTS("[SE0464]");
};
UI.base.onkey_PICMODE_PANORAMA = function(){
    if(!checkAspectRatioEnAble()){return;}
    var curIdx = picAspectRatioVec.indexOf("Panoramic");
    tv && model.video.setEnumZoom(2);//6
    GLOBAL.MTSToastStr = "[SE3127]";
    UI.pushGhostModule("setting","MTSToast");
//    UI.base.showSimpleTip("[SE3127]");
    UI.callTTS("[SE3127]");
};
UI.base.onkey_ZOOM =
UI.base.onkey_PICMODE_ZOOM = function(){
    if(!checkAspectRatioEnAble()){return;}
    var curIdx = picAspectRatioVec.indexOf("Zoom");
    tv && model.video.setEnumZoom(4);//2
    GLOBAL.MTSToastStr = "[SE0049]";
    UI.pushGhostModule("setting","MTSToast");
//    UI.base.showSimpleTip("[SE0049]");
    UI.callTTS("[SE0049]");
};
UI.base.onkey_PICTURE_MOVIE = function(){
    var isHDRFlag = tv ? model.video.getHdrFlag() : 3;
    tv && model.video.setEnumPictureMode(3);
    DBG_INFO("model.video.setEnumPictureMode: 3");
    var picModeTextVec = !!isHDRFlag ?  HDRMode: SDRMode;
    GLOBAL.MTSToastStr = picModeTextVec[3];
    UI.pushGhostModule("setting","MTSToast");
//    UI.base.showSimpleTip(picModeTextVec[3]);
    UI.callTTS(picModeTextVec[3]);

};
UI.base.onkey_SOUND_MOVIE = function(){
    tv && model.video.setSoundMode(1);//2
    DBG_INFO("model.video.setSoundMode(1)");
    GLOBAL.MTSToastStr = "[SE0061]";
    UI.pushGhostModule("setting","MTSToast");
//    UI.base.showSimpleTip("[SE0061]");
    UI.callTTS("[SE0061]");
};
UI.base.onkey_PICTURE_THEATER = function(){
    DBG_INFO("onkey_PICTURE_THEATER");
    try {
        var ModuleName = UI.getCurrModule().name;
        if((ModuleName == "launcher") && (launcher.isEditMode || launcher.isMoveMode || launcher.isDeleteMode)){
            DBG_INFO("launcher is in edit mode");
            return;
        }
        var isHDRFlag = tv ? model.video.getHdrFlag() : 1;
        var picModeTextVec = !!isHDRFlag ?  HDRMode: SDRMode;
        theaterIdx = 3;
        tv && model.video.SetPictureAdjustment(theaterIdx,1,1);
        DBG_INFO("model.video.SetPictureAdjustment: " + theaterIdx);
        GLOBAL.MTSToastStr = picModeTextVec[theaterIdx];
        UI.pushGhostModule("setting","MTSToast");
        UI.callTTS(picModeTextVec[theaterIdx]);
    } catch (ex) {
        DBG_ERROR(ex.message);
    }
};
UI.base.onkey_PICTURE_SPORTS = function(){
    DBG_INFO("onkey_PICTURE_SPORTS");
    try {
        var ModuleName = UI.getCurrModule().name;
        if((ModuleName == "launcher") && (launcher.isEditMode || launcher.isMoveMode || launcher.isDeleteMode)){
            DBG_INFO("launcher is in edit mode");
            return;
        }
        var isHDRFlag = tv ? model.video.getHdrFlag() : 1;
        var picModeTextVec = !!isHDRFlag ?  HDRMode: SDRMode;
        sportsIdx = 5;
        tv && model.video.SetPictureAdjustment(sportsIdx,1,1);
        DBG_INFO("model.video.SetPictureAdjustment: " + sportsIdx);
        GLOBAL.MTSToastStr = picModeTextVec[sportsIdx];
        UI.pushGhostModule("setting","MTSToast");
        UI.callTTS(picModeTextVec[sportsIdx]);
    } catch (ex) {
        DBG_ERROR(ex.message);
    }
};
//UI.base.onkey_CH_LIST = function(){
//
//};
//UI.base.onkey_FAVCHANNEL = function(){
//
//};
//UI.base.onkey_PRE_CH = function(){
//
//};
UI.base.onkey_PROGRAMINFO = function(){

};
UI.base.onkey_TEST = function(){
    //onEnterSuspendChanged(1)
    UI.pushSubModule("testModule", "dynamic", true);

    //if (window["testModule"]) {
    //    UI.getCurrModule() = window["testModule"];
    //    UI.Creater();
    //    doPushSubModule();
    //} else {
    //    window["testModule"] = new createjs.Container();
    //    window["testModule"].setBounds(0, 0, 1920, 1080);
    //    window["testModule"].name = "testModule";
    //    UI.frontStage.addChild(window["testModule"]);
    //    UI.getCurrModule() = window["testModule"];
    //    $LAB.script("module/testModule.js")
    //        .script("module/testModule/testSub2.js")
    //        .wait(function(){
    //            UI.Creater();
    //            doPushSubModule();
    //        });
    //}
    //
    //function doPushSubModule() {
    //    var subModule = window["testModule"]["testSub2"];
    //
    //    if (subModule.onPush) {
    //        subModule.onPush({});
    //    }
    //
    //    UI.getCurrSubModule() = subModule;
    //    UI.getCurrModule().currFocus = subModule.currFocus;
    //
    //    if (subModule.onShow) {
    //        subModule.onShow();
    //    }
    //
    //    createjs.Tween.removeTweens(UI.base.cursor);
    //
    //    UI._callBubble(subModule.currFocus, "onFocus", subModule.currFocus);
    //    UI.moveTop(subModule.currFocus);
    //
    //    subModule.visible = true;
    //    UI.base.cursor.visible = true;
    //    UI.endLoading();
    //    UI.activeKey();
    //
    //    if (subModule.afterPush) {
    //        subModule.afterPush();
    //    }
    //}
};

UI.base.onkey_KPAD= function() {
    DBG_INFO("APPMODULE.KpadToast:" + APPMODULE.KpadToast);
    if (1 == GLOBAL.FACTORY){
        return true;
    }else{
        if(APPMODULE.KpadToast == null){
            UI.pushGhostModule("setting","KeypadToast");
            APPMODULE.KpadToast = "KpadToast";
        }else{
            if(checkIsAppOn()&& UI.getCurrModule().name=="base"){
                registerKeyCodesForApp();
            }
            UI.popGhostModule("KeypadToast");
            APPMODULE.KpadToast = null;
        }
    }
};


UI.base.onkey_PLAYPAD= function() {
    if (1 == GLOBAL.FACTORY){
        return true;
    }else{
        if(APPMODULE.LayoutToast == null){
            UI.pushGhostModule("setting","LayoutToast");
            APPMODULE.LayoutToast = "LayoutToast";
        }else{
            if(checkIsAppOn()&& UI.getCurrModule().name=="base"){
                registerKeyCodesForApp();
            }
            UI.popGhostModule("LayoutToast");
            APPMODULE.LayoutToast = null;
        }
    }
};

//UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.KEY_RELEASE, function() {clearTimeout(GLOBAL.KEYPADMENU_TIMER);});
