var accuweatherDeleteCityPage={};
UI.moduleBuilder['accuweather']['accuweatherDeleteCity'] = function(){
    var accuweatherDeleteCity_Data = {
        bg:UI.window_bg,
        BgSheet:UI['bg_overlay'],
        delpage_title:'[WE0009]'//Please delete a city
    };
    var template = Util.readJson("module/accuweather/accuweatherDeleteCity.json");
    var accuweatherDeleteCity = SubModule.create(accuweatherDeleteCity_Data, template);
    var allList = UI.getItem(accuweatherDeleteCity, "DelItem_anchor");
    var item_content=UI.getItem(accuweatherDeleteCity,"item_content");
    UI.addMask(item_content, 900, 680);

    UI.setView(item_content, 900, 680);

    var info = {
        template : "accuweatherDeleteCityItem",
        direction : CONST.GIRD_DIRECTION.H,
        breakNum : 1,
        distanceX : 40,
        distanceY: 20,
        container : allList
    };
    var pageData={
        accu_dc_title: {Data: 'Please delete a city'},
        accu_dc_list: {Data: [], SelectedIndex: 0}
    };
    accuweatherDeleteCityPage.oprtData = {};
    accuweatherDeleteCity.onShow = function() {
       UI.getCurrSubModule().alpha=1;
        initData();
    }
    function initData(){
        accuweatherDeleteCityPage.oprtData.cityList = accuweather.getCityList();
        accuweatherDeleteCityPage.oprtData.defInd = accuweather.getDefaultCityId();
        rewritePageData();
    }
    accuweatherDeleteCity.onExit=function(to){

    }
    accuweatherDeleteCity.onkey_BACKSPACE=function(){
        UI.popSubModule();
        UI.focusTo(accuweather.initfocus);
    }
    accuweatherDeleteCityPage.deleteTheSelectedCity=function() {
        if(accuweatherDeleteCityPage.oprtData.selectedIndex ==accuweatherDeleteCityPage.oprtData.defInd) {
            accuweatherDeleteCityPage.oprtData.defInd = 0;
        }
        else if(accuweatherDeleteCityPage.oprtData.selectedIndex < accuweatherDeleteCityPage.oprtData.defInd) {
            accuweatherDeleteCityPage.oprtData.defInd--;
        }
        var locId = accuweatherDeleteCityPage.oprtData.cityList[accuweatherDeleteCityPage.oprtData.selectedIndex].locId;
        accuweatherDeleteCityPage.oprtData.cityList.splice(accuweatherDeleteCityPage.oprtData.selectedIndex, 1);
        writeFileToNative(accuweather.getCityListPath(), objToString({
            defInd: accuweatherDeleteCityPage.oprtData.defInd,
            cityList: accuweatherDeleteCityPage.oprtData.cityList
        }), 1);
        accuweather.needRefreshWhenDelete(locId);
    }
    accuweatherDeleteCity.onkey_ENTER= function openConfirmDialog() {
        if(-1!=UI.getCurrFocus().name.indexOf('item')){
            accuweatherDeleteCityPage.oprtData.selectedIndex = UI.getCurrFocus().name.split("item")[1];
            UI.popSubModule();
            UI.pushSubModule("accuweather","ConfirmDialog",true);
        }

    }
    function rewritePageData() {
        if(!accuweatherDeleteCityPage.oprtData.cityList) return;
        pageData.accu_dc_list.Data = [];
        for(var i = 0; i < accuweatherDeleteCityPage.oprtData.cityList.length; i++) {
            pageData.accu_dc_list.Data.push({
                accu_dcl_city: accuweatherDeleteCityPage.oprtData.cityList[i].locName + ", " + accuweatherDeleteCityPage.oprtData.cityList[i].locCountry + (i == accuweatherDeleteCityPage.oprtData.defInd ? ' ([FTE0055])' : ''),//Home
                del_pic:"accuweather/trash_can.png" ,
                Del_item_bg:UI.item_bg,
                name:"item"+i
            })
        }
        //info.container.removeAllChildren();
        for(;info.container.children.length>0;){
            info.container.children.pop();
        }
        if(pageData.accu_dc_list.Data.length==0){
            UI.popSubModule();
        }
        Gird.create(pageData.accu_dc_list.Data, info);
        accuweatherDeleteCity.currFocus = UI.getItem(allList,"item0");

        UI.updateStage();
    }
    initData();
};


