// Global Module Var
var accuweather = window["accuweather"];
(function(){
    try{
        hisenseUIConfig = tv?readFileFromNative("weather/accuWeather_config.ini", 1):"";
    }catch(ex){DBG_ERROR(ex.message)}
    var Mute=null;
    accuweather.onFocus = function(focus) {
        try{
            //var focus=UI.getCurrSubModule().currFocus;
            UI.moveCursor(UI.adjustView());
            UI.getTween(focus.scale).to({x:1.05, y:1.05}, 200, UI.ease.quartOut);
            UI.getTween(UI.base.cursor).to({alpha:1}, 500, UI.ease.quartOut);
            UI.moveTop(focus);
        }catch(ex){DBG_ERROR('accuweather.onFocus:'+ex.message)}
    };
    accuweather.onNormal = function(focus) {
        try{
            UI.getTween(focus.scale).to({x:1, y:1}, 500, UI.ease.quartOut);
            UI.getTween(UI.base.cursor).set({alpha:0});
        }catch(ex){DBG_ERROR('accuweather.onNormal:'+ex.message)}
    };
    function soundState(){
        var mute=null;
        if(tv){
            mute= parseInt(model.sound.getMainMute());
        }
        if(mute!=null){
            return mute;
        }else{
            DBG_ERROR("getMainMute is error");
            return -1;
        }

    }
    //accuweather.onkey_EXIT = function() {
    //    //UI.popModule();
    //    return true;
    //    //accuweather.caller.alpha = 1;
    //}
    accuweather.onkey_BACKSPACE=function(){
        if(UI.getCurrSubModule().name!="accuweatherMain"){
            UI.popSubModule();
        }else{
            UI.popModule();
            openLiveTVModule();
        }
    }
    accuweather.onkey_ENTER = function() {
        UI.getTween(UI.getCurrModule().currFocus).to({scaleX:0.9, scaleY:0.9}, 100).to({scaleX:1, scaleY:1}, 100);
    };
    accuweather.onShow=function(){
        AccuWeatherData.startFlag=true;
        if(tv){
            //Mute=soundState();
            //DBG_INFO("soundState:"+Mute);
            pauseDTV();
            UI.popGhostModule("volumeCtrl");
            //if(!Mute){
            //    model.sound.setMainMute(1);
            //}
        }
    }
    accuweather.onExit=function(){
        if(tv){
            resumeDTV(500);
            //if(!Mute){
            //    model.sound.setMainMute(0);
            //}
            UI.pushGhostModule("volumeBar", "volumeCtrl");
            //setTimeout(function() {
            //}, 300);
        }
    }
    accuweather.onPush=function(){
        UI.pushSubModule("accuweather", "accuweatherMain", true);
        var tmp_param={
            AppName:"accuweather",
            LaunchSource:1
        }
        DBG_INFO("log report GTAPPRun is open")
        LGReport.GTAPPRunStart(tmp_param.AppName,tmp_param.LaunchSource);
    }
    accuweather.onPop=function(){
        try{
            AccuWeatherData.startFlag=false;
            var tmp_param={
                AppName:"accuweather",
                LaunchSource:1
            }
            DBG_INFO("log report GTAPPRun is closed")
            DBG_INFO("log report GTAPPRun is closed:GLOBAL.TV_SUSPENDING="+GLOBAL.TV_SUSPENDING);
            if(!GLOBAL.TV_SUSPENDING){
                LGReport.GTAPPRunClose(tmp_param.AppName,tmp_param.LaunchSource);
            }else{
                DBG_ERROR("accuweather.onPop GLOBAL.TV_SUSPENDING");
            }
        }catch(ex){DBG_ERROR(ex.message)}
    }
    accuweather.onkey_MENU=function(){
        var curModeIndex = tv? model.system.getUserMode(): 0;
        if(curModeIndex != 0){
            UI.pushSubModule("setting",  "storeModeSettingMenu", true, {origin:"weather"});
        }
        else{
            UI.pushSubModule("setting", "menuChip", true, {origin: "weather"});
        }
    }
})();