UI.moduleBuilder['FTE']['fte_complete'] = function(){
    var completeData = {
        modeHintText:"" ,//"Press \"Finish\" to use your TV, for retailers press \"Store Mode\"."
        btnBgImg: UI.item_bg,
        networkBtnText: "[SE3500]",//"Set up network"
        networkHelptext: "[SE3499]"//"You will need internet connectivity to access built-in music, sports or movie apps and the web browser."
    };
    var template = Util.readJson("module/FTE/fte_complete.json");
    var complete = SubModule.create(completeData, template);

    var background = UI.getSubModule("fte_background");
    var userModeLabel = UI.getItem(complete, "userModeLabel");
    var networkLabel = UI.getItem(complete, "networkLabel");
    var modeHintText = UI.getItem(complete, "modeHintText");
    var networkHelptext = UI.getItem(complete, "networkHelptext");
    var completeImg = UI.getItem(complete, "completeImg");
    var finishBtnText = UI.getItem(complete, "finishBtnText");

    var networkBtn = UI.getItem(complete, "networkBtn");
    var finishBtn = UI.getItem(complete, "finishBtn");


    LabelValue.create(userModeLabel,"[SE0807]","48px SourceSansPro-Light","0xFFFFFF");//Use Mode
    userModeLabel.setValue("[SE0244]");
    LabelValue.create(networkLabel,"[SE0119]","48px SourceSansPro-Light","0xFFFFFF");//Network
    complete.currFocus = finishBtn;

    complete.onShow = function(){
        background.open();
        hideNavbarOrNot(0);
        var networkStatus = tv?model.network.getEnumNetworkAvailable():0;//0：没有上网；1：连接上网
        DBG_ERROR("networkStatus is " + networkStatus);
        if(networkStatus == 1){
            UI.setImage(completeImg, "FTE/fte_finish_network.png");
            complete.currFocus = finishBtn;
            showNetworkType();
            UI.setText(finishBtnText,"[SE3498]");//"Start to use"
            UI.setText(modeHintText,"[SE3495]");//"Congratulations! You have completed TV setup."
            networkHelptext.alpha = 0;
            networkBtn.alpha = 0;
        }else{
            UI.setImage(completeImg, "FTE/fte_finish_nonetwork.png");
            complete.currFocus = networkBtn;
            networkLabel.setValue("[SE0400]");
            UI.setText(modeHintText,"[SE3496]");//"You are at the last step of TV setup."
            UI.setText(finishBtnText,"[SE3497]" );//"Use without network"
            networkHelptext.alpha = 1;
            UI.setText(networkHelptext,"[SE3499]");//"You will need internet connectivity to access built-in music, sports or movie apps and the web browser."
            networkBtn.alpha = 1;
            finishBtn.alpha = 1;
        }
    }

    finishBtn.onkey_LEFT = function(){
        if(networkBtn.alpha == 1){
           UI.focusTo(networkBtn);
        }
    }
    networkBtn.onkey_RIGHT = function(){
        if(finishBtn.alpha == 1){
            UI.focusTo(finishBtn);
        }
    }
    finishBtn.onkey_ENTER = function(){
        UI.popSubModule();
        UI.pushSubModule("FTE", "fte_logReport", true);
    }
    networkBtn.onkey_ENTER = function(){
        if(GLOBAL.UI_BRAND == "tos"){
            fteUpdate(-1);
        }else{
            fteUpdate(-2);
        }
    }
    complete.onkey_BACKSPACE = function(){
        fteUpdate(-1);
    }

    complete.onPop = function(){

    }

    function showNetworkType(){
        if(!tv) {networkLabel.setValue("[SE0400]");return;}
        var netIndex = tv ? model.network.getEnumNetworkAvailable() : 1;//0：未连接  1：已联网
        var netType = tv ? model.network.getEnumNetworking() :1;////1：有线,2：无线，0:关闭
        var wirelessName = tv ? model.network.getSsid() :"gogogo";//获取无线网络的名称
        DBG_ERROR("netIndex is " + netIndex + " netType is " + netType + " wirelessName is " + wirelessName);
        if(netIndex == 0){
            networkLabel.setValue("[SE0400]");//"Disconnected"
        }else{
            if(netType == 1){
                networkLabel.setValue("[SE0159]");//有线网："Ethernet"
            }else if(netType == 2){
                networkLabel.setValue(wirelessName);//无线网：wirelessName
            }
        }
    }
}
