// Global Module Var
var FTE = window["FTE"];

// Init
(function(){
    FTE.fteStepIndex = 0;   //FTE当前步骤序号
    FTE.fteSequence = [
        "fte_language2",
        "fte_disclaimer",
        "fte_userMode",
        "fte_network",
        "fte_productRegister",
        "fte_complete"
    ];
    FTE.fteTitle = [
        "localization",
        "disclaimer",
        "userMode",
        "Network",
        "Register",
        "complete"
    ];
    FTE.fteNavbarContent = [
        "1",
        "2",
        "3",
        "4",
        "5",
        "6"
    ];
    FTE.enableKeyGroup = [
        CONST.KEY.VK_UP, CONST.KEY.VK_DOWN, CONST.KEY.VK_LEFT, CONST.KEY.VK_RIGHT,
        CONST.KEY.VK_BACKSPACE, CONST.KEY.VK_ENTER, CONST.KEY.VK_ESCAPE,
        CONST.KEY.VK_BLUE, CONST.KEY.VK_RED, CONST.KEY.VK_GREEN, CONST.KEY.VK_YELLOW, CONST.KEY.VK_F1,
        CONST.KEY.VK_POWER, CONST.KEY.VK_POWER_ON, CONST.KEY.VK_POWER_KEY_PAD,
        CONST.KEY.VK_1, CONST.KEY.VK_2, CONST.KEY.VK_3, CONST.KEY.VK_4, CONST.KEY.VK_5,
        CONST.KEY.VK_6, CONST.KEY.VK_7, CONST.KEY.VK_8, CONST.KEY.VK_9, CONST.KEY.VK_0,
        CONST.KEY.VK_VOLUME_UP, CONST.KEY.VK_VOLUME_DOWN,CONST.KEY.VK_MUTE,
        CONST.KEY.VK_CHANNEL_UP, CONST.KEY.VK_CHANNEL_DOWN,
        CONST.KEY.VK_KEYPAD_CHANNEL_UP, CONST.KEY.VK_KEYPAD_CHANNEL_DOWN
    ];

    FTE.enableKeyGroup = FTE.enableKeyGroup.concat(CONST.KEYBOARD_KEYCODE_MAP.slice(0, 126));

    FTE.TIMEOUT = tv? 300000: 3000000;//300000  10000
    FTE.CECTIMEOUT = tv? 870000: 10000000;//

    FTE.isTimeoutPlay4KVideo = false;
})();

// Actions
(function(){

    FTE.onPush = function() {
        DBG_ERROR("FTE ENTER!!!!");
        DBG_ERROR("GLOBAL.UI_BRAND is " + GLOBAL.UI_BRAND);
        if(GLOBAL.UI_BRAND == "tos"){
            FTE.fteSequence = [
                "fte_language2", "fte_disclaimer", "fte_userMode", "fte_network", "fte_complete"
            ];
            FTE.fteTitle = [
                "localization", "disclaimer", "userMode", "Network", "complete"
            ];
            FTE.fteNavbarContent = [
                "1", "2", "3", "4", "5"
            ];
        }else{
            FTE.fteSequence = [
                "fte_language2", "fte_disclaimer", "fte_userMode", "fte_network", "fte_productRegister", "fte_complete"
            ];
            FTE.fteTitle = [
                "localization", "disclaimer", "userMode", "Network", "Register", "complete"
            ];
            FTE.fteNavbarContent = [
                "1", "2", "3", "4", "5", "6"
            ];
        }

        if(tv && getWizardSetFlag() != 0){
            clearOpenFromStandbyFlag();
        }
        UI.registerKeyCodes(FTE.enableKeyGroup);    //按键屏蔽
        FTE.isOpenLiveTV = true;
        FTE.isResumeDtv = true;
        pauseDTV();
        FTE.fteStepIndex = getWizardStep();
        UI.setEnterEulaTimeout(function(){
            if(UI.getCurrSubModule().name == "fte_language2"){
                DBG_ERROR("change to eula");
                fteUpdate(1);
                UI.setEnterStoreTimeout(function(){
                    DBG_ERROR("change to store mode");
                    UI.pushSubModule("FTE", "fte_storeDialog", true, {caller:"store"});
                },FTE.TIMEOUT)
            }
            else if(UI.getCurrSubModule().name == "fte_disclaimer"){
                DBG_ERROR("power on change to store mode");
                UI.pushSubModule("FTE", "fte_storeDialog", true, {caller:"store"});
            }
            else{

            }
        },FTE.TIMEOUT);

        UI.setFteMenuTimeout(function(){
            UI.pushSubModule("FTE","fte_storeDialog",true);
        },FTE.CECTIMEOUT);

        FTE.langPageInitDone = false;
        UI.pushSubModule("FTE", "fte_background", false);
        if(tv && getWizardSetFlag() == 1){
            model.system.setFteshow(2);
        }
    };

    FTE.onPop = function(){
        DBG_ERROR("pop fte ");
        UI.registerKeyCodes(null);
        UI.setKeyGroup(7);
    };

    FTE.fteExit = function(callback,holdFteFlag) {
        DBG_ERROR("FTE Exit!!!!!!!!!!!!!!!!!!!");
        if(!holdFteFlag){
            setWizardStep(0);
            setWizardSetFlag(0);
            try{
                model.hisfactory.ActionFactoryOKBoot();
            }catch(ex){
                DBG_ERROR(ex.message);
            }
        }
        UI.popAllModule();

        UI.clearFteMenuTimeout();
        UI.clearEnterEulaTimeout();
        UI.clearEnterStoreTimeout();

        if (tv) {
            if (FTE.isResumeDtv) {
                resumeDTV();
            }
            if (FTE.isOpenLiveTV) {
                openLiveTVModule();
            }
            try{
                if(model.network.getEnumNetworkAvailable() == NetWorkConnect.CONNECT &&  model.network.getEnumNetworking() == NetWorkType.WIRELESS){
                    LGReport.GTFTE("Wireless");
                }else if(model.network.getEnumNetworkAvailable() == NetWorkConnect.CONNECT &&  model.network.getEnumNetworking() == NetWorkType.ETHER){
                    LGReport.GTFTE("Ethernet");
                }else{
                    LGReport.GTFTE("Not Connected");
                }
            }catch(ex){
                DBG_ERROR(ex.message);
            }
        }
        FTE.isOpenLiveTV = true;
        FTE.isResumeDtv = true;

        if ((typeof callback) == "function") {
            DBG_INFO("FTE exit do callback");
            callback();
        }

        UI.registerKeyCodes(null);  //解锁按键屏蔽
        UI.setKeyGroup(7);
    };

    FTE.play4kVideo = function(play4kVideoCallback) {   //这里的callback可能是起launcher或者播放e-Pos或者其他FTE退出时的动作
        FTE.isTimeoutPlay4KVideo = false;
        var callbackType = typeof play4kVideoCallback;
        if (callbackType == "function") {
            FTE.play4kVideoCallback = play4kVideoCallback;
        }
        else {
            FTE.play4kVideoCallback = null;
        }
        UI.pushSubModule("FTE", "fte_videoPlay", true);
    };

    FTE.onExit = function() {
        UI.clearFteMenuTimeout();
        UI.registerKeyCodes(null);
        UI.setKeyGroup(7);
    };

    FTE.onFocus = function(focus) {
        if (GLOBAL.HICONTRAST) {
            UI.base.toHiContrast(focus);
        }
        if(GLOBAL.TTS){
            if (focus.voiceStr) {
                UI.callTTS(focus.voiceStr);
            } else {
                UI.callTTS(UI.base.getVoiceStr(focus))
            }
        }

        UI.moveCursor(UI.adjustView());
        UI.getTween(focus.scale).wait(100).to({x:1.05, y:1.05}, 500, UI.ease.quartOut);
        UI.getTween(UI.base.cursor).wait(100).to({alpha:1}, 500, UI.ease.quartOut);
        UI.moveTop(focus);
        UI.base.runText(focus);
    };

    FTE.onNormal = function(focus) {
        if (GLOBAL.HICONTRAST) {
            UI.base.toNormalContrast(focus);
        }
        UI.getTween(focus.scale).to({x:1, y:1}, 200);
        UI.base.stopText(focus);
    };

    FTE.onkey_ENTER = function(focus) {
        UI.getTween(focus.scale).to({x:0.9, y:0.9}, 100).to({x:1, y:1}, 100);
    };


    FTE.onkey_BACKSPACE = function() {
        fteUpdate(-1);
    };

    FTE.onkey_ESCAPE = function() {

    };

    FTE.loadingtimer = null;
    FTE.loadingIcon = null;
    FTE.networkStartLoading = function (from, timeout) {
        DBG_INFO("[FTE.networkStartLoading]" + from);
        if(FTE.loadingtimer != null){
            DBG_INFO("FTE.networkStartLoading has existed");
            return;
        }
        if (!timeout) {
            timeout = 5;
        }
        UI.registerKeyCodes([CONST.KEY.VK_BACK]);   //todo 添加各自的返回键行为
        UI.setKeyGroup(7);


        var baseTexture = PIXI.BaseTexture.fromImage(themeDir + "FTE/loading.png");
        baseTexture.common = true;
        var texture = new PIXI.Texture(baseTexture);
        FTE.loadingIcon = new PIXI.Sprite(texture);
        FTE.loadingIcon.number = 0;
        FTE.loadingIcon.anchor.x = 0.5;
        FTE.loadingIcon.anchor.y = 0.5;
        FTE.loadingIcon.x = 960;
        FTE.loadingIcon.y = 540;
        FTE.loadingIcon.name = "fteLoadingIcon";



        if (UI.base.getChildByName(FTE.loadingIcon.name) == null) {
            UI.base.addChild(FTE.loadingIcon);
        }
        UI.getTween(FTE.loadingIcon, true, true).to({rotation: FTE.loadingIcon.rotation + Math.PI*2}, 1000);
        FTE.loadingtimer = setTimeout(function () {
            FTE.networkEndLoading("startLoading timeout");
        }, timeout * 1000);
    };
    FTE.networkEndLoading = function (from) {
        DBG_INFO("[FTE.networkEndLoading]" + from);
        try {
            if (!!FTE.loadingtimer) {
                clearTimeout(FTE.loadingtimer);
                FTE.loadingtimer = null;
            }
            if (!!FTE.loadingIcon) {
                createjs.Tween.removeTweens(FTE.loadingIcon);
                UI.base.removeChild(FTE.loadingIcon);
                FTE.loadingIcon = null;
            }
//            UI.activeKey();
            UI.registerKeyCodes(FTE.enableKeyGroup);
            UI.setKeyGroup(7);
            UI.updateStage();
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    };

    FTE.onkey_F1 = function() {
        DBG_INFO("FTE.onkey_F1: FTE exit");
        FTE.fteExit();
    };



    FTE.onkey_CHUP = function() {};
    FTE.onkey_CHDOWN = function() {};

})();

function dispalySwitch(target) {
    target.alpha == 0? (target.alpha = 1) : (target.alpha = 0);
}

function fteGirdSelect(tar, fun) {
    tar.DataSelected.children[1].alpha = 0;

    tar.DataSelected = UI.getCurrSubModule().currFocus;
    tar.DataSelected.children[1].alpha = 1;
    UI.updateStage();

    if (undefined != fun) {
        fun();
    }
}

function fteDefaultSelect(tar) {
    try {
        for (var i = 0; i < tar.children.length; i++) {
            tar.children[i].children[1].alpha = 0;
        }
        tar.DataSelected.children[1].alpha = 1;
        UI.updateStage();
    }
    catch (ex) {
        DBG_ERROR("fteDefaultSelect: " + ex.message)
    }
}

function elementShow(target) {
    target.alpha = 1;
    if (!!target.scrollbar) {
        target.scrollbar.alpha = 1;
    }
}

function elementHide(target) {
    target.alpha = 0;
    if (!!target.scrollbar) {
        target.scrollbar.alpha = 0;
    }
}

/*function popSubModuleUntil(tar) {
    while (UI.getCurrSubModule().name != tar) {
        UI.popSubModule();
    }
}*/

function popSubModuleUntil(tar) {
    if(!UI.getSubModule(tar)) {
        DBG_ERROR("can not find the Submodule");
        return;
    }
    while(!!UI.getCurrModule() && UI.getCurrModule().children.length > 0 && UI.getCurrSubModule().name!= tar){
        UI.popSubModule();
    }
}

function getWizardStep() {
    if (!tv) {
        if (!!localStorage.getItem("wizardStep") && localStorage.getItem("wizardStep") < FTE.fteSequence.length) {
            return parseInt(localStorage.getItem("wizardStep"));
        }
        else {
            localStorage.setItem("wizardStep", 1);
            return 1;
        }
    }
    else {
        try {
            var wizardstep = model.system.getWizardStep();
            DBG_ERROR("wizardstep is " + wizardstep);
            return wizardstep;
        }
        catch (ex) {
            DBG_ERROR("getWizardStep: " + ex.message);
            return 0;
        }
    }
}
function setWizardStep(flag) {
    DBG_INFO("setWizardStep: " + flag);
    if (!tv) {
        localStorage.setItem("wizardStep", flag);
    }
    else {
        model.system.setWizardStep(flag);
        DBG_ERROR("model.system.setWizardStep IS " + flag);
    }
}

