/**
 * VideoModelDefines  class.
 * Contains all defined constants from  for
 * internal use.
 */

function VideoModelDefines() {
}
{
    // --------------------------------------------------------------
    // Static constants
    // -------------------------------------------------------------- 
    VideoModelDefines.SL2_TVAPI_VINT32_VIDEO_ENUM_PICTURE_MODE_LIST = "tvapi.vint32.video.enum.picture.mode.list";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_PICTURE_MODE = "tvapi.i32.video.enum.picture.mode";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_BRIGHTNESS = "tvapi.i32.video.brightness";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_CONTRAST = "tvapi.i32.video.contrast";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_COLOUR_INTENSITY = "tvapi.i32.video.colour.intensity";
    VideoModelDefines.SL2_TVAPI_VINT32_VIDEO_ZOOM_LIST = "tvapi.vint32.video.zoom_list";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_ZOOM = "tvapi.i32.video.enum.zoom";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_DYNAMIC_BACKLIGHT = "tvapi.i32.video.dynamic.backlight";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_BACKLIGHT = "tvapi.i32.video.backlight";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ECO_SENSOR = "tvapi.i32.video.eco.sensor";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_MINIMUM_BACKLIGHT = "tvapi.i32.video.minimum.backlight";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_DISPLAY = "tvapi.i32.video.display";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_DISPLAY_EXIST = "tvapi.i32.video.display.exist";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_PHASE = "tvapi.i32.video.phase";
    VideoModelDefines.SL2_TVAPI_ACTION_VIDEO_RESTORE_COMPONENT_SETTINGS = "tvapi.action.video.reset.component.settings";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_VGA_AUTO_ADJUST = "tvapi.i32.video.vga.auto.adjust";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_H_POSITION = "tvapi.i32.video.h.postion";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_V_POSITION = "tvapi.i32.video.v.postion";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_VGA_CLOCK = "tvapi.i32.video.vga.clock";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_OVERSCAN = "tvapi.i32.video.overscan";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_TINT = "tvapi.i32.video.tint";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_SHARPNESS = "tvapi.i32.video.sharpness";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_SKIN_TONE = "tvapi.i32.video.skintone";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_SMOOTH_MOTION = "tvapi.i32.video.enum.smooth.motion";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_SMOOTH_MOTION_SUPPORT= "tvapi.i32.video.enum.smooth.motion.support";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_NOISE_REDUCTION = "tvapi.i32.video.enum.noise.reduction";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_LOCAL_DIMMING = "tvapi.i32.video.enum.local.dimming";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_LOCAL_DIMMING_EXIST = "tvapi.i32.video.local.dimming.exist";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ADAPTIVE_CONTRAST = "tvapi.i32.video.adaptive.contrast";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_COLOUR_TEMPERATURE = "tvapi.i32.video.enum.colour.temperature";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_WHITE_BALANCE = "tvapi.i32.video.white.balance";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_RGAIN = "tvapi.i32.video.rgain";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_GGAIN = "tvapi.i32.video.ggain";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_BGAIN = "tvapi.i32.video.bgain";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ROFFSET = "tvapi.i32.video.roffset";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_GOFFSET = "tvapi.i32.video.goffset";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_BOFFSET = "tvapi.i32.video.boffset";
    VideoModelDefines.SL2_TVAPI_ACTION_VIDEO_RESTORE_WHITE_BALANCE_SETTINGS = "tvapi.action.video.reset.white.balance.settings";
    VideoModelDefines.SL2_TVAPI_ACTION_VIDEO_RESTORE_WHITE_BALANCE_POINT10_SETTINGS = "tvapi.action.video.reset.white.balance.point10.settings";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_WHITE_BALANCE_10_POINT = "tvapi.i32.video.white_balance.10.point";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_LEVER = "tvapi.i32.video.level";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_RED = "tvapi.i32.video.red";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_GREEN = "tvapi.i32.video.green";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_BLUE = "tvapi.i32.video.blue";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_COLOR = "tvapi.i32.video.color";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_COLOR_HUE = "tvapi.i32.video.color.hue";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_COLOR_SATURATION = "tvapi.i32.video.color.saturation";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_COLOR_BRIGHTNESS = "tvapi.i32.video.color.brightness";
    VideoModelDefines.SL2_TVAPI_ACTION_VIDEO_RESTORE_COLOR_TUNER_SETTINGS = "tvapi.action.video.reset.color.tuner.settings";
    VideoModelDefines.SL2_TVAPI_ACTION_VIDEO_RESTORE_DEFAULT_PICTURE_SETTINGS = "tvapi.action.video.reset.default.picture.settings";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_SUPPORTED = "tvapi.i32.video.3d.supported";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_2DTO3D_EXIST = "tvapi.i32.video.3d.2dto3d.exist";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_2DTO3D = "tvapi.i32.video.3d.2dto3d";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_3DTO2D_EXIST = "tvapi.i32.video.3d.3dto2d.exist";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_3DTO2D = "tvapi.i32.video.3d.3dto2d";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_EXIST = "tvapi.i32.video.3d.exist";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_MODE_EXIST = "tvapi.i32.video.3d.mode.exist";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_3D_MODE = "tvapi.i32.video.enum.3d.mode";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_DEPTH = "tvapi.i32.video.3d.depth";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_VIEW_POINT = "tvapi.i32.video.3d.view.point";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_LRSWITCH = "tvapi.i32.video.3d.lrswitch";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_DEPTH_EXIST = "tvapi.i32.video.3d.depth.exist";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_VIEW_POINT_EXIST = "tvapi.i32.video.3d.view.point.exist";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_LRSWITCH_EXIST = "tvapi.i32.video.3d.lrswitch.exist";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_GLASS_HINT = "tvapi.i32.video.3d.glass.hint";

    VideoModelDefines.SL2_TVAPI_I32_VIDEO_HDMI_ZOOM = "tvapi.i32.video.hdmi.zoom";
    VideoModelDefines.SL2_TVAPI_VINT32_VIDEO_SIGNAL_INFO = "tvapi.vint32.video.signal.info";

    VideoModelDefines.SL2_TVAPI_VINT32_VIDEO_WINDOW0 = "tvapi.vint32.video.window0";

    VideoModelDefines.SL2_TVAPI_I32_VIDEO_LOCAL_DIMMING_ADVANCED_SUPPORT= "tvapi.i32.video.local.dimming.advanced.support";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_APPLY_MODE= "tvapi.i32.video.apply.mode";
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_COLOR_GAMUT= "tvapi.i32.video.color.gamut";
	VideoModelDefines.SL2_TVAPI_I32_VIDEO_COLOR_GAMUT_SUPPORT= "tvapi.i32.video.color.gamut.support";


    // enum or defined is here


    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_PICTURE_VIVID = 0;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_PICTURE_STANDARD = 1;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_PICTURE_THEATER = 2;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_PICTURE_ENERGY_SAVING = 3;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_PICTURE_GAME = 4;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_PICTURE_SPORT = 5;


    VideoModelDefines.SL2_TVAPI_VIDEO_BRIGHTNESS_MIN = 0;
    VideoModelDefines.SL2_TVAPI_VIDEO_BRIGHTNESS_MAX = 100;
    VideoModelDefines.SL2_TVAPI_VIDEO_BRIGHTNESS_DEFAULT = 50;


    VideoModelDefines.SL2_TVAPI_VIDEO_CONTRAST_MIN = 0;
    VideoModelDefines.SL2_TVAPI_VIDEO_CONTRAST_MAX = 100;
    VideoModelDefines.SL2_TVAPI_VIDEO_CONTRAST_DEFAULT = 50;


    VideoModelDefines.SL2_TVAPI_VIDEO_COLOUR_INTENSITY_MIN = 0;
    VideoModelDefines.SL2_TVAPI_VIDEO_COLOUR_INTENSITY_MAX = 100;


    VideoModelDefines.SL2_TVAPI_VIDEO_ZOOM_NORMAL = 0;
    VideoModelDefines.SL2_TVAPI_VIDEO_ZOOM_ZOOM = 1;
    VideoModelDefines.SL2_TVAPI_VIDEO_ZOOM_WIDE = 2;
    VideoModelDefines.SL2_TVAPI_VIDEO_ZOOM_CINEMA = 3;
    VideoModelDefines.SL2_TVAPI_VIDEO_ZOOM_PIXEL_MAP = 4;
    VideoModelDefines.SL2_TVAPI_VIDEO_ZOOM_PANORAMIC = 5;
    VideoModelDefines.SL2_TVAPI_VIDEO_ZOOM_DIRECT = 6;
    VideoModelDefines.SL2_TVAPI_VIDEO_ZOOM_AUTO = 7;
    VideoModelDefines.SL2_TVAPI_VIDEO_ZOOM_MAX = 8;


    VideoModelDefines.SL2_TVAPI_I32_VIDEO_DYNAMIC_BACKLIGHT_OFF = 0;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_DYNAMIC_BACKLIGHT_LOW = 1;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_DYNAMIC_BACKLIGHT_HIGT = 2;


    VideoModelDefines.SL2_TVAPI_VIDEO_BACKLIGHT_MIN = 0;
    VideoModelDefines.SL2_TVAPI_VIDEO_BACKLIGHT_MAX = 100;
    VideoModelDefines.SL2_TVAPI_VIDEO_BACKLIGHT_DEFAULT = 50;


    VideoModelDefines.SL2_TVAPI_VIDEO_MINIMUM_BACKLIGHT_MIN = 0;
    VideoModelDefines.SL2_TVAPI_VIDEO_MINIMUM_BACKLIGHT_MAX = 100;


    VideoModelDefines.SL2_TVAPI_I32_VIDEO_DISPLAY_COMPONENT = 0;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_DISPLAY_VGA = 1;


    VideoModelDefines.SL2_TVAPI_VIDEO_PHASE_MIN = 0;
    VideoModelDefines.SL2_TVAPI_VIDEO_PHASE_MAX = 100;


    VideoModelDefines.SL2_TVAPI_I32_VIDEO_VGA_AUTO_ADJUST_OFF = 0;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_VGA_AUTO_ADJUST_ON = 1;


    VideoModelDefines.SL2_TVAPI_VIDEO_H_POSITION_MIN = 0;
    VideoModelDefines.SL2_TVAPI_VIDEO_H_POSITION_MAX = 100;


    VideoModelDefines.SL2_TVAPI_VIDEO_V_POSITION_MIN = 0;
    VideoModelDefines.SL2_TVAPI_VIDEO_V_POSITION_MAX = 100;


    VideoModelDefines.SL2_TVAPI_VIDEO_VGA_CLOCK_MIN = 0;
    VideoModelDefines.SL2_TVAPI_VIDEO_VGA_CLOCK_MAX = 100;


    VideoModelDefines.SL2_TVAPI_I32_VIDEO_OVERSCAN_OFF = 0;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_OVERSCAN_ON = 1;
    VideoModelDefines.SL2_TVAPI_VIDEO_TINT_MIN = -50;
    VideoModelDefines.SL2_TVAPI_VIDEO_TINT_MAX = 50;


    VideoModelDefines.SL2_TVAPI_VIDEO_SHARPNESS_MIN = 0;
    VideoModelDefines.SL2_TVAPI_VIDEO_SHARPNESS_MAX = 20;


    VideoModelDefines.SL2_TVAPI_I32_VIDEO_SKIN_TONE_OFF = 0;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_SKIN_TONE_LOW = 1;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_SKIN_TONE_MEDIUM = 2;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_SKIN_TONE_HIGH = 3;


    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_SMOOTH_MOTION_OFF = 0;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_SMOOTH_MOTION_LOW = 1;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_SMOOTH_MOTION_MEDIUM = 2;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_SMOOTH_MOTION_HIGHT = 3;


    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_NOISE_REDUCTION_OFF = 0;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_NOISE_REDUCTION_LOW = 1;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_NOISE_REDUCTION_MEDIUM = 2;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_NOISE_REDUCTION_HIGHT = 3;


    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_LOCAL_DIMMING_OFF = 0;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_LOCAL_DIMMING_LOW = 1;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_LOCAL_DIMMING_MEDIUM = 2;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_LOCAL_DIMMING_HIGHT = 3;


    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ADAPTIVE_CONTRAST_OFF = 0;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ADAPTIVE_CONTRAST_LOW = 1;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ADAPTIVE_CONTRAST_MEDIUM = 2;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ADAPTIVE_CONTRAST_HIGH = 3;


    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_COLOUR_TEMP_NORMAL = 0;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_COLOUR_TEMP_WARM = 1;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_COLOUR_TEMP_COOL = 2;


    VideoModelDefines.SL2_TVAPI_I32_VIDEO_WHITE_BALANCE_VALUE_2_POINT = 0;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_WHITE_BALANCE_VALUE_10_POINT = 1;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_RGB_2_POINTMIN = -25;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_RGB_2_POINTMAX = 25;


    VideoModelDefines.SL2_TVAPI_I32_VIDEO_RGB_2_POINTDEFAULT = 0;


    VideoModelDefines.SL2_TVAPI_I32_VIDEO_LEVER_10 = 0;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_LEVER_20 = 1;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_LEVER_30 = 2;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_LEVER_40 = 3;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_LEVER_50 = 4;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_RGB_2_POINT_MIN = -10;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_RGB_2_POINT_MAX = 10;


    VideoModelDefines.SL2_TVAPI_I32_VIDEO_RGB_2_POINT_DEFAULT = 0;


    VideoModelDefines.SL2_TVAPI_I32_VIDEO_COLOR_RED = 0;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_COLOR_GREEN = 1;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_COLOR_BLUE = 2;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_COLOR_YELLOW = 3;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_COLOR_cyan = 4;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_COLOR_MAGENTA = 5;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_COLOR_FLESH = 6;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_COLOR_TONE = 7;


    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_3D_MODE_OFF = 0;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_3D_MODE_AUTO = 1;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_3D_MODE_SIDE_BY_SIDE = 2;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_3D_MODE_TOP_BOTTOM = 3;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_3D_MODE_GAMES = 4;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_3D_MODE_LINE_BY_LINE = 5;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_3D_MODE_2D_TO_3D = 6;


    VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_DEPTH_MIN = 0;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_DEPTH_MAX = 10;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_DEPTH_DEFAULT = 4;


    VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_VIEW_POINT_MIN = 0;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_VIEW_POINT_MAX = 10;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_VIEW_POINT_DEFAULT = 8;


    VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_LRSWITCH_OFF = 0;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_LRSWITCH_ON = 1;


    VideoModelDefines.SL2_TVAPI_I32_VIDEO_HDMI_ZOOM_ENLARGE = 0;
    VideoModelDefines.SL2_TVAPI_I32_VIDEO_HDMI_ZOOM_FULLSCREEN = 1;
}
/**
 * VideoModel class derived from SubModel.
 */
function VideoModel(parentModel) {
    SubModel.call(this, parentModel, VideoModelDefines);

    // --------------------------------------------------------------
    // Objects
    // --------------------------------------------------------------

    this.registerIntegerVectorObject(
        VideoModelDefines.SL2_TVAPI_VINT32_VIDEO_WINDOW0,
        "getWindow0", "setWindow0", "onWindow0Chaged",
        null, null);

    // EnumPictureModeList
    this.registerIntegerVectorObject(
        VideoModelDefines.SL2_TVAPI_VINT32_VIDEO_ENUM_PICTURE_MODE_LIST,
        "getEnumPictureModeList", "setEnumPictureModeList", "onEnumPictureModeListChaged",
        null, null);

    // EnumPictureMode
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_PICTURE_MODE,
        "getEnumPictureMode", "setEnumPictureMode", "onEnumPictureModeChaged",
        null, null);

    // Brightness
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_BRIGHTNESS,
        "getBrightness", "setBrightness", "onBrightnessChaged",
        null, null);

    // Contrast
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_CONTRAST,
        "getContrast", "setContrast", "onContrastChaged",
        null, null);

    // ColourIntensity
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_COLOUR_INTENSITY,
        "getColourIntensity", "setColourIntensity", "onColourIntensityChaged",
        null, null);

    // Zoom_list
    this.registerIntegerVectorObject(
        VideoModelDefines.SL2_TVAPI_VINT32_VIDEO_ZOOM_LIST,
        "getZoom_list", "setZoom_list", "onZoom_listChaged",
        null, null);

    // EnumZoom
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_ZOOM,
        "getEnumZoom", "setEnumZoom", "onEnumZoomChaged",
        null, null);

    // DynamicBacklight
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_DYNAMIC_BACKLIGHT,
        "getDynamicBacklight", "setDynamicBacklight", "onDynamicBacklightChaged",
        null, null);

    // Backlight
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_BACKLIGHT,
        "getBacklight", "setBacklight", "onBacklightChaged",
        null, null);

    // EcoSensor
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_ECO_SENSOR,
        "getEcoSensor", "setEcoSensor", "onEcoSensorChaged",
        null, null);

    // MinimumBacklight
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_MINIMUM_BACKLIGHT,
        "getMinimumBacklight", "setMinimumBacklight", "onMinimumBacklightChaged",
        null, null);

    // Display
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_DISPLAY,
        "getDisplay", "setDisplay", "onDisplayChaged",
        null, null);

    // DisplayExist
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_DISPLAY_EXIST,
        "getDisplayExist", "setDisplayExist", "onDisplayExistChaged",
        null, null);

    // Phase
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_PHASE,
        "getPhase", "setPhase", "onPhaseChaged",
        null, null);

// Need to fix
//	VideoModelDefines.SL2_TVAPI_ACTION_VIDEO_RESTORE_COMPONENT_SETTINGS=  "tvapi.action.video.reset.component.settings "

    // ResetComponentSettings
    this.registerActionObject(
        VideoModelDefines.SL2_TVAPI_ACTION_VIDEO_RESTORE_COMPONENT_SETTINGS,
        [
            {name: "ResetComponentSettings", method: function (object) {
                return object.invoke();
            }}
        ], "OnResetComponent"
    );

    // VgaAutoAdjust
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_VGA_AUTO_ADJUST,
        "getVgaAutoAdjust", "setVgaAutoAdjust", "onVgaAutoAdjustChaged",
        null, null);

    // HPostion
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_H_POSITION,
        "getHPostion", "setHPostion", "onHPostionChaged",
        null, null);

    // VPostion
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_V_POSITION,
        "getVPostion", "setVPostion", "onVPostionChaged",
        null, null);

    // VgaClock
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_VGA_CLOCK,
        "getVgaClock", "setVgaClock", "onVgaClockChaged",
        null, null);

    // Overscan
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_OVERSCAN,
        "getOverscan", "setOverscan", "onOverscanChaged",
        null, null);

    // Tint
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_TINT,
        "getTint", "setTint", "onTintChaged",
        null, null);

    // Sharpness
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_SHARPNESS,
        "getSharpness", "setSharpness", "onSharpnessChaged",
        null, null);

    // Skintone
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_SKIN_TONE,
        "getSkintone", "setSkintone", "onSkintoneChaged",
        null, null);

    // EnumSmoothMotion
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_SMOOTH_MOTION,
        "getEnumSmoothMotion", "setEnumSmoothMotion", "onEnumSmoothMotionChaged",
        null, null);

    // EnumSmoothMotionSupport
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_SMOOTH_MOTION_SUPPORT,
        "getEnumSmoothMotionSupport", "setEnumSmoothMotionSupport", "onEnumSmoothMotionSupportChaged",
        null, null);

    // EnumNoiseReduction
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_NOISE_REDUCTION,
        "getEnumNoiseReduction", "setEnumNoiseReduction", "onEnumNoiseReductionChaged",
        null, null);

    // EnumLocalDimming
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_LOCAL_DIMMING,
        "getEnumLocalDimming", "setEnumLocalDimming", "onEnumLocalDimmingChaged",
        null, null);

    // LocalDimmingExist
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_LOCAL_DIMMING_EXIST,
        "getLocalDimmingExist", "setLocalDimmingExist", "onLocalDimmingExistChaged",
        null, null);

    // AdaptiveContrast
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_ADAPTIVE_CONTRAST,
        "getAdaptiveContrast", "setAdaptiveContrast", "onAdaptiveContrastChaged",
        null, null);

    // EnumColourTemperature
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_COLOUR_TEMPERATURE,
        "getEnumColourTemperature", "setEnumColourTemperature", "onEnumColourTemperatureChaged",
        null, null);

    // WhiteBalance
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_WHITE_BALANCE,
        "getWhiteBalance", "setWhiteBalance", "onWhiteBalanceChaged",
        null, null);

    // Rgain
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_RGAIN,
        "getRgain", "setRgain", "onRgainChaged",
        null, null);

    // Ggain
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_GGAIN,
        "getGgain", "setGgain", "onGgainChaged",
        null, null);

    // Bgain
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_BGAIN,
        "getBgain", "setBgain", "onBgainChaged",
        null, null);

    // Roffset
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_ROFFSET,
        "getRoffset", "setRoffset", "onRoffsetChaged",
        null, null);

    // Goffset
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_GOFFSET,
        "getGoffset", "setGoffset", "onGoffsetChaged",
        null, null);

    // Boffset
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_BOFFSET,
        "getBoffset", "setBoffset", "onBoffsetChaged",
        null, null);

// Need to fix
//	VideoModelDefines.SL2_TVAPI_ACTION_VIDEO_RESTORE_WHITE_BALANCE_SETTINGS=  "tvapi.action.video.reset.white.balance.settings "

    // ResetWhiteBalanceSettings
    this.registerActionObject(
        VideoModelDefines.SL2_TVAPI_ACTION_VIDEO_RESTORE_WHITE_BALANCE_SETTINGS,
        [
            {name: "ResetWhiteBalanceSettings", method: function (object) {
                return object.invoke();
            }}
        ], "OnResetWhite2Point"
    );
//	VideoModelDefines.SL2_TVAPI_ACTION_VIDEO_RESTORE_WHITE_BALANCE_POINT10_SETTINGS=  "tvapi.action.video.reset.white.balance.point10.settings "

    // Reset10PointWhiteBalanceSettings
    this.registerActionObject(
        VideoModelDefines.SL2_TVAPI_ACTION_VIDEO_RESTORE_WHITE_BALANCE_POINT10_SETTINGS,
        [
            {name: "Reset10PointWhiteBalanceSettings", method: function (object) {
                return object.invoke();
            }}
        ], "OnResetWhite10Point"
    );
    // White_balance10Point
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_WHITE_BALANCE_10_POINT,
        "getWhite_balance10Point", "setWhite_balance10Point", "onWhite_balance10PointChaged",
        null, null);

    // Level
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_LEVER,
        "getLevel", "setLevel", "onLevelChaged",
        null, null);

    // Red
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_RED,
        "getRed", "setRed", "onRedChaged",
        null, null);

    // Green
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_GREEN,
        "getGreen", "setGreen", "onGreenChaged",
        null, null);

    // Blue
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_BLUE,
        "getBlue", "setBlue", "onBlueChaged",
        null, null);

    // Color
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_COLOR,
        "getColor", "setColor", "onColorChaged",
        null, null);

    // ColorHue
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_COLOR_HUE,
        "getColorHue", "setColorHue", "onColorHueChaged",
        null, null);

    // ColorSaturation
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_COLOR_SATURATION,
        "getColorSaturation", "setColorSaturation", "onColorSaturationChaged",
        null, null);

    // ColorBrightness
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_COLOR_BRIGHTNESS,
        "getColorBrightness", "setColorBrightness", "onColorBrightnessChaged",
        null, null);

// Need to fix
//	VideoModelDefines.SL2_TVAPI_ACTION_VIDEO_RESTORE_COLOR_TUNER_SETTINGS=  "tvapi.action.video.reset.color.tuner.settings "

    // ResetColorTunerSettings
    this.registerActionObject(
        VideoModelDefines.SL2_TVAPI_ACTION_VIDEO_RESTORE_COLOR_TUNER_SETTINGS,
        [
            {name: "ResetColorTunerSettings", method: function (object) {
                return object.invoke();
            }}
        ], "OnResetColorTuner"
    );

// Need to fix
//	VideoModelDefines.SL2_TVAPI_ACTION_VIDEO_RESTORE_DEFAULT_PICTURE_SETTINGS=  "tvapi.action.video.reset.default.picture.settings "

    // ResetDefaultPictureSettings
    this.registerActionObject(
        VideoModelDefines.SL2_TVAPI_ACTION_VIDEO_RESTORE_DEFAULT_PICTURE_SETTINGS,
        [
            {name: "ResetDefaultPictureSettings", method: function (object, configflag) {
                return object.invoke(configflag);
            }}
        ], "onResetAction"
    );

    // 3dSupported
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_SUPPORTED,
        "get3dSupported", "set3dSupported", "on3dSupportedChaged",
        null, null);

    // 3d2dto3dExist
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_2DTO3D_EXIST,
        "get3d2dto3dExist", "set3d2dto3dExist", "on3d2dto3dExistChaged",
        null, null);

    // 3d2dto3d
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_2DTO3D,
        "get3d2dto3d", "set3d2dto3d", "on3d2dto3dChaged",
        null, null);

    // 3d3dto2dExist
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_3DTO2D_EXIST,
        "get3d3dto2dExist", "set3d3dto2dExist", "on3d3dto2dExistChaged",
        null, null);

    // 3d3dto2d
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_3DTO2D,
        "get3d3dto2d", "set3d3dto2d", "on3d3dto2dChaged",
        null, null);

    // 3dExist
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_EXIST,
        "get3dExist", "set3dExist", "on3dExistChaged",
        null, null);

    // 3dModeExist
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_MODE_EXIST,
        "get3dModeExist", "set3dModeExist", "on3dModeExistChaged",
        null, null);

    // Enum3dMode
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_ENUM_3D_MODE,
        "getEnum3dMode", "setEnum3dMode", "onEnum3dModeChaged",
        null, null);

    // 3dDepth
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_DEPTH,
        "get3dDepth", "set3dDepth", "on3dDepthChaged",
        null, null);

    // 3dViewPoint
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_VIEW_POINT,
        "get3dViewPoint", "set3dViewPoint", "on3dViewPointChaged",
        null, null);

    // 3dLrswitch
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_LRSWITCH,
        "get3dLrswitch", "set3dLrswitch", "on3dLrswitchChaged",
        null, null);

    // 3dDepthExist
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_DEPTH_EXIST,
        "get3dDepthExist", "set3dDepthExist", "on3dDepthExistChaged",
        null, null);

    // 3dViewPointExist
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_VIEW_POINT_EXIST,
        "get3dViewPointExist", "set3dViewPointExist", "on3dViewPointExistChaged",
        null, null);

    // 3dLrswitchExist
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_LRSWITCH_EXIST,
        "get3dLrswitchExist", "set3dLrswitchExist", "on3dLrswitchExistChaged",
        null, null);

    // 3dGlassHint
      this.registerIntegerObject(
      VideoModelDefines.SL2_TVAPI_I32_VIDEO_3D_GLASS_HINT,
      "get3dGlassHint", "set3dGlassHint", "on3dGlassHintChaged",
      null, null );

    // HdmiZoom
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_HDMI_ZOOM,
        "getHdmiZoom", "setHdmiZoom", "onHdmiZoomChaged",
        null, null);

    // SignalInfo
    this.registerIntegerVectorObject(
        VideoModelDefines.SL2_TVAPI_VINT32_VIDEO_SIGNAL_INFO,
        "getSignalInfo", "setSignalInfo", "onSignalInfoChaged",
        null, null);
    //LocalDimmingAdvancedSupport
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_LOCAL_DIMMING_ADVANCED_SUPPORT,
        "getLocalDimmingAdvancedSupport", "setLocalDimmingAdvancedSupport", "onLocalDimmingAdvancedSupportChaged",
        null, null);

    //ApplyMode
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_APPLY_MODE,
        "getApplyMode", "setApplyMode", "onApplyModeChaged",
        null, null);
    //ColorGamut

    // ColorGamutSupport
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_COLOR_GAMUT,
        "getColorGamut", "setColorGamut", "onColorGamutChaged",
        null, null);

   // ColorGamutSupport
    this.registerIntegerObject(
        VideoModelDefines.SL2_TVAPI_I32_VIDEO_COLOR_GAMUT_SUPPORT,
        "getColorGamutSupport", "setColorGamutSupport", "onColorGamutSupportChaged",
        null, null);
}
VideoModel.prototype = new SubModel();
VideoModel.prototype.constructor = VideoModel;
{
    // --------------------------------------------------------------
    // Static constants
    // --------------------------------------------------------------    
    SubModel.registerStaticConstants(
        VideoModel, VideoModelDefines,
        [
        ]);
}
