UI.moduleBuilder['Alexa']['register_bg'] = function() {
    var backgroundData = {
        tempImg1: "Alexa/register/bg.png"
    };
    var template = Util.readJson("module/Alexa/register_bg.json");
    var register_bg = SubModule.create(backgroundData, template);

    var tempImg1 = UI.getItem(register_bg, "tempImg1");
    var navbarTiles = UI.getItem(register_bg, "navbarTiles");


    register_bg.navbarContent = [];
    function rewriteNavbar() {
        navbarTiles.removeAllChildren();
        var navbar = [];
        for (var i = 0; i < register_bg.navbarContent.length; i++) {
            navbar.push({});
            navbar[i].navName = register_bg.navbarContent[i];
            navbar[i].name = "register" + i;
        }
        var navinfo = {
            template: "fte_background_item",
            direction: CONST.GIRD_DIRECTION.v,
            breakNum: 1,
            distanceX: 48,
            distanceY: 0,
            container: navbarTiles,
            x: 0,
            y: 0
        };
        Gird.create(navbar, navinfo);
    }
    rewriteNavbar();
    for (var i=0; i < navbarTiles.children.length; i++) {
        navbarTiles.children[i].children[0].alpha = 0.3;
    }
    UI.updateStage();
    register_bg.currFocus = navbarTiles;

    var hisense_login_status = null;
    var amazon_login_status = null;
    register_bg.onPush = function(){
        if(tv){
            hisense_login_status = (AVSClient.register.getRegisterStatus("hisense") == 1);
            amazon_login_status = AVSClient.register.getRegisterStatus("amazon");
            DBG_ERROR( "hisense_login_status is " + hisense_login_status + "amazon_login_status is " + amazon_login_status);
            initPage();
        }else{
            initPage();
        }
    };
    var initPage = function () {
        try{
            var currStep = getStep();
            DBG_ERROR("avs " + avs_support + "avg "+ avg_support + "getBTRCSupport is " + AVSClient.model.getBTRCSupport() + "currStep " + currStep);
            if(avs_support && avg_support){
                if(pco_support){
                    register_bg.sequence = ["register_chooseDevice", "register_hisense", "register_rename", "register_amazon", "register_setup_pco","register_language","register_demo"];
                }else{
                    register_bg.sequence = ["register_chooseDevice", "register_hisense", "register_rename", "register_amazon", "register_setup","register_language","register_demo"];
                }
                if(remoteAppFlag){
                    register_bg.navbarContent = [" ","1", "2", "3", "4", "5","6"];
                }else{
                    register_bg.navbarContent = ["1", "2", "3", "4", "5","6","7"];
                }
                register_bg.title = ["chooseDevice", "hisense", "rename", "amazon", "setup","demo"];
            }else if(!avs_support && avg_support){
                register_bg.sequence = ["register_chooseDevice", "register_hisense", "register_rename", "register_setup","register_demo"];
                register_bg.navbarContent = [" ","1", "2", "3", "4"];
                register_bg.title = ["chooseDevice", "hisense", "rename", "setup","demo"];
            }else{
                DBG_ERROR("no such requirement");
            }
            Alexa.currStep = getAlexaStep(hisense_login_status, amazon_login_status, currStep);
            DBG_ERROR("register_bg.sequence is " + register_bg.sequence + "  Alexa.currStep is " + Alexa.currStep);
            register_bg.alpha = 1;
            rewriteNavbar();
            navbarTiles.x = 1920 / 2 - 180;
            if(Alexa.currStep){
                startRegisterFromStep(Alexa.currStep);
            }else{
                startRegisterFromStep(0);
            }
            UI.updateStage();
        }catch(ex){
            DBG_ERROR(ex.message);
        }

    };

    function getAlexaStep(hiStatus, amaStatus, preStep){
        var avsRegister = tv ? Hisense.File.exists("hisenseUI/avsRegister", 1) :false;
        DBG_ERROR("avs_support  is " + avs_support + "avsRegister is " + avsRegister + " AVSClient.model.getBTRCSupport() is "+ AVSClient.model.getBTRCSupport() + " preStep " + preStep );
        try{
            if(avs_support && avg_support){
                if(!hiStatus){
                    if(preStep == 0){
                        return 0;
                    }else{
                        return 1;
                    }
                }else if(!amaStatus){
                    if(avsRegister){
                        return 3;
                    }else{
                        return Math.min(3,preStep);
                    }
                }else{
                    return preStep;
                }
            }else if(!avs_support && avg_support){
                if(!hiStatus){
                    if(preStep == 0){
                        return 0;
                    }else{
                        return 1;
                    }
                }else{
                    return preStep;
                }
            }else{
                DBG_ERROR("not support");
            }
        }catch(ex){
            DBG_ERROR("getAlexaStep error ");
            return 0;
        }
    }


    register_bg.afterShow = function(){

    }

    register_bg.onFocus = function () {
    };

    register_bg.onNormal = function () {
    };

    register_bg.onPop = function(){

    }
    function startRegisterFromStep(step){
        try{
            registerSetStep(step);
            UI.pushSubModule("Alexa", register_bg.sequence[step], true);
            DBG_ERROR("register current step is " + register_bg.sequence[step]);
        }catch(ex){
            DBG_ERROR(ex.message);
        }
    }
}



function registerSetStep(step) {
    try{
        var register_bg = UI.getSubModule("register_bg");
        var navbarTiles = UI.getItem(register_bg, "navbarTiles");
        Alexa.currStep = step;
        for (var i = 0; i < navbarTiles.children.length; i++) {
            navbarTiles.children[i].children[0].alpha = 0.3;
        }
        navbarTiles.children[Alexa.currStep].children[0].alpha = 1;
    }catch(ex){
        DBG_ERROR(ex.message);
    }

}

function getStep() {
    if (!tv) {
        if (!!localStorage.getItem("registerStep")) {
            return parseInt(localStorage.getItem("registerStep"));
        }
        else {
            localStorage.setItem("registerStep", 0);
            return 0;
        }
    }
    else {
        try {
            var registerStep = AVSClient.register.getLoginStep();
            return registerStep;
        }
        catch (ex) {
            DBG_ERROR("getWizardStep error: " + ex.message);
            return 0;
        }
    }
}
function setStep(flag) {
    DBG_ERROR("setStep: " + flag);
    if (!tv) {
        localStorage.setItem("registerStep", flag);
    }else{
        AVSClient.register.setLoginStep(flag);
    }
}

function registerUpdate(dir) {
    var register_bg = UI.getSubModule("register_bg");
    var navbarTiles = UI.getItem(register_bg, "navbarTiles");
    var Index = Alexa.currStep;
    if(!!dir) {
        if (Index == register_bg.sequence.length - 1) {
            return;
        }
        navbarTiles.children[Index].children[0].alpha = 0.3;
        Index = Index < register_bg.sequence.length - 1? Index + 1: register_bg.sequence.length - 1;
        Alexa.currStep = Index;
        UI.popSubModule();
        UI.pushSubModule("Alexa", register_bg.sequence[Index], true);
    }
    else {
        if (Index == 0) {
            return;
        }
        navbarTiles.children[Index].children[0].alpha = 0.3;
        Index = Index > 0? Index - 1: 0;
        Alexa.currStep = Index;
        UI.popSubModule();
        UI.pushSubModule("Alexa", register_bg.sequence[Index], true);
    }
    navbarTiles.children[Alexa.currStep].children[0].alpha = 1;
    setStep(Alexa.currStep);
    DBG_ERROR("dir is " + dir + "register_bg.currStep is " + Alexa.currStep) ;
    UI.updateStage();
}





