/**
 * Created by liutiantian on 2015/1/23.
 */

function Tools() {
    if(typeof Tools.initialized == "undefined") {
        Tools.MODE_LANGUAGE = 0;
        Tools.MODE_NUM1 = 1;
        Tools.MODE_NUM2 = 2;
        Tools.MODE_PASSWORD = 3;

        Tools.prototype.measureText = function(id, text, lineHeight, lineMax) {
            var element = document.getElementById(id);
            if(!!element) {
                element.innerHTML = text;
                var lineNum = Math.ceil(element.scrollHeight / lineHeight);
                while(lineNum - lineMax > 1) {
                    text = text.slice(0, Math.ceil(text.length * (lineMax + 1 + lineNum) / (2 * lineNum)));
                    element.innerHTML = text;
                    lineNum = Math.ceil(element.scrollHeight / lineHeight);
                }
                text = text.slice(0, -1);
                element.innerHTML = text + "\u2026";
                while(element.scrollHeight / lineHeight > lineMax) {
                    text = text.slice(0, -1);
                    element.innerHTML = text + "\u2026";
                }
            }
        };

        Tools.prototype.extendPrototype = function(Son, Father) {
            for(var key in Father.prototype) {
                if(!!Son.prototype[key]) {
                    continue;
                }
                Son.prototype[key] = Father.prototype[key];
            }
        };

        Tools.prototype.getSystemLan = function() {
            return "ENG";
        };

        Tools.prototype.findElementPathInHtmlById = function(html, id, root) {
            if(html.id == id) {
                return root;
            }
            var res = "";
            if(!!html.children) {
                for(var key in html.children) {
                    res = this.findElementPathInHtmlById(html.children[key], id, root + ".children[" + key + "]");
                    if(!!res) {
                        return res;
                    }
                }
            }
            return res;
        };

        Tools.prototype.findHtmlById = function(html, id) {
            if (html.id == id) {
                return html;
            }

            var res = null;
            if (!!html.children) {
                for (var key in html.children) {
                    res = this.findHtmlById(html.children[key], id);
                    if (!!res) {
                        return res;
                    }
                }
            }
            return res;
        };

        Tools.prototype.queryScreenFromUrl = function(key) {
            var space = {};

            var url = document.location.href;
            host.logger.i("tools", "Tools.queryScreenFromUrl", "show url: " + url);
            var keys = url.split("?")[1];
            if(!!keys && keys.length > 0){
                space.para = keys.split("&");

                if(!!space.para && space.para.length > 0) {
                    space.key = key.trim().toLowerCase();

                    for(var i = 0; i < space.para.length; i++) {
                        space.values = space.para[i].split("=");
                        if(!!space.values && space.values.length > 1 && space.values[0].toLowerCase().trim() == space.key) {
                            space.value = space.values[1];
                            break;
                        }
                    }

                    switch(space.value) {
                        case "1":
                            return "720P";
                        default:
                            return "1080P";
                    }
                }
            }
            return "1080P"
        };

        Tools.prototype.getLanguageList = function() {
            /*host.config.market = "EU";
            host.config.area = "MiddleEast";
            if(host.tv) {
                var space = {};
                var url = document.location.href;
                host.logger.i("tools", "Tools.getLanguageList", "show url: " + url);
                var keys = url.split("?")[1];
                if(!!keys && keys.length > 0){
                    space.para = keys.split("&");

                    if(!!space.para && space.para.length > 0) {
                        for(var i = 0; i < space.para.length; i++) {
                            space.values = space.para[i].split("=");
                            if(!!space.values && space.values.length > 1) {
                                if("market" == space.values[0].toLowerCase().trim()) {
                                    host.config.market = space.values[1].toUpperCase();
                                    if("US" == host.config.market.toUpperCase()) {
                                        host.config.market = "NA";
                                    }
                                }
                                else if("area" == space.values[0].toLowerCase().trim()) {
                                    switch(parseInt(space.values[1])) {
                                        case 0:
                                            host.config.area = "MiddleEast";
                                            break;
                                        case 1:
                                            host.config.area = "CIS";
                                            break;
                                        case 2:
                                            host.config.area = "Asian";
                                            break;
                                        default :
                                            host.config.area = "Africa";
                                            break;
                                    }
                                }
                            }
                        }
                    }
                }
            }*/

            host.logger.i("tools", "Tools.getLanguageList", "show market: " + host.config.market + "; area: " + host.config.area);
            var lanes = [];
            for(var j = 0; j < host.config.lans.length; ++j) {
                if("EM" == host.config.market && !!host.config.lans[j].area && host.config.lans[j].area.indexOf(host.config.area) + 1 > 0) {
                    lanes.push(host.config.lans[j]);
                    continue;
                }
                if(!!host.config.lans[j].market && host.config.lans[j].market.indexOf(host.config.market) + 1 > 0) {
                    lanes.push(host.config.lans[j]);
                }
            }
            if(lanes.length == 0) {
                if("EM" == host.config.market) {
                    if(!!host.config.lans[j].area && host.config.lans[j].area.indexOf("Africa") + 1 > 0) {
                        lanes.push(host.config.lans[j]);
                    }
                }
            }
            host.config.curLangArray = [];
            for(var k = 0; k < lanes.length; ++k) {
                host.config.curLangArray.push(lanes[k].code);
            }
            if(!this.isRunningOnTv()) {
                return host.config.lans;
            }
            return lanes;
        };

        Tools.prototype.assertBrowserCore = function() {
            var user_agent = navigator.userAgent.toLowerCase();
            if(user_agent.indexOf("presto") + 1 > 0) {
                return "presto";
            }
            else if(user_agent.indexOf("webkit") + 1 > 0) {
                return "webkit";
            }
            return "presto";
        };

        Tools.prototype.assertCssValid = function(classes, state) {
            if("presto" == host.browser) {
                return true;
            }
            if("webkit" == host.browser) {
                if(!!host.config.csses.webkit[classes]) {
                    if(!!host.config.csses.webkit[classes].exclude && host.config.csses.webkit[classes].exclude.indexOf(state) + 1 > 0) {
                        return false;
                    }
                    return true;
                }
                return false;
            }

            host.logger.i("tools", "Tools.assertCssValid", "browser core type not supported, show browser core: " + host.browser + "; and true returned as default.");
            return true;
        };

        Tools.prototype.assertLanguageRtl = function(language) {
            for(var i = 0; i < host.config.lans.length; ++i) {
                if(host.config.lans[i].code == language) {
                    return host.config.lans[i].rtl;
                }
            }
            return false;
        };

        Tools.prototype.assertLanguageShift = function(language) {
            for(var i = 0; i < host.config.lans.length; ++i) {
                if(host.config.lans[i].code == language) {
                    return host.config.lans[i].shift;
                }
            }
            return false;
        };

        Tools.prototype.classmaker = function(html) {
            if(!html.flags) {
                html.flags = iqqi_constances.c_default;
            }
            //host.logger.i("tools", "Tools.classmaker", " id: " + html.id + "; classes: " + html.classes + "; state: " + html.state + "; flags: " + html.flags);

            var inner = [html.classes];

            if(html.flags & iqqi_constances.c_shift_caps_care) {
                var suffix = this.decideShiftCaps();
                if(suffix) {
                    inner.push(suffix);
                }
            }

            rtl:
                if(host.tools.assertLanguageRtl(host.config.curLang)) {
                    if(html.state == "hidden" && (html.flags & iqqi_constances.c_rtl_exclude_hidden)) {
                        break rtl;
                    }
                    else if(html.state == "gone" && (html.flags & iqqi_constances.c_rtl_exclude_gone)) {
                        break rtl;
                    }
                    else if(!(html.flags & iqqi_constances.c_rtl)) {
                        break rtl;
                    }
                    inner.push("rtl");
                }

            if(host.config.curMode == Tools.MODE_PASSWORD && (html.flags & iqqi_constances.c_password)) {
                inner.push("password");
            }

            browser:
                if(html.state == "hidden" && (html.flags & iqqi_constances.c_browser_exclude_hidden)) {
                    break browser;
                }
                else if(html.state == "gone" && (html.flags & iqqi_constances.c_browser_exclude_gone)) {
                    break browser;
                }
                else if(host.browser == "presto" || !(html.flags & iqqi_constances.c_browser_webkit)) {
                    inner.push("presto");
                }
                else {
                    inner.push("webkit");
                }

            screen:
                if(html.state == "hidden" && (html.flags & iqqi_constances.c_screen_exclude_hidden)) {
                    break screen;
                }
                else if(html.state == "gone" && (html.flags & iqqi_constances.c_screen_exclude_gone)) {
                    //host.logger.i("tools", "Tools.classmaker", "screen.gone logic enter");
                    break screen;
                }
                else if(host.screen == "720P" || !(html.flags & iqqi_constances.c_screen_1080P)) {
                    inner.push("720P");
                }
                else {
                    //host.logger.i("tools", "Tools.classmaker", "screen.1080P logic enter");
                    inner.push("1080P");
                }

            inner.push(html.state);

            //host.logger.i("tools", "Tools.classmaker", "show id: " + html.id + "; classes last: " + inner.join("_"));

            return inner.join("_");
        };

        Tools.prototype.isRunningOnOpera = function() {
            return navigator.appName == "Opera";
        };

        Tools.prototype.isRunningOnTv = function() {
            return window["Hisense"] || window["opera_omi"];
        };
    }
    Tools.initialized = true;
}
