(function(){

    var templateData = {

    };

    var template = Util.readJson("module/testModule/dynamic.json");

    var dynamic = SubModule.create(templateData, template);

    var groupData = [
        {
            template : "0-1001",
            data : [
                {
                    img : "launcher/title/netflix.png",
                    txt : "netflix",
                    url : "netflix",
                    urlType : "37"
                },
                {
                    img : "launcher/title/amazon.png",
                    txt : "amazonruby",
                    url : "amazonruby",
                    urlType : "37"
                },
                {
                    img : "launcher/title/youtube.png",
                    txt : "youtube",
                    url : "youtube",
                    urlType : "37"
                },
                {
                    img : "launcher/title/vudu.png",
                    txt : "vudu",
                    url : "vudu",
                    urlType : "37"
                }
            ]
        }
    ];

    var groups = [];

    var groupAnchor = UI.getItem(dynamic, "groupAnchor");

    var currX = 0;

    for (var i = 0; i < groupData.length; i++) {

        var group = Group.create(groupData[i].template, groupData[i].data);

        //for (var j = 0; j < group.children.length; j++) {
        //    UI.setImage(group.children[j], groupData[i].data[j].img);
        //    group.children[j].url = groupData[i].data[j].url
        //}

        groups.push(group);

        group.x = currX;

        currX += group.getBounds().width + 50;

        groupAnchor.addChild(group);

        if (groups[i - 1]) {

            groups[i].leftTo = groups[i - 1].children[0].name;

            groups[i - 1].rightTo = groups[i].children[0].name;

        }

        group.onkey_ENTER = function(focus) {

            var group = focus.parent;

            if (group.cmd == LauncherCMD.APP) {
                UI.popAllModule(true);
                startThirdPartyApp(null, focus.data.url, focus.data.urlType, CMDMethod.MENU, false, "#FFFFFF");
            } else if (group.cmd == LauncherCMD.INPUT) {
                if (focus.data.id == "100") {
                    UI.popAllModule();
                    UI.pushSubModule("miracast", "miracastMain", true);
                    UI.base.cursor.alpha = 0;
                } else {
                    changeSourceTo(focus.data.id);
                    UI.popAllModule();
                    openLiveTVModule([Msg.WAIT_SOURCE_CHANGE, 1]);
                }
            } else if (group.cmd == LauncherCMD.CHANNEL) {
                changeSourceTo(0);
                UI.popAllModule();
                openLiveTVModule([Msg.WAIT_SOURCE_CHANGE, 1]);
                checkAndPlayChannel(focus.data);
            }
        }

    }

    UI.refreshBounds(groupAnchor);

    UI.setView(groupAnchor, 1920, 1080);

    dynamic.currFocus = groups[0].children[0];

})();