/**
 * Created by manli1 on 2017-9-12.
 */
UI.moduleBuilder['setting']['picGammaCalibration'] = function(){
    try {

        var initImgData = {
            allBg: UI['bg_overlay'],
            picGammaCalibrationBg: UI.window_bg,
            picGammaCalibrationBar: UI.item_bg
        };
        var template = Util.readJsonObject("module/setting/picGammaCalibration.json");
        var picGammaCalibration = SubModule.create(initImgData, template);


        var picGammaCalibrationPageData = {
            InputLevelTextVec:["5", "10", "15", "20", "25", "30", "35", "40", "45",
                "50","55", "60", "65", "70", "75", "80", "85", "90", "95", "100"],
            InputLevelVal: 0,
            GainVal: 0
        };

        picGammaCalibration.onPush = function () {
            ModelNotifyInit();
            picGammaCalibrationPageInit();
            picGammaCalibration.currFocus = UI.getItem(picGammaCalibration, "InputLevel");
            UI.updateStage();
        };

        picGammaCalibration.onShow = function () {
            picGammaCalibration.alpha = 1;
        };

        function picGammaCalibrationPageInit() {
            try {
                picGammaCalibrationPageData.InputLevelVal = tv ? model.video.getGammaCalibrationLevel() : 2;
                DBG_INFO('model.video.getGammaCalibrationLevel(): ' + picGammaCalibrationPageData.InputLevelVal);
                onGammaCalibrationLevelChaged(picGammaCalibrationPageData.InputLevelVal);

                picGammaCalibrationPageData.GainVal = tv ? model.video.getGammaCalibrationGain() : 3;
                DBG_INFO('model.video.getGammaCalibrationGain(): ' + picGammaCalibrationPageData.GainVal / 2);
                onGammaCalibrationgGainChaged(picGammaCalibrationPageData.GainVal);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        var InputLevel = UI.getItem(picGammaCalibration, "InputLevel");
        var Gain = UI.getItem(picGammaCalibration, "Gain");
        var RestoreGammaCalibration = UI.getItem(picGammaCalibration, "RestoreGammaCalibration");

        function CreateLabelFunc(label, labelStr) {
            try {
                var fontSize = "36px SourceSansPro-Light";
                var cmpValue = UI.getItem(label, "textLabelValue");
                LabelValue.create(cmpValue, labelStr, fontSize);
                cmpValue.setValue(eval('picGammaCalibrationPageData.' + label.name + "Val").toString());
                UI.updateStage();
                label.onkey_ENTER = function () {
                    DBG_INFO(label.name + ".onkey_ENTER");
                    HidepicGammaCalibration();
                    PictureConfig.PicGammaCalibrationSign = label.name;
                    UI.pushSubModule("setting", "picGammaCalibrationAdjust", true);
                };
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        CreateLabelFunc(InputLevel, "[SE3567]");
        CreateLabelFunc(Gain, "[SE3568]");

        RestoreGammaCalibration.onkey_ENTER = function () {
            DBG_INFO('PanelColorTunerReset.onkey_ENTER');
            HidepicGammaCalibration();
            PictureConfig.PicResetSign = PicSignDefine.PicResetSign.PIC_GAMMA_CALIBRATION_RESET;
            UI.pushSubModule("setting", "picReset", true);
        };

        var onGammaCalibrationLevelChaged = function (val) {
            try {
                DBG_INFO("onColorHueChaged: " + val);
                picGammaCalibrationPageData.InputLevelVal = picGammaCalibrationPageData.InputLevelTextVec[val];
                picGammaCalibrationPageData.InputLevelVal = picGammaCalibrationPageData.InputLevelVal+"%";
                UILabelSetVal(InputLevel);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onGammaCalibrationgGainChaged = function (val) {
            try {
                DBG_INFO("onColorSaturationChaged: " + val / 2);
                picGammaCalibrationPageData.GainVal = val / 2;
                UILabelSetVal(Gain);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };

        function UILabelSetVal(label) {
            try {
                UI.getItem(label, "textLabelValue").setValue(eval('picGammaCalibrationPageData.' + label.name + "Val"));
                //label.updateCache();
                UI.updateStage();
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
        function HidepicGammaCalibration() {
            picGammaCalibration.alpha = 0;
        }
        function ModelNotifyInit() {
            try {
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_GAMMA_CALIBRATION_LEVEL, onGammaCalibrationLevelChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_GAMMA_CALIBRATION_GAIN, onGammaCalibrationgGainChaged);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
        function UNModelNotifyInit() {
            try {
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_GAMMA_CALIBRATION_LEVEL, onGammaCalibrationLevelChaged);
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_GAMMA_CALIBRATION_GAIN, onGammaCalibrationgGainChaged);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
        picGammaCalibration.onPop = function(){
            UNModelNotifyInit();
        }

    } catch (ex) {
        DBG_ERROR(ex.message);
    }
};