// Init
//var PicAdvancedFunc = {};
UI.moduleBuilder['setting']['picAdvanced'] = function(){
    try {

        var heightEnum = {
            H_120: 120,
            H_72: 72
        };
        var cmpSpaceEnum = {
            H_0: 0,
            H_10: 10,
            H_24: 24,
            H_48: 48
        };
        var firMagTop = cmpSpaceEnum.H_0;
        var cmpCfgVector = [
            {
                id: "AdvancedOverScan",
                height: heightEnum.H_120
            },
            {
                id: "AdvancedColorTemp",
                height: heightEnum.H_120
            },
            {
                id: "AdvancedAquoMotionEnhancement",
                height: heightEnum.H_120
            },
            {
                id: "AdvancedJudderReduction",
                height: heightEnum.H_72
            },
            {
                id: "AdvancedBlurReduction",
                height: heightEnum.H_72
            },
            {
                id: "AdvancedDigitalNoiseReduction",
                height: heightEnum.H_120
            },
            {
                id: "AdvancedHDMIDynamicRange",
                height: heightEnum.H_120
            },
            {
                id: "AdvancedActiveContrast",
                height: heightEnum.H_120
            },
            {
                id: "AdvancedColorSpace",
                height: heightEnum.H_120
            }
        ];
        var cmpIdVec = [];
        for (var i = 0; i < cmpCfgVector.length; i++) {
            cmpIdVec.push(cmpCfgVector[i].id);
        }
        function getCmpSpacing(idx) {
            if (0 == idx) {
                return firMagTop;
            } else {
                if (cmpCfgVector[idx].height == heightEnum.H_72 && cmpCfgVector[idx - 1].height == heightEnum.H_72) {
                    return cmpSpaceEnum.H_10;
                } else {
                    return cmpSpaceEnum.H_24
                }
            }
        }
        function getCmpPosY(cmpId) {
            var idx = cmpIdVec.indexOf(cmpId);
            var posY = cmpSpaceEnum.H_0;
            for (var i = 0; i < idx; i++) {
                posY += cmpCfgVector[i].height + getCmpSpacing(i + 1);
            }
            return posY;
        }

        var initData = {
            "picAdvancedSheet": UI.setting_bg,
            "picAdvancedIconImg": "setting/"+GLOBAL.LAUNCHER_BRAND+"/ic_picture_154x154.png",
            "JudderReductionPointIcon":"setting/pic/linkage_point.png",
            "BlurReductionPointIcon":"setting/pic/linkage_point.png",
            "AdvancedOverScanBar": UI.btn_normal_bg,
            "AdvancedColorTempBar": UI.btn_normal_bg,
            "AdvancedAquoMotionEnhancementBar": UI.btn_normal_bg,
            "AdvancedJudderReductionBar": UI.btn_normal_bg,
            "AdvancedBlurReductionBar": UI.btn_normal_bg,
            "AdvancedDigitalNoiseReductionBar": UI.btn_normal_bg,
            "AdvancedHDMIDynamicRangeBar": UI.btn_normal_bg,
            "AdvancedActiveContrastBar": UI.btn_normal_bg,
            "AdvancedColorSpaceBar": UI.btn_normal_bg
        };
        var template = Util.readJsonObject("module/setting/picAdvanced.json");

        for (var i = 0; i < cmpCfgVector.length; i++) {
            DBG_INFO(cmpCfgVector[i].id + getCmpPosY(cmpCfgVector[i].id));
            template.picAdvanced.items.picAdvancedGrp.items[cmpCfgVector[i].id].position.y = getCmpPosY(cmpCfgVector[i].id);
            template.picAdvanced.items.picAdvancedGrp.items[cmpCfgVector[i].id].position.x = 0;
        }

        var picAdvanced = SubModule.create(initData, template);
        var picAdvancedGrp = UI.getItem(picAdvanced, "picAdvancedGrp");
        UI.addMask(picAdvancedGrp, 1242, 925, 80, 6);
        UI.setView(picAdvancedGrp, 1242, 925);

        picAdvanced.onPush = function () {
            ModelNotifyInit();
            PicAdvancedPageInit();
            if (PicAdvancedPageData.isOverScanEnAble) {
                UI.getCurrModule().currFocus = picAdvanced.currFocus = UI.getItem(picAdvanced, "AdvancedOverScan");
            } else {
                UI.getCurrModule().currFocus = picAdvanced.currFocus = UI.getItem(picAdvanced, "AdvancedColorTemp");
                picAdvancedGrp.y = PosYDisable.PosYOverScanUp;
            }
            UI.updateStage();
        };
        picAdvanced.onShow = function () {
            UI.getItem(setting, 'picMain').alpha = 0;
            picAdvanced.alpha = 1;
        };

        var AdvancedOverScan = UI.getItem(picAdvancedGrp, "AdvancedOverScan");
        var AdvancedColorTemp = UI.getItem(picAdvancedGrp, "AdvancedColorTemp");
        var AdvancedAquoMotionEnhancement = UI.getItem(picAdvancedGrp, "AdvancedAquoMotionEnhancement");
        var AdvancedJudderReduction = UI.getItem(picAdvancedGrp, "AdvancedJudderReduction");
        var AdvancedBlurReduction = UI.getItem(picAdvancedGrp, "AdvancedBlurReduction");
        var AdvancedDigitalNoiseReduction = UI.getItem(picAdvancedGrp, "AdvancedDigitalNoiseReduction");
        var AdvancedHDMIDynamicRange = UI.getItem(picAdvancedGrp, "AdvancedHDMIDynamicRange");
        var AdvancedActiveContrast = UI.getItem(picAdvancedGrp, "AdvancedActiveContrast");
        var AdvancedColorSpace = UI.getItem(picAdvancedGrp, "AdvancedColorSpace");

        var PicAdvancedPageData = {
            isOverScanEnAble: true,
            isMemcSupport: 0,
            isJudderSupport: 0,
            isBlurSupport: 0,
            isEnumSmoothMotionExist: 0,
            isHdmiDynamicRangeEnable:0,
            isColorSpaceEnable: true,
            picOverScanTextVec: ["[GE0006]", "[GE0005]"],//["Off", "On"],
            picColorTempTextVec: ["[GE0001]","[GE0002]","[GE0003]", "[SE3128]"],//["Low", "Middle-Low", "Middle", "High"],
            picAquoMotionEnhancementTextVec: ["[GE0006]", "[SE0010]", "[SE1437]", "[BR0017]", "[SE0004]", "[SE3129]"],//["Off", "Custom", "Film", "Clear", "Standard", "Smooth"],
            picDigitalNoiseReductionTextVec: ["[GE0006]", "[GE0003]", "[GE0002]", "[GE0001]"],//["Off", "Low", "Medium", "High"],
            picHDMIDynamicRangeValTextVec: ["[GE0012]", "[SE3130]", "[SE0050]"],//["Auto", "Limit", "Full"],
            picActiveContrastTextVec:  ["[GE0006]", "[GE0003]", "[GE0002]", "[GE0001]"],//["Off", "Low", "Medium", "High"],
            picColorSpaceTextVec: ["[GE0012]", "[SE2746]"],//["Auto", "Native"],

            AdvancedOverScanVal: 0,
            AdvancedColorTempVal: 0,
            AdvancedAquoMotionEnhancementVal: 0,
            AdvancedJudderReductionVal: 0,
            AdvancedBlurReductionVal: 0,
            AdvancedDigitalNoiseReductionVal: 0,
            AdvancedHDMIDynamicRangeVal: 0,
            AdvancedActiveContrastVal: 0,
            AdvancedColorSpaceVal: 0
        };

        var PosYDisable = {
            PosYOverScanUp: 679,
            PosYColorSpaceDown:428
        };

        try {
            PicAdvancedPageData.isJudderSupport = tv ? model.video.getJudderReductionExist() : 1;//1
            DBG_INFO("model.video.getJudderReductionExist(): " + PicAdvancedPageData.isJudderSupport);
            PicAdvancedPageData.isBlurSupport = tv ? model.video.getBlurReductionExist() : 1;//1
            DBG_INFO("model.video.getBlurReductionExist(): " + PicAdvancedPageData.isBlurSupport);
        } catch (ex) {
            DBG_ERROR(ex.message);
        }

        function PicAdvancedPageInit() {
            try {
                var AdvancedOverScanValTmp = tv ? model.video.getOverscan() : 0;
                DBG_INFO("model.video.getOverscan(): " + AdvancedOverScanValTmp);
                PicAdvancedPageData.AdvancedOverScanVal = PicAdvancedPageData.picOverScanTextVec[AdvancedOverScanValTmp];
                onOverscanChaged(AdvancedOverScanValTmp);
                PicAdvancedPageData.isOverScanEnAble = checkOverScanEnAble();
                SetAdvancedEnable(AdvancedOverScan, PicAdvancedPageData.isOverScanEnAble);

                var AdvancedColorTempValTmp = tv ? model.video.getEnumColourTemperature() : 1;
                DBG_INFO("model.video.getEnumColourTemperature(): " + AdvancedColorTempValTmp);
                PicAdvancedPageData.AdvancedColorTempVal = PicAdvancedPageData.picColorTempTextVec[AdvancedColorTempValTmp];
                onEnumColourTemperatureChaged(AdvancedColorTempValTmp);

                PicAdvancedPageData.isMemcSupport = tv ? model.video.getEnumSmoothMotionExist() : 0xBF;//0xBF
                DBG_INFO("model.video.getEnumSmoothMotionExist(): " + PicAdvancedPageData.isMemcSupport);
                if (PicAdvancedPageData.isMemcSupport & 0x80){//7-bit: isMemcSupport
                    var AdvancedAquoMotionEnhancementValTmp = tv ? model.video.getEnumSmoothMotion() : 2;
                    DBG_INFO("model.video.getEnumSmoothMotion(): " + AdvancedAquoMotionEnhancementValTmp);
                    PicAdvancedPageData.AdvancedAquoMotionEnhancementVal = PicAdvancedPageData.picAquoMotionEnhancementTextVec[AdvancedAquoMotionEnhancementValTmp];
                    onEnumSmoothMotionChaged(AdvancedAquoMotionEnhancementValTmp);
                    PicAdvancedPageData.isEnumSmoothMotionExist =  PicAdvancedPageData.isMemcSupport & 1;
                    SetAdvancedEnable(AdvancedAquoMotionEnhancement, PicAdvancedPageData.isEnumSmoothMotionExist);
                    try {
                        if(!(2 & PicAdvancedPageData.isMemcSupport) || !PicAdvancedPageData.isJudderSupport || !PicAdvancedPageData.isBlurSupport){
                            DeleteJudderBlur();//Don't support Custom
                        }else{
                            //Don't support Judder Reduction
                            PicAdvancedPageData.AdvancedJudderReductionVal = tv ? model.video.getJudderReduction() : 2;
                            DBG_INFO("model.video.getJudderReduction(): " + PicAdvancedPageData.AdvancedJudderReductionVal);
                            onJudderReductionChaged(PicAdvancedPageData.AdvancedJudderReductionVal);
                            SetAdvancedEnable(AdvancedJudderReduction, PicAdvancedPageData.isEnumSmoothMotionExist);

                            //Don't support Blur Reduction
                            PicAdvancedPageData.AdvancedBlurReductionVal = tv ? model.video.getBlurReduction() : 3;
                            DBG_INFO("model.video.getBlurReduction(): " + PicAdvancedPageData.AdvancedBlurReductionVal);
                            onBlurReductionChaged(PicAdvancedPageData.AdvancedBlurReductionVal);
                            SetAdvancedEnable(AdvancedBlurReduction, PicAdvancedPageData.isEnumSmoothMotionExist);
                        }
                    } catch (ex) {
                        DBG_ERROR(ex.message);
                    }
                }else{
                    DBG_INFO("setHideSmoothMotion:"+ (PicAdvancedPageData.isMemcSupport & 128));
                    setHideSmoothMotion( );
                }

                var AdvancedDigitalNoiseReductionValTmp = tv ? model.video.getEnumNoiseReduction() : 1;
                DBG_INFO("model.video.getEnumNoiseReduction(): " + AdvancedDigitalNoiseReductionValTmp);
                PicAdvancedPageData.AdvancedDigitalNoiseReductionVal = PicAdvancedPageData.picDigitalNoiseReductionTextVec[AdvancedDigitalNoiseReductionValTmp];
                onEnumNoiseReductionChaged(AdvancedDigitalNoiseReductionValTmp);

                var isHdmiDynamicRangeExist = tv ? model.video.getHdmiDynamicRangeExist() : 1;
                DBG_INFO("model.source.getHdmiDynamicRangeExist(): " + isHdmiDynamicRangeExist);
                
                var AdvancedHDMIDynamicRangeValTmp = tv ? model.video.getHdmiDynamicRange() : 2;
                DBG_INFO("model.video.getHdmiDynamicRange(): " + AdvancedHDMIDynamicRangeValTmp);
                PicAdvancedPageData.AdvancedHDMIDynamicRangeVal = PicAdvancedPageData.picHDMIDynamicRangeValTextVec[AdvancedHDMIDynamicRangeValTmp];
                onHdmiDynamicRangeChaged(AdvancedHDMIDynamicRangeValTmp);
                PicAdvancedPageData.isHdmiDynamicRangeEnable= isHdmiDynamicRangeExist;
                SetAdvancedEnable(AdvancedHDMIDynamicRange, PicAdvancedPageData.isHdmiDynamicRangeEnable);               
                


                var AdvancedActiveContrastValTmp = tv ? model.video.getAdaptiveContrast() : 1;
                DBG_INFO("model.video.getAdaptiveContrast(): " + AdvancedActiveContrastValTmp);
                PicAdvancedPageData.AdvancedActiveContrastVal = PicAdvancedPageData.picActiveContrastTextVec[AdvancedActiveContrastValTmp];
                onAdaptiveContrastChaged(AdvancedActiveContrastValTmp);

                var isColorSpaceExit = tv ? model.video.getColorSpaceExist() : 1;
                DBG_INFO("model.video.getColorSpaceExist(): " + isColorSpaceExit);
                if(isColorSpaceExit){
                    var AdvancedColorSpaceValTmp = tv ? model.video.getColorSpace() : 0;
                    DBG_INFO("model.video.getColorSpace(): " + AdvancedColorSpaceValTmp);
                    PicAdvancedPageData.AdvancedColorSpaceVal = PicAdvancedPageData.picColorSpaceTextVec[AdvancedColorSpaceValTmp];
                    onColorSpaceChaged(AdvancedColorSpaceValTmp);
                    PicAdvancedPageData.isColorSpaceEnable = checkColorSpaceEnable();
                    SetAdvancedEnable(AdvancedColorSpace, PicAdvancedPageData.isColorSpaceEnable);
                }else{
                    setHideColorSpace();
                }

            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        var AspectRatioData = {
          Direct : 14,
          PixelMap : 3
        };
        var PictureModeData = {
          Vivid: 0,
          Standard: 1,
          EnergySaving:2,
          Movie: 3,
          Game: 4,
          Sport: 5,
          Calibrated: 6
        };
        function checkOverScanEnAble() {
            try {
                var appGhost = UI.getGhostModule(APPMODULE.CONTROL);
                var isOverScan= tv ? model.video.getOverscanSupported():1;
                var isUhdFlag = tv ? model.video.getUhdFlag() : 0;
                var isDMPRuning = UI.isExistModule ('hiMedia');
                var isZoom = [AspectRatioData.Direct, AspectRatioData.PixelMap].indexOf(tv ? model.video.getEnumZoom() : -1) > -1;
                var isWeather = UI.isExistModule ('accuweather');
                if (appGhost != null || isUhdFlag == 1 || true == isDMPRuning
                    || true == isZoom ||isOverScan==1 || true == isWeather) {
                    DBG_ERROR("checkOverScanEnAble: "+appGhost+isUhdFlag
                        +isDMPRuning+isZoom+isOverScan + isWeather);
                    return false;
                } else {
                    return true;
                }
            } catch (ex) {
                DBG_ERROR(ex.message);
                return true;
            }
        }

        function checkColorSpaceEnable(){
            var isPicMode = tv ? model.video.getEnumPictureMode() : 1;
            if((isPicMode == PictureModeData.Vivid) || (isPicMode == PictureModeData.Sport)){
                return false;
            }
            return true;
        }

        function SetAdvancedEnable(disableItem, isEnable) {
            try{
                DBG_INFO(disableItem.name + ' '+ isEnable);
                if(!isEnable){
                    DBG_INFO(disableItem.name + ' '+ 'hide');
                    disableItem.disable = true;
                    disableItem.alpha = 0.3;
                }else{
                    DBG_INFO(disableItem.name + ' '+ 'show');
                    disableItem.disable = false;
                    disableItem.alpha = 1;
                }
            }catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        function DeleteJudderBlur(){
            try {
                DBG_INFO("Hide Judder and Blur");
                AdvancedJudderReduction.disable = true;
                AdvancedJudderReduction.alpha = 0;
                AdvancedBlurReduction.disable = true;
                AdvancedBlurReduction.alpha = 0;
                AdvancedDigitalNoiseReduction.y = AdvancedAquoMotionEnhancement.y + heightEnum.H_120 + cmpSpaceEnum.H_24;
                AdvancedHDMIDynamicRange.y = AdvancedDigitalNoiseReduction.y + heightEnum.H_120 + cmpSpaceEnum.H_24;
                AdvancedActiveContrast.y = AdvancedHDMIDynamicRange.y + heightEnum.H_120 + cmpSpaceEnum.H_24;
                AdvancedColorSpace.y = AdvancedActiveContrast.y + heightEnum.H_120 + cmpSpaceEnum.H_24;

            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
        function setHideSmoothMotion( ) {
            try {
                DBG_INFO("Hide Smooth Motion");
                if(AdvancedDigitalNoiseReduction.y == AdvancedAquoMotionEnhancement.y) return;
                AdvancedAquoMotionEnhancement.disable = true;
                AdvancedAquoMotionEnhancement.alpha = 0;
                AdvancedJudderReduction.disable = true;
                AdvancedJudderReduction.alpha = 0;
                AdvancedBlurReduction.disable = true;
                AdvancedBlurReduction.alpha = 0;
                AdvancedDigitalNoiseReduction.y = AdvancedAquoMotionEnhancement.y;
                AdvancedHDMIDynamicRange.y = AdvancedDigitalNoiseReduction.y + heightEnum.H_120 + cmpSpaceEnum.H_24;
                AdvancedActiveContrast.y = AdvancedHDMIDynamicRange.y + heightEnum.H_120 + cmpSpaceEnum.H_24;
                AdvancedColorSpace.y = AdvancedActiveContrast.y + heightEnum.H_120 + cmpSpaceEnum.H_24;
                UI.updateStage();
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
        function setHideHdmiDynamicRange(){
            DBG_INFO("Hide Hdmi Dynamic Range");
            if(AdvancedActiveContrast.y == AdvancedHDMIDynamicRange.y) return;
            AdvancedHDMIDynamicRange.disable =true;
            AdvancedHDMIDynamicRange.alpha=0;
            AdvancedColorSpace.y = AdvancedActiveContrast.y;
            AdvancedActiveContrast.y = AdvancedHDMIDynamicRange.y;
            UI.updateStage();
        }
        function setHideColorSpace(){
            try {
                DBG_INFO("Hide Color Space");
                AdvancedColorSpace.disable = true;
                AdvancedColorSpace.alpha = 0;
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
        SetHelpInfo();

        function SetHelpInfo() {
            var CmpHelpInfo = {
                AdvancedOverScan: {
                    title: " ",
                    info: "[SE0525]"
                },
                AdvancedColorTemp: {
                    title: " ",
                    info: "[SE0483]"
                },
                AdvancedAquoMotionEnhancement: {
                    title: " ",
                    info: "[SE0527]"
                },
                AdvancedJudderReduction: {
                    title: " ",
                    info: " "
                },
                AdvancedBlurReduction: {
                    title: " ",
                    info: " "
                },
                AdvancedDigitalNoiseReduction: {
                    title: " ",
                    info: "[SE0528]"
                },
                AdvancedHDMIDynamicRange: {
                    title: " ",
                    info: "[SE2916]"
                },
                AdvancedActiveContrast: {
                    title: " ",
                    info: "[SE0482]"
                },
                AdvancedColorSpace: {
                    title: " ",
                    info: "[SE3143]"
                }
            };
            try {
                var CmpVec = [AdvancedOverScan, AdvancedColorTemp, AdvancedAquoMotionEnhancement,
                    AdvancedJudderReduction,AdvancedBlurReduction,AdvancedDigitalNoiseReduction,
                    AdvancedHDMIDynamicRange, AdvancedActiveContrast, AdvancedColorSpace];
                var infoCmp = UI.getItem(picAdvanced, 'picAdvancedInfo');

                for (var i = 0; i < CmpVec.length; i++) {
                    cmpSetOnNormalFocusFunc(CmpVec[i]);
                }

                function cmpSetOnNormalFocusFunc(cmp) {
                    cmp.onFocus = function () {
                        DBG_INFO('info: ' + CmpHelpInfo[cmp.name].info);
                        UI.setText(infoCmp, CmpHelpInfo[cmp.name].info);
                        return true;
                    };
                }
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }
        AdvancedColorTemp.onkey_UP = function (){
            if (!PicAdvancedPageData.isOverScanEnAble) {
                UI.getTween(picAdvancedGrp).to({y:PosYDisable.PosYOverScanUp},400);
            }else{
                return true;
            }
        };
        AdvancedActiveContrast.onkey_DOWN = function(){
            if (!PicAdvancedPageData.isColorSpaceEnable) {
                UI.getTween(picAdvancedGrp).to({y:PosYDisable.PosYColorSpaceDown},400);
            }else{
                return true;
            }
        };

        function CreateLabelFunc(label, labelStr) {
            try {
                var cmpValue = UI.getItem(label, "textLabelValue");
//                var brand = tv ? model.system.getCurBrand(): "his";
                if(label.name == "AdvancedAquoMotionEnhancement" ){
                    if (GLOBAL.UI_BRAND=="shp"){
                        labelStr = "[SE3132]";
                    }else{
                        labelStr = "[OT0255]";
                    }
                    DBG_INFO("AdvancedAquoMotionEnhancement.name = " + labelStr)
                }
                LabelValue.create(cmpValue, labelStr, FontDef.Arial_36, "0xFFFFFF");
                cmpValue.setValue(eval('PicAdvancedPageData.' + label.name + "Val").toString());
                UI.updateStage();

                    label.onkey_ENTER = function () {
                        switch(label.name) {
                            case "AdvancedOverScan":
                                PictureConfig.picOnOffSign = 'picOverScan';
                                UI.pushSubModule("setting", "picOverScanAdjust", true);
                                break;
                            case "AdvancedAquoMotionEnhancement":
                            case "AdvancedDigitalNoiseReduction":
                            case "AdvancedHDMIDynamicRange":
                            case "AdvancedColorSpace":
                            case "AdvancedColorTemp":
                            case "AdvancedActiveContrast":
                                PictureConfig.picModeSign = 'pic' + label.name.substr(8);
                                UI.pushSubModule("setting", "picMode", true);
                                break;
                            case "AdvancedJudderReduction":
                                if(PicAdvancedPageData.isJudderSupport &&PicAdvancedPageData.isBlurSupport){
                                    PictureConfig.PicJudderBlurSign = PicSignDefine.PicJudderBlurSign.PIC_JUDDER;
                                    UI.pushSubModule("setting", "picJudderBlurReductionAdjust", true);
                                }
                                break;
                            case "AdvancedBlurReduction":
                                if(PicAdvancedPageData.isJudderSupport &&PicAdvancedPageData.isBlurSupport){
                                    PictureConfig.PicJudderBlurSign = PicSignDefine.PicJudderBlurSign.PIC_BLUR;
                                    UI.pushSubModule("setting", "picJudderBlurReductionAdjust", true);
                                }
                                break;
                            default:
                                DBG_ERROR(label.name + ".onkey_ENTER");
                        }
                        HidePicAdvanced();
                    };

            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        CreateLabelFunc(AdvancedOverScan, "[SE0524]");
        CreateLabelFunc(AdvancedColorTemp, "[SE0038]");
        CreateLabelFunc(AdvancedAquoMotionEnhancement, "[SE3132]");
        CreateLabelFunc(AdvancedJudderReduction, "[SE2910]");
        CreateLabelFunc(AdvancedBlurReduction, "[SE2911]");
        CreateLabelFunc(AdvancedDigitalNoiseReduction, "[SE3135]");
        CreateLabelFunc(AdvancedHDMIDynamicRange, "[SE3136]");
        CreateLabelFunc(AdvancedActiveContrast, "[SE3137]");
        CreateLabelFunc(AdvancedColorSpace, "[SE3138]");


        var onOverscanChaged = function (val) {
            try {
                DBG_INFO("onOverscanChaged: " + val);
                PicAdvancedPageData.AdvancedOverScanVal = PicAdvancedPageData.picOverScanTextVec[val];
                UILabelSetVal(AdvancedOverScan);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onEnumColourTemperatureChaged = function (val) {
            try {
                DBG_INFO("onEnumColourTemperatureChaged: " + val);
                PicAdvancedPageData.AdvancedColorTempVal = PicAdvancedPageData.picColorTempTextVec[val];
                UILabelSetVal(AdvancedColorTemp);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onEnumSmoothMotionChaged = function (val) {
            try {
                DBG_INFO("onEnumSmoothMotionChaged: " + val);
                PicAdvancedPageData.AdvancedAquoMotionEnhancementVal = PicAdvancedPageData.picAquoMotionEnhancementTextVec[val];
                UILabelSetVal(AdvancedAquoMotionEnhancement);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onJudderReductionChaged = function (val) {
            try {
                DBG_INFO("onJudderReductionChaged: " + val);
                PicAdvancedPageData.AdvancedJudderReductionVal = val;
                UILabelSetVal(AdvancedJudderReduction);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onBlurReductionChaged = function (val) {
            try {
                DBG_INFO("onBlurReductionChaged: " + val);
                PicAdvancedPageData.AdvancedBlurReductionVal = val;
                UILabelSetVal(AdvancedBlurReduction);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onEnumNoiseReductionChaged = function (val) {
            try {
                DBG_INFO("onEnumNoiseReductionChaged: " + val);
                PicAdvancedPageData.AdvancedDigitalNoiseReductionVal = PicAdvancedPageData.picDigitalNoiseReductionTextVec[val];
                UILabelSetVal(AdvancedDigitalNoiseReduction);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onHdmiDynamicRangeChaged = function (val) {
            try {
                DBG_INFO("onHdmiDynamicRangeChaged: " + val);
                PicAdvancedPageData.AdvancedHDMIDynamicRangeVal = PicAdvancedPageData.picHDMIDynamicRangeValTextVec[val];
                UILabelSetVal(AdvancedHDMIDynamicRange);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onAdaptiveContrastChaged = function (val) {
            try {
                DBG_INFO("onAdaptiveContrastChaged: " + val);
                PicAdvancedPageData.AdvancedActiveContrastVal = PicAdvancedPageData.picActiveContrastTextVec[val];
                UILabelSetVal(AdvancedActiveContrast);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        var onColorSpaceChaged = function (val) {
            try {
                DBG_INFO("onColorSpaceChaged: " + val);
                PicAdvancedPageData.AdvancedColorSpaceVal = PicAdvancedPageData.picColorSpaceTextVec[val];
                UILabelSetVal(AdvancedColorSpace);
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };
        function UILabelSetVal(label) {
            try {
                UI.getItem(label, "textLabelValue").setValue(eval('PicAdvancedPageData.' + label.name + "Val"));
                UI.updateStage();
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        function ModelNotifyInit() {
            try {
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_OVERSCAN, onOverscanChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_COLOR_TEMP, onEnumColourTemperatureChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_SMOOTHR_MOTION, onEnumSmoothMotionChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_JUDDER_REDUCTION, onJudderReductionChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BLUR_REDUCTION, onBlurReductionChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_NOISE_REDUCTION, onEnumNoiseReductionChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_HDMI_DYNAMIC_RANGE, onHdmiDynamicRangeChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_ADAPTIVE_CONTRAST, onAdaptiveContrastChaged);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_COLOR_SPACE, onColorSpaceChaged);
//                model.video.onOverscanChaged = onOverscanChaged;
//                model.video.onEnumColourTemperatureChaged = onEnumColourTemperatureChaged;
//                model.video.onEnumSmoothMotionChaged = onEnumSmoothMotionChaged;
//                model.video.onJudderReductionChaged = onJudderReductionChaged;
//                model.video.onBlurReductionChaged = onBlurReductionChaged;
//                model.video.onEnumNoiseReductionChaged = onEnumNoiseReductionChaged;
//                model.video.onHdmiDynamicRangeChaged = onHdmiDynamicRangeChaged;
//                model.video.onAdaptiveContrastChaged = onAdaptiveContrastChaged;
//                model.video.onColorSpaceChaged = onColorSpaceChaged;
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        function HidePicAdvanced() {
            picAdvanced.alpha = 0;
        }

        picAdvanced.onPop = function(){
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_OVERSCAN, onOverscanChaged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_COLOR_TEMP, onEnumColourTemperatureChaged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_SMOOTHR_MOTION, onEnumSmoothMotionChaged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_JUDDER_REDUCTION, onJudderReductionChaged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_BLUR_REDUCTION, onBlurReductionChaged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_NOISE_REDUCTION, onEnumNoiseReductionChaged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_HDMI_DYNAMIC_RANGE, onHdmiDynamicRangeChaged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_ADAPTIVE_CONTRAST, onAdaptiveContrastChaged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.PICTURE_COLOR_SPACE, onColorSpaceChaged);
        }

    } catch (ex) {
        DBG_ERROR(ex.message);
    }
};