/**
 * Created by Hisense on 2016-3-9.
 */
// Init
UI.moduleBuilder['setting']['BluetoothDialog'] = function(){
    var initData = {
        ImgBg: UI['bg_overlay'],
        DialogImg: UI.window_bg,
        LeftBtnImg: UI.item_bg,
        RightBtnImg: UI.item_bg,
        CancelBtnImg: UI.item_bg,
        CancelBtnText:"[GE0008]",
        RightBtnText:"[SE3005]",
        LeftBtnText:"[SE0188]"
    };
    var template = Util.readJson("module/setting/BluetoothDialog.json");
    var BluetoothDialog = SubModule.create(initData, template);
    var BluetoothlikedDialog = UI.getItem(BluetoothDialog, "BluetoothlikedDialog");
    var DialogInfo = UI.getItem(BluetoothDialog, "DialogInfo");
    var BluetoothDialogPageData = {
        DeviceStateList: ["Paired", "[SE0399]"],//"Pairing successful","Connected",
        DevicePaired: 0,
        DeviceLinked: 1,
        BTDisCon: false,
        BTDisPair:false
    };
    var BluetoothlikedDialog = UI.getItem(BluetoothDialog, "BluetoothlikedDialog");
    var CancelBtn = UI.getItem(BluetoothlikedDialog, "CancelBtn");
    var LeftBtn = UI.getItem(BluetoothlikedDialog, "LeftBtn");
    var LeftBtnText = UI.getItem(LeftBtn,"LeftBtnText");
    var RightBtn = UI.getItem(BluetoothlikedDialog, "RightBtn");
    var BluetoothSetting = UI.getSubModule("BluetoothSetting");

    BluetoothDialog.currFocus = UI.getItem(BluetoothlikedDialog, "LeftBtn");
    BluetoothDialog.noAutoClose = true;

    BluetoothDialog.onPush = function () {
        try {
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.KEY_RELEASE, keyReleaseForBTDisCon);
            BluetoothDialogPageData.BTDisPair = false;
            BluetoothDialogPageData.BTDisCon = false;
            BluetoothDialog.deviceType = BluetoothSetting.deviceType;
            if(BluetoothSetting.deviceState == BluetoothAttribute.CONNECTED){
                UI.setText(DialogInfo, BluetoothSetting.deviceName + ":" + BluetoothDialogPageData.DeviceStateList[1]);
                UI.setText(LeftBtnText, "[SE0188]");//"Disconnect"
                LeftBtn.disable = false;
                LeftBtn.alpha = 1;
                UI.focusTo(LeftBtn);
            }else if(BluetoothSetting.deviceState == BluetoothAttribute.PAIRED){
                UI.setText(DialogInfo, BluetoothSetting.deviceName + ":" + BluetoothDialogPageData.DeviceStateList[0]);
                UI.setText(LeftBtnText, "[SE0187]");//"Connect"
                LeftBtn.disable = false;
                LeftBtn.alpha = 1;
                if (checkA2DPDevice(BluetoothDialog.deviceType)) {
                    LeftBtn.disable = false;
                    LeftBtn.alpha = 1;
                    UI.focusTo(LeftBtn);
                } else {
                    LeftBtn.disable = true;
                    LeftBtn.alpha = 0;
                    UI.focusTo(RightBtn);
                }
                UI.updateStage();
            }else{
                DBG_ERROR("BluetoothDialog.onPush:BluetoothSetting.deviceState error!!");
                UI.popSubModule();
            }

        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }

    }

    function checkA2DPDevice(deviceType) {
        if (deviceType == 4 || deviceType == 5) {
            return true;
        }
        else {
            return false;
        }
    } //蓝牙设备需要手动连接，目前蓝牙设备的类型是3和4

    function keyReleaseForBTDisCon() {
        try {
            if (BluetoothDialogPageData.BTDisCon) {
                if (tv) {
                    DBG_ERROR("keyReleaseForBTDisCon:deviceAddr"+BluetoothSetting.deviceAddr);
                    model.bluetooth.bluetoothDeviceSelectAction(BluetoothSetting.deviceAddr);//disconnect
                }
                BluetoothDialogPageData.BTDisCon = false;
                return true;
            }
            if(BluetoothDialogPageData.BTDisPair){
                model.bluetooth.bluetoothDeviceDeleteAction(BluetoothSetting.deviceAddr);
                BluetoothDialogPageData.BTDisPair = false;
            }
        }
        catch (ex) {
            DBG_ERROR("keyReleaseForBTDisCon:"+ex.message);
        }
    }
    BluetoothDialog.onkey_BACKSPACE = CancelBtn.onkey_ENTER = function () {
        try {
            UI.popSubModule();
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    };
    LeftBtn.onkey_ENTER = function () {
        try {
            if (BluetoothSetting.deviceState == BluetoothAttribute.PAIRED) {
                UI.popSubModule();
                BluetoothSetting.BluetoothStartConnectDevice();
                if(tv){
                    model.bluetooth.bluetoothDeviceSelectAction(BluetoothSetting.deviceAddr);
                }else{

                }
            } else {
                BluetoothDialogPageData.BTDisCon = true;
            }
            return true;
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    };

    RightBtn.onkey_ENTER = function () {
        if (tv) {
            BluetoothDialogPageData.BTDisPair = true;
        }
        return true;
    }

    BluetoothDialog.onPop = function () {
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.KEY_RELEASE, keyReleaseForBTDisCon);

    }
}
