/**
 * Created by Hisense on 2016-2-29.
 */
// Init
UI.moduleBuilder['setting']['AudioSpeakersList'] = function(){

    var initData = {
        AudioSpeakersListBg: UI.window_bg,
        SpeakersTitle:"[SE3250]"//Speakers
    };
    var template = Util.readJson("module/setting/AudioSpeakersList.json");
    var AudioSpeakersList = SubModule.create(initData, template);
    var commonList_array = [],allArray = [],index = 0,popList = null,title = null, groupName = null;
    var List = UI.getItem(AudioSpeakersList, "List");
    var List_image = {
        Focus: "setting/ic_radiobutton_focused.png",
        Normal: "setting/ic_radiobutton_normal.png"
    };
    var SpeakersTitle = UI.getItem(AudioSpeakersList,"SpeakersTitle");
    var info = {
        template: "DialogListItem",
        direction: CONST.GIRD_DIRECTION.H,
        breakNum: 1,
        distanceX: 0,
        distanceY: 20,
        container: List
    };

    function createList() {
        try {
            List.removeAllChildren();
            for (var i = 0; i < commonList_array.length; i++) {
                allArray.push(
                    {
                        ItemName: commonList_array[i],
                        tileBg: UI.item_bg,
                        name: "item" + i,
                        isFlag: List_image.Normal
                    }
                )
            }
            Gird.create(allArray, info);
            UI.addMask(List, 820, 330,100, 10);
            UI.setView(List, 820, 330);
            UI.addScrollbar(List,26);
            AudioSpeakersList.currFocus = UI.getItem(List, "item" + index);
            UI.updateStage();
        } catch (ex) {
            DBG_ERROR("createList is error" + ex.message)
        }

    }
    function SetCheckedImage() {
        try {
            for (var i = 0; i < List.initSequence.length; i++) {
                UI.setImage(List.children[i].children[2], List_image.Normal);
            }
            UI.setImage(AudioSpeakersList.currFocus.children[2], OEMFunction.getInstance().getBrandSelectFocusImage(), List_image.Focus);
        } catch (ex) {
            DBG_ERROR("SetCheckedImage" + ex.message)
        }
    }
    AudioSpeakersList.onPush = function () {
        initPopListParam();
        createList();
        SetCheckedImage();
    };
    function initPopListParam() {
        DBG_INFO("initPopListParam____");
        popList = AudioSpeakersList.param[0];
        index = popList.index;

        var BTAvailable = 0;
        try {
            BTAvailable = tv ?  model.bluetooth.getBluetoothAvailability() : 0;
            DBG_INFO("model.bluetooth.getBluetoothAvailability() " + BTAvailable);
        } catch (ex) {
            DBG_ERROR(ex.message);
        }

        if (BTAvailable) {
            commonList_array = ["[SE2751]", "[SE0792]", "[SE3526]","[SE0183]"];//TV Speaker/ARC/SPDIF/BlueTooth
        } else {
            commonList_array = ["[SE2751]", "[SE0792]", "[SE3526]"];//TV Speaker/ARC/SPDIF
        }

        //commonList_array = popList.listArray;
        title = popList.Title;
        groupName = popList.groupName;
        UI.setText(SpeakersTitle, title);
    }
    function clearAll() {
        try {
            allArray = [];//todo reset
            for (; info.container.children.length > 0;) {//todo clear old list
                info.container.children.pop();
            }
        } catch (ex) {
            DBG_ERROR('clearAll is error:' + ex.message)
        }

    }
    AudioSpeakersList.onPop = function () {
        clearAll();
    };
    List.onkey_ENTER = function (focus) {
        try {
            var index = List.initSequence.indexOf(focus);
            SetCheckedImage();
            var speakers = index+1;
            if (groupName == "SpeakersMenu") {
                DBG_INFO("model.sound.setSpeakerArc:"+speakers);
                tv && model.sound.setSpeakerArc(speakers);

            }
            else if (groupName == "BassBoostMenu") {
                DBG_INFO("model.sound.setDTSBassBoost:"+index);
                tv&&model.sound.setDTSBassBoost(index)

            }
            else if (groupName == "DialogClarityMenu") {
                DBG_INFO("model.sound.setDTSDialogClarify:"+speakers);
                tv&&model.sound.setDTSDialogClarify(index);
            }
            UI.popSubModule();
        } catch (ex) {
            DBG_ERROR("List.onkey_ENTER :" + ex.message);
        }

    };
};