// Init
UI.moduleBuilder['setting']['AudioMode'] = function(){
    var AudioModeData = {
        bg: UI["liveTV_bg"],
        disable_bg: UI.disable_bg
    };
    var template = Util.readJsonObject("module/setting/AudioMode.json");

    var AudioModeDataCfg = {
        AudioMode: {
            title: '[SE0059]',
            description: ' ',
            array:  [
                {tileBg:UI.btn_normal_bg,tileImg:"setting/snd/ic_standard.png", tileTxt:"[SE0004]", Info:"[SE2835]"},//"Standard"
                {tileBg:UI.btn_normal_bg,tileImg:"setting/snd/ic_speech.png", tileTxt:"[SE0062]", Info:"[SE2838]"},//"Speech"
                {tileBg:UI.btn_normal_bg,tileImg:"setting/snd/ic_late_night.png", tileTxt:"[SE0542]", Info:"[SE2839]"},//"Late Night"
                {tileBg:UI.btn_normal_bg,tileImg:"setting/snd/ic_music.png", tileTxt:"[SE0060]", Info:"[SE2837]"},//"Music"
                {tileBg:UI.btn_normal_bg,tileImg:"setting/pic/mode/ic_Movie.png", tileTxt:"[SE0061]", Info:"[SE2836]"},//"Theater"
                {tileBg:UI.btn_normal_bg,tileImg:"setting/snd/ic_sport.png", tileTxt:"[LA0013]", Info:"[OT0189]"}//"Sports"//todo citiao
            ]
        }
    };
    var AudioMode = SubModule.create(AudioModeData, template);

    AudioMode.onPush = function () {
        var grid = UI.getItem(AudioMode, "grid");
        grid != StrDef.UNDEFINED && grid.removeAllChildren();
        var array = [];// getObjCopy(AudioModeDataCfg[PictureConfig.AudioModeSign].array);
        var arrayData = AudioModeDataCfg.AudioMode.array;
        for (var i = 0; i < arrayData.length; i++) {
            array.push({
                tileBg: arrayData[i].tileBg,
                tileImg: arrayData[i].tileImg,
                tileTxt: arrayData[i].tileTxt
            });
        }
        var info = {
            template: "picModeNewTile",
            direction: CONST.GIRD_DIRECTION.V,
            breakNum: 1,
            distanceX: 20,
            distanceY: 0,
            container: grid
        };
        Gird.create(array, info);

        var curFocusIdx = getAudioModeModelValue();
        UI.setText(UI.getItem(AudioMode, 'title'), AudioModeDataCfg.AudioMode.title);
        AudioMode.currFocus = UI.getItem(AudioMode, "picModeNewTile" + curFocusIdx);
        UI.resetViewPos(UI.getItem(AudioMode, "grid"));

        if (AudioModeGrid.selectedItem) {
            AudioModeGrid.selectedItem.removeChild(selectedFlg, true);
            AudioModeGrid.selectedItem = UI.getItem(AudioMode, AudioMode.currFocus.name);
        }
        AudioModeGrid.initSequence[curFocusIdx].addChild(selectedFlg);
        AudioModeGrid.selectedItem = UI.getItem(AudioMode, AudioMode.currFocus.name);
    };

    AudioMode.onShow = function () {
        AudioMode.alpha = 1;
    };
    UI.addMask(UI.getItem(AudioMode, "grid"), 1760, 180, 38, 30);
    UI.setView(UI.getItem(AudioMode, "grid"), 1760, 180 ,0, 0);

    function getAudioModeModelValue() {
        try {
            var val = tv ? model.sound.getSoundMode() : 3;
            DBG_INFO("model.sound.getSoundMode(): " + val);
            if(val==undefined){val=0;}
            return val;
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    var selectedFlg = new PIXI.Graphics();
    selectedFlg.beginFill(OEMFunction.getInstance().getBrandColor()).drawRect(0, 152, 295, 8).endFill();

    var AudioModeGrid = UI.getItem(AudioMode, 'grid');
    AudioModeGrid.onFocus = function () {
        DBG_INFO('AudioModeGrid.onFocus');
        var currFocus = AudioMode.currFocus;
        if (!AudioModeGrid.selectedItem) {
            currFocus.addChild(selectedFlg);
            AudioModeGrid.selectedItem = UI.getItem(AudioMode, currFocus.name);
        }
        var curFocusIdx = currFocus.name.substr(14);
        UI.setText(UI.getItem(AudioMode, 'description'), AudioModeDataCfg.AudioMode.array[curFocusIdx].Info);
        UI.updateStage();
        return true;
    };

    AudioModeGrid.onkey_ENTER = function () {
        var currFocus = AudioMode.currFocus;
        if (AudioModeGrid.selectedItem) {
            AudioModeGrid.selectedItem.removeChild(selectedFlg, true);
            AudioModeGrid.selectedItem = UI.getItem(AudioMode, currFocus.name);
        }
        currFocus.addChildAt(selectedFlg,currFocus.children.length-2);
        var curIdx = parseInt(currFocus.name.substr(14));
        UI.updateStage();
        SetAudioModeModelValue(curIdx);
    };

    function SetAudioModeModelValue(curIdx) {
        try {
            tv && model.sound.setSoundMode(curIdx,1,1);
            DBG_INFO("model.sound.setSoundMode(" + curIdx + ")");
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    AudioModeGrid.onkey_BACKSPACE = function () {
        DBG_INFO('SndModeGrid.onkey_BACKSPACE');
        UI.popSubModule();
        var AudioMainPanel = UI.getSubModule("AudioMainPanel");

        if(AudioMode.caller=="AudioMainPanel"){
            AudioMainPanel.alpha = 1;
        }
        else if(!!AudioMode.param && !!AudioMode.param.caller && AudioMode.param.caller.toString()=="hiMedia"){
            hiMedia.changeByLauncher("resume");
        }
        else{
            if(window["setting"]["menuChip"]){
                window["setting"]["menuChip"].open();
            }
            else {
                UI.pushSubModule("setting","menuChip",true,AudioMode.param,null,"CHIP"+ CHIPS.SND_MODE);

            }
        }
    };

};

