/************
 **   Created by Xueyuan
 **       2016-1-26
 ************/

//init
UI.moduleBuilder['dlna']['dlnaPicPlayer'] = function () {
    var dlnaPPageData = {
        picName: "Picture Name"
    };
    var template = Util.readJson("module/dlna/dlnaPicPlayer.json");
    var dlnaPicPlayer = SubModule.create(dlnaPPageData, template);
    var picPlayerMenu = UI.getItem(dlnaPicPlayer, "picPlayerMenu");
    picPlayerMenu.visible = false;
    picPlayerMenu.alpha = 0;

    var picStatus = UI.getItem(dlnaPicPlayer, "picStatus");
    picStatus.visible = false;
    picStatus.alpha = 0;
    dlnaPicPlayer.currFocus = UI.getItem(dlnaPicPlayer, "picName");

    var picName = "";
    dlnaPicPlayer.picTitle = UI.getItem(dlnaPicPlayer,"picName");

    dlnaPicPlayer.onPush = function () {
        try {
            DBG_ALWAYS("Dlna picPlayer onPush");
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_STATE_CHANGED, dlnaPicPlayer.onPStateChanged);
            writeFileToNative("picStopFlag", "running", 0);
            dlnaPicPlayer.updateDlnaData(Dlna.dlnaPicList);
            playstatus = 0;
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    dlnaPicPlayer.onShow = function () {
        UI.getTween(dlnaPicPlayer.picTitle, true).set({y: -85});//图片加载完成前隐藏title
    }

    dlnaPicPlayer.updateDlnaData = function (piclist) {
        DBG_ALWAYS("update DlnaPicPlayer data");
        Dlna.startLoading("dlnaPicPlayer", 30);
        //model.cec.setIsMiracastExist(1);
        picStartCount = 0;
        decodeTime = 0;
        var url = piclist[0].picUrl;
        var name = piclist[0].picName;
        picName = name;
        UI.setText(dlnaPicPlayer.picTitle, name);
        dlnaPicPlayer.playPicByUrl(url);
    }

    dlnaPicPlayer.playPicByUrl = function (pUrl) {
        if (pUrl != null) {
            DBG_INFO("pic Url is :" + pUrl);
            try {
                model.mpctrl.PlayMedia(pUrl, null, null, null, null, null, 16, null, null, null);
            }
            catch (ex) {
                DBG_ERROR("[playPicByUrl]" + ex.message);
            }
        }
    }
    var playstatus = 0;
    dlnaPicPlayer.onPStateChanged = function (value) {
        var nState = parseInt(value[2]);
        DBG_INFO("[onPStateChanged] state changed : " + nState);

        if (nState == playstatus &&
            (nState == MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PREPARE_DONE ||
                nState == MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PREPARED)) {
            DBG_INFO("drop duplicated state event" + nState);
            return;
        }
        playstatus = nState;
        var currentSubModel = (UI.getCurrSubModule() ? UI.getCurrSubModule().name : "");
        DBG_INFO("currentSubModel: " + currentSubModel);
        if (currentSubModel == "dlnaPicPlayer") {
            switch (nState) {//(parseInt(value))

                case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PLAYING:
                    //UI.setImage(videoStatus, "hiMedia/play_status.png");
                    break;
                case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PAUSE:
                    break;

                case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PLAY_DONE:
                    break;
                case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PREPARE_DONE:
                    try {
                        model.mpctrl.MpCtrl(1);
                        Dlna.endLoading("picPlayer");
                    } catch (ex) {
                        DBG_ERROR(ex.message);
                    }
                    break;
                case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PREPARED:
                    DBG_INFO("SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PREPARED!");

                    try {
                        model.mpctrl.MpCtrl(1);
                        Dlna.endLoading("picPlayer");
                        Dlna.renderLock = false;
                        UI.unlockAllKeys("picDone");
                        var infoData = model.mpctrl.getMetadata();
                        width = picPlayer.pWidth = parseInt(infoData[MpCtrlModelDefines.SL2_TVAPI_MPCTRL_VSTR_METADATA_INDEX_VIDEO_WIDTH]);
                        height = picPlayer.pHeight = parseInt(infoData[MpCtrlModelDefines.SL2_TVAPI_MPCTRL_VSTR_METADATA_INDEX_VIDEO_HEIGHT]);
                        pubStateMediaDLNA(picName, 0, 0, 0, "single", "picture", width + "*" + height);
                    } catch (ex) {
                        DBG_ERROR(ex.message);
                    }

                    break;
                case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_AUTO_STOP://no get
                    //case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_RELEASING:
                    dlnaPicPlayer.closePicPlayer();
                    break;

                case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_AUDIO_UNPLAYABLE:
                case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_VIDEO_UNPLAYABLE:
                case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_NOT_SUPPORT_FILE:
                case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_OPEN_FILE_FAIL:
                case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_UNKNOWN:
                case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_MEDIA_LOST:
                    //"File not supported"  leftover
                    Dlna.toastMsg("[DMP0031]");
                    dlnaPicPlayer.closePicPlayer();
                    break;

                default :

                    break;
            }
        } else {
            DBG_ERROR("current subModel is " + currentSubModel + ",not picPlayer!!");
        }
    }

    var picStartTimer = null;
    var picStartCount = 0;
    var decodeTime = 0;


    dlnaPicPlayer.closePicPlayer = function () {
        if (UI.getCurrSubModule().name == "dlnaPicPlayer") {
            UI.popSubModule();
            clearTimeout(Dlna.closeDlnaTimer);
            Dlna.closeDlnaTimer = setTimeout(function () {
                UI.popAllModule();
                try {
                    openLiveTVModule([Msg.INFO, 0]);
                } catch (e) {
                    DBG_ERROR(e.message);
                }
            }, 3000);
        }
    }

    dlnaPicPlayer.onkey_ESCAPE = function () {
//        UI.popSubModule();
        UI.popAllModule();
        try {
            openLiveTVModule([Msg.INFO, 0]);
        } catch (e) {
            DBG_ERROR(e.message);
        }
    }
    dlnaPicPlayer.onkey_MENU = function () {
        if(!!GLOBAL.DLNADEVICE_MAC){
            var str = localStorage.getItem(GLOBAL.DLNADEVICE_MAC);
            if(str == 1){
                localStorage.removeItem(GLOBAL.DLNADEVICE_MAC);
                var mac = Config.language.SE0181 + ":" + GLOBAL.DLNADEVICE_MAC;
                UI.pushGhostModule("common", "dlnaToast2",{"titleStr" : "[SE4212]", "textStr": mac})
                dlnaPicPlayer.onkey_BACKSPACE();
            }
        }
    };
    dlnaPicPlayer.onkey_BACKSPACE = function () {
//        UI.popSubModule();
        UI.popAllModule();
        try {
            openLiveTVModule([Msg.INFO, 0]);
        } catch (e) {
            DBG_ERROR(e.message);
        }
    }

    dlnaPicPlayer.onExit = function () {
        Dlna.endLoading("dlnaPicPlayer");
    }

    dlnaPicPlayer.onPop = function () {
        try {
            clearTimeout(picStartTimer);
            clearTimeout(Dlna.decodePicTimer);

            model.mpctrl.MpCtrl(3);
            //model.cec.setIsMiracastExist(0);
            writeFileToNative("picStopFlag", "stop", 0);
	    pubStateMediaDLNA(picName, 0, 0, 0, "stop", "picture", "");
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_STATE_CHANGED, dlnaPicPlayer.onPStateChanged);

        } catch (e) {
            DBG_ERROR(e.message);
        }
    }
};