// Init
UI.moduleBuilder['FTE']['fte_videoPlay'] = function(){
    var videoPlayData = {
    };
    var template = Util.readJson("module/FTE/fte_videoPlay.json");
    var videoPlay = SubModule.create(videoPlayData, template);
    var focusLocation = UI.getItem(videoPlay, "focusLocation");
    var playerstatus = 0;

    videoPlay.fte4kVideoPath = "";

    videoPlay.currFocus = focusLocation;


    videoPlay.onPush = function() {
        UI.lockAllKeys();
        var isPlayVideoEnable = false;
//        if (tv) {
//            if (Hisense.File.exists("video/StoreModeDemo.mkv", 5)) {
//                isPlayVideoEnable = true;
//                videoPlay.fte4kVideoPath = "file:///vddt/video/StoreModeDemo.mkv";
//            } else if (Hisense.File.exists("video/StoreModeDemo.mp4", 5)) {
//                isPlayVideoEnable = true;
//                videoPlay.fte4kVideoPath = "file:///vddt/video/StoreModeDemo.mp4";
//            } else {
//                DBG_ERROR("can't find 4k video in path");
//            }
//        }
        DBG_ERROR("isPlayVideoEnable is " + isPlayVideoEnable + " FTE.isTimeoutPlay4KVideo is " + FTE.isTimeoutPlay4KVideo);
        if (isPlayVideoEnable) {
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_STATE_CHANGED, fteVideoStatchanged);//listening state
            UI.unlockAllKeys();
            ftePlayVideo();
        }else {
            setTimeout(function() {
                UI.unlockAllKeys();
                FTE.fteExit(FTE.play4kVideoCallback);
            }, 100);
        }
    };

    videoPlay.onPop = function(){
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_STATE_CHANGED, fteVideoStatchanged);//listening state
        UI.registerKeyCodes(FTE.enableKeyGroup);
        UI.getCurrModule().alpha = 1;
    };
    videoPlay.afterPush = function() {
        UI.updateStage();
    };

    videoPlay.onExit = function() {
        UI.getCurrModule().alpha = 1;
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_STATE_CHANGED, fteVideoStatchanged);//listening state
    };

    videoPlay.onFocus = function() {
       /* createjs.Tween.removeAllTweens();
        UI.base.cursor.alpha = 1;
        UI.updateStage();*/
        return true;
    };
    videoPlay.onNormal = function() {};

    videoPlay.onkey = function() {
        DBG_ERROR("----------------------------------receive key");
        fteStopVideo();
//        UI.popSubModule();
//        if(!FTE.isTimeoutPlay4KVideo){
//            FTE.fteExit(FTE.play4kVideoCallback);   //解锁按键屏蔽,总是一个函数或者null,
//        }
    };

    function ftePlayVideo() {   //todo pauseTV
        if (!tv) {
            return;
        }
        try {
            DBG_ERROR("videoPlay.fte4kVideoPath is " + videoPlay.fte4kVideoPath);
            pauseDTV();
            setTimeout(function () {
                UI.lockAllKeys();
                model.mpctrl.PlayMedia(videoPlay.fte4kVideoPath, null, null, null, null, null, 4, null, null, null);
            }, 1000);

            DBG_INFO("ftePlayVideo begin");
        }
        catch (ex) {
            DBG_ERROR("ftePlayVideo: " + ex.message);
        }
    }

    function fteStopVideo() {
        try {
            DBG_INFO("fteStopVideo: stop video play");
            model.mpctrl.MpCtrl(3);
        }
        catch (ex) {
            DBG_ERROR("fteStopVideo: " + ex.message);
        }
    }

    function fteVideoStatchanged(value) {
        DBG_ERROR("UI.getCurrSubModule().name is " + UI.getCurrSubModule().name);
        DBG_ERROR(" fteVideoStatchanged : "  +  value);
        var nState = parseInt(value[2]);
        if (nState == playerstatus &&
            (nState == MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PREPARE_DONE ||
                nState == MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PREPARED)) {
            DBG_ERROR("drop duplicated state event" + nState);
            return;
        }
        DBG_ERROR("playerstatus = " + playerstatus + " nState = " + nState);
        playerstatus = nState;
        switch (parseInt(value[2])) {
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_IDLE:
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PREPARING:
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PREPARED:
                //准备好后发播放命令  5658 PREPARE_DONE;6586 :PREPARED
                try {
                    DBG_ERROR("fte play 4k video now");
                    UI.getCurrModule().alpha = 0;
                    UI.updateStage();
                    model.mpctrl.setScreenPosition(createIntergerVector([0,0,3840,2160,1,0]));
                    model.mpctrl.MpCtrl(1);  //播放器开始播放资源
                    UI.unlockAllKeys();
                    UI.registerKeyCodes(null);
                    UI.setKeyGroup(7);

                }
                catch(ex){
                    DBG_ERROR("fteVideoStatchanged: " + ex.message);
                }
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PLAYING:
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PAUSE:
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_STOP:
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_AUTO_STOP:
                if(FTE.isTimeoutPlay4KVideo){
                    DBG_ERROR("4k video  auto stop and repeat play");
                    setTimeout(function () {
                        model.mpctrl.PlayMedia(videoPlay.fte4kVideoPath, null, null, null, null, null, 4, null, null, null);
                    }, 200);
                }else{
                    fteStopVideo();
                    FTE.fteExit(FTE.play4kVideoCallback);
                }
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_RELEASING:
                DBG_ERROR("source release");
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PREPARE_DONE:  //不再使用
                break;
            case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_AUDIO_UNPLAYABLE:
            case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_VIDEO_UNPLAYABLE:
            case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_NOT_SUPPORT_FILE:
            case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_OPEN_FILE_FAIL:
            case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_UNKNOWN:
                DBG_ERROR("play error UI stop video us_5766");
                videoPlay.onkey();
                break;
            default :
                break;
        }
    }
};
