// Init
UI.moduleBuilder['FTE']['fte_netIpSet'] = function(){
    var netIpSetData = {
        switchIcon: "FTE/"+GLOBAL.LAUNCHER_BRAND +"/fte_tggl_on.png",
        switchText: "[SE3095]",//Manually assign IP address
        text1: "[SE0175]",      //"IP Address",
        text2: "[SE0618]",      //"Subnet Mask",
        text3: "[SE0177]",      //"Gateway",
        text4: "[SE3096]",//DNS Server
        saveBtnText: "[SE3097]",//Save changes
        skipBtnImg: UI.item_bg,
        cancelText: "[SE3067]"//Press BACK button to cancel
    };
    var template = Util.readJson("module/FTE/fte_netIpSet.json");
    var netIpSet = SubModule.create(netIpSetData, template);

    var DataNetIpSetHelp = "[SE2944]";//"Most devices obtain an IP address automatically. Set an IP address manually if you do not have a router, or your router does not assign IP address for you.";

    netIpSet.pageData = {
        "tilesIndex": 0,
        "clrFlag": false,
        "ipConfigType": 1,              //IP��ȡ��ʽ��0���Զ���1���ֶ�
        "ipAddress": "172.168.1.100",       //ip��ַ
        "subnet_Mask": "255.255.255.0",     //��������
        "default_Gateway": "172.168.1.1",   //Ĭ�����
        "primary_DNS": "172.168.1.130",     //DNS
        "secondary_DNS": "172.168.1.131"    //����DNS
    };

    var nameText = UI.getItem(netIpSet, "nameText");
    var tiles1 = UI.getItem(netIpSet, "tiles1");    //ip����
    var tiles2 = UI.getItem(netIpSet, "tiles2");    //�»��ߺ͵����
    var okBtn = UI.getItem(netIpSet, "okBtn");
    var switchBar = UI.getItem(netIpSet, "switchBar");


    var array2 = [];
    for (var i=0; i < 16; i++) {
        array2.push({});
        array2[i].name = "ipSetFiledBg" + i;
        array2[i].numBgImg = "FTE/fte_txt_fld_short_standard.png";
        array2[i].point = ".";
    }
    var info2 = {
        template: "fte_ipSet_item3",
        direction: CONST.GIRD_DIRECTION.H,
        breakNum: 4,
        distanceX: 10,
        distanceY: 24,
        container: tiles2
    };
    Gird.create(array2, info2);
    //���������ĵ��
    tiles2.children[3].children[2].alpha = 0;
    tiles2.children[7].children[2].alpha = 0;
    tiles2.children[11].children[2].alpha = 0;
    tiles2.children[15].children[2].alpha = 0;
    UI.updateStage();

    var array = [];
    for (var i=0; i < 16; i++) {
        array.push({});
        array[i].name = "ipSetFiled" + i;
    }
    var info = {
        template: "fte_ipSet_item2",
        direction: CONST.GIRD_DIRECTION.H,
        breakNum: 4,
        distanceX: 48,
        distanceY: 24,
        container: tiles1
    };
    Gird.create(array, info);
    //�������ҵ���
    tiles1.children[3].rightTo = tiles1.children[4].name;
    tiles1.children[7].rightTo = tiles1.children[8].name;
    tiles1.children[11].rightTo = tiles1.children[12].name;
    tiles1.children[15].rightTo = okBtn.name;

    // ��������Ϊ���������
    var NumInfo = {
        initVal : 12,
        min : 0,
        max : 2559, //255�ټ�һ����λ
        fontSize : 40,
        align: "center",
        color : 0xFFFFFF
    };
    for (var i=0; i < tiles1.children.length; i++) {
        NumberInput.create(tiles1.children[i].children[0], NumInfo, onNumChanged);
        //͸�����ֿ򱳾�
        tiles1.children[i].children[0].children[0].alpha = 0;
    }

    tiles1.children.forEach(function(target) {
        target.onkey_ZERO = target.children[0].onkey_ZERO
        target.onkey_ONE = target.children[0].onkey_ONE
        target.onkey_TWO = target.children[0].onkey_TWO
        target.onkey_THREE = target.children[0].onkey_THREE
        target.onkey_FOUR = target.children[0].onkey_FOUR
        target.onkey_FIVE = target.children[0].onkey_FIVE
        target.onkey_SIX = target.children[0].onkey_SIX
        target.onkey_SEVEN = target.children[0].onkey_SEVEN
        target.onkey_EIGHT = target.children[0].onkey_EIGHT
        target.onkey_NINE = target.children[0].onkey_NINE
    })

    function onNumChanged(txt) {
        var number = parseInt(txt.text, 10);
        var quotient  = parseInt(number / 10);
        var remainder = number % 10;     //��λ

        if (netIpSet.pageData.clrFlag) {    //�������־��ֻ������λ��ע��onFocu��ı�netIpSet.pageData.clrFlagֵ
            netIpSet.pageData.clrFlag = false;
            txt.text = remainder;
            if (txt.text == 0) {
                var next = UI.getItem(netIpSet, UI.getCurrFocus().rightTo);
                UI.focusTo(next);
            }
        }
        else {
            if (quotient == 25 && remainder > 5) {  //����������256~259�����
                txt.text = 25;
                var next = UI.getItem(netIpSet, UI.getCurrFocus().rightTo);
                next.children[1].text = remainder;
                UI.focusTo(next);
                netIpSet.pageData.clrFlag = false;
            }
            if ((number > 999 && remainder == 0) || txt.text > 25 || txt.text.length == 3) { //����Ϊ���ǰ��λ���ڵ���25�򳤶��Ѿ�Ϊ3�ˣ���ת
                var next = UI.getItem(netIpSet, UI.getCurrFocus().rightTo);
                UI.focusTo(next);
            }
        }
        saveIpAddress();
    }

    function saveIpAddress(){
        netIpSet.pageData.ipAddress = tiles1.initSequence[0].children[0].children[1].text.toString() + "." + tiles1.initSequence[1].children[0].children[1].text + "." + tiles1.initSequence[2].children[0].children[1].text + "." + tiles1.initSequence[3].children[0].children[1].text;
        netIpSet.pageData.subnet_Mask = tiles1.initSequence[4].children[0].children[1].text.toString() + "." + tiles1.initSequence[5].children[0].children[1].text + "." + tiles1.initSequence[6].children[0].children[1].text + "." + tiles1.initSequence[7].children[0].children[1].text;
        netIpSet.pageData.default_Gateway = tiles1.initSequence[8].children[0].children[1].text.toString() + "." + tiles1.initSequence[9].children[0].children[1].text + "." + tiles1.initSequence[10].children[0].children[1].text + "." + tiles1.initSequence[11].children[0].children[1].text;
        netIpSet.pageData.primary_DNS = tiles1.initSequence[12].children[0].children[1].text.toString() + "." + tiles1.initSequence[13].children[0].children[1].text + "." + tiles1.initSequence[14].children[0].children[1].text + "." + tiles1.initSequence[15].children[0].children[1].text;

    }

    tiles1.onFocus = function() {
        netIpSet.pageData.clrFlag = true;
        UI.getCurrFocus().children[0].children[1].alpha = 1;
//        showTiles1name();
        return true;
    };
    tiles1.onNormal = function() {
        UI.getCurrFocus().children[0].children[1].alpha = 0.7;
        return true;
    };
    for (var i = 0; i < tiles1.children.length; i++) {
        tiles1.children[i].children[0].children[1].alpha = 0.7;
    }

    function showTiles1name() {
        tiles1.children.map(function(index, target) {
//            DBG_INFO("showTiles1name: " + target.name);
            DBG_INFO("showTiles1name: " + index.name);  //todo Ϊʲô��index??
        })
    }

    netIpSet.currFocus = UI.getItem(netIpSet, "switchBar");

//};

/*-------------------------------------Actions------------------------------------------------*/
//(function(){
    var background = UI.getSubModule("fte_background");
    var network = UI.getSubModule("fte_network");
    var netWifiResult = null;
//    var tiles1First = UI.getItem(tiles1, "ipSetFiled0");
//    var tiles1Last = UI.getItem(tiles1, "ipSetFiled3");
    var tiles1First = tiles1.children[0];
    var tiles1Last = tiles1.children[12];
    var switchIcon = UI.getItem(netIpSet, "switchIcon");

    netIpSet.onPush = function() {

        DBG_INFO("netIpSet.onPush: network.netType is "  + network.netType);
        if (network.netType == NetWorkType.WIRELESS) { //��������Ϊwifiʱ����Ҫ��ȡnetnetWifiResultҳ,��netnetWifiResultҳһ������
            netWifiResult = UI.getSubModule("fte_netWifiResult");
        }
        getAndShowIp();
        switchBar.children[0].isBg=true;
    };

    netIpSet.onShow = function () {
        showSkipEleOrNot(0);
        changeNetworkHelpText(DataNetIpSetHelp);
        showIpAddress();
    };

    netIpSet.onkey_BACKSPACE = function() {
        if (network.netType == NetWorkType.WIRELESS) {
            if(network.ipWifiPageMode == 0){
                netWifiResult.showWifiBtnNoConnectPage();
            }else{//network.ipWifiPageMode == 1
                var fte_netPasswordError = UI.getSubModule("fte_netPasswordError");
                popSubModuleUntil("fte_netPasswordError");
                elementShow(fte_netPasswordError);
            }
        }
        else if (network.netType == NetWorkType.ETHER) {
            if (network.ipPageMode == 1) {
                network.showEthBtnNoConnectPage();
            }
            else{
                popSubModuleUntil("fte_network");
                network.searchEthernet();
            }
        }
        else{

        }
    };

    netIpSet.getIpData = function () {
        var ipArray = [];
        ipArray.push(netIpSet.pageData.ipAddress.split("."));
        ipArray.push(netIpSet.pageData.subnet_Mask.split("."));
        ipArray.push(netIpSet.pageData.default_Gateway.split("."));
        ipArray.push(netIpSet.pageData.primary_DNS.split("."));
        DBG_ERROR("ipArray is " + objToString(ipArray));
        return ipArray;
    };

    netIpSet.setIpData = function (ipListArray) {
        netIpSet.pageData.ipAddress = ipListArray[0] + "." + ipListArray[1] + "." + ipListArray[2] + "." + ipListArray[3];
        netIpSet.pageData.subnet_Mask = ipListArray[4] + "." + ipListArray[5] + "." + ipListArray[6] + "." + ipListArray[7];
        netIpSet.pageData.default_Gateway = ipListArray[8] + "." + ipListArray[9] + "." + ipListArray[10] + "." + ipListArray[11];
        netIpSet.pageData.primary_DNS = ipListArray[12] + "." + ipListArray[13] + "." + ipListArray[14] + "." + ipListArray[15];
    };

    switchBar.onkey_DOWN = function() {
        UI.focusTo(tiles1First);
    };
    okBtn.onkey_UP = function() {
        UI.focusTo(tiles1Last);
    };

    switchBar.onkey_ENTER = function() {
        if (netIpSet.pageData.ipConfigType == 0) {  //�Զ����ֶ�
            netIpSet.pageData.ipConfigType = 1;
            UI.setImage(switchIcon, "FTE/"+GLOBAL.LAUNCHER_BRAND +"/fte_tggl_on.png");
            nameText.alpha = 1;
            tiles1.alpha = 1;
            tiles2.alpha = 0.7;
            switchBar.onkey_DOWN = function() {
                UI.focusTo(tiles1First);
            };
            okBtn.onkey_UP = function() {
                UI.focusTo(tiles1Last);
            };
                       
        } else if (netIpSet.pageData.ipConfigType == 1) {   //�ֶ����Զ�
            netIpSet.pageData.ipConfigType = 0;
            UI.setImage(switchIcon, "FTE/fte_tggl_off.png");
            clearIpAddress();
            nameText.alpha = 0.3;
            tiles1.alpha = 0.3;
            tiles2.alpha = 0.3;
            switchBar.onkey_DOWN = function() {
                UI.focusTo(okBtn);
            };
            okBtn.onkey_UP = function() {
                UI.focusTo(switchBar);
            };
        }
        UI.updateStage();
    };

    for (var i = 0; i < tiles1.initSequence.length; i++) {
        tiles1.initSequence[i].onkey_ENTER = function(focus) {
            netIpSet.pageData.tilesIndex = tiles1.initSequence.indexOf(focus);
            UI.pushSubModule("FTE", "fte_netIpInputPanel", true);
        };
    }

    //tiles1�����˳����,ʹ��initSequence
    okBtn.onkey_ENTER = function() {
        try {
            for (var i = 0; i < tiles1.initSequence.length; i++) {
                if (tiles1.initSequence[0].children[0].children[1].text === "" ||
                    tiles1.initSequence[0].children[0].children[1].text === undefined ||
                    tiles1.initSequence[0].children[0].children[1].text === null) {
                    //����0��OK�ġ�"", undefined, null ����
                    return;
                }
            }

            if (netIpSet.pageData.ipConfigType == 1) {  //�ֶ�IP
                FTE.networkStartLoading("netIpSet", 5000);
                DBG_INFO("netIpSet: " + netIpSet.pageData.ipConfigType);
                saveIpAddress();
                DBG_INFO("FTE ipaddress: " + netIpSet.pageData.ipAddress);
                DBG_INFO("FTE subnet_Maspek: " + netIpSet.pageData.subnet_Mask);
                DBG_INFO("FTE default_Gateway: " + netIpSet.pageData.default_Gateway);
                DBG_INFO("FTE primary_DNS: " + netIpSet.pageData.primary_DNS);
                DBG_INFO("FTE secondary_DNS: " + netIpSet.pageData.secondary_DNS);
                if (tv == true) {
//                    model.network.setEnumIp_config(netIpSet.pageData.ipConfigType);
                    model.network.setEnumIp_config(NetWorkIpConfig.MANUAL);
                    model.network.setIp_address(netIpSet.pageData.ipAddress);
                    model.network.setSubnet_mask(netIpSet.pageData.subnet_Mask);
                    model.network.setGateway(netIpSet.pageData.default_Gateway);
                    model.network.setDns_server_1(netIpSet.pageData.primary_DNS);
//                    model.network.setDns_server_2(netIpSet.pageData.secondary_DNS);
                    DBG_INFO("FTE netIpSet start connect...");
                    if (network.netType == NetWorkType.ETHER) { //����
                        setTimeout(showEtherIpSetResult, 5000);   //5�����ʾ���
                        model.network.WiredSet();
                    }
                    else {                      //wifi & �ֶ�IP
                        netWifiResult.fteNetSetWifiStartConnNetwork(1);
                    }
                }
            }else {  //netIpSet.pageData.ipConfigType == 0   //DHCP�Զ�IP
                if (network.netType == NetWorkType.ETHER) {
                    popSubModuleUntil("fte_network");
                    network.searchEthernet();
                }
                else {  //network.netType == NetWorkType.WIRELESS  �������Զ�����
                    popSubModuleUntil("fte_netWifiResult");
                    netWifiResult.fteNetSetWifiStartConnNetwork(0);
                }
            }
        } catch (ex) {
            DBG_INFO("FTE netIpset info: " + ex.message);
        }
    };

    function showEtherIpSetResult() {
        FTE.networkEndLoading("netIpSet");
        var ipResult = tv? model.network.getEnumNetworkAvailable(): 0;
        DBG_INFO("IpResult is " + ipResult);
        if (network.netType == NetWorkType.ETHER) {
            if (ipResult == 1) {    //success
                network.showEthBtnFinishPage();
            }
            else {                  //fail
                network.showEthBtnNoConnectPage();
            }
        }
    }

    function netSetEtherIpStateCallBack(state){
        DBG_ALWAYS("netSetEtherIpStateCallBack:"+state);
        switch (state){
            case 3://idle
//                var currConfigType = netIpSet.pageData.ipConfigType;
                getAndShowIp();
                showIpAddress();
//                netIpSet.pageData.oriIpConfigType = netIpSet.pageData.ipConfigType;
//                if(currConfigType != opData.ipConfigType){
//                    DBG_ALWAYS("settingNetSetEtherIpNetworkOnChange:"+currConfigType+","+opData.ipConfigType);
//                    netIpSet.pageData.ipConfigType = currConfigType;
//                }
                break;
            case 4://update
                break;
            case 9://not available
                break;
            default :
                break;
        }
    }

    function fteNetSetStartSearchEthernet(){
        var data = network.ethernetData;
        try{
            if(tv == false){
                fteNetworkSetCreateEtherentResultPage();
            }else{
//                model.network.setEnumNetworkConfig(1);  //0:�ر�����, 1:������
                model.network.setEnumNetworking(0);//0:Ehternet,1:Wireless
                var ethSearState = model.network.getEnumNetworkAvailable(); //1��success, 0��fail
                DBG_INFO("[FTE ethernet] ethSearState is " + ethSearState);
                if(ethSearState != 1){
                    //���¿�ʼ����
                    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_CHANGED, getEthernetResult);
                }else{
                    fteNetworkSetCreateEtherentResultPage();
                }
            }
        }catch (ex){
            DBG_ERROR("fteNetSetStartSearchEthernet: " + ex.message);
        }
    }

    function getAndShowIp(){
        if (tv) {
            DBG_INFO("fte_netIpSet: get ip from tv");
//            netIpSet.pageData.ipConfigType = model.network.getEnumIp_config();
            netIpSet.pageData.ipAddress = model.network.getIp_address();
            netIpSet.pageData.subnet_Mask = model.network.getSubnet_mask();
            netIpSet.pageData.default_Gateway = model.network.getGateway();
            netIpSet.pageData.primary_DNS = model.network.getDns_server_1();
            if (netIpSet.pageData.ipAddress == "") {
                netIpSet.pageData.ipAddress = "...";
            }
            if (netIpSet.pageData.subnet_Mask == "") {
                netIpSet.pageData.subnet_Mask = "...";
            }
            if (netIpSet.pageData.default_Gateway == "") {
                netIpSet.pageData.default_Gateway = "...";
            }
            if (netIpSet.pageData.primary_DNS == "") {
                netIpSet.pageData.primary_DNS = "...";
            }
        }
        /*if(ipConfigType == NetWorkIpConfig.DHCP){
         netIpSet.pageData.setIpInputDisable(true);
         }else{
         netIpSet.pageData.setIpInputDisable(true);
         }*/
//        showIpAddress();
    }

    function showIpAddress() {
        var netIpArray = [];
        netIpArray = netIpArray.concat(netIpSet.pageData.ipAddress.split("."));
        netIpArray = netIpArray.concat(netIpSet.pageData.subnet_Mask.split("."));
        netIpArray = netIpArray.concat(netIpSet.pageData.default_Gateway.split("."));
        netIpArray = netIpArray.concat(netIpSet.pageData.primary_DNS.split("."));

        DBG_ERROR("showIpAddress is " + objToString(netIpArray));

        for (var i = 0; i < netIpArray.length; i++) {
            tiles1.initSequence[i].children[0].setText(netIpArray[i]+'');
//            tiles1.initSequence[i].children[0].children[1].text  = netIpArray[i]+'';
            DBG_ERROR(" tiles1.initSequence[i].children[1].text is " +  tiles1.initSequence[i].children[0].children[1].text);

        }
        UI.updateStage();
    }

    function clearIpAddress() {
        tiles1.alpha = 0;
       /* for (var i = 0; i < tiles1.initSequence.length; i++) {
            tiles1.initSequence[i].children[1].text  = '';
        }*/
        UI.updateStage();
    }

    function showDhcpResult() {
        var dhcpResult = tv? model.network.getEnumNetworkAvailable(): 0;
        if (dhcpResult != 1) {
            network.showEthBtnNoConnectPage();
        }
    }

};