// Init
UI.moduleBuilder['FTE']['fte_netAddWifi'] = function(){
    var netAddWifiData = {
        inputBgImg: "FTE/fte_txt_fld_long_standard.png",
        inputBox: "",
        noTextHint: "[SE3014]",//Press OK button  open keyboard
        text1: "[SE0168]",  //"Security",
        connectBtnText: "[SE0187]", //"Connect",
        skipBtnText: "[FTE0031]",   //"Skip network setup",
        cancelText:"[SE3067]",
        tilesBgImg: UI.list_bg,
        connectBtnImg: UI.item_bg,
        skipBtnImg: UI.item_bg
    };
    var template = Util.readJson("module/FTE/fte_netAddWifi.json");
    var netAddWifi = SubModule.create(netAddWifiData, template);

    var DataAddHidden = "[SE3091]";//Add a hidden network
    var DataAddWifiHelp = "[SE3092]";//If you have set your network to not broadcast its name, connect to it by enter the network details.

    netAddWifi.pageData={
        "operateData":{
            "currSSID":"",
            "currSecTypeIdx": 0,
            "wifiSecTypeList": [
                "[BR0081]",         //"Open",
                "WEP",
                "WPA PSK (TKIP)",
                "WPA2-PSK(AES)",
                "WPA-PSK(AES)",
                "WPA2-PSK(TKIP)"
            ],
            "secAuthMapList":[
                {
                    "security":0,
                    "authentication":0
                },
                {
                    "security":4,
                    "authentication":4
                },
                {
                    "security":2,
                    "authentication":2
                },
                {
                    "security":3,
                    "authentication":3
                },
                {
                    "security":5,
                    "authentication":5
                },
                {
                    "security":6,
                    "authentication":6
                }
            ]
        }
    };

    var network = UI.getSubModule("fte_network");
    var netWifiResult = UI.getSubModule("fte_netWifiResult");
    var inputField = UI.getItem(netAddWifi, "inputField");
    var inputBox = UI.getItem(netAddWifi, "inputBox");
    var noTextHint = UI.getItem(netAddWifi, "noTextHint");
    var secTiles = UI.getItem(netAddWifi, "secTiles");
    var connectBtn = UI.getItem(netAddWifi, "connectBtn");
    var skipBtn = UI.getItem(netAddWifi, "skipBtn");

    //�����ı������
    var textInfo = {
        initVal : "",
        maxLength : 63,
        maxWidth: 1128,
        fontSize : 36,
        isPwd : false,
        color : "#AAAAAA"
    };
    TextBox.create(inputBox, textInfo, onTextChanged);

    function onTextChanged() {
        DBG_ERROR("inputBox.children[0].realValue.length is " + inputBox.children[0].realValue.length );
        if (inputBox.children[0].realValue.length != 0) {
            noTextHint.alpha = 0;
            connectBtnDisableOrNot(1);
        }
        else {
            noTextHint.alpha = 0.5;
            connectBtnDisableOrNot(0);
        }
        DBG_INFO("sw value changed!");
    }

    inputField.onFocus = function(focus){
        UI.base.cursor.alpha = 0;
        UI.getTween(UI.base.cursor).set({alpha: 0});
        inputBox.active();
//        focus.uncache();
        return false;
    };
    inputField.onNormal = function(focus){
        inputBox.inactive();
//        focus.cache(0, 0, focus.getBounds().width, focus.getBounds().height);
        return true;
    };
    inputField.onkey_RIGHT = function() {
        inputBox.cursorRight();
    };
    inputField.onkey_LEFT = function() {
        inputBox.cursorLeft();
    };
    inputField.onkey_ENTER = function() {
        inputBox.showKeyBoard();
    };

    var proIpNumKey = function() {
        var value = CONST.NUMIPT_VALUE[UI.currKeyValue];
        inputBox.children[0].realValue = inputBox.makeText(value);
        inputBox.setText(inputBox.children[0].realValue);
        inputBox.cursorRight();
        if (inputBox.children[0].realValue.length != 0) {
            noTextHint.alpha = 0;
        }
        else {
            noTextHint.alpha = 0.5;
        }
        DBG_INFO("value changed!");
        netAddWifi.pageData.operateData.currSSID = inputBox.children[0].realValue;
        if (inputBox.children[0].realValue.length != 0) {
            noTextHint.alpha = 0;
            connectBtnDisableOrNot(1);
        }
        else {
            noTextHint.alpha = 0.5;
            connectBtnDisableOrNot(0);
        }

    };
    inputField.onkey_ZERO = proIpNumKey;
    inputField.onkey_ONE = proIpNumKey;
    inputField.onkey_TWO = proIpNumKey;
    inputField.onkey_THREE = proIpNumKey;
    inputField.onkey_FOUR = proIpNumKey;
    inputField.onkey_FIVE = proIpNumKey;
    inputField.onkey_SIX = proIpNumKey;
    inputField.onkey_SEVEN = proIpNumKey;
    inputField.onkey_EIGHT = proIpNumKey;
    inputField.onkey_NINE = proIpNumKey;

    var array = [];
    for (var i=0; i < netAddWifi.pageData.operateData.wifiSecTypeList.length; i++) {
        array.push({});
        array[i].name = "secType" + i;
        array[i].bgImg = UI.item_bg;
        array[i].selectedImg = "FTE/fte_checkmark.png";
        array[i].secTypeName = netAddWifi.pageData.operateData.wifiSecTypeList[i];
    }

    var info = {
        template : "fte_addWifi_item",
        direction : CONST.GIRD_DIRECTION.H,
        breakNum : 1,
        distanceX : 0,
        distanceY : 6,
        container : secTiles,
        x : 0,
        y : 0
    };
    Gird.create(array, info);
    var secTypeFirst = UI.getItem(secTiles, "secType0");
    var secTpyeLast = UI.getItem(secTiles, "secType" + (secTiles.children.length-1));
    secTiles.DataSelected = secTiles.children[netAddWifi.pageData.operateData.currSecTypeIdx];

    fteDefaultSelect(secTiles);

    netAddWifi.currFocus = UI.getItem(netAddWifi, "inputField");

    function connectBtnDisableOrNot(flag) {

        if (!flag) {    //connectBtn disable
            connectBtn.alpha = 0.2;
            connectBtn.disableFlag = 1;
            secTpyeLast.downTo = skipBtn.name;
        }
        else {
            connectBtn.alpha = 1;
            connectBtn.disableFlag = 0;
            secTpyeLast.downTo = connectBtn.name;
        }

    }

//})();

/*---------------------------------------Actions-------------------------------------------------------*/
//(function(){
    var background = UI.getSubModule("fte_background");

    netAddWifi.onPush = function () {
        showSkipEleOrNot(0);
        changeNetworkHelpText(DataAddWifiHelp);
        inputBox.children[0].realValue = "";
        inputBox.setText(inputBox.children[0].realValue);
        inputBox.cursorLeft();
        onTextChanged();
        secTiles.DataSelected = secTiles.initSequence[0];
        var data = netAddWifi.pageData;
        data.operateData.currSecTypeIdx = 0;
        fteDefaultSelect(secTiles);
        elementShow(netAddWifi);
    };

    netAddWifi.afterPush = function() {
        UI.focusTo(inputField);
    };

    secTiles.onkey_ENTER = function() {
        var data = netAddWifi.pageData;
        fteGirdSelect(secTiles);
        data.operateData.currSecTypeIdx = secTiles.initSequence.indexOf(UI.getCurrFocus());
        DBG_INFO("netAddWifi: wifi security type index is " + data.operateData.currSecTypeIdx);
        if (!connectBtn.disableFlag) {
            UI.focusTo(connectBtn);
        }
    };

    connectBtn.onkey_ENTER = function() {
        DBG_INFO("netAddWifi: connect to added wifi");
        fteNetSetWifiAdd();
    };
    skipBtn.onkey_ENTER = function() {
        //�����������
        UI.popSubModule();  //pop��fte_netAddWifi
        UI.popSubModule();  //pop��ft_netWifiResult
        network.skipNetworkSet();
    };


    //����
    netAddWifi.onkey_BACKSPACE = function() {
        UI.popSubModule();
        elementShow(netWifiResult);
    };
    inputField.onkey_DOWN = function() {
        //��ȡwifi���
        var data = netAddWifi.pageData;
        data.operateData.currSSID = inputBox.children[0].realValue;
        DBG_INFO("netAddWifi: wifi input ssid is " + data.operateData.currSSID);
        UI.focusTo(secTypeFirst);
    };
    connectBtn.onkey_UP = function() {
        UI.focusTo(secTpyeLast);
    };
    skipBtn.onkey_UP = function() {
        UI.focusTo(secTpyeLast);
    };
    skipBtn.onkey_LEFT = function(){
        if(connectBtn.disableFlag == 0){
            UI.focusTo(connectBtn);
        }
    };

    function fteNetSetWifiAdd(){
        try{
            var data = netAddWifi.pageData;
            var inputSSID = data.operateData.currSSID;
            DBG_INFO("fteNetSetWifiAdd: inputSSID = " + inputSSID);
            if(inputSSID.length > 0){
                if(tv == true){
                    model.network.setLink_quality(100);
                }
                data.operateData.currSSID = inputSSID;
                if(data.operateData.currSecTypeIdx == 0){
                    DBG_INFO("fteNetSetWifiAdd: wifi type is open!!");
                    //û�����룬����netWifiResult.connectData��ֱ������
                    netWifiResult.fteSetNetSetWifiConnPara(getFteNetSetWifiAddConnPare());
                    //��ʼ��������wifi
                    netWifiResult.fteNetSetWifiStartConnNetwork();
                }else{
                    DBG_INFO("fteNetSetWifiAdd: create add wifi input page");
                    //�����룬����netWifiResult.pageData��������������
                    var wifiConnPare = getFteNetSetWifiAddConnPare();
                    netWifiResult.fteWifiSetPageDataConnPare(wifiConnPare.SSID, wifiConnPare.secType, wifiConnPare.authType, 100);

                    elementHide(netAddWifi);
                    netWifiResult.pageData.operateData.clearPassword = true;
                    UI.pushSubModule("FTE", "fte_netWifiInput", true);
                    /*UI.inactiveKey();
                    if (Config.tv) {
                        UI.isSoftKeyBoard = true;
                    } else {
                        UI.inactiveKey();
                        document.onkeydown = UI.onKeyBoardForSoft;
                    }
                    startIQQI.call({
                        "value": "",
                        "position": 0,
                        "maxLength": 20,
                        "curLang": "ENG",
                        "curMode": 0,
                        "viewType": 0 == 1 ? "password" : "text",
                        "workType": 0 == 1 ? "password" : "text",
                        "callback": function() {
                            if (Config.tv) {
                                UI.isSoftKeyBoard = false;
                            } else {
                                document.onkeydown = UI.onKeyBoard;
                            }

                            UI.updateStage();
                            UI.activeKey();

                            var password = this.value; //�õ�����
                            DBG_INFO("[zhangnaiyun add wifi] input password -------------> " + password);
                            netWifiResult.fteSetNetSetWifiConnPara(getFteNetSetWifiAddConnPare());
                            netWifiResult.connectData.operateData.password = password;

                            //��ʼ��������wifi
                            netWifiResult.fteNetSetWifiStartConnNetwork();

                        }
                    });*/
                }
            }else{
                DBG_ERROR("fteNetSetWifiAdd: inputSSID is null!!");
            }
        }catch (ex){
            DBG_ERROR("fteNetSetWifiAdd: " + ex.message);
        }
    }

    function getFteNetSetWifiAddConnPare(){
        var data = netAddWifi.pageData;
        var wifiConnPare ={
            "SSID":"",
            "secType":0,
            "authType":1,
            "password":""
        };
        wifiConnPare.SSID = data.operateData.currSSID;
        wifiConnPare.secType =data.operateData.secAuthMapList[data.operateData.currSecTypeIdx].security;
        wifiConnPare.authType = data.operateData.secAuthMapList[data.operateData.currSecTypeIdx].authentication;
        wifiConnPare.password = "";
        if(tv == true){
            var currWifiState = model.network.getEnumLink();
            if(currWifiState == 0){
                var connSSID = model.network.getSsid();
                if(connSSID == data.operateData.currSSID){
                    wifiConnPare.password =  model.network.getEncryptionPassphrase();
                    DBG_INFO("getFteNetSetWifiAddConnPare: password = " + wifiConnPare.password);
                }
            }
        }
        return wifiConnPare;
    }
};