UI.moduleBuilder['FTE']['fte_logReport'] = function(){
    /*default data*/
    var template = Util.readJson("module/FTE/fte_logReport.json");
    var TipData = {
        network_bg: UI.window_bg,
        btn_left_bg: UI.item_bg,
        btn_right_bg: UI.item_bg,
        btn_right_text: "[SE2972]",//Send Diagnostics and Usage
        btn_left_text: "[GE0008]",
        tipContent:"[SE3877]",//Help improve Hisense TV and service
        tipSubContent:"[SE3881]"
    };

    var logReportTip = SubModule.create(TipData, template);
    var BtnRight = UI.getItem(logReportTip, "BtnRight");
    var BtnLeft = UI.getItem(logReportTip, "BtnLeft");
    logReportTip.currFocus = BtnLeft;
//    BtnRight.alpha = BtnLeft.alpha = 0.6;
    var fteBackground = UI.getSubModule("fte_background");

    logReportTip.onPush = function(){
        var flag = tv ? model.basicSetting.getImproveHis() :0;
        DBG_ERROR("flag is " + flag);
        logReportTip.currFocus = flag ? BtnRight : BtnLeft;
        UI.clearFteMenuTimeout();
        UI.clearEnterEulaTimeout();
        UI.clearEnterStoreTimeout();
        fteBackground.alpha = 0;
        UI.updateStage();
    };

    logReportTip.onPop = function(){
        FTE.play4kVideo();
    };

    logReportTip.onkey_BACKSPACE = function(){
        return false;
    };

    BtnLeft.onkey_ENTER = function(){
        exitReport(0);

    };

    BtnRight.onkey_ENTER = function(){
        exitReport(1);
    };

    function exitReport(flag){
        if(tv){
            model.basicSetting.setImproveHis(flag);
        }
        UI.popSubModule();
    }



//    BtnRight.onkey_ENTER = networkTip.onkey_ESCAPE = networkTip.onkey_BACKSPACE = closeNetworkTip;
};