/**
 * Created by jiangbo1 on 2016/4/29.
 */
(function () {

    var epgMainData = {
        epgTitleImg: GLOBAL.FREEVIEW_VERSION ? GLOBAL.IMAGE_LIST.FREEVIEW_LOGO : GLOBAL.IMAGE_LIST.NONE,
        epgTitleText: "Guide",
        epgCurrentTime: "",
        epg_left_bg: "EPG/epgMain/epg_left_panel.png",//{color: "#222536"}
        epg_right_bg: GLOBAL.IMAGE_LIST.EPG_RIGHT_BG,
        epg_shadow_bg: GLOBAL.IMAGE_LIST.EPG_SHADOW_VERTICAL,
        epg_win_ch_bg: GLOBAL.IMAGE_LIST.EPG_BLACK_BG,
        epg_crnt_list_bg: GLOBAL.IMAGE_LIST.EPG_LIST_BG,
        epgGreenBG: GLOBAL.IMAGE_LIST.EPG_GREEN,
        epgPurpleBG: GLOBAL.IMAGE_LIST.EPG_PURPLE,
        epgRedBG: GLOBAL.IMAGE_LIST.EPG_RED,
        epgGreenName: "",
        epgPurpleName: "",
        epgRedName: "",
        epg_time_axis_bg: GLOBAL.IMAGE_LIST.EPG_HILIGHT_BG,
        epg_time_axis_border_1: GLOBAL.IMAGE_LIST.EPG_WHITE_BG,
        epg_time_axis_border_2: GLOBAL.IMAGE_LIST.EPG_WHITE_BG,
        epgLeftArrow: GLOBAL.IMAGE_LIST.EPG_LEFT_ARROW,
        epgRightArrow: GLOBAL.IMAGE_LIST.EPG_RIGHT_ARROW,

        epg_opt_bg: GLOBAL.IMAGE_LIST.EPG_HILIGHT_BG,
        epgOptChImage: GLOBAL.IMAGE_LIST.EPG_CH_IMAGE,
        epgOptInfoImage: GLOBAL.IMAGE_LIST.EPG_INGO_IMAGE,
        epgOptBlueImage: GLOBAL.IMAGE_LIST.BLUE40,
        epgOptYellowImage: GLOBAL.IMAGE_LIST.YELLOW40,
        epgOptGreenImage: GLOBAL.IMAGE_LIST.GREEN40,
        epgOptRedImage: GLOBAL.IMAGE_LIST.RED40,
        epgOptChText: "[TV0052]",
        epgOptInfoText: "[TV0010]",
        epgOptRedText: "[TV0053]",
        epgOptGreenText: "[TV0125]",
        epgOptBlueText: "24h +",
        epgOptYellowText: "24h -",
        epg_timeline_bg: GLOBAL.IMAGE_LIST.EPG_TIMELINE

    };

    var template = Util.readJson("module/EPG/epgMain.json");
    var epgMain = SubModule.create(epgMainData, template);

    var epgChPanel, epgPrgrmPanel, epgCrntTime, epgCrntPrgrmDetail, epgTimelinePanel,
        epgCrntPrgrmName, epgCrntPrgrmTime, epgWinChTip, epgCrntChannel,
        epgPurpleName, epgGreenName, epgRedName, epgCrntListName, epgAxisPanel;
    var myEnum = 0, ccControl = -1, enableThemeColor = true, baseAlpha = 0.6;


    var epgChannelIterator, epgEventIterator = [], epgEventOneWinIterator, currentChannel = {}, currentList = {};
    var channelMaxRows = 5, programMaxCols = 10, maxDay = 7, totalSeconds = 3600 * 3, totalWidth = 1345;
    var startIndex = 0, channelIndex = 0, programIndex = 0, currentPlayIndex = [];
    var currentTime, baseLine, startLine, endLine, leftEdge, rightEdge;
    //todo startLine record now,endline record the end time of this page;both baseline and leftEdge record init time
    //todo rightEdge record epg max time for operate
    var readedCount = 0, timeLineBaseL = 572, timeLineTimer = 0;
    var flipFlag = FLIPMODE.NONE, epgUpdateQue = [];
    var minEventWidth = 30 + 30 + 48 + 20, eventBorder = 3 * 2;
    var oprtData = {
        currentUTC: 0,
        colorTheme: [
            'Movie', 'News', 'Shows',
            'Sport', 'Kids', 'Music',
            'Arts', 'Social', 'Education',
            'Hobby', 'Series', 'Others'
        ],
        themeValue: [0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xA, 0xB, 0xC],
        themeIndex: [0, 1, 2],
        channels: []
    };

    var CHITEM = {
        BG: myEnum++,
        BORDER: myEnum++,
        NUMBER: myEnum++,
        LOGO: myEnum++,
        NAME: myEnum++,
        ENCRYPT: myEnum++,
        LOCK: myEnum
    }
    myEnum = 0;
    var PRGRMITEM = {
        BG: myEnum++,
        NAME: myEnum++,
        BOOK: myEnum++,
        THEME: myEnum
    }
    function resetCurrentPlayIndex(initData){
        try{
            currentPlayIndex=[];
            for (var i=0;i<channelMaxRows;i++){
                currentPlayIndex.push(parseInt(initData));
            }
        }catch(ex){DBG_ERROR('refreshCurrentPlayIndex is error:'+ex.message)}
    }

    function setChPanelData() {
        for (var i = 0; i < channelMaxRows; i++) {
            var children = epgChPanel.initSequence[i].children;
            var chnl = oprtData.channels[startIndex + i];
            UI.setTextColor(children[CHITEM.NAME], "#ffffff");
            UI.setTextColor(children[CHITEM.NUMBER], "#ffffff");
            if (chnl) {
                epgChPanel.initSequence[i].alpha = 1;
                setLiveTVText(children[CHITEM.NUMBER], chnl.number);
                setLiveTVText(children[CHITEM.NAME], chnl.name);
                setLiveTVImage(children[CHITEM.LOGO], chnl.logo ? chnl.logo : GLOBAL.IMAGE_LIST.NONE);
                setLiveTVImage(children[CHITEM.ENCRYPT], chnl.isEncryt ? GLOBAL.IMAGE_LIST.ENCRYPT48 : GLOBAL.IMAGE_LIST.NONE);
                setLiveTVImage(children[CHITEM.LOCK], chnl.isLock ? GLOBAL.IMAGE_LIST.LOCK48 : GLOBAL.IMAGE_LIST.NONE)
            }
            else {
                epgChPanel.initSequence[i].alpha = 0;
                //setLiveTVText(children[CHITEM.NUMBER], "");
                //setLiveTVText(children[CHITEM.NAME], "");
                //setLiveTVImage(children[CHITEM.LOGO], GLOBAL.IMAGE_LIST.NONE);
                //setLiveTVImage(children[CHITEM.ENCRYPT], GLOBAL.IMAGE_LIST.NONE);
                //setLiveTVImage(children[CHITEM.LOCK], GLOBAL.IMAGE_LIST.NONE);
            }
            if (i == channelIndex - startIndex) {
                setLiveTVImage(children[CHITEM.BG], GLOBAL.IMAGE_LIST.EPG_HILIGHT_BG);
            }
            else {
                setLiveTVImage(children[CHITEM.BG], GLOBAL.IMAGE_LIST.NONE);
            }
        }
    }

    function initEPGData() {
        currentChannel = liveTV.getEPGCurrentChannel();
        if (null == currentChannel || currentChannel.channelIndex < 0) return false;
        currentList = currentChannel.list;
        startIndex = channelMaxRows * Math.floor(currentChannel.channelIndex / channelMaxRows);
        channelIndex = currentChannel.channelIndex;
        programIndex = 0;
        resetCurrentPlayIndex(0);
        flipFlag = FLIPMODE.START;
        return true;
    }

    function initTVState() {
        if (!Config.tv) return;
        if ("SA" == GLOBAL.CURRENT_AREA) {//todo close caption interface for sa
            if (ccControl == -1) {
                ccControl = model.closedcaption.getControl();
                //ginga.GingaStop();
                model.closedcaption.setControl(0);
            }
        }
        else {
            model.system.setCurChannelSubtitleStatus(2);//todo close caption interface for others
        }
        pauseHBBTV();//prevent conflicts
        if (GLOBAL.FREEVIEW_VERSION) {
            model.epg.setBarkerChannelActive(parseInt(currentChannel.channelId));//todo freeView authentication flag
        }
        setMheg5Status(0xe);//Hex
    }

    function initTimeLineTimer() {
        epgTimelinePanel.x = timeLineBaseL + durationTimeToWidth(currentTime - baseLine);
        clearInterval(timeLineTimer);
        timeLineTimer = setInterval(refreshTimeLine, 30 * 1000);
    }

    function initTimeLine() {
        recheckDSTSeconds();//todo recheck daylight saving time
        currentTime = getDVBLongTime();//todo get Data Rate time if it is tv
        var d = (new Date((currentTime + GLOBAL.TIMEZONE_SECONDS) * GLOBAL.MILLIBASE));
        //todo add local timezone for create date
        d.setUTCMinutes(0);//todo reset minute
        d.setUTCSeconds(0);//todo reset second
        d.setUTCMilliseconds(0);//todo reset millisecond
        baseLine = d.getTime() / GLOBAL.MILLIBASE - GLOBAL.TIMEZONE_SECONDS;//todo baseLine record init time
        startLine = baseLine;//todo startLine record now
        endLine = startLine + totalSeconds;
        leftEdge = baseLine;//todo record init time
        rightEdge = baseLine + ((24 - d.getUTCHours()) + maxDay * 24) * 3600;//todo epg max time for operate
        initTimeLineTimer();
    }

    function refreshTimeAxises() {
        if (currentTime < baseLine) {
            DBG_ERROR("current time changed error. current[" + currentTime + "], base[" + baseLine + "]");
            closeEPGModule();
            openLiveTVModule([Msg.INFO, 0]);
            return false;
        }
        else {
            epgTimelinePanel.x = timeLineBaseL + durationTimeToWidth(currentTime - baseLine);
            UI.setText(UI.getItem(epgTimelinePanel, "epgTimelineText"), UTCToLocalTime(currentTime));
            return true;
        }
    }

    function refreshTimeLine() {
        currentTime = getDVBLongTime();
        DBG_INFO("refresh epg time line[" + currentTime + "]");

        if (currentTime >= baseLine + totalSeconds) {
            DBG_INFO("epg opened more than 3 hours, auto close.");
            closeEPGModule();
            openLiveTVModule([Msg.INFO, 0]);
        }
        else {
            if (!refreshTimeAxises()) return;
            UI.setText(epgCrntTime, getEPGTime());
            var i, j, needUpdate = false;
            for (i = 0; i < channelMaxRows; i++) {
                var chnl = oprtData.channels[i + startIndex];
                if (!chnl || "" == chnl.uid) continue;
                for (j = 0; j < chnl.program.length; j++) {
                    var prgrm = chnl.program[j];
                    if ("" == prgrm.eventId) continue;
                    if (isCurrentPlay(prgrm.startTime, prgrm.endTime)) {
                        if (currentPlayIndex[i] != j) needUpdate = true;
                        currentPlayIndex[i] = j;
                        break;
                    }
                }
            }
            if (needUpdate) rewriteEPGUI();
        }
    }

    function getEPGTime() {
        recheckDSTSeconds();
        // var utcdate = new Date((currentTime + hisenseUITZSeconds + hisenseUIDSTSeconds) * milliBase);
        var utcdate = new Date(getLocalTimeByUTC(currentTime) * GLOBAL.MILLIBASE);
        var formatHour = getHourByFormat(utcdate.getUTCHours(), GLOBAL.TIME_FORMAT);
        var localtime = formatHour.HOUR + ':' + ("0" + utcdate.getUTCMinutes()).slice(-2) + formatHour.APM.replace(/\s+$/, '');
        var localweek = CONST.SHORT_WEEK[utcdate.getUTCDay()];
        var localdate = ('0' + utcdate.getUTCDate()).slice(-2) + ", " + CONST.SHORT_MONTH[utcdate.getUTCMonth()];

        if ("THA" == GLOBAL.CURRENT_COUNTRY) {
            localdate += (" " + utcdate.getUTCFullYear());
        }

        return localtime + " " + localweek + " " + localdate;
    }

    function durationTimeToWidth(durationTime) {
        return Math.round(durationTime / totalSeconds * totalWidth);
    }

    function initThemeColor() {
        oprtData.themeIndex = [0, 1, 2];
        if (!enableThemeColor) return false;
        try {
            oprtData.themeIndex = Config.tv ? model.epg.getThemsColor() : [0, 1, 2];
            if (0 == oprtData.themeIndex[0] + oprtData.themeIndex[1] + oprtData.themeIndex[2]) {
                oprtData.themeIndex = [0, 1, 2];
                if(Config.tv) model.epg.setThemsColor(oprtData.themeIndex);
            }
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    function getChannelEvent(list) {
        UI.lockAllKeys("get channel");
        epgChannelIterator = createChannelIterator(list, onGetChannelsEvent, 1);
        if (null != epgChannelIterator) {
            epgChannelIterator.fetchTotalCount();
        }
        else {
            DBG_ERROR("create iterator error");
            UI.unlockAllKeys("get channel");
        }
    }

    function onGetChannelsEvent(list, m_event) {
        if (m_event.type == TableIterator.EVENT_TYPE_ROWS_READ) {
            if (m_event.rows.length <= 0) return;
            oprtData.channels = eventRowsToChannels(m_event.rows, list);
            currentList = list;
            if (FLIPMODE.LIST == flipFlag) {
                channelIndex = 0;
                startIndex = 0;
            }
            getProgramEvent();
            UI.unlockAllKeys("get channel");
        }
        else if (m_event.type == TableIterator.EVENT_TYPE_TOTAL_COUNT) {
            if (m_event.totalCount <= 0) {
                showMsg('', 'Selected channel list is empty.');
                UI.unlockAllKeys("get channel");
                showEPGPage();
            }
            else {
                // seekRowIndex(epgChannelIterator, startIndex, onGetChannelsEvent.bind(this, list));
                epgChannelIterator.readNextRows(m_event.totalCount);
            }

        }
        else if (m_event.type == TableIterator.EVENT_TYPE_SEEK_TO_ROW) {
            epgChannelIterator.readNextRows(channelMaxRows);
        }
    }

    function getProgramEvent() {
        try {
            DBG_INFO("start[" + startLine + "], end[" + endLine + "]");
            createjs.Tween.removeAllTweens();
            lockEPGPageKeys();
            readedCount = 0;
            programIndex = 0;
            epgEventIterator = [];
            var channelIds = "",
                serviceIds = "",
                i;
            for (i = 0; i < channelMaxRows; i++) {
                var chnl = oprtData.channels[i + startIndex];
                if (!chnl || "" == chnl.uid) continue;
                channelIds += (chnl.uid + ",");
                serviceIds += (chnl.playId + ",");
            }
            if ("" !== channelIds) {
                channelIds = channelIds.slice(0, -1);
                serviceIds = serviceIds.slice(0, -1);
                epgEventOneWinIterator = createOneActiveWinProgram(
                    channelIds, serviceIds, startLine, endLine,
                    onGetProgramEventInActiveWin);
                epgEventOneWinIterator.seekToRow(0, TableIterator.SEEK_SET);
                epgEventOneWinIterator.readNextRows(programMaxCols);
            }
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    function onGetProgramEventInActiveWin(m_event) {
        var chnl = oprtData.channels[readedCount + startIndex];
        if (null == m_event) {
            if (chnl) {
                chnl.program = getNoProgramData();
            }
            checkReadedCount(readedCount + 1);
        }
        else if (m_event.type == TableIterator.EVENT_TYPE_ROWS_READ) {
            chnl.program = eventRowsToProgram(chnl, m_event.rows);
            readedCount++;
            // DBG_ERROR("next uid: " + oprtData.channels[readedCount + startIndex].uid);
            if (readedCount == channelMaxRows) {
                checkReadedCount(readedCount);
            }
            else if (!oprtData.channels[readedCount + startIndex] || "" == oprtData.channels[readedCount + startIndex].uid) {
                // onGetProgramEventInActiveWin(null);
                checkReadedCount(channelMaxRows);
            }
            else {
                epgEventOneWinIterator.seekToRow(readedCount, TableIterator.SEEK_SET);
                epgEventOneWinIterator.readNextRows(programMaxCols);
            }
        }
    }

    function getLastVisibleProgram() {
        var i, prgrms = oprtData.channels[channelIndex].program;
        for (i = programMaxCols - 1; i >= 0; i--) {
            if ("" == prgrms[i].eventId) continue;
            if (prgrms[i].startTime < endLine) return i;
        }
        return 0;
    }

    function getFirstPlayingProgram() {
        if (startLine > baseLine) return 0;
        var i, prgrms = oprtData.channels[channelIndex].program;
        for (i = 0; i < prgrms.length; i++) {
            if ("" == prgrms[i].eventId) continue;
            if (isCurrentPlay(prgrms[i].startTime, prgrms[i].endTime)) return i;
        }
        return 0;
    }

    function isCurrentPlay(startTime, endTime) {
        return (currentTime >= startTime && currentTime <= endTime);
    }

    function checkReadedCount(cnt, uid) {
        readedCount = cnt;
        if (readedCount == channelMaxRows) {
            if (currentTime > endLine || currentTime < startLine) {
                resetCurrentPlayIndex(-1);
            }
            if (!refreshTimeAxises()) return;
            switch (flipFlag) {
                case FLIPMODE.LEFT:
                    programIndex = getLastVisibleProgram();
                    break;
                case FLIPMODE.START:
                case FLIPMODE.CHFLIP:
                case FLIPMODE.LIST:
                case FLIPMODE.DAY:
                    programIndex = getFirstPlayingProgram();
                    break;
                case FLIPMODE.UPDATE:
                    if ("undefined" != typeof uid) {
                        var idx = epgUpdateQue.indexOf(uid);
                        if (idx > -1) {
                            epgUpdateQue.splice(idx, 1);
                        }
                        if (epgUpdateQue.length > 0) {
                            //self.refreshEPGWhenTimeChanged(1, epgUpdateQue[0]);
                        }
                    }
                    programIndex = 0;
                    break;
                default:
                    break;
            }
            rewriteEPGUI();
            unLockEPGPageKeys();
            showEPGPage();
        }
    }

    function getPBBTypeColor(theme) {
        var src = GLOBAL.IMAGE_LIST.NONE;
        if (!enableThemeColor) return src;
        switch ((theme >> 4)) {
            case oprtData.themeValue[oprtData.themeIndex[0]]:
                src = GLOBAL.IMAGE_LIST.EPG_PURPLE;
                break;
            case oprtData.themeValue[oprtData.themeIndex[1]]:
                src = GLOBAL.IMAGE_LIST.EPG_GREEN;
                break;
            case oprtData.themeValue[oprtData.themeIndex[2]]:
                src = GLOBAL.IMAGE_LIST.EPG_RED;
                break;
            default:
                break;
        }
        return src;
    }

    function getProgramItem(chIdx, prgrmIdx) {
        return epgPrgrmPanel.children[chIdx - startIndex].initSequence[prgrmIdx];
    }

    function getChannelItem(chIdx) {
        return epgChPanel.initSequence[chIdx - startIndex];
    }

    function setNullProgram(chIdx, prgrmIdx) {
        var prgrms = epgPrgrmPanel.children[chIdx].initSequence;
        if (null !== prgrmIdx) {
            prgrms[prgrmIdx].alpha = 0;
            //prgrmItem = prgrms[prgrmIdx];
            //prgrmItem.children[0].alpha = 0.3;
            //setLiveTVText(prgrmItem.children[1], " ");
            //setLiveTVImage(prgrmItem.children[2], GLOBAL.IMAGE_LIST.NONE);
            //setLiveTVImage(prgrmItem.children[3], GLOBAL.IMAGE_LIST.NONE);
        }
        else {
            for (var i = 0; i < prgrms.length; i++) {
                prgrms[i].alpha = 0;
                //prgrmItem = prgrms[i];
                //prgrmItem.children[0].alpha = 0.3;
                //setLiveTVText(prgrmItem.children[1], " ");
                //setLiveTVImage(prgrmItem.children[2], GLOBAL.IMAGE_LIST.NONE);
                //setLiveTVImage(prgrmItem.children[3], GLOBAL.IMAGE_LIST.NONE);
            }
        }
    }

    function recoverProgramAlpha(prgrmItem) {
        prgrmItem.alpha = 1;
        prgrmItem.children[PRGRMITEM.BG].alpha = 0.3;
        prgrmItem.children[PRGRMITEM.NAME].alpha = baseAlpha;
        if (prgrmItem.scaleX > 1) {
            DBG_ERROR("scalex");
        }
        prgrmItem.scaleX = 1;
        prgrmItem.scaleY = 1;
    }

    function setProgramPosition(prgrmItem, width, baseX) {
        var flag=width%2;
        if(flag==1){width++;}//todo repair bug for unexpected breakLine in prgrmItem
        prgrmItem.setBounds(0, 0, width, 100);
        /*BG: myEnum++,
         NAME: myEnum++,
         BOOK: myEnum++,
         THEME: myEnum*/
        prgrmItem.children[PRGRMITEM.BG].setBounds(0, 0, width, 100);
        prgrmItem.children[PRGRMITEM.BG].children[0].setBounds(0, 0, width, 100);

        prgrmItem.children[PRGRMITEM.THEME].setBounds(0, 0, width, 8);
        prgrmItem.children[PRGRMITEM.THEME].children[0].setBounds(0, 0, width, 8);

        prgrmItem.regX = width / 2;
        prgrmItem.x = baseX + prgrmItem.regX;

        prgrmItem.children[PRGRMITEM.BOOK].x = width - 64;
        if (width < minEventWidth / 2) {
            setLiveTVText(prgrmItem.children[PRGRMITEM.NAME], " ", true);
        }
    }

    function getEPGDisplayDate(longTime) {//todo display the date in the leftedge
        var curDate = new Date(getLocalTimeByUTC(currentTime) * GLOBAL.MILLIBASE);
        var destDate = new Date(getLocalTimeByUTC(longTime) * GLOBAL.MILLIBASE);
        curDate.setUTCHours(0);
        curDate.setUTCMinutes(0);
        curDate.setUTCSeconds(0);
        curDate.setUTCMilliseconds(0);
        var timeOffset = destDate.getTime() - curDate.getTime();
        if (timeOffset >= 0 && timeOffset < 24 * 3600 * 1000) {
            return "Today";
        }
        else if (timeOffset >= -24 * 3600 * 1000 && timeOffset < 0) {
            return "Yesterday";
        }
        else if (timeOffset >= 24 * 3600 * 1000 && timeOffset < 48 * 3600 * 1000) {
            return "Tomorrow";
        }
        else {
            var d = '0' + destDate.getUTCDate();
            return d.slice(-2) + ' ' + CONST.SHORT_MONTH[destDate.getUTCMonth()];
        }
    }

    function rewriteEPGUI() {
        if (oprtData.channels.length == 0) return;
        var chnl = oprtData.channels[channelIndex];
        var crntChannel = liveTV.getCurrentChannelInfo();
        var cur_prgrm = chnl.program[programIndex];

        //var bookFlag = schedule.getIsBookingByProgram(cur_prgrm);
        cur_prgrm.reminder = false;//bookFlag.reminder;
        cur_prgrm.record = false;//bookFlag.record;
        setLiveTVText(epgCrntTime, getEPGTime());
        setLiveTVText(epgWinChTip, crntChannel.number + " " + crntChannel.name);
        setLiveTVText(epgCrntChannel, chnl.name);
        if (enableThemeColor) {
            setLiveTVText(epgGreenName, oprtData.colorTheme[oprtData.themeIndex[0]]);
            setLiveTVText(epgPurpleName, oprtData.colorTheme[oprtData.themeIndex[1]]);
            setLiveTVText(epgRedName, oprtData.colorTheme[oprtData.themeIndex[2]]);
        }

        setLiveTVText(epgCrntPrgrmName, cur_prgrm.title);
        setLiveTVText(epgCrntPrgrmTime, getProgramLocalTime(oprtData.channels[channelIndex].program[programIndex].startTime, oprtData.channels[channelIndex].program[programIndex].endTime, 4))
        setLiveTVText(epgCrntPrgrmDetail, oprtData.channels[channelIndex].program[programIndex].detail);
        setLiveTVText(epgCrntListName, currentList.name);

        var titleArr = [];
        for (var i = 0; i < 3; i++) {
            var timeOffset = (startLine + i * 3600);
            setLiveTVText(UI.getItem(epgAxisPanel, "epgAxisTime" + i), UTCToLocalTime(timeOffset));
            if (currentTime - timeOffset >= 0 && currentTime - timeOffset < 3600) {
                setLiveTVText(UI.getItem(epgAxisPanel, "epgAxisTip" + i), "On Now");
            }
            else {
                var temp = getEPGDisplayDate(timeOffset);
                if (titleArr.indexOf(temp) < 0) {
                    setLiveTVText(UI.getItem(epgAxisPanel, "epgAxisTip" + i), temp);
                    titleArr[i] = temp;
                }
                else {
                    setLiveTVText(UI.getItem(epgAxisPanel, "epgAxisTip" + i), " ");
                }
            }
        }
        UI.getItem(epgAxisPanel, "epgLeftArrow").alpha = startLine == leftEdge ? 0 : 1;
        UI.getItem(epgAxisPanel, "epgRightArrow").alpha = endLine == rightEdge ? 0 : 1;
        epgTimelinePanel.alpha = (startLine != baseLine) ? 0 : 1;
        setChPanelData();
        var rowCnt = 0;
        var chnl, prgrm, eventWidth, eventOffset, eventLen, leftEndTime, baseX;
        for (var i = 0; i < channelMaxRows; i++) {
            chnl = oprtData.channels[startIndex + i];
            if (!chnl) {
                setNullProgram(i, null);
                continue;
            }
            rowCnt++;
            eventLen = 0;
            baseX = 0;
            leftEndTime = startLine;
            for (var j = 0; j < programMaxCols; j++) {
                var prgrmItem = getProgramItem(i + startIndex, j);
                prgrm = chnl.program[j];
                if (!prgrm || "" == prgrm.eventId) {
                    setNullProgram(i, j);
                    continue;
                }

                recoverProgramAlpha(prgrmItem);

                if (isCurrentPlay(prgrm.startTime, prgrm.endTime)) {
                    currentPlayIndex[i] = j;
                    prgrmItem.children[PRGRMITEM.BG].alpha = 1;
                }
                else {
                    prgrmItem.children[PRGRMITEM.BG].alpha = 0.3;
                }

                eventWidth = durationTimeToWidth(prgrm.endTime - prgrm.startTime);
                eventOffset = durationTimeToWidth(prgrm.startTime - leftEndTime);
                //todo leftEndTime is end time of the previous item
                //todo eventOffset exists for prevent losing program item
                if (eventOffset <= 0) {
                    eventWidth += eventOffset;
                    eventOffset = 0;
                }
                //todo eventLen refer to the length which is from the begin item of this page to current item
                if (eventLen + eventOffset + eventWidth >= totalWidth) {
                //todo prevent the length of this ten programs exceed the width of this right panel
                    eventWidth = Math.max(totalWidth - eventLen - eventOffset, 0);
                    eventLen = totalWidth;
                }
                else {
                    eventLen += (eventOffset + eventWidth);
                }
                if (eventWidth < 1) eventWidth = 1;
                leftEndTime = prgrm.endTime;

                var bookFlag = {reminder: false, record: true};//schedule.getIsBookingByProgram(prgrm);
                prgrm.reminder = bookFlag.reminder;
                prgrm.record = bookFlag.record;
                prgrmItem.children[PRGRMITEM.NAME]._bounds = null;
                setLiveTVText(prgrmItem.children[PRGRMITEM.NAME],
                    prgrm.title, false,
                    Math.max(1, eventWidth - minEventWidth));//todo minEventWidth is preserved for pic

                if (eventWidth - eventBorder > minEventWidth) {
                    //todo set image of record or reminder if exist
                    if (prgrm.record) setLiveTVImage(prgrmItem.children[PRGRMITEM.BOOK], GLOBAL.IMAGE_LIST.RECORD48);
                    if (prgrm.reminder) setLiveTVImage(prgrmItem.children[PRGRMITEM.BOOK], GLOBAL.IMAGE_LIST.REMINDER48);
                }
                else {
                    setLiveTVImage(prgrmItem.children[PRGRMITEM.BOOK], GLOBAL.IMAGE_LIST.NONE);
                }
                setLiveTVImage(prgrmItem.children[PRGRMITEM.THEME], getPBBTypeColor(prgrm.theme));
                setProgramPosition(prgrmItem, eventWidth - eventBorder, baseX + eventOffset);
                baseX = prgrmItem.x + prgrmItem.regX + eventBorder;
            }
        }
    }

    function showEPGPage() {
        try {
            epgMain.currFocus = getProgramItem(channelIndex, programIndex);
            //setNextSelectedProgram(null, null, channelIndex, programIndex);
            setNextSelectedChannel(channelIndex, channelIndex);
            focusToCurrentEvent();
        }
        catch (ex) {
            //DBG_ERROR(ex.message);
        }
        flipFlag = FLIPMODE.NONE;
        UI.updateStage();
    }

    function eventRowsToChannels(rows, list) {
        var chnls = [];
        for (var i = 0; i < rows.length; i++) {
            var row = rows[i], chnl = {};
            if (row) {
                chnl.number = row[SPChannel.NUMBER];
                chnl.name = row[SPChannel.NAME];
                chnl.uid = row[SPChannel.UID];
                chnl.type = row[SPChannel.TYPE];
                chnl.attr = parseInt(row[SPChannel.ATTRIBUTE]);
                chnl.listUid = list.uid;
                chnl.satId = list.satId;
                chnl.playId = row[SPChannel.PLAYID];
                chnl.serviceType = row[SPChannel.SERVICETYPE];
                chnl.program = initProgramData();
                chnl.updateTime = 0;
                chnl.favType = getMaskValue(Mask.FAVTYPE, chnl.attr);
                chnl.isLock = getMaskValue(Mask.LOCK, chnl.attr);
                chnl.isEncrypt = getMaskValue(Mask.ENCRYPT, chnl.attr);
            }
            else {
                chnl.number = "";
                chnl.name = "";
                chnl.uid = "";
                chnl.type = "";
                chnl.attr = "";
                chnl.listUid = "";
                chnl.satId = "";
                chnl.playId = "";
                chnl.serviceType = "";
                chnl.program = initProgramData();
                chnl.favType = "";
                chnl.isLock = "";
                chnl.isEncrypt = "";
            }
            chnls.push(chnl);
        }
        return chnls;
    }

    function eventRowsToProgram(chnl, rows) {
        var prgrms = [], i, leftEnd = startLine;
        var emptyFlag = 0;
        for (i = 0; i < programMaxCols; i++) {
            var row = rows[i], prgrm = {};
            if (row) {
                prgrm.channelUid = chnl.uid;
                prgrm.playId = chnl.playId;
                prgrm.eventId = row[0];
                prgrm.title = row[1];
                prgrm.text = row[2];
                prgrm.theme = row[3];
                prgrm.startTime = parseInt(row[4]);
                prgrm.endTime = parseInt(row[5]);
                prgrm.attr = row[6];
                prgrm.detail = row[7];
                prgrm.guidance = row[8];
                prgrm.reminder = false;
                prgrm.record = false;
                if (0 && 0 == i && prgrm.startTime > startLine) {
                    prgrms.push({
                        channelUid: "",
                        playId: "",
                        eventId: "N/A",
                        title: "[TV0009]",
                        text: "[SE2734]",
                        theme: 0,
                        startTime: startLine,
                        endTime: prgrm.startTime,
                        attr: 0,
                        detail: "[SE2734]",
                        guidance: "",
                        reminder: false,
                        record: false
                    });
                }
            }
            else {
                prgrm.channelUid = "";
                prgrm.playId = "";
                prgrm.eventId = (0 === emptyFlag) ? "N/A" : "";
                prgrm.title = "[TV0009]";
                prgrm.secondaryTitle = "";
                prgrm.text = "[SE2734]";
                prgrm.theme = 0
                prgrm.startTime = leftEnd;
                prgrm.endTime = endLine > leftEnd ? endLine : (leftEnd + totalSeconds);
                prgrm.attr = 0;
                prgrm.detail = "[SE2734]";
                prgrm.guidance = "";
                prgrm.reminder = false;
                prgrm.record = false;
                emptyFlag = 1;
            }
            leftEnd = prgrm.endTime;
            prgrms.push(prgrm);
        }
        return prgrms;
    }

    function lockEPGPageKeys() {
        DBG_INFO("epg_lock");
        //hiWebOsFrame.enablePageKeys(hiWebOsFrame[self.id], []);
        UI.inactiveKey();
    }

    function unLockEPGPageKeys() {
        DBG_INFO("epg_unlock");
        UI.activeKey();
        //hiWebOsFrame.clearEnablePageKeys(hiWebOsFrame[self.id]);
    }

    function getNoProgramData() {
        var prgrms = initProgramData();
        prgrms[0] =
        {
            eventId: "N/A",
            name: "[TV0009]",
            text: "[TV0009]",
            detail: "[SE2734]",
            startTime: startLine,
            endTime: endLine
        };
        return prgrms;
    }

    function initProgramData() {
        var prgrms = [], j;
        for (j = 0; j < programMaxCols; j++) {
            prgrms.push({eventId: j + 1, name: (j + 1) + ""});
        }
        return prgrms;
    }

    function setNextSelectedChannel(destCIndex, oriCIndex) {
        var crntSelProgram = oprtData.channels[channelIndex].program[programIndex];
        var nextSelProgram, i;
        channelIndex = destCIndex;
        var oriPIndex = programIndex;
        for (i = 0; i < oprtData.channels[channelIndex].program.length; i++) {
            nextSelProgram = oprtData.channels[channelIndex].program[i];
            if (nextSelProgram.endTime > crntSelProgram.startTime) {
                programIndex = i;
                break;
            }
        }
        setLiveTVText(epgCrntChannel, oprtData.channels[channelIndex].name);

        UI.setTextColor(getChannelItem(oriCIndex).children[CHITEM.NAME], "#ffffff");
        UI.setTextColor(getChannelItem(oriCIndex).children[CHITEM.NUMBER], "#ffffff");
        UI.setTextColor(getChannelItem(destCIndex).children[CHITEM.NAME], "#00a9c2");
        UI.setTextColor(getChannelItem(destCIndex).children[CHITEM.NUMBER], "#00a9c2");

        setLiveTVImage(getChannelItem(oriCIndex).children[CHITEM.BG], GLOBAL.IMAGE_LIST.NONE);
        setLiveTVImage(getChannelItem(destCIndex).children[CHITEM.BG], GLOBAL.IMAGE_LIST.EPG_HILIGHT_BG);
        setNextSelectedProgram(oriCIndex, oriPIndex, channelIndex, programIndex);
    }

    function setNextSelectedProgram(oriC, oriP, curC, curP) {
        var nextSelProgram = oprtData.channels[channelIndex].program[curP];
        setLiveTVText(epgCrntPrgrmName, nextSelProgram.title);
        setLiveTVText(epgCrntPrgrmTime, getProgramLocalTime(nextSelProgram.startTime, nextSelProgram.endTime, 4));
        setLiveTVText(epgCrntPrgrmDetail, nextSelProgram.detail);
        programIndex = curP;
        getProgramItem(oriC, oriP).children[PRGRMITEM.NAME].alpha = baseAlpha;
        getProgramItem(curC, curP).children[PRGRMITEM.NAME].alpha = 1;
    }

    function setParamsBeforeFlip(flag) {

        startLine += flag * totalSeconds;
        if (startLine <= leftEdge) startLine = leftEdge;
        if (startLine + totalSeconds >= rightEdge) startLine = rightEdge - totalSeconds;
        endLine = startLine + totalSeconds;
    }

    function focusToCurrentEvent() {
        UI.focusTo(getProgramItem(channelIndex, programIndex));
    }


    EPG.switchList = function (list) {
        //hiWebOsFrame.startLoading(10, "epg");
        flipFlag = FLIPMODE.LIST;
        initTimeLine();
        getChannelEvent(list);
        //hiWebOsFrame[self.id].hiFocus("epg_channel_list");
    }

    EPG.refreshEPGWhenTimeChanged = function () {
        if (!isModuleOpened(EPGMDL.NAME)) return;
        if (!checkFlipMode()) {
            DBG_INFO("epg busy, update queue: " + objToString(epgUpdateQue));
            // if(epgUpdateQue.indexOf(channel_id) < 0) epgUpdateQue.push(channel_id);
            return;
        }
        flipFlag = FLIPMODE.UPDATE;
        UI.lockAllKeys("update");
        getProgramEvent();
        refreshTimeLine();
        UI.unlockAllKeys("update");
    }

    function refreshPIPChannelInfo(chnl) {
        if (!isModuleOpened(EPGMDL.NAME)) return;
        setLiveTVText(epgWinChTip, chnl.number + " " + chnl.name);
        UI.updateStage();
    }

    EPG.refreshEPGColorTheme = function (themes) {
        if (!isModuleOpened(EPGMDL.NAME)) return;
        if (oprtData.themeIndex.toString() == themes.toString()) return;
        oprtData.themeIndex = themes;
        rewriteEPGUI();
        UI.updateStage();
    }
    EPG.getCurrentThemeIndex = function(){
        return copyObj(oprtData.themeIndex);
    }

    epgMain.onPush = function () {
        if (!initEPGData()) return false;
        setWindowSize(48, 124, 474, 267);
        initTVState();
        initTimeLine();
        initThemeColor();
        initEPGElementItem();
        //schedule.getScheduleList(false);
        getChannelEvent(currentChannel.list);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CURRENT_CHANNEL_CHANGED, refreshPIPChannelInfo);
    }

    epgMain.onPop = function () {
        releaseEPGElement();
        if ("SA" == GLOBAL.CURRENT_AREA) {
            if (-1 != ccControl) {
                Config.tv && model.closedcaption.setControl(ccControl);
                ccControl = -1;
            }
        } else {
            Config.tv && model.system.setCurChannelSubtitleStatus(3);
        }
        setMheg5Status(0xf);
        clearInterval(timeLineTimer);
        setWindowSize(0, 0, 1920, 1080);
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.CURRENT_CHANNEL_CHANGED, refreshPIPChannelInfo);
    }

    epgMain.onFocus = function (target) {
        onFocusLiveTVTarget(target, 1.02, 500, true);
    };

    epgMain.onNormal = function (target) {
        onNormalLiveTVTarget(target, 1, 500, true);
    };


    epgMain.onkey_CHUP = function () {
        if (!checkFlipMode()) return false;

        if (startIndex == 0) {
            if (oprtData.channels.length <= channelMaxRows) {
                setNextSelectedChannel(oprtData.channels.length - 1, channelIndex);
                focusToCurrentEvent();
            }
            else {
                startIndex = channelMaxRows * Math.floor((oprtData.channels.length - 1) / channelMaxRows);
                channelIndex = oprtData.channels.length - 1;
                flipFlag = FLIPMODE.CHFLIP;
                getProgramEvent();
            }
        }
        else {
            startIndex -= channelMaxRows;
            channelIndex = startIndex;
            flipFlag = FLIPMODE.CHFLIP;
            getProgramEvent();
        }
        return false;

    }

    epgMain.onkey_CHDOWN = function () {
        if (!checkFlipMode()) return false;
        if (startIndex == channelMaxRows * Math.floor((oprtData.channels.length - 1) / channelMaxRows)) {
            if (oprtData.channels.length <= channelMaxRows) {
                setNextSelectedChannel(0, channelIndex);
                focusToCurrentEvent();
            }
            else {
                startIndex = 0;
                channelIndex = 0;
                flipFlag = FLIPMODE.CHFLIP;
                getProgramEvent();
            }
        }
        else {
            startIndex += channelMaxRows;
            channelIndex = Math.min(oprtData.channels.length, startIndex + channelMaxRows) - 1;
            flipFlag = FLIPMODE.CHFLIP;
            getProgramEvent();
        }
        return false;

    }

    epgMain.onkey_INFO = function () {
        //var prgrm = oprtData.channels[channelIndex].program[programIndex];
        //openEPGDetailPage(prgrm, hiWebOsFrame[self.id]);
        //DBG_TODO("openEPGDetailPage(prgrm, hiWebOsFrame[self.id])");
        UI.pushSubModule(EPGMDL.NAME, EPGMDL.DETAIL_INFO, true, null,
            oprtData.channels[channelIndex].program[programIndex]);
    }

    epgMain.onkey_ENTER = function () {
        var chnl = oprtData.channels[channelIndex];
        var prgrm = chnl.program[programIndex];
        if (prgrm.startTime > currentTime) {
            if ("" != prgrm.eventId && ("N/A" != prgrm.eventId)) {
                DBG_TODO("openBookAddOrEditPage(chnl, prgrm)");
            }
            else {
                DBG_ERROR("program startTime[" + prgrm.startTime + "], currentTime[" + currentTime + "]");
            }
        }
        else {
            if ("N/A" == prgrm.eventId) {
                var crntChannel = liveTV.getCurrentChannelInfo();
                if (!compareChannel(crntChannel, chnl)) {
                    liveTV.changeChannel(chnl);
                }
                if (GLOBAL.NO_SIGNAL) return;
                UI.lockAllKeys("refresh_epg");
                setTimeout(function () {
                    getProgramEvent();
                    UI.unlockAllKeys("refresh_epg");
                }, 1000);
            }
            else {
                if ("SA" != GLOBAL.CURRENT_AREA) {
                    closeEPGModule();//omg
                    openLiveTVModule([Msg.INFO, 0, Msg.PASSWORD, 0]);//omg-2015-11-12
                }
                liveTV.changeChannel(chnl);
            }
        }
    }

    epgMain.onkey_RED = function () {
        if (!checkFlipMode()) return;
        DBG_TODO("openBookSchedulePage();");
    }

    epgMain.onkey_GREEN = function () {
        if (!checkFlipMode()) return;
        if (enableThemeColor) {
            UI.pushSubModule(EPGMDL.NAME, EPGMDL.COLOR, true);
        }
        else {
            UI.pushSubModule(EPGMDL.NAME, EPGMDL.CHLIST, true);
        }
    }

    epgMain.onkey_YELLOW = function () {
        if (!checkFlipMode()) return false;
        if (startLine <= leftEdge) {
            DBG_INFO("reach the min day.");
        }
        else {
            setParamsBeforeFlip(-8);
            flipFlag = FLIPMODE.DAY;
            getProgramEvent();
        }
        return false;
    }

    epgMain.onkey_BLUE = function () {
        if (!checkFlipMode()) return false;
        if (endLine >= rightEdge) {
            DBG_INFO("reach the max day.");
        }
        else {
            setParamsBeforeFlip(8);
            flipFlag = FLIPMODE.DAY;
            getProgramEvent();
        }
        return false;
    }

    epgMain.onkey_RIGHT = function () {
        if (!checkFlipMode()) return false;
        var crntSelProgram = oprtData.channels[channelIndex].program[programIndex];
        if (crntSelProgram.endTime >= endLine - 60 || programMaxCols - 1 == programIndex) {
            //flip to the next page
            if (endLine < rightEdge) {
                setParamsBeforeFlip(1);
                flipFlag = FLIPMODE.RIGHT;
                getProgramEvent();
            }
            else {
                DBG_INFO("reach the right edge.");
            }
        }
        else {
            setNextSelectedProgram(channelIndex, programIndex, channelIndex, programIndex + 1);
            focusToCurrentEvent();
        }
        return false;
    }

    epgMain.onkey_LEFT = function () {
        if (!checkFlipMode()) return false;
        if (0 == programIndex) {
            //flip to the last page
            if (startLine > leftEdge) {
                setParamsBeforeFlip(-1);
                flipFlag = FLIPMODE.LEFT;
                getProgramEvent();
            }
            else {
                DBG_INFO("reach the left edge.");
            }
        }
        else {
            setNextSelectedProgram(channelIndex, programIndex, channelIndex, programIndex - 1);
            focusToCurrentEvent();
        }
        return false;
    }

    epgMain.onkey_DOWN = function () {
        if (!checkFlipMode()) return;
        if (oprtData.channels.length - 1 == channelIndex) {
            if (oprtData.channels.length <= channelMaxRows) {
                setNextSelectedChannel(0, channelIndex);
                focusToCurrentEvent();
            }
            else {
                startIndex = 0;
                channelIndex = 0;
                flipFlag = FLIPMODE.DOWN;
                getProgramEvent();
            }
        }
        else if (channelMaxRows - 1 == channelIndex - startIndex) {
            startIndex += channelMaxRows;
            channelIndex += 1;
            flipFlag = FLIPMODE.DOWN;
            getProgramEvent();
        }
        else {
            setNextSelectedChannel(channelIndex + 1, channelIndex);
            focusToCurrentEvent();
        }
        return false;
    }

    epgMain.onkey_UP = function () {
        if (!checkFlipMode()) return;
        if (0 == channelIndex) {
            if (oprtData.channels.length <= channelMaxRows) {
                setNextSelectedChannel(oprtData.channels.length - 1, channelIndex);
                focusToCurrentEvent();
            }
            else {
                startIndex = channelMaxRows * Math.floor((oprtData.channels.length - 1) / channelMaxRows);
                channelIndex = oprtData.channels.length - 1;
                flipFlag = FLIPMODE.UP;
                getProgramEvent();
            }
        }
        else if (0 == channelIndex - startIndex) {
            startIndex -= channelMaxRows;
            channelIndex -= 1;
            flipFlag = FLIPMODE.UP;
            getProgramEvent();
        }
        else {
            setNextSelectedChannel(channelIndex - 1, channelIndex);
            focusToCurrentEvent();
        }
        return false;
    }

    function checkFlipMode() {
        if (FLIPMODE.NONE != flipFlag) {
            DBG_ERROR("flip mode error: " + flipFlag);
            return false;
        }
        return true;
    }


    function initEPGElementItem(epgLeftPanel, epgRightPanel) {
        if (!epgLeftPanel || !epgRightPanel) {
            epgLeftPanel = UI.getItem(epgMain, "epgLeftPanel");
            epgRightPanel = UI.getItem(epgMain, "epgRightPanel");
        }
        epgWinChTip = UI.getItem(epgLeftPanel, "epgWinChTip");
        epgCrntListName = UI.getItem(epgLeftPanel, "epgCrntListName");
        epgCrntTime = UI.getItem(epgRightPanel, "epgCrntTime");
        epgCrntPrgrmDetail = UI.getItem(epgRightPanel, "epgCrntPrgrmDetail");
        epgCrntPrgrmName = UI.getItem(epgRightPanel, "epgCrntPrgrmName");
        epgCrntPrgrmTime = UI.getItem(epgRightPanel, "epgCrntPrgrmTime");
        epgCrntChannel = UI.getItem(epgRightPanel, "epgCrntChannel");
        epgAxisPanel = UI.getItem(epgRightPanel, "epgAxisPanel");
        epgPurpleName = UI.getItem(epgRightPanel, "epgPurpleName");
        epgRedName = UI.getItem(epgRightPanel, "epgRedName");
        epgGreenName = UI.getItem(epgRightPanel, "epgGreenName");
        epgTimelinePanel = UI.getItem(epgMain, "epgTimelinePanel");
    }

    function initEPGElementAlpha(epgLeftPanel, epgRightPanel, epgBottomPanel) {
        epgCrntTime.alpha = epgCrntPrgrmDetail.alpha = baseAlpha;
        if (enableThemeColor) {
            UI.getItem(epgRightPanel, "epgGreenBG").alpha = 1;
            UI.getItem(epgRightPanel, "epgRedBG").alpha = 1;
            UI.getItem(epgRightPanel, "epgPurpleBG").alpha = 1;
            setLiveTVText(UI.getItem(epgBottomPanel, "epgOptGreenText"), "Program Color");
            epgGreenName.alpha = baseAlpha;
            epgPurpleName.alpha = baseAlpha;
            epgRedName.alpha = baseAlpha;
        }
        else {
            UI.getItem(epgRightPanel, "epgGreenBG").alpha = 0;
            UI.getItem(epgRightPanel, "epgRedBG").alpha = 0;
            UI.getItem(epgRightPanel, "epgPurpleBG").alpha = 0;
            setLiveTVText(UI.getItem(epgBottomPanel, "epgOptGreenText"), "Ch. List");
            epgGreenName.alpha = 0;
            epgPurpleName.alpha = 0;
            epgRedName.alpha = 0;
        }
        UI.getItem(epgLeftPanel, "epg_win_ch_bg").alpha = baseAlpha;
        UI.getItem(epgRightPanel, "epgAxisTip0").alpha = baseAlpha;
        UI.getItem(epgRightPanel, "epgAxisTip1").alpha = baseAlpha;
        UI.getItem(epgRightPanel, "epgAxisTip2").alpha = baseAlpha;
        UI.getItem(epgRightPanel, "epgAxisTime0").alpha = baseAlpha;
        UI.getItem(epgRightPanel, "epgAxisTime1").alpha = baseAlpha;
        UI.getItem(epgRightPanel, "epgAxisTime2").alpha = baseAlpha;
        UI.getItem(epgRightPanel, "epg_time_axis_border_1").alpha = 0.1;
        UI.getItem(epgRightPanel, "epg_time_axis_border_2").alpha = 0.1;
        UI.getItem(epgBottomPanel, "epgOptChText").alpha = baseAlpha;
        UI.getItem(epgBottomPanel, "epgOptInfoText").alpha = baseAlpha;
        UI.getItem(epgBottomPanel, "epgOptBlueText").alpha = baseAlpha;
        UI.getItem(epgBottomPanel, "epgOptGreenText").alpha = baseAlpha;
        UI.getItem(epgBottomPanel, "epgOptYellowText").alpha = baseAlpha;
        UI.getItem(epgBottomPanel, "epgOptRedText").alpha = baseAlpha;


        for (var i = 0; i < epgBottomPanel.children.length; i++) {
            if (epgBottomPanel.children[i].type == 6) epgBottomPanel.children[i].alpha = baseAlpha;
        }

    }

    function releaseEPGElement() {
        //epgChPanel = null;
        //epgPrgrmPanel = null;
        epgCrntTime = null;
        epgCrntPrgrmDetail = null;
        epgCrntPrgrmName = null;
        epgCrntPrgrmTime = null;
        epgWinChTip = null;
        epgCrntChannel = null;
        epgPurpleName = null;
        epgGreenName = null;
        epgRedName = null;
        epgCrntListName = null;
        epgAxisPanel = null;
        epgChannelIterator = null;
        epgEventIterator = [];
        epgEventOneWinIterator = null;
        currentChannel = {};
        currentList = {};
        oprtData.channels = [];
    }

    function setEnableThemeColor() {
        if ("EU" != GLOBAL.CURRENT_AREA || GLOBAL.FREEVIEW_VERSION) {
            enableThemeColor = true;
            return;
        }
        //var currentCountry = hiWebOsFrame.getCurrentCountry();
        //var EM_Country = ["Russia_EU", "Uzbekistan_EU", "Kirghizstan_EU", "Tajikistan_EU"];
        //if (EM_Country.indexOf(currentCountry) > -1) {
        //    enableThemeColor = false;
        //} else {
        //    enableThemeColor = true;
        //}
    }

    function EPGInitialize() {
        var epgLeftPanel = UI.getItem(epgMain, "epgLeftPanel");
        var epgRightPanel = UI.getItem(epgMain, "epgRightPanel");
        var epgBottomPanel = UI.getItem(epgMain, "epgBottomPanel");
        epgChPanel = UI.getItem(epgLeftPanel, "epgChPanel");
        epgPrgrmPanel = UI.getItem(epgRightPanel, "epgPrgrmPanel");
        setEnableThemeColor();
        initEPGElementItem(epgLeftPanel, epgRightPanel);
        initEPGElementAlpha(epgLeftPanel, epgRightPanel, epgBottomPanel);
        createChannelPanel();
    }

    function createChannelPanel() {
        var gridInfo = {
            template: "epgChItem",
            direction: CONST.GIRD_DIRECTION.H,
            breakNum: 1,
            distanceY: 0,
            distanceX: 0,
            container: epgChPanel
        };
        var allArray = [];
        for (var i = 0; i < channelMaxRows; i++) {
            allArray.push(
                {
                    name: "CHANNEL_" + i,
                    ch_item_bg: GLOBAL.IMAGE_LIST.NONE,
                    ch_item_border: GLOBAL.IMAGE_LIST.EPG_WHITE_BG,
                    ch_item_number: "0",
                    ch_item_logo: GLOBAL.IMAGE_LIST.NONE,
                    ch_item_name: "0",
                    ch_item_encrypt: GLOBAL.IMAGE_LIST.NONE,
                    ch_item_lock: GLOBAL.IMAGE_LIST.NONE
                }
            );
            createProgramPanel(epgPrgrmPanel.children[i], i);
        }
        removeLiveTVShape(epgChPanel);
        epgChPanel.removeAllChildren();
        epgChPanel.initSequence = [];
        Gird.create(allArray, gridInfo);
        UI.setView(epgChPanel, 570, 550);

        for (var i = 0; i < epgChPanel.initSequence.length; i++) {
            epgChPanel.initSequence[i].alpha = 1;
            epgChPanel.initSequence[i].children[CHITEM.BORDER].alpha = 0.1;
            epgChPanel.initSequence[i].children[CHITEM.NUMBER].alpha = baseAlpha;
            epgChPanel.initSequence[i].children[CHITEM.NAME].alpha = baseAlpha;
        }
    }

    function createProgramPanel(panel, chIdx) {
        var gridInfo = {
            template: "epgPrgrmItem",
            direction: CONST.GIRD_DIRECTION.H,
            breakNum: 10,
            distanceY: 0,
            distanceX: 0,
            container: panel
        };
        var allArray = [];
        for (var i = 0; i < programMaxCols; i++) {
            allArray.push(
                {
                    name: "CHANNEL_" + chIdx + "_PROGRAM_" + i,
                    prgrm_item_bg: GLOBAL.IMAGE_LIST.EPG_PRGRM_BG,
                    prgrm_item_name: "0",
                    prgrm_item_book: GLOBAL.IMAGE_LIST.NONE,
                    prgrm_item_theme: GLOBAL.IMAGE_LIST.NONE
                }
            );
        }
        removeLiveTVShape(panel);
        panel.removeAllChildren();
        panel.initSequence = [];
        Gird.create(allArray, gridInfo);
        //UI.setView(panel, 1350, 106);
        UI.addMask(panel, 1350, 106, 10, 10);
        for (var i = 0; i < panel.initSequence.length; i++) {
            panel.initSequence[i].alpha = 1;
            panel.initSequence[i].children[PRGRMITEM.NAME].alpha = baseAlpha;
            panel.initSequence[i].children[PRGRMITEM.BG].alpha = 0.3;
        }
    }

    EPGInitialize();

    EPG.getColorTheme = function () {
        return oprtData.colorTheme;
    }
    EPG.setChPanelData = setChPanelData;
})();