UI.moduleBuilder['Alexa']['register_demo'] = function() {
    var demoData = {
        titleImg:"Alexa/register/logo_alexa.png",
        title: "[SE3961]",
        helpText:"[SE3962]",
        okBtnText:"[GE0013]",
        demo1Img1:"Alexa/register/chet_bg_left_1.png",
        demo1Img2:"Alexa/register/chet_bg_left_2.png",
        demo1Img3:"Alexa/register/chet_bg_left_3.png",

        demo2Img1:"Alexa/register/chet_bg_right_1.png",
        demo2Img2:"Alexa/register/chet_bg_right_2.png",
        demo2Img3:"Alexa/register/chet_bg_right_3.png",

        demo3Img1:"Alexa/register/chet_bg_left_1.png",
        demo3Img2:"Alexa/register/chet_bg_left_2.png",
        demo3Img3:"Alexa/register/chet_bg_left_3.png",

        OKBtnImg:UI.item_bg
    }
    var template = Util.readJson("module/Alexa/register_demo.json");
    var register_demo = SubModule.create(demoData, template);

    var okBtn = UI.getItem(register_demo, "okBtn");
    register_demo.currFocus = okBtn;
    register_demo.protected = true;

    var helpText1 = UI.getItem(register_demo, "helpText1");
    var demo1Text = UI.getItem(register_demo, "demo1Text");
    var demo2Text = UI.getItem(register_demo, "demo2Text");
    var demo3Text = UI.getItem(register_demo, "demo3Text");
    var helpText2 = UI.getItem(register_demo, "helpText2");

    var textArray1 = [
        "[SE3963]",//Press and hold the Microphone button, then ask Alexa after the tone. Here are some of the many things you can try:
        "[SE3964]",//What’s the weather today?
        "[SE3965]",//Show my To-Do List.
        "[TV0195]",//Mute the TV.
        "[SE3967]"//You can also control your Hisense TV using other Alexa-enabled devices.
    ];

    var textArray2 = [//avg
        "[SE3968]",//"Here are some of the many things you can try using your Alexa-enabled devices:"
        "[SE3969]",//"Alexa, mute the [TV Name]."
        "[SE3970]",//"Alexa, change to HDMI 1 on [TV Name]."
        "[SE3973]",//"Alexa, channel up on [TV Name]."
        ""
    ];

    var textArray = [helpText1,demo1Text,demo2Text,demo3Text,helpText2];

    register_demo.onPush = function(){
        register_demo.currFocus = okBtn;
    }

    register_demo.onShow = function(){//demo  afterpush  , _setup onkey_enter
      writeFileToNative("hisenseUI/avsRegister", "register", 1);
      if(avs_support && avg_support){
          for (var i=0; i<textArray.length; i++)
          {
              UI.setText(textArray[i],textArray1[i]);
          }
      }else if(!avs_support && avg_support){
          for (var i=0; i<textArray.length; i++)
          {
              UI.setText(textArray[i],textArray2[i]);
          }
      }else{
          DBG_ERROR("no such requirement");
      }
        UI.updateStage();
    }

    register_demo.onPop = function(){
        setStep(0);

    }

    okBtn.onkey_ENTER = function(){
        UI.clearAllSubModule("Alexa");
        if (checkIsAppOn()) {
            registerKeyCodesForApp();
        } else {
            openLiveTVModule([Msg.INFO, 0]);
        }
    }

}
//