/**
 * Created by yangcheng3 on 2017-8-10.
 *
 * AVS-Model-Defines  class.
 * Contains all defined constants from values-avs.h
 */
function AvsModelDefines() {
}
{
    AvsModelDefines.SL2_TVAPI_I32_RECOG_STATE = "tvapi.avs.i32.recogintion.state";
    AvsModelDefines.SL2_TVAPI_STR_DISPLAY_CARDS = "tvapi.avs.str.display.cards";
    AvsModelDefines.SL2_TVAPI_ACTION_CTRL = "tvapi.avs.action.ctrl";

    AvsModelDefines.SL2_TVAPI_STR_AUTH_URL = "tvapi.avs.str.auth.url";
    AvsModelDefines.SL2_TVAPI_STR_AUTH_CODE = "tvapi.avs.str.auth.code";
    AvsModelDefines.SL2_TVAPI_I32_AUTH_EXPIRE_TIME = "tvapi.avs.i32.auth.expire.time";
    AvsModelDefines.SL2_TVAPI_I32_AUTH_RESULT = "tvapi.avs.i32.auth.result";
    AvsModelDefines.SL2_TVAPI_STR_USER_PROFILE = "tvapi.avs.str.user.profile";
    AvsModelDefines.SL2_TVAPI_I32_LOGIN_STATUS = "tvapi.avs.i32.login.status";

    AvsModelDefines.SL2_TVAPI_I32_SVR_ENABLE = "tvapi.avs.i32.svr.enable.flag";
    AvsModelDefines.SL2_TVAPI_I32_BT_RC_SUPPORT = "tvapi.avs.i32.bt.rc.support.flag";

    AvsModelDefines.SL2_TVAPI_STR_HIAUTH_TOKEN = "tvapi.avs.str.hiauth.token";
    AvsModelDefines.SL2_TVAPI_STR_HIAUTH_INFO = "tvapi.avs.str.hiauth.info";
    AvsModelDefines.SL2_TVAPI_I32_HIAUTH_RESULT = "tvapi.avs.i32.hiauth.result";
    AvsModelDefines.SL2_TVAPI_I32_HILOGIN_STATUS = "tvapi.avs.i32.hilogin.status";
    AvsModelDefines.SL2_TVAPI_STR_HIUSER_PROFILE = "tvapi.avs.str.hiuser.profile";
    AvsModelDefines.SL2_TVAPI_STR_HIDEV_ID = "tvapi.avs.str.hidev.id";

    AvsModelDefines.SL2_TVAPI_I32_HIDEV_REPORT = "tvapi.avs.i32.hireport.devinfo.result";
    AvsModelDefines.SL2_TVAPI_I32_LOGIN_STEP = "tvapi.avs.i32.rw.user.login.step";

    AvsModelDefines.SL2_TVAPI_I32_ALARM_FLAG = "tvapi.avs.i32.alarm.flag";
    AvsModelDefines.SL2_TVAPI_I32_RECOG_ERRCODE = "tvapi.avs.i32.recogintion.error.code";
    AvsModelDefines.SL2_TVAPI_STR_HIDEV_INFO = "tvapi.avs.str.hidev.info";

    AvsModelDefines.SL2_TVAPI_STR_ENABLE_SKILL_NAME = "de.loewe.sl2.str.avs.enable.skill.name";
    AvsModelDefines.SL2_TVAPI_STR_RESET_SKILL_NAME = "de.loewe.sl2.str.avs.reset.skill.name";
    AvsModelDefines.SL2_TVAPI_STR_PULL_CLOUD_MSG = "de.loewe.sl2.str.avs.pull.cloud.msg";

    // enum
    //ENUM_AVS_RECOG_STATE
    AvsModelDefines.ENUM_SL2_TVAPI_AVS_RECOG_STATE_IDLE = 0;
    AvsModelDefines.ENUM_SL2_TVAPI_AVS_RECOG_STATE_LISTENING = 1;
    AvsModelDefines.ENUM_SL2_TVAPI_AVS_RECOG_STATE_THINKING = 2;
    AvsModelDefines.ENUM_SL2_TVAPI_AVS_RECOG_STATE_SPEAKING = 3;
    AvsModelDefines.ENUM_SL2_TVAPI_AVS_RECOG_STATE_ALARM = 4;
    AvsModelDefines.ENUM_SL2_TVAPI_AVS_RECOG_STATE_INTERACTON = 100;

    //ENUM_SL2_TVAPI_AVS_CTRL_TYPE
    AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_START = 1;
    AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_STOP = 2;
    AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_CANCEL = 3;
    AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_GET_AUTH_CODE = 4;
    AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_CANCEL_AUTH_CODE = 5;
    AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_SEND_TO_AVS = 6;
    AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_LOGOUT = 7;
    AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_GET_USER_PROFILE = 9;
    AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_CANCEL_ALARM = 10;
    AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_GET_LOGIN_STATUS = 11;
    AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_NOTIFY_NET_STATUS = 12;

    AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_HIAVS_REPORT_ENABLE_FLAG = 80;
    AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_HIAVS_REPORT_TV_NAME = 81;
    AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_HIAVS_GET_AUTH_INFO = 82;
    AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_HIAVS_GET_USER_PROFILE = 83;
    AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_HIAVS_LOGOUT = 84;
    AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_HIAVS_GET_LOGIN_STATUS = 85;
    AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_HIAVS_GET_SERVICE_INFO = 86;
    AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_ACTION_TYPE_REPLACE_DEVICE = 88;
    AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_ACTION_TYPE_FORGET_PASSWORD = 89;
    AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_ACTION_TYPE_PCO_ENABLE_SKILL = 90;
    AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_ACTION_TYPE_PCO_RESET_SKILL = 91;

    //ENUM_TVAPI_AVS_AUTH_RESULT
    AvsModelDefines.ENUM_SL2_TVAPI_AVS_RESULT_OK = 0;
    AvsModelDefines.ENUM_SL2_TVAPI_AVS_RESULT_TIMEOUT = 1;
}
/**
 * AvsModel class derived from SubModel.
 */
function AvsModel(parentModel) {
    SubModel.call(this, parentModel, AvsModelDefines);
    this.registerSubObject = function (loadType) {
        this.registerIntegerObject(
            AvsModelDefines.SL2_TVAPI_I32_RECOG_STATE,
            "null", "null", "onRecogintionStateChanged",
            null, null);
        this.registerStringObject(
            AvsModelDefines.SL2_TVAPI_STR_DISPLAY_CARDS,
            "null", "null", "onDirectiveReceive",
            null, null);
        this.registerActionObject(
            AvsModelDefines.SL2_TVAPI_ACTION_CTRL,
            [
                {
                    name: "setControlType", method: function (e, s, p) {
                    return e.invoke(s, p);
                }
                }
            ], "null");

        this.registerStringObject(
            AvsModelDefines.SL2_TVAPI_STR_AUTH_CODE,
            "null", "null", "onAuthCodeReceived",
            null, null);
        this.registerIntegerObject(
            AvsModelDefines.SL2_TVAPI_I32_AUTH_RESULT,
            "null", "null", "onAuthResultReceived",
            null, null);
        this.registerIntegerObject(
            AvsModelDefines.SL2_TVAPI_I32_LOGIN_STATUS,
            "getLoginStatus", "null", "onLoginStatusReceived",
            null, null);
        this.registerIntegerObject(
            AvsModelDefines.SL2_TVAPI_I32_SVR_ENABLE,
            "getAlexaEnable", "setAlexaEnable", "null",
            null, null);
        this.registerIntegerObject(
            AvsModelDefines.SL2_TVAPI_I32_BT_RC_SUPPORT,
            "getBTRCSupport", "null", "null",
            null, null);
        this.registerStringObject(
            AvsModelDefines.SL2_TVAPI_STR_HIAUTH_TOKEN,
            "getSystemToken", "null", "onHisenseTokenReceived",
            null, null);
        this.registerStringObject(
            AvsModelDefines.SL2_TVAPI_STR_HIAUTH_INFO,
            "null", "null", "onHisenseAuthInfoReceived",
            null, null);
        this.registerIntegerObject(
            AvsModelDefines.SL2_TVAPI_I32_HIAUTH_RESULT,
            "null", "null", "onHisenseAuthResultReceived",
            null, null);
        this.registerIntegerObject(
            AvsModelDefines.SL2_TVAPI_I32_HILOGIN_STATUS,
            "getHisLoginStatus", "null", "onHisLoginStatusReceived",
            null, null);
        this.registerStringObject(
            AvsModelDefines.SL2_TVAPI_STR_USER_PROFILE,
            "null", "null", "onUserProfileReceived",
            null, null);
        this.registerStringObject(
            AvsModelDefines.SL2_TVAPI_STR_HIUSER_PROFILE,
            "null", "null", "onHisUserProfileReceived",
            null, null);
        this.registerStringObject(
            AvsModelDefines.SL2_TVAPI_STR_HIDEV_ID,
            "getDeviceId", "null", "null",
            null, null);
        this.registerIntegerObject(
            AvsModelDefines.SL2_TVAPI_I32_HIDEV_REPORT,
            "null", "null", "onHisDeviceReportResult",
            null, null);
        this.registerIntegerObject(
            AvsModelDefines.SL2_TVAPI_I32_ALARM_FLAG,
            "null", "null", "onAlarmReceived",
            null, null);
        this.registerIntegerObject(
            AvsModelDefines.SL2_TVAPI_I32_LOGIN_STEP,
            "getLoginStep", "setLoginStep", "null",
            null, null);
        this.registerIntegerObject(
            AvsModelDefines.SL2_TVAPI_I32_RECOG_ERRCODE,
            "null", "null", "onErrorCodeReceived",
            null, null);
        this.registerStringObject(
            AvsModelDefines.SL2_TVAPI_STR_HIDEV_INFO,
            "null", "null", "onHisDeviceInfoReceived",
            null, null);
        this.registerStringObject(
            AvsModelDefines.SL2_TVAPI_STR_ENABLE_SKILL_NAME,
            "null", "null", "onEnableSkillNameReceived",
            null, null);
        this.registerStringObject(
            AvsModelDefines.SL2_TVAPI_STR_RESET_SKILL_NAME,
            "null", "null", "onResetSkillNameReceived",
            null, null);
        this.registerStringObject(
            AvsModelDefines.SL2_TVAPI_STR_PULL_CLOUD_MSG,
            "null", "null", "onPullCloudMsgReceived",
            null, null);
    }
}
AvsModel.prototype = new SubModel;
AvsModel.prototype.constructor = AvsModel;
{
    SubModel.registerStaticConstants(AvsModel, AvsModelDefines,[]);
}