UI.templateManager["module/volumeBar/volumeCtrl.json"] = {
    volumeCtrl: {
        type: 0,
        position: {
            x: 496,
            y: 770
        },
        items: {
            volumeEle: {
                type: 0,
                position: {
                    x: 0,
                    y:0
                },
                items: {
                    volume_bg: {
                        type: 7,
                        bound: {
                            w: 970,
                            h: 200
                        },
                        position: {
                            x: -20,
                            y: -20
                        },
                        navigation: {
                            leftTo: null,
                            rightTo: null,
                            upTo: null,
                            downTo: null
                        }
                    },
                    volumeIcon: {
                        type: 7,
                        bound: {
                            w: 100,
                            h: 100
                        },
                        position: {
                            x: 79,
                            y: 30
                        },
                        navigation: {
                            leftTo: null,
                            rightTo: null,
                            upTo: null,
                            downTo: null
                        }
                    },
                    volBar: {
                        type: 7,
                        bound: {
                            w: 600,
                            h: 12
                        },
                        position: {
                            x: 199,
                            y: 74
                        },
                        navigation: {
                            leftTo: null,
                            rightTo: null,
                            upTo: null,
                            downTo: null
                        }
                    },
                    volText: {
                        type: 6,
                        bound: {
                            w: 100,
                            h: 40
                        },
                        innerPos: {
                            x: 0,
                            y: 0
                        },
                        value: 100,
                        font: "42px SourceSansPro-Light",
                        color:"0xf2f2f2",
                        align: "left",
                        position: {
                            x: 819,
                            y: 60
                        },
                        navigation: {
                            leftTo: null,
                            rightTo: null,
                            upTo: null,
                            downTo: null
                        }
                    }
                }
            },
            muteEle: {
                type: 0,
                position: {
                    x: 1154,
                    y: 0
                },
                items: {
                    mute_bg: {
                        type: 7,
                        bound: {
                            w: 250,
                            h: 200
                        },
                        position: {
                            x: -20,
                            y: -20
                        },
                        navigation: {
                            leftTo: null,
                            rightTo: null,
                            upTo: null,
                            downTo: null
                        }
                    },
                    muteIcon: {
                        type: 7,
                        bound: {
                            w: 100,
                            h: 100
                        },
                        position: {
                            x: 55,
                            y: 30
                        },
                        navigation: {
                            leftTo: null,
                            rightTo: null,
                            upTo: null,
                            downTo: null
                        }
                    }
                }
            }
        }
    }
};


UI.moduleBuilder['volumeBar']['volumeCtrl'] = function(){
    /*default data*/
    var template = Util.readJson("module/volumeBar/volumeCtrl.json");
    var volumeData = {
        volumeIcon: GLOBAL.IMAGE_LIST.VOLUME_ICON,
        headphoneIcon:GLOBAL.IMAGE_LIST.HEADPHONE_ICON,
        arcIcon:GLOBAL.IMAGE_LIST.ARC_ICON,
        bluetoothIcon:GLOBAL.IMAGE_LIST.BLUETOOTH_ICON,
        volume_bg: UI.liveTV_bg,
        mute_bg: GLOBAL.IMAGE_LIST.MUTE_BG,
        muteIcon: GLOBAL.IMAGE_LIST.MUTE_ICON
    }, volBar, volumeEle, muteEle, volText,volumeIcon;
    var volumeCtrl = null, volume, maxVol, minVol, mute, rpt = 0, volTimer,dev,speakerState;
    var SpeedMap = [1, 1, 1, 2, 2, 2, 4, 4, 4, 8];
    var volumeOpened = false;
    var imageList =
        ["liveTV/volume/ic_volume.png",
        "liveTV/volume/ic_earphone.png",
        "liveTV/volume/ic_arc.png",
        "liveTV/volume/ic_bluetooth_devices.png"];

    function initVolumeBar() {
        maxVol = 100;
        minVol = 0;
        if (Config.tv) {
            mute = parseInt(model.sound.getMainMute());
            volume = parseInt(model.sound.getMainVolume());
            dev = parseInt(model.sound.getMainVolumeDev());//0=speaker,1=headphone��2=arc��3=bluetooth
            speakerState = parseInt(model.sound.getSpeakerArc());//speaker 1；arc 2；spdif 3；bluetooth 4
            DBG_ERROR("mute is " + mute +" volume is  " + volume + " dev is " + dev + "speakerState is " + speakerState);
        }
        else {
            mute = 0;
            volume = 20;
            dev = 1;
            speakerState = 2;
        }
        volumeCtrl = SubModule.create(volumeData, template);
        volumeCtrl.noAutoMemcControl = true;
        volumeEle = UI.getItem(volumeCtrl, "volumeEle");
        muteEle = UI.getItem(volumeCtrl, "muteEle");
        volumeIcon = UI.getItem(volumeCtrl, "volumeIcon");
        volBar = UI.getItem(volumeEle, "volBar");
        volText = UI.getItem(volumeEle, "volText");

        Percent.create(volBar, volText, volume);
        refreshVolumeIcon(dev,speakerState);
        if(GLOBAL.FACTORY == 1){
            muteEle.alpha = 0;
        }else{
            muteEle.alpha = mute;
        }
        volumeEle.alpha = 0;
        UI.updateStage();
        setOsdForVolumebar(volumeEle.alpha,muteEle.alpha);
        volumeCtrl.currFocus = volBar;
    }

    function setOsdForVolumebar(val1, val2){
        DBG_ERROR("val1 is " + val1 + "val2 is " + val2);
        if(val1 == 1 || val2 == 1){
            UI.setOsdShowType(1);
        }else{
            UI.setOsdShowType(0);
        }
    }
    function refreshVolumeIcon(val1, val2){
        DBG_ERROR("val1 is " + val1 + "val2 is " + val2);
        if(val1 == 2 && val2 == 2 ){
            UI.setImage(volumeIcon, imageList[val1]);
        }else if(val1 == 2 && val2 != 2 ){
            UI.setImage(volumeIcon, imageList[0]);
        }else{
            UI.setImage(volumeIcon, imageList[val1]);
        }
        UI.updateStage();
    }


    initVolumeBar();

    function setMaxVolume(val) {
        maxVol = val
    }

    function setMinVolume(val) {
        minVol = val
    }

    liveTV.setMaxVolume = setMaxVolume;
    liveTV.setMinVolume = setMinVolume;

    function showVolumeBar() {
        volumeEle.alpha = 1;
        setOsdForVolumebar(volumeEle.alpha,muteEle.alpha);
        UI.updateStage();
        UI.callTTS("[SE1929]" + " " + volume);
        autoClose();
    }

    volumeCtrl.isVolumBarShow = function(){
        return volumeEle.alpha || muteEle.alpha;
    };

    function hideVolumeBar() {
        volumeEle.alpha = 0;
        setOsdForVolumebar(volumeEle.alpha,muteEle.alpha);
        UI.updateStage();
    }
    function onDevChanged(val){
        var devChange = dev == parseInt(val);
        dev = parseInt(val);
        DBG_ERROR("devChange is " + devChange + " val is " + val);
        if(!devChange){
            refreshVolumeIcon(dev, speakerState);
        }
    }

    function onSpeakerStateChanged(val){
        var speakerChange = speakerState == parseInt(val);
        speakerState = parseInt(val);
        DBG_ERROR("speakerChange is " + speakerChange + ", speakerState is " + speakerState );
        if(!speakerChange){
            refreshVolumeIcon(dev, speakerState);
        }
    }



    function onMuteChanged(val) {
        var noVioce = mute == parseInt(val);
        mute = parseInt(val);
        DBG_ERROR("onMuteChanged noVioce is " + noVioce + ", mute is " + mute);
        muteEle.alpha = mute;
        setOsdForVolumebar(volumeEle.alpha,muteEle.alpha);
        UI.updateStage();
        setTimeout(function(){
            UI.updateStage();
        },50);
        if (!mute && !noVioce) {
            UI.callTTS("Audio on");
        }
    }

    function onVolumeChanged(val, noRefresh) {
        DBG_ERROR("GLOBAL.CEC_CONTROL " + GLOBAL.CEC_CONTROL + "GLOBAL.CEC_DEVICE_EXIST " + GLOBAL.CEC_DEVICE_EXIST + "GLOBAL.CEC_ARC_STATE " +GLOBAL.CEC_ARC_STATE);
        if (isCECByPass()) {
           autoClose();
        }
        var noVioce = volume == parseInt(val);
        volume = parseInt(val);
        volBar.setPercentNoVoice(volume);
        DBG_ERROR("noVioce is " + noVioce + ", volume is " + volume + ", val is  "+ val );
        var volTxt = "[SE1929]";//"volume";
        if (!noVioce) {
            UI.callTTS(volTxt + " " + val);
        }
        if (0 == volumeEle.alpha && !noRefresh) showVolumeBar();
    }

    function setVolumeByFlag(val) {
        if ((val > 0 && volume < maxVol) || (val < 0 && volume > minVol)) {
            var presetVal = volume + val;
            if (presetVal < minVol) presetVal = minVol;
            if (presetVal > maxVol) presetVal = maxVol;
            if (1 == mute && presetVal > volume) {
                Config.tv ? model.sound.setMainMute(0) : onMuteChanged(0);
            }
            Config.tv ? model.sound.setMainVolume(presetVal) : onVolumeChanged(presetVal);
        }
        else {
            if (volume >= 100) {
                Config.tv ? model.sound.setMainMute(0) : onMuteChanged(0);
            }
        }
    }

    function clearVolumeGain(v) {
        if (1 == v) rpt = 0;
    }

    function getVolGain(x) {
        if (x >= SpeedMap.length) x = SpeedMap.length - 1;
        return SpeedMap[x];
    }

    function receiveVolumeKey(keyCode, focus, evt) {
        if (UI.getCurrSubModule().name == "standbyControl") {
            UI.getCurrSubModule().onkey();
            return;
        }

        if (UI.getCurrSubModule().name == LIVETV.CONTROL) {
            UI.getCurrSubModule().onkey();
        }
        if(processB2bVolume() == true){
            return;
        }

        if(B2BPara.SCREENOFFFLAG){
            return;
        }
        autoClose();
        if (isCECByPass()) {
            sendKeyToCEC(keyCode, volume);
        }
        else {

            if (CONST.KEY.VK_MUTE == keyCode) {
                if (UI.keyState == 2) {
                    return;
                }
                if(tv && GLOBAL.TTS){
                    if (mute == 0) {
                        UI.callTTS("Audio off",0);//Mute
                        setTimeout(function() {
                            model.sound.setMainMute(1);
                        },1200);
                    }
                    else {
                        model.sound.setMainMute(0);
                    }

                }
                else {
                    Config.tv ? model.sound.setMainMute(1 - mute) : onMuteChanged(1 - mute);
                }
            }
            else {
                if (0 == volumeEle.alpha) {
                    rpt = 0;
                    volume = parseInt(model.sound.getMainVolume());
                    volBar.setPercentNoVoice(volume);
                    showVolumeBar();
                }
                else {
                    if(UI.keyRepeatTime == 0){
                        rpt = 0;
                    }
                    setVolumeByFlag((CONST.KEY.VK_VOLUME_DOWN == keyCode ? -1 : 1) * getVolGain(rpt));
                    rpt++;
                }
            }
        }
        return false;
    }

    function autoClose() {
        clearTimeout(volTimer);
        volTimer = setTimeout(function () {
            hideVolumeBar();
        }, 3000);
    }

    function refreshCurrentVolume(val) {
        //if (!Config.tv) return;
        if (1 == val) {
            UI.popGhostModule("volumeCtrl");
        }
        else {
            if (!GLOBAL.TV_SUSPENDING) {
                recheckVolume(val);
            }
        }
        UI.updateStage();
    }

    function recheckVolume(val) {
        if (Config.tv) {
            onVolumeChanged(parseInt(model.sound.getMainVolume()), true);
            onMuteChanged(parseInt(model.sound.getMainMute()));
            onDevChanged(parseInt(model.sound.getMainVolumeDev()));
            onSpeakerStateChanged(parseInt(model.sound.getSpeakerArc()));
            DBG_ERROR("recheck: volume[" + volume + "], mute[" + mute + "] , dev[" + dev + "] , speakerState[" + speakerState +"]");
        }
        if (null == UI.getGhostModule("volumeCtrl")) UI.pushGhostModule("volumeBar", "volumeCtrl");
    }

    function resetVolAftSuspendChanged(v) {
        muteEle.alpha = mute = 0;
        setOsdForVolumebar(volumeEle.alpha,muteEle.alpha);
        if (1 == v) {
            UI.popGhostModule("volumeCtrl");
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.HEADPHONE_DEVICE_INSERT, recheckVolume);
        }
        else {
            UI.pushGhostModule("volumeBar", "volumeCtrl");
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.HEADPHONE_DEVICE_INSERT, recheckVolume);
        }
        UI.updateStage();
    }

    function processB2bVolume(){
        try{
            DBG_ERROR("B2BPara.GHASB2B is " + B2BPara.GHASB2B + "model.b2b.getVolumeFixedModev is"+model.b2b.getVolumeFixedMode() );
            /*if(hasB2BorNot() && model.sound.getSpeakerArc()==0) {
             return true;
             }*/
            if(B2BPara.GHASB2B && model.b2b.getVolumeFixedMode()==0){
                if(volume<B2BPara.GMAXVOLUE){
                    model.sound.setMainVolume(volume);
                }else{
                    volume=B2BPara.GMAXVOLUE;
                    model.sound.setMainVolume(volume);
                }
                return true;
            }
            return false;
        }catch(ex){DBG_ERROR(ex.message)}
    }

    volumeCtrl.onPush = function () {
        DBG_INFO("volume bar pushed.");
        volumeOpened = true;
    };

    volumeCtrl.onPop = function () {
        DBG_INFO("volume bar poped.");
        volumeOpened = false;
        clearTimeout(volTimer);
        hideVolumeBar();
    };

    volumeCtrl.onkey_MUTE = receiveVolumeKey.bind(this, CONST.KEY.VK_MUTE);
    volumeCtrl.onkey_VALMINUS = receiveVolumeKey.bind(this, CONST.KEY.VK_VOLUME_DOWN);
    volumeCtrl.onkey_VALPLUS = receiveVolumeKey.bind(this, CONST.KEY.VK_VOLUME_UP);
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.VOLUME_CHANGED, onVolumeChanged);
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.MUTE_CHANGED, onMuteChanged);
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.KEY_RELEASE, clearVolumeGain);
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.FACTORY_MODE_CHANGED, refreshCurrentVolume);
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CEC_DEVICE_EXIST_CHANGED, recheckVolume);
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CEC_CONTROL_CHANGED, recheckVolume);
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.HEADPHONE_DEVICE_INSERT, recheckVolume);
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.ENTER_SUSPEND_MODE, resetVolAftSuspendChanged);
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.VOLUME_DEV_CHANGED, recheckVolume);// must add
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AUDIO_SPEAKER, recheckVolume);//1:tv,2:arc,3:spifc

};