// Init
UI.moduleBuilder['setting']['wifiAdd'] = function(){

    var mainPanelData = {
        wifiAddDialogBgImg:UI['bg_overlay'],
        wifiAddBgImg:UI.window_bg,
        wifiAddInputBar:"setting/wifi/"+GLOBAL.LAUNCHER_BRAND+"/wifi_add_input_focused.png",
        wifiAuthTypeImg:UI.item_bg,
        wifiAddAuthListGrpBg:UI.window_bg,
        wifiAddCancelImg:UI.item_bg,
        wifiAddConnectImg:UI.item_bg,
        wifiAddName:"[SE0610]",//"Add Wireless Network"
        wifiAddSid:"[SE0167]",//"SSID"
        noAddTextHint:"[SE3014]",//"Press OK open the keyboard"
        wifiAddAuthListText:"[SE0168]",//"Security"
        Security:"[SE0168]",
        wifiAddCancelText:"[GE0008]",//Cancel
        wifiAddConnectText:"[SE0187]"//Connect

    };
    var template = Util.readJson("module/setting/wifiAdd.json");
    var wifiAdd = SubModule.create(mainPanelData, template);
    var wifiAddConnectBtn = UI.getItem(wifiAdd, "wifiAddConnectBtn");
    var textBar = UI.getItem(wifiAdd, "wifiAddInputTextBox");
    var inputBox = UI.getItem(textBar, "wifiAddInputBox");

    wifiAdd.index = 0;
    wifiAdd.oldIndex = 0;
    wifiAdd.addName = "";
/***** DBTAG 20161012 MARK *****/
    wifiAdd.securityTypeList = ["[SE0275]","WEP","WPA-PSK(TKIP)","WPA2-PSK(AES)","WPA-PSK(AES)","WPA2-PSK(TKIP)"];
    wifiAdd.secAuthMapList=[
        {
            "security":0,//5657 US is 1
            "authentication":0
        },
        {
            "security":4,
            "authentication":4
        },
        {
            "security":2,
            "authentication":2
        },
        {
            "security":3,
            "authentication":3
        },
        {
            "security":5,
            "authentication":5
        },
        {
            "security":6,
            "authentication":6
        }
    ];
/***** DBTAG -- END *****/
    wifiAdd.noAutoClose = true;
    wifiAdd.currFocus = UI.getItem(wifiAdd, "wifiAddInputTextBox");

    var wifiAddCancelBtn = UI.getItem(wifiAdd, "wifiAddCancelBtn");
    var wifiAddName = UI.getItem(wifiAdd, "wifiAddName");
    var wifiAddSid = UI.getItem(wifiAdd, "wifiAddSid");
    var wifiAddAuthListGrp = UI.getItem(wifiAdd, "wifiAddAuthListGrp");
    var wifiAddAuthList = UI.getItem(wifiAddAuthListGrp,"wifiAddAuthList");
    var wifiAuthTypeBtn = UI.getItem(wifiAdd, "wifiAuthTypeBtn");
    var wifiAuthTypeText = UI.getItem(wifiAuthTypeBtn,"wifiAuthTypeText");

    var wifiAddInputBar = UI.getItem(textBar, "wifiAddInputBar");
    var noAddTextHint = UI.getItem(textBar, "noAddTextHint");

    Select.create(wifiAuthTypeText, wifiAdd.securityTypeList);
    wifiAuthTypeText.selectCurrent(0);
    var textInfo = {
        initVal : "",
        maxLength : 500,
        maxWidth : 580,
        fontSize : 40,
        isPwd : false,
        color : "rgba(255,255,255,.6)",
        TextName:Config.language["SE0167"]
    };
    TextBox.create(inputBox, textInfo, onAddTextChanged);

    var HIDE = 0;
    var SHOW = 1;
    wifiAdd.onShow =  function(){
        try{
            inputBox.children[0].realValue = "";
            inputBox.children[0].text = "";
            inputBox.setText("");
            inputBox.cursorLeft();

            setAuthListGrpAlpha(HIDE);
            setAuthBtnGrpAlpha(SHOW);
            createWifiAddAuthListGrp();
            wifiAddConnectBtn.disable = true;
            wifiAddConnectBtn.alpha = 0.3;
            wifiAdd.index = 0;
            wifiAdd.oldIndex = 0;
            noAddTextHint.alpha = 0.5;
            UI.callTTS("[SE3014]");
            wifiAuthTypeText.selectCurrent(0);
//            UI.setImage(wifiAddInputBar,"setting/wifi/wifi_add_input_focused.png");
//            wifiAdd.currFocus = UI.getItem(wifiAdd, "wifiAddInputTextBox");
            UI.focusTo(textBar);
            UI.updateStage();

        }
        catch (ex){
            DBG_ERROR(ex.message);
        }
    };
    wifiAdd.currFocus = UI.getItem(wifiAdd, "wifiAddInputTextBox");
//    inputBox.removeAllChildren();

    textBar.onFocus = function(){
        UI.base.cursor.alpha = 0;
        UI.getTween(UI.base.cursor).set({alpha: 0});
        DBG_INFO("!!!!!!!!!!onfocus");
        UI.setImage(wifiAddInputBar,"setting/wifi/"+GLOBAL.LAUNCHER_BRAND+"/wifi_add_input_focused.png");
        inputBox.active();
        UI.updateStage();
        return false;
//
    };
    textBar.onNormal = function(){
        UI.base.cursor.alpha = 1;
        UI.getTween(UI.base.cursor).set({alpha: 1});
        DBG_INFO("!!!!!!!!!!onNormal");
        UI.setImage(wifiAddInputBar,"setting/wifi/wifi_add_input_normal.png");
        UI.updateStage();
        inputBox.inactive();
        return true;
//
    };

    textBar.onkey_ZERO = wifiAddProNumKey;
    textBar.onkey_ONE = wifiAddProNumKey;
    textBar.onkey_TWO = wifiAddProNumKey;
    textBar.onkey_THREE = wifiAddProNumKey;
    textBar.onkey_FOUR = wifiAddProNumKey;
    textBar.onkey_FIVE = wifiAddProNumKey;
    textBar.onkey_SIX = wifiAddProNumKey;
    textBar.onkey_SEVEN = wifiAddProNumKey;
    textBar.onkey_EIGHT = wifiAddProNumKey;
    textBar.onkey_NINE = wifiAddProNumKey;

    function onAddTextChanged(txt) {
        DBG_INFO("!!!!!!!!!!!!!!!!!!!"+txt);
        wifiAdd.addName = txt.text;
        inputBox.setText(inputBox.children[0].realValue);
        if(wifiAdd.addName.length>0){
            DBG_INFO("!!!!!!!!!!!!!!!!!!!"+txt);
            wifiAddConnectBtn.disable = false;
            wifiAddConnectBtn.alpha = 1;
            noAddTextHint.alpha = 0;
        }
        UI.updateStage();

    }

    function wifiAddProNumKey(){
        inputBox.children[0].realValue += CONST.NUMIPT_VALUE[UI.currKeyValue];
        inputBox.setText(inputBox.children[0].realValue);
        inputBox.cursorRight();
        wifiAdd.addName = inputBox.children[0].realValue;
        if (inputBox.children[0].realValue.length != 0) {
            noAddTextHint.alpha = 0;
//            connectBtnDisableOrNot(1);
            wifiAddConnectBtn.disable = false;
            wifiAddConnectBtn.alpha = 1;
        }
        else {
            noAddTextHint.alpha = 0.5;
            UI.callTTS("[SE3014]");
//            connectBtnDisableOrNot(0);
        }
        DBG_INFO("value changed!");
        UI.updateStage();
    }

    textBar.onkey_ENTER = function (){
        DBG_INFO("!!!!!!!!!!!!!!!!!!!");
        inputBox.showKeyBoard();
    };

    function createWifiAddAuthListGrp(){
        var array = [];
        for(var i=0;i<wifiAdd.securityTypeList.length;i++){
            array.push({});
            array[i].name = "wifiAuthTypeId" + i;
            array[i].wifiAuthTypeItemImg = UI.item_bg;
            array[i].wifiAuthTypeName = wifiAdd.securityTypeList[i];
            array[i].wifiAuthTypeFlag = "setting/ic_radiobutton_normal.png"
        }
        var info = {
            template: "wifi_authtype",
            direction: CONST.GIRD_DIRECTION.H,
            breakNum: 1,
            distanceX: 0,
            distanceY: 20,
            container: wifiAddAuthList
        };
        wifiAddAuthList.removeAllChildren();
        UI.resetViewPos(wifiAddAuthList);
        UI.removeScrollbar(wifiAddAuthList);
        UI.removeView(wifiAddAuthList);
        UI.removeMask(wifiAddAuthList);
        Gird.create(array, info);
        UI.addMask(wifiAddAuthList, 820, 676,50,10);
        UI.setView(wifiAddAuthList, 820, 676);
        UI.addScrollbar(wifiAddAuthList,24);
    }

    wifiAuthTypeBtn.onkey_ENTER = function (){
        setAuthListGrpAlpha(SHOW);
        setAuthBtnGrpAlpha(HIDE);
        wifiAdd.listFirstFocus = UI.getItem(wifiAddAuthList,"wifiAuthTypeId0");
        UI.focusTo(wifiAdd.listFirstFocus);
        wifiAdd.currFocus = UI.getItem(wifiAddAuthList,"wifiAuthTypeId0");
        var index = wifiAdd.securityTypeList.indexOf(wifiAuthTypeText.selected);
        DBG_INFO("networkIpSetModeText:"+index);

        var  oldTarget = UI.getItem(wifiAddAuthList,"wifiAuthTypeId"+wifiAdd.oldIndex);
        var  target = UI.getItem(wifiAddAuthList,"wifiAuthTypeId"+index);
        UI.setImage(oldTarget.children[2], "setting/ic_radiobutton_normal.png");
        UI.setImage(target.children[2], "setting/"+GLOBAL.LAUNCHER_BRAND+"/ic_radiobutton_focused.png");
        wifiAdd.oldIndex = index;
    };
    wifiAuthTypeBtn.onkey_DOWN = function (){
        if(wifiAddConnectBtn.disable){
            UI.focusTo(wifiAddCancelBtn);
        }else{
            UI.focusTo(wifiAddConnectBtn);
        }
    };

    wifiAddAuthList.onkey_ENTER = function (focus) {
        var index = wifiAddAuthList.initSequence.indexOf(focus);
        DBG_INFO("wifiAddAuthList!!!!"+index);
        wifiAdd.index = index;
        setAuthListGrpAlpha(HIDE);
        setAuthBtnGrpAlpha(SHOW);
        wifiAuthTypeText.selectCurrent(index);
        UI.focusTo(wifiAuthTypeBtn);
    };

    function setAuthListGrpAlpha(alpha){
        wifiAddAuthListGrp.alpha = alpha;
        UI.updateStage();
    }
    function setAuthBtnGrpAlpha(alpha){
        wifiAddConnectBtn.alpha = alpha;
        if(alpha == SHOW){
            if(wifiAddConnectBtn.disable){
                wifiAddConnectBtn.alpha = 0.3;
            }
        }
        wifiAddCancelBtn.alpha = alpha;
        wifiAuthTypeBtn.alpha = alpha;
        textBar.alpha = alpha;
        wifiAddName.alpha = alpha;
        wifiAddSid.alpha = alpha;
        UI.updateStage();
    }

    wifiAuthTypeBtn.onFocus = function(){
        UI.setTextColor(wifiAuthTypeBtn.children[1],"rgba(255,255,255,1.0)");
        UI.setTextColor(wifiAuthTypeText,"rgba(255,255,255,1.0)");
        return true;
    };
    wifiAuthTypeBtn.onNormal = function(){
        UI.setTextColor(wifiAuthTypeBtn.children[1],"rgba(255,255,255,0.6)");
        UI.setTextColor(wifiAuthTypeText,"rgba(255,255,255,0.6)");
        return true;
    };

    wifiAddAuthList.onFocus = function(){
        UI.setTextColor(wifiAdd.currFocus.children[1],"rgba(255,255,255,1.0)");
        return true;
    };
    wifiAddAuthList.onNormal = function(){
        UI.setTextColor(wifiAdd.currFocus.children[1],"rgba(255,255,255,0.6)");
        return true;
    };
    wifiAddConnectBtn.onFocus = function(){
        UI.setTextColor(wifiAddConnectBtn.children[1],"rgba(255,255,255,1.0)");
        return true;
    };
    wifiAddConnectBtn.onNormal = function(){
        UI.setTextColor(wifiAddConnectBtn.children[1],"rgba(255,255,255,0.6)");
        return true;
    };
    wifiAddCancelBtn.onFocus = function(){
        UI.setTextColor(wifiAddCancelBtn.children[1],"rgba(255,255,255,1.0)");
        return true;
    };
    wifiAddCancelBtn.onNormal = function(){
        UI.setTextColor(wifiAddCancelBtn.children[1],"rgba(255,255,255,0.6)");
        return true;
    };

    wifiAuthTypeBtn.onkey_RIGHT = function() {
        wifiAuthTypeText.selectNext();
        var index = wifiAdd.securityTypeList.indexOf(wifiAuthTypeText.selected);
        wifiAdd.index = index;

    };
    wifiAuthTypeBtn.onkey_LEFT = function() {
        wifiAuthTypeText.selectPrev();
        var index = wifiAdd.securityTypeList.indexOf(wifiAuthTypeText.selected);
        wifiAdd.index = index;

    };

    wifiAddConnectBtn.onkey_ENTER = function() {
        try{
            var inputSSID = wifiAdd.addName;
            DBG_INFO("wizardNetSetWifiAddBtnHandle:inputSSID="+inputSSID);
            if(inputSSID.length > 0){
                if(tv == true){
                    model.network.setLink_quality(100);
                }
//                data.operateData.currSSID = inputSSID;
                var networkConfigPanel = UI.getSubModule("networkConfigPanel");
                var wifiConnPara = getWifiAddConnPare();

                networkConfigPanel.currPassword = "";
                networkConfigPanel.currSSIDName = wifiConnPara.SSID;
                networkConfigPanel.currSecType = wifiConnPara.secType;
                networkConfigPanel.currAuthType = wifiConnPara.authType;
                networkConfigPanel.currPassword = wifiConnPara.password;
                if(wifiAdd.index == 0){
                    networkConfigPanel.openFromPwd = 3;
                    UI.popSubModule();
                }else{
                    networkConfigPanel.openFromPwd = 1;
                    UI.popSubModule();
                    networkConfigPanel.connWifiPara.SSID = networkConfigPanel.currSSIDName;
                    networkConfigPanel.connWifiPara.secType = networkConfigPanel.currSecType;
                    networkConfigPanel.connWifiPara.authType = networkConfigPanel.currAuthType;
                    networkConfigPanel.connWifiPara.connPassword = networkConfigPanel.currPassword;
                    DBG_ERROR("networkConfigPanel.openFromPwd:" + networkConfigPanel.openFromPwd);
                    networkConfigPanel.openFromPwd = 3;
                    DBG_ERROR("networkConfigPanel.openFromPwd:" + networkConfigPanel.openFromPwd);
                    UI.pushSubModule("setting", "wifiPwdInput", true);
                    return false;
//                    debugPrint("wizardNetSetWifiAddBtnHandle:create wizardNetSetPWInputDialogId dialog");
//                    hiWebOsFrame.setting3rdNetworkWifiAdd.destroy();
//                    hiWebOsFrame.createPage('setting3rdNetworkWifiPwd', null, hiWebOsFrame.setting3rdNetworkWifiAdd, null, function (a) {
//                        hiWebOsFrame.setting3rdNetworkWifiPwd = a;
//                        hiWebOsFrame.setting3rdNetworkWifiPwd.origin = hiWebOsFrame.setting3rdNetworkWifiAdd;
//                        setting3rdNetworkWifiPwdSetData(getSetting3rdNetworkWifiAddConnPare());
//                        a.open();
//                        a.hiFocus();
//                    });
                }
            }else{
                DBG_ERROR("wizardNetSetWifiAddBtnHandle:inputSSID is null!!");
            }
        }catch (ex){
            DBG_ERROR("wizardNetSetWifiAddBtnHandle:"+ex.message);
        }
    };
    function getWifiAddConnPare(){
        var wifiConnPare ={
            "SSID":"",
            "secType":0,
            "authType":1,
            "password":""
        }
        wifiConnPare.SSID = wifiAdd.addName;
        wifiConnPare.secType =wifiAdd.secAuthMapList[wifiAdd.index].security;
        wifiConnPare.authType = wifiAdd.secAuthMapList[wifiAdd.index].authentication;
        wifiConnPare.password = "";
        if(tv == true){
            var currWifiState = model.network.getEnumLink();
            if(currWifiState == 0){
                var connSSID = model.network.getSsid();
                if(connSSID == wifiAdd.addName){
                    wifiConnPare.password =  model.network.getEncryptionPassphrase();
                    DBG_ERROR("getWizardNetSetWifiAddConnPare:password=");
                }
            }
        }
        return wifiConnPare;
    }
    wifiAddCancelBtn.onkey_ENTER = function() {
        var networkConfigPanel = UI.getSubModule("networkConfigPanel");
        networkConfigPanel.openFromPwd = 1;
        UI.popSubModule();
    };
    wifiAdd.onkey_BACKSPACE = function() {
        if(wifiAddAuthListGrp.alpha == SHOW){
            setAuthListGrpAlpha(HIDE);
            setAuthBtnGrpAlpha(SHOW);
            UI.focusTo(wifiAuthTypeBtn);
        }else{
            var networkConfigPanel = UI.getSubModule("networkConfigPanel");
            networkConfigPanel.openFromPwd = 1;
            UI.popSubModule();
        }

    };
    wifiAdd.onPop = function(){
        DBG_ALWAYS("wifiAdd  onPop  !!!!!!!!!!!!!!!");
        var networkConfigPanel = UI.getSubModule("networkConfigPanel");
        if(networkConfigPanel.openFromPwd != 3){
            networkConfigPanel.openFromPwd = 1;
        }
    }

};

