// Init
UI.moduleBuilder['setting']['picMode'] = function(){
    //var self = this;

    var picModeDisableVec = [];
    var isHDRFlag = 0;//false;
    var isEnumExist = 0;
    var isJudderSupport = 0;
    var isBlurSupport = 0;
    var logReportStr="";

    // 初始化子模块
    var picModeData = {
        bg: UI["liveTV_bg"],
//        leftArrow: "setting/pic/picModeLeftArrow.png",
//        rightArrow: "setting/pic/picModeRightArrow.png",
        disable_bg: UI.disable_bg
    };
    var template = Util.readJsonObject("module/setting/picMode.json");

    var picModeDataCfg = {
        picMode: {
            title: '[SE0003]',//'Picture Mode',
            description: ' ',
            //Vivid / Standard / Energy Saving / Movie / Game / Sport / Calibrated
            array: [
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/ic_vivid.png", tileTxt: '[SE0456]',Info: "[SE2826]"},//"Vivid"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/ic_Standard.png", tileTxt: '[SE0004]',Info:"[SE2824]"},//"Standard"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/ic_Energy_Saving.png", tileTxt: '[SE0457]',Info:"[SE2887]"},//"Energy Saving"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/ic_Movie.png", tileTxt: '[SE0061]',Info:"[SE2828]"},//"Theater"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/ic_Game.png", tileTxt: '[SE0008]',Info:"[SE2825]"},//"Game"//Best suited for PC or Games console. Reduces Input Lag and improves responsiveness.
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/sport.png", tileTxt: '[LA0013]',Info:"[SE2888]"},//"Sports"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/ic_Calibrated.png", tileTxt: "[SE3122]",Info:"[SE3198]"}//Calibrated
            ]
        },
        picAspectRatio: {
            title: '[SE0461]',//'Aspect Ratio',
            description: ' ',
            array: [
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/auto.png", tileTxt: '[GE0012]', Info:"[SE2896]"},//"Auto"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/normal.png", tileTxt: '[SE0080]', Info:"[SE2897]"},//"Normal"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/zoom.png", tileTxt: '[SE0049]', Info:"[SE2898]"},//"Zoom"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/wide.png", tileTxt: '[SE0463]', Info:"[SE2899]"},//"Wide"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/direct.png", tileTxt: '[SE0467]', Info:"[SE2900]"},//"Direct"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/pixelmap.png", tileTxt: '[SE2901]', Info:"[SE2902]"},//"1:1 Pixel Map"//SE0465
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/panoramic.png", tileTxt: "[SE3127]", Info:"[SE2903]"},//Panoramic
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/cinema.png", tileTxt: '[SE0464]', Info:"[SE2904]"}//"Cinema"
            ]
        },
        picOverScan: {
            title: '[SE0524]',//'Overscan',
            description: ' ',
            array: [
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/on.png", tileTxt: '[GE0004]', Info:"[SE0525]"},//"On"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/off.png", tileTxt: '[GE0006]', Info:"[SE0525]"}//"Off"
            ]
        },
        picColorTemp: {
            title: '[SE0038]',
            description: ' ',
            array: [
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/Tmp_Low.png", tileTxt: '[GE0003]', Info:"[SE0483]"},//"Low"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/Tmp_Middle_Low.png", tileTxt: "[SE3128]", Info:"[SE0483]"},//Mid-Low
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/Tmp_Middle.png", tileTxt: '[GE0002]', Info:"[SE0483]"},//"Medium"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/Tmp_High.png", tileTxt: '[GE0001]', Info:"[SE0483]"}//"High"
            ]
        },
        picActiveContrast: {
            title: '[SE3137]',
            description: ' ',
            array: [
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/off.png", tileTxt: '[GE0006]', Info:"[SE0482]"},//"Off"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/low.png", tileTxt: '[GE0003]', Info:"[SE0482]"},//"Low"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/middle.png", tileTxt: '[GE0002]', Info:"[SE0482]"},//"Medium"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/high.png", tileTxt:  '[GE0001]', Info:"[SE0482]"}//"High"
            ]
        },
        picAquoMotionEnhancement: {
            title: '[SE3132]',
            description: ' ',
            //Smooth / Standard / Clear / Animation / Custom / Off
            array: [
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/off.png", tileTxt: '[GE0006]', Info:"[SE3204]",Idx:0},//"Off"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/custom.png", tileTxt: '[SE0010]', Info:"[SE3203]",Idx:1},//"Custom"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/film.png", tileTxt: '[SE1437]', Info:"[SE3202]",Idx:2},//Film
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/clear.png", tileTxt: '[BR0017]', Info:"[SE3201]",Idx:3},//"Clear"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/standard.png", tileTxt: '[SE0004]', Info:"[SE3200]",Idx:4},//"Standard"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/smooth.png", tileTxt: "[SE3129]", Info:"[SE3199]",Idx:5}
            ]
        },
        picFilmMode: {
            title: '[SE3133]',
            description: ' ',
            array: [
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/Auto.png", tileTxt: '[GE0012]', Info:""},//"Auto"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/Off.png", tileTxt: '[GE0006]', Info:""}//"Off"
            ]
        },
        picDigitalNoiseReduction: {
            title: '[SE3135]',
            description: 'Digital Noise Reduction description',
            array: [
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/off.png", tileTxt: '[GE0006]', Info:"[SE0528]"},//"Off"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/low.png", tileTxt: '[GE0003]', Info:"[SE0528]"},//"Low"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/middle.png", tileTxt: '[GE0002]', Info:"[SE0528]"},//"Medium"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/high.png", tileTxt: '[GE0001]', Info:"[SE0528]"}//"High"
            ]
        },
        picHDMIDynamicRange: {
            title: '[SE3136]',
            description: ' ',
            array: [
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/HDMI_Auto.png", tileTxt: '[GE0012]', Info:"[SE2916]"},//"Auto",
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/HDMI_Limit.png", tileTxt: "[SE3130]", Info:"[SE2916]"},//Limit
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/HDMI_Full.png", tileTxt: '[SE0050]', Info:"[SE2916]"}//"Full"
            ]
        },
        picColorSpace: {
            title: '[SE3138]',
            description: ' ',
            array: [
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/ColorSpace_Auto.png", tileTxt: '[GE0012]', Info:"[SE3143]"},//"Auto",
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/ColorSpace_Native.png", tileTxt: '[SE2746]', Info:"[SE3143]"}//"Native"
            ]
        },
        picGammaAdjustment: {
            title: '[SE3139]',
            description: ' ',
            array: [
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/Gamma1.8.png", tileTxt: "1.8", Info:"[SE2930]"}, //"1.8" //todo
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/Gamma2.0.png", tileTxt: "2.0", Info:"[SE2930]"}, //"2.0" //todo
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/Gamma2.2.png", tileTxt: "2.2", Info:"[SE2930]"}, //"2.2" //todo
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/Gamma2.4.png", tileTxt: "2.4", Info:"[SE2930]"}, //"2.4" //todo
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/GammaBT1886.png", tileTxt: "ITU.BT1886", Info:"[SE2930]"} //"ITU.BT1886" //todo
            ]
        },
        picGammaAdjustment2: {
            title: '[SE3139]',
            description: ' ',
            array: [
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/Gamma2.2.png", tileTxt: "2.2", Info:"[SE2930]"}, //"2.2" //todo
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/Gamma2.4.png", tileTxt: "2.4", Info:"[SE2930]"} //"2.4" //todo
            ]
        },
        picRGBOnlyMode: {
            title: '[SE3140]',
            description: ' ',
            array: [
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/off.png", tileTxt: '[GE0006]', Info:"[SE3205]"},//"Off"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/red.png", tileTxt: '[SE0517]', Info:"[SE3205]"},//"Red"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/green.png", tileTxt: '[SE0519]', Info:"[SE3205]"},//"Green"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/blue.png", tileTxt: '[SE0521]', Info:"[SE3205]"}//"Blue"
            ]
        }

    };

    var logReportModeVec={
        "pictureMode":["Vivid","Standard","Energy Saving","Theater","Game", "Sport", "Calibrated"],
        "pictureModeSdr":["Vivid","Standard","Energy Saving","Theater","Game", "Sport", "Calibrated"],
        "pictureModeHdr": ["HDR Vivid", "HDR Standard", "HDR Energy Saving", "HDR Theater", "HDR Game", "HDR Sports", "HDR Calibrated"],
        "aspectRatio":["Auto", "Normal", "Zoom", "Wide", "Direct", "Dot-By-Dot", "Panoramic", "Cinema"],
        "MotionEnhancement":["Off","Custom","Film","Clear","Standard","Smooth"],
        "NoiseReduction":["Off","Low","Medium","High"],
        "HDMIDynamicRange":["Auto","Limit","Full"]
    };

    var HdrPicMode = {
        //(HDR Vivid /HDR  Standard / HDR Energy Saving / HDR Theater /HDR  Game / HDR Sports /HDR  Calibrated)
        hdrPictureMode:{
            array: [
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/ic_vivid.png", tileTxt: '[OT0098]',Info: "[SE2826]"},//"Vivid"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/ic_Standard.png", tileTxt: '[OT0095]',Info:"[SE2824]"},//"Standard"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/ic_Energy_Saving.png", tileTxt: '[OT0099]',Info:"[SE2887]"},//"Energy Saving"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/ic_Movie.png", tileTxt: '[OT0100]',Info:"[SE2828]"},//"Theater"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/ic_Game.png", tileTxt: '[OT0094]',Info:"[SE2825]"},//"Game"//Best suited for PC or Games console. Reduces Input Lag and improves responsiveness.
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/sport.png", tileTxt: '[SE3404]',Info:"[SE2888]"},//"Sports"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/ic_Calibrated.png", tileTxt: "[OT0102]",Info:"[SE3198]"}//Calibrated
            ]
        }
    };
    var SdrPicMode = {
        sdrPictureMode:{
            //Standard, Cinema day, Cinema Night, PC/Game, Dynamic
            array: [
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/ic_vivid.png", tileTxt: '[SE0456]',Info: "[SE2826]"},//"Vivid"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/ic_Standard.png", tileTxt: '[SE0004]',Info:"[SE2824]"},//"Standard"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/ic_Energy_Saving.png", tileTxt: '[SE0457]',Info:"[SE2887]"},//"Energy Saving"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/ic_Movie.png", tileTxt: '[SE0061]',Info:"[SE2828]"},//"Theater"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/ic_Game.png", tileTxt: '[SE0008]',Info:"[SE2825]"},//"Game"//Best suited for PC or Games console. Reduces Input Lag and improves responsiveness.
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/sport.png", tileTxt: '[LA0013]',Info:"[SE2888]"},//"Sports"
                {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/ic_Calibrated.png", tileTxt: "[SE3122]",Info:"[SE3198]"}//Calibrated
            ]
        }
    };

    DBG_INFO('PictureConfig.picModeSign:' + PictureConfig.picModeSign);

    var picMode = SubModule.create(picModeData, template);
    var comData = {
        OffFlag:0xFF,
        CustomFlag:0x02,
        FilmFlag:0x04,
        ClearFlag:0x08,
        StandardFlag:0x10,
        SmoothFlag:0x20,
        ExistFlag:0x80
    };
    var isFirstFlag = false;

    var showAllGammaProductList = ["HU43A6106UW", "HU50A6106UW", "HU55A6106UW", "HU65A6106UW", "HU55A6109UW", "HU65A6109UW"];
    var isNeedShowAllGamma = false;

    picMode.onPush = function () {
        var productType = tv ? model.hisfactory.getProductType() : "0000";
        var index = showAllGammaProductList.indexOf(productType);
        if (index < 0) {
            picModeDataCfg.picGammaAdjustment = picModeDataCfg.picGammaAdjustment2;
        } else {
            isNeedShowAllGamma = true;
        }
    	  HdrOrSdrPicMode();
        if (PicSignDefine.PicModeSign.PIC_AQUOMOTION_ENHANCEMENT == PictureConfig.picModeSign){
            AquoMotionEnhancementMode();
            AquoMotionEnhancementName();
        }
        var grid = UI.getItem(picMode, "grid");
        grid != StrDef.UNDEFINED && grid.removeAllChildren();
        var array = [];// getObjCopy(picModeDataCfg[PictureConfig.picModeSign].array);
        var arrayData = picModeDataCfg[PictureConfig.picModeSign].array;
        for (var i = 0; i < arrayData.length; i++) {
            array.push({
                tileBg: arrayData[i].tileBg,
                tileImg: arrayData[i].tileImg,
                tileTxt: arrayData[i].tileTxt
            });
        }
        var info = {
            template: "picModeNewTile",
            direction: CONST.GIRD_DIRECTION.V,
            breakNum: 1,
            distanceX: 20,
            distanceY: 0,
            container: grid
        };
        Gird.create(array, info);

        var curFocusIdx = getPicModeModelValue();
        UI.setText(UI.getItem(picMode, 'title'), picModeDataCfg[PictureConfig.picModeSign].title);
        DisableInvalidItem();
//        picMode.currFocus = UI.getItem(picMode, "picModeNewTile" + curFocusIdx);
        try {
            var picModeFocus=UI.getItem(picMode, "picModeNewTile" + curFocusIdx);
        } catch (ex) {
            DBG_ERROR(ex.message);
            picModeFocus=UI.getItem(picMode, "picModeNewTile" + 0);
        }
        if(!!picModeFocus){
            picMode.currFocus = picModeFocus;
        }else{
            picMode.currFocus = UI.getItem(picMode, "picModeNewTile" + 0);
        }
        UI.resetViewPos(UI.getItem(picMode, "grid"));

        if (PicModeGrid.selectedItem) {
            PicModeGrid.selectedItem.removeChild(selectedFlg, true);
            PicModeGrid.selectedItem = UI.getItem(picMode, picMode.currFocus.name);
        }
        PicModeGrid.initSequence[curFocusIdx].addChild(selectedFlg);
        PicModeGrid.selectedItem = UI.getItem(picMode, picMode.currFocus.name);
    };

    picMode.onShow = function () {
        picMode.alpha = 1;
    };
    UI.addMask(UI.getItem(picMode, "grid"), 1760, 180, 10, 40);
    UI.setView(UI.getItem(picMode, "grid"), 1760, 180 ,0, 0);

    function HdrOrSdrPicMode(){
        try {
            isHDRFlag = tv ? model.video.getHdrFlag() :0;
            DBG_INFO("model.video.getHdrFlag(): " + isHDRFlag);
            picModeDataCfg.picMode.array = isHDRFlag ? HdrPicMode.hdrPictureMode.array : SdrPicMode.sdrPictureMode.array;
            logReportModeVec.pictureMode = isHDRFlag ? logReportModeVec.pictureModeHdr : logReportModeVec.pictureModeSdr;
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }
    
    function AquoMotionEnhancementName(){
        if(PicSignDefine.PicModeSign.PIC_AQUOMOTION_ENHANCEMENT != PictureConfig.picModeSign){
            return;
        }
//        var brand = tv ? model.system.getCurBrand(): "his";
        if (GLOBAL.UI_BRAND=="shp"){
            picModeDataCfg.picAquoMotionEnhancement.title = "[SE3132]";//AquoMotionEnhancement
            DBG_INFO("picAquoMotionEnhancement.title = " + picModeDataCfg.picAquoMotionEnhancement.title);
            picModeDataCfg.picAquoMotionEnhancement.array[0].Info="[SE3204]";
            picModeDataCfg.picAquoMotionEnhancement.array[2].Info="[SE3202]";
        }else{
            picModeDataCfg.picAquoMotionEnhancement.title = "[OT0255]";//Motion Enhancement
            DBG_INFO("picAquoMotionEnhancement.title = " + picModeDataCfg.picAquoMotionEnhancement.title);
            picModeDataCfg.picAquoMotionEnhancement.array[0].Info="[SE3551]";
            picModeDataCfg.picAquoMotionEnhancement.array[2].Info="[SE3552]";
        }
    }
    function AquoMotionEnhancementMode(){
        try {
            DBG_INFO('PictureConfig.picModeSign:' + PictureConfig.picModeSign);
            if(PicSignDefine.PicModeSign.PIC_AQUOMOTION_ENHANCEMENT != PictureConfig.picModeSign){
                return;
            }
            if(!isFirstFlag){
                isFirstFlag = true;
                isEnumExist = tv ? model.video.getEnumSmoothMotionExist() : 0xBF;//0xBF
                DBG_INFO("model.video.getEnumSmoothMotionExist(): " + isEnumExist);
                isJudderSupport = tv ? model.video.getJudderReductionExist() : 1;//1
                DBG_INFO("model.video.getJudderReductionExist(): " + isJudderSupport);
                isBlurSupport = tv ? model.video.getBlurReductionExist() : 1;//1
                DBG_INFO("model.video.getBlurReductionExist(): " + isBlurSupport);
                var ultraArray = picModeDataCfg[PictureConfig.picModeSign].array;
                var ultraIndex = [];
                if(isEnumExist&comData.ExistFlag){
                    //Smooth / Standard / Clear / Animation / Custom / Off
                    var stdVal = [comData.OffFlag,comData.CustomFlag,comData.FilmFlag,comData.ClearFlag,comData.StandardFlag,comData.SmoothFlag];
                    for(var i=5; i>0;i--){
                        if(i==1){
                            ultraIndex[i] = (isEnumExist&stdVal[i]) && (isJudderSupport &&isBlurSupport) ? 0: 1;
                        }else{
                            ultraIndex[i] = isEnumExist&stdVal[i] ? 0: 1;
                        }
                        ultraArray.splice(i,ultraIndex[i]);
                    }
                }
                picModeDataCfg.picAquoMotionEnhancement.array = ultraArray;
                DBG_INFO("ultraArray = "+ultraArray);
            }
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }
    function getPicModeModelValue() {
        try {
            var val = 0;
            picModeDisableVec = [];
            switch (PictureConfig.picModeSign) {
                case PicSignDefine.PicModeSign.PIC_MODE:
                    picMode.noAutoClose = false;
                    val = tv ? model.video.getEnumPictureMode() : 3;
                    DBG_INFO("model.video.getEnumPictureMode(): " + val);
                    if (false == getGameModeEnable()) {
                        picModeDisableVec = [4];
                    }
                    break;
                case PicSignDefine.PicModeSign.PIC_ASPECT_RATIO:
                    picMode.noAutoClose = false;
                    val = tv ? model.video.getEnumZoom() : 14;
                    DBG_INFO("model.video.getEnumZoom(): " + val);
                    val = ({0:3, 1:1, 2:6, 3:5, 4:2, 12:7, 13:0, 14:4}[val]);
                    if(false == getPixMapEnable())
                        picModeDisableVec.push(5);
                    if(false == getPanaramicEnable())
                        picModeDisableVec.push(6);
                    break;
                case PicSignDefine.PicModeSign.PIC_OVER_SCAN:
                    picMode.noAutoClose = false;
                    val = tv ? model.video.getOverscan() : 0;
                    DBG_INFO("model.video.getOverscan(): " + val);
                    val = ({0: 1, 1: 0}[val]);
                    break;
                case PicSignDefine.PicModeSign.PIC_COLOR_TEMP:
                    picMode.noAutoClose = false;
                    val = tv ? model.video.getEnumColourTemperature() : 1;
                    DBG_INFO("model.video.getEnumColourTemperature(): " + val);
                    val = ({0: 3, 1: 2, 2: 0, 3: 1}[val]);
                    break;
                case PicSignDefine.PicModeSign.PIC_AQUOMOTION_ENHANCEMENT:
                    picMode.noAutoClose = false;
                    var MemcTmp = tv ? model.video.getEnumSmoothMotion() : 5;
                    DBG_INFO("model.video.getEnumSmoothMotion()： " + MemcTmp);
                    for (var i = 0; i < picModeDataCfg.picAquoMotionEnhancement.array.length; i++) {
                        if (MemcTmp == picModeDataCfg.picAquoMotionEnhancement.array[i].Idx) break;
                    }
                    val = i;
                    break;
                case PicSignDefine.PicModeSign.PIC_DIGITAL_NOISE_REDUCTION:
                    picMode.noAutoClose = false;
                    val = tv ? model.video.getEnumNoiseReduction() : 0;
                    DBG_INFO("model.video.getEnumNoiseReduction(): " + val);
                    break;
                case PicSignDefine.PicModeSign.PIC_HDMI_DYNAMIC_RANGE:
                    picMode.noAutoClose = false;
                    val = tv ? model.video.getHdmiDynamicRange() : 1;
                    DBG_INFO("model.video.getHdmiDynamicRange(): " + val);
                    break;
                case PicSignDefine.PicModeSign.PIC_ACTIVE_CONTRAST:
                    picMode.noAutoClose = false;
                    val = tv ? model.video.getAdaptiveContrast() : 0;
                    DBG_INFO("model.video.getAdaptiveContrast(): " + val);
                    break;
                case PicSignDefine.PicModeSign.PIC_COLOR_SPACE:
                    picMode.noAutoClose = false;
                    val = tv ? model.video.getColorSpace() : 0;
                    DBG_INFO("model.video.getColorSpace(): " + val);
                    break;
                case PicSignDefine.PicModeSign.PIC_GAMMA_ADJUSTMENT:
                    picMode.noAutoClose = true;
                    val = tv ? model.video.getHdmiGammaAdjustment() : 1;
                    if (isNeedShowAllGamma) {
                        val = ({0: 1, 1: 2, 2: 3, 3: 4, 4: 0}[val]);
                    } else {
                        val = ({1: 0, 2: 1}[val]);
                    }
                    DBG_INFO("model.video.getHdmiGammaAdjustment(): " + val);
                    break;
                case PicSignDefine.PicModeSign.PIC_RGBONLY_MODE:
                    picMode.noAutoClose = true;
                    val = tv ? model.video.getRgbOnlyMode() : 0;
                    DBG_INFO("model.video.getRgbOnlyMode(): " + val);
                    break;
                default:
                    DBG_ERROR("PictureConfig.picModeSign ERR");
                    break;
            }
            if(val==undefined){val=0;}
            return val;
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

    function DisableInvalidItem() {
        for (var i = 0; i < picModeDisableVec.length; i++) {
            var disableItem = UI.getItem(picMode, "picModeNewTile" + picModeDisableVec[i]);
            disableItem.disable = true;
            disableItem.alpha = 0.26;
        }
    }

    function HidePicMode() {
        picMode.alpha = 0;
    }


    var selectedFlg = new PIXI.Graphics();
    selectedFlg.beginFill(OEMFunction.getInstance().getBrandColor()).drawRect(0, 152, 295, 8).endFill();

    var PicModeGrid = UI.getItem(picMode, 'grid');
    PicModeGrid.onFocus = function () {
        DBG_INFO('PicModeGrid.onFocus');
        var currFocus = picMode.currFocus;
        if (!PicModeGrid.selectedItem) {
            currFocus.addChild(selectedFlg);
            PicModeGrid.selectedItem = UI.getItem(picMode, currFocus.name);
        }
        var curFocusIdx = currFocus.name.substr(14);
        UI.setText(UI.getItem(picMode, 'description'), picModeDataCfg[PictureConfig.picModeSign].array[curFocusIdx].Info);
        UI.updateStage();
        return true;
    };

    PicModeGrid.onkey_ENTER = function () {
        var currFocus = picMode.currFocus;
        if (PicModeGrid.selectedItem) {
            PicModeGrid.selectedItem.removeChild(selectedFlg, true);
            PicModeGrid.selectedItem = UI.getItem(picMode, currFocus.name);
        }
        currFocus.addChildAt(selectedFlg,currFocus.children.length-2);
        var curIdx = parseInt(currFocus.name.substr(14));
        UI.updateStage();

        SetPicModeModelValue(curIdx);
    };

    PicModeGrid.onkey_BACKSPACE = function () {
        DBG_INFO('PicModeGrid.onkey_BACKSPACE');
        UI.popSubModule();
        var picMain = UI.getSubModule("picMain");
        if(!!picMode.param && !!picMode.param.caller && picMode.param.caller.toString()=="hiMedia"){
            hiMedia.changeByLauncher("resume");
        }else if (!!picMode.caller && picMode.caller == "picMain") {
            picMain.alpha = 1;
        } else if(PictureConfig.picModeSign==PicSignDefine.PicModeSign.PIC_MODE){
            if(window["setting"]["menuChip"]){
                window["setting"]["menuChip"].open();
            }
            else {
                UI.pushSubModule("setting","menuChip",true,picMode.param,null,"CHIP"+ CHIPS.PIC_MODE);

            }
        }
        else if(PictureConfig.picModeSign==PicSignDefine.PicModeSign.PIC_ASPECT_RATIO){
            if(window["setting"]["menuChip"]){
                window["setting"]["menuChip"].open();
            }
            else {
                UI.pushSubModule("setting","menuChip",true,picMode.param,null,"CHIP"+ CHIPS.ASPECT);

            }

        }
    };

    function SetPicModeModelValue(curIdx) {
        try {
            switch (PictureConfig.picModeSign) {
                case PicSignDefine.PicModeSign.PIC_MODE:
                    tv && model.video.SetPictureAdjustment(curIdx,1,1);
                    DBG_INFO("model.video.SetPictureAdjustment(" + curIdx + ")"
                        +"logReportModeVec.pictureMode:"+logReportModeVec.pictureMode[curIdx]);
                    logReportStr="Picture mode";
                    try {
                        LGReport.GTSETItem(logReportStr, logReportModeVec.pictureMode[curIdx]);
                    } catch (ex) {
                        DBG_ERROR(ex.message);
                    }
                    break;
                case PicSignDefine.PicModeSign.PIC_ASPECT_RATIO:
                    curIdx = ({0:13, 1:1, 2:4, 3:0, 4:14, 5:3, 6:2, 7:12}[curIdx]);
                    tv && model.video.setEnumZoom(curIdx);
                    DBG_INFO("model.video.setEnumZoom(" + curIdx + ")");
                    logReportStr="Aspect Ratio";
                    curIdx = ({13:0, 1:1, 4:2, 0:3, 14:4, 3:5, 2:6, 12:7}[curIdx]);
                    DBG_INFO("logReportModeVec.aspectRatio:"+logReportModeVec.aspectRatio[curIdx]);
                    try {
                        LGReport.GTSETItem(logReportStr, logReportModeVec.aspectRatio[curIdx]);
                    } catch (ex) {
                        DBG_ERROR(ex.message);
                    }
                    break;
                case PicSignDefine.PicModeSign.PIC_OVER_SCAN:
                    curIdx = ({0: 1, 1: 0}[curIdx]);
                    tv && model.video.setOverscan(curIdx);
                    DBG_INFO("model.video.setOverscan(" + curIdx + ")");
                    break;
                case PicSignDefine.PicModeSign.PIC_COLOR_TEMP:
                    curIdx = ({0: 2, 1: 3, 2: 1, 3: 0}[curIdx]);
                    tv && model.video.setEnumColourTemperature(curIdx);
                    DBG_INFO("model.video.setEnumColourTemperature(" + curIdx + ")");
                    break;
                case PicSignDefine.PicModeSign.PIC_AQUOMOTION_ENHANCEMENT:
                    DBG_INFO("isEnumExist: " + isEnumExist + "  curIdx: " + curIdx);
                    curIdx = picModeDataCfg.picAquoMotionEnhancement.array[curIdx].Idx;
                    tv && model.video.setEnumSmoothMotion(curIdx);
                    DBG_INFO("model.video.setEnumSmoothMotion(" + curIdx + ")");
                    if (1 == curIdx) {
                        HidePicMode();
                        if(isJudderSupport && isBlurSupport){
                            PictureConfig.PicJudderBlurSign = PicSignDefine.PicJudderBlurSign.PIC_JUDDER;
                            UI.pushSubModule("setting", "picJudderBlurReductionAdjust", true);
                        }
                    }
                    logReportStr="Ultra Smooth Motion";
                    DBG_INFO("logReportModeVec.MotionEnhancement:"+logReportModeVec.MotionEnhancement[curIdx]);
                    try {
                        LGReport.GTSETItem(logReportStr, logReportModeVec.MotionEnhancement[curIdx]);
                    } catch (ex) {
                        DBG_ERROR(ex.message);
                    }
                    break;
                case PicSignDefine.PicModeSign.PIC_FILM_MODE:
                    curIdx = ({0: 1, 1: 0}[curIdx]);
                    tv && model.video.setFilmModeState(curIdx);
                    DBG_INFO("model.video.setFilmModeState(" + curIdx + ")");
                    break;
                case PicSignDefine.PicModeSign.PIC_DIGITAL_NOISE_REDUCTION:
                    tv && model.video.setEnumNoiseReduction(curIdx);
                    DBG_INFO("model.video.setEnumNoiseReduction(" + curIdx + ")");
                    logReportStr="Noise Reduction";
                    DBG_INFO("logReportModeVec.NoiseReduction:"+logReportModeVec.NoiseReduction[curIdx]);
                    try {
                        LGReport.GTSETItem(logReportStr, logReportModeVec.NoiseReduction[curIdx]);
                    } catch (ex) {
                        DBG_ERROR(ex.message);
                    }
                    break;
                case PicSignDefine.PicModeSign.PIC_HDMI_DYNAMIC_RANGE:
                    tv && model.video.setHdmiDynamicRange(curIdx);
                    DBG_INFO("model.video.setHdmiDynamicRange(" + curIdx + ")");
                    logReportStr="Black Level";
                    DBG_INFO("logReportModeVec.HDMIDynamicRange:"+logReportModeVec.HDMIDynamicRange[curIdx]);
                    try {
                        LGReport.GTSETItem(logReportStr, logReportModeVec.HDMIDynamicRange[curIdx]);
                    } catch (ex) {
                        DBG_ERROR(ex.message);
                    }
                    break;
                case PicSignDefine.PicModeSign.PIC_ACTIVE_CONTRAST:
                    tv && model.video.setAdaptiveContrast(curIdx);
                    DBG_INFO("model.video.setAdaptiveContrast(" + curIdx + ")");
                    break;
                case PicSignDefine.PicModeSign.PIC_COLOR_SPACE:
                    tv && model.video.setColorSpace(curIdx);
                    DBG_INFO("model.video.setColorSpace(" + curIdx + ")");
                    break;
                case PicSignDefine.PicModeSign.PIC_GAMMA_ADJUSTMENT:
                    var tmpCurIdx;
                    if (isNeedShowAllGamma) {
                        tmpCurIdx= ({0: 4, 1: 0, 2: 1, 3: 2, 4: 3}[curIdx]);
                    } else {
                        tmpCurIdx = ({0: 1, 1: 2}[curIdx]);
                    }
                    tv && model.video.setHdmiGammaAdjustment(tmpCurIdx);
                    DBG_INFO("model.video.setHdmiGammaAdjustment(" + curIdx + ")");
                    break;
                case PicSignDefine.PicModeSign.PIC_RGBONLY_MODE:
                    tv && model.video.setRgbOnlyMode(curIdx);
                    DBG_INFO("model.video.setRgbOnlyMode(" + curIdx + ")");
                    break;
                default:
                    DBG_ERROR("PictureConfig.picModeSign ERR");
                    break;
            }
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }

};

