// Init
UI.moduleBuilder['setting']['ChMainPanel'] = function(){

    var mainPanelData = {
        ChSheetImg:UI.setting_bg,
        ChImg:"setting/"+GLOBAL.LAUNCHER_BRAND+"/ic_channel_154x154.png",
        TunerModeImg:UI.btn_normal_bg,
        AutoScanImg:UI.btn_normal_bg,
        ManualScanImg:UI.btn_normal_bg,
        FavListImg:UI.btn_normal_bg,
        SkipListImg:UI.btn_normal_bg,
        ChTitle2:"[SE0089]",//Channel
        TunerModeText:"[SE0582]",//"Tuner Mode",
        SelectModeText:"[SE0385]",// "Cable",
        AutoScanText:"[SE0584]",//"Auto Channel Scan",
        ManualScanText:"[SE3149]",//"Add A Channel",
        FavListText:"[SE0590]", // "Channel Skip",
        SkipListText:"[SE0592]"// "Favourites List",

    };
    var template = Util.readJson("module/setting/ChMainPanel.json");
    var ChMainPanel = SubModule.create(mainPanelData, template);

    var ChMainGrp = UI.getItem(ChMainPanel,"ChMainGrp");
    var ChFavListBtn = UI.getItem(ChMainGrp,"ChFavListBtn");
    var ChSkipListBtn = UI.getItem(ChMainGrp,"ChSkipListBtn");
    var ChManualScanBtn = UI.getItem(ChMainPanel, "ChManualScanBtn");
    var ChAutoScanBtn = UI.getItem(ChMainPanel, "ChAutoScanBtn");
    var ChTitle2 = UI.getItem(ChMainPanel, "ChTitle2");
    var TunerModeSelectBar = UI.getItem(ChMainGrp,"TunerModeSelectBar");
    var RightImg = UI.getItem(TunerModeSelectBar, "RightImg");
    ChMainPanel.TunerTypeListData = ["[SE0384]", "[SE0385]"];//"Antenna","Cable"
    var selectComp = UI.getItem(TunerModeSelectBar, "SelectModeText");
    Select.create(selectComp,ChMainPanel.TunerTypeListData );
    ChMainPanel.CurrTunerMode = 0;
    var ChTitle3 = UI.getItem(ChMainPanel, "ChTitle3");
    ChTitle3.children[0].lineHeight = 50;
    ChTitle3.children[0].lineWidth = 512;
    ChMainPanel.onPush =  function(){
        DBG_INFO(" ChMainPanel.onPush ::"+ ChMainPanel.CurrTunerMode);
        ChMainPanel.currSource = tv?getCurrentSourceId():0;
        DBG_INFO("ChMainPanel.currSource"+ChMainPanel.currSource+"appControl.getCurrentAPPName():"+appControl.getCurrentAPPName());
        if((appControl.getCurrentAPPName() != APPNAME.EPOS && checkIsAppOn())||GLOBAL.MEDIA_STARTUP_FLAG ||(ChMainPanel.currSource !=0)||GLOBAL.MIRACAST_STARTFLAG) {   // 判断当前有应用在运行时、非TV通道下灰掉搜台选项,焦点定位到skip list上
            ChMainPanel.currFocus = UI.getItem(ChMainGrp, "ChSkipListBtn");
        }else{
            ChMainPanel.currFocus = UI.getItem(ChMainGrp, "TunerModeSelectBar");
        }
        selectComp.onFocus();

        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.LIVETV_MAIN_PLAY_CHANGED, mainPlayChannelChanged);
    };
    ChMainPanel.onShow =  function(){
        ChMainPanel.alpha=1;
        var mainPanel =UI.getSubModule("mainPanel");
        if(!!mainPanel)
        {
            mainPanel.alpha=0;
        }
        if(UI.isExistModule('launcher')){
            UI.hideModule(launcher);
        }
        if(tv){
            ChMainPanel.CurrTunerMode = model.channelSearch.getSource();
        }
        //Change here for Tuner mode default change.
        var index;
        switch( ChMainPanel.CurrTunerMode ) {
            case 17: //for power cut when scaning ATV
                ChMainPanel.CurrTunerMode = 15;
                model.channelSearch.setSource(15); //ATSC-T
                setPlayedChListIndex(CHLISTINDEX.ALL);
            case 15:
                index = 0; //common setting for src 15/17
                break;
            case 18: //for power cut when scaning ATV
                ChMainPanel.CurrTunerMode = 16;
                model.channelSearch.setSource(16); //ATSC-C
                setPlayedChListIndex(CHLISTINDEX.ALL);
            case 16:
                index = 1; //common setting for src 16/18
                break;
            default:
                index = ChMainPanel.CurrTunerMode;
                break;
        }
        selectComp.selectCurrent(index);
        DBG_INFO(" ChMainPanel.onShow ::"+ ChMainPanel.CurrTunerMode,DebugLevel.ALWAYS);
        disableChannelItem();
    };
    ChMainPanel.open=function(){
        ChMainPanel.alpha=1;
    };
    ChMainPanel.close=function(){
        ChMainPanel.alpha=0;
    };
    ChMainPanel.setTunerMode = function(idx){
        DBG_INFO("setTunerMode:scanType="+idx,DebugLevel.INFO);
        ChMainPanel.CurrTunerMode = idx;
        selectComp.selectCurrent(idx);
    };
    function disableChannelItem(){
        DBG_ERROR("disableChannelItem="+GLOBAL.MEDIA_STARTUP_FLAG +"appControl.getCurrentAPPName():"+appControl.getCurrentAPPName());
        if((appControl.getCurrentAPPName() != APPNAME.EPOS && checkIsAppOn())||GLOBAL.MEDIA_STARTUP_FLAG||(ChMainPanel.currSource !=0) ||GLOBAL.MIRACAST_STARTFLAG){   // 判断当前有应用在运行时、非TV通道下灰掉搜台选项
            DBG_INFO("checkIsAppOn",DebugLevel.ALWAYS);
            TunerModeSelectBar.disable = true;
            TunerModeSelectBar.alpha = 0.3;
            ChAutoScanBtn.disable = true;
            ChAutoScanBtn.alpha = 0.3;
            ChManualScanBtn.disable = true;
            ChManualScanBtn.alpha = 0.3;
        }else{
            TunerModeSelectBar.disable = false;
            TunerModeSelectBar.alpha = 1;
            ChAutoScanBtn.disable = false;
            ChAutoScanBtn.alpha = 1;
            ChManualScanBtn.disable = false;
            ChManualScanBtn.alpha = 1;
        }
        UI.updateStage();
    }
    ChMainPanel.currFocus = UI.getItem(ChMainGrp, "TunerModeSelectBar");

    var channelhelplist =[
        {
            "title": "Tuner Mode",
            "content": "[SE3017]"//"Select if you receive TV channels over the air (antenna) or through a cable set top box. "
        },
        {
            "title": "Auto Channel Scan",
            "content": "[SE0585]" //"Automatically scan for channels to view programming from your TV source."
        },
        {
            "title": "Manual Scan",
            "content": "[SE3019]" //"Type in a channel to add it manually to your TV."
        },
        {
            "title": "Channel Skip",
            "content": "[SE0591]" // "Skip a channel that your TV picked up during a previous channel scan search."
        },
        {
            "title":  "Favourites List",
            "content": "[SE0593]" // "Quickly access your most-watched channels by creating a Favourites list."
        }
    ];
    ChMainPanel.onFocus = function(){
        try
        {
        var settingChGrouplist = ["TunerModeSelectBar","ChAutoScanBtn","ChManualScanBtn","ChSkipListBtn","ChFavListBtn"];
        var index = settingChGrouplist.indexOf(ChMainPanel.currFocus.name);
        UI.setText(ChTitle3,channelhelplist[index].content);
        //UI.setTextColor(ChMainPanel.currFocus.children[1],"rgba(255,255,255,1.0)");
        //    if(index==0){
        //        selectComp.onFocus();
        //    }
        }catch (e) {
            DBG_ERROR(e.message)
        }
        //UI.updateStage();
        return true;
    };

        TunerModeSelectBar.onkey_ENTER = function () {
            if ((appControl.getCurrentAPPName() == APPNAME.EPOS) && checkIsAppOn()) {
                DBG_ERROR("TunerModeSelectBar.onkey_ENTER:epos is on,stop it");
                appControl.stopCurrentApp();
                appStoppedFunc = function () {
                    var index = ChMainPanel.TunerTypeListData.indexOf(selectComp.selected);
                    ChMainPanel.CurrTunerMode = index;
                    UI.pushSubModule("setting", "ChScanTypePanel", true);
                };
            }else{
                var index = ChMainPanel.TunerTypeListData.indexOf(selectComp.selected);
                ChMainPanel.CurrTunerMode = index;
                UI.pushSubModule("setting", "ChScanTypePanel", true);
            }
        };
        TunerModeSelectBar.onkey_RIGHT = function() {
            if ((appControl.getCurrentAPPName() == APPNAME.EPOS) && checkIsAppOn()) {
                DBG_ERROR("TunerModeSelectBar.onkey_RIGHT:epos is on,stop it");
                appControl.stopCurrentApp();
                appStoppedFunc = function () {
                    if(liveTV.getHasChannelFlag()){ // 没台的时候底层不会notify UI 空台，避免不能解锁无台的时候不锁键；
                        UI.startLoading();
                    }
                    selectComp.selectNext();
                    var index = ChMainPanel.TunerTypeListData.indexOf(selectComp.selected);
                    ChangeTunerMode(index);
                    DBG_INFO("index:::::"+ index);
                    //disableChannelItem();
                    liveTV.playAfterChangeTunerMode(index);
                };
            }else{
                if(liveTV.getHasChannelFlag()){ // 没台的时候底层不会notify UI 空台，避免不能解锁无台的时候不锁键；
                    UI.startLoading();
                }
                selectComp.selectNext();
                var index = ChMainPanel.TunerTypeListData.indexOf(selectComp.selected);
                ChangeTunerMode(index);
                DBG_INFO("index:::::"+ index);
                //disableChannelItem();
                liveTV.playAfterChangeTunerMode(index);
            }
            return true;
        };
        TunerModeSelectBar.onkey_LEFT = function() {
            if ((appControl.getCurrentAPPName() == APPNAME.EPOS) && checkIsAppOn()) {
                DBG_ERROR("TunerModeSelectBar.onkey_LEFT:epos is on,stop it");
                appControl.stopCurrentApp();
                appStoppedFunc = function () {
                    if(liveTV.getHasChannelFlag()){
                        UI.startLoading();
                    }
                    selectComp.selectPrev();
                    var index = ChMainPanel.TunerTypeListData.indexOf(selectComp.selected);
                    ChangeTunerMode(index);
                    //disableChannelItem();
                    DBG_INFO("index:::::"+ index);
                    liveTV.playAfterChangeTunerMode(index);
                };
            }else{
                if(liveTV.getHasChannelFlag()){
                    UI.startLoading();
                }
                selectComp.selectPrev();
                var index = ChMainPanel.TunerTypeListData.indexOf(selectComp.selected);
                ChangeTunerMode(index);
                //disableChannelItem();
                DBG_INFO("index:::::"+ index);
                liveTV.playAfterChangeTunerMode(index);
            }
            return true;
        };
    function ChangeTunerMode(index){
        if(tv){
            if(0 == index){
                model.channelSearch.setSource(15);	//ATSC-T
                setPlayedChListIndex(CHLISTINDEX.ALL);
            }
            else if (1 == index) {
                model.channelSearch.setSource(16);          //ATSC-C
                setPlayedChListIndex(CHLISTINDEX.ALL);
            }
            else{
                DBG_ERROR("inavalible index value!\n");
                return false;
            }
        }
        ChMainPanel.CurrTunerMode = index;
    }
    function mainPlayChannelChanged(val) {
        DBG_ERROR("ChMainPanel current channel info is --" + objToString(val) + "--");
        if(!!UI.getCurrSubModule() && UI.getCurrSubModule().name =="ChMainPanel"){
            selectComp.selectCurrent(ChMainPanel.CurrTunerMode);
            UI.endLoading();
        }
    }
         ChAutoScanBtn.onkey_ENTER = function () {
             var hasParentLock = tv ? model.parentlock.getSModel() :1;
             DBG_INFO("hasParentLock:::::"+ hasParentLock);
             var hasChannels = liveTV.getHasChannelFlag();
             DBG_INFO("hasChannels:::::"+ hasChannels);
             if(hasParentLock){
                 GLOBAL.StartSearchFromLiveTV = false;
                 GLOBAL.LockParentIndex = LockParent.AUTOSCAN;
                 UI.pushSubModule("setting", "ChParLockInputDialog", true);
             }else{
                if(hasChannels){
                    GLOBAL.StartSearchFromLiveTV = false;
                    UI.pushSubModule("setting", "ChClearChannelDialog", true);
                } else{
                    GLOBAL.StartSearchFromLiveTV = false;
                    UI.pushSubModule("setting", "ChAutoScanPanel", true);
                }
             }
        };

        ChManualScanBtn.onkey_ENTER = function () {
            if(tv){
                var hasParentLock = model.parentlock.getSModel();
                DBG_INFO("hasParentLock:::::"+ hasParentLock);
                if(hasParentLock == 1){
                    GLOBAL.LockParentIndex = LockParent.MANUALSCAN;
                    UI.pushSubModule("setting", "ChParLockInputDialog", true);
                }else{
                    UI.pushSubModule("setting", "ChManualScanPanel", true);
                }
            }else{
                GLOBAL.LockParentIndex = LockParent.MANUALSCAN;
                UI.pushSubModule("setting", "ChParLockInputDialog", true);
            }
        };
        ChFavListBtn.onkey_ENTER = function(){
            var CurrFavList = liveTV.getRefChannels();
            if(CurrFavList.length > 0)
            {
                UI.pushSubModule("setting", "ChFavListPanel", true);
            }else
            {
                GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.SCANCHLTIP;
                UI.pushGhostModule("setting","SettingSysToast");
            }
        };

        ChSkipListBtn.onkey_ENTER = function(){
            var CurrSkipList = liveTV.getCurrentListAllChannels();
            if(CurrSkipList.length > 0)
            {
                UI.pushSubModule("setting", "ChSkipListPanel", true);
            }else
            {
                GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.SCANCHLTIP;
                UI.pushGhostModule("setting","SettingSysToast");
            }
        };
    ChMainPanel.onPop = function(){
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.LIVETV_MAIN_PLAY_CHANGED, mainPlayChannelChanged);
    }
}
