/**
 * Created by Hisense on 2016-2-29.
 */
// Init
UI.moduleBuilder['setting']['AudioDigitalAudioOutList'] = function(){

    var initData = {
        AudioBg: UI['bg_overlay'],
        AudioDigitalAudioOutListBg: UI.window_bg,
        DBXDigitalAudioOutTitle:"[SE0557]"//Digital Audio Out
    };
    var template = Util.readJson("module/setting/AudioDigitalAudioOutList.json");
    var AudioDigitalAudioOutList = SubModule.create(initData, template);

    AudioDigitalAudioOutList.operateData = {
        "DigitalAudioOutList": [
            {
                "map": 1,
                "name": "[SE0076]",//"RAW",
                "flag": false
            },
            {
                "map": 2,
                "name": "[SE0077]",//"PCM",
                "flag": false
            },
            {
                "map": 3,
                "name": "[OT0182]",//Dolby Digital  "DD",
                "flag": false
            },
        ],
        "currDigitalAudioOutIdx": 0
    };
    function SndgetDigitalAudioOutIdx() {
        try {

            var DAudioOutTmp = tv ? model.sound.getDigitalAudioOut() : 1;
            DBG_INFO("model.sound.getDigitalAudioOut=" + DAudioOutTmp);
            for (var i = 0; i < AudioDigitalAudioOutList.operateData.DigitalAudioOutList.length; i++) {
                if (DAudioOutTmp == AudioDigitalAudioOutList.operateData.DigitalAudioOutList[i].map) {
                    break;
                }
            }
            return i;

        } catch (ex) {
            DBG_ERROR("SndgetDigitalAudioOutIdx:" + ex.message);
        }
    }

    // 初始化Grid控件
    // 取得目标锚点
    var List = UI.getItem(AudioDigitalAudioOutList, "List");

    // Grid的配置信息JSON
    var info = {
        // 每个图标使用的模板名
        template: "DialogListItem",
        // V表示竖向排列，H表示横向排列
        direction: CONST.GIRD_DIRECTION.H,
        // 每隔几个图标就换行
        breakNum: 1,
        // 每隔图标之间的距离
        distanceX: 0,
        distanceY: 20,
        // 要将此Grid添加到哪个锚点位置上
        container: List
    };

    // 声明一个初始化用数组，将数据配置好
    var allArray = [];
    for (var i = 0; i < AudioDigitalAudioOutList.operateData.DigitalAudioOutList.length; i++) {
        allArray.push(
            {
                ItemName: AudioDigitalAudioOutList.operateData.DigitalAudioOutList[i].name,
                tileBg: UI.item_bg,
                name: "item" + i,
                isFlag: "setting/ic_radiobutton_normal.png"
            }
        )
    }
    // 调用Grid.create方法生成Gird并添加到锚点位置上
    Gird.create(allArray, info);
    // 设置视野范围，当焦点超出此范围时，整个Grid会反向移动，达到滚动效果（此处配置的x，y是全局坐标）

    // 设置遮罩范围，隐藏显示不下的图标
    AudioDigitalAudioOutList.operateData.currDigitalAudioOutIdx = SndgetDigitalAudioOutIdx();
    AudioDigitalAudioOutList.currFocus = UI.getItem(List, "item" + AudioDigitalAudioOutList.operateData.currDigitalAudioOutIdx);
    AudioDigitalAudioOutList.onShow = function () {
        AudioDigitalAudioOutList.operateData.currDigitalAudioOutIdx = SndgetDigitalAudioOutIdx();
        DBG_INFO("setAudioDigitalAudioOutList.onShow");
        for (var i = 0; i < List.initSequence.length; i++) {
            UI.setImage(List.children[i].children[2], "setting/ic_radiobutton_normal.png");
        }
        AudioDigitalAudioOutList.currFocus = UI.getItem(List, "item" + AudioDigitalAudioOutList.operateData.currDigitalAudioOutIdx);
        UI.setImage(AudioDigitalAudioOutList.currFocus.children[2], OEMFunction.getInstance().getBrandSelectFocusImage(),AudioDigitalAudioOutList.currFocus);
        UI.focusTo(UI.getItem(List, "item" + AudioDigitalAudioOutList.operateData.currDigitalAudioOutIdx)) ;
    };

    function SndSetCurrTotalVIdx(idx) {
        try {
            AudioDigitalAudioOutList.operateData.currDigitalAudioOutIdx = idx;

            var DigitalAudioOutMapList = AudioDigitalAudioOutList.operateData.DigitalAudioOutList;
            if (idx > DigitalAudioOutMapList.length - 1) {
                DBG_ERROR("SndSetCurrTotalVIdx:idx=" + idx);
                idx = 0;
            }
            DBG_INFO("model.sound.setDigitalAudioOut:"+DigitalAudioOutMapList[idx].map);
            tv? model.sound.setDigitalAudioOut(DigitalAudioOutMapList[idx].map) :1;

        } catch (ex) {
            DBG_ERROR("SndSetCurrTotalVIdx:" + ex.message);
        }

    }

    List.onkey_ENTER = function (focus) {
        var index = List.initSequence.indexOf(focus);//AudioDigitalAudioOutList.currFocus.name.slice(-1);
        for (var i = 0; i < List.initSequence.length; i++) {
            UI.setImage(List.children[i].children[2], "setting/ic_radiobutton_normal.png");
        }
        UI.setImage(AudioDigitalAudioOutList.currFocus.children[2], OEMFunction.getInstance().getBrandSelectFocusImage());
        SndSetCurrTotalVIdx(index);
        UI.popSubModule();
        return true;
    };

};