/**
 * Created by Hisense on 2016-1-29.
 */
// Init
UI.moduleBuilder['miracast']['miracastMain'] = function(){

    var initData = {
        bg: "miracast/Anyviewcast.png",
        processImg1: "miracast/01.png",
        processImg2: "miracast/02.png",
        //processImg3: "miracast/02.png",
        process: "[SE0985]",//Wait for the external device to connect."
        message1:"[SE4219]",//To mirror content from your device to the TV:
        //message2:"[SE4220]",//Make sure your device and this TV are on the same network.
        message2:"[SE4221]",//Turn on the wireless display function on your Android device. (NOTE:Some devices may not support casting.)
        message3:"[SE4222]",//Find this TV in the list of devices that displays and select it.
    };
    var template = Util.readJson("module/miracast/miracastMain.json");
    var miracastMain = SubModule.create(initData, template);
    var TVName = UI.getItem(miracastMain, "TVName");
    var processImg1 = UI.getItem(miracastMain, "processImg1");
    var processImg2 = UI.getItem(miracastMain, "processImg2");
    //var processImg3 = UI.getItem(miracastMain, "processImg3");
    var process = UI.getItem(miracastMain, "process");
    var state1 = "miracast/01.png";
    var state2 = "miracast/02.png";
    miracastMain.mireCurrentPage = 0;

    var mirastateInfo = [
        "[SE0985]",//Wait for the external device to connect.",
        "[SS0003]",//"Creating connection",
        "[SE0165]"//"Connected successfully"
    ]
    miracastMain.currFocus = TVName;
    LabelValue.create(TVName, "[SS0002]");//"Device Name:"
    //initMira();

    function initMira() {
        if (tv) {
            model.miracast.ActionStartApp();
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.MIRACAST_STATUS_CHANGED, onMiracastChanged);
        }

    }

    miracastMain.onPush = function(){
        DBG_ERROR("push miracast");
        try {
            var tmp_param = {
                AppName: APPNAME.MIRACAST,
                LaunchSource: 1
            }
            LGReport.GTAPPRunStart(tmp_param.AppName,tmp_param.LaunchSource);
        } catch (ex) {
            DBG_ERROR(ex.message)
        }
    }

    miracastMain.onShow = function () {
        var tvName = tv ? model.system.getMachinename() : "Smart TV";
        DBG_INFO("model.system.getMachinename():" + tvName)
        TVName.setValue(tvName);
        UI.updateStage();
        if (tv) {
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.MIRACAST_STATUS_CHANGED, onMiracastChanged);
        }

        //onMiracastChanged("connecting");
    }
    miracastMain.onFocus = function () {
        UI.base.cursor.alpha = 0;
        UI.base.cursor.visible = false;
    }
    function onMiracastChanged(v) {
        try {
            DBG_INFO("onMiracastChanged:" + v);
            switch (v) {
                case 0:
                case 1:
                case 18:
                case 3:
                case 10://disconnect_success
                    miracastMain.mireCurrentPage = 0;
                    miracastMain.waitingUI();
                    break;
                case 6:
                    miracastMain.mireCurrentPage = 1;
                    connectUI();
                    break;
                case 14:
                    miracastMain.mireCurrentPage = 2;
                    successUI();
                    break;
                default:
                    break;
            }
            UI.updateStage();
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }

    }

    miracastMain.waitingUI = function () {
        try {
            miracastMain.alpha = 1;
            UI.setImage(processImg1, state1);
            UI.setImage(processImg2, state2);
           // UI.setImage(processImg3, state2);
            UI.setText(process, mirastateInfo[0]);
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }


    }

    function connectUI() {
        miracastMain.alpha = 1;
        UI.setImage(processImg1, state1);
        UI.setImage(processImg2, state1);
      //  UI.setImage(processImg3, state2);
        UI.setText(process, mirastateInfo[1]);
    }

    function successUI() {
        UI.setImage(processImg1, state1);
        UI.setImage(processImg2, state1);
     //   UI.setImage(processImg3, state1);
        UI.setText(process, mirastateInfo[2]);
        miracastMain.alpha = 0;

    }


    miracastMain.onkey_BACKSPACE = function () {
        try {
            DBG_INFO("-----onkey_BACKSPACE");
            UI.base.cursor.alpha = 1;
            UI.pushSubModule("miracast", "miracastDialog", true);
        }
        catch (ex) {
            DBG_ERROR(ex.message);
        }

    }
    miracastMain.onkey_EXIT = function () {
        UI.popSubModule();
        openLiveTVModule([Msg.INFO, 0]);
        DBG_INFO(" miracastMain.onkey_EXIT");
        return true;
    }
    miracastMain.onPop = function () {

        DBG_INFO("miracastMain.onPop");

        if (tv) {
            model.miracast.ActionStopApp("3");
            DBG_INFO("miracastMain.onShow:miracast stoped");
            model.source.appStatusSet("miracast","stoped");
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.MIRACAST_STATUS_CHANGED, onMiracastChanged);
        }
        resumeDTV(500);
        try {
            var tmp_param = {
                AppName: APPNAME.MIRACAST,
                LaunchSource: 1
            }
            LGReport.GTAPPRunClose(tmp_param.AppName,tmp_param.LaunchSource);
        } catch (ex) {
            DBG_ERROR(ex.message)
        }
    }

};