/**
 * Created by xueyuan1 on 2016-3-22.
 */

// Init
UI.moduleBuilder['EposMessage']['startEposCountDown'] = function() {

    var eposCountDownPageData = {
        bgImg: UI.window_bg,
        msgPanel: UI.item_bg,
        storeImg: UI.item_bg,
        homeImg: UI.item_bg,
        //startEposBar:{color: 0x00a9c2},
        //homeTxt: "[SE0244]",
        msgTitle: "[TV0159]",
        homeTxt: "[SE3725]",
        storeTxt: "[SE3721]",
        msgTxt: "[SE3724]"

    };
    var template = Util.readJson("module/EposMessage/startEposCountDown.json");
    var startEposCountDown = SubModule.create(eposCountDownPageData, template);

    startEposCountDown.currFocus = UI.getItem(startEposCountDown, "btnHome");
    startEposCountDown.protected = true;
    var startEposBar = UI.getItem(startEposCountDown, "startEposBar");
    var btnHome = UI.getItem(startEposCountDown, "btnHome");
    var btnStore = UI.getItem(startEposCountDown, "btnStore");
    var msgTxt = UI.getItem(startEposCountDown, "msgTxt");
    var timer = null;
    var msg = null;
    startEposCountDown.onPush = function () {
        DBG_INFO("startEposCountDown.onPush   :" + timer);
        createPercent(startEposBar, 30, 0, 30);
        var timeout = 30;
        if (!!timer) {
            clearInterval(timer);
            timer = null;
        }
        timer = setInterval(function () {
            timeout = parseInt(timeout) - 1;
            //msg = Config.language.TV0115.replace(/10/, timeout);//modify countdown message
            if (timeout == 0) {
                clearInterval(timer);
                try {
                    
                    var currModel = model.system.getUserMode();
                    model.system.setUserMode(currModel);
                    UI.clearEposMenuTimeout();
                } catch (e) {
                    DBG_ERROR(e.message);
                }
                UI.setEposMenuTimeout(startRetailmodeTimer, retailmodeTimeout);
                DBG_INFO("TIMEOUT !! START EPOS.");
                startePos(true);
            }
            createPercent(startEposBar, timeout, 0, 30);
        }, 1000);
    }

    btnHome.onkey_ENTER = function () {
        DBG_ALWAYS("Home Mode!!!");
        clearInterval(timer);
        try {
            model.system.setUserMode(SystemModelDefines.SL2_TVAPI_STR_SYSTEM_USER_MODE_HOME);
            UI.clearEposMenuTimeout();
        } catch (e) {
            DBG_ERROR(e.message);
        }
        UI.popAllModule();
        openLiveTVModule([Msg.INFO, 0]);
    }

    btnStore.onkey_ENTER = function () {
        DBG_ALWAYS("Store Mode");
        clearInterval(timer);
        try {
            
//            var currModel = model.system.getUserMode();
            model.system.setUserMode(1);
            UI.clearEposMenuTimeout();
        } catch (e) {
            DBG_ERROR(e.message);
        }
        UI.setEposMenuTimeout(startRetailmodeTimer, retailmodeTimeout);
        startePos(true);
    }
    startEposCountDown.onPop = function () {
        DBG_INFO("startEposCountDown onPop,ckearInterval timer");
        if (!!timer) {
            clearInterval(timer);
            timer = null;
        }
    }
    startEposCountDown.onkey_BACKSPACE = function () {
        return false;
    }
    startEposCountDown.onkey_EXIT = function () {
        return false;
    }
    startEposCountDown.onkey_NETFLIX = function () {
        return false;
    }
    startEposCountDown.onkey_AMAZON = function () {
        return false;
    }
    startEposCountDown.onkey_VUDU = function () {
        return false;
    }
    startEposCountDown.onkey_YOUTUBE = function () {
        return false;
    }
    startEposCountDown.onkey_LAUNCHER = function () {
        return false;
    }

    startEposCountDown.onkey_WUAKI = function () {
        return false;
    }
    startEposCountDown.onkey_INPUT = function () {
        return false;
    }
    startEposCountDown.onkey_KEYPADMENU = function () {
        return false;
    }

    var createPercent = function (target, percent, min, max) {
        target.percent = percent;
        target.min = min;
        target.max = max;
        target.redraw = function (g) {
            g.clear();
            g.beginFill(0xffffff, 0.2);
            g.drawRoundedRect(0, 0, width, height, 4);
            g.endFill();
            UI.updateStage();
            if (target.percent != min) {
                var enableColor = 0xbb2071;
                if(GLOBAL.LAUNCHER_BRAND =="his") { enableColor = 0x00a9c2 };
                g.beginFill(enableColor, 0.5);
                g.drawRoundedRect(0, 0, width * ((target.percent - min) / (target.max - min)), height, 4);
                g.endFill();
                UI.updateStage();
            }
        };
        var width = startEposBar.getBounds().width;
        var height = target.getBounds().height;
        target.removeAllChildren();
        var shape = target.addChild(new PIXI.Graphics());
        target.redraw(shape);
        UI.updateStage();
        target.getPercentPos = function () {
            return width * ((target.percent - min) / (target.max - min));
        };
        target.getPercent = function () {
            return target.percent;
        };
        target.setPercent = function (percent) {
            target.percent = percent;
            this.redraw(shape);
            UI.updateStage();
        };
        target.setMax = function (max) {
            target.max = max;
            this.redraw(shape);
            UI.updateStage();
        };
        target.update = function () {
            this.redraw(shape);
            UI.updateStage();
        };
    };
};