UI.moduleBuilder['Alexa']['register_amazon'] = function() {
    var amazonAccountData = {
        loadingImg:"Alexa/register/loading.png",
        titleImg:"Alexa/register/logo_alexa.png",
        title: "[SE3770]",
        helpText:"[SE3955]",
        refreshBtnImg:UI.item_bg,
        refreshBtnText:"[SE1301]"//Refresh
    };
    var template = Util.readJson("module/Alexa/register_amazon.json");
    var register_amazon = SubModule.create(amazonAccountData, template);

    var title = UI.getItem(register_amazon, "title");
    var refreshBtn = UI.getItem(register_amazon, "refreshBtn");
    var loadingImg = UI.getItem(register_amazon, "loadingImg");
    var codeMainFrame = UI.getItem(register_amazon, "codeMainFrame");
    var errorMainFrame = UI.getItem(register_amazon, "errorMainFrame");
    var codeMainFrameText1 = UI.getItem(register_amazon, "codeMainFrameText1");
    var codeMainFrameText2 = UI.getItem(register_amazon, "codeMainFrameText2");
    var codeMainFrameText3 = UI.getItem(register_amazon, "codeMainFrameText3");
    var errorMainFrameText = UI.getItem(register_amazon, "errorMainFrameText");


    var hide = 0;
    var show = 1;
    register_amazon.web = "";
    register_amazon.code = "xxxxxxxxx";
    register_amazon.amazonTime = 0;
    register_amazon.errorMsg = "";
    register_amazon.expireTimer = null;
    register_amazon.currFocus = title;
    register_amazon.protected = true;

    register_amazon.onPush = function(){
        register_amazon.currFocus = title;
        displayPageMsg(show,hide,hide);
        register_result = false;
        AVSClient.register.getRegisterInfo("amazon");
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AVS_ONAMAMESSAGECHANGED, onAmazonMsgChanged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AVS_ONAMAZONREGISTERRESULT, amazonCloudCallback);

    };

    register_amazon.onFocus = function(){
        if(UI.getCurrFocus().name != "refreshBtn"){
            UI.base.cursor.alpha = 0;
            UI.getTween(UI.base.cursor).set({alpha: 0});
            return false;
        }else{
            return true;
        }
    }
    var register_result = false;
    function amazonCloudCallback(cloudState){
        clearTimeout(register_amazon.expireTimer);
        DBG_ERROR("cloudState is " + cloudState);
        switch (cloudState){
            case 1: //success
                register_result = true;
                registerUpdate(1);
                break;
            case 0: //fail
                displayPageMsg(hide,hide,show);
                register_amazon.errorMsg = "[SE3949]";
                UI.setText(errorMainFrameText,register_amazon.errorMsg);
                UI.focusTo(refreshBtn);
                UI.updateStage();
                break;
            default:
                break;
        }
    }

    function onAmazonMsgChanged(url, code, time){
        DBG_ERROR("onAmazonMsgChanged : url is " + url);
        DBG_ERROR("onAmazonMsgChanged : code is " + code);
        DBG_ERROR("onAmazonMsgChanged : time is " + time);
        registerLoading(0);
        displayPageMsg(hide,show,hide);
        register_amazon.web = url ;
        register_amazon.code = code;
        register_amazon.amazonTime = parseInt(time/60)
        UI.setText(codeMainFrameText1,"[SE3956]", null, null, null, null, [register_amazon.web]);
        UI.setText(codeMainFrameText2,register_amazon.code);
        UI.setText(codeMainFrameText3,"[SE3951]", null, null, null, null,[register_amazon.amazonTime]);
        UI.focusTo(codeMainFrameText2);
        clearTimeout(register_amazon.expireTimer);
        register_amazon.expireTimer = setTimeout( function(){
            DBG_ERROR("register_amazon.expireTimer");
            displayPageMsg(hide,hide,show);
            register_amazon.errorMsg = "[SE3952]";
            UI.setText(errorMainFrameText,register_amazon.errorMsg);
            UI.focusTo(refreshBtn);
            UI.updateStage();
        },time *1000);
        //notify remote app
        if(tv){
            try{
                pubAvsAmazonCode(url,code);
            }catch(ex){
                DBG_ERROR(ex.message);
            }
        }
    }



    register_amazon.afterPush = function(){
        if(!tv){
            setTimeout(function(){
                onAmazonMsgChanged("www.baidu.com","ABD" ,500);
                setTimeout(function(){
                    amazonCloudCallback(1);
                },1000);
            },1000);
        }
    }

    register_amazon.onPop = function(){
        clearTimeout(register_amazon.expireTimer);
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.AVS_ONAMAMESSAGECHANGED, onAmazonMsgChanged);
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.AVS_ONAMAZONREGISTERRESULT, amazonCloudCallback);
        if (!register_result) {
            AVSClient.register.cancelRegister("amazon");
        }
    }


    refreshBtn.onkey_ENTER = function(){
        //todo
        displayPageMsg(show,hide,hide);
        register_result = false;
        AVSClient.register.getRegisterInfo("amazon");
    }



    function displayPageMsg(a,b,c){
        registerLoading(a);
        codeMainFrame.alpha = b;
        errorMainFrame.alpha = c;
    }

    function registerLoading(flag) {
        if (flag) {
            loadingImg.alpha = 1;
            UI.getTween(loadingImg, true, true).to({rotation: loadingImg.rotation + Math.PI*2}, 1000);
        }
        else {
            loadingImg.alpha = 0;
            createjs.Tween.removeTweens(loadingImg);
        }

    }
}
