var Alexa = window["Alexa"];
Alexa.currStep = 0;
(function(){
    Alexa.enableKeyGroup = [
        CONST.KEY.VK_UP, CONST.KEY.VK_DOWN, CONST.KEY.VK_LEFT, CONST.KEY.VK_RIGHT,
        CONST.KEY.VK_BACKSPACE, CONST.KEY.VK_ENTER, CONST.KEY.VK_EXIT,
        CONST.KEY.VK_BLUE, CONST.KEY.VK_RED, CONST.KEY.VK_GREEN, CONST.KEY.VK_YELLOW,
        CONST.KEY.VK_POWER, CONST.KEY.VK_POWER_ON, CONST.KEY.VK_POWER_KEY_PAD,
        CONST.KEY.VK_0, CONST.KEY.VK_1, CONST.KEY.VK_2, CONST.KEY.VK_3, CONST.KEY.VK_4,
        CONST.KEY.VK_5, CONST.KEY.VK_6, CONST.KEY.VK_7, CONST.KEY.VK_8, CONST.KEY.VK_9,
        CONST.KEY.VK_VOLUME_UP, CONST.KEY.VK_VOLUME_DOWN,CONST.KEY.VK_MUTE,
        CONST.KEY.VK_CHANNEL_DOWN, CONST.KEY.VK_CHANNEL_UP,
        CONST.KEY.VK_LAUNCHER, CONST.KEY.VK_MENU, CONST.KEY.VK_SETTINGS,CONST.KEY.VK_VOICE,
        CONST.KEY.VK_NETFLIX, CONST.KEY.VK_VUDU, CONST.KEY.VK_YOUTUBE, CONST.KEY.VK_AMAZON,
        CONST.KEY.VK_VOICE_DOWN, CONST.KEY.VK_VOICE_UP
    ];
    Alexa.onPush = function(){
        DBG_ERROR("Alexa enter");
        UI.registerKeyCodes(Alexa.enableKeyGroup);
        UI.setKeyGroup(7);
    };
    Alexa.onShow = function(){};
    Alexa.onPop = function(){
        //set timer to adjust sequence
        setTimeout(function () {
            if(checkIsAppOn() && UI.getCurrSubModule().name == "blank"){
                DBG_ERROR("alexa:has app");
                registerKeyCodesForApp();
            } else if (Alexa.caller== "hiMedia") {
                hiMedia.changeByLauncher("resume");
                UI.registerKeyCodes(null);
                UI.setKeyGroup(7);
            } else{
                UI.registerKeyCodes(null);
                UI.setKeyGroup(7);
            }
        }, 100);
    };
    Alexa.onkey_BACKSPACE = function(){
        DBG_ERROR("exit register flow");
        // UI.popModule("Alexa");
        if(tv){
            try{
                pubAvsRegisterQuit();
            }catch(ex){
                DBG_ERROR(ex.message);
            }
        }
        UI.clearAllSubModule("Alexa");
        if (checkIsAppOn()) {
            registerKeyCodesForApp();
        } else {
            openLiveTVModule([Msg.INFO, 0]);
        }
    }

    Alexa.onkey_ESCAPE = function(){
        Alexa.onkey_BACKSPACE();
    }

    Alexa.onFocus = function (focus) {
            if (GLOBAL.HICONTRAST) {
                UI.base.toHiContrast(focus);
            }
            if(GLOBAL.TTS){
                if (focus.voiceStr) {
                    UI.callTTS(focus.voiceStr);
                } else {
                    UI.callTTS(UI.base.getVoiceStr(focus))
                }
            }

            UI.moveCursor(UI.adjustView());
            UI.getTween(focus.scale).wait(100).to({x:1.05, y:1.05}, 500, UI.ease.quartOut);
            UI.getTween(UI.base.cursor).wait(100).to({alpha:1}, 500, UI.ease.quartOut);
            UI.moveTop(focus);
            UI.base.runText(focus);
    }

    Alexa.onNormal = function (focus) {
            if (GLOBAL.HICONTRAST) {
                UI.base.toNormalContrast(focus);
        }
        UI.getTween(focus.scale).to({x:1, y:1}, 200);
        UI.base.stopText(focus);
    }

})();