/**
 * Created by Administrator on 16-2-3.
 */
var g_LauncherData = {"currentCountryCode": "USA", "currentLanguage": "eng", "cTimestamp": 0};
var g_notificationApps = [];
var g_ottList = [];
var g_notificationTimeStamp = getNotificationTimeStamp();
var g_acrNotification = [];
var g_notificationCrtTimeStamp = 0;
var cannotInstallApps = ["netflix","youtube","vudu","amazonruby","amazon","pandora",
    "https://tv.pandora.com/?model=MTK5658&vendor=Hisense&type=HTML5&modelYear=2016&badge=azupn7ofdwvpugkuoxyobg5227hnk63sddmvx43a32jgaccr7ika&mouseEnabled=true&playKey=415&skipKey=417&pauseKey=19&backKey=8",
    "https://tv.pandora.com/?model=MTK5658&vendor=Sharp&type=HTML5&modelYear=2016&badge=7bsx3s6dur6tkbtu562mnhhgxoh6dwtsen5gh6ldsjlntolr5xua&mouseEnabled=true&playKey=415&skipKey=417&pauseKey=19&backKey=8"];

var g_appStoreList = [];
var g_installAppNum = 0;
var g_pictureResource = null;
var g_pictureResourceB = null;

function initScreenProtectPath(){
    if(GLOBAL.UI_BRAND == "his"){
        return ["Screen/hisense_input_nosignal.png","Screen/his1.png","Screen/his2.png","Screen/his3.png","Screen/his4.png","Screen/his5.jpg"];
    } else if(GLOBAL.UI_BRAND == "tos") {
        return ["Screen/hisense_input_nosignal.png", "Screen/his1.png","Screen/his2.png","Screen/his3.png","Screen/his4.png"];
    } else {
        return ["Screen/sharp_input_nosignal.png","Screen/shp1.png","Screen/shp2.png","Screen/shp3.png","Screen/shp4.png","Screen/shp5.png"];
    }
}

function getLauncherData() {
    var dd = [];
    var serviceUpdate = getLauncherServiceUpdateData();

    var currentCountryCode = tv ? ChangeCountryNumToCode(model.basicSetting.getTvsetLocation()) : "CAN";
    var serviceCountryCode = serviceUpdate.countryCode;
    DBG_INFO('current Country Code ' + currentCountryCode, DebugLevel.WARNING);
//    if (currentCountryCode != "USA" && currentCountryCode != "CAN" && currentCountryCode != "MEX") {
//        currentCountryCode = "USA";
//    }
    getAlwaysDebugStatus();
    g_LauncherData.currentCountryCode = currentCountryCode;
    g_LauncherData.cTimestamp = serviceUpdate.timeStamp;
    g_LauncherData.currentLanguage = tv?ChangeLangNumToCode(model.language.getOsd()):GLOBAL.CURRENT_LANGUAGE;
    DBG_INFO("currentCountryCode:" + currentCountryCode);
    var mainJSON = null;
    var defaultData = (serviceCountryCode != currentCountryCode) || getAlwaysDefaultDataStatus() || serviceUpdate.timeStamp == 0;

    var launcherPath = defaultData ? "hisenseUI/data/" : "launcher/data/";
    if (defaultData) {
        DBG_ERROR('service country not equal current country, use default data', DebugLevel.WARNING);
        mainJSON = loadLauncherDefaultData(launcherPath, currentCountryCode);
    }
    else {
        mainJSON = readXMLDOM(launcherPath + "CategoryIndex.xml", 1);
        if (null == mainJSON) {
            launcherPath = "hisenseUI/data/";
            DBG_ERROR('get launcher data error, use default data', DebugLevel.ERROR);
            mainJSON = loadLauncherDefaultData(launcherPath, currentCountryCode);
            defaultData = true;
        }
    }

    if (null != mainJSON) {
        var footerJSON = readXMLDOM(launcherPath + getCategoryListPath(mainJSON), defaultData ? 2 : 1);
        dd = parseLauncherCategoryListData(footerJSON, defaultData, launcherPath);
    }
//    var launcherData = {};
//    launcherData.data = dd;
//    DBG_ERROR("return data:" + objToString(launcherData));
//    var ret = $.extend(true,{}, launcherData);
    if(dd == null){
        launcherPath = "hisenseUI/data/";
        DBG_ERROR('no all app data ,use default data');
        mainJSON = loadLauncherDefaultData(launcherPath, currentCountryCode);
        defaultData = true;
        if (null != mainJSON) {
            var footerJSON = readXMLDOM(launcherPath + getCategoryListPath(mainJSON), defaultData ? 2 : 1);
            dd = parseLauncherCategoryListData(footerJSON, defaultData, launcherPath);
        }
    }
//    DBG_INFO("return data:" + objToString(dd));

    return dd;
}
function refreshNotificationApps(){
    var deletedNotification = null;
    if(!tv){
        deletedNotification = [];
        var obj = {
            tagType:0,
            contentMD5:0
        }
        obj.tagType = LauncherTagType.RECOMMEND;
        obj.contentMD5 = "e6e36b32bf5fd24d13db744a74a3185c";
        deletedNotification.push(obj);
    }else{
        deletedNotification = readFileFromNative('launcher/deletedNotification.txt', 1);
        if (null == deletedNotification) {
            deletedNotification = [];
        }
    }
    return deletedNotification;

}
function getNotificationApps(){
//    DBG_ERROR("getNotificationApps:" + objToString(g_notificationApps));
    return g_notificationApps;
}

function getPictureResource(){
//    DBG_ERROR("getNotificationApps:" + objToString(g_notificationApps));
    var data = null;
    if(g_pictureResource!=null){
        data = {};
        data.Icon = g_pictureResource.Icon;
        data.Detail = g_pictureResource.Detail;
        data.Name = g_pictureResource.Name;
        data.cmd = g_pictureResource.cmd;
        data.date = g_pictureResource.date;
    }
    return data;
}

function getPictureResourceB(){
//    DBG_ERROR("getNotificationApps:" + objToString(g_notificationApps));
    var data = null;
    if(g_pictureResourceB!=null){
        data = {};
        data.Icon = g_pictureResourceB.Icon;
        data.Detail = g_pictureResourceB.Detail;
        data.Name = g_pictureResourceB.Name;
        data.cmd = g_pictureResourceB.cmd;
        data.date = g_pictureResourceB.date;
    }
    return data;
}

function clearNotificationApps(){

    var cateGory = [];
    var obj = {
        tagType:0,
        contentMD5:0
    }
    if(g_pictureResource!=null){
        obj.tagType = LauncherTagType.PICTURE;
        obj.contentMD5 = g_pictureResource.contentMD5;
        cateGory.push(obj);
    }
    if(g_pictureResourceB!=null){
        obj.tagType = LauncherTagType.PICTURE_B;
        obj.contentMD5 = g_pictureResourceB.contentMD5;
        cateGory.push(obj);
    }
    if(g_notificationApps.length>0){
        obj.tagType = LauncherTagType.RECOMMEND;
        obj.contentMD5 = g_notificationApps[0].contentMD5;
        cateGory.push(obj);
    }

    if(cateGory.length>0){
        if (tv) {
            writeFileToNative('launcher/deletedNotification.txt', objToString(cateGory), 1);
        }
    }
    g_notificationApps = [];
    g_pictureResourceB = null;
    g_pictureResource = null;
    try{
        model.system.cleanAllNotifyMessage();
    }catch(e){

    }
//    var ret = Hisense.File.delete("notify/msg/msg_index", 1);

}

function parseLauncherCategoryListData(footer, defaultData, launcherPath) {
    var containerData = [];
    if (null == footer) {
        DBG_ERROR("footer json is null");
        return null;
    }
    var delData = getLauncherDeleteAppByUser();
    var lockData = getLauncherLockedAppByUser();
    var installerData = getLauncherInstallerAppByUser();
    var uninstallData = getLauncherUninstallAppByUser();
    var rememberInfo = getRememberEditAppFromNativeFile();
    var delNotification = refreshNotificationApps();
    var addApps = getAddAppFromOpera();
//    DBG_ERROR("rememberInfo:"+JSON.stringify(rememberInfo));
//    var homeData = $.extend(true, {}, rememberInfo.appInfo);
    var homeData = rememberInfo.appInfo;
    var footerTmp = getNodesByKey(CategoryKey.INFO, footer);
    var hasProtect = false;
    var hasNotification = false;
    var hasAllAppTitles = false;
    var hasPictureResource = false;
    var hasPictureResourceB = false;
    var hasOtt = false;
    var hasAllApp = false;
    var allAppLen = 0;
    var allAppTitlesLen = 0;
    var installerList = [];
    var youtube_video = null;
//    DBG_ERROR("footerTmp.length:" + footerTmp.length);
    for (var i = 0; i < footerTmp.length; i++) {
        var contentItem = {};

        contentItem.Name = getItemsByLanguage(getNodesByKey(CategoryKey.CATEGORYNAME, footerTmp[i]), "name", defaultData);
        contentItem.Icon = getItemsByLanguage(getNodesByKey(CategoryKey.CATEGORYICON, footerTmp[i]), 'iconUrl', defaultData);
        contentItem.Order = getTextByKey(CategoryKey.ORDER, footerTmp[i]);
        contentItem.tagType = getTextByKey(CategoryKey.TAGTYPE, footerTmp[i]);

        var contentData = {};
        contentData.tagType = contentItem.tagType;
        contentData.txts = [];
        contentData.imgs = [];
        contentData.Icon_96 = [];
        contentData.urls = [];
//        contentData.objectDesc = [];
        contentData.urlTypes = [];
        contentData.storeTypes = [];
        contentData.canRemoves = [];
        contentData.canMoves = [];
        contentData.Descs = [];
        contentData.Installer = [];
        contentData.Locked = [];
        contentData.from = [];
        contentData.appId = [];
        contentData.cmd = -1;
        if (contentItem.tagType == LauncherTagType.LIVETV) {
            contentItem.data = contentData;
        } else {
            contentItem.data = parseLauncherCategoryContentData(getTextByKey(CategoryKey.CATEGORYURL, footerTmp[i]), defaultData, launcherPath,contentItem.tagType);
            if(contentItem.data == null && contentItem.tagType == LauncherTagType.AllAPP){
                return null;
            }
            if (contentItem.tagType == LauncherTagType.AllAPP || contentItem.tagType == LauncherTagType.AllAPPTITLES) {

                for (var m = 0; m < delData.length; m++) {
                    var idx = $.inArray(delData[m], contentItem.data.urls);
                    if (idx > -1) {
                        DBG_ALWAYS("generateDataFunction:delete all:" + delData[m] + "," + delData.length);
                        contentItem.data.imgs.splice(idx, 1);
                        contentItem.data.txts.splice(idx, 1);
                        contentItem.data.urls.splice(idx, 1);
                        contentItem.data.urlTypes.splice(idx, 1);
                        contentItem.data.canRemoves.splice(idx, 1);
                        contentItem.data.canMoves.splice(idx, 1);
                        contentItem.data.Installer.splice(idx, 1);
                        contentItem.data.Locked.splice(idx, 1);
                        contentItem.data.from.splice(idx, 1);
                        contentItem.data.appId.splice(idx, 1);
                        contentItem.data.storeTypes.splice(idx, 1);
                        contentItem.data.Icon_96.splice(idx, 1);
                    }
                }
                var configAppNum = contentItem.data.imgs.length;

                g_appStoreList = [];
                DBG_ALWAYS("VIDAALiteInitLauncherAppPageData:add app number:" + addApps.length);
                launcherLastAppStoreAddNum = addApps.length;
                for (var n = 0; n < addApps.length; n++) {
                    var idx = $.inArray(addApps[n].appUrl, contentItem.data.urls);
                    if (idx > -1) {
                        continue;
                    }
                    g_appStoreList.push(addApps[n].appUrl);
                    contentItem.data.imgs[configAppNum] = addApps[n].Image;
                    contentItem.data.txts[configAppNum] = addApps[n].appName;
                    contentItem.data.urls[configAppNum] = addApps[n].appUrl;
                    contentItem.data.urlTypes[configAppNum] = addApps[n].appUrlType;
                    contentItem.data.canRemoves[configAppNum] = addApps[n].canRemove;
                    contentItem.data.canMoves[configAppNum] = addApps[n].canMove;
                    contentItem.data.Installer[configAppNum] = addApps[n].Installer;
                    contentItem.data.Locked[configAppNum] = addApps[n].Locked;
                    contentItem.data.from[configAppNum] = addApps[n].from;
                    contentItem.data.appId[configAppNum] = addApps[n].appId;
                    contentItem.data.storeTypes[configAppNum] = addApps[n].storeType;
                    contentItem.data.Icon_96[configAppNum] = addApps[n].Icon_96;
                    configAppNum = configAppNum+1;
                }
                if(contentItem.tagType == LauncherTagType.AllAPP){
                    contentData.cmd = LauncherCMD.ALLAPP;
                    hasAllApp = true;
                    allAppLen = contentItem.data.urls.length;

                    for (var m = 0; m < installerData.length; m++) {
                        var idx = $.inArray(installerData[m], contentItem.data.urls);
//                        if (idx > -1 && contentItem.data.from[idx]!="store") {
                            contentItem.data.Installer[idx] = true;
//                        }
                    }
                    for (var m = 0; m < uninstallData.length; m++) {
                        var idx = $.inArray(uninstallData[m], contentItem.data.urls);
//                        if (idx > -1 && contentItem.data.from[idx]!="store") {
                            contentItem.data.Installer[idx] = false;
//                        }
                    }

                    for (var m = 0; m < cannotInstallApps.length; m++) {
                        var idx = $.inArray(cannotInstallApps[m], contentItem.data.urls);
                        if (idx > -1) {
                            contentItem.data.Installer[idx] = true;
                        }
                    }
                    for (var m = 0; m < contentItem.data.urls.length; m++) {
                        var idx = $.inArray(contentItem.data.urls[m], lockData);
                        if (idx > -1) {
                            contentItem.data.Locked[m] = true;
                        }else{
                            contentItem.data.Locked[m] = false;
                        }
                        if(contentItem.data.Installer[m]){
                            installerList.push(contentItem.data.urls[m]);
                        }
                    }

                }else if(contentItem.tagType == LauncherTagType.AllAPPTITLES){
                    hasAllAppTitles = true;
                    allAppTitlesLen = contentItem.data.urls.length;
                }
            }
            else if(contentItem.tagType == LauncherTagType.SCREENPROTECT){
                hasProtect = true;
                g_screenProtectPath = [];
                var tmpPath = initScreenProtectPath();
                var b=1;
                var lengthPicturesDefault = 5;
                if(GLOBAL.UI_BRAND == "tos") {
                    lengthPicturesDefault = 4;
                } else {
                    lengthPicturesDefault = 5;
                }
                if(GLOBAL.UI_BRAND == "his" || GLOBAL.UI_BRAND == "tos"){
                    g_screenProtectPath[0] = "Screen/hisense_input_nosignal.png";
                }else{
                    g_screenProtectPath[0] = "Screen/sharp_input_nosignal.png";
                }
                for(var a=0;a<contentItem.data.imgs.length;a++){
                    if(contentItem.data.imgs[a].indexOf("default.png")>-1){
//                        hasProtect = false;
//                        break;
                        g_screenProtectPath[a+1] = tmpPath[b];
                        if(b<lengthPicturesDefault){
                            b++;
                        }else{
                            b = 1;
                        }
                    }else{
                        g_screenProtectPath[a+1] = contentItem.data.imgs[a];
                    }
                }
                DBG_INFO("g_screenProtectPath:"+JSON.stringify(g_screenProtectPath));
            }else if(contentItem.tagType == LauncherTagType.RECOMMEND){
//                DBG_INFO("!!!!!!!!!!!!!");
                hasNotification = true;
//                g_notificationTimeStamp = g_LauncherData.cTimestamp;
                for(var mm=0;mm<delNotification.length;mm++){
                    if(contentItem.data.contentMD5 == delNotification[mm].contentMD5){
                        hasNotification = false;
                        break;
                    }
                }
                if(hasNotification){
                    g_notificationApps = [];
                    for(var y=0;y<contentItem.data.imgs.length;y++){
                        var appInfo = {};
                        var data = {};
                        appInfo.Name = contentItem.data.txts[y];
                        if(contentItem.data.imgs[y].indexOf("default.png")>-1){
                            appInfo.Icon = "launcher/notification/default.png";
                        }else{
                            appInfo.Icon = contentItem.data.imgs[y];
                        }
                        appInfo.Detail = "";
                        appInfo.date = g_LauncherData.cTimestamp;
                        appInfo.cmd = LauncherCMD.APP;
                        appInfo.data = data;
                        data.url = contentItem.data.urls[y];
                        data.urlType = contentItem.data.urlTypes[y];
                        data.storeType = contentItem.data.storeTypes[y];
                        appInfo.contentMD5 = contentItem.data.contentMD5;
                        g_notificationApps.push(appInfo);
                    }
                    g_notificationCrtTimeStamp = g_LauncherData.cTimestamp;
                }
            }else if(contentItem.tagType == LauncherTagType.OTT){
                hasOtt = true;
                g_ottList = [];
                for(var y=0;y<contentItem.data.imgs.length;y++){
                    var appInfo = {};
                    var data = {};
                    appInfo.Name = contentItem.data.txts[y];
                    if(contentItem.data.imgs[y].indexOf("default.png")>-1){
                        appInfo.Icon = "launcher/inputs/his/xumo.png";
                    }else{
                        appInfo.Icon = contentItem.data.imgs[y];
                    }
                    appInfo.Detail = " ";
                    appInfo.date = g_LauncherData.cTimestamp;
                    appInfo.cmd = LauncherCMD.APP;
                    appInfo.data = data;
                    appInfo.Locked = false;
                    data.url = contentItem.data.urls[y];
                    var idx = $.inArray(data.url, lockData);
                    if (idx > -1) {
                        appInfo.Locked = true;
                    }else{
                        appInfo.Locked = false;
                    }
                    data.urlType = contentItem.data.urlTypes[y];
                    data.storeType = contentItem.data.storeTypes[y];
                    g_ottList.push(appInfo);
                }
                var ott = readFileFromNative("launcher/ott.txt", 1);
                var ottIndex = -1;
                if(ott!=null && ott.name != 0 ){
                    for(var x=0;x<g_ottList.length;x++){
                        if(g_ottList[x].data.url == ott.url){
                            ottIndex = x;
                            break;
                        }
                    }
                }
                if(ottIndex == -1){
                    var obj = {
                        "name":0,
                        "url":0
                    };
                    writeFileToNative("launcher/ott.txt",objToString(obj), 1);
                }
            }
            else if(contentItem.tagType == LauncherTagType.YOUTUBE_VIDEO){
                contentData.cmd = LauncherCMD.YOUTUBE_VIDEO;
                youtube_video = $.extend(true,{}, contentItem.data);
            }
            else if(contentItem.tagType == LauncherTagType.PICTURE){
                DBG_INFO("!!!!!!!!!!!!!"+contentItem.data.contentMD5);
                hasPictureResource = true;
                for(var mm=0;mm<delNotification.length;mm++){
                    if(contentItem.data.contentMD5 == delNotification[mm].contentMD5){
                        hasPictureResource = false;
                        break;
                    }
                }
                if(hasPictureResource){
                    g_pictureResource =
                    {
                        "Icon":"",
                        "Name":"",
                        "Detail":" ",
                        "cmd":LauncherCMD.PICTURE,
                        "date":g_LauncherData.cTimestamp,
                        "data":[]
                    };
                    g_pictureResource.Icon = contentItem.Icon;
                    g_pictureResource.Name = contentItem.Name;
                    g_pictureResource.contentMD5 = contentItem.data.contentMD5;

                    for(var y=0;y<contentItem.data.imgs.length;y++){
                        var appInfo = {};
                        appInfo.Name = contentItem.data.txts[y];
                        if(contentItem.data.imgs[y].indexOf("default.png")>-1){
                            appInfo.Icon = "launcher/notification/default.png";
                        }else{
                            appInfo.Icon = contentItem.data.imgs[y];
                        }
                        appInfo.Detail = contentItem.data.Descs[y];
                        appInfo.cmd = LauncherCMD.PICTURE;
                        g_pictureResource.data.push(appInfo);
                    }
                    g_notificationCrtTimeStamp = g_LauncherData.cTimestamp;
                }

            }
            else if(contentItem.tagType == LauncherTagType.PICTURE_B){
                hasPictureResourceB = true;
                for(var mm=0;mm<delNotification.length;mm++){
                    if(contentItem.data.contentMD5 == delNotification[mm].contentMD5){
                        hasPictureResourceB = false;
                        break;
                    }
                }
                if(hasPictureResourceB){
                    g_pictureResourceB =
                    {
                        "Icon":"",
                        "template":contentItem.template,
                        "Name":"",
                        "Detail":" ",
                        "cmd":LauncherCMD.PICTURE_B,
                        "date":g_LauncherData.cTimestamp,
                        "data":[]
                    };

                    g_pictureResourceB.Icon = contentItem.Icon;
                    g_pictureResourceB.Name = contentItem.Name;
                    g_pictureResourceB.contentMD5 = contentItem.data.contentMD5;

                    for(var y=0;y<contentItem.data.imgs.length;y++){
                        var appInfo = {};
                        appInfo.Name = contentItem.data.txts[y];
                        if(contentItem.data.imgs[y].indexOf("default.png")>-1){
                            appInfo.Icon = "launcher/notification/default.png";
                        }else{
                            appInfo.Icon = contentItem.data.imgs[y];
                        }
                        appInfo.Detail = contentItem.data.Descs[y];
                        appInfo.cmd = LauncherCMD.PICTURE_B;

                        g_pictureResourceB.data.push(appInfo);
                    }
                    g_notificationCrtTimeStamp = g_LauncherData.cTimestamp;
                }

            }
        }

        if (contentItem.data != null && contentItem.tagType!=LauncherTagType.SCREENPROTECT
            && contentItem.tagType!=LauncherTagType.PICTURE && contentItem.tagType!=LauncherTagType.PICTURE_B && contentItem.tagType!=LauncherTagType.YOUTUBE_VIDEO) {
            containerData.push(contentItem);
        }
    }
    if(!hasAllApp){
        DBG_ERROR("no all app  data!!!!!!!!!!!!!!!");
        return null;
    }
    if(!hasProtect){
        g_screenProtectPath = initScreenProtectPath();
    }
    if(!hasNotification){
        g_notificationApps = [];
    }

    if(!hasOtt){
        g_ottList = [];
        var obj = {
            "name":0,
            "url":0
        };
        writeFileToNative("launcher/ott.txt",objToString(obj), 1);

    }
    if(!hasPictureResource){
        g_pictureResource = null;
    }

    if(!hasPictureResourceB){
        g_pictureResourceB = null;
    }
//    DBG_ERROR("xml data:" + objToString(containerData));
    //var allAppData = [];
    //DBG_ERROR("footerTmp.length:"+objToString(containerData));
    for(var j =0;j<homeData.length;j++){
        for(var x=0;x<containerData.length;x++){
            if((homeData[j].tagType == containerData[x].tagType)||
                (homeData[j].cmd == LauncherCMD.ALLAPP && containerData[x].tagType == LauncherTagType.AllAPP) ||
                (homeData[j].cmd == LauncherCMD.LIVETV && containerData[x].tagType == LauncherTagType.LIVETV)){
                homeData[j].Name = containerData[x].Name;
                homeData[j].data = containerData[x].data;
//                if(!defaultData) {
//                    homeData[j].Icon = containerData[x].Icon;
//                }
            }
            if(homeData[j].cmd == LauncherCMD.APP && containerData[x].tagType == LauncherTagType.AllAPP){
                for(var t=0;t<containerData[x].data.urls.length;t++){
                    if(homeData[j].data.url == containerData[x].data.urls[t]){
                        homeData[j].data.txt = containerData[x].data.txts[t];
                        homeData[j].Name = containerData[x].data.txts[t];
                        break;
                    }

                }
            }
            if(homeData[j].cmd == LauncherCMD.APP && containerData[x].tagType == LauncherTagType.AllAPPTITLES){
                for(var t=0;t<containerData[x].data.urls.length;t++){
                    if(homeData[j].data.url == containerData[x].data.urls[t]){
                        if(containerData[x].data.imgs[t].indexOf("default.png")>-1){
                            var imgPath = getLauncherAllAppImgNameByUrl(homeData[j].data.url);
                            if(imgPath==null){
                                homeData[j].data.appimg = "launcher/title/default.png";
                                homeData[j].Icon = "launcher/title/default.png";
                            }else{
                                homeData[j].data.appimg = "launcher/title/"+imgPath+".png";
                                homeData[j].Icon = "launcher/title/"+imgPath+".png";
                            }
                        }else{
                            homeData[j].data.appimg = containerData[x].data.imgs[t];
                            homeData[j].Icon = containerData[x].data.imgs[t];
                        }

                        break;
                    }
                }
            }
        }
    }


    var homeDataAppUrls = [];
    for(var j =0;j<homeData.length;j++){
        if(homeData[j].cmd == LauncherCMD.APP || homeData[j].cmd == LauncherCMD.BROWSER){
            if(!!homeData[j].data.url){
                homeDataAppUrls.push(homeData[j].data.url);
            }
        }
    }

    var addBrowserApp = getAddAppFromBrowser();
    if(addBrowserApp!=null && addBrowserApp.length>0){
        var appIndex = 0;
        for(var i=0;i<homeData.length;i++){
            if(homeData[i].cmd == LauncherCMD.ALLAPP){
                appIndex = i+1;
                break;
            }
        }
        launcherLastAppBrowserAddNum = addBrowserApp.length;
        for (var n = 0; n < addBrowserApp.length; n++) {
            if($.inArray(addBrowserApp[n].appUrl,homeDataAppUrls) == -1){
//                if($.inArray(addBrowserApp[n].appUrl,foxxumApp) == -1){
                var item = {};
                item.Name = addBrowserApp[n].appName;
                item.Icon = addBrowserApp[n].Image;
                item.cmd =  LauncherCMD.BROWSER;
                item.url = addBrowserApp[n].appUrl;
                item.data = {};
                item.data.appimg =addBrowserApp[n].Image;
                item.data.canMove = true;
                item.data.canRemove = true;
                item.data.img = addBrowserApp[n].Image;
                item.data.txt = addBrowserApp[n].appName;
                item.data.url = addBrowserApp[n].appUrl;
                item.data.urlType = addBrowserApp[n].appUrlType;
                item.data.storeType = StoreType.BROWSER;
                homeData.splice(appIndex,0,item);
                appIndex++;
//                    homeData.push(item);
//                }
            }
        }
    }
    else{
        launcherLastAppBrowserAddNum = 0;
    }

//    DBG_INFO("xml data:" + objToString(homeData));
    if(hasAllAppTitles && allAppLen != allAppTitlesLen){
        DBG_ERROR(" allAppLen != allAppTitlesLen");
        hasAllAppTitles = false;
    }
    var allAppArray = [],allAppTitlesArray = [];
    for(var k=0;k<containerData.length;k++){
        if(containerData[k].tagType == LauncherTagType.AllAPP){
            allAppArray = containerData[k].data.urls;
        }
        if(containerData[k].tagType == LauncherTagType.AllAPPTITLES){
            allAppTitlesArray = containerData[k].data.urls;
        }
    }
    for(var mm=0;mm<allAppTitlesArray.length;mm++){
        if($.inArray(allAppTitlesArray[mm],allAppArray) == -1){
            DBG_ERROR("allApp!=allAppTitlesArray");
            hasAllAppTitles = false;
            break;
        }
    }

    var tileData = [];
    for(var j =0;j<homeData.length;j++){
//        if(homeData[j].url == "netflix"){
//            homeData[j].Icon = "launcher/title/netflix.png";
//        }else if(homeData[j].url == "youtube"){
//            homeData[j].Icon = "launcher/title/youtube.png";
//        }else if(homeData[j].url == "amazonruby"){
//            homeData[j].Icon = "launcher/title/amazon.png";
//        }else if(homeData[j].url == "vudu"){
//            homeData[j].Icon = "launcher/title/vudu.png";
//        }
        if(homeData[j].cmd == LauncherCMD.ALLAPP){
            if(homeData[j].data.urls.length>0){
                var appimgs = [];
                for(var n=0;n<containerData.length;n++){
                    if(hasAllAppTitles){
                        if(containerData[n].tagType == LauncherTagType.AllAPPTITLES){
                            for(var x=0;x<homeData[j].data.urls.length;x++){
                                for(var y=0;y<containerData[n].data.urls.length;y++){
                                    if(homeData[j].data.urls[x] == containerData[n].data.urls[y]){
                                        if(containerData[n].data.imgs[x].indexOf("default.png")>-1){
                                            var imgPath = getLauncherAllAppImgNameByUrl(homeData[j].data.urls[x]);
                                            if(imgPath==null){
                                                appimgs[x] = "launcher/title/default.png";
                                            }else{
                                                appimgs[x] = "launcher/title/"+imgPath+".png";
                                            }
                                        }else{
                                            if(containerData[n].data.Icon_96[y] != null){
                                                appimgs[x] = containerData[n].data.Icon_96[y];
                                            }else{
                                                appimgs[x] = containerData[n].data.imgs[y];
                                            }
                                        }
                                        break;
                                    }
                                }
                                if(homeData[j].data.imgs[x].indexOf("default.png")>-1){
                                    var imgPath = getLauncherAllAppImgNameByUrl(homeData[j].data.urls[x]);
                                    if(imgPath==null){
                                        homeData[j].data.imgs[x] = "launcher/app/default.png";
                                    }else{
                                        homeData[j].data.imgs[x] = "launcher/app/"+imgPath+".png";
                                    }
                                }
                            }
                            break;
                        }
                    }
                    else{
                        for(var x=0;x<homeData[j].data.urls.length;x++){
                            if(homeData[j].data.imgs[x].indexOf("default.png")>-1){
                                var imgPath = getLauncherAllAppImgNameByUrl(homeData[j].data.urls[x]);
                                if(imgPath==null){
                                    homeData[j].data.imgs[x] = "launcher/app/default.png";
                                }else{
                                    homeData[j].data.imgs[x] = "launcher/app/"+imgPath+".png";
                                }
                            }
                            if(homeData[j].data.Icon_96[x] != null){
                                appimgs[x] = homeData[j].data.Icon_96[x];
                            }else{
                                var imgPath1 = getLauncherAllAppImgNameByUrl(homeData[j].data.urls[x]);
                                if(imgPath1==null){
                                    appimgs[x] = homeData[j].data.imgs[x];
                                }else{
                                    appimgs[x] = "launcher/title/"+imgPath1+".png";
                                }

                            }

                        }
                    }

                }
                homeData[j].data.appimgs = appimgs;
            }
            var settingUseApps = [];
            $.each(homeData[j].data.urls, function(k,v) {
                if('netflix' == v) {
                    settingUseApps.push(v);
                }
                else if('vudu' == v || 'vudu_movie' == v) {
                    settingUseApps.push('vudu');
                }
            });
            writeFileToNative('launcher/settingappinfo.txt', objToString(settingUseApps), 1);
            tileData = homeData[j];
        }
    }
    for(var z =0;z<homeData.length;z++){
        if(homeData[z].cmd == LauncherCMD.ALLAPP){
            homeData[z].Name = "[OT0043]";
        }else if(homeData[z].cmd == LauncherCMD.LIVETV){
            homeData[z].Name = "[LA0076]";
        }else if(homeData[z].cmd == LauncherCMD.ALLINPUTS){
            homeData[z].Name = "[LA0087]";
        }else if(homeData[z].cmd == LauncherCMD.HIMEDIA){
            homeData[z].Name = "[LA0019]";
        }else if(homeData[z].cmd == LauncherCMD.SETTINGS){
            homeData[z].Name = "[DMP0123]";
        }
        if(homeData[z].cmd == LauncherCMD.APP)
        {
            try{
            for(var t=0;t<tileData.data.urls.length;t++){
                if(homeData[z].data.url == tileData.data.urls[t]){
                    homeData[z].Icon = tileData.data.appimgs[t];
                    break;
                }
            }
            }catch(e){
                DBG_ERROR("refresh launcher app icon:"+e);
            }

        }

    }
    if(!!youtube_video && !!youtube_video.urls){
        var notificationIndex = 0;
        for(var s =0;s<homeData.length;s++){
            if(homeData[s].cmd == LauncherCMD.NOTIFICATION){
                notificationIndex = s+1;
            }
            if(homeData[s].cmd == LauncherCMD.YOUTUBE_VIDEO){
                var dx = $.inArray(homeData[s].data.url, youtube_video.urls);
                DBG_INFO("youtube_video:"+dx);
                if (dx < 0 ) {
                    homeData.splice(s, 1);
                    s--;
                }
            }
        }
        for(var g=0;g<youtube_video.urls.length;g++){
            var already = false;
            for(var e =0;e<homeData.length;e++){
                if(homeData[e].cmd == LauncherCMD.YOUTUBE_VIDEO){
                    if(homeData[e].data.url == youtube_video.urls[g]){
                        already = true;
                        homeData[e].Icon = youtube_video.imgs[g];
                        break;
                    }
                }
            }
            if(already){
                continue;
            }
            var item = {"Name": "FreeviewPlay", "Icon": "launcher/title/youtube.png",
                "cmd": LauncherCMD.YOUTUBE_VIDEO,"url":"youtube","data":{"url":"url","storeType":98,"urlType":36,"txt":""}};
            item.Name = youtube_video.txts[g];
            item.Icon = youtube_video.imgs[g];
            item.url = youtube_video.urls[g];
            item.data.url = youtube_video.urls[g];
            item.data.storeType = youtube_video.storeTypes[g];
            item.data.urlType = youtube_video.urlTypes[g];
            item.data.txt = youtube_video.txts[g];
            homeData.splice(notificationIndex,0,item);
            notificationIndex++;
        }
    }else{
        for(var q =0;q<homeData.length;q++){
            if(homeData[q].cmd == LauncherCMD.YOUTUBE_VIDEO){
                homeData.splice(q, 1);
                q--;
            }
        }
    }
    allAppsWriteToFileForUse(containerData);
    presetInstallerApp(installerList);
    return homeData;
}

function parseLauncherCategoryContentData(url, defaultData, launcherPath,tagType) {

    var contentData = {};
    contentData.txts = [];
    contentData.imgs = [];
    contentData.urls = [];
//    contentData.objectDesc = [];
    contentData.urlTypes = [];
    contentData.storeTypes = [];
    contentData.canRemoves = [];
    contentData.canMoves = [];
    contentData.Installer = [];
    contentData.Locked = [];
    contentData.from = [];
    contentData.appId = [];
    contentData.widths = [];
    contentData.Icon_96 = [];
    contentData.Descs = [];
    contentData.contentMD5 = null;
    if (!url) {
        return null;
    }

    var contentJSON = null;
    if (defaultData) {
        contentJSON = readXMLDOM(launcherPath + url, 2);
    }
    else {
        contentJSON = readXMLDOM(launcherPath + url, 1);
    }
    if (null == contentJSON) {
        DBG_INFO('read category ' + url + 'error. ', DebugLevel.ERROR);
        return null;
    }

    var objectTmp = getNodesByKey(ObjectKey.OBJECTINFO, contentJSON);
    if(tagType == LauncherTagType.RECOMMEND || tagType == LauncherTagType.PICTURE || tagType == LauncherTagType.PICTURE_B){
        var md5 = getTextByKey("contentMD5",contentJSON);
        if(!!md5){
            contentData.contentMD5 = md5;
        }
    }
    for (var j = 0; j < objectTmp.length; j++) {
        contentData.txts[j] = getItemsByLanguage(getNodesByKey(ObjectKey.OBJECTNAME, objectTmp[j]), "name", false);
        contentData.imgs[j] = getItemsByLanguage(getNodesByKey(ObjectKey.OBJECTPICTURE, objectTmp[j]), 'pictureUrl', false);
        contentData.urlTypes[j] = parseInt(getTextByKey(ObjectKey.OBJECTTYPE, objectTmp[j]));
        contentData.urls[j] = getTextByKey(ObjectKey.OBJECTURL, objectTmp[j]);
//        contentData.objectDesc[j] = getTextByKey("objectDesc", objectTmp[j]);
        if(contentData.urls[j] == APPNAME.AMAZONRUBY){
            contentData.urls[j] = APPNAME.AMAZON;
        }
        contentData.Icon_96[j] = null;
        if(!!tagType && (tagType== LauncherTagType.PICTURE || tagType== LauncherTagType.PICTURE_B)){
            contentData.Descs[j] = getItemsByLanguage(getNodesByKey(ObjectKey.OBJECTDESCS, objectTmp[j]), "desc", false);
        }
        contentData.widths[j] = getTextByKey(ObjectKey.WIDTH, objectTmp[j]);
        contentData.canMoves[j] = parseInt(getTextByKey(ObjectKey.MOVABLE, objectTmp[j])) == 0 ? false : true;
        contentData.Installer[j] = parseInt(getTextByKey(ObjectKey.INSTALLER, objectTmp[j])) == 1 ? true : false;
        contentData.Locked[j] = false;
        contentData.from[j] = "preset";
        contentData.appId[j] = -1;
        contentData.canRemoves[j] = (contentData.urlTypes[j] == CmdURLType.START_WEBAPP);
        if(contentData.Installer[j] && tagType == 57){
            cannotInstallApps.push(contentData.urls[j]);
        }
        if(!contentData.canRemoves[j]){
            contentData.Installer[j] = true;
        }
        var ownerId = getOwnerId(objectTmp[j]);
        if (ownerId == null) {
            contentData.storeTypes[j] = 10000;
        }
        else {
            contentData.storeTypes[j] = parseInt(ownerId);
            if(contentData.storeTypes[j] == StoreType.OPERA){
                contentData.from[j] = "store";
            }
        }
        if(contentData.urlTypes[j] == 14){
            contentData.storeTypes[j] = 100;
            contentData.urlTypes[j] = 36;
        }
//        if(contentData.urlTypes[j] == 32){
//            contentData.storeTypes[j] = 100;
//            contentData.urlTypes[j] = 36;
//        }
        if (92 == ownerId && CmdURLType.VUDU_POSTER != contentData.urlTypes[j]) {
            contentData.urlTypes[j] = CmdURLType.VUDU_POSTER;
            DBG_INFO("vudu poster, set object type = " + CmdURLType.VUDU_POSTER, DebugLevel.WARNING);
        }
    }

    return contentData;
}

function getItemsByLanguage(items, key, def) {

    var langs = ["chi", "eng", "fre", "kor", "rus", "jpn", "spa", "ger", "zho", "ara", "per",
        "tha", "ita", "dut", "por", "cze", "hun", "gre", "bul", "rum", "mal",
        "hbr", "tur", "ind", "uzb", "nor", "swe", "dan", "fin", "vie"
        , "mya", "hin", "eng", "ukr", "slk", "pol", "srp","mac","alb","hrv","lav","est","lit"];
    var languageId = langs.indexOf(GLOBAL.CURRENT_LANGUAGE);
//    DBG_ALWAYS("getItemsByLanguage!!!!!!!!!!:"+languageId);

    if (languageId < 0) {
        languageId = 1;
    }
//    else if (36 == languageId) {
//        languageId = 31;
//    }
//    def = true;
    return getItemByKeyLang(key, items[0], languageId, def);
}
function loadLauncherDefaultData(launcherPath, countryCode) {
    if(countryCode =="PRI" || countryCode =="USA"){
        var crtCode = "USA";
        var obj = readXMLDOM(launcherPath + 'CategoryIndex_' + crtCode + "_"+GLOBAL.LAUNCHER_BRAND+".xml", 2);
    }else if(countryCode =="CAN"){
        var obj = readXMLDOM(launcherPath + 'CategoryIndex_' + countryCode + ".xml", 2);
    }else{
        var crtCode = "MEX";
        if(GLOBAL.UI_BRAND == "tos"){
            var obj = readXMLDOM(launcherPath + 'CategoryIndex_MEX_tos.xml', 2);
        }else{
            var obj = readXMLDOM(launcherPath + 'CategoryIndex_' + crtCode + ".xml", 2);
        }
    }

    if (null == obj) {
        DBG_ERROR("can not find default CategoryIndex_" + countryCode + ".xml");
        obj = readXMLDOM(launcherPath + 'CategoryIndex.xml', 2);
    }
    return obj;
}

/*get launcher service update countryCode and timeStamp*/
function getLauncherServiceUpdateData() {
    var srvUpdate = {},
        cTimestampDom = readXMLDOM('launcher/data/serviceUpdate.xml', 1),
        cTimestampJson = getServiceUpdateJSON(cTimestampDom);
    if (null != cTimestampJson) {
        srvUpdate.timeStamp = cTimestampJson.updateTimestamp;
        srvUpdate.countryCode = cTimestampJson.countryCode;
    }
    else {
        srvUpdate.timeStamp = 0;
        srvUpdate.countryCode = '';
    }
    if (getAlwaysDefaultDataStatus()) {
        srvUpdate.timeStamp = 0;
        var currentCountryCode = tv ? ChangeCountryNumToCode(model.basicSetting.getTvsetLocation()) : "USA";
//        if (currentCountryCode != "USA" && currentCountryCode != "CAN" && currentCountryCode != "MEX") {
//            currentCountryCode = "USA";
//        }
        srvUpdate.countryCode = tv ? currentCountryCode : "USA";
    }
    return srvUpdate;
}

//function getServiceSwitchJSON(dom){
//    var srvjson = {
//        acrFlag: 1
//    };
//    try {
//        if(null != dom) {
//            srvjson.acrFlag = dom.getElementsByTagName("acrFlag")[0].textContent;
//        }
//    }
//    catch (ex){
//        DBG_ERROR(ex.message);
//    }
//    return srvjson;
//}

//function initAcrServer() {
//    if(!acrflag){
//        return;
//    }
//    DBG_ERROR("!!!!!!!!!!!!!initAcrServer Acr!!!!!!!!!!1111111111111");
//    var srvUpdate = {},
//        switchDom = readXMLDOM('launcher/data/SwitchFeatureList.xml', 1),
//        switchJson = getServiceSwitchJSON(switchDom);
//    if (null != switchJson) {
//        srvUpdate.acrFlag = switchJson.acrFlag;
//    }
//    else {
//        srvUpdate.acrFlag = AcrSwitch.ON;
//    }
//    g_acrSwitch.GlobalSwitch = srvUpdate.acrFlag;
//    DBG_ERROR("!!!!!!!!!!!!!initAcrServer Acr!!!!!!!!!!");
//    var acrSwitch = readFileFromNative('launcher/acrSwitch.json', 1);
//    if (null == acrSwitch) {
//        g_acrSwitch.settingSwitch = AcrSwitch.OFF;
//        g_acrSwitch.lastSettingSwitch = AcrSwitch.OFF;
//        g_acrSwitch.acrPeriod = 0;
//        g_acrSwitch.acrNotification = AcrSwitch.ON;
//        g_acrSwitch.acrPeriodIndex = 12;
//
//    }else{
//        g_acrSwitch.settingSwitch = acrSwitch.settingSwitch;
//        g_acrSwitch.lastSettingSwitch = acrSwitch.lastSettingSwitch;
//        g_acrSwitch.settingSwitch = acrSwitch.lastSettingSwitch;
//        g_acrSwitch.acrPeriod = acrSwitch.acrPeriod;
//        g_acrSwitch.acrNotification = acrSwitch.acrNotification;
//        g_acrSwitch.acrPeriodIndex = acrSwitch.acrPeriodIndex;
//    }
//    DBG_ERROR("ACR doesn't start cos of Global Switch when power on:"+g_acrSwitch.acrNotification);
//    if(g_acrSwitch.GlobalSwitch == AcrSwitch.OFF){
//        DBG_ERROR("ACR doesn't start cos of Global Switch when power on");
////        stopAcrServerSendCmd("GLOBAL");
////        g_acrSwitch.lastSettingSwitch = g_acrSwitch.settingSwitch;
//        g_acrSwitch.settingSwitch = AcrSwitch.OFF;
//    }else{
//        if(g_acrSwitch.settingSwitch == AcrSwitch.OFF){
//            DBG_ERROR("ACR doesn't start cos of Setting Switch when power on");
////            stopAcrServerSendCmd("Setting");
//        }else{
//            if(model.system.getUserMode()!=0 || isTtsPlay()){
//                g_acrSwitch.settingSwitch = AcrSwitch.OFF;
//                DBG_ERROR("ACR doesn't start cos of tv is Store Mode or tts is On when power on");
//            }else{
//                DBG_ERROR("ACR start when power on");
//                startAcrServerSendCmd("Setting");
//            }
//        }
//    }
//    saveAcrSwitchData();
//
//}



function acrServiceSwitchUpdate(){
    if(!acrflag || !isCurCountryhasACR()){
        return;
    }
    var srvUpdate = {},
        switchDom = readXMLDOM('launcher/data/SwitchFeatureList.xml', 1),
        switchJson = getServiceSwitchJSON(switchDom);
    if (null != switchJson) {
        srvUpdate.acrFlag = switchJson.acrFlag;
    }
    else {
        srvUpdate.acrFlag = AcrSwitch.ON;
    }
//    if(getSystemLongTime()>g_acrSwitch.acrPeriod){
//        if(g_acrSwitch.acrStatus == AcrStatus.ACR_START){
//            stopAcrServerSendCmd("Setting");

//        }
    //            g_acrSwitch.lastSettingSwitch = g_acrSwitch.settingSwitch;
//            g_acrSwitch.settingSwitch = AcrSwitch.OFF;
    //            if (tv) {
//                writeFileToNative('launcher/acrSwitch.json', objToString(g_acrSwitch), 1);
//            }
//    }else{
        DBG_ERROR("acrServiceSwitchUpdate:"+g_acrSwitch.GlobalSwitch +":"+srvUpdate.acrFlag);
        if(g_acrSwitch.GlobalSwitch != srvUpdate.acrFlag){
            g_acrSwitch.GlobalSwitch = srvUpdate.acrFlag;
            DBG_ERROR("g_acrSwitch.acrStatus:"+g_acrSwitch.acrStatus);
            if(srvUpdate.acrFlag == AcrSwitch.ON){
                if(g_acrSwitch.acrStatus == AcrStatus.ACR_STOP){
                    if(g_acrSwitch.lastSettingSwitch == AcrSwitch.ON){
                        startAcrServerSendCmd("Global");
                        g_acrSwitch.settingSwitch = g_acrSwitch.lastSettingSwitch;
                    }
                }
            }else{
                g_acrSwitch.lastSettingSwitch = g_acrSwitch.settingSwitch;
                g_acrSwitch.settingSwitch = AcrSwitch.OFF;
                if(g_acrSwitch.acrStatus == AcrStatus.ACR_START){
                    stopAcrServerSendCmd("GLOBAL");
                }
            }
            if (tv) {
                writeFileToNative('launcher/acrSwitch.json', objToString(g_acrSwitch), 1);
            }
        }
//    }

}

function getLauncherDeleteAppByUser() {
    if (!tv) {
        var deletedApps = [];
    } else {
        var deletedApps = readFileFromNative('launcher/deletedPresetApp.txt', 1);
        if (null == deletedApps) {
            DBG_ALWAYS("parseOEMLauncherDeleteApp:no delete app!");
            deletedApps = [];
        }
//        DBG_INFO("parseOEMLauncherDeleteApp:" + deletedApps);
    }
    return deletedApps;
}
function getLauncherLockedAppByUser() {
    if (!tv) {
        var deletedApps = ["netflix","youtube"];
    } else {
        var deletedApps = readFileFromNative('launcher/lockedApp.txt', 1);
        if (null == deletedApps) {
            DBG_ALWAYS("getLauncherLockedAppByUser:no delete app!");
            deletedApps = [];
        }
//        DBG_INFO("getLauncherLockedAppByUser:" + deletedApps);
    }
    return deletedApps;
}

function getLauncherInstallerAppByUser() {
    if (!tv) {
        var deletedApps = ["https://www-hisense.mgo.com/"];
    } else {
        var deletedApps = readFileFromNative('launcher/installerApp.txt', 1);
        if (null == deletedApps) {
            DBG_ALWAYS("getLauncherInstallerAppByUser:no delete app!");
            deletedApps = ["netflix","youtube","vudu","amazonruby","amazon"];
        }
        if($.inArray("netflix", deletedApps)<0){
            deletedApps.push("netflix");
        }
        if($.inArray("youtube", deletedApps)<0){
            deletedApps.push("youtube");
        }
        if($.inArray("vudu", deletedApps)<0){
            deletedApps.push("vudu");
        }
        if($.inArray("amazon", deletedApps)<0){
            deletedApps.push("amazon");
        }
        if($.inArray("amazonruby", deletedApps)<0){
            deletedApps.push("amazonruby");
        }
//        if($.inArray("pandora", deletedApps)<0){
//            deletedApps.push("pandora");
//        }
//        DBG_INFO("getLauncherInstallerAppByUser:" + deletedApps);
    }
    return deletedApps;
}
function getLauncherUninstallAppByUser(){
    if (!tv) {
        var deletedApps = ["pandora"];
    } else {
        var deletedApps = readFileFromNative('launcher/uninstallApp.txt', 1);
        if (null == deletedApps) {
            DBG_ALWAYS("getLauncherUninstallAppByUser:no delete app!");
            deletedApps = [];
        }
//        DBG_INFO("getLauncherUninstallAppByUser:" + deletedApps);
    }
    return deletedApps;
}
function allAppsWriteToFileForUse(launcherData) {

    var tmpData = launcherData,
        index = 0,
        tempData = {
            AppInfo: []
        };

    for(var i = 0; i < tmpData.length; ++i) {
        if(tmpData[i].tagType == '57') {
            index = i;
            break;
        }
    }

    var dataContents = tmpData[index].data,
        dataLength = dataContents.txts.length;

    var deletedPresetApps = readFileFromNative("launcher/deletedPresetApp.txt", 1);

    for (var i = 0; i < dataLength; ++i) {

        if (Array.isArray(deletedPresetApps) && deletedPresetApps.indexOf(dataContents.urls[i]) > -1) {
            //debugE("This App has been removed:" + dataContents.urls[i]);
            continue;
        }
        if(dataContents.urlTypes[i] == 36 && dataContents.storeTypes[i] == 95){
            continue;
        }
        tempData.AppInfo.push({
            AppName: dataContents.txts[i],
            IconURL: dataContents.imgs[i],
            InstallTime: "",
            RunTimes: 0,
            URL: ((null == dataContents.urls[i]) ? ("") : (dataContents.urls[i])),
            StartCommand: ((null == dataContents.urls[i]) ? ("") : (dataContents.urls[i])),
            UrlType: dataContents.urlTypes[i],
            StoreType: dataContents.storeTypes[i],
            PreInstall: true
        });
    }
    writeFileToNative('launcher/preset.txt', objToString(tempData), 1);
}

function getRememberEditAppFromNativeFile() {

    if (!tv) {
        var rememberEditApp = getDefaultHomeConfigData("USA");
        if(g_fteNoneSource.none){
            for(var i=0;i<rememberEditApp.appInfo.length;i++){
                if(rememberEditApp.appInfo[i].cmd == LauncherCMD.LIVETV){
                    rememberEditApp.appInfo.splice(i, 1);
                    break;
                }
            }
        }
        return rememberEditApp;
    } else {
        var rememberEditApp = readFileFromNative('launcher/rememberEditApp.json', 1);
        var currentCountryCode = g_LauncherData.currentCountryCode;
        if (null == rememberEditApp) {
//            DBG_ERROR("parseOEMLauncherDeleteApp!!!!!!!!!!!!!!!!!!!!!!!!!!:");
            rememberEditApp = getDefaultHomeConfigData(currentCountryCode);
//            setRememberEditAppToNativeFile(rememberEditApp.appInfo);
            if(g_fteNoneSource.none){
                for(var i=0;i<rememberEditApp.appInfo.length;i++){
                    if(rememberEditApp.appInfo[i].cmd == LauncherCMD.LIVETV){
                        rememberEditApp.appInfo.splice(i, 1);
                        break;
                    }
                }
            }else{
                if(g_fteNoneSource.needUpdate){
                    var hasLive = false;
                    for(var i=0;i<rememberEditApp.appInfo.length;i++){
                        if(rememberEditApp.appInfo[i].cmd == LauncherCMD.LIVETV){
                            hasLive = true;
                            break;
                        }
                    }
                    if(!hasLive){
                        var item = {"Name": "Live TV", "Icon": "launcher/inputs/"+GLOBAL.LAUNCHER_BRAND+"/livetv.png", "tagType": "70", "cmd": LauncherCMD.LIVETV};
                        rememberEditApp.appInfo.push(item);
                    }
                }

            }
            return rememberEditApp;
        }
        if (currentCountryCode == rememberEditApp.countryCode) {
            var appErr = true;
            var settingErr = true;
            var inputErr = true;

            for(var i=0;i<rememberEditApp.appInfo.length;i++){
                if(rememberEditApp.appInfo[i].cmd == LauncherCMD.ALLAPP){
                    appErr = false;
                    continue;
                }
                if(rememberEditApp.appInfo[i].cmd == LauncherCMD.SETTINGS){
                    settingErr = false;
                    continue;
                }
                if(rememberEditApp.appInfo[i].cmd == LauncherCMD.ALLINPUTS){
                    inputErr = false;
                }
            }
            if(appErr || settingErr || inputErr){
                rememberEditApp = getDefaultHomeConfigData(currentCountryCode);
            }
            if(g_fteNoneSource.none){
                for(var i=0;i<rememberEditApp.appInfo.length;i++){
                    if(rememberEditApp.appInfo[i].cmd == LauncherCMD.LIVETV){
                        rememberEditApp.appInfo.splice(i, 1);
                        break;
                    }
                }
            }else{
                if(g_fteNoneSource.needUpdate){
                    var hasLive = false;
                    for(var i=0;i<rememberEditApp.appInfo.length;i++){
                        if(rememberEditApp.appInfo[i].cmd == LauncherCMD.LIVETV){
                            hasLive = true;
                            break;
                        }
                    }
                    if(!hasLive){
                        var item = {"Name": "Live TV", "Icon": "launcher/inputs/"+GLOBAL.LAUNCHER_BRAND+"/livetv.png", "tagType": "70", "cmd": LauncherCMD.LIVETV};
                        rememberEditApp.appInfo.push(item);
                    }
                }

            }

            return rememberEditApp;
        } else {
            DBG_INFO("VIDAALiteGetRememberEditApp:currentCountry:" + currentCountryCode + ",rememberCountry:" + rememberEditApp.countryCode);
//            var ret = Hisense.File.delete('launcher/rememberEditApp.json', 1);
//            if(0 != ret) {
//                DBG_ERROR('remove native file: "' + path + '" error. Error code = ' + ret);
//            }
//            else {
//                DBG_INFO('remove native file: "' + path + '" success');
//            }
//            return {};
            rememberEditApp = getDefaultHomeConfigData(currentCountryCode);
            if(g_fteNoneSource.none){
                for(var i=0;i<rememberEditApp.appInfo.length;i++){
                    if(rememberEditApp.appInfo[i].cmd == LauncherCMD.LIVETV){
                        rememberEditApp.appInfo.splice(i, 1);
                        break;
                    }
                }
            }else{
                if(g_fteNoneSource.needUpdate){
                    var hasLive = false;
                    for(var i=0;i<rememberEditApp.appInfo.length;i++){
                        if(rememberEditApp.appInfo[i].cmd == LauncherCMD.LIVETV){
                            hasLive = true;
                            break;
                        }
                    }
                    if(!hasLive){
                        var item = {"Name": "Live TV", "Icon": "launcher/inputs/"+GLOBAL.LAUNCHER_BRAND+"/livetv.png", "tagType": "70", "cmd": LauncherCMD.LIVETV};
                        rememberEditApp.appInfo.push(item);
                    }
                }

            }
            return rememberEditApp;
        }
    }
}
function setRememberEditAppToNativeFile(editApp) {
//    DBG_ERROR("Remember Data is :" + JSON.stringify(editApp));
    var currentCountryCode = tv ? ChangeCountryNumToCode(model.basicSetting.getTvsetLocation()) : "USA";
//    if (currentCountryCode != "USA" && currentCountryCode != "CAN" && currentCountryCode != "MEX") {
//        currentCountryCode = "USA";
//    }
    var rememberEditApp = {
        countryCode: currentCountryCode,
        appInfo: editApp
    };
    if (tv) {
        writeFileToNative('launcher/rememberEditApp.json', objToString(rememberEditApp), 1);
    }
}
function launcherResetTitlesConfig(){
//    DBG_ERROR("launcherResetTitlesConfig !!!!!!!!!!!!!!!!!!!!!!");
    var rememberEditApp = getDefaultHomeConfigData(g_LauncherData.currentCountryCode);
    setRememberEditAppToNativeFile(rememberEditApp.appInfo);
}

function getDefaultHomeConfigData(countryCode) {
    var app = {};
    GLOBAL.UI_BRAND  = getBrandCode(GLOBAL.CURRENT_AREA);
    if(GLOBAL.UI_BRAND == "his" || GLOBAL.UI_BRAND == "Hisense" || GLOBAL.UI_BRAND == "tos"){
        GLOBAL.LAUNCHER_BRAND = "his";
    }
    else if(GLOBAL.UI_BRAND == "Sharp" || GLOBAL.UI_BRAND == "shp"){
        GLOBAL.LAUNCHER_BRAND = "shp";
    }
    else{
        GLOBAL.LAUNCHER_BRAND = "his";
    }
    DBG_ERROR("getDefaultHomeConfigData crt brand :"+GLOBAL.LAUNCHER_BRAND);
        app = {"countryCode": "USA", "appInfo": [
            {"Name": "All Apps", "Icon": "launcher/inputs/"+GLOBAL.LAUNCHER_BRAND+"/apps.png", "tagType": "57", "cmd": LauncherCMD.ALLAPP, "data": null},
            {"Name": "Live TV", "Icon": "launcher/inputs/"+GLOBAL.LAUNCHER_BRAND+"/livetv.png", "tagType": "70", "cmd": LauncherCMD.LIVETV},
            {"Name": "All Inputs", "Icon": "launcher/inputs/"+GLOBAL.LAUNCHER_BRAND+"/inputs.png", "cmd": LauncherCMD.ALLINPUTS},
            {"Name": "Media", "Icon": "launcher/inputs/"+GLOBAL.LAUNCHER_BRAND+"/himedia.png", "tagType": "59", "cmd": LauncherCMD.HIMEDIA},
            {"Name": "Settings", "Icon": "launcher/inputs/"+GLOBAL.LAUNCHER_BRAND+"/settings.png", "cmd": LauncherCMD.SETTINGS}
        ]};
    app.countryCode = countryCode;
    return app;
}
var launcherNeedDownLoadAppImgUrl = [];
var launcherLastAppStoreAddNum = 0;
var launcherLastAppBrowserAddNum = 0;
function getAppIfInstall(url){
    var install = false;
    var installerData = getLauncherInstallerAppByUser();
    var uninstallData = getLauncherUninstallAppByUser();

    var idx = $.inArray(url,installerData);
    if(idx>-1){
        install = true;
    }
    if(!install){
        var addApps = getAddAppFromOpera();
        for (var n = 0; n < addApps.length; n++) {
            if(url == addApps[n].appUrl){
                install = true;
                break
            }
        }
    }
    idx = $.inArray(url,uninstallData);
    if(idx>-1){
        install = false;
    }
    if(!install){
        idx = $.inArray(url,cannotInstallApps);
        if(idx>-1){
            install = true;
        }
    }

    return install;
}

function getInstallAppUrlList(){
    var installArray = [];
    var installerData = getLauncherInstallerAppByUser();
    var uninstallData = getLauncherUninstallAppByUser();

    installArray.concat(cannotInstallApps);

    for (var m = 0; m < installerData.length; m++) {
        var idx = $.inArray(installerData[m], uninstallData);
        if (idx > -1) {
        }else{
            installArray.push(installerData[m]);
        }
    }
    var addApps = getAddAppFromOpera();
    for (var n = 0; n < addApps.length; n++) {
        var idx = $.inArray(addApps[n].appUrl,installArray);
        if (idx > -1) {
        }else{
            var idx = $.inArray(addApps[n].appUrl, uninstallData);
            if (idx > -1) {
            }else{
                installArray.push(installerData[m]);
            }
//            installArray.push(addApps[n].appUrl);
        }
    }
    return installArray;
}
function setAddAppToOpera(appInfo,flag,installIcon,secondObjectPic) {
    setLauncherInstallerAppByUser(appInfo.appUrl,flag);
    var favApps = readFileFromNative('launcher/Appinfo.json', 1);
    if (favApps == null) {
        favApps = {"AppInfo": []}
    }

//    DBG_ERROR("setAddAppToOpera:"+objToString(appInfo));
    DBG_ERROR("installIcon:"+installIcon);
    DBG_ERROR("secondObjectPic:"+secondObjectPic);
    if(!!appInfo.startupMode){

    }else{
        appInfo.startupMode = 95;
    }

    if(!appInfo.appId  || !appInfo.appUrl ||!appInfo.appName){
        return;
    }
    if(flag){
        if(!installIcon || !secondObjectPic){
            installIcon = " ";
            secondObjectPic = " ";
        }
    }
    var storeType ="opera";
    switch (appInfo.startupMode){
        case StoreType.OPERA:
            storeType ="opera";
            break;
        case StoreType.FOXXUM:
            storeType ="foxxum";
            break;
        case StoreType.NETRANGE:
            storeType ="netrange";
            break;
        case StoreType.STORE:
            storeType ="store";
            break;
        case StoreType.HBBTV:
            storeType ="hbbtv";
            break;
        case StoreType.BROWSER:
            storeType ="browser";
            break;
        case StoreType.HISENSE:
            storeType ="hisense";
            break;
        default:
            storeType ="opera";
            break;

    }
    try{
        var data = {
            "Id": appInfo.appId,
            "Title": appInfo.appName,
            "Thumb": appInfo.appIcon,
            "Icon_96": installIcon,
            "Image": installIcon,
            "URL": appInfo.appUrl,
            "AppName": appInfo.appName,
            "IconURL": installIcon,
            "StartCommand": appInfo.appUrl,
            "InstallTime": "2017-7-6",
            "RunTimes": 0,
            "StoreType":storeType
        };
    }catch(e){
        DBG_ERROR("setAddAppToOpera data :"+ e.message);
        return;
    }
    for (var i = 0; i < favApps.AppInfo.length; i++) {
        if (!!favApps.AppInfo[i] && appInfo.appUrl == favApps.AppInfo[i].URL) {
            if(!flag){
                favApps.AppInfo.splice(i, 1);
                break;
            }else{
                DBG_ERROR("This App is already installed!!!!");
                return;
            }
        }
    }
    if(flag){
        favApps.AppInfo.push(data);
    }

    writeFileToNative('launcher/Appinfo.json', objToString(favApps), 1);

}
function getAddAppFromOpera() {
    var storeTypeList = {
        "opera": StoreType.OPERA,
        "foxxum": StoreType.FOXXUM,
        "netrange": StoreType.NETRANGE,
        "store":StoreType.STORE,
        "hbbtv":StoreType.HBBTV,
        "browser":StoreType.BROWSER,
        "hisense":StoreType.HISENSE
    };
    var addApps = [];
    if (!tv) {
        addApps = [];
        return addApps;
    } else {
        launcherNeedDownLoadAppImgUrl = [];
        addApps = [];
        var favAppsPageData = readFileFromNative('launcher/Appinfo.json', 1);
        if (null == favAppsPageData || 0 == favAppsPageData.AppInfo.length) {
            return addApps;
        }
        var favArr = favAppsPageData.AppInfo;
        var iconArr = readCacheIndex('launcher/cache/index.json');
        if (null == iconArr) {
            iconArr = [];
        }
        for (var i = 0; i < favArr.length; i++) {
            var app = {};
//            app.Image = getLocalAppImgUrl(favArr[i].Image, iconArr);
//            app.Icon_96 = getLocalAppImgUrl(favArr[i].Icon_96, iconArr);
            app.Image = getLocalAppImgUrl(favArr[i].IconURL, iconArr);
            app.Icon_96 = getLocalAppImgUrl(favArr[i].IconURL, iconArr);
            app.appName = favArr[i].Title;
            app.appUrl = favArr[i].URL;
            app.appUrlType = CmdURLType.START_WEBAPP;
            app.canRemove = true;
            app.canMove = true;
            app.Installer = true;
            app.Locked = true;
            app.from = "store";
            if(isNaN(favArr[i].Id)){
                app.appId = -1;
            }else{
                app.appId = favArr[i].Id;
            }

            app.storeType = storeTypeList[favArr[i].StoreType];
            addApps.push(app);
        }
        cacheFileToNative(launcherNeedDownLoadAppImgUrl, 'launcher/cache', 'launcher/cache/index.json');
        DBG_INFO("getAddAppFromOpera:" + addApps.length);
        return addApps;
    }
}

function getAddAppFromBrowser() {
    var storeTypeList = {
        "opera": StoreType.OPERA,
        "foxxum": StoreType.FOXXUM,
        "netrange": StoreType.NETRANGE,
        "store":StoreType.STORE,
        "hbbtv":StoreType.HBBTV,
        "browser":StoreType.BROWSER,
        "hisense":StoreType.HISENSE
    };
    var addApps = [];
    if (!tv) {
        addApps = [];
        return addApps;
    } else {
//        launcherNeedDownLoadAppImgUrl = [];
        addApps = [];
        var favAppsPageData = readFileFromNative('launcher/BrowserAppInfo.json', 1);
        try{
            if (null == favAppsPageData || 0 == favAppsPageData.AppInfo.length) {
                return addApps;
            }
            var favArr = favAppsPageData.AppInfo;

            for (var i = 0; i < favArr.length; i++) {
                var app = {};
                app.Image = favArr[i].Image;
                app.appName = favArr[i].Title;
                app.appUrl = favArr[i].URL;
                app.appUrlType = CmdURLType.START_WEBAPP;
                app.canRemove = true;
                app.canMove = true;
                app.storeType = storeTypeList[favArr[i].StoreType];
                addApps.push(app);
            }
            DBG_INFO("getAddAppFromBrowser:" + addApps.length);
        }catch(e){
            DBG_ERROR("getAddAppFromBrowser:" + e.message);
            addApps = [];
            deleteNativeFile('launcher/BrowserAppInfo.json', 1);
        }
        return addApps;
    }
}

function setLauncherDeleteFoxxumAppByUser(url) {
    if (tv) {
        DBG_ALWAYS("setLauncherDeleteFoxxumAppByUser:url" + url);
        var favApps = readFileFromNative('launcher/BrowserAppInfo.json', 1);
        if (favApps == null) {

        } else {
            try{
                var favArr = favApps.AppInfo;
                for (var i = 0; i < favApps.AppInfo.length; i++) {
                    if (!!favArr[i] && url == favArr[i].URL) {
                        favArr.splice(i, 1);
                    }
                }
                writeFileToNative('launcher/BrowserAppInfo.json', objToString(favApps), 1);
            }catch(e){
                DBG_ERROR("setLauncherDeleteFoxxumAppByUser:" + e.message);
                deleteNativeFile('launcher/BrowserAppInfo.json', 1);
            }
        }
    }
}

function setLauncherDeleteAppByUser(url) {
    if (tv) {
        DBG_ALWAYS("deleteOEMLauncherEditApp:url" + url);
        var favApps = readFileFromNative('launcher/Appinfo.json', 1);
        if (favApps == null) {

        } else {
            var favArr = favApps.AppInfo;
            for (var i = 0; i < favApps.AppInfo.length; i++) {
                if (!!favArr[i] && url == favArr[i].URL) {
                    favArr.splice(i, 1);
                }
            }
            writeFileToNative('launcher/Appinfo.json', objToString(favApps), 1);
        }
        setLauncherInstallerAppByUser(url,false);
        //add deleted app
        var deletedApps = readFileFromNative('launcher/deletedPresetApp.txt', 1);
        if (null == deletedApps) {
            deletedApps = [];
        }
        for (i = 0; i < deletedApps.length; i++) {
            if ($.inArray(url, deletedApps) > -1) {
                DBG_ALWAYS("deleteOEMLauncherEditApp:have delete");
                return;
            }
        }
        deletedApps.push(url);
        writeFileToNative('launcher/deletedPresetApp.txt', objToString(deletedApps), 1);
        chanceAppVersion("delete");
        //remove preset
        var preApps = readFileFromNative('launcher/preset.txt', 1);
        if (null != preApps && !!preApps.AppInfo) {
            for (var i = 0; i < preApps.AppInfo.length; i++) {
                if (url == preApps.AppInfo[i].URL) {
                    preApps.AppInfo.splice(i, 1);
                    break;
                }
            }
            writeFileToNative('launcher/preset.txt', objToString(preApps), 1);
        }
        var lockApps = readFileFromNative('launcher/lockedApp.txt', 1);
        if (null == lockApps) {
            lockApps = [];
        }else{
            for (var j = 0; j < lockApps.length; j++) {
                if (url == lockApps[j]) {
                    lockApps.splice(j, 1);
                    break;
                }
            }
            writeFileToNative('launcher/lockedApp.txt', objToString(lockApps), 1);
        }


        //remove recentUseApps
//        var recentUseApps = readFileFromNative("hisenseUI/recentapps.txt", 1);
//        if (null != recentUseApps && !!recentUseApps.AppInfo) {
//            for (var i = 0; i < recentUseApps.AppInfo.length; i++) {
//                if (url == recentUseApps.AppInfo[i].URL) {
//                    recentUseApps.AppInfo.splice(i, 1);
//                    break;
//                }
//            }
//            writeFileToNative('hisenseUI/recentapps.txt', objToString(recentUseApps), 1);
//        }
    }
}
function setLauncherLockedAppByUser(url,flag) {
    if (tv) {
        DBG_ALWAYS("setLauncherLockedAppByUser:url" + url);
        var deletedApps = readFileFromNative('launcher/lockedApp.txt', 1);
        if (null == deletedApps) {
            deletedApps = [];
        }
        if(flag){
            for (var i = 0; i < deletedApps.length; i++) {
                if ($.inArray(url, deletedApps) > -1) {
                    DBG_ALWAYS("setLauncherLockedAppByUser:have locked");
                    return;
                }
            }
            deletedApps.push(url);
            writeFileToNative('launcher/lockedApp.txt', objToString(deletedApps), 1);
            var sMode = tv?model.parentlock.getSModel():1;
            var lockTime =  tv?model.source.getCurrentTimeInLock():1;
            var isLock = false;
            if(sMode!=0 && lockTime==1){
                isLock = true;
            }
            for(var x=0;x<g_ottList.length;x++){
                if(g_ottList[x].data.url == url){
                    if(isLock){
                        g_ottList[x].Locked = true;
                    }
                    break;
                }
            }

        }else{
            for (var i = 0; i < deletedApps.length; i++) {
                if (url == deletedApps[i]) {
                    deletedApps.splice(i, 1);
                    writeFileToNative('launcher/lockedApp.txt', objToString(deletedApps), 1);
                    for(var x=0;x<g_ottList.length;x++){
                        if(g_ottList[x].data.url == url){
                           g_ottList[x].Locked = false;
                            break;
                        }
                    }
                    break;
                }
            }
        }

    }
}
function resetDefaultOttLocked(){
    for(var x=0;x<g_ottList.length;x++){
        g_ottList[x].Locked = false;
    }
}

function presetInstallerApp(list) {
    var insApps = readFileFromNative('launcher/installerApp.txt', 1);
    if (null == insApps) {
        insApps = [];
        writeFileToNative('launcher/installerApp.txt', objToString(list), 1);
        return;
    }
    for (var i = 0; i < list.length; i++) {
        if ($.inArray(list[i], insApps) > -1) {
//            DBG_ALWAYS("presetInstallerApp:have install");
            continue;
        }
        insApps.push(list[i]);
    }
    g_installAppNum = insApps.length;
    writeFileToNative('launcher/installerApp.txt', objToString(insApps), 1);

}
function setLauncherInstallerAppByUser(url,flag) {
    if (tv) {
        DBG_ALWAYS("setLauncherInstallerAppByUser:" + url +" flag" +flag);
        var insApps = readFileFromNative('launcher/installerApp.txt', 1);
        var unApps = readFileFromNative('launcher/uninstallApp.txt', 1);
        if (null == insApps) {
            insApps = [];
        }
        if (null == unApps) {
            unApps = [];
        }
        if(flag){  //install
            for (var i = 0; i < unApps.length; i++) {
                if (url == unApps[i]) {
                    unApps.splice(i, 1);
                    writeFileToNative('launcher/uninstallApp.txt', objToString(unApps), 1);
                    break;
                }
            }
            for (var i = 0; i < insApps.length; i++) {
                if ($.inArray(url, insApps) > -1) {
                    DBG_ALWAYS("setLauncherInstallerAppByUser:have locked");
                    return;
                }
            }
            insApps.push(url);
            chanceAppVersion("install");
            writeFileToNative('launcher/installerApp.txt', objToString(insApps), 1);
        }else{  //uninstall
            var deletedApps = readFileFromNative('launcher/lockedApp.txt', 1);
            if (null == deletedApps) {
                deletedApps = [];
            }
            for (var i = 0; i < deletedApps.length; i++) {
                if (url == deletedApps[i]) {
                    deletedApps.splice(i, 1);
                    break;
                }
            }
            writeFileToNative('launcher/lockedApp.txt', objToString(deletedApps), 1);
            for (var i = 0; i < insApps.length; i++) {
                if (url == insApps[i]) {
                    insApps.splice(i, 1);
                    writeFileToNative('launcher/installerApp.txt', objToString(insApps), 1);
                    break;
                }
            }
            for (var i = 0; i < unApps.length; i++) {
                if ($.inArray(url, unApps) > -1) {
                    DBG_ALWAYS("setLauncherInstallerAppByUser:have locked");
                    return;
                }
            }
            unApps.push(url);
            chanceAppVersion("uninstall");
            writeFileToNative('launcher/uninstallApp.txt', objToString(unApps), 1);
        }
    }
}

function ifPandoraApp(appName,url){
    if(!!appName && appName.toLowerCase() == "pandora"){
        return true;
    }

    if(!!url && url.indexOf("https://tv.pandora.com/")>-1){
        return true;
    }
    return false;

}


function getLocalAppImgUrl(oriImgUrl, localIcons) {
    for (var i = 0; i < localIcons.length; i++) {
        if (oriImgUrl == localIcons[i].original_url) {
            return localIcons[i].local_url;
        }
    }
    launcherNeedDownLoadAppImgUrl.push(oriImgUrl);
    DBG_ALWAYS('getLocalAppImgUrl:can not find local icon, use image url.');
    return oriImgUrl;
}
var g_launcherDataPassword = "";
var g_alwaysDefaultData = false;
var g_alwaysDebugData = false;

function getAlwaysDefaultDataStatus() {
    g_alwaysDefaultData = readFileFromNative("launcher/default_launcher_data", 1);
    if (null == g_alwaysDefaultData) g_alwaysDefaultData = false;
    showLauncherDefaultDataTip();
    return g_alwaysDefaultData;
}
function getAlwaysDebugStatus() {
    var timeStamp  = tv?readFileFromNative("launcher/debugmode.txt", 1):null;
    var txt = 0;
    if(timeStamp!=null){
        txt = parseInt(timeStamp[0]);
    }
    if(txt == 0){
        g_alwaysDebugData = false;
    }else{
        g_alwaysDebugData = true;
    }
    showLauncherDebugDataTip();
    DBG_ERROR("getAlwaysDebugStatus:" + g_alwaysDebugData);
}

function setDefaultDataStatus(o, d, code) {
    var num = (parseInt(code) - (tv ? CONST.KEY.VK_0 : 48)) + "";
    g_launcherDataPassword += num;
    if ("1969" == g_launcherDataPassword.slice(-4)) {
        g_launcherDataPassword = "";
        g_alwaysDefaultData = !g_alwaysDefaultData;
        DBG_ALWAYS("always use default data[" + g_alwaysDefaultData + "]");
        writeFileToNative("launcher/default_launcher_data", g_alwaysDefaultData + "", 1);
        showLauncherDefaultDataTip();
    }
}

function setDebugDataStatus(o, d, code) {
    var num = (parseInt(code) - (tv ? CONST.KEY.VK_0 : 48)) + "";
    g_launcherDataPassword += num;
    if ("0532" == g_launcherDataPassword.slice(-4)) {
        g_launcherDataPassword = "";
        g_alwaysDebugData = !g_alwaysDebugData;
        DBG_ALWAYS("setDebugDataStatus[" + g_alwaysDebugData + "]");
        var txt = 0;
        if(g_alwaysDebugData){
            txt = 1;
        }
        var arr  = [];
        arr.push(txt);
        if(tv)writeFileToNative("launcher/debugmode.txt", objToString(arr), 1);
        showLauncherDebugDataTip();
    }
}
var LauncherDefaultDataTip = false;
function showLauncherDefaultDataTip() {
    if (g_alwaysDefaultData) {
        if(LauncherDefaultDataTip){
            return;
        }
        LauncherDefaultDataTip = true;
        var text = new PIXI.Text("No update service",
            {
                font: "40px Airal",
                fill: "red"
            });
        text.alpha = 1;
        text.name = "noUpdateTip";
        UI.base.addChildAt(text,0);
    } else {
        LauncherDefaultDataTip = false;
        UI.base.removeChild(UI.base.getChildByName("noUpdateTip"));
    }
    UI.updateStage();

//    $("#launcher_default_data_tip").css("display", g_alwaysDefaultData ? "block" : "none");
}
var LauncherDebugDataTip = false;
function showLauncherDebugDataTip() {
    if (g_alwaysDebugData) {
        if(LauncherDebugDataTip){
            return;
        }
        LauncherDebugDataTip = true;
        var text = new PIXI.Text("Debug Mode",
            {
                font: "40px Airal",
                fill: "red"
            });
        text.alpha = 1;
        text.x = 800;
        text.name = "debugModeTip";
        UI.base.addChildAt(text,0);
    } else {
        LauncherDebugDataTip = false;
        UI.base.removeChild(UI.base.getChildByName("debugModeTip"));
    }
    UI.updateStage();

//    $("#launcher_default_data_tip").css("display", g_alwaysDefaultData ? "block" : "none");
}

function hideLauncherDefaultDataTip() {

//    $("#launcher_default_data_tip").css("display", "none");
}

//function readXMLDOM(url, workRoot) {
//    if (!Config.tv) {
//        var xmlBasePath = (workRoot == 2) ? '../' : "../../appdata/";
//        var dom = loadxmldoc(xmlBasePath + url + "?time=" + Date.now());
//        return dom;
//    }
//    var dom = null;
//    DBG_INFO('xml path = ' + url + '; workRoot = ' + workRoot);
//    var obj = Hisense.File.read(url, workRoot);
//    if (isNaN(obj)) {
//        try {
//            dom = (new DOMParser()).parseFromString(obj, "text/xml");
//        }
//        catch (e) {
//            DBG_INFO("launcher_debug_readXML_error:" + e.message, DebugLevel.ERROR);
//            dom = null;
//        }
//        return dom;
//    }
//    else {
//        DBG_INFO("error in reading xml: " + obj, DebugLevel.ERROR);
//        return null;
//    }
//}
//
//function loadxmldoc(x) {
//    try {
//        DBG_INFO("XMLHttpRequest[" + x + "]");
//        var xmlDoc;
//        if (window.ActiveXObject) {
//            xmlDoc = new ActiveXObject("Microsoft.XMLDOM");
//            xmlDoc.async = false;
//            xmlDoc.load(x);
//        }
//        else if (window.XMLHttpRequest) {
//            xmlDoc = getxml(x).responseXML;
//        }
//        else {
//            return false;
//        }
//
//
//        return xmlDoc;
//    }
//    catch (ex) {
//        DBG_ERROR(ex.message);
//        return null;
//    }
//}
//var xmlhttpMain = null;
//function getxmlhttp() {
//    if (window.ActiveXObject) {
//        try {
//            xmlhttpMain = new ActiveXObject("Msxml2.XMLHTTP");
//        }
//        catch (e) {
//            xmlhttpMain = new ActiveXObject("Microsoft.XMLHTTP");
//        }
//    }
//    else if (window.XMLHttpRequest) {
//        xmlhttpMain = new XMLHttpRequest();
//    }
//    return xmlhttpMain;
//}
//
//function getxml(x) {
//    if (null == xmlhttpMain) {
//        getxmlhttp();
//    }
//    if (xmlhttpMain != null) {
//        xmlhttpMain.open("GET", x, false);
//        xmlhttpMain.send(null);
//    }
//    else {
//        DBG_INFO("Your browser does not support XMLHTTP.11");
//        return false;
//    }
//    return (xmlhttpMain);
//}

function launcherDataNeedToUpdate() {
    var update = LauncherUpdate.NOUPDATE;
    var tempSrvUpdate = getLauncherServiceUpdateData();
    var currentCountryCode = tv ? ChangeCountryNumToCode(model.basicSetting.getTvsetLocation()) : "USA";
//    if (currentCountryCode != "USA" && currentCountryCode != "CAN" && currentCountryCode != "MEX") {
//        currentCountryCode = "USA";
//    }
    acrServiceSwitchUpdate();
    var tempCountryCode = tv ? currentCountryCode : "USA";
    var tempLanguage = tv?ChangeLangNumToCode(model.language.getOsd()):GLOBAL.CURRENT_LANGUAGE;
    if(g_LauncherData.currentCountryCode != tempCountryCode
        || g_LauncherData.cTimestamp != tempSrvUpdate.timeStamp){
        update = LauncherUpdate.SERVICE;
        needUpdateFrom4kNow = false;
        chanceAppVersion("update");
        return update;

    }
    var addApps = getAddAppFromOpera();
//    DBG_ERROR("add app number:" + addApps.length);
    if (addApps.length != launcherLastAppStoreAddNum) {
        DBG_ERROR("OEMlauncherPageOnOpen:all app need update");
        needUpdateFrom4kNow = false;
	chanceAppVersion("opera");
        update = LauncherUpdate.SERVICE;
        return update;
    }else{
        for (var n = 0; n < addApps.length; n++) {
            if($.inArray(addApps[n].appUrl,g_appStoreList) == -1){
                DBG_ERROR("getAddAppFromOpera changed !!!!!!!!!!");
                update = LauncherUpdate.SERVICE;
                needUpdateFrom4kNow = false;
                return update;
            }
        }
    }

    var addBrowserApp = getAddAppFromBrowser();
    if (addBrowserApp.length != launcherLastAppBrowserAddNum) {
        DBG_ERROR("OEMlauncherPageOnOpen:all app need update");
        update = LauncherUpdate.SERVICE;
        return update;
    }

    var insApps = readFileFromNative('launcher/installerApp.txt', 1);
    if (null == insApps) {
        insApps = [];
    }
    if(insApps.length != g_installAppNum){
        DBG_ERROR("install app num  changed !!!!!!!!!!");
        update = LauncherUpdate.SERVICE;
        needUpdateFrom4kNow = false;
        return update;
    }

    DBG_ERROR("launcherDataNeedToUpdate:"+update);
    if(g_LauncherData.currentLanguage != tempLanguage){
        needUpdateFrom4kNow = false;
        update = LauncherUpdate.SERVICE;
        return update;
    }
//    DBG_ERROR("launcherDataNeedToUpdate!!!!!:"+g_fteNoneSource.needUpdate);
    if(g_fteNoneSource.needUpdate){
        needUpdateFrom4kNow = false;
        update = LauncherUpdate.SERVICE;
        return update;
    }
    DBG_ERROR("launcherDataNeedToUpdate!!!!!needUpdateFrom4kNow:"+needUpdateFrom4kNow);
    if(needUpdateFrom4kNow){
        needUpdateFrom4kNow = false;
        update = LauncherUpdate.SERVICE;
    }
    return update;
}


function isLauncherHomeAppCanRemove(url){
    var ret = true;
    switch(url){
        case "netflix":
        case "youtube":
        case "amazonruby":
        case "vudu":
            ret = false;
            break;
        default:
            ret = true;
            break;
    }
    return ret;
}

function getLauncherAllAppImgNameByUrl(url){
    var ret = null;
    switch(url){
        case "netflix":
            ret = "netflix";
            break;
        case "youtube":
            ret = "youtube";
            break;
        case "amazonruby":
        case "amazon":
            ret = "amazon";
            break;
        case "vudu":
            ret = "vudu";
            break;
        case "https://ecs.ultraflix.com/00170A3/ultraflix/index.html/?allowLive&device=Hi-Sense":
            ret = "Ultraflix";
            break;
        case "https://hisense.tvstore.opera.com:84/api/tvapps/runapp/ted-talks/?closeWindow=1":
            ret = "TED";
            break;
        case "https://hisense.tvstore.opera.com:84/api/tvapps/runapp/ted/?closeWindow=1":
            ret = "TED";
            break;
        case "pandora":
        case "https://tv.pandora.com/?model=MTK5658&vendor=Sharp&type=HTML5&modelYear=2016&badge=7bsx3s6dur6tkbtu562mnhhgxoh6dwtsen5gh6ldsjlntolr5xua&mouseEnabled=true&playKey=415&skipKey=417&pauseKey=19&backKey=8":
            ret = "pandora";
            break;
        case "http://www.yupptv.com/hisense/index.html":
            ret = "YuppTV";
            break;
        case "http://html5.toongoggles.com/":
            ret = "ToonGoggles";
            break;
        case "http://ott.on.aol.com/ott/hisense_tv/homepage":
            ret = "AOLOn";
            break;
        case "accuweather":
            ret = "accuweather";
            break;
        case "dailymotion":
            ret = "Dailymotion";
            break;
        case "http://www.viewster.tv/Viewster_v5/index.html":
            ret = "viewster";
            break;
        case "https://hisense.tvstore.opera.com:84/api/tvapps/runapp/facebook/?closeWindow=1":
            ret = "facebook";
            break;
        case "appstore":
            ret = "OperaTVStore";
            break;
        case "browser":
            ret = "TVBrowser";
            break;
        case "https://hisense.tvstore.opera.com:84/api/tvapps/runapp/tvitter/?closeWindow=1":
            ret = "Tvitter";
            break;
        case "gamecenter":
            ret = "gamecenter";
            break;
        case "https://hisense.tvstore.opera.com:84/api/tvapps/runapp/ap-news/?closeWindow=1":
            ret = "ap_news";
            break;
        case "https://hisense.tvstore.opera.com:84/api/tvapps/runapp/rockswap-adventures/?closeWindow=1":
            ret = "rock_swap";
            break;
        case "https://hisense.tvstore.opera.com:84/api/tvapps/runapp/ultimate-poker-2/?closeWindow=1":
            ret = "ultimatepoker";
            break;
        case "http://kidoz.tv/hs/hisense.html":
            ret = "Kidoz";
            break;
        case "https://4ka.husard.com/":
            ret = "four4know";
            break;
        case "http://beta.bigstar.tv/webapp/hisense/bigstar/":
            ret = "bigstar";
            break;
        case "http://klic2cdn0wzz17dt4f.s3.amazonaws.com/apps/common/prd/indexHisenseH7.html":
            ret = "Cinepolis";
            break;
        case "http://tv2hisense.clarovideo.net/FRONTEND/":
            ret = "clarovideo";
            break;
        case "https://www-hisense.mgo.com/":
            ret = "Fandangonow";
            break;
        case "http://ctv.pluto.tv/hisense/index.html":
            ret = "PlutoTV";
            break;
        case "qview":
            ret = "qview";
            break;
        default:
            ret = null;
            break;
    }
    return ret;
}
function getNotifyGroupInformation(dom) {
    var msgObj = [],item;
    try {
        var groupInfo = getNodesByKey("msgInfo", dom);
        if (null == groupInfo) return msgObj;
        for (var i = 0; i < groupInfo.length; i++) {
            item = {};
            item.msgType = null;
            item.msgContent = null;
            item.msgType = getTextByKey("msgType", groupInfo[i]);
            item.msgContent = getTextByKey("msgContent", groupInfo[i]);
            msgObj.push(item);
        }
    } catch (ex) {
        DBG_ERROR(ex.message);
    }
    return msgObj;
}

function getMsgFromServer(){
    var count = 200;
    try{
        var countTmp  = tv?Hisense.File.read("launcher/testNotify.txt", 1):10;
        if (countTmp && "none" != countTmp && "" != countTmp && 2 != countTmp && '2' != countTmp){
            DBG_INFO("countTmp:"+countTmp);
            count = parseInt(countTmp);
        }
    }catch(e){
        
    }
    DBG_INFO("Notify count:"+count);
    var path = "notify/msg/msg_index";
    var obj = tv?Hisense.File.read(path, 1):'/3rw_rw/appdata/notify/msg/msg_123,123\r\n/3rw_rw/appdata/notify/msg/msg_456,456';
    if (obj && "none" != obj && "" != obj && 2 != obj && '2' != obj){
//        DBG_INFO("getMsgFromServer:"+objToString(obj));
//        obj="/3rd_rw/notify/msg/msg_1502076173,1502076173\n";
        var array = obj.split("\n");
        var fileArray = [];
        if(array.length>1){
            for(var i =array.length-1;i>=0;i--){
                var data = {
                    path:"",
                    timeStamp:0
                };
                var arrayTmp = array[i].split(",");
                if(arrayTmp.length >1){
                    data.path = arrayTmp[0];
                    data.timeStamp = arrayTmp[1];
                    fileArray.push(data);
                }
            }
        }else{
            var data = {
                path:"",
                timeStamp:0
            };
            var arrayTmp = obj.split(",");
            data.path = arrayTmp[0];
            data.timeStamp = arrayTmp[1];
            fileArray.push(data);
        }
        var acrArray = [];
//        DBG_ERROR("fileArray:"+objToString(fileArray));
        for(var j=0;j<fileArray.length;j++){
            if(acrArray.length == count){
                break;
            }
            //if(fileArray[j].path.substring(1, 7) != "3rd_rw"){
            //   continue;
            //}
            var path = fileArray[j].path.substring(27,fileArray[j].path.length);
            var dom = readXMLDOM(path,1);
            if (null == dom) {
                return [];
            }
//            var dom = readXMLDOM("UI/data/templateConfig.xml",2);
            var ProgramData = [];
            ProgramData = getNotifyGroupInformation(dom);
            for(var n=0;n<ProgramData.length;n++){
                if(ProgramData[n].msgType ==1){
                   continue;
                }
                if(acrArray.length == count){
                    break;
                }
                var content = strToObject(ProgramData[n].msgContent);
                var item = {
                    "Name": " ",
                    "Detail": " ",
                    "Icon": "",
                    "date": "",
                    "data": "",
                    "cmd": ""
                };
                item.Name = content.title;
                item.cmd = LauncherCMD.SERVERMSG;
                item.data = content;
                item.Detail = " ";
                item.Icon = content.poster;
                item.date = fileArray[j].timeStamp;
                acrArray.push(item);
            }

        }
//        DBG_ERROR("fileArray:"+objToString(acrArray));
        return acrArray;
    }
    return [];
}
function getAcrNotification(){
//    DBG_ERROR("getNotificationApps:" + objToString(g_notificationApps));
    var acrArray = [];
    for(var i=0;i<g_acrNotification.length;i++){
        var item = {
            "Name": " ",
            "Detail": " ",
            "Icon": "",
            "date": "",
            "data": "",
            "cmd": ""
        };
        item.Name = g_acrNotification[i].data.content[0].title;
        item.cmd = LauncherCMD.ACRMSG;
        item.data = g_acrNotification[i].data.content[0];
        item.Detail = g_acrNotification[i].data.content[0].body;
        item.Detail = item.Detail.replace(/['\n']/g,' ');
        item.Icon = g_acrNotification[i].data.content[0].iconURL;
        item.date = g_acrNotification[i].date;
        acrArray.push(item);
    }

    return acrArray;
}

function clearAcrNotification(){
    g_acrNotification = [];
}
function sourceIdMap(name){
    var id = "0";
    switch (name){
        case "TV":
        case "tv":
            id = "0";
            break;
        case "AVS":
        case "avs":
            id = "1";
            break;
        case "COMPONENT":
        case "component":
            id = "2";
            break;
        case "VGA":
        case "vga":
            id = "3";
            break;
        case "HDMI1":
        case "hdmi1":
            id = "4";
            break;
        case "HDMI2":
        case "hdmi2":
            id = "5";
            break;
        case "HDMI3":
        case "hdmi3":
            id = "6";
            break;
        case "HDMI4":
        case "hdmi4":
            id = 7;
            break;
        case "SCART":
        case "scart":
            id = "8";
            break;
        default:
            id = "0";
            break;
    }
    return id;

}
function getNotificationData() {
    var Notifications = [];
    var msg = UIObserver.getNotifications();
//    DBG_INFO("getNotificationApps333!!!!:" + JSON.stringify(msg));
    var obj = Object.keys(msg);
    var sourceMap = {
        0: "tv",
        1: "av",
        2: "component",
        3: "vga",
        4: "hdmi1",
        5: "hdmi2",
        6: "hdmi3",
        7: "hdmi4",
        8: "scart"
    };
    var UsbOffline = [];
    var inputsData = initAllInputsData();
    for (var i = 0; i < obj.length; i++) {
        if (msg[obj[i]].length > 0) {
            if (msg[obj[i]][0].cmd == LauncherCMD.INPUT) {
                for (var j = 0; j < msg[obj[i]].length; j++) {
                    var array = msg[obj[i]][j].data[0].split("-");
                    if (array.length > 1) {
                        if (array[1] == 2) {
                            var item = {
                                "Name": " ",
                                "Detail": " ",
                                "Icon": "",
                                "date": "",
                                "data": "",
                                "id":"",
                                "cmd": ""
                            };
                            array[0] = sourceIdMap(array[0]);
                            item.Name = sourceMap[array[0]];
                            item.cmd = LauncherCMD.INPUT;
                            item.data = array[0];
                            item.Icon = "launcher/notification/ic_" + sourceMap[array[0]] + ".png";
                            item.date = msg[obj[i]][j].date;
                            for(var y=0;y<Notifications.length;y++){
                                if(Notifications[y].cmd == LauncherCMD.INPUT){
                                    if(Notifications[y].data == item.data){
                                        Notifications.splice(y, 1);
                                    }
                                }
                            }
                            if($.inArray(item.data,inputsData.signalSourceList) > -1){
                                Notifications.push(item);
                            }
                        }
                    }
                }
            } else if (msg[obj[i]][0].cmd == LauncherCMD.HIMEDIA) {
                for (var j = 0; j < msg[obj[i]].length; j++) {
                    if (msg[obj[i]][j].data[0][1].indexOf("FSL2") != -1 ) {
                        if(msg[obj[i]][j].data[0][0] == VolumeModelDefines.ENUM_SL2_TVAPI_VOLUME_ADDED
                            && msg[obj[i]][j].data[0][msg[obj[i]][j].data[0].length-1]!=0)
                        {
                            var item = {
                                "Name": " ",
                                "Detail": " ",
                                "Icon": "",
                                "date": "",
                                "data": "",
                                "id":"",
                                "cmd": ""
                            };
                            item.Name = "[LA0019]";
                            item.cmd = LauncherCMD.HIMEDIA;
                            item.data = "";
                            item.id = msg[obj[i]][j].data[0][1];
                            item.Detail = msg[obj[i]][j].data[0][2];
                            item.Icon = "launcher/notification/ic_media.png";
                            item.date = msg[obj[i]][j].date;
                            Notifications.push(item);
                        }else if(msg[obj[i]][j].data[0][0] == VolumeModelDefines.ENUM_SL2_TVAPI_VOLUME_REMOVED){
                            var item = {
                                "Name": " ",
                                "Detail": " ",
                                "Icon": "",
                                "date": "",
                                "data": "",
                                "id":"",
                                "cmd": ""
                            };
                            item.Name = "[LA0019]";
                            item.cmd = LauncherCMD.HIMEDIA;
                            item.data = "";
                            item.id = msg[obj[i]][j].data[0][1];
                            item.Detail = msg[obj[i]][j].data[0][2];
                            item.Icon = "launcher/notification/ic_media.png";
                            item.date = msg[obj[i]][j].date;
                            UsbOffline.push(item);
                        }
                    }

                }
            }
        }
    }
    try{
    for(var a=0;a<Notifications.length;a++){
        for(var b=0;b<UsbOffline.length;b++){
            if(Notifications[a].cmd == LauncherCMD.HIMEDIA){
                if(Notifications[a].id == UsbOffline[b].id){
                    if(UsbOffline[b].date >= Notifications[a].date){
                        Notifications.splice(a,1);
                        a--;
                        break;
                    }
                }
            }
        }
    }
    }catch(e){
            DBG_ERROR("" + e.message);
    }
//    if(tv && model.system.getNotificationSwitch()!=0){
        var launcherMsg = getNotificationApps();
        Notifications = Notifications.concat(launcherMsg);
//    }
    var picMsg = getPictureResource();
    if(picMsg!=null){
        Notifications = Notifications.concat(picMsg);
    }
    picMsg = getPictureResourceB();
    if(picMsg!=null){
        Notifications = Notifications.concat(picMsg);
    }
    if(g_acrNotification.length>0){
        var acrMsg = getAcrNotification();
        Notifications = Notifications.concat(acrMsg);
    }

    var serverMsg = getMsgFromServer();
    if(serverMsg.length >0){
        Notifications = Notifications.concat(serverMsg);
    }
//    DBG_INFO("getNotificationApps22222!!!!:" + JSON.stringify(Notifications));
    var tem = 0;
    try{
    for(var m=0;m<Notifications.length;m++){
        for(var n=0;n<Notifications.length-m-1;n++){
            if(Notifications[n].date<Notifications[n+1].date){
                tem = Notifications[n];
                Notifications[n] = Notifications[n+1];
                Notifications[n+1] = tem;
            }
        }
    }

//    Notifications = [{"Name":"Media","Detail":"MISS QIN","Icon":"launcher/notification/ic_media.png","date":1088651425,"data":"","cmd":2},{"Name":"Media","Detail":"MISS QIN","Icon":"launcher/notification/ic_media.png","date":1088651417,"data":"","cmd":2}];
    for(var x=0;x<Notifications.length-1;x++){
        if(Notifications[x].cmd == LauncherCMD.HIMEDIA && Notifications[x].cmd == Notifications[x+1].cmd){
            if(Notifications[x].Detail == Notifications[x+1].Detail){
                Notifications.splice(x+1, 1);
            }
        }
        if(Notifications[x].cmd == LauncherCMD.INPUT && Notifications[x].cmd == Notifications[x+1].cmd){
            if(Notifications[x].data == Notifications[x+1].data){
                Notifications.splice(x+1, 1);
            }
        }
    }
        var name= 0;
        for(var x=0;x<Notifications.length;x++){
            if(Notifications[x].cmd == LauncherCMD.HIMEDIA){
                if(Notifications[x].Detail ==""){
                    Notifications[x].Detail = "USB"+name;
                    name++;
                }
            }
        }
    }catch(e){
        DBG_ERROR("" + e.message);
    }
//    DBG_INFO("getNotificationApps22222!!!!:" + JSON.stringify(Notifications));
//    test();

    return Notifications;
}
//
function test(){
    DBG_INFO("test!!!!!!!!!!!!getNotificationApps22222!!!!:");
    var a =[1];
    var t = a[0];
    for(var i=0;i<a.length;i++){
        DBG_INFO("i:" + i);
        for(var j=0;j< a.length-i-1;j++){
            DBG_INFO("j:" + j);
            if(a[j]<a[j+1]){
                t=a[j];
                a[j] = a[j+1];
                a[j+1] = t;
            }
        }
//        DBG_INFO("test!!!!!!!!!!!!getNotificationApps22222!!!!:"+a[i]);
    }
    DBG_INFO("test!!!!!!!!!!!!getNotificationApps22222!!!!:"+JSON.stringify(a));
}
function getSystemLongTimeForNotification(){
    var utcTime = 0;
    utcTime = Math.ceil(Date.now() / GLOBAL.MILLIBASE);
    return utcTime;
}

function setNotificationTimeStamp(){
    g_notificationTimeStamp = getSystemLongTimeForNotification();
    DBG_INFO("setNotificationTimeStamp!!!!:" + g_notificationTimeStamp);
    var arr  = [];
    arr.push(g_notificationTimeStamp);
    writeFileToNative("launcher/notificationTimeStamp.txt", objToString(arr), 1);

}

function getNotificationTimeStamp(){
    var timeStamp = readFileFromNative("launcher/notificationTimeStamp.txt", 1);
    var notificationTimeStamp = 0;
    if(timeStamp!=null){
        notificationTimeStamp = parseInt(timeStamp[0]);
    }
    DBG_ERROR("getNotificationTimeStamp:" + notificationTimeStamp);
    return notificationTimeStamp;
}

function getNotificationDataNew() {
//    var temTimeStamp = 0;
    var newData = false;
//    var Notifications = [];
//    Notifications = getNotificationData();
//    if(Notifications.length>0){
//        temTimeStamp = Notifications[0].date;
//    }
//    for(var i=0;i<Notifications.length;i++){
//        if(Notifications[i].date>temTimeStamp){
//            temTimeStamp = Notifications[i].date;
//        }
//    }
    if(g_notificationCrtTimeStamp>g_notificationTimeStamp){
        newData = true;
    }
    DBG_INFO("getNotificationDataNew:" + newData);
    return newData;
}

var needUpdateFrom4kNow = false;
function installAppFrom4kNow(url){
    var insApps = readFileFromNative('launcher/installerApp.txt', 1);
    var unApps = readFileFromNative('launcher/uninstallApp.txt', 1);
    if (null == unApps) {
        unApps = [];
    }
    for (var i = 0; i < unApps.length; i++) {
        if (url == unApps[i]) {
            unApps.splice(i, 1);
            writeFileToNative('launcher/uninstallApp.txt', objToString(unApps), 1);
            break;
        }
    }
    if (null == insApps) {
        setLauncherInstallerAppByUser(url,true);
        needUpdateFrom4kNow = true;
        return;
    }
    for (var i = 0; i < insApps.length; i++) {
        if ($.inArray(url, insApps) > -1) {
            DBG_ALWAYS("setLauncherInstallerAppByUser");
            needUpdateFrom4kNow = false;
            return;
        }
    }
    needUpdateFrom4kNow = true;
    insApps.push(url);
    chanceAppVersion("install");
    writeFileToNative('launcher/installerApp.txt', objToString(insApps), 1);

}

function getAllAppDataForSetting() {
    var dd = [];
    var serviceUpdate = getLauncherServiceUpdateData();
    var currentCountryCode = tv ? ChangeCountryNumToCode(model.basicSetting.getTvsetLocation()) : "USA";
    var serviceCountryCode = serviceUpdate.countryCode;
    DBG_INFO('getAllAppDataForSetting current Country Code ' + currentCountryCode, DebugLevel.WARNING);
    getAlwaysDebugStatus();
    var mainJSON = null;
    var defaultData = (serviceCountryCode != currentCountryCode) || getAlwaysDefaultDataStatus() || serviceUpdate.timeStamp == 0;

    var launcherPath = defaultData ? "hisenseUI/data/" : "launcher/data/";
    if (defaultData) {
        DBG_ERROR('getAllAppDataForSetting service country not equal current country, use default data', DebugLevel.WARNING);
        mainJSON = loadLauncherDefaultData(launcherPath, currentCountryCode);
    }
    else {
        mainJSON = readXMLDOM(launcherPath + "CategoryIndex.xml", 1);
        if (null == mainJSON) {
            launcherPath = "hisenseUI/data/";
            DBG_ERROR('getAllAppDataForSetting get launcher data error, use default data', DebugLevel.ERROR);
            mainJSON = loadLauncherDefaultData(launcherPath, currentCountryCode);
            defaultData = true;
        }
    }

    if (null != mainJSON) {
        var footerJSON = readXMLDOM(launcherPath + getCategoryListPath(mainJSON), defaultData ? 2 : 1);
        dd = parseLauncherCategoryListDataForSetting(footerJSON, defaultData, launcherPath);
    }
    if(dd == null){
        launcherPath = "hisenseUI/data/";
        DBG_ERROR('no all app data ,use default data');
        mainJSON = loadLauncherDefaultData(launcherPath, currentCountryCode);
        defaultData = true;
        if (null != mainJSON) {
            var footerJSON = readXMLDOM(launcherPath + getCategoryListPath(mainJSON), defaultData ? 2 : 1);
            dd = parseLauncherCategoryListDataForSetting(footerJSON, defaultData, launcherPath);
        }
    }
    DBG_INFO("getAllAppDataForSetting return data:" + objToString(dd));
    return dd;
}

function parseLauncherCategoryListDataForSetting(footer, defaultData, launcherPath) {
    var containerData = [];
    if (null == footer) {
        DBG_ERROR("footer json is null");
        return null;
    }
    var delData = getLauncherDeleteAppByUser();
    var footerTmp = getNodesByKey(CategoryKey.INFO, footer);
    for (var i = 0; i < footerTmp.length; i++) {
        var contentItem = {};

        contentItem.Name = getItemsByLanguage(getNodesByKey(CategoryKey.CATEGORYNAME, footerTmp[i]), "name", defaultData);
        contentItem.Icon = getItemsByLanguage(getNodesByKey(CategoryKey.CATEGORYICON, footerTmp[i]), 'iconUrl', defaultData);
        contentItem.Order = getTextByKey(CategoryKey.ORDER, footerTmp[i]);
        contentItem.tagType = getTextByKey(CategoryKey.TAGTYPE, footerTmp[i]);

        var contentData = {};
        contentData.tagType = contentItem.tagType;
        contentData.txts = [];
        contentData.imgs = [];
        contentData.urls = [];
        contentData.urlTypes = [];
        contentData.storeTypes = [];
        contentData.canRemoves = [];
        contentData.canMoves = [];
        contentData.Installer = [];
        contentData.Locked = [];
        contentData.from = [];
        contentData.cmd = -1;
        if (contentItem.tagType == LauncherTagType.LIVETV) {
            contentItem.data = contentData;
        } else {
            contentItem.data = parseLauncherCategoryContentData(getTextByKey(CategoryKey.CATEGORYURL, footerTmp[i]), defaultData, launcherPath);
            if(contentItem.data == null){
                return null;
            }
            if (contentItem.tagType == LauncherTagType.AllAPP) {
                for (var m = 0; m < delData.length; m++) {
                    var idx = $.inArray(delData[m], contentItem.data.urls);
                    if (idx > -1) {
                        DBG_ALWAYS("generateDataFunction:delete all:" + delData[m] + "," + delData.length);
                        contentItem.data.imgs.splice(idx, 1);
                        contentItem.data.txts.splice(idx, 1);
                        contentItem.data.urls.splice(idx, 1);
                        contentItem.data.urlTypes.splice(idx, 1);
                        contentItem.data.canRemoves.splice(idx, 1);
                        contentItem.data.canMoves.splice(idx, 1);
                        contentItem.data.Installer.splice(idx, 1);
                        contentItem.data.Locked.splice(idx, 1);
                        contentItem.data.from.splice(idx, 1);
                        contentItem.data.storeTypes.splice(idx, 1);
                    }
                }
                var configAppNum = contentItem.data.imgs.length;
                var addApps = getAddAppFromOpera();
                DBG_ALWAYS("VIDAALiteInitLauncherAppPageData:add app number:" + addApps.length);
                for (var n = 0; n < addApps.length; n++) {
                    var idx = $.inArray(addApps[n].appUrl, contentItem.data.urls);
                    if (idx > -1) {
                        continue;
                    }
                    contentItem.data.imgs[configAppNum] = addApps[n].Image;
                    contentItem.data.txts[configAppNum] = addApps[n].appName;
                    contentItem.data.urls[configAppNum] = addApps[n].appUrl;
                    contentItem.data.urlTypes[configAppNum] = addApps[n].appUrlType;
                    contentItem.data.canRemoves[configAppNum] = addApps[n].canRemove;
                    contentItem.data.canMoves[configAppNum] = addApps[n].canMove;
                    contentItem.data.Installer[configAppNum] = addApps[n].Installer;
                    contentItem.data.Locked[configAppNum] = addApps[n].Locked;
                    contentItem.data.from[configAppNum] = addApps[n].from;
                    contentItem.data.storeTypes[configAppNum] = addApps[n].storeType;
                    configAppNum = configAppNum+1;
                }

            }
        }

        if (contentItem.data != null && contentItem.tagType!=LauncherTagType.SCREENPROTECT) {
            containerData.push(contentItem);
        }
    }
    allAppsWriteToFileForUse(containerData);
    addDataForSettingUse();
    return containerData;
}

function addDataForSettingUse() {

    var settingUse = [],
        presetApps = readFileFromNative("launcher/preset.txt", 1);

    if (null != presetApps) {
        $.each(presetApps.AppInfo, function(k,v) {
            if(v.URL == "netflix") {
                settingUse.push(v.URL);
            }
            else if("vudu" == v.URL
                || "vudu_movie" == v.URL) {
                settingUse.push("vudu");
            }
        });
    }
    writeFileToNative('launcher/settingappinfo.txt', objToString(settingUse), 1);
}
function getAppUrlByName(name){
    var url = null;
    var allAppsData = null;
    var currentData = getLauncherData();
    for (var i = 0; i < currentData.length; i++) {
        if (currentData[i].cmd == LauncherCMD.ALLAPP) {
            allAppsData = currentData[i].data;
            break;
        }
    }
    var appName = name.toLowerCase().replace(" ", "");
    if(allAppsData != null){
        for (var i = 0; i < allAppsData.imgs.length; i++) {
            var tmpName = allAppsData.txts[i].toLowerCase().replace(" ", "");
            if(appName == tmpName){
                url = allAppsData.urls[i];
                break;
            }
            if(allAppsData.urls[i].indexOf(appName)>-1){
                url = allAppsData.urls[i];
                break;
            }
        }
    }
    return url;

}