DBG_INFO("UI.js start " + debugRunTime());
var UI = {
    frontStage : null,
    moduleBuilder : {},
    currKey: null,
    currKeyValue : null,
    currKeyCode: 0,
    time : 0,
    keyState : null,
    keyRepeatTime : 0,
    focus : null,
    keyActive : true,
    noLabel : false,
    guiService : null,
    currApp : null,
    resLib : [],
    isSoftKeyBoard : false,
    guiKeyListener : null,
    guiAppEventMessageListener : null,
    softKeyboard : null,
    base : null,
    ease : createjs.Ease,
    window_bg : null,
    item_bg : null,
    btn_normal_bg:null,
    back_bg :null,
    list_bg: null,
    disable_bg : null,
    input_shp_bg : null,
    setting_shp_bg : null,
    keyListener : null,
    lockCntr: 0,
    lockTimer: 0,
    existSubModules: [],
    fteMenuTimeout : null,
    settingMenuTimeout : null,
    liveTVMenuTimeout : null,
    LauncherMenuTimeout : null,
    MediaMenuTimeout : null,
    MediaTimeout : null,
    eposMenuTimeout : null,
    initFinishFlag : false,
    rememberKey : null,
    ttsTimeout : null,
    ttsUtterance:null,
    eatKey : false,
    funcQueue : [],
    inPopChain : false,
    currGhostModules : [],
    isTextRunning : false,
    runningText : null,
    sprites : [],
    prevSubModule:"",
    createModuleId : "",
    memc : 0,
    localDimming : 0,
    destroyManager : {},
    templateManager : [],
    subModuleManager : {},
    wait:0,
    ttsCancel:true,
    isLoadingModule:false,
    preloadAppControlFinish:false,
    osdFlag : 0,
    ttsReg : new RegExp("[\\s~·`!！@#￥$%^……&*（()）【\\[\\]】｛{}｝\\|、\\\\；;：:‘“”\"，,《<。》>、/？?]"),
    errorKeyNum : 0

};
var UIObserver = new MessagePool();
function getMessageName(messageName){
    for (mName in UIObserver.MESSAGE_NAME) {
        if (messageName == UIObserver.MESSAGE_NAME[mName]) {
            return mName;
        }
    }
}
UI.init = function () {
    DBG_INFO("UI.init start "+ debugRunTime());
    DBG_ERROR("Start init UI!");
    UI.initStage();
    GLOBAL.APP_ENABLE_START_FLAG = false;
    GLOBAL.UI_LOADING_TIMER = setTimeout(function(){
        DBG_ERROR("GLOBAL.UI_LOADING_TIMER timeout,enable netflix start");
        GLOBAL.APP_ENABLE_START_FLAG = true;
    },28000);
    UI.initGuiService();
    UI.initTTSUtterance();
    UI.initTVModel();
    UI.initTTSLanguagePowerOn();
    UI.changeLanguage(GLOBAL.CURRENT_LANGUAGE);
    UI.initKey();
    UI.initBaseModule();
    UI.initEvent();
    UI.initTV();
    UI.initSoftKeyBoard();
    UI.initSprites();
    UI.startStage();
    GLOBAL.HICONTRAST=tv?model.system.getMenuHighLightControl():0;//omg  high contrast init
    if (GLOBAL.RTL) {
        UI.renderer.view.style.webkitTransform="scale(-1,1)";
    }
    DBG_INFO("UI.init end "+ debugRunTime());
};

UI.showTempInfoBar = function() {
    //var info;
    //var tempChannel;
    //if (Config.tv) {
    //    info = model.tvservice.getMainPlay();
    //    tempChannel = {
    //        number: info[TvserviceModel.PLAY_FIELD_NO],
    //        name: info[TvserviceModel.PLAY_SERVICE_NAME]
    //    };
    //}
    //document.getElementById("infoName").innerText = Config.tv ? tempChannel.name : "channelName";
    //document.getElementById("infoNumber").innerText = Config.tv ? tempChannel.number : "11111";
    //document.getElementById("tempInfoBar").style.visibility = "visible";
};

UI.initGuiService = function () {
    DBG_INFO("UI.initGuiService start "+ debugRunTime());
    if(Config.tv){
        UI.guiService = guijs.createService();
    }
    DBG_INFO("UI.initGuiService end "+ debugRunTime());
};

UI.initTV = function () {
    DBG_INFO("UI.initTV start "+ debugRunTime());
    try {
        if (Config.tv) {
            GLOBAL.APP_POWER_ON = getPowerOnType();
            GLOBAL.FACTORY = parseInt(model.hisfactory.getStateOpen());
            GLOBAL.TTS = isTtsPlay();
            GLOBAL.MASTER_KEY=model.parentlock.getFallbackPin();
            DBG_ERROR("UI.initTV:"+GLOBAL.FACTORY);
            DBG_INFO("FALLBACK_PIN"+GLOBAL.MASTER_KEY);

            if (GLOBAL.APP_POWER_ON == 0 && getWizardSetFlag() == 0) {
                model.system.stopAnimation(0);
            }
            LGReport.getDeviceMsg();
        }
        UI.preloadVoiceChrome();
        UI.preloadAppControl();
        UI.initLiveTV();

    } catch (ex) {
        DBG_ERROR(ex.stack);
    }
    DBG_INFO("UI.initTV end "+ debugRunTime());
};
var dlnaLoadFlag = "";
UI.delayLoad = function() {
    DBG_INFO("UI.delayLoad start "+ debugRunTime());
    DBG_ERROR("try to delay load js....");
    if (!UI.delayLoaded) {
        UI.delayLoaded = true;
        setTimeout(function(){
           // if (Config.tv) {
                $LAB.script("lib/launcherDataInterface.js")
                    .script("lib/parseXML.js")
                    //.script("lib/inputsInterface.js")
                    .script("pub/USOperation/CacheAdapter.js")
                    .script("pub/USOperation/HttpAdapter.js")
                    .script("pub/USOperation/web-storage-cache.js")
                    .script("pub/USOperation/USOUtil.js")
                    .script("pub/USOperation/fourknowUtil.js")
                    .script("pub/USOperation/DataManager.js")
                    .script("pub/USOperation/html5sql.js")
                    .script("pub/HisProductConfig.js")
                    .script("module/dlna/dlnaConfig.js")
                    .script("module/EPOS/eposConfig.js")
                    .script("lib/mqttws31.js")
                    .script("lib/remoteapp_tv_api.js")
                    .script("module/remoter/remoter.js")
                    .script("lib/avsbase64.js")
                    .script("lib/avswebsocket.js")
                    .script("pub/AVSClient.js")
                    .wait(function() {
                        if (Config.tv) {
                            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_DLNA_PIC_RUNNING_CHANGED, Dlna.onPictureRunningchanged);
                            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_DLNA_RENDER_CHANGED, Dlna.onMpCtrlRenderchanged);
                            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_DLNA_METADATA_CHANGED, Dlna.onMetadataChanged);
                            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_DLNA_DMRMUTE_CHANGED, Dlna.onMpCtrlDMRMutechanged);
                            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_DLNA_DMRVOLUME_CHANGED, Dlna.onMpCtrlDMRVolumechanged);
                            GLOBAL.SETTING_TIMEOUT_DELAY=parseInt(model.basicSetting.getMenuDelayDisappear())*1000;
                        }
                        // model.softupdate.StartSearch(100);
//                            model.network.getEnumNetworkConfig();
//                            model.network.TestStart();
                        initRemoter();
                        loadB2BModule();
                        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.KEY_REPORT,LGReport.KeyReport);
                        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.SYSTEM_STANDBY_FLAG,onStandbyTipChanged);
                        GLOBAL.CEC_DEVICE_EXIST = parseInt(model.sound.getArcDevExist());
                        UI.preloadLauncher();
                        if("NA" != GLOBAL.CURRENT_AREA) {
                            loadCss("module/EPG/epgDetail.css");
                        }
                        loadCss("module/setting/settingAbtDis.css");
                        loadCss("module/FTE/fte_dis_info.css");
                        loadCss("module/launcher/pictureResourceA.css");
                        loadCss("module/Alexa/listContentDiv.css");
                        loadCss("module/Alexa/bodyTemplate1Div.css");
                        if (AVSClient) {
                            AVSClient.setting.syncVoiceSupportType()
                        }
                        DBG_ERROR("UI.delayLoad end   load file end!!!!!!!!!!!!!!!!!!!!!! ");
                        var ret = readFileFromNative("launcher/settingappinfo.txt", 1);
                        if(null == ret)
                        {
                            getAllAppDataForSetting();
                        }
                    });
           // }
        }, 500);
    }
    var iqqiDiv = document.createElement("div");
    iqqiDiv.setAttribute("id","softKeyboard");
    iqqiDiv.setAttribute("class","iqqi_body_normal");
    iqqiDiv.setAttribute("style","z-index: 1;font-family: myFirstFont;");

    var iqqi_log_area_presto_720P_div = document.createElement("div");
    iqqi_log_area_presto_720P_div.setAttribute("id","iqqi_log_area_presto_720P");
    iqqi_log_area_presto_720P_div.setAttribute("class","iqqi_log_area_presto_720P_normal");
    iqqi_log_area_presto_720P_div.setAttribute("style","display: none");
    iqqiDiv.appendChild(iqqi_log_area_presto_720P_div);

    var iqqi_log_area_presto_1080P_div = document.createElement("div");
    iqqi_log_area_presto_1080P_div.setAttribute("id","iqqi_log_area_presto_1080P");
    iqqi_log_area_presto_1080P_div.setAttribute("class","iqqi_log_area_presto_1080P_normal");
    iqqi_log_area_presto_1080P_div.setAttribute("style","display: none");
    iqqiDiv.appendChild(iqqi_log_area_presto_1080P_div);

    var my_Myanmar_Font_div = document.createElement("div");
    my_Myanmar_Font_div.setAttribute("style","display: none; font-family: my_Myanmar_Font");
    iqqiDiv.appendChild(my_Myanmar_Font_div);

    var my_Hindi_Font_div = document.createElement("div");
    my_Hindi_Font_div.setAttribute("style","display: none; font-family: my_Hindi_Font");
    iqqiDiv.appendChild(my_Hindi_Font_div);

    var my_Thai_Font_div = document.createElement("div");
    my_Thai_Font_div.setAttribute("style","display: none; font-family: my_Thai_Font");
    iqqiDiv.appendChild(my_Thai_Font_div);
    document.body.appendChild(iqqiDiv);


    DBG_INFO("UI.delayLoad end "+ debugRunTime());
};

UI.initLiveTV = function (cover) {
    DBG_INFO("UI.initLiveTV start " + debugRunTime());
    if (window["liveTV"]) {
        window["liveTV"].initLiveTV(false);
        window["liveTV"].initChannelList(true);
        openLiveTVModule();
        if (GLOBAL.CURRENT_SVR_MSG == SvrMsg.AUDIO_PROG) {
            window["liveTV"].showInfoBar();
        }
        showNetworkToastNeverSet();
        return;
    }

    if(GLOBAL.UI_BRAND == "his" || GLOBAL.UI_BRAND == "Hisense" || GLOBAL.UI_BRAND == "tos"){
        GLOBAL.LAUNCHER_BRAND = "his";
    }
    else if(GLOBAL.UI_BRAND == "Sharp"){
        GLOBAL.LAUNCHER_BRAND = "shp";
    }
    else{
        GLOBAL.LAUNCHER_BRAND = "shp";
    }

    UI.delayLoad();

    window['liveTV'] = new PIXI.Container();
    UI.moduleBuilder['liveTV'] = {};
    UI.destroyManager['liveTV'] = [];
    UI.destroyManager['Ghost'] = [];
    cover = Config.tv ? (getWizardSetFlag() != 0) : false;
    DBG_ERROR("cover is " + cover);

    $LAB.script("module/liveTV.js")
        .script("module/liveTV/liveTVCtrl.js")
        .wait(function() {
                UI.moduleBuilder['liveTV']['liveTVCtrl']();
                window['liveTV']['liveTVCtrl'].onFirstPush();
                if (1 == GLOBAL.FACTORY) {
                DBG_ERROR("Factory Mode enter");
                if (Config.tv && UI.rememberKey) {
                    UI.endLoading();
                }
                //document.body.removeChild(document.getElementById("powerOnLayer"));
                setTimeout(function(){
                    if(GLOBAL.NEED_START_OPERA4X){
                        DBG_ERROR("NEED_START_OPERA4X");
                        sendAM(":am,am,:start=opera4x","opera4x","start","");
                        GLOBAL.NEED_START_OPERA4X = false;
                    }
                },2000);
                setTimeout(function(){
                    modeljs.sendAppMessage("apm",'{"type":"AppStatus","source":"launcher","status":"loaded"}');
                },6000);
            }
            else if (cover) {
                DBG_ERROR("FTE enter");
                if (Config.tv && UI.rememberKey) {
                    UI.endLoading();
                }
                UI.pushModule("FTE");
                UI.registerKeyCodes(null);
                UI.setKeyGroup(7);
                UI.unlockAllKeys("init");
                //document.body.removeChild(document.getElementById("powerOnLayer"));
                setTimeout(function(){
                    if(GLOBAL.NEED_START_OPERA4X){
                        DBG_ERROR("NEED_START_OPERA4X");
                        sendAM(":am,am,:start=opera4x","opera4x","start","");
                        GLOBAL.NEED_START_OPERA4X = false;
                    }
                },2000);
                setTimeout(function(){
                    modeljs.sendAppMessage("apm",'{"type":"AppStatus","source":"launcher","status":"loaded"}');
                },6000);
            }
            else if (GLOBAL.APP_POWER_ON) {
                DBG_ERROR("APP enter");
                if (Config.tv && UI.rememberKey) {
                    UI.endLoading();
                }
//                document.body.removeChild(document.getElementById("powerOnLayer"));
                modeljs.sendAppMessage("apm",'{"type":"AppStatus","source":"launcher","status":"loaded"}');
                UI.registerKeyCodes(null);
                UI.setKeyGroup(7);
                UI.unlockAllKeys("init");
            }
            else if (model.system.getUserMode() == 1 || model.system.getUserMode() == 2) {
                UI.pushSubModule("liveTV", "liveTVCtrl");
                if (Config.tv && UI.rememberKey) {
                    UI.endLoading();
                }
                setTimeout(function(){
                    if (UI.getCurrModule().name == 'liveTV') {
                        DBG_ERROR("Epos Count Down enter");
                        UI.clearEposMenuTimeout();
                        UI.pushSubModule("EposMessage","startEposCountDown",true);
                    }
                }, 5000);
                //document.body.removeChild(document.getElementById("powerOnLayer"));
            }
            else {
                DBG_ERROR("LiveTV enter");
                UI.pushSubModule("liveTV", "liveTVCtrl");
            }

            UI.initFinished();
        });
    DBG_INFO("UI.initLiveTV end " + debugRunTime());
};

UI.preloadVoiceChrome = function () {
    UI.moduleBuilder['Alexa'] = {};
    UI.subModuleManager['Alexa'] = [];
    UI.destroyManager['Alexa'] = [];
    $LAB.script("module/Alexa/voiceService.js")
        .wait(function(){
            UI.moduleBuilder['Alexa']['voiceService']();
            UI.base.ghostModule['voiceService'] = UI.getCurrModule()['voiceService'];
            delete UI.getCurrModule()['voiceService'];
            // UI.base.ghostModule.appControl.initAppControl();
            // UI.base.ghostModule.appControl.checkAppStateWhenPowerOn();
        })
};

UI.preloadAppControl = function(){
    UI.moduleBuilder['APP'] = {};
    UI.subModuleManager['APP'] = [];
    UI.destroyManager['APP'] = [];
    $LAB.script("module/APP/appControl.js")
        .wait(function(){
            UI.moduleBuilder['APP']['appControl']();
            UI.base.ghostModule['appControl'] = UI.getCurrModule()['appControl'];
            delete UI.getCurrModule()['appControl'];
            UI.base.ghostModule.appControl.initAppControl();
            UI.base.ghostModule.appControl.checkAppStateWhenPowerOn();
            UI.preloadAppControlFinish = true;
        })
};

UI.preloadLauncher = function(){
    UI.moduleBuilder['launcher'] = {};
    UI.subModuleManager['launcher'] = [];
    UI.destroyManager['launcher'] = [];
    window['launcher'] = new PIXI.Container();
    $LAB.script("module/launcher.js")
        .script("module/launcher/statusBar.js")
        .script("module/launcher/helpInfo.js")
        .script("module/launcher/mainTiles.js")
        .wait(function(){
            UI.launcherPreloaded = true;

            PIXI.loader.add([
                themeDir+'launcher/inputs/'+GLOBAL.LAUNCHER_BRAND+'/la_ic_notifications_no.png',
                themeDir+'launcher/inputs/'+GLOBAL.LAUNCHER_BRAND+'/apps.png',
                themeDir+'launcher/inputs/'+GLOBAL.LAUNCHER_BRAND+'/livetv.png',
                themeDir+'launcher/inputs/'+GLOBAL.LAUNCHER_BRAND+'/inputs.png',
                themeDir+'launcher/inputs/'+GLOBAL.LAUNCHER_BRAND+'/himedia.png',
                themeDir+'launcher/inputs/'+GLOBAL.LAUNCHER_BRAND+'/settings.png',
                themeDir+'launcher/inputs/'+GLOBAL.LAUNCHER_BRAND+'/la_ic_edit.png'
            ]);

            PIXI.loader.load();

        });
    Util.readJson("module/launcher/statusBar.json");
    Util.readJson("module/launcher/helpInfo.json");
    Util.readJson("module/launcher/mainTiles.json");
};

UI.initFinished = function() {
    UIObserver.registerNotify();
    UIObserver.publishMessage(UIObserver.MESSAGE_NAME.REGISTER_NOTIFY_FINISH, 1);
    UI.initFinishFlag = true;
    setTimeout(function(){
        if (Config.tv) {
            Hisense.File.write("InitFinished", "1", 0);
            try{
                model.system.setGuiLoopFinished(1);
            }catch(ex){
                DBG_ERROR(ex.message);
            }
            var dev = model.sound.getMainVolumeDev();
            DBG_ERROR("dev is " + dev);
            UIObserver.publishMessage(UIObserver.MESSAGE_NAME.VOLUME_DEV_CHANGED, dev);
        }
    }, 3000);
    DBG_ERROR("!!!!!!!!!!!!!start Acr!!!!!!!!!!");
    if(acrflag){
        initInputSourceForACR();
        initAcrServer();
    }
    showNetworkToastNeverSet();
    sysUpgradeInit();
    DBG_ERROR("UI first time init finished!!!");
};

UI.initSoftKeyBoard = function() {
    UI.softKeyboard = document.getElementById("softKeyboard");
    UI.softKeyboard.y = 500;
};

UI.createFocusRing = function() {
    var baseTexture = PIXI.BaseTexture.fromImage(themeDir + "ring.png");
    baseTexture.common = true;
    var texture = new PIXI.Texture(baseTexture);
    var slicePanel = new PIXI.mesh.NineSlicePlane(texture, 32, 32, 32, 32);
    UI.base.cursor = slicePanel;
    UI.base.cursor.r = 24;
    UI.base.cursor.name = "cursor";
    UI.base.cursor.alpha = 0;
};

UI.initBaseModule = function () {
    DBG_INFO("UI.initBaseModule start "+ debugRunTime());

    UI.base = new PIXI.Container();
    UI.base.name = "base";
    UI.frontStage.addChild(UI.base);
    UI.destroyManager['base'] = [];
    if (Config.debug && !Config.tv) {
        UI.initDebugPanel();
    }

    UI.base.ghostModule = UI.base.addChild(new PIXI.Container());
    UI.base.ghostModule.name = "ghost";
    UI.pushGhostModule("volumeBar", "volumeCtrl");
    UI.pushGhostModule("notificationToast", "notificationToast");
    UI.pushGhostModule("AcrNotificationToast", "AcrNotificationToast");

    UI.createLoading();
    // UI.createSimpleTip();

    var blank = UI.base.addChild(new PIXI.Container());
    blank.name = "blank";
    blank.position.x = -10;
    blank.position.y = -10;
    blank.currFocus = blank;
    UI.base.blank = blank;
    blank.visible = false;
    UI.base.addChild(blank);

    UI.createFocusRing();
    UI.base.blank.addChild(UI.base.cursor);
    $LAB.script("module/base.js");
    DBG_INFO("UI.initBaseModule end "+ debugRunTime());
};

UI.createLoading = function() {
    var baseTexture = PIXI.BaseTexture.fromImage(themeDir + "loading.png");
    baseTexture.common = true;
    var texture = new PIXI.Texture(baseTexture);
    UI.base.loading = new PIXI.Sprite(texture);
    UI.base.loading.number = 0;
    UI.base.loading.anchor.x = 0.5;
    UI.base.loading.anchor.y = 0.5;
    UI.base.loading.x = 960;
    UI.base.loading.y = 540;
    UI.base.loading.name = "loading";
    UI.base.addChild(UI.base.loading);
    UI.base.loading.alpha = 0;
};

UI.destroy = function(displayObject, deep) {
    displayObject.destroy(deep);
};

UI.createSimpleTip = function() {
    var container = new PIXI.Container();
    var baseTexture = PIXI.BaseTexture.fromImage(themeDir + "toast/Toast_bg03.png");
    var texture = new PIXI.Texture(baseTexture);
    var background = new PIXI.Sprite(texture);
    var text = new PIXI.Text("",
        {
            fontFamily : 'SourceSansPro-Light',
            fontSize: 36,
            fill : 0x363E4D,
            align : 'left'
        });
    text.style.wordWrap = true;
    text.style.wordWrapWidth = 810;
    text.style.lineHeight = 50;
    container.x = 556;
    container.y = 800;
    text.x = 10;
    container.addChild(background);
    container.addChild(text);
    UI.base.addChild(container);
    container.alpha=0;
    UI.base.settingTip=container;
};

UI.showSimpleTip=function (msg){
    // UI.base.settingTip.children[1].text = UI.setString(msg);
    // UI.base.settingTip.children[1].dirty = true;
    // UI.base.settingTip.children[1].updateText();
    // UI.calculateAlignRTL(UI.base.settingTip.children[1]);
    // UI.base.settingTip.children[1].texture._updateUvs();
    // UI.base.settingTip.children[1].x = 60;
    // UI.base.settingTip.children[1].y = 60;
    // UI.base.settingTip.alpha=1;
    // UI.base.settingTip.children[1].position.y = UI.base.settingTip.children[0].getBounds().height / 2;
    // UI.base.settingTip.children[1].pivot.y = UI.base.settingTip.children[1].getBounds().height / 2;
    // if(!!UI.base.settingTip.timer)
    // {
    //     clearTimeout(UI.base.settingTip.timer);
    //     UI.base.settingTip.timer=null;
    // }
    // UI.base.settingTip.timer=setTimeout(function(){
    //     UI.closeSimpleTip();
    // },5000)
    // UI.getTween(UI).wait(5000);
    GLOBAL.toast_msg = msg;
    UI.pushGhostModule("common", "commonToast");

};

UI.preloadSubModule = function(moduleId, subModuleId) {
    if (!UI.moduleBuilder[moduleId]) {
        UI.moduleBuilder[moduleId] = {};
        window[moduleId] = new PIXI.Container();
        $LAB.script("module/" + moduleId + ".js")
            .script("module/" + moduleId + "/" + subModuleId +".js");
        Util.readJson("module/" + moduleId + "/" + subModuleId +".json");
        if (!UI.subModuleManager[moduleId]) {
            UI.subModuleManager[moduleId] = [];
        }
        if (!UI.destroyManager[moduleId]) {
            UI.destroyManager[moduleId] = [];
        }
    }
};

UI.closeSimpleTip=function(){
    if( UI.base.settingTip.alpha!=0){
        UI.base.settingTip.alpha=0;
        UI.updateStage();
    }

    if(!!UI.base.settingTip.timer)
    {
        clearTimeout(UI.base.settingTip.timer);
        UI.base.settingTip.timer=null;
    }
};

UI.initSound = function () {
    //createjs.Sound.registerPlugins([createjs.HTMLAudioPlugin]);
    //UI.loader.installPlugin(createjs.Sound);
};

UI.preload = function () {


    //
    //
    //UI.loader.on("complete", UI.init, null, true);
    //UI.loader.loadManifest(Config.preloadResource, true, "");
};



UI.changeLanguage = function (type) {
    if (UI.base) {
        if (UI.isTextRunning) {
            UI.base.stopText();
        }
    }
    if(GLOBAL.UI_BRAND == "shp"){
        type = type + "_shp";
    }
    $LAB.setOptions({AllowDuplicates:true})
        .script("language/language_" + type +".js")
        .wait(function(){
            UIObserver.publishMessage(UIObserver.MESSAGE_NAME.LANGUAGE_CHANGUAGE_COMPLETE, true);
            if(type=="ara"||type=="per"||type=="hbr") {
                UI.switchRTL(true);
            } else {
                UI.switchRTL(false);
            }

            UI.setupLanguage(UI.frontStage);
            UI.refreshRTL(UI.frontStage);

            UI.setupLanguage(liveTV.liveTVCtrl);
            UI.refreshRTL(liveTV.liveTVCtrl);
        });
};

UI.refreshSubModuleLanguage = function(subModule) {
    UI.setupLanguage(subModule);
};
UI.initTTSUtterance = function(){
    //创建一个 SpeechSynthesisUtterance的实例
    UI.ttsUtterance = new SpeechSynthesisUtterance();
    //initTtsValueHandler();// remove according to @wangweipeng init conflict
    var langList=['eng','spa'];
    var index=getI32LangIdx();
    DBG_ALWAYS('index:'+index);
    GLOBAL.TTS_LANGUAGE = langList[index%2];
}
UI.initTTSLanguagePowerOn = function () {
    var type = GLOBAL.TTS_LANGUAGE
    if(GLOBAL.UI_BRAND == "shp"){
        type = type + "_shp";
    }
    $LAB.setOptions({AllowDuplicates:true})
        .script("language/language_tts_" + type +".js").wait(function () {
            UI.callTTS("[SE0341]",0);
        });
};
UI.initTTSLanguage = function () {
    var type = GLOBAL.TTS_LANGUAGE;
    if(GLOBAL.UI_BRAND == "shp"){
        type = type + "_shp";
    }
    $LAB.setOptions({AllowDuplicates:true})
        .script("language/language_tts_" + type +".js")
};

UI.setupLanguage = function (target) {
    if (!target) return;
    var padding = 0;
    if (GLOBAL.CURRENT_LANGUAGE == 'hin') {
        padding = 15;
    }
    for (var i = 0; i < target.children.length; i++) {
        var item = target.children[i];
        if (item.msgId) {
                if (item.children[0].style) item.children[0].style.padding = padding;
                UI.setText(item, item.msgId);
                item.children[0].updateText();
        }
        else if (item.selected) {
            if (item.children[0].style) {
                item.children[0].style.padding = padding;
                UI.setText(item, item.selected);
                item.children[0].updateText();
            }
        }
        else if (item.label) {
            if (item.label.msgId) {
                item.label.style.padding = padding;
                item.setLabel(item.label.msgId);
            }
            if (item.value.msgId) {
                item.value.style.padding = padding;
                item.setValue(item.value.msgId);
            }
        }
        else if (item.children) {
            UI.setupLanguage(item);
        }
    }
};

UI.switchRTL = function (flag) {
    if ((GLOBAL.RTL && flag) || ((!GLOBAL.RTL) && (!flag))) {
        return;
    }
    GLOBAL.RTL = flag ? true : false;
    if (Config.tv) {
        CONST.KEYCODE_MAP[guijs.SYSCMD_ARROW_LEFT] = GLOBAL.RTL ? CONST.KEY.VK_RIGHT : CONST.KEY.VK_LEFT;
        CONST.KEYCODE_MAP[guijs.SYSCMD_ARROW_RIGHT] = GLOBAL.RTL ? CONST.KEY.VK_LEFT : CONST.KEY.VK_RIGHT;
    } else {
        CONST.KEYVALUE_MAP[CONST.KEY.VK_LEFT] = GLOBAL.RTL ? "RIGHT" : "LEFT";
        CONST.KEYVALUE_MAP[CONST.KEY.VK_RIGHT] = GLOBAL.RTL ? "LEFT" : "RIGHT";
    }
    if (GLOBAL.RTL) {
        UI.renderer.view.style.webkitTransform="scale(-1,1)";
        UI.renderer.view.style.direction = "rtl";
    } else {
        UI.renderer.view.style.webkitTransform="scale(1,1)";
        UI.renderer.view.style.direction = "";
    }
};

UI.calculateAlignRTL = function(text) {
    if (text.style.align != "center") {
        if (GLOBAL.RTL) {
            if (text.lines == 1) {
                text.style.align = "left";
            } else if (text.lines > 1) {
                text.style.align = "right";
            }
        } else {
            text.style.align = text.originAlign;
        }
    }
};

UI.refreshRTL = function(target) {
    if (!target) {
        return;
    }
    for (var i = 0; i < target.children.length; i++) {
        var item = target.children[i];
        if (item.isText) {
            item.children[0].updateText();
            if (item.children[0].style.wordWrap) {
                UI.calculateAlignRTL(item.children[0]);
            }
            item.children[0].texture._updateUvs()
        }
        else if (item.isLabelValue) {
            item.label.updateText();
            item.label.texture._updateUvs();
            item.value.updateText();
            item.value.texture._updateUvs();
        }
        else if (item.leftArrow) {
            item.leftArrow.texture._updateUvs(true);
            item.rightArrow.texture._updateUvs(true);
        }
        else if (item.children[0] && item.children[0].texture) {
            if (item.doFlip) {
                item.children[0].texture._updateUvs(true);
            } else {
                item.children[0].texture._updateUvs();
            }
        }
        if (item.children && item.children[0]) {
            UI.refreshRTL(item);
        }
    }
};

UI.changeTheme = function (newDir) {
    var sourceList = [];
    UI.refreshSprite(newDir, sourceList);
    UI.refreshImage(UI.existSubModules, newDir, sourceList);
    if (sourceList.length == 0) {
        UI.updateStage();
    } else {
        loadImagesForGird(sourceList);
    }
    themeDir = newDir;
};

UI.refreshSprite = function(newDir, sourceList) {
    for (var i = 0; i < UI.sprites.length; i++) {
        var sprite = UI.sprites[i];
        var oldUrl = sprite._images[0].src;
        var newUrl = oldUrl.replace(themeDir, newDir);
        if (imageLib[newUrl]) {
            sprite._images[0] = imageLib[newUrl];
            for (var j = 0; j < sprite._frames.length; j++) {
                sprite._frames[j].image = imageLib[newUrl];
            }
        } else {
            var img = new Image();
            img.dataUrl = newUrl;
            sprite._images[0] = img;
            for (var j = 0; j < sprite._frames.length; j++) {
                sprite._frames[j].image = img;
            }
            sourceList.push(img);
            imageLib[newUrl] = img;
        }
    }
};

UI.refreshImage = function (target, newDir, sourceList) {
    for (var i = 0; i < target.length; i++) {
        var item = target[i];
        if (item.children) {
            UI.refreshImage(item.children, newDir, sourceList);
        } else if (item.image) {
            var oldUrl = item.image.src;
            var newUrl = oldUrl.replace(themeDir, newDir);
            if (imageLib[newUrl]) {
                item.image = imageLib[newUrl];
            } else {
                var img = new Image();
                img.dataUrl = newUrl;
                item.image = img;
                sourceList.push(img);
                imageLib[newUrl] = img;
            }
        }
    }
};

UI.initStage = function () {
    DBG_INFO("UI.initStage start "+ debugRunTime());
    UI.renderer = new PIXI.WebGLRenderer(1920, 1080, {
        transparent:true,
        antialias: true,
        preserveDrawingBuffer: false
        //forceFXAA:true,
        //roundPixels:true
    });
    UI.renderer.view.style.position = "absolute";
    UI.renderer.view.style.display = "block";
    document.getElementById('canvasLayer').appendChild(UI.renderer.view);
    UI.frontStage = new PIXI.Container();
    if (!Config.tv) {
        UI.renderer.view.style.backgroundColor = 0x0000FF;
        UI.renderer.view.style.transparent = false;
    }

    DBG_INFO("UI.initStage end "+ debugRunTime());
};

UI.initSprites = function () {
    DBG_INFO("UI.initSprites start "+ debugRunTime());
    UI.createSprite("liveTV_bg", themeDir + "liveTV/infobar/ic_info_left.png", 31, 31, 31, 31);
    UI.createSprite("bg_tranparent", themeDir + "tranparent.png", 1, 1, 1, 1);
    UI.createSprite("window_bg", themeDir + "setting/dialog_bg_max.png", 2, 2, 2, 5);
    UI.createSprite("back_bg", themeDir + "launcher/launcher_panelback.png", 2, 2, 2, 2);
    UI.createSprite("item_bg", themeDir + "setting/dialog_list_btn_normal_max.png", 2, 2, 2, 3);
    UI.createSprite("btn_normal_bg", themeDir + "setting/setting_btn_normal_max.png", 2, 2, 2, 3);
    UI.createSprite("disable_bg", themeDir + "setting/setting_btn_disable_max.png", 2, 2, 2, 3);
    UI.createSprite("list_bg", themeDir + "FTE/fte_lst_bg.png", 1, 1, 1, 1);
    UI.createSprite("chlist_bg", themeDir + "liveTV/channellist/channel_item.png", 2, 2, 2, 2);
    UI.createSprite("bg_overlay", themeDir + "launcher/bg_overlay_edit_mode.png", 1, 1, 1, 1);
    UI.createSprite("no_channel_bg", themeDir + "liveTV/initiate/btn_normal.png", 1, 1, 1, 2);
    UI.createSprite("bg_overlayfor25", themeDir + "launcher/bg_overlay_launcher_u2.5.png", 1, 1, 1, 1);
    UI.createSprite("setting_bg", themeDir + "setting/sheet_bg2.png", 640, 64, 64, 64);
    UI.createSprite("input_shp_bg", themeDir + "launcher/inputs/shp/la_ic_bgimg.png", 384, 282);
    UI.createSprite("bg_overlayforTOS", themeDir + "launcher/bgTOS.png", 1, 1, 1, 1);
    UI.createSprite("setting_shp_bg", themeDir + "setting/shp/la_sec_tile_392x320.png", 392, 288);
    DBG_INFO("UI.initSprites end "+ debugRunTime());
};

UI.createSprite = function(id, url, leftWidth, topHeight, rightWidth, bottomHeight, offsetX, offsetY) {
    if (!offsetX)offsetX=0;
    if (!offsetY)offsetY=0;
    UI[id] = new PIXI.BaseTexture.fromImage(url);
    UI[id].leftWidth = leftWidth;
    UI[id].topHeight = topHeight;
    UI[id].rightWidth = rightWidth;
    UI[id].bottomHeight = bottomHeight;
    UI[id].offsetX = offsetX;
    UI[id].offsetY = offsetY;
    UI[id].common = true;
};

UI.startStage = function () {
    createjs.Ticker.timingMode = createjs.Ticker.RAF_SYNCHED;
    createjs.Ticker.framerate = 30;
};

UI.initDebugPanel = function () {
    var panel = new PIXI.Graphics();
    panel.name = "debug";
    panel.beginFill(0x88DD88, 0.8).drawRect(0, 0, 300, 250).endFill();
    UI.base.addChild(panel);
    UI.base.panel = panel;

    var fps = new PIXI.Text("0",
        {
            fontFamily : 'SourceSansPro-Light',
            fontSize: 24,
            fill : 0xff0000,
            align : 'left'
        });
    fps.name = "fps";
    fps.position.y = 10;

    var perFrame = new PIXI.Text("0",
        {
            fontFamily : 'SourceSansPro-Light',
            fontSize: 24,
            fill : 0xff0000,
            align : 'left'
        });
    perFrame.name = "perFrame";
    perFrame.position.y = 40;

    var perTick = new PIXI.Text("0",
        {
            fontFamily : 'SourceSansPro-Light',
            fontSize: 24,
            fill : 0xff0000,
            align : 'left'
        });
    perTick.name = "perTick";
    perTick.position.y = 70;

    var currKey = new PIXI.Text("0",
        {
            fontFamily : 'SourceSansPro-Light',
            fontSize: 24,
            fill : 0xff0000,
            align : 'left'
        });
    currKey.name = "currKey";
    currKey.position.y = 100;

    var currModule = new PIXI.Text("0",
        {
            fontFamily : 'SourceSansPro-Light',
            fontSize: 24,
            fill : 0xff0000,
            align : 'left'
        });
    currModule.name = "currModule";
    currModule.position.y = 130;

    var currSubModule = new PIXI.Text("0",
        {
            fontFamily : 'SourceSansPro-Light',
            fontSize: 24,
            fill : 0xff0000,
            align : 'left'
        });
    currSubModule.name = "currSubModule";
    currSubModule.position.y = 160;

    var currFocus = new PIXI.Text("0",
        {
            fontFamily : 'SourceSansPro-Light',
            fontSize: 24,
            fill : 0xff0000,
            align : 'left'
        });
    currFocus.name = "currFocus";
    currFocus.position.y = 190;

    panel.addChild(fps);
    panel.addChild(perFrame);
    panel.addChild(currKey);
    panel.addChild(currModule);
    panel.addChild(currSubModule);
    panel.addChild(currFocus);
    panel.addChild(perTick);
};

UI.initKey = function () {
    DBG_INFO("UI.initKey start "+ debugRunTime());
    if (Config.tv) {
        UI.initKeyRemote();
    } else {
        UI.initKeyBoard();
    }
    DBG_INFO("UI.initKey end "+ debugRunTime());
};

UI.initEvent = function () {
    createjs.EventDispatcher.initialize(UI);
    UI.keyListener = UI.on("KeySingle", UI.processKey);
    //UI.on("KeyRelease", UI.processRelease)
};

UI.processRelease = function() {

};

UI.hideModule = function (moduleId) {
    var mod = UI.getModule(moduleId);
    mod.visible = false;
    UI.updateStage();
    //UI.getCurrModule() = mod.caller;
};

//UI.showModule = function (moduleId) {
//    var mod = UI.getModule(moduleId);
//    mod.visible = true;
//    UI.frontStage.update();
//    UI.getCurrModule() = mod;
//};

UI.setCurrent = function (currModuleId, currFocusId) {
    //UI.getCurrModule() = UI.getModule(currModuleId);
    UI.getCurrSubModule().currFocus = UI.getItem(UI.getCurrModule(), currFocusId);
    UI.focusTo(UI.getCurrSubModule().currFocus);
};

UI.popModule = function (holdFlg) {
    if (UI.base.cursor.parent) {
        UI.base.cursor.parent.removeChild(UI.base.cursor);
    }
    if (UI.isTextRunning) {
        UI.base.stopText();
    }
    if (holdFlg) {
        if (UI.frontStage.children.length == 1) {
            UI.activeKey();
            return;
        }
        UI.inactiveKey();
        var module = UI.getCurrModule();
        DBG_INFO("Pop Module : " + module.name);

        //UI._callBubble(UI.getCurrFocus(), "onNormal", UI.getCurrFocus());

        if(module.onPop) module.onPop();

        if (module.onExit) {
            if (module.caller) {
                module.onExit(UI.getCurrModule().caller)
            } else {
                module.onExit()
            }
        }

        UI.frontStage.removeChild(module);
        UI.updateStage();
        UI.activeKey();
        UI.prevModule = module.name;

        while (UI.subModuleManager[module.name].length > 0) {
            var removeModule = UI.subModuleManager[module.name].pop();
            if (removeModule.name == 'liveTVCtrl') {
//                 || removeModule.name == 'channelList') {
                UI.prevSubModule = removeModule.name;
                continue;
            }
            if (removeModule.children) {
                UI.renderer.textureGC.unload(removeModule);
                removeModule.destroy(true);
                UI.prevSubModule = removeModule.name;
                delete module[removeModule.name];
            }
        }

        while (UI.destroyManager[module.name].length > 0) {
            UI.destroyManager[module.name].pop().destroy(true);
        }

        if (UI.getCurrSubModule().onShow) UI.getCurrSubModule().onShow(module);

        if (UI.getCurrModule().name == "base") {
            UI.setOsdShowType(0);
        }
        // if(window.gc) {
        //     window.gc();
        // }
        return module;
    } else {
        UI.clearAllSubModule();
    }

};

//UI.popModuleTo = function (moduleId) {
//    var index = UI.loadedModule.length - 1;
//    for (var i = UI.loadedModule.length - 1; i > 0; i--) {
//        if (UI.loadedModule[i].name == moduleId) {
//            index = i;
//            break;
//        }
//    }
//    for (var j = 0; j <= index; j++) {
//        UI.popModule();
//    }
//};

UI.popAllModule = function () {
    GLOBAL.NO_VOICE = true;
    try {
        while (UI.frontStage.children.length > 1) {
            var moduleToPop = UI.frontStage.children[UI.frontStage.children.length - 2];
            if (moduleToPop.children.length == 0) {
                UI.popModule();
            } else {
                while (moduleToPop.children.length > 0) {
                    UI.popSubModule(moduleToPop);
                }
            }
        }
    }
    catch (ex){
        DBG_ERROR(ex.stack);
    }
    GLOBAL.NO_VOICE = false;
};

UI.getCurrModule = function() {
    if (UI.frontStage.children.length == 1) {
        return UI.base;
    } else if (UI.frontStage.children.length > 1) {
        return UI.frontStage.children[UI.frontStage.children.length - 2];
    }
};

UI.getCurrSubModule = function(module) {
    var currModule = module;
    if (!currModule) {
        currModule = UI.getCurrModule();
    }
    if (currModule && currModule.children.length > 0) {
        return currModule.children[currModule.children.length - 1];
    }
};

UI.getCurrFocus = function() {
    var currSubModule = UI.getCurrSubModule();
    if (currSubModule) {
        return currSubModule.currFocus;
    }
};

UI.pushModule = function (moduleId, info) {
    DBG_INFO("PushModule : " + moduleId);
    if (UI.isTextRunning) {
        UI.base.stopText();
    }
    UI.base.cursor.visible = false;
    UI.updateStage();
    UI.inactiveKey();
    UI.isLoadingModule = true;
    if (!window[moduleId]) {
        UI.moduleBuilder[moduleId] = {};
        window[moduleId] = new PIXI.Container();
        $LAB.script("module/" + moduleId + ".js")
            .wait(function() {
                UI.doPushModule(moduleId, info);
            });
    } else {
        UI.doPushModule(moduleId, info);
    }
};

UI.doPushModule = function(moduleId, info) {
    var exitModule = UI.getCurrModule();
    if (exitModule) {
        window[moduleId].caller = exitModule.name;
    }
    window[moduleId].name = moduleId;
    DBG_ERROR("Caller : " + window[moduleId].caller);
    for (var i = 0; i < UI.frontStage.children.length; i++) {
        if (UI.frontStage.children[i].name == "base") {
            if(UI.frontStage.children.indexOf(window[moduleId])>=0) {
                UI.frontStage.addChildAt(window[moduleId], i-1);
            } else {
                UI.frontStage.addChildAt(window[moduleId], i);
            }
            break;
        }
    }
    for (prop in info) {
        if (info.hasOwnProperty(prop)) {
            if (!window[moduleId].info) {
                window[moduleId].info = {};
            }
            window[moduleId].info[prop] = info[prop];
        }
    }
    if (window[moduleId].onPush) window[moduleId].onPush(exitModule, info);
    if (window[moduleId].onShow) window[moduleId].onShow(exitModule);
    UI.base.cursor.visible = true;
    UI.updateStage();
    UI.activeKey();
    if (!UI.subModuleManager[moduleId]) {
        UI.subModuleManager[moduleId] = [];
    }
    if (!UI.destroyManager[moduleId]) {
        UI.destroyManager[moduleId] = [];
    }
    window[moduleId].isModule = true;
    UI.isLoadingModule = false;
};


UI.startLoading = function(){
    DBG_INFO("UI.startLoading");
    UI.inactiveKey();
    UI.base.loading.alpha = 1;
    UI.getTween(UI.base.loading, true, true).to({rotation: UI.base.loading.rotation + Math.PI*2}, 2000);
    UI.base.loading.number++;
    UI.updateStage();
};

UI.endLoading = function(){
    DBG_INFO("UI.endLoading");
    UI.base.loading.number--;
    if (UI.base.loading.number <= 0) {
        UI.base.loading.alpha = 0;
        createjs.Tween.removeTweens(UI.base.loading);
        UI.updateStage();
    }
    UI.activeKey();
};

UI.prepareSubModule = function(moduleId, subModuleId, focusFlg, param, exitModule,focusId) {
    UI.base.cursor.visible = false;
    UI.updateStage();
    UI.inactiveKey();
    if (UI.isTextRunning) {
        UI.base.stopText();
    }
    var currModule = UI.getCurrModule();
    var currSubModule = UI.getCurrSubModule();
    if (currSubModule) {
        UI._callBubble(currSubModule.currFocus, "onNormal", currSubModule.currFocus);
        if (currSubModule.onExit) {
            currSubModule.onExit(subModuleId);
        }
    }
    if (currModule.name != moduleId) {
        DBG_ERROR("PushSubModule 2: " + moduleId);
        if (UI.isTextRunning) {
            UI.base.stopText();
        }
        UI.base.cursor.visible = false;
        UI.updateStage();
        UI.inactiveKey();
        if (!window[moduleId]) {
            UI.moduleBuilder[moduleId] = {};
            window[moduleId] = new PIXI.Container();
            $LAB.script("module/" + moduleId + ".js")
                .wait(function(){
                    UI.doPushModule(moduleId);
                })
                .script("module/" + moduleId + "/" + subModuleId +".js")
                .wait(function() {
                    UI.moduleBuilder[moduleId][subModuleId]();
                    UI.doPushSubModule(moduleId, subModuleId, focusFlg, param, true, exitModule,focusId, true);
                });
        } else if (!UI.moduleBuilder[moduleId][subModuleId]) {
            UI.doPushModule(moduleId);
            $LAB.script("module/" + moduleId + "/" + subModuleId +".js")
                .wait(function() {
                    UI.moduleBuilder[moduleId][subModuleId]();
                    UI.doPushSubModule(moduleId, subModuleId, focusFlg, param, true, exitModule,focusId, true);
                });
        } else if (!window[moduleId][subModuleId]) {
            UI.doPushModule(moduleId);
            UI.moduleBuilder[moduleId][subModuleId]();
            UI.doPushSubModule(moduleId, subModuleId, focusFlg, param, false, exitModule,focusId, true);
        } else {
            UI.doPushModule(moduleId);
            //UI.moduleBuilder[moduleId][subModuleId]();
            UI.doPushSubModule(moduleId, subModuleId, focusFlg, param, false, exitModule,focusId, true);
        }
    } else {
        if (window[moduleId][subModuleId]) {
            UI.doPushSubModule(moduleId, subModuleId, focusFlg, param, false, exitModule,focusId, false)
        } else if (UI.moduleBuilder[moduleId][subModuleId]) {
            UI.moduleBuilder[moduleId][subModuleId]();
            UI.doPushSubModule(moduleId, subModuleId, focusFlg, param, false, exitModule,focusId, false)
        } else {
            $LAB.script("module/" + moduleId + "/" + subModuleId +".js")
                .wait(function() {
                    UI.moduleBuilder[moduleId][subModuleId]();
                    UI.doPushSubModule(moduleId, subModuleId, focusFlg, param, true, exitModule,focusId, false)
                });
        }
    }
};

UI.pushSubModule = function (moduleId, subModuleId, focusFlg, param,lastModule,focusId) {
    DBG_ERROR("Push SubModule : " + subModuleId);
    UI.isLoadingModule = true;
    UI.loadingSubModuleName = subModuleId;
    UI.inactiveKey();
    var exitModule = lastModule?lastModule:UI.getCurrModule();
    //if (CONST.PRELOADIMGS[moduleId]
    //    && CONST.PRELOADIMGS[moduleId][subModuleId]
    //    && CONST.PRELOADIMGS[moduleId][subModuleId].length > 0) {
    //    while (CONST.PRELOADIMGS[moduleId][subModuleId].length > 0) {
    //        var url = CONST.PRELOADIMGS[moduleId][subModuleId].pop();
    //        PIXI.loader.add(themeDir + url,themeDir + url);
    //    }
    //    PIXI.loader.once('complete', function(){
    //        UI.prepareSubModule(moduleId, subModuleId, focusFlg, param, exitModule)
    //    });
    //    PIXI.loader.load();
    //} else {
        UI.prepareSubModule(moduleId, subModuleId, focusFlg, param, exitModule,focusId)
    //}
};

UI.doPushSubModule = function(moduleId, subModuleId, focusFlg, param, isFirstPush, exitModule,focusId,fromOtherModule) {
    DBG_ERROR("PushSubModule 4: " + subModuleId);
    var subModule = UI.getCurrModule()[subModuleId];

    if (GLOBAL.RTL) {
        UI.refreshRTL(subModule);
    }

    UI.setupLanguage(subModule);
    UI.refreshRTL(subModule);

    subModule.param = param;
    subModule.fromOther = fromOtherModule;

    var currSubModule = UI.getCurrSubModule(exitModule);
    if (currSubModule) {
        subModule.caller = currSubModule.name;
    } else {
        subModule.caller = UI.prevSubModule;
    }

    var currModule = window[moduleId];
    var flag = false;
    for (var i = 0; i < currModule.children.length; i++) {
        var module = currModule.children[i];
        if (module.name == subModule.name) {
            flag = true;
            break;
        }
    }
    if(!flag){
        currModule.addChild(subModule);
    }

    if (subModule.onFirstPush && isFirstPush) {
        subModule.onFirstPush();
    }

    if (subModule.onPush) {
        if (subModule.caller) {
            subModule.onPush(subModule.caller);
        } else {
            subModule.onPush({});
        }
    }

    if (subModule.onShow) {
        if (subModule.caller) {
            subModule.onShow(subModule.caller);
        } else {
            subModule.onShow({});
        }
    }

    if (focusFlg) {
        if(!!focusId)
        {
            var item= UI.getItem(subModule,focusId)
            if(!!item)
            {
                subModule.currFocus=item;
            }
        }
        UI.base.cursor.scale.x = 1;
        UI.base.cursor.scale.y = 1;
        UI._callBubble(subModule.currFocus, "onFocus", subModule.currFocus);
        UI.moveTop(subModule.currFocus);
    }

    subModule.visible = true;
    UI.base.cursor.visible = true;
    UI.activeKey();
    if (!subModule.noAutoMemcControl) {
        UI.setOsdShowType(1);
    }
    UI.updateStage();

    UI.subModuleManager[moduleId].push(subModule);

    UI.getTween(UI).to({wait:0}, 5000);
    UI.isLoadingModule = false;
UI.loadingSubModuleName = null;
    if (subModule.afterPush) {
        subModule.afterPush();
    }
if (!subModule.noAutoMemcControl) {
       UI.setOsdShowType(1);
    }
    DBG_ERROR("PushSubModule: " + subModuleId+";done");
};

UI.preloadImages = function(url) {
    var image = new Image();
    image.src = url;
};

UI.pushGhostModule = function(moduleId, subModuleId,param) {
    if (!UI.moduleBuilder[moduleId]) {
        UI.moduleBuilder[moduleId] = {};
    }
    if (UI.base.ghostModule[subModuleId]) {
        UI.base.ghostModule.addChild(UI.base.ghostModule[subModuleId]);
        UI.base.ghostModule[subModuleId].visible = true;
        UI.base.ghostModule[subModuleId].param = param;
        if (UI.base.ghostModule[subModuleId].onPush) {
            if (UI.base.ghostModule[subModuleId].caller) {
                UI.base.ghostModule[subModuleId].onPush(UI.base.ghostModule[subModuleId].caller);
            } else {
                UI.base.ghostModule[subModuleId].onPush({});
            }
        }
        UI.updateStage();
    } else {
        $LAB.script("module/" + moduleId + "/" + subModuleId +".js")
            .wait(function(){
                UI.moduleBuilder[moduleId][subModuleId]();
                UI.base.ghostModule[subModuleId] = UI.base.ghostModule.addChild(UI.getCurrModule()[subModuleId]);
                delete UI.getCurrModule()[subModuleId];
                UI.base.ghostModule[subModuleId].isSubModule = true;
                UI.base.ghostModule[subModuleId].visible = true;
                UI.base.ghostModule[subModuleId].param = param;
                if (UI.base.ghostModule[subModuleId].onPush) {
                    if (UI.base.ghostModule[subModuleId].caller) {
                        UI.base.ghostModule[subModuleId].onPush(UI.base.ghostModule[subModuleId].caller);
                    } else {
                        UI.base.ghostModule[subModuleId].onPush({});
                    }
                }
                UI.updateStage();
            });
    }
    if(!!subModuleId && subModuleId ==APPMODULE.CONTROL){
        UI.setOsdShowType(0);
    }else{
        //DBG_ERROR("OK! UI is gone memc on ");
        UI.setOsdShowType(1);
    }

};

UI.popGhostModule = function(subModuleId) {
    var module = UI.getItem(UI.base.ghostModule, subModuleId);
    if(null == module) return;
    UI.base.ghostModule.removeChild(module);
    if(module.onPop) {
        module.onPop();
    }
    UI.updateStage();
    if (UI.getCurrModule().name == "base") {
        UI.setOsdShowType(0);
    }
};

UI.getGhostModule = function (subModuleId) {
    if (!UI.base.ghostModule.children) return null;
    for (var i = 0; i < UI.base.ghostModule.children.length; i++) {
        var module = UI.base.ghostModule.children[i];
        if (module.name == subModuleId) return module;
    }
    return null;
};

UI.popSubModule = function (module, doShow) {
    if (UI.isSoftKeyBoard) {
        host.keyboard.onKeyDown({which : 27});
        UI.isSoftKeyBoard = false;
    }
    if (UI.base.cursor.parent) {
        UI.base.cursor.parent.removeChild(UI.base.cursor);
    }
    UI.base.cursor.visible = false;
    UI.updateStage();

    if(!module) module = UI.getCurrModule();

    if (module.name == "base") {
        return;
    }

    if (UI.isTextRunning) {
        UI.base.stopText();
    }

    if (module.children.length == 0) {
        if (module.name == UI.getCurrModule().name) {
            UI.popModule(true);
        } else {
            UI.frontStage.removeChild(module, true);
            if (module.onPop)module.onPop();
        }
        UI.base.cursor.visible = true;
        UI.updateStage();
        return;
    }

    var removeModule = module.children[module.children.length - 1];

    DBG_ERROR("removeModule.name" + " : " + removeModule.name);

    UI._callBubble(removeModule.currFocus, "onNormal", removeModule.currFocus);

    if (removeModule.parent) {
        removeModule.parent.removeChild(removeModule);
    }

    if(removeModule.onPop) {
        removeModule.onPop();
    }

    if (removeModule.onExit) {
        removeModule.onExit();
    }

    if (module.children.length == 0) {
        if (module.name == UI.getCurrModule().name) {
            UI.popModule(true);
        } else {
            UI.frontStage.removeChild(module, true);
            if (module.onPop)module.onPop();
        }
        UI.base.cursor.visible = true;
        UI.updateStage();
    } else {
        if (removeModule.caller) {
            if (removeModule.caller != removeModule.name) {
                var callerSubModule = UI.getSubModule(removeModule.caller);
                if (callerSubModule) {
                    if (UI.POP_NOSHOW && !doShow) {
                        callerSubModule.alpha = 1;
                    } else {
                        if (callerSubModule.onShow) {
                            callerSubModule.onShow(removeModule.name);
                        }
                    }
                }
            }
        }
    }
    UI.base.cursor.visible = true;
    var currFocus = UI.getCurrFocus();
    if (currFocus) {
        createjs.Tween.removeTweens(currFocus.scale);
        currFocus.scale.x = 1;
        currFocus.scale.y = 1;
    }
    UI._callBubble(UI.getCurrFocus(), "onFocus", UI.getCurrFocus());
};

UI.isExistModule = function (moduleName) {
    var isExist = false;
    for (var i = 0; i < UI.frontStage.children.length; i++) {
        if (UI.frontStage.children[i].name == moduleName) {
            isExist = true;
            break;
        }
    }
    return isExist;
};

UI.isExistSubModule = function (subModuleName) {
    var isExist = false;
    for (var i = 0; i < UI.frontStage.children.length; i++) {
        var module = UI.frontStage.children[i];
        for (var j = 0; j < module.children.length; j++) {
            if (module.children[j].name == subModuleName) {
                isExist = true;
                break;
            }
        }

    }
    return isExist;
};

UI.clearAllSubModule = function (moduleId, doShow) {
    GLOBAL.NO_VOICE = true;
    if (!moduleId) {
        moduleId = UI.getCurrModule().name;
    }
    UI.POP_NOSHOW = true;
    while (window[moduleId].children.length > 1) {
        UI.popSubModule(window[moduleId], doShow);
    }
    UI.POP_NOSHOW = false;
    UI.popSubModule(window[moduleId], doShow);
    GLOBAL.NO_VOICE = false;
};

//UI.createSubView = function (event, moduleId, subModuleId) {
//    var moduleSetup = UI[moduleId + "Setup"];
//    var moduleRoot = new createjs.Container();
//    moduleRoot = UI.setupModule(moduleSetup.items, UI.loader, moduleRoot);
//    moduleRoot.name = moduleId;
//    UI.loadedModule.push(moduleRoot);
//    moduleRoot.caller = UI.getCurrModule();
//    UI.getCurrModule() = moduleRoot;
//    window[moduleId] =moduleRoot;
//    UI.setUpSelector(moduleRoot.children, window[moduleId]);
//    moduleRoot.prevFocus = moduleRoot.currFocus;
//    UI.frontStage.addChildAt(moduleRoot, 0);
//    var manifest = [];
//    manifest.push({src: "module/" + moduleId + "/launcher.js"});
//    UI.loader.on("complete", function(event, moduleId) {
//        UI.frontStage.removeChild(UI.frontStage.getChildByName("loadingIcon"));
//        window[moduleId].init(window[moduleId]);
//        window[moduleId].onShow(window[moduleId]);
//        UI.moveTop(UI.getCurrSubModule().currFocus);
//
//    }, null, true, moduleId);
//    UI.loader.loadManifest(manifest, true, "../");
//};

UI.removeTweensExcept = function (target) {
    var tweens = createjs.Tween._tweens;
    for (var i= 0, l=tweens.length; i<l; i++) {
        var tween = tweens[i];
        if (tween.target = target) {
            continue;
        }
        tween._paused = true;
        tween.target.tweenjs_count--;
    }
};

UI.setUpSelector = function (children, selector) {
    for (var i = 0; i < children.length; i++) {
        if (children[i].name) {
            selector[children[i].name] = children[i];
            if (children[i].children) {
                UI.setUpSelector(children[i].children, selector[children[i].name]);
            }
        }
    }
};

UI._callBubble = function(target, funcName, param, evt) {
    if (!target) {
        return;
    }
    if (target[funcName]) {
        var rtn = target[funcName](param, evt);
        if (rtn) {
            if (target == UI.getCurrModule()) {
                UI._callPara(UI.getCurrModule().caller, funcName, param, evt)
            } else {
                UI._callBubble(target.parent, funcName, param, evt)
            }
        }
    } else {
        if (target == UI.getCurrModule()) {
            UI._callPara(UI.getCurrModule().caller, funcName, param, evt)
        } else {
            UI._callBubble(target.parent, funcName, param, evt)
        }
    }
};

UI._callPara = function(target, funcName, param, evt) {
    if (UI.base[funcName]) {
        UI.base[funcName](param, evt);
    }
};

UI.callTTS = function(txt,time,dotFlag,isCancel) {
    try{
        DBG_INFO("UI.callTTS:GLOBAL.TTS="+GLOBAL.TTS+","+"GLOBAL.NO_VOICE="+GLOBAL.NO_VOICE+",UI.ttsCancel="+UI.ttsCancel);
        if(GLOBAL.TTS && !GLOBAL.NO_VOICE){
            try{
                if(txt.toLowerCase() == "vewd"){
                    txt = "viewed app store";
                }

                if(time != 0 && !time){
                    time = 500;
                }
                if(time == 0){
                    clearTimeout(UI.ttsTimeout);
                    verifyStringAndReadTTS(txt,dotFlag,isCancel);
                }else{
                    clearTimeout(UI.ttsTimeout);
                    UI.ttsTimeout = setTimeout(function(){
                        verifyStringAndReadTTS(txt,dotFlag,isCancel);
                    }, time);
                }
            }catch (e){

            }

        }
    }catch (ex){
        DBG_ERROR("UI.callTTS:"+ex.message);
    }

};
function verifyStringAndReadTTS(txt,dotFlag,isCancel){
    txt = UI.setTtsString(txt)+"";
    if(dotFlag){
        txt = txt.replace(/[\.\,]/g,getPointStrForTTS());
    }
    var str = "";
    for (var i = 0; i < txt.length; i++) {
        str = str + txt.substr(i, 1).replace(UI.ttsReg, ' ').replace('-', ' dash ');
    }
    DBG_INFO("UI.callTTS.......: "+str);
    // 设置文本
    if(str.length==0){
        return;
    }
    UI.ttsUtterance.text = str;
    if(UI.ttsCancel){
        Hisense.System.stopSpeaking();
    }
    //Hisense.System.stopSpeaking();
    // 添加到队列
    Hisense.System.speak(UI.ttsUtterance.text);

    if(isCancel==undefined){
        isCancel=true;
    }
    UI.ttsCancel=isCancel;
    DBG_ERROR("UI.callTTS:"+UI.ttsCancel);
}
UI.setVoiceStr = function(target, txt) {
    DBG_ERROR("enter...UI.setVoiceStr....."+txt);
    txt += "";
    target.voiceStr = txt;
    var msgId = UI.getMsgId(txt);
    if (msgId) {
        target.voiceStr = txt.replace('['+msgId+']', Config.ttsLanguage[msgId]);
        //target.msgId = msgId;
    }
    UI.callTTS(target.voiceStr);
};

UI.processKey = function(evt) {
    for (var i = 0; i < UI.base.ghostModule.children.length; i++) {
        var ghostModule = UI.base.ghostModule.children[i];

        if (ghostModule["onkey_" + evt.value]) {
            DBG_INFO('ghostModule["onkey_' + evt.value + '"');
            ghostModule["onkey_" + evt.value](UI.getCurrSubModule().currFocus, evt);
            return;
        } else if (ghostModule["onkey"]) {
            var ret = ghostModule["onkey"](UI.getCurrSubModule().currFocus, evt);
            if (!ret) return;
        }
    }
    var currModule = UI.getCurrModule();
    var currSubModule = UI.getCurrSubModule();
    if("base" == currModule.name){
        UI._callBubble(currModule, "onkey_" + evt.value, currModule, evt);
    }
    else{
        if (currSubModule.onkey) {
            if (!currSubModule.onkey(currSubModule.currFocus, evt)) {
                return;
            }
        }
        if (UI.activeTextBox) {
            // 取出原始文本
            var oriTxt = UI.activeTextBox.children[0].realValue;
            DBG_ERROR("processkey evt.value=" + evt.value)
            switch (evt.value) {
                case "BACKSPACE":
                    if (evt.keyFrom == "Keyboard" || evt.keyFrom == "KeyboardSp") {
                        // 当按下的是BackSpace键时，删除一个字符
                        // UI.activeTextBox.setText(oriTxt.substring(0, oriTxt.length - 1));
                        UI.activeTextBox.backspace();
                        // 光标左移
                        // UI.activeTextBox.cursorLeft();
                        // 调用TextBox控件的回调
                        if (UI.activeTextBox.onChangeCallBack){
                            UI.activeTextBox.onChangeCallBack(UI.activeTextBox.children[0], UI.activeTextBox, true);
                        }
                        return;
                    }
                    break;
                case "DELETE":
                    UI.activeTextBox.delete();
                    if (UI.activeTextBox.onChangeCallBack){
                        UI.activeTextBox.onChangeCallBack(UI.activeTextBox.children[0], UI.activeTextBox, true);
                    }
                    return;
                case "ENTER":
                    // 当按下Enter键时，调出软键盘
                    UI.activeTextBox.showKeyBoard();
                    return;
                case "LEFT":
                    if (UI.activeTextBox.cursorLeft()) {
                        return;
                    }
                    break;
                case "RIGHT":
                    if (UI.activeTextBox.cursorRight()) {
                        return;
                    }
                    break;
                default:
                    if ((evt.value !== "UP" && evt.value !== "DOWN" && evt.value !== "ESCAPE" && evt.value !== "EXIT") && (evt.keyFrom == "Keyboard" || evt.keyFrom == "KeyboardSp")) {
                        // 按下其他字母按键时，将unicode键值转换为字符并添加到TextBox的文本中
                        var oriTxt = UI.activeTextBox.children[0].realValue;
                        var addTxt = String.fromCharCode(evt.keyCode);
                        UI.activeTextBox.setText(oriTxt, addTxt);
                        UI.activeTextBox.cursorRight();
                        if (UI.activeTextBox.onChangeCallBack){
                            UI.activeTextBox.onChangeCallBack(UI.activeTextBox.children[0], UI.activeTextBox, true);
                        }
                        return;
                    }
            }
        }
        UI._callBubble(currSubModule.currFocus, "onkey_" + evt.value, currSubModule.currFocus, evt);
    }
};

UI.processKeyGhost = function(evt) {
    //console.log("ghost");
    for (var i = 0; i < UI.base.ghostModule.children.length; i++) {
        var ghostModule = UI.base.ghostModule.children[i];
        if (ghostModule["onkey_" + evt.value]) {
            ghostModule["onkey_" + evt.value](UI.getCurrSubModule().currFocus, evt);
            return;
        }
    }
    if("base" == UI.getCurrModule().name){
        UI._callBubble(UI.getCurrModule(), "onkey_" + evt.value, UI.getCurrModule(), evt);
    }
    else{
        UI._callBubble(UI.getCurrSubModule().currFocus, "onkey_" + evt.value, UI.getCurrSubModule().currFocus, evt);
    }
};


UI._startTime = 0;
var now = window.performance && (performance.now || performance.mozNow || performance.msNow || performance.oNow || performance.webkitNow);
UI._getTime = function() {
    return ((now&&now.call(performance))||(new Date().getTime())) - UI._startTime;
};
UI._lastTime = 0;
var one_more_update = null;
UI.updateStage = function () {
    if (!UI.initFinishFlag || UI.noRefresh) {
        //console.log("UI refreshed before ready!");
        return;
    }
    //if(Config.debug && UI.base.panel) {
    //    UI.base.panel.getChildByName("fps").text = "帧率:" + Math.round(createjs.Ticker.getMeasuredFPS());
    //    UI.base.panel.getChildByName("perFrame").text = "每帧用时:" + Math.round(1000 / createjs.Ticker.getMeasuredFPS()) + "毫秒";
    //    UI.base.panel.getChildByName("perTick").text = "按键标志:" + UI.keyState;
    //    UI.base.panel.getChildByName("currKey").text = "当前按键:" + UI.currKeyValue;
    //    UI.base.panel.getChildByName("currModule").text = "当前模块:" + UI.getCurrModule().name;
    //    UI.base.panel.getChildByName("currSubModule").text = "当前子模块:" + (UI.getCurrSubModule() ? UI.getCurrSubModule().name : null);
    //    UI.base.panel.getChildByName("currFocus").text = "当前焦点:" + (UI.getCurrFocus() ? UI.getCurrFocus().name : null);
    //    UI.base.panel.alpha = 1;
    //}

    //UI.renderer.render(UI.frontStage);
	//UI
    requestAnimationFrame(function(){
        // run if enough time has elapsed, with a little bit of flexibility to be early:
        var _ttt = UI._getTime()
        if (_ttt - UI._lastTime >= 30) {
            UI._lastTime = _ttt;
            one_more_update = null;
            UI.renderer.render(UI.frontStage);
        } else {
            clearTimeout(one_more_update);
            one_more_update = setTimeout(UI.updateStage, 50);
        }
    });

    //console.log("UI refreshed!!!")
};

UI.updateStageDelay = function () {
    if (UI.refreshDelayTimer) {
        clearTimeout(UI.refreshDelayTimer);
    }
    UI.refreshDelayTimer = setTimeout(function(){
        UI.updateStage();
        UI.updateStage();
    }, 200);
};

UI.animate = function(){
    if (createjs.Tween._tweens.length > 0) {
        createjs.Tween.tick(17);
        UI.updateStage();
        requestAnimationFrame(UI.animate);
    }
};

UI.getTween = function (target, override, loop) {
    /*var tween =  createjs.Tween.get(target, {loop:loop ? loop : false, override : override==false ? override : true});
    tween.on("change", UI.updateStage);*/
    var tween = createjs.Tween.get(target, {
        loop: loop ? loop : false,
        override: override == false ? override : true
    }, null, true);
    tween.on("change", UI.updateStage);
    tween.on("complete", function () {
        if (!!target) {
            createjs.Tween.removeTweens(target);
            DBG_ERROR("REMOVE THE TWEENS !!!" + target.name);
            if (createjs.Tween._tweens.length === 0) {
                createjs.Ticker.reset();
            }
        }
    });
    if (createjs.Ticker._inited == false) {
        createjs.Ticker.init();
    }
    return tween;
};

UI.getItem = function (container, name) {
    if (!container || !container.children) {
        return null;
    }
    var ret = null;
    for (var i = 0; i < container.children.length; i++) {
        var element = container.children[i];
        if (element.name == name) {
            ret = element;
            break;
        } else if (element.children) {
            ret =  UI.getItem(element, name);
            if (ret) {
                return ret;
            }
        }
    }
    return ret;
};

UI.setView = function(target, width, height, offsetX, offsetY) {
    if (undefined == offsetX) {
        offsetX = 0;
    }
    if (undefined == offsetY) {
        offsetY = 0;
    }
    var viewRect;
    if (target.viewRect) {
        viewRect = target.viewRect;
    } else {
        viewRect = new PIXI.Graphics();
        target.viewRect = viewRect;
        target.initViewRect = viewRect;
        target.parent.addChild(viewRect);
    }
    viewRect.clear()
            .beginFill(0xffff00, 0.5)
            .drawRect(0, 0, width, height)
            .endFill();
    if (target.initSequence) {
        viewRect.position.x = target.initPos.x - offsetX;
        viewRect.position.y = target.initPos.y - offsetY;
    } else {
        viewRect.x = target.x - target.pivot.x - offsetX;
        viewRect.y = target.y - target.pivot.y - offsetY;
    }
    viewRect.rectWidth = width;
    viewRect.rectHeight = height;
    viewRect.renderable = false;
};

UI.resetViewPos = function(target){
    target.x = target.initPos.x + target.pivot.x;
    target.y = target.initPos.y + target.pivot.y;
};

UI.removeScrollbar = function(target){
    if (!target.scroll) return;
    target.parent.removeChild(target.scroll);
    target.scroll=null;
};
UI.removeView = function(target){
    if (!target.viewRect) return;
    target.parent.removeChild(target.viewRect);
    target.viewRect = null;
};
UI.removeMask = function(target){
    if (!target.mask) return;
    target.parent.removeChild(target.mask);
    target.mask = null;
};

UI.addScrollbar = function(target, offsetX) {
    target.scroll = target.parent.addChild(new PIXI.Graphics());
    target.scroll.x = target.viewRect.x + target.viewRect.rectWidth + (offsetX ? offsetX : 0);
    target.scroll.y = target.viewRect.y;
    target.scroll
        .clear()
        .beginFill(0xffffff, 0.15)
        .drawRoundedRect(0, 0, 6, target.viewRect.rectHeight * target.viewRect.rectHeight / target.getBounds().height, 1)
        .endFill();
    if (target.getBounds().height <= target.viewRect.rectHeight) {
        target.scroll.alpha = 0;
    } else {
        target.scroll.alpha = 1;
    }
};

UI.resetScrollbar = UI.refeshScrollbar = function(target) {
    if (!this.scroll) return;
    this.scroll
        .beginFill(0xffffff, 0.15)
        .drawRoundedRect(0, 0, 6, this.viewRect.rectHeight * target.viewRect.rectHeight / target.getBounds().height, 1)
        .endFill();
    if (target.getBounds().height <= target.viewRect.rectHeight) {
        target.scroll.alpha = 0;
    } else {
        target.scroll.alpha = 1;
    }
};

UI.refreshView = function(target, focus) {

    var retPoint = new PIXI.Point();
    if (!target || !focus)  {
        return retPoint;
    }
    var viewRect = target.viewRect;
    if (!viewRect) {
        target = target.parent;
        viewRect = target.viewRect;
    }
    if (!viewRect) {
        return retPoint;
    }

    var viewRectPos = target.parent.toGlobal(viewRect.position);
    var focusPos = focus.parent.toGlobal(focus.position);
    var desPoint = new PIXI.Point();

    var distRight = focusPos.x + focus.pivot.x - viewRectPos.x - viewRect.rectWidth;
    var distLeft  = focusPos.x - focus.pivot.x - viewRectPos.x;
    var distDown  = focusPos.y + focus.pivot.y - viewRectPos.y - viewRect.rectHeight;
    var distUp    = focusPos.y - focus.pivot.y - viewRectPos.y;

    if (distRight > 0) {
        desPoint.x = target.x - distRight;
    } else if (distLeft < 0) {
        desPoint.x = target.x - distLeft;
    } else {
        desPoint.x = target.x;
    }
    if (distDown > 0) {
        desPoint.y = target.y - distDown;
    } else if (distUp < 0) {
        desPoint.y = target.y - distUp;
    } else {
        desPoint.y = target.y;
    }

    target.position = desPoint;
};

UI.adjustView = function (duration) {
    if(!duration)duration=800;
    var focus = UI.getCurrFocus();
    var target = focus.parent;
    var retPoint = new PIXI.Point();
    if (!target)  {
        return retPoint;
    }
    var viewRect = target.viewRect;
    if (!viewRect) {
        target = target.parent;
        viewRect = target.viewRect;
    }
    if (!viewRect) {
        return retPoint;
    }

    var viewRectPos = target.parent.toGlobal(viewRect.position);
    var focusPos = focus.parent.toGlobal(focus.position);
    var desPoint = new PIXI.Point();

    var distRight = focusPos.x + focus.pivot.x - viewRectPos.x - viewRect.rectWidth;
    var distLeft  = focusPos.x - focus.pivot.x - viewRectPos.x;
    var distDown  = focusPos.y + focus.pivot.y - viewRectPos.y - viewRect.rectHeight;
    var distUp    = focusPos.y - focus.pivot.y - viewRectPos.y;

    if (distRight > 0) {
        desPoint.x = target.x - distRight;
    } else if (distLeft < 0) {
        desPoint.x = target.x - distLeft;
    } else {
        desPoint.x = target.x;
    }
    if (distDown > 0) {
        desPoint.y = target.y - distDown;
    } else if (distUp < 0) {
        desPoint.y = target.y - distUp;
    } else {
        desPoint.y = target.y;
    }

    UI.getTween(target).to({x:desPoint.x, y:desPoint.y}, duration, createjs.Ease.quartOut);

    if (target.scroll && !target.navTo) {
        UI.getTween(target.scroll, true)
            .to({
                y : target.viewRect.y +
                (focus.position.y - focus.height/2) / (target.height - focus.height)
                * (viewRect.rectHeight - target.scroll.height)
            }, 500);
    }

    if (target.ArrowCallBack) {
        target.ArrowCallBack(distLeft, distRight);
    }
    if (target.isSavingGrid && target.refreshItemVisible) {
        clearTimeout(refreshTimer);
        refreshTimer = setTimeout(function () {
            refreshTimer = null;
            target.refreshItemVisible();
            UI.updateStage();
        }, 600);
    }
    return desPoint;
};
var refreshTimer = null;

UI.moveCursor = function(noUse, retfocus) {

    var focus = !!retfocus? retfocus : UI.getCurrFocus();
    if ((!focus) || (UI.base.cursor.parent == focus)) {
        return;
    }
    createjs.Tween.removeTweens(UI.base.cursor);
    UI.base.cursor.alpha = 0;
    if (UI.isTextRunning) {
        UI.base.stopText();
    }
    var focusBounds = focus.getBounds();
    UI.base.cursor.width = focusBounds.width + UI.base.cursor.r * 2;
    UI.base.cursor.height = focusBounds.height + UI.base.cursor.r * 2;
    UI.base.cursor.position.x = focusBounds.width / 2 - UI.base.cursor.r;
    UI.base.cursor.position.y = focusBounds.height / 2 - UI.base.cursor.r;
    UI.base.cursor.pivot.x = focusBounds.width / 2;
    UI.base.cursor.pivot.y = focusBounds.height / 2;
    UI.base.cursor.scale.x = 1;
    UI.base.cursor.scale.y = 1;
    focus.addChild(UI.base.cursor);
    UI.base.cursor.getBounds();
};

UI.adjustToPoint = function (point, target, moveable) {
    var targetPos = target.parent.toGlobal(target.position);
    var dist = point.x - targetPos.x;
    UI.getTween(moveable).to({x:moveable.x + dist}, 500);
    return 0;
};

UI.focusTo = function(next) {
    if (next) {
        UI.base.navToNext(next)
    }
};

UI.getModule = function (moduleId) {
    for (var i = 0; i < UI.loadedModule.length; i++) {
        if (UI.loadedModule[i].name == moduleId) {
            return UI.loadedModule[i];
        }
    }
};

UI.onRemoteForSoft = function (key) {
    UI.keyCode = null;
    UI.keyFrom = null;
    UI.keyState = key.state;
    if (key.command in CONST.KEYCODE_MAP) {
        UI.keyCode = CONST.KEYCODE_MAP[key.command];
        UI.keyFrom = "Remote"
    }
    else if (CONST.KEYBOARD_ARROWKEY[key.alphakey+'']) {
        UI.keyCode = CONST.KEYBOARD_ARROWKEY[key.alphakey+''];
        UI.keyFrom = "KeyboardSp"
    }
    else if (key.alphakey != undefined && key.alphakey != null && key.alphakey != 0) {
        if (key.alphakey in CONST.KEYBOARD_KEYCODE_MAP) {
            UI.keyCode = CONST.KEYBOARD_KEYCODE_MAP[key.alphakey];
        } else {
            UI.keyCode = key.alphakey;
        }
        UI.keyFrom = "Keyboard"
    }
    if (UI.keyCode) {

        UI.sendKeyResult(key, true);
        UI.setCurrentKey(UI.keyCode);
        if (!( UI.keyCode in UI.keySet ) && (UI.keyFrom != "Keyboard")) {
            UI.sendKeyResult(key, false);
            return;
        }

        if (key.state == 1) {
            var event = {};
            event.which = UI.keyCode;
            event.keyFrom = UI.keyFrom;
            DBG_INFO("Send Single key from UI to Keyboard!");
            host.keyboard.onKeyDown(event);
        } else if (key.state == 2 && !Config.keyRep) {
            Config.keyRep = true;
            Config.keyIntervalIdForSoft = window.setInterval(function() {
                var event = {};
                event.which = UI.keyCode;
                event.keyFrom = UI.keyFrom;
                host.keyboard.onKeyDown(event);
                DBG_INFO("Send Repeat key from UI to Keyboard!");
            }, 120);
        } else if (key.state == 8) {
            Config.keyRep = false;
            window.clearInterval(Config.keyIntervalIdForSoft);
        }
    } else {
        UI.sendKeyResult(key, false);
    }
};

UI.onRemoteForUI = function (key, b2bKey) {
    if(!!readyCancelListener && key.state ==8){
        UI.guiService.listen(0);
        UI.sendKeyResult(key, true);
        UIObserver.publishMessage(UIObserver.MESSAGE_NAME.KEY_REPORT, UI.currKeyValue ,UI.currKeyCode);
        return;
    }
    UI.keyCode = null;
    UI.keyFrom = null;
    UI.keyState = key.state;
    if(!!b2bKey){
        UI.keyCode = key.keyCode;
        UI.keyFrom='b2bRs232Command'
    }else {
        if (key.command in CONST.KEYCODE_MAP) {
            UI.keyCode = CONST.KEYCODE_MAP[key.command];
            UI.keyFrom = "Remote"
        }
        else if (CONST.KEYBOARD_ARROWKEY[key.alphakey + '']) {
            UI.keyCode = CONST.KEYBOARD_ARROWKEY[key.alphakey + ''];
            UI.keyFrom = "KeyboardSp"
        }
        else {
            for (var keyboardCode in CONST.KEY) {
                if (CONST.KEY[keyboardCode] == key.alphakey) {
                    UI.keyCode = key.alphakey;
                    UI.keyFrom = "Keyboard"
                }
            }
        }
    }
    UI.receiveKey(key, UI.keyCode);
    if (!UI.getCurrSubModule() || !UI.getCurrFocus()) {
        DBG_ERROR("SDK:CurrSubModule is null, discard the key!");
        UI.sendKeyResult(key, true);
        if(key.state == 1){
            UI.errorKeyNum++;
            if(UI.errorKeyNum > 5){
                UI.popAllModule();
                if(checkIsAppOn()){
                    DBG_ERROR("UI.errorKeyNum > 5, and app is on focus to app");
                    appControl.focusCurrentApp();
                }else{
                    DBG_ERROR("UI.errorKeyNum > 5, open livetv");
                    openLiveTVModule();
                    var defaultFocus = UI.getItem(UI.getCurrSubModule(), "defaultFocus");
                    UI.focusTo(defaultFocus);
                }
                UI.errorKeyNum = 0;
            }
        }
        return;
    }else{
        UI.errorKeyNum = 0;
    }
    if(key.state == 2){
        UI.keyRepeatTime ++;
    }else{
        UI.keyRepeatTime = 0;
    }
//    if (key.state == 8) {
//        try{
//          //  DBG_ERROR("GLOBAL.AUTO_SLEEP"+ GLOBAL.AUTO_SLEEP );
//        if (GLOBAL.AUTO_SLEEP > 0) {
//            clearTimeout(g_systemautosleepTimer);
//            g_systemautosleepTimer = null;
//            var sleepvalue = [0, 3, 4];
//            var timer = 4;
//            if (GLOBAL.AUTO_SLEEP < 3) {
//                timer = sleepvalue[GLOBAL.AUTO_SLEEP];
//            }
//            g_systemautosleepTimer = setTimeout(function () {
//                onStandbyTipChanged(-3)
//            }, timer*3600*1000);
//        }
//        else if (!!g_systemautosleepTimer) {
//            clearTimeout(g_systemautosleepTimer);
//            g_systemautosleepTimer = null;
//        }
//        }catch (e)
//        {DBG_ERROR(e.message)}
//    }
    if(g_SystemAudioOnlyFlag==1
        &&key.state == 1
        &&(CONST.KEYCODE_MAP[key.command] != CONST.KEY.VK_VOLUME_UP)
        &&(CONST.KEYCODE_MAP[key.command] != CONST.KEY.VK_VOLUME_DOWN)
        &&(CONST.KEYCODE_MAP[key.command] != CONST.KEY.VK_MUTE)
        &&(CONST.KEYCODE_MAP[key.command] != CONST.KEY.VK_KEYPAD_VOLUME_UP)
        &&(CONST.KEYCODE_MAP[key.command] != CONST.KEY.VK_KEYPAD_VOLUME_DOWN)
        ){
        UI.sendKeyResult(key, true);
        g_SystemAudioOnlyFlag=0;
        model.system.setEnumScreenState(1);
        DBG_ALWAYS(" to open the screen");
        return;
    }

    var keyForPlayPad = [
        CONST.KEY.VK_UP, CONST.KEY.VK_DOWN,
        CONST.KEY.VK_LEFT, CONST.KEY.VK_RIGHT,
        CONST.KEY.VK_ENTER, CONST.KEY.VK_BACKSPACE,
        CONST.KEY.VK_EXIT,CONST.KEY.VK_MUTE,
        CONST.KEY.VK_VOLUME_UP, CONST.KEY.VK_VOLUME_DOWN,
        CONST.KEY.VK_KEYPAD_VOLUME_UP, CONST.KEY.VK_KEYPAD_VOLUME_DOWN,
        CONST.KEY.VK_CHANNEL_UP, CONST.KEY.VK_CHANNEL_DOWN,
        CONST.KEY.VK_FAST_BKW, CONST.KEY.VK_FAST_FWD,
        CONST.KEY.VK_PLAY, CONST.KEY.VK_PAUSE, CONST.KEY.VK_STOP, CONST.KEY.VK_PLAYPAUSE
    ];
    var keyForKpad = [
        CONST.KEY.VK_UP, CONST.KEY.VK_DOWN,
        CONST.KEY.VK_LEFT, CONST.KEY.VK_RIGHT,
        CONST.KEY.VK_ENTER, CONST.KEY.VK_BACKSPACE,
        CONST.KEY.VK_EXIT,CONST.KEY.VK_MUTE,
        CONST.KEY.VK_VOLUME_UP, CONST.KEY.VK_VOLUME_DOWN,
        CONST.KEY.VK_KEYPAD_VOLUME_UP, CONST.KEY.VK_KEYPAD_VOLUME_DOWN,
        CONST.KEY.VK_CHANNEL_UP, CONST.KEY.VK_CHANNEL_DOWN,
        CONST.KEY.VK_ZERO,CONST.KEY.VK_ONE,CONST.KEY.VK_TWO, CONST.KEY.VK_THREE,
        CONST.KEY.VK_FOUR,CONST.KEY.VK_FIVE,CONST.KEY.VK_SIX,
        CONST.KEY.VK_SEVEN, CONST.KEY.VK_EIGHT,CONST.KEY.VK_NINE,CONST.KEY.VK_SHORT_LINE,
        CONST.KEY.VK_RED,CONST.KEY.VK_GREEN,CONST.KEY.VK_YELLOW,CONST.KEY.VK_BLUE
    ];
    DBG_ERROR("in k-pad current key is: " + CONST.KEYCODE_MAP[key.command]);
    if((keyForPlayPad.indexOf(CONST.KEYCODE_MAP[key.command]) <= -1) && APPMODULE.LayoutToast == "LayoutToast" && CONST.KEYCODE_MAP[key.command] != CONST.KEY.VK_PLAYPAD){
        UI.popGhostModule("LayoutToast");
        APPMODULE.LayoutToast = null;
    }else if((keyForKpad.indexOf(CONST.KEYCODE_MAP[key.command]) <= -1) && APPMODULE.KpadToast == "KpadToast" && CONST.KEYCODE_MAP[key.command] != CONST.KEY.VK_KPAD){
        UI.popGhostModule("KeypadToast");
        APPMODULE.KpadToast = null;
    }

    if (GLOBAL.WAIT_POWERON && CONST.KEYCODE_MAP[key.command] != CONST.KEY.VK_POWER_ON) {
        UI.sendKeyResult(key, true);
        return;
    }
    if (UI.keyCode) {
        UI.setCurrentKey(UI.keyCode);
        if (GLOBAL.HBBTV_KEYSET > 0
            && CONST.HBBTV_KEYSET.indexOf(UI.keyCode) > -1
            && UI.getCurrModule().name == 'base') {
            DBG_ERROR("send key to hbbtv");
            UI.sendKeyResult(key, false);
            return;
        }
        else if (!(UI.currKeyCode in UI.keySet)) {
            UI.sendKeyResult(key, false);
            return;
        }
        else {
            if (!UI.keyActive) {
                if (Config.keyIntervalId) {
                    window.clearInterval(Config.keyIntervalId);
                }
                UI.sendKeyResult(key, true);
                return;
            }

            try{
                if(B2BPara.GHASB2B && b2bKeyHandle(key, b2bKey)){
                    DBG_INFO("b2b key handle:"+objToString(key));
                    DBG_INFO("b2bKey:"+ b2bKey +"return");
                    return;
                };
            }catch(ex){DBG_ERROR(ex.message)}

            if (key.state == 1) {
                var event = new createjs.Event("KeySingle");
                event.value = UI.currKeyValue;
                event.keyCode = UI.currKeyCode;
                event.keyFrom = UI.keyFrom;
                event.keyState = key.state;
                UI.dispatchKeyEvent(event);
            }
            else if (key.state == 2) {
                Config.keyRep = true;
                if (UI.keyActive) {
                    if (!(UI.currKeyCode in CONST.KEYSET_REPEAT)) {
//                        DBG_ERROR("NO REPEAT!!!");
                        UI.sendKeyResult(key, false);
                        return;
                    } else {
                        var event = new createjs.Event("KeySingle");
                        event.value = UI.currKeyValue;
                        event.keyCode = UI.currKeyCode;
                        event.keyFrom = UI.keyFrom;
                        event.keyState = key.state;
                        UI.dispatchKeyEvent(event);
                    }
                }
            }
            else if (key.state == 8) {
                Config.keyRep = false;
                UIObserver.publishMessage(UIObserver.MESSAGE_NAME.KEY_RELEASE, 1);
                UIObserver.publishMessage(UIObserver.MESSAGE_NAME.KEY_REPORT, UI.currKeyValue ,UI.currKeyCode);
            }
        }
        UI.sendKeyResult(key, true);
    }
    else {
        if (key.state != 1) {
            UI.sendKeyResult(key, true);
            return;
        }
        if (!UI.isUnicodeKey(key.alphakey)) {
            // ui does not receive special keys in keyboard
            DBG_ERROR("current key isUnicodeKey false")
            UI.sendKeyResult(key, true);
            return;
        }
        if (UI.activeTextBox
            && (key.alphakey < 62208 || key.alphakey > 62210)
            && (key.alphakey < 61445 || key.alphakey > 61448)) {
            UI.sendKeyResult(key, true);
            var oriTxt = UI.activeTextBox.children[0].realValue;
            var addTxt = String.fromCharCode(key.alphakey);
            var chars = oriTxt.split('');
            var cursorIndex = UI.activeTextBox.getCursor();
            if (cursorIndex < 0) {
                cursorIndex = 0;
            }
            chars.splice(cursorIndex, 0, addTxt);
            UI.activeTextBox.setText(chars.join(''));
                UI.activeTextBox.cursorRight();
                if (UI.activeTextBox.onChangeCallBack){
                    UI.activeTextBox.onChangeCallBack(UI.activeTextBox.children[0], UI.activeTextBox, true);
                }
            UI.sendKeyResult(key, true);
        } else {
            UI.sendKeyResult(key, false);
        }
    }
};
UI.isUnicodeKey = function (keyCode) {
    if (!keyCode) {
        return false
    }
    var key_type = (keyCode >> 8) & 0xff;
    var functional_keycode_type = [
        0xf0, // dikt_special
        0xf1, // dikt_function
        0xf2, // dikt_modifier
        0xf3, // dikt_lock
        0xf4, // dikt_dead
        0xf5, // dikt_custom
        0xf6, // dikt_identifier
        0xe0 // dikt_smallboard
    ];

    return !(functional_keycode_type.indexOf(key_type) > -1)
};

UI.onKeyBoard = function (key) {
    if (UI.fteMenuTimeout) {
        UI.refreshFteMenuTimeout();
    }
    if(UI.enterEulaTimeout && key.state == 1){
        UI.clearEnterEulaTimeout();
    }
    if(UI.enterStoreTimeout && key.state == 1){
        UI.clearEnterStoreTimeout();
    }
    if (UI.settingMenuTimeout && UI.settingMenuTimeout.interval) {
        UI.refreshSettingMenuTimeout();
    }
    if (UI.liveTVMenuTimeout) {
        UI.refreshLiveTVMenuTimeout();
    }
    if (UI.eposMenuTimeout) {
        UI.refreshEposMenuTimeout();
    }
    if (UI.LauncherMenuTimeout) {
        UI.refreshLauncherMenuTimeout();
    }
    if (UI.MediaMenuTimeout) {
        UI.refreshMediaMenuTimeout();
    }
    if (UI.MediaTimeout) {
        UI.refreshMediaTimeout();
    }
    if (!UI.keyActive) {
        return;
    }
    if("keydown" == key.type) {
        UI.setCurrentKey(key.keyCode);
        var event = new createjs.Event("KeySingle");
        event.value = CONST.KEYVALUE_MAP[key.keyCode];
        event.keyCode = UI.currKeyCode;
        UI.dispatchKeyEvent(event);
    }
    else{
        UIObserver.publishMessage(UIObserver.MESSAGE_NAME.KEY_RELEASE, 1);
    }
};

UI.dispatchKeyEvent = function(event) {
    this.dispatchEvent(event);
};

UI.initTVModel = function () {
    DBG_INFO("UI.initTVModel start "+ debugRunTime());
    DBG_ERROR("initTVModel Start");
    registerUSBNotify();
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CURRENT_LANGUAGE_CHANGED, onLanguageChanged);
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.MENU_TIMEOUT_CHANGED, onMenuTimeoutChanged);
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_CHANGED, onNetworkStatusChanged);
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.PLAY_MAIN_PAUSE_CHANGED, onPlayMainPauseChanged);
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.SYSTEM_PWR_USE_CASE, onSystemPwrUseCaseChanged);
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.SYTEM_NTP_TIME_CHANGED, onCurNTPTimeValidChaged);
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.BLUETOOTH_RC_PAIRED, bluetoothOnRCPairedChaged);
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.CURRENT_COUNTRY_CHANGED, onCountryCodeChanged);
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AVS_ONHISENSEDEVICEREPORTRESULT, onTvNameReportChanged);


    if (!Config.tv) return;
    //DB
    GLOBAL.UI_BRAND = getBrandCode(GLOBAL.CURRENT_AREA);

    GLOBAL.CURRENT_COUNTRY = getCountryCode(GLOBAL.CURRENT_AREA);
    GLOBAL.CURRENT_LANGUAGE = getLanguageCode(GLOBAL.CURRENT_AREA, GLOBAL.CURRENT_SUB_AREA);
    updateDateFormat();
    //RPC
    GLOBAL.CEC_CONTROL = parseInt(model.cec.getFunctionality());
    GLOBAL.CEC_DEVICE_EXIST = parseInt(model.sound.getArcDevExist());
    try {
        GLOBAL.CEC_ARC_STATE = parseInt(model.cec.getHdmiDevicesArcState());
    } catch(e){DBG_ERROR(e.stack)}
    GLOBAL.TIMEZONE_SECONDS = getTimezoneSeconds();
    GLOBAL.DEVIATION_FROM_UTC = parseInt(model.datetime.getDeviationFromutc());
    GLOBAL.TIME_FORMAT = parseInt(model.datetime.getTimeFormat());
    GLOBAL.DST_SECONDS = 0;//(parseInt(model.datetime.getDaylightSavings()) * 3600);
    recheckDSTSeconds();
    //notify
    UI.guiAppEventMessageListener = UI.guiService.addEventListener("appEventMessage", onAppEventMessageChanged);//message bettween app
    UI.guiAppEventMessageListener = UI.guiService.addEventListener("appNotifySTR", onAppEventMessageChanged);//style same with appEventMessage,use the same function
//    model.system.onAmStateChanged = onAmStateChanged;
    //GLOBAL.MHEG5_STATUS

    //MHL
    //model.source.setInputMhlAvailable(1);

    DBG_ERROR("UI register OttShowPwdDialogChanged!!!!!!!!!!!!!!!!!!!");
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.SYSTEM_OTT_SHOW_PWD_DIALOG, onOttShowPwdDialogChanged);



    DBG_ERROR("initTVModel End");
    DBG_INFO("UI.initTVModel end "+ debugRunTime());
};

UI.onRemote = function(key, b2bKey){
    try {
        if (UI.fteMenuTimeout) {
            UI.refreshFteMenuTimeout();
        }
        if(UI.enterEulaTimeout && key.state == 1){
            UI.clearEnterEulaTimeout();
        }
        if(UI.enterStoreTimeout && key.state == 1){
            UI.clearEnterStoreTimeout();
        }
        if (UI.settingMenuTimeout && UI.settingMenuTimeout.interval) {
            UI.refreshSettingMenuTimeout();
        }
        if (UI.liveTVMenuTimeout) {
            UI.refreshLiveTVMenuTimeout();
        }
        if (UI.eposMenuTimeout) {
            UI.refreshEposMenuTimeout();
        }
        if (UI.LauncherMenuTimeout) {
            UI.refreshLauncherMenuTimeout();
        }
        if (UI.MediaMenuTimeout) {
            UI.refreshMediaMenuTimeout();
        }
        if (UI.MediaTimeout) {
            UI.refreshMediaTimeout();
        }
        if (UI.initFinishFlag) {
            if (UI.isSoftKeyBoard) {
                UI.onRemoteForSoft(key);
            } else {
                UI.onRemoteForUI(key, b2bKey);
            }
        }
    }
    catch (ex){
        DBG_ERROR(ex.stack);
        UI.sendKeyResult(key, true);
    }
};

UI.initKeyRemote = function() {
    DBG_ERROR("Init Remote!");
    UI.guiKeyListener = UI.guiService.addEventListener("key", UI.onRemote);
};

UI.initKeyBoard = function() {
    DBG_ALWAYS("Init Keyboard!");
    document.onkeyup = document.onkeydown = UI.onKeyBoard;
};

UI.moveTop = function (target) {
    if (!target) {
        return;
    }
    if (target.parent) {
        var index = target.parent.getChildIndex(target);
        target.parent.children.splice(index, 1);
        target.parent.children.push(target);
    }
};

UI.moveTo = function(target, index) {
    target.parent.addChildAt(target, index);
};
var readyCancelListener = "";
UI.lockAllKeys = function (des, autoUnlockTime) {
    if (!autoUnlockTime) {
        autoUnlockTime = 10000;
    }
    if (1 == (++UI.lockCntr)) {
        if(Config.tv){
            if(UI.keyState != 8){
                readyCancelListener = "readyCancelListener";
            }else{
                UI.guiService.listen(0);
            }
        }
        //Config.tv && UI.guiService.listen(0);
        UI.inactiveKey();
    }
    DBG_ERROR("key lock[" + des + "], lockCntr:[" + UI.lockCntr + "]");
    autoUnlock(autoUnlockTime);

    function autoUnlock() {
        clearTimeout(UI.lockTimer);
        UI.lockTimer = setTimeout(function () {
            DBG_ALWAYS('unlock autoUnlock');
            UI.lockCntr = 0;
            readyCancelListener="";
            Config.tv && UI.guiService.listen(1);
            UI.activeKey();
        }, autoUnlockTime);
    }
};

UI.unlockAllKeys = function (des, force) {
    DBG_INFO("UI.unlockAllKeys start "+ debugRunTime());
    readyCancelListener = "";
    if (force || (1 == (UI.lockCntr--))) {
        clearTimeout(UI.lockTimer);
        UI.lockCntr = 0;
        Config.tv && UI.guiService.listen(1);
        UI.activeKey();
    }
    if (UI.lockCntr < 0) {
        DBG_ERROR("unlock lockCntr[" + UI.lockCntr + "], from[" + des + "], reset to 0");
        UI.lockCntr = 0;
        clearTimeout(UI.lockTimer);
        Config.tv && UI.guiService.listen(1);
        UI.activeKey();
    }
    else {
        DBG_ALWAYS("unlock lockCntr[" + UI.lockCntr + "], from[" + des + "]");
    }
    DBG_INFO("UI.unlockAllKeys end "+ debugRunTime());
};

UI.activeKey = function () {
    UI.keyActive = true;
    //UI.guiService.listen(1);
    DBG_ALWAYS("key active");

};

UI.inactiveKey = function () {
    UI.keyActive = false;
    //UI.guiService.listen(0);
    DBG_ALWAYS("key inactive");

};

UI.getSubModule = function (subModuleName) {
    if (!subModuleName) return;
    for (var i = 0; i < UI.frontStage.children.length; i++) {
        var module = UI.frontStage.children[i];
        if (module[subModuleName]) {
            return module[subModuleName];
        }
    }
};

UI.getSubModuleById = function(moduleId, subModuleId) {
    if (!window[moduleId]) {
        return null;
    }
    return window[moduleId][subModuleId];
};

UI.addMask = function(target, width, height, offsetX, offsetY) {
    if (undefined == offsetX) {
        offsetX = 3;
    }
    if (undefined == offsetY) {
        offsetY = 3;
    }
    var mask;
    if (target.mask) {
        mask = target.mask;
    } else {
        mask = new PIXI.Graphics();
        target.parent.addChild(mask);
        target.mask = mask;
    }
    mask.clear()
        .beginFill(0x0000FF, 0.5)
        .drawRect(0, 0, width + offsetX * 2, height + offsetY * 2)
        .endFill();
    if (target.initSequence) {
        mask.position.x = target.initPos.x - offsetX;
        mask.position.y = target.initPos.y - offsetY;
    } else {
        mask.position.x = target.x - target.pivot.x - offsetX;
        mask.position.y = target.y - target.pivot.y - offsetY;
    }
    mask.rectWidth = width;
    mask.rectHeight = height;
    //mask.renderable = true;
};



UI.setImage = function (target, urlOrObj, noUpdate, destroy, noScale) {
    if (!urlOrObj || !target) {
        return;
    }
    if (urlOrObj.color) {
        if (destroy) {
            var removed = target.removeChildren();
            for (var i = 0; i < removed.length; i++) {
                removed[i].destroy(true);
            }
        } else {
            UI.destroyManager[UI.getCurrModule().name].concat(target.removeChildren());
        }
        var graphics = new PIXI.Graphics();
        var alpha = 1;
        if (typeof urlOrObj.alpha == "number") {
            alpha = urlOrObj.alpha;
        }
        graphics.clear()
            .beginFill(urlOrObj.color, alpha)
            .drawRect(0, 0, target.oriWidth, target.oriHeight)
            .endFill();
        target.addChild(graphics);
    }
    else if (urlOrObj.graphicsData) {
        if (destroy) {
            UI.destroyManager[UI.getCurrModule().name].concat(target.removeChildren());
        } else {
            UI.destroyManager[UI.getCurrModule().name].concat(target.removeChildren());
        }
        target.addChild(urlOrObj);
    }
    else if (urlOrObj.resolution) {
        if (destroy) {
            var removed = target.removeChildren();
            for (var i = 0; i < removed.length; i++) {
                removed[i].destroy();
            }
        } else {
            UI.destroyManager[UI.getCurrModule().name].concat(target.removeChildren());
        }
        var pic = Util.connBgPics(urlOrObj, target.oriWidth, target.oriHeight);
        target.addChild(pic);
    }
    else {
        var url = null;
        if (urlOrObj.substring(1, 10) == "var/local") {
            url = "file://" + urlOrObj;
        } else if (urlOrObj.substring(0, 7) == "file://") {
            url = urlOrObj;
        } else if (urlOrObj.substring(0, 7) == "http://") {
            url = urlOrObj;
        }else if (urlOrObj.substring(0, 8) == "https://") {
            url = urlOrObj;
        }
        else {
            url = themeDir + "" + urlOrObj;
        }
        var calculateImageSize = function (imgH, imgW, containerH, containerW) {
            // var rateH = containerH/imgH;
            // var rateW = containerW/imgW;
            // var targetH = rateW*imgH;
            // var targetW = rateH*imgW;
            // var ret = {
            //     W: 0,
            //     H: 0
            // };
            // if (targetH > containerH) {
            //     ret.H = containerH;
            //     ret.W = targetW;
            // } else {
            //     ret.H = targetH;
            //     ret.W = containerW;
            // }
            var ret = {
                W: containerW,
                H: imgH/imgW*containerW
            };
            return ret;
        };

        if (!!target.children && !!target.children.length && target.children[0].texture &&
            target.children[0].texture.baseTexture &&
            url == target.children[0].texture.baseTexture.imageUrl) {
            if (noScale) {
                target.width = PIXI.loader.resources[url].data.width;
            }
            if (!noUpdate) {
                UI.getTween(UI).wait(3000);
            } else {
                UI.updateStageDelay();
            }
            return;
        }
        var baseTexture;
        var texture;
        if (PIXI.loader.resources[url]) {
            texture = PIXI.loader.resources[url].texture;
            baseTexture = texture.baseTexture;
            if (urlOrObj.substring(0, 7) != "http://" && urlOrObj.substring(0, 7) != "https://") {
                baseTexture.common = true;
                texture.common = true;
            }
            if (!!baseTexture) {
                baseTexture.count++;
            }
        } else {
            baseTexture = PIXI.BaseTexture.fromImage(url);
            texture = new PIXI.Texture(baseTexture);
        }

        for (var idx = 0; idx < CONST.COMMONIMGS.length; idx++) {
            if (CONST.COMMONIMGS[idx] == urlOrObj) {
                texture.common = true;
                baseTexture.common = true;
                break;
            }
        }
        if (!!target.children && !!target.children.length && target.children[0].texture) {
            if (destroy) {
                target.children[0].texture.destroy(true);
            } else {
                UI.destroyManager[UI.getCurrModule().name].push(target.children[0].texture);
            }
            target.children[0].texture = texture;
        } else {
            if (destroy) {
                var removed = target.removeChildren();
                for (var i = 0; i < removed.length; i++) {
                    removed[i].destroy();
                }
            } else {
                UI.destroyManager[UI.getCurrModule().name].concat(target.removeChildren());
            }
            target.addChild(new PIXI.Sprite(texture));
        }
        target.children[0].width = target.oriWidth;
        target.children[0].height = target.oriHeight;
        if (noScale) {
            target.width = PIXI.loader.resources[url].data.width;
        }
        if (!noUpdate) {
            UI.getTween(UI).wait(3000);
        } else {
            UI.updateStageDelay();
        }
    }
    target.children[0].width = target.oriWidth;
    target.children[0].height = target.oriHeight;
};


UI.setImageForGhost = function (target, urlOrObj, noUpdate, destroy, noScale) {
    if (!urlOrObj || !target) {
        return;
    }
    if (urlOrObj.color) {
        if (destroy) {
            var removed = target.removeChildren();
            for (var i = 0; i < removed.length; i++) {
                removed[i].destroy(true);
            }
        } else {
            UI.destroyManager['Ghost'].concat(target.removeChildren());
        }
        var graphics = new PIXI.Graphics();
        var alpha = 1;
        if (typeof urlOrObj.alpha == "number") {
            alpha = urlOrObj.alpha;
        }
        graphics.clear()
            .beginFill(urlOrObj.color, alpha)
            .drawRect(0, 0, target.oriWidth, target.oriHeight)
            .endFill();
        target.addChild(graphics);
    }
    else if (urlOrObj.graphicsData) {
        if (destroy) {
            UI.destroyManager['Ghost'].concat(target.removeChildren());
        } else {
            UI.destroyManager['Ghost'].concat(target.removeChildren());
        }
        target.addChild(urlOrObj);
    }
    else if (urlOrObj.resolution) {
        if (destroy) {
            var removed = target.removeChildren();
            for (var i = 0; i < removed.length; i++) {
                removed[i].destroy();
            }
        } else {
            UI.destroyManager['Ghost'].concat(target.removeChildren());
        }
        var pic = Util.connBgPics(urlOrObj, target.oriWidth, target.oriHeight);
        target.addChild(pic);
    }
    else {
        var url = null;
        if (urlOrObj.substring(1, 10) == "var/local") {
            url = "file://" + urlOrObj;
        } else if (urlOrObj.substring(0, 7) == "file://") {
            url = urlOrObj;
        } else if (urlOrObj.substring(0, 7) == "http://") {
            url = urlOrObj;
        }else if (urlOrObj.substring(0, 8) == "https://") {
            url = urlOrObj;
        }
        else {
            url = themeDir + "" + urlOrObj;
        }
        var calculateImageSize = function (imgH, imgW, containerH, containerW) {
            // var rateH = containerH/imgH;
            // var rateW = containerW/imgW;
            // var targetH = rateW*imgH;
            // var targetW = rateH*imgW;
            // var ret = {
            //     W: 0,
            //     H: 0
            // };
            // if (targetH > containerH) {
            //     ret.H = containerH;
            //     ret.W = targetW;
            // } else {
            //     ret.H = targetH;
            //     ret.W = containerW;
            // }
            var ret = {
                W: containerW,
                H: imgH/imgW*containerW
            };
            return ret;
        };

        if (!!target.children && !!target.children.length && target.children[0].texture &&
            target.children[0].texture.baseTexture &&
            url == target.children[0].texture.baseTexture.imageUrl) {
            if (noScale) {
                target.width = PIXI.loader.resources[url].data.width;
            }
            if (!noUpdate) {
                UI.getTween(UI).wait(3000);
            } else {
                UI.updateStageDelay();
            }
            return;
        }
        var baseTexture;
        var texture;
        if (PIXI.loader.resources[url]) {
            texture = PIXI.loader.resources[url].texture;
            baseTexture = texture.baseTexture;
            if (urlOrObj.substring(0, 7) != "http://" && urlOrObj.substring(0, 7) != "https://") {
                baseTexture.common = true;
                texture.common = true;
            }
            if (!!baseTexture) {
                baseTexture.count++;
            }
        } else {
            baseTexture = PIXI.BaseTexture.fromImage(url);
            texture = new PIXI.Texture(baseTexture);
        }

        for (var idx = 0; idx < CONST.COMMONIMGS.length; idx++) {
            if (CONST.COMMONIMGS[idx] == urlOrObj) {
                texture.common = true;
                baseTexture.common = true;
                break;
            }
        }
        if (!!target.children && !!target.children.length && target.children[0].texture) {
            if (destroy) {
                target.children[0].texture.destroy(true);
            } else {
                UI.destroyManager['Ghost'].push(target.children[0].texture);
            }
            target.children[0].texture = texture;
        } else {
            if (destroy) {
                var removed = target.removeChildren();
                for (var i = 0; i < removed.length; i++) {
                    removed[i].destroy();
                }
            } else {
                UI.destroyManager['Ghost'].concat(target.removeChildren());
            }
            target.addChild(new PIXI.Sprite(texture));
        }
        target.children[0].width = target.oriWidth;
        target.children[0].height = target.oriHeight;
        if (noScale) {
            target.width = PIXI.loader.resources[url].data.width;
        }
        if (!noUpdate) {
            UI.getTween(UI).wait(3000);
        } else {
            UI.updateStageDelay();
        }
    }
    target.children[0].width = target.oriWidth;
    target.children[0].height = target.oriHeight;
};



UI.setImageforMedia = function (target, urlOrObj, noUpdate, destroy, noScale) {
    if (!urlOrObj || !target) {
        return;
    }
    if (urlOrObj.color) {
        if (destroy) {
            var removed = target.removeChildren();
            for (var i = 0; i < removed.length; i++) {
                removed[i].destroy();
            }
        } else {
            UI.destroyManager[UI.getCurrModule().name].concat(target.removeChildren());
        }
        var graphics = new PIXI.Graphics();
        graphics.clear()
            .beginFill(urlOrObj.color)
            .drawRect(0, 0, target.oriWidth, target.oriHeight)
            .endFill();
        target.addChild(graphics);
    }
    else if (urlOrObj.graphicsData) {
        if (destroy) {
            UI.destroyManager[UI.getCurrModule().name].concat(target.removeChildren());
        } else {
            UI.destroyManager[UI.getCurrModule().name].concat(target.removeChildren());
        }
        target.addChild(urlOrObj);
    }
    else if (urlOrObj.resolution) {
        if (destroy) {
            var removed = target.removeChildren();
            for (var i = 0; i < removed.length; i++) {
                removed[i].destroy();
            }
        } else {
            UI.destroyManager[UI.getCurrModule().name].concat(target.removeChildren());
        }
        var pic = Util.connBgPics(urlOrObj, target.oriWidth, target.oriHeight);
        target.addChild(pic);
    }
    else {
        var url = null;
        if (urlOrObj.substring(1, 10) == "var/local") {
            url = "file://" + urlOrObj;
        } else if (urlOrObj.substring(0, 7) == "file://") {
            url = urlOrObj;
        } else if (urlOrObj.substring(0, 7) == "http://") {
            url = urlOrObj;
        }else if (urlOrObj.substring(0, 8) == "https://") {
            url = urlOrObj;
        }
        else {
            url = themeDir + "" + urlOrObj;
        }
        var calculateImageSize = function (imgH, imgW, containerH, containerW) {
            // var rateH = containerH/imgH;
            // var rateW = containerW/imgW;
            // var targetH = rateW*imgH;
            // var targetW = rateH*imgW;
            // var ret = {
            //     W: 0,
            //     H: 0
            // };
            // if (targetH > containerH) {
            //     ret.H = containerH;
            //     ret.W = targetW;
            // } else {
            //     ret.H = targetH;
            //     ret.W = containerW;
            // }
            var ret = {
                W: containerW,
                H: imgH/imgW*containerW
            };
            return ret;
        };
        if (target.children[0].texture &&
            target.children[0].texture.baseTexture &&
            url == target.children[0].texture.baseTexture.imageUrl) {
            if (noScale) {
                var ret = calculateImageSize(PIXI.loader.resources[url].data.height, PIXI.loader.resources[url].data.width, target.oriHeight, target.oriWidth);
                target.width = ret.W;
                target.height = ret.H;
                UI.addMask(target, target.oriWidth, target.oriHeight);
                if (!target.offsetY) target.offsetY = 0;
                target.y = target.y - target.offsetY;
                target.offsetY = (target.height - target.oriHeight)/2;
                target.y = target.y + target.offsetY;
            }
            if (!noUpdate) {
                UI.getTween(UI).wait(3000);
            } else {
                UI.updateStageDelay();
            }
            return;
        }
        if (!PIXI.loader.resources[url] && url.indexOf('fvcmd') == -1) {
            PIXI.loader.add(url);
            PIXI.loader.once('complete', function () {
                var baseTexture = PIXI.BaseTexture.fromImage(url);
                for (var idx = 0; idx < CONST.COMMONIMGS.length; idx++) {
                    if (CONST.COMMONIMGS[idx] == urlOrObj) {
                        baseTexture.common = true;
                        break;
                    }
                }
                if (target.children[0].texture) {
                    if (destroy) {
                        target.children[0].texture.destroy(true);
                        target.children[0].texture = null;
                    } else {
                        UI.destroyManager[UI.getCurrModule().name].push(target.children[0].texture);
                    }
                    //target.children[0].texture.destroy(true);
                    //UI.destroyManager[UI.getCurrModule().name].push(target.children[0].texture);
                    target.children[0].texture = new PIXI.Texture(baseTexture);
                } else {
                    if (destroy) {
                        UI.destroyManager[UI.getCurrModule().name].concat(target.removeChildren());
                        var removed = target.removeChildren();
                        for (var i = 0; i < removed.length; i++) {
                            removed[i].destroy({children:true,texture:true,baseTexture:true});
                        }
                    } else {
                        UI.destroyManager[UI.getCurrModule().name].concat(target.removeChildren());
                    }
                    //UI.destroyManager[UI.getCurrModule().name].concat(target.removeChildren());
                    target.addChild(new PIXI.Sprite(new PIXI.Texture(baseTexture)));
                }
                target.children[0].width = target.oriWidth;
                target.children[0].height = target.oriHeight;
                if (noScale) {
                    var ret = calculateImageSize(PIXI.loader.resources[url].data.height, PIXI.loader.resources[url].data.width, target.oriHeight, target.oriWidth);
                    target.width = ret.W;
                    target.height = ret.H;
                    UI.addMask(target, target.oriWidth, target.oriHeight);
                    if (!target.offsetY) target.offsetY = 0;
                    target.y = target.y - target.offsetY;
                    target.offsetY = (target.height - target.oriHeight)/2;
                    target.y = target.y + target.offsetY;
                }
                if (!noUpdate) {
                    UI.getTween(UI).wait(3000);
                } else {
                    UI.updateStageDelay();
                }
            });
            PIXI.loader.load();
        } else {
            var baseTexture = PIXI.BaseTexture.fromImage(url);
            for (var idx = 0; idx < CONST.COMMONIMGS.length; idx++) {
                if (CONST.COMMONIMGS[idx] == urlOrObj) {
                    baseTexture.common = true;
                    break;
                }
            }
            if (target.children[0].texture) {
                if (destroy) {
                    target.children[0].texture.destroy(true);
                } else {
                    UI.destroyManager[UI.getCurrModule().name].push(target.children[0].texture);
                }
                //UI.destroyManager[UI.getCurrModule().name].push(target.children[0].texture);
                target.children[0].texture = new PIXI.Texture(baseTexture);
            } else {
                if (destroy) {
                    var removed = target.removeChildren();
                    for (var i = 0; i < removed.length; i++) {
                        removed[i].destroy();
                    }
                } else {
                    UI.destroyManager[UI.getCurrModule().name].concat(target.removeChildren());
                }
                UI.destroyManager[UI.getCurrModule().name].concat(target.removeChildren());
                target.addChild(new PIXI.Sprite(new PIXI.Texture(baseTexture)));
            }
            target.children[0].once('refresh', function (sprite) {
                sprite.width = sprite.parent.oriWidth;
                sprite.height = sprite.parent.oriHeight;
            }, this);
            if (noScale) {
                var ret = calculateImageSize(PIXI.loader.resources[url].data.height, PIXI.loader.resources[url].data.width, target.oriHeight, target.oriWidth);
                target.width = ret.W;
                target.height = ret.H;
                UI.addMask(target, target.oriWidth, target.oriHeight);
                if (!target.offsetY) target.offsetY = 0;
                target.y = target.y - target.offsetY;
                target.offsetY = (target.height - target.oriHeight)/2;
                target.y = target.y + target.offsetY;
            }
            if (!noUpdate) {
                UI.getTween(UI).wait(3000);
            } else {
                UI.updateStageDelay();
                target.children[0].once('refresh', function () {
                    UI.updateStageDelay();
                }, this)
            }
        }
    }
    target.children[0].width = target.oriWidth;
    target.children[0].height = target.oriHeight;
};

UI.getMsgId = function(str) {
    str += "";
    var sIndex = str.indexOf('[');
    var eIndex = str.indexOf(']');
    if (sIndex != -1 && eIndex != -1 && eIndex > sIndex) {
        return str.substring(sIndex + 1, eIndex);
    } else {
        return null;
    }
};

UI.setString = function(text){
    var tempText = text;
    var msgId = null;
    while(msgId = UI.getMsgId(tempText)){
        if (Config.language[msgId]) {
            tempText = tempText.replace('[' + msgId + ']', Config.language[msgId]);
        } else {
            break;
        }
    }
    return tempText;
};

UI.setTtsString = function(text){
    var tempText = text;
    var msgId = null;
    while(msgId = UI.getMsgId(tempText)){
        if (Config.ttsLanguage[msgId]) {
            tempText = tempText.replace('[' + msgId + ']', Config.ttsLanguage[msgId]);
        } else {
            break;
        }
    }
    return tempText;
};

UI.getPageStrs = function(text, str, width, pageLines, breakWords) {
    var splitter;
    var space;
    var tempStr = str;
    if (breakWords) {
        splitter = '';
        space = '';
    } else {
        switch(GLOBAL.CURRENT_LANGUAGE) {
            case "chi":
                splitter = '';
                space = '';
                break;
            case "tha":
                splitter = '#';
                space = '';
                tempStr = tempStr.split('#').join("");
                break;
            default :
                splitter = ' ';
                space = ' ';
        }
    }

    var finalStrs = [];
    var words = str.split(splitter);
    var lines = 1;
    tempStr = "";
    var segStr = "";

    for (var i = 0; i < words.length; i++) {
        if (TextMeasurer.measure(tempStr, text) > width) {
            if (lines >= pageLines) {
                finalStrs.push(segStr);
                lines = 0;
                segStr = "";
                tempStr = "";
            } else {
                segStr += tempStr;
            }
            lines++;
        }
        tempStr += words[i] + space;
    }
    finalStrs.push(segStr);
    return finalStrs;
};

UI.calculateWarpString = function(text, str, width, maxLines) {
    var splitter;
    var space;
    var tempStr = str;
    var isChi = /[\u4E00-\u9FA5\uF900-\uFA2D]/.test(str);
    var isTha = /^[\u0e80-\u0eff]+$/.test(str);
    if (isChi) {
        splitter = '';
        space = '';
    } else if (isTha) {
        splitter = '#';
        space = '';
        tempStr = tempStr.split('#').join("");
    } else {
        if (!maxLines) {
            text.text = str;
            return;
        }
        splitter = ' ';
        space = ' ';
    }
    if (TextMeasurer.measure(tempStr, text) > width) {
        var finalStr = '';
        var words = str.split(splitter);
        var lines = 1;
        tempStr = "";
        var lastTempStr = "";
        lastWord = "";
        for (var i = 0; i < words.length; i++) {
            lastTempStr = tempStr;
            lastWord = words[i];
            tempStr += words[i];
            if (TextMeasurer.measure(tempStr, text) > width) {
                if (lines >= maxLines) {
                    tempStr = lastTempStr.substring(0, lastTempStr.length - 4) + "...";
                    finalStr += tempStr + space;
                    break;
                } else {
                    finalStr += lastTempStr;
                    tempStr = words[i] + " ";
                }
                lines++;
            }
            tempStr += space;
            if (i == words.length - 1) {
                finalStr += tempStr;
                break;
            }
        }

        text.text = finalStr;
    } else {
        text.text = tempStr;
    }
    text.lines = lines;
};

UI.setText = function(target, str, noUpdate, noMarquee, width, renew, strArray) {
    if (!target || !target.children) {
        return;
    }
    var text = target.children[0];
    if (!text.style)return;

    if (UI.isTextRunning && UI.runningText == target) {
        UI.base.stopText();
    }

    target.msgId = str;
    var msgId;
    var arrayIndex = 0;
    while(msgId = UI.getMsgId(str)){
        if (Config.language[msgId]) {
            str = str.replace('[' + msgId + ']', Config.language[msgId]);
        } else if(msgId == "URL" && strArray != undefined) {
            str = str.replace('[' + msgId + ']', strArray[arrayIndex++]);
        } else {
            break;
        }
    }

    if (!width) {width = target.originWidth}

    if (text.style.wordWrap) {
        var newText = new PIXI.Text(text.text, text.style.clone());
        newText.maxLines = text.maxLines;
        target.removeChild(target.children[0]);
        text = newText;
        target.addChildAt(text, 0);
        UI.calculateWarpString(text, str, target.originWidth, text.maxLines);
    } else {
        if (renew) {
            var newText = new PIXI.Text(text.text, text.style.clone());
            target.removeChild(target.children[0]);
            text = newText;
            target.addChildAt(text, 0);
        }
        if (TextMeasurer.measure(str, text) > width) {
            target.originText = str;
            var finalText = str;
            for (var i = 1; i <= finalText.length; i++) {
                var tempStr = finalText.substring(0, finalText.length - i) + "...";
                if (TextMeasurer.measure(tempStr, text) <= width) {
                    finalText = tempStr;
                    break;
                } else if (tempStr == '...') {
                    finalText = tempStr;
                }
            }
            text.text = finalText;
        } else {
            target.originText = null;
            text.text = str;
        }
    }

    switch (text.style.align) {
        case "left" :
            text.position.x = 0;
            text.pivot.x = 0;
            break;
        case "right" :
            text.position.x = target.originWidth;
            text.pivot.x = text.width;
            break;
        case "center" :
            text.position.x = target.originWidth / 2;
            text.pivot.x = text.width / 2;
            break;
    }

    switch (target.textColumn) {
        case "up" :
            text.position.y = 0;
            text.pivot.y = 0;
            break;
        case "down" :
            text.position.y = target.originHeight;
            text.pivot.y = text.getBounds().height;
            break;
        case "middle" :
            text.position.y = target.originHeight / 2;
            text.pivot.y = text.getBounds().height / 2;
            break;
    }

    if (noMarquee) {
        target.originText = null;
    } else if (UI.getItem(UI.getCurrFocus(), target.name)) {
        UI.base.runText(target);
    }

    if(!noUpdate) UI.updateStage();
};

UI.getText=function(target,item_name){
    if(item_name){
        var temp_target=UI.getItem(target,item_name);
        return temp_target.children[0].text;
    }else{
        return target.children[0].text;
    }
};

UI.getTextWidth = function(target) {
    return target.children[0].getBounds().width;
};

UI.setTextColor = function(target, color) {
    if (!target.children[0]) {
        return;
    }
    target.children[0].style.fill = color;
    UI.updateStage();
};

UI.setTextLineHeight = function(target, height) {
    target.children[0].lineHeight = height;
    UI.updateStage();
};

UI.onKeyBoardForSoft = function (key) {
    host.keyboard.onKeyDown(key);
};

UI.addResource = function(resName) {
    if (UI.resLib[resName]) {
        return UI.resLib[resName];
    } else {
        var img = document.createElement("img");
        img.src = themeDir + "" + resName;
        UI.resLib[resName] = img;
        img.onload = UI.updateStage;
        return img;
    }
};

UI.registerKeyCodes = function (keyCodes) {
    DBG_INFO("UI.registerKeyCodes start "+ debugRunTime());
    UI.keySet = {};
    if(null == keyCodes){//register all keys
        var keys = Object.keys(CONST.KEY);
        keys.forEach(function (k) {
            UI.keySet[CONST.KEY[k]] = true;
        });
        //if(Config.tv) UI.guiService.wanted_key_group(7);
    }
    else{//regiseter partial keys
        keyCodes.forEach(function (v) {
            UI.keySet[v] = true;
        });
        UI.keySet[CONST.KEY.VK_POWER_ON] = true;
        //if(Config.tv) UI.guiService.wanted_key_group(0);
    }
    DBG_INFO("UI.registerKeyCodes end "+ debugRunTime());
};

UI.setKeyGroup = function(group){
    if(Config.tv) UI.guiService.wanted_key_group(group);
};

UI.showAppLoading = function(appName) {
    //UI.inactiveKey();
    //UI.base.loading.alpha = 1;
    //UI.getTween(UI.base.loading, true, true).to({rotation: UI.base.loading.rotation + 360}, 1000);
    //UI.base.loading.number++;
    //
    //UI.appLoadingBg = UI.base.addChildAt(new PIXI.Graphics(), 0);
    //UI.appLoadingBg.graphics.c().f("#000000").dr(0, 0, 1920, 1080);
    //
    //UI.updateStage();
    //clearTimeout(UI.loadingTimer);
    //UI.loadingTimer = setTimeout(UI.hideAppLoading, 20000);
};

UI.hideAppLoading = function() {
    clearTimeout(UI.loadingTimer);
    UI.base.loading.number--;
    if (UI.base.loading.number <= 0) {
        UI.base.loading.alpha = 0;
        UI.base.removeChild(UI.appLoadingBg);
        createjs.Tween.removeTweens(UI.base.loading);
        UI.updateStage();
    }
    UI.activeKey();
};

function getKeyStateStr(state){
    return 1 == state ? "DOWN" : 8 == state ? "UP" : 2 == state ? "REPEAT" : "NULL";
}

function getCurrentSubModelName(){
    if(!UI.getCurrModule() || !UI.getCurrSubModule()) return null;
    return UI.getCurrSubModule().name;
}

function getCurrentFocus(){
    if(!UI.getCurrModule() || !UI.getCurrSubModule() || !UI.getCurrSubModule().currFocus) return null;
    return UI.getCurrSubModule().currFocus.name;
}

UI.receiveKey = function(key, keyCode){
    if(!Config.tv) return;
    UI.currKey = key;
    DBG_ERROR(
        "receive key: " +
        keyCode +
        " " +
        CONST.KEYVALUE_MAP[keyCode] +
        ": " + getKeyStateStr(key.state) +
        ", currSubModule: " +
        getCurrentSubModelName() +
        ", currFocus: " + getCurrentFocus() +
        ""
    );
};

UI.sendKeyResult = function (key, val) {
    //debugWhoCallMe('sendKeyResult');
    if (!Config.tv) return;
    if(null == key) key = UI.currKey;
    DBG_ERROR("send    key: " + CONST.KEYVALUE_MAP[CONST.KEYCODE_MAP[key.command]] + ": " + getKeyStateStr(key.state) + ": " + val);
    key.sendResult(val);
};

UI.setCurrentKey = function(code){
    UI.currKeyCode = code;
    if (UI.keyFrom == "Remote") {
        try{
            var ModuleName = UI.getCurrModule().name;
            var SubModuleName = UI.getCurrSubModule().name;
            if (code == CONST.KEY.VK_KEYPAD_CHANNEL_UP && (SubModuleName == "allInputs" || ModuleName == "EposMessage" || ModuleName == "setting" || ModuleName == "hiMedia")) {
                UI.currKeyValue = CONST.KEYVALUE_MAP[CONST.KEY.VK_UP];
                UI.currKeyCode = CONST.KEY.VK_UP;
            }
            else if (code == CONST.KEY.VK_KEYPAD_CHANNEL_DOWN && (SubModuleName == "allInputs" || ModuleName == "EposMessage" || ModuleName == "setting" || ModuleName == "hiMedia")) {
                UI.currKeyValue = CONST.KEYVALUE_MAP[CONST.KEY.VK_DOWN];
                UI.currKeyCode = CONST.KEY.VK_DOWN;
            }
            else if (code == CONST.KEY.VK_KEYPAD_VOLUME_UP && (SubModuleName == "allInputs" || ModuleName == "setting") && g_SystemAudioOnlyFlag == 0) {
                UI.currKeyValue = CONST.KEYVALUE_MAP[CONST.KEY.VK_RIGHT];
                UI.currKeyCode = CONST.KEY.VK_RIGHT;
            }
            else if (code == CONST.KEY.VK_KEYPAD_VOLUME_DOWN && (SubModuleName == "allInputs"  || ModuleName == "setting") && g_SystemAudioOnlyFlag == 0) {
                UI.currKeyValue = CONST.KEYVALUE_MAP[CONST.KEY.VK_LEFT];
                UI.currKeyCode = CONST.KEY.VK_LEFT;
            }
            else if (code == CONST.KEY.VK_KEYPAD_MENU_BUTTON7) {
                if(UI.keyState == 1){
                    GLOBAL.KEYPAD_MENU_INIDATE = new Date().getTime();
//                    DBG_ERROR("GLOBAL.KEYPAD_MENU_INIDATE is " + GLOBAL.KEYPAD_MENU_INIDATE);
                    GLOBAL.KEYPAD_MENU_FLAG = true;
                }
                if(SubModuleName == "allInputs"  || ModuleName == "EposMessage" || (ModuleName == "setting" && UI.keyState == 1)){
//                    DBG_ERROR("1ModuleName name is " + ModuleName + "UI.keyState is "  + UI.keyState + " UI.currKeyValue is " +  UI.currKeyValue);
                    UI.currKeyValue = CONST.KEYVALUE_MAP[CONST.KEY.VK_ENTER];
                    UI.currKeyCode = CONST.KEY.VK_ENTER;
                }else if(( ModuleName != "FTE" &&  SubModuleName != "ChAutoScanPanel" && SubModuleName != "ChManualScanPanel")&& model.system.getUserMode() == 0){
//                    DBG_ERROR("--------------2ModuleName name is " + ModuleName + "UI.keyState is "  + UI.keyState + " UI.currKeyValue is " +  UI.currKeyValue);
                    UI.currKeyValue = CONST.KEYVALUE_MAP[code];
                    if(UI.keyState == 2){
                        var  newDate = new Date().getTime();
//                    DBG_ERROR("------------------2key down:date is " + objToString(GLOBAL.KEYPAD_MENU_INIDATE) + "------------------2newDate is " + newDate);
                        var timeLength = newDate - GLOBAL.KEYPAD_MENU_INIDATE;
                        DBG_ERROR("----------------------newDate - date is " + objToString(timeLength));
                        if(timeLength >= 3000){
                            if(GLOBAL.KEYPAD_MENU_FLAG) {
                                GLOBAL.KEYPAD_MENU_FLAG = false;
                                UI.pushGhostModule("EposMessage","initStoreWithConsole");
                            }
                            clearTimeout(GLOBAL.POP_STORE_CONSOLE_TIMER);
                            GLOBAL.POP_STORE_CONSOLE_TIMER = setTimeout(function() {
                                DBG_ERROR("POP initStoreWithConsole");
                                UI.popGhostModule("initStoreWithConsole");
                            }, 200);
                        }
                    }
                }else{
                    UI.currKeyValue = CONST.KEYVALUE_MAP[code];
                }
            }
            else if(GLOBAL.KEYPAD_STATE && code == CONST.KEY.VK_KEYPAD_MENU){
                UI.currKeyValue = CONST.KEYVALUE_MAP[code];
                if(UI.keyState == 1){
                    GLOBAL.KEYPAD_MENU_INIDATE = new Date().getTime();
                    GLOBAL.KEYPAD_MENU_FLAG = true;
                }
                if(UI.keyState == 2){
                    var  newDate = new Date().getTime();
                    var timeLength = newDate - GLOBAL.KEYPAD_MENU_INIDATE;
                    DBG_ERROR("----------------------newDate - date is " + objToString(timeLength));
                    if(timeLength >= 3000){
                        if(GLOBAL.KEYPAD_MENU_FLAG) {
                            GLOBAL.KEYPAD_MENU_FLAG = false;
                            UI.pushGhostModule("EposMessage","initStoreWithConsole");
                        }
                    }
                }
                if(UI.keyState == 8){
                    if(UI.getGhostModule('initStoreWithConsole')){
                        UI.popGhostModule('initStoreWithConsole');

                    }
                }
            }
            else if (code == CONST.KEY.VK_KEYPAD_INPUT && (ModuleName == "EposMessage" || ModuleName == "setting")) {
                UI.currKeyValue = CONST.KEYVALUE_MAP[CONST.KEY.VK_BACKSPACE];
                UI.currKeyCode = CONST.KEY.VK_BACKSPACE;

            }
            else {
                UI.currKeyValue = CONST.KEYVALUE_MAP[code];
            }
        }
        catch (ex){
            DBG_ERROR(ex.message);
        }
    }
    else if (UI.keyFrom == "Keyboard") {
        UI.currKeyValue = CONST.KEYVALUE_MAP[code];
    }
    //else if (UI.keyFrom == "KeyboardSp") {
    //    UI.currKeyValue = CONST.KEYBOARD_KEYVALUE_MAP_SP[code];
    //}
    else {
        UI.currKeyValue = CONST.KEYVALUE_MAP[code+''];
    }

};

UI.setDisable = function(target) {
    target.disable = true;
};

UI.switchTo = function(target, dist) {
    var newPos = target.toLocal(target.position, dist);
    dist.addChild(target);
    target.x = newPos.x;
    target.y = newPos.y;
};

UI.blankFunc = function () {
};

UI.hideModule = function (module) {
    module.renderable = false;
    UI.updateStage();
};

UI.showModule = function (module) {
    module.renderable = true;
    UI.updateStage();
};

UI.refreshBounds = function(target) {
    //var oriPoint = new createjs.Point(target.x - target.regX, target.y - target.regY);
    //target._bounds=null;
    //if (target.cacheCanvas) {
    //    target.uncache();
    //}
    //var bounds= target.getBounds();
    //if (!bounds) {
    //    bounds = {x:0, y:0, width:0, height:0}
    //}
    //target.setBounds(0,0,bounds.width,bounds.height);
    //target.regX = bounds.width / 2;
    //target.regY = bounds.height / 2;
    //target.x = oriPoint.x + target.regX;
    //target.y = oriPoint.y + target.regY;
    //if (target.text) {
    //    if (!target.noCache) {
    //        target.setBounds(bounds.x, bounds.y,bounds.width,bounds.height);
    //        target.cache(bounds.x, bounds.y - 10, bounds.width, bounds.height + 30);
    //    }
    //}
    return target.getBounds();
};

UI.hideCursor = function () {
    UI.base.cursor.alpha = 0;
    UI.getTween(UI.base.cursor).set({alpha:0});
    UI.updateStage();
};

UI.setFteMenuTimeout = function(callback, delay) {
    UI.clearFteMenuTimeout();
    UI.fteMenuTimeout = {};
    UI.fteMenuTimeout.callback = callback;
    UI.fteMenuTimeout.delay = delay;
    UI.fteMenuTimeout.interval = setTimeout(UI.fteMenuTimeout.callback, UI.fteMenuTimeout.delay);
};

UI.clearFteMenuTimeout = function() {
    if (!!UI.fteMenuTimeout) {
        clearTimeout(UI.fteMenuTimeout.interval);
    }
    UI.fteMenuTimeout = null;
};

UI.refreshFteMenuTimeout = function() {
    if (!!UI.fteMenuTimeout) {
        clearTimeout(UI.fteMenuTimeout.interval);
    }
    UI.fteMenuTimeout.interval = setTimeout(UI.fteMenuTimeout.callback, UI.fteMenuTimeout.delay);
};

UI.setEnterEulaTimeout = function(callback, delay) {
    UI.clearEnterEulaTimeout();
    UI.enterEulaTimeout = {};
    UI.enterEulaTimeout.callback = callback;
    UI.enterEulaTimeout.delay = delay;
    UI.enterEulaTimeout.interval = setTimeout(UI.enterEulaTimeout.callback, UI.enterEulaTimeout.delay);
};

UI.clearEnterEulaTimeout = function() {
    if (!!UI.enterEulaTimeout) {
        clearTimeout(UI.enterEulaTimeout.interval);
    }
    UI.enterEulaTimeout = null;
};

UI.setEnterStoreTimeout = function(callback, delay) {
    UI.clearEnterStoreTimeout();
    UI.enterStoreTimeout = {};
    UI.enterStoreTimeout.callback = callback;
    UI.enterStoreTimeout.delay = delay;
    UI.enterStoreTimeout.interval = setTimeout(UI.enterStoreTimeout.callback, UI.enterStoreTimeout.delay);
};

UI.clearEnterStoreTimeout = function() {
    if (!!UI.enterStoreTimeout) {
        clearTimeout(UI.enterStoreTimeout.interval);
    }
    UI.enterStoreTimeout = null;
};


UI.setSettingMenuTimeout = function() {
    UI.clearSettingMenuTimeout();
    UI.settingMenuTimeout = {};
    UI.settingMenuTimeout.callback = function(){
        if (UI.getCurrModule().name == "setting") {
            if (!UI.getCurrSubModule().noAutoClose) {
                if (UI.getCurrModule().caller == 'launcher') {
                    if (UI.isSoftKeyBoard) {
                        host.keyboard.onKeyDown({which : 27});
                        UI.isSoftKeyBoard = false;
                    }
                    LogReportData.LauncherPanelCloseReasonTimeOut=true;
                    UI.clearAllSubModule('setting');
                    UI.showModule(launcher);
                   // launcher.mainTiles.onShow("setting");
                    createjs.Tween.removeTweens(UI.base.cursor.scale);
                    UI.base.cursor.alpha = 1;
                    UI.base.cursor.visible = true;
                    UI.updateStage();
                } else if (UI.getCurrModule().caller == 'base'||UI.getCurrModule().caller == 'liveTV') {
                    if(checkIsAppOn())
                    {
                        if (UI.isSoftKeyBoard) {
                            host.keyboard.onKeyDown({which : 27});
                            UI.isSoftKeyBoard = false;
                        }
                        UI.clearAllSubModule("setting");
                        appControl.focusCurrentApp();
                    }
                    else{
                        if (UI.isSoftKeyBoard) {
                            host.keyboard.onKeyDown({which : 27});
                            UI.isSoftKeyBoard = false;
                        }
                        UI.clearAllSubModule('setting');
                        openLiveTVModule();
                    }

                } else if(UI.getCurrModule().caller == 'hiMedia'){
                    UI.clearAllSubModule('setting');
                    hiMedia.changeByLauncher("resume");

                }
            }

        }else   if (UI.getCurrModule().name == "EposMessage") {
            if (!UI.getCurrSubModule().noAutoClose) {
                if (UI.getCurrModule().caller == 'launcher') {
                    if (UI.isSoftKeyBoard) {
                        host.keyboard.onKeyDown({which : 27});
                        UI.isSoftKeyBoard = false;
                    }
                    LogReportData.LauncherPanelCloseReasonTimeOut=true;
                    UI.clearAllSubModule('EposMessage');
                    UI.showModule(launcher);
                    launcher.mainTiles.onShow("EposMessage");
                    createjs.Tween.removeTweens(UI.base.cursor.scale);
                    UI.base.cursor.alpha = 1;
                    UI.base.cursor.visible = true;
                    UI.updateStage();
                } else if (UI.getCurrModule().caller == 'base'||UI.getCurrModule().caller == 'liveTV') {
                    if(checkIsAppOn())
                    {
                        if (UI.isSoftKeyBoard) {
                            host.keyboard.onKeyDown({which : 27});
                            UI.isSoftKeyBoard = false;
                        }
                        UI.clearAllSubModule("EposMessage");
                        appControl.focusCurrentApp();
                    }
                    else{
                        if (UI.isSoftKeyBoard) {
                            host.keyboard.onKeyDown({which : 27});
                            UI.isSoftKeyBoard = false;
                        }
                        UI.clearAllSubModule('EposMessage');
                        openLiveTVModule();
                    }

                } else if(UI.getCurrModule().caller == 'hiMedia'){
                    UI.clearAllSubModule('EposMessage');
                }
            }

        }
        UI.clearSettingMenuTimeout();
        UI.settingMenuTimeout.interval = setTimeout(UI.settingMenuTimeout.callback, GLOBAL.SETTING_TIMEOUT_DELAY);
    };
    var timer= GLOBAL.SETTING_TIMEOUT_DELAY;
    if(timer==0)
    {
        UI.clearSettingMenuTimeout();
    } else {
        UI.clearSettingMenuTimeout();
        UI.settingMenuTimeout.interval = setTimeout(UI.settingMenuTimeout.callback,timer);
    }

};

UI.clearSettingMenuTimeout = function() {
    if (!!UI.settingMenuTimeout&&!!UI.settingMenuTimeout.interval) {
        clearTimeout(UI.settingMenuTimeout.interval);
        UI.settingMenuTimeout.interval = null;
        LogReportData.LauncherPanelCloseReasonTimeOut=false;
    }
};

UI.refreshSettingMenuTimeout = function() {
    UI.clearSettingMenuTimeout();
    var timer= GLOBAL.SETTING_TIMEOUT_DELAY;
    if(timer!=0)
    {
        UI.settingMenuTimeout.interval = setTimeout(UI.settingMenuTimeout.callback,timer);
    }
};

UI.setLiveTVMenuTimeout = function(callback, delay) {
    UI.clearLiveTVMenuTimeout();
    if(0 == delay) return;
    UI.liveTVMenuTimeout = {};
    UI.liveTVMenuTimeout.callback = callback;
    UI.liveTVMenuTimeout.delay = delay;
    UI.liveTVMenuTimeout.interval = setTimeout(UI.liveTVMenuTimeout.callback, UI.liveTVMenuTimeout.delay);
};

UI.clearLiveTVMenuTimeout = function() {
    if (!!UI.liveTVMenuTimeout) {
        clearTimeout(UI.liveTVMenuTimeout.interval);
    }
    UI.liveTVMenuTimeout = null;
};

UI.refreshLiveTVMenuTimeout = function() {
    if (!!UI.liveTVMenuTimeout) {
        clearTimeout(UI.liveTVMenuTimeout.interval);
        UI.liveTVMenuTimeout.interval = setTimeout(UI.liveTVMenuTimeout.callback, UI.liveTVMenuTimeout.delay);
    }
};

UI.setKpadTimeout = function(callback, delay) {
    UI.clearKpadTimeout();
    if(0 == delay) return;
    UI.KpadTimeout = {};
    UI.KpadTimeout.callback = callback;
    UI.KpadTimeout.delay = delay;
    UI.KpadTimeout.interval = setTimeout(UI.KpadTimeout.callback, UI.KpadTimeout.delay);
};

UI.clearKpadTimeout = function() {
    if (!!UI.KpadTimeout) {
        clearTimeout(UI.KpadTimeout.interval);
    }
    UI.KpadTimeout = null;
};

UI.refreshKpadTimeout = function() {
    if (!!UI.KpadTimeout) {
        clearTimeout(UI.KpadTimeout.interval);
        UI.KpadTimeout.interval = setTimeout(UI.KpadTimeout.callback, UI.KpadTimeout.delay);
    }
};

UI.setPlayPadTimeout = function(callback, delay) {
    UI.clearKpadTimeout();
    if(0 == delay) return;
    UI.PlayPadTimeout = {};
    UI.PlayPadTimeout.callback = callback;
    UI.PlayPadTimeout.delay = delay;
    UI.PlayPadTimeout.interval = setTimeout(UI.PlayPadTimeout.callback, UI.PlayPadTimeout.delay);
};

UI.clearPlayPadTimeout = function() {
    if (!!UI.PlayPadTimeout) {
        clearTimeout(UI.PlayPadTimeout.interval);
    }
    UI.PlayPadTimeout = null;
};

UI.refreshPlayPadTimeout = function() {
    if (!!UI.PlayPadTimeout) {
        clearTimeout(UI.PlayPadTimeout.interval);
        UI.PlayPadTimeout.interval = setTimeout(UI.PlayPadTimeout.callback, UI.PlayPadTimeout.delay);
    }
};

UI.setLauncherMenuTimeout = function(callback, delay) {
    UI.clearLauncherMenuTimeout();
    if(0 == delay) return;
    UI.LauncherMenuTimeout = {};
    UI.LauncherMenuTimeout.callback = callback;
    UI.LauncherMenuTimeout.delay = delay;
    UI.LauncherMenuTimeout.interval = setTimeout(UI.LauncherMenuTimeout.callback, UI.LauncherMenuTimeout.delay);
};

UI.clearLauncherMenuTimeout = function() {
    if (!!UI.LauncherMenuTimeout) {
        clearTimeout(UI.LauncherMenuTimeout.interval);
    }
    UI.LauncherMenuTimeout = null;
};

UI.refreshLauncherMenuTimeout = function() {
    if (!!UI.LauncherMenuTimeout) {
        clearTimeout(UI.LauncherMenuTimeout.interval);
        UI.LauncherMenuTimeout.interval = setTimeout(UI.LauncherMenuTimeout.callback, UI.LauncherMenuTimeout.delay);
    }
};

UI.setEposMenuTimeout = function(callback, delay) {
    UI.clearEposMenuTimeout();
    UI.eposMenuTimeout = {};
    UI.eposMenuTimeout.callback = callback;
    UI.eposMenuTimeout.delay = delay;
    UI.eposMenuTimeout.interval = setTimeout(UI.eposMenuTimeout.callback, UI.eposMenuTimeout.delay);
};

UI.clearEposMenuTimeout = function() {
    if (!!UI.eposMenuTimeout) {
        clearTimeout(UI.eposMenuTimeout.interval);
    }
    UI.eposMenuTimeout = null;
};

UI.refreshEposMenuTimeout = function() {
    if (!!UI.eposMenuTimeout) {
        clearTimeout(UI.eposMenuTimeout.interval);
        UI.eposMenuTimeout.interval = setTimeout(UI.eposMenuTimeout.callback, UI.eposMenuTimeout.delay);
    }
};

UI.setMediaMenuTimeout = function(callback, delay) {
    UI.clearMediaMenuTimeout();
    UI.MediaMenuTimeout = {};
    UI.MediaMenuTimeout.callback = callback;
    UI.MediaMenuTimeout.delay = delay;
    UI.MediaMenuTimeout.interval = setTimeout(UI.MediaMenuTimeout.callback, UI.MediaMenuTimeout.delay);
};
UI.setMediaTimeout = function(callback, delay) {
    UI.clearMediaTimeout();
    UI.MediaTimeout = {};
    UI.MediaTimeout.callback = callback;
    UI.MediaTimeout.delay = delay;
    UI.MediaTimeout.interval = setTimeout(UI.MediaTimeout.callback, UI.MediaTimeout.delay);
};
UI.clearMediaMenuTimeout = function() {
    if (!!UI.MediaMenuTimeout) {
        clearTimeout(UI.MediaMenuTimeout.interval);
    }
    UI.MediaMenuTimeout = null;
};
UI.clearMediaTimeout = function() {
    if (!!UI.MediaTimeout) {
        clearTimeout(UI.MediaTimeout.interval);
    }
    UI.MediaTimeout = null;
};

UI.refreshMediaMenuTimeout = function() {
    if (!!UI.MediaMenuTimeout) {
        clearTimeout(UI.MediaMenuTimeout.interval);
        UI.MediaMenuTimeout.interval = setTimeout(UI.MediaMenuTimeout.callback, UI.MediaMenuTimeout.delay);
    }
};

UI.refreshMediaTimeout = function() {
    if (!!UI.MediaTimeout) {
        clearTimeout(UI.MediaTimeout.interval);
        UI.MediaTimeout.interval = setTimeout(UI.MediaTimeout.callback, UI.MediaTimeout.delay);
    }
};

UI.setArrowCallBack = function (target, ArrowCallBack) {
    try {
        target.ArrowCallBack = ArrowCallBack;
    } catch (ex) {
        DBG_ERROR(ex.message);
    }
};

UI.addToFuncQueue = function (processFunc,param) {
    UI.funcQueue.push({func:processFunc,value:param});
    UI.excuteFuncQueue();
    clearTimeout(UI.funcQueueTimeout);
    UI.funcQueueTimeout = setTimeout(UI.excuteFuncQueue, 5000);
};

UI.excuteFuncQueue = function() {
    try{
    clearTimeout(UI.funcQueueTimeout);
    if(!UI.getCurrSubModule())
    {
       DBG_ERROR(" cursubmodule is null");
    }
    else if (GLOBAL.PROTECTED_TIME|| UI.isLoadingModule) {
        DBG_INFO("FuncQueue : curr time is protected or isLoadingModule");
    } else if (UI.lockCntr>0
        || UI.keyActive==false
        || (checkIsAppOn(APPNAME.EPOS))
        || UI.getCurrModule().name == "FTE"
        || (checkIsAppOn(APPNAME.FACTORY))
        || UI.isSoftKeyBoard) {
        DBG_INFO("FuncQueue : because of app, keylock, fte, epos, factory, softkeyboard, func will not excute.");
    } else if (UI.getCurrSubModule() && UI.getCurrSubModule().protected) {
        if (UI.funcQueue[0] && UI.funcQueue[0].value == MsgBoxType.STANDBY_TIP) {
            var item = UI.funcQueue.shift();
            if (item!=undefined&&!!item.func)
            {
                item.func.call(this,item.value);
                DBG_INFO("FuncQueue : func excuted.");
            }
        } else {
            DBG_INFO("FuncQueue : curr module is protected, func will not excute.");
        }
    } else {
        var item = UI.funcQueue.shift();
        if (item!=undefined&&!!item.func)
        {
            if (UI.isSoftKeyBoard) {
                host.keyboard.onKeyDown({which : 27});
                UI.isSoftKeyBoard = false;
            }
            item.func.call(this,item.value);
            DBG_INFO("FuncQueue : func excuted.");
        }
    }
    if (UI.funcQueue.length > 0) {
        UI.funcQueueTimeout = setTimeout(UI.excuteFuncQueue, 5000);
    }
    }catch (ex)
    {
        DBG_ERROR(ex.stack);

    }
};

UI.clearFuncQueue = function () {
    UI.funcQueue = [];
    if (!!UI.funcQueueTimeout) {
        clearTimeout(UI.funcQueueTimeout);
        UI.funcQueueTimeout = null;
    }
};

UI.deleteFuncQueue= function (processFunc,param) {
    var val={func:processFunc, value: param};
    if (UI.funcQueue.length > 0) {

        for(var a in UI.funcQueue)
        {
            if(isObjectValueEqual(UI.funcQueue[a], val)){
                UI.funcQueue.splice(a, 1);
            }
        }
    }
}
UI.checkFuncQueue= function (processFunc) {
    var val={func:processFunc, value:null};
    if (UI.funcQueue.length > 0) {

        for(var a in UI.funcQueue)
        {
            if(UI.funcQueue[a]&&
                !!UI.funcQueue[a].func&&
                UI.funcQueue[a].func==processFunc){
                val.value=UI.funcQueue[a].value;
                return val;
            }

        }

        return null;
    }
};

UI.checkFuncQueueValue= function (func,value) {
    //var val={func:processFunc, value:null};
    if (UI.funcQueue.length > 0) {
        for(var a in UI.funcQueue)
        {
            if(UI.funcQueue[a]&&
                !!UI.funcQueue[a].func&&
                !!UI.funcQueue[a].value&&
                UI.funcQueue[a].func==func&&
                UI.funcQueue[a].value==value){
                return true;
            }
        }
    }
    return false;
};

//0:no UI 1:
UI.setOsdShowType = function(flag) {

    var liveTV = window['liveTV'];
    var videoPlayer = UI.getItem( window['hiMedia'], 'videoPlayer');
    var volumeBar = UI.getItem(UI.base.ghostModule, 'volumeCtrl');
    var currSubModule = UI.getCurrSubModule();

    if (flag == 0 &&
        ((liveTV&&liveTV.isInfobarOpened&&liveTV.isInfobarOpened() ||
        videoPlayer&&videoPlayer.isMediaOsdShow&&videoPlayer.isMediaOsdShow() ||
        volumeBar&&volumeBar.isVolumBarShow&&volumeBar.isVolumBarShow()) ||
        (currSubModule&&!currSubModule.noAutoMemcControl&&currSubModule.name != 'blank')
        )
    )
    {
        flag = 1;
    }

    if (UI.osdFlag != flag) {
        DBG_ERROR("setOsdShowType:" + flag);
        Config.tv && model.message.setUIVisible(flag);
        UI.osdFlag = flag;
    }

    if (checkIsAppOn()) {
        if (UI.osdFlag == 0 && UI.base.loading.alpha == 0) {
            createjs.Ticker.reset();
        } else {
            createjs.Ticker.init();
        }
    } else {
        if (createjs.Ticker._inited == false) {
            createjs.Ticker.init();
        }
    }

};

UI.showKeyBoard = function(value, position, maxLength, viewType, workType, callback) {
    UI.inactiveKey();
    if (Config.tv) {
        UI.isSoftKeyBoard = true;
    } else {
        UI.inactiveKey();
        document.onkeydown = UI.onKeyBoardForSoft;
        UI.isSoftKeyBoard = true;
    }
    var curLang;
    DBG_INFO("GLOBAL.CURRENT_LANGUAGE :"+GLOBAL.CURRENT_LANGUAGE);
    switch(GLOBAL.CURRENT_LANGUAGE) {
        case "per" : //波斯语
            curLang = "FAS";
            break;
        case "hbr" : //希伯来语hbr
            curLang = "HEB";
            break;
        case "mal" : //马来语
            curLang = "MSA";
            break;
        case "ger" : //德语
            curLang = "DEU";
            break;
        case "cze" : //捷克
            curLang = "CES";
            break;
        case "bur" : //缅甸语
            curLang = "MYA";
            break;
        case "fre":
            curLang = "FRA";
            break;
        default : //其他
            curLang = GLOBAL.CURRENT_LANGUAGE.toUpperCase();
    }
    DBG_INFO("curLang :"+curLang);

    if (!GLOBAL.SOFTKEYBOAD_INITED) {
        $LAB.script("keyboard/js/constances.js")
            .script("keyboard/js/debug.js")
            .script("keyboard/js/api/cache.js")
            .script("keyboard/js/api/json.js")
            .script("keyboard/js/api/view.js")
            .script("keyboard/js/tools.js")
            .script("keyboard/js/strings.js")
            .script("keyboard/js/html.js")
            .script("keyboard/js/native.js")
            .script("keyboard/js/config.js")
            .script("keyboard/js/keyboard.js")
            .script("keyboard/js/iqqi.js")
            .script("keyboard/js/invoke.js")
            .wait(function(){
                startIQQI.call({
                    "value":value,
                    "position":position,
                    "maxLength":maxLength,
                    "curLang": curLang,
                    "curMode": 0,
                    "viewType": viewType,//inputTxt.showPwd ? "password" : "text",
                    "workType": workType,//inputTxt.isPwd ? "password" : "text",
                    "curMarket": GLOBAL.CURRENT_AREA,
                    "curArea": GLOBAL.CURRENT_SUB_AREA,
                    "callback": function() {
                        if (Config.tv) {
                            UI.isSoftKeyBoard = false;
                        } else {
                            document.onkeydown = UI.onKeyBoard;
                        }
                        UI.updateStage();
                        UI.activeKey();
                        if (callback){
                            callback(this.value);
                        }
                    }
                });
            });
        GLOBAL.SOFTKEYBOAD_INITED = true;
    } else {
        startIQQI.call({
            "value":value,
            "position":position,
            "maxLength":maxLength,
            "curLang": curLang,
            "curMode": 0,
            "viewType": viewType,//inputTxt.showPwd ? "password" : "text",
            "workType": workType,//inputTxt.isPwd ? "password" : "text",
            "curMarket": GLOBAL.CURRENT_AREA,
            "curArea": GLOBAL.CURRENT_SUB_AREA,
            "callback": function() {
                if (Config.tv) {
                    UI.isSoftKeyBoard = false;
                } else {
                    document.onkeydown = UI.onKeyBoard;
                }
                UI.updateStage();
                UI.activeKey();
                if (callback){
                    callback(this.value);
                }
            }
        });
    }
};

function processKeyOnPC(code) {
    UI._callBubble(UI.getCurrSubModule().currFocus, "onkey_" + CONST.KEYVALUE_MAP[code], UI.getCurrSubModule().currFocus, null);
}

UI.send_key_to_dfb=function(keycode){
    DBG_ERROR("send key to dfb : " + keycode);
    try {
        // UI.guiService.sendkeytodfb(keycode);
        model.system.setKeyToDfb(keycode);
    }
    catch (ex) {
        DBG_ERROR("send key to dfb error : " + ex.message);
    }
};

UI.playPad_Status = function(flag){
    DBG_INFO("pause_flag is: " + flag);
    if(APPMODULE.LayoutToast == "LayoutToast"){
        var LayoutToast = UI.getGhostModule("LayoutToast");
        LayoutToast.changePlayStatus(flag);
    }
};

UI.getPageStrs = function (text, str, width, pageLines, breakWords) {
    var splitter;
    var space;
    var tempStr = str;

    switch (GLOBAL.CURRENT_LANGUAGE) {
        case "chi":
            splitter = '';
            space = '';
            break;
        case "tha":
            splitter = '#';
            space = '';
            tempStr = tempStr.split('#').join("");
            break;
        default :
        {
            splitter = ' ';
            space = ' ';

            break;
        }
    }


    var finalStrs = [];
    str=str.replace(/[\r]/g,"").replace(/\n/g," \n ");
    var words = str.split(splitter);
    var lines = 0;
    var lastStr = "";
    tempStr = "";
    var segStr = "";

    for (var i = 0; i < words.length; i++) {
        lastStr = tempStr;
        tempStr += words[i] + space;
        if (TextMeasurer.measure(tempStr, text) > width|| words[i]=="\n") {
            lines++;
            if (lines >= pageLines) {
                if( words[i]=="\n"){
                    segStr += tempStr;
                    finalStrs.push(segStr);
                    lines = 0;
                    segStr = "";
                    tempStr = "";
                }
                else {
                    segStr += lastStr;
                    finalStrs.push(segStr);
                    lines = 0;
                    segStr = "";
                    tempStr = "";
                    tempStr += words[i] + space;
                }

            } else {
                if( words[i]=="\n"){
                    segStr += tempStr;
                    tempStr = "";
                }
                else {
                    segStr += lastStr;
                    tempStr = "";
                    tempStr += words[i] + space;
                }

            }
            if (breakWords) {
                tempStr = "";

                if (TextMeasurer.measure(words[i], text) > width) {
                    if (breakWords) {
                        words[i]=words[i].replace(/[\r]/g,"").replace(/\n/g,"                 ");
                    }
                    var characters = words[i].split('');
                    for (var c = 0; c < characters.length; c++) {
                        lastStr = tempStr;
                        tempStr += characters[c];
                        if (TextMeasurer.measure(tempStr, text) > width) {
                            lines++;
                            if (lines >= pageLines) {
                                segStr += lastStr + '\n';
                                finalStrs.push(segStr);
                                lines = 0;
                                segStr = "";
                                tempStr = "";
                                tempStr += characters[c] + space;
                            } else {
                                //segStr += tempStr;
                                segStr += lastStr + '\n';
                                tempStr = "";
                                tempStr += characters[c] + space;
                            }
                        }
                    }
                }

            }

        }
    }

    if (segStr.length > 0||tempStr.length>0) {
        if( tempStr.length>0)
        {
            segStr+=tempStr;
        }
        finalStrs.push(segStr);
    }

    return finalStrs;
};







DBG_INFO("UI.js end " + debugRunTime());
