/**
 * Created by yangcheng3 on 2017-11-21.
 * public functions for Amazon Alexa
 */

/**
 * AVS public interface
 */
Alexa_globalKeys = [
    CONST.KEY.VK_NETFLIX, CONST.KEY.VK_VUDU, CONST.KEY.VK_YOUTUBE, CONST.KEY.VK_AMAZON,
    CONST.KEY.VK_LAUNCHER, CONST.KEY.VK_MENU, CONST.KEY.VK_SETTINGS, CONST.KEY.VK_VOICE,
    CONST.KEY.VK_VOICE_DOWN, CONST.KEY.VK_VOICE_UP
];
var AVSClient = {};
(function (self) {
    //add AVSClient object
    if (!self) {
        window.AVSClient = {};
        self = window.AVSClient;
    }
    /**
     * AVSClient enum directive namespaces
     */
    self.DIRECTIVE_NAMESPACE = {
        TEMPLATERUNTIME: "TemplateRuntime",
        AUDIOPLAYER: "AudioPlayer",
        SPEAKER: "Speaker"
    };
    /**
     * AVSClient enum template names
     */
    self.TEMPLATE_NAME = {
        BODYTEMPLATE1: "BodyTemplate1",
        BODYTEMPLATE2: "BodyTemplate2",
        LISTTEMPLATE1: "ListTemplate1",
        WEATHERTEMPLATE: "WeatherTemplate"
    };

    /**
     * AVSClient enum image sizes
     */
    self.IMAGE_SIZE = {
        XSMALL: "X-SMALL",
        SMALL: "SMALL",
        MEDIUM: "MEDIUM",
        LARGE: "LARGE",
        XLARGE: "X-LARGE"
    };

//*******************audioPlayer part************************
    /**
     * interface for playing music
     */
    self.audioPlayer = {
        /**
         * show alexa music card
         * @private
         */
        _showPlayer: function () {
            //reset the flags
            self.audioPlayer.player_is_ready = false;
            self.audioPlayer.music_card_is_ready = false;
            UI.popAllModule();
            DBG_ERROR("notify to start Alexa music player");
            startThirdPartyApp(APPNAME.ALEXAMNUSIC, null, CMDType.HISENSEPAGE, CMDMethod.COMMANDURL, false);
            self.logReport.reportSuccess(self.logReport.CONST.NAMESPACE_PLAYER, self.logReport.CONST.NAME_MUSIC);

        },
        closePlayer: function () {
            if (checkIsAppOn() && appControl.getCurrentAPPName() == "AlexaMusic") {
                appControl.stopCurrentApp();
            }
        },
        /**
         * check the alexa music card is running
         * @returns {boolean}
         */
        checkPlayerIsRunning: function () {
            return checkIsAppOn() && appControl.getCurrentAPPName() === "AlexaMusic";
        },
        playerDTemp: "",
        renderPlayerInfoDTemp: "",
        isAlexaMusicExist: false,
        msgToAudioPlayer: {
            key: {
                voiceKeyDown: {
                    keyEvent: "voice_key_down"
                },
                voiceKeyUp: {
                    keyEvent: "voice_key_up"
                }
            }
        }
    };
    self.audioPlayer.onReceiveMessage = function (data) {
        if (!data || data.length == 0) {
            return;
        }
        var obj = JSON.parse(data);
        if (!!self[obj.name] && typeof self[obj.name]["_" + obj.directive] === "function") {
            self[obj.name]["_" + obj.directive](obj.param);
        }
    };
    self.audioPlayer._onInit = function () {
        self.audioPlayer.isAlexaMusicExist = true;
        if (self.audioPlayer.playerDTemp.length) {
            DBG_INFO("playerDirectiveTemp is: " + self.audioPlayer.playerDTemp);
            AvsMusic.sendJsonMessage(self.audioPlayer.playerDTemp);
            self.audioPlayer.playerDTemp = "";
        }
        if (self.audioPlayer.renderPlayerInfoDTemp.length) {
            DBG_INFO("renderPlayerInfoDirectiveTemp is: " + self.audioPlayer.renderPlayerInfoDTemp);
            AvsMusic.sendJsonMessage(self.audioPlayer.renderPlayerInfoDTemp);
            self.audioPlayer.renderPlayerInfoDTemp = "";
        }
    };
    self.audioPlayer._onClose = function () {
        DBG_ALWAYS("receive close msg");
        self.audioPlayer.closePlayer();
    };
    try {
        AvsMusic.init(0);
        AvsMusic.addEventListener("message", function (data) {
            self.audioPlayer.onReceiveMessage(data);
        });
    } catch (e) {
        DBG_ALWAYS("failed to AvsMusic.init(0): " + e.message);
    }
    /**
     * notify the audio player directive is coming
     */
    self.audioPlayer.notifyMusicPlay = function (template_info) {
        if (self.audioPlayer.checkPlayerIsRunning()) {
            try {
                if (self.audioPlayer.isAlexaMusicExist) {
                    DBG_INFO("send play directive to player: " + objToString(template_info));
                    AvsMusic.sendJsonMessage(objToString(template_info));
                } else {
                    DBG_INFO("AlexaMusic is not exist, store play");
                    self.audioPlayer.playerDTemp = objToString(template_info);
                }
            } catch (e) {
                DBG_ALWAYS("AvsMusic.sendJsonMessage failed to send play directive: " + e.message);
            }
            return;
        }
        DBG_INFO("audioPlayer.notifyMusicPlay");
        if (JSON.parse(template_info).directive.header.name !== "Play") {
            DBG_ERROR("error directive, do not start player");
            return;
        }
        writeFileToNative("launcher/alexa_music_play", objToString(template_info), 1);
        self.audioPlayer.isAlexaMusicExist = false;
        self.audioPlayer._showPlayer();
    };
    /**
     * notify pages to show the music player
     * @param template_info the page info
     */
    self.audioPlayer.notifyMusicCard = function (template_info) {
        if (self.audioPlayer.checkPlayerIsRunning()) {
            try {
                if (self.audioPlayer.isAlexaMusicExist) {
                    DBG_INFO("send renderPlayerInfo directive to player: " + objToString(template_info));
                    AvsMusic.sendJsonMessage(objToString(template_info));
                } else {
                    DBG_INFO("AlexaMusic is not exist, store renderPlayerInfo");
                    self.audioPlayer.renderPlayerInfoDTemp = objToString(template_info);
                }
            } catch (e) {
                DBG_ALWAYS("AvsMusic.sendJsonMessage failed to send RenderPlayerInfo directive: " + e.message);
            }
            return;
        }
        DBG_INFO("audioPlayer.notifyMusicCard ");
        writeFileToNative("launcher/alexa_music_card", objToString(template_info), 1);
    };
//*****************audioPlayer part end**********************

//*********************register part*************************
    /**
     * interface for amazon register process
     */
    self.register = {};
    /**
     *
     * @param type {string} "amazon" or "hisense"
     * @param callback
     */
    self.register.getRegisterInfo = function (type) {
        if (type === "amazon") {
            self.model.setControlType(AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_GET_AUTH_CODE);
        } else if (type === "hisense") {
            self.register.onHisenseAuthInfoReceived = function (str) {
                var info = JSON.parse(str);
                var register_url = "";
                var register_code = "";
                var register_expire_time = 0;
                if (!!info) {
                    register_url = info.authUrl;
                    register_code = info.dynAuthCode;
                    register_expire_time = parseInt(info.expiredTime);
                }
                UIObserver.publishMessage(UIObserver.MESSAGE_NAME.AVS_ONHISMESSAGECHANGED, register_url, register_code, register_expire_time);
            };
            self.model.setControlType(AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_HIAVS_GET_AUTH_INFO);
        } else {
            DBG_ERROR("error type = " + type);
            callback();
        }
    };
    self.register.onAuthInfoReceived = function () {

    };
    self.register.onHisenseAuthInfoReceived = function () {

    };

    self.register.cancelRegister = function () {
        self.model.setControlType(AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_CANCEL_AUTH_CODE)
    };
    /**
     * get the register status of the device
     * api for pages
     */
    self.register.getRegisterStatus = function (type) {
        var ret = 100;  //error status
        if (type === "amazon") {
            ret = self.model.getLoginStatus();
        } else if (type === "hisense") {
            ret = self.model.getHisLoginStatus();
        }
        //error status, get login status failed
        if (ret == 100) {
            DBG_ERROR("getRegisterStatus[" + type + "] error, update status again");
            self.register.updateRegisterStatus(type);
        }
        return ret;
    };
    self.register.updateRegisterStatus = function (type) {
        if (type === "amazon") {
            self.model.setControlType(AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_GET_LOGIN_STATUS);
        } else if (type === "hisense") {
            self.model.setControlType(AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_HIAVS_GET_LOGIN_STATUS);
        }
    };
    self.register.onLoginStatusReceived = function (status) {
        DBG_INFO("AVSClient.register.onLoginStatusReceived status=" + status);
    };
    self.register.onHisLoginStatusReceived = function (status) {
        DBG_INFO("AVSClient.register.onHisLoginStatusReceived status=" + status);
    };
    /**
     * get mail address
     * @param type amazon or hisense
     * @param callback
     */
    self.register.getUserProfile = function (type, callback) {
        if (type === "amazon") {
            self.register.onUserProfileReceived = callback;
            self.model.setControlType(AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_GET_USER_PROFILE);
        } else if (type === "hisense") {
            self.register.onHisUserProfileReceived = callback;
            self.model.setControlType(AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_HIAVS_GET_USER_PROFILE);
        } else {
            if (typeof callback === "function") {
                callback();
            }
        }
    };
    self.register.onUserProfileReceived = function () {

    };
    self.register.onHisUserProfileReceived = function () {

    };
    /**
     * logout
     * @param type amazon or hisense
     */
    self.register.logout = function (type) {
        if (!(self.register.getRegisterStatus(type) == 1)) {
            DBG_ERROR("self.register.logout err, [" + type + "] is not login");
            return;
        }
        if (type === "amazon") {
            self.model.setControlType(AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_LOGOUT);
            setTimeout(self.audioPlayer.closePlayer, 500);
        } else if (type === "hisense") {
            Hiwebsocket.disconnect();
            self.model.setControlType(AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_HIAVS_LOGOUT);
        } else {
            DBG_ERROR("self.register.logout error type=" + type)
        }
        self.register.updateRegisterStatus(type);
    };
    /**
     * notify pages the register result message
     * @param result 1(success)
     */
    self.register.onRegisterResult = function (result) {
        DBG_INFO("AVSClient.register.onRegisterResult result = " + result);
        self.register.updateRegisterStatus("amazon");
        UIObserver.publishMessage(UIObserver.MESSAGE_NAME.AVS_ONAMAZONREGISTERRESULT, result);
    };
    self.register.onHisRegisterResult = function (result) {
        DBG_INFO("AVSClient.register.onHisRegisterResult result = " + result);
        self.register.updateRegisterStatus("hisense");
        UIObserver.publishMessage(UIObserver.MESSAGE_NAME.AVS_ONHISENSEREGISTERRESULT, result);
    };

    self.register.reportDeviceName = function (name, force) {
        if (self.model.getHisLoginStatus() != 1) {
            DBG_ERROR("[reportDeviceName] hisense is not registered");
            return;
        }
        if (!force) {
            self.model.setControlType(AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_HIAVS_REPORT_TV_NAME, name);
        } else {
            self.model.setControlType(AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_ACTION_TYPE_REPLACE_DEVICE, name);
        }

    };
    self.register.onHisDeviceReportResult = function (result) {
        DBG_INFO("AVSClient.register.onHisDeviceReportResult result = " + result);
        if (result == 0) {
            self.register.setIsReplaced(false);
        }
        UIObserver.publishMessage(UIObserver.MESSAGE_NAME.AVS_ONHISENSEDEVICEREPORTRESULT, result);
    };


    self.register.setIsReplaced = function (flag) {
        DBG_INFO("register.setIsReplaced: flag is " + flag);
        if (!!localStorage) {
            localStorage.setItem("avs_replaced", !!flag ? "1" : "0");
        }
    };
    self.register.getIsReplaced = function () {
        var flag = false;
        if (!!localStorage) {
            flag = localStorage.getItem("avs_replaced");
        }
        DBG_INFO("register.getIsReplaced: flag is " + flag);
        return !!parseInt(flag);
    };
    self.register.getResetPasswordUrl = function (callback) {
        self.register.onGetResetPasswordUrl = callback;
        self.model.setControlType(AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_ACTION_TYPE_FORGET_PASSWORD);
    };
    self.register.onGetResetPasswordUrl = null;
    self.register.enablePcoSkill = function(){
        self.model.setControlType(AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_ACTION_TYPE_PCO_ENABLE_SKILL);
    };
    self.register.resetPcoSkill = function(){
        self.model.setControlType(AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_ACTION_TYPE_PCO_RESET_SKILL);
    };



    self.register.getLanguageList = function(){
        try{
            if (isFileExist("hiAvsService/alexaLanList.json", 1)) {
                DBG_ERROR("language file exist ");
                var tvSideLangList = readFileFromNative("hiAvsService/alexaLanList.json", 1);
                if(!tv){
                    tvSideLangList =  {
                        "defaultLanguage":      {
                            "languageDesc": "English(United States)",
                            "languageId":   1,
                            "memo": " ",
                            "statCode":     "USA"
                        },
                        "languageList": [{
                            "languageDesc": "English(United States)",
                            "languageId":   1,
                            "locale":       "en-US",
                            "memo": " ",
                            "statCode":     "USA"
                        }, {
                            "languageDesc": "English(Canada)",
                            "languageId":   1,
                            "locale":       "en-CA",
                            "memo": " ",
                            "statCode":     "CAN"
                        },{
                            "languageDesc": "English(Canada)",
                            "languageId":   1,
                            "locale":       "en-CA",
                            "memo": " ",
                            "statCode":     "CAN"
                        },{
                            "languageDesc": "English(Canada)",
                            "languageId":   1,
                            "locale":       "en-CA",
                            "memo": " ",
                            "statCode":     "CAN"
                        },{
                            "languageDesc": "English(Canada)",
                            "languageId":   1,
                            "locale":       "en-CA",
                            "memo": " ",
                            "statCode":     "CAN"
                        }/*,{
                            "languageDesc": "English(Canada)",
                            "languageId":   1,
                            "locale":       "en-CA",
                            "memo": " ",
                            "statCode":     "CAN"
                        },{
                            "languageDesc": "English(Canada)",
                            "languageId":   1,
                            "locale":       "en-CA",
                            "memo": " ",
                            "statCode":     "CAN"
                        }*/],
                        "resultCode":   0,
                        "updatetimeStamp":      1524032385
                    }
                }
                DBG_ERROR("languageList is " + objToString(tvSideLangList));
                DBG_ERROR(tvSideLangList);
                var avsLangSource = [];
                var avsLanguageList = tvSideLangList;
                var type = typeof tvSideLangList;
                if (type == "string") {
                    DBG_INFO("tvSideLangList is a string");
                    try{
                        avsLanguageList = JSON.parse(tvSideLangList);
                    }catch(e){
                        DBG_ERROR("failed to parse msg");
                    }
                }
                for(var i = 0 ; i < avsLanguageList.languageList.length ; i++ ){
                    avsLangSource.push({
                        languageDesc:avsLanguageList.languageList[i].languageDesc,
                        locale:avsLanguageList.languageList[i].locale
                    })
                }
                DBG_ERROR("avsLangSource is " + objToString(avsLangSource));
                return avsLangSource;
            }else{
                DBG_ERROR("file  not exist ");
            }
        }catch(ex){
            DBG_ERROR(ex.message);
        }
    };
    self.register.getAlexaLanguageCode = function(){
        if (Config.tv) {
            try {
                self.model.setControlType(AvsModelDefines.TV_API_AVS_CTRL_ACTION_TYPE_GET_LANG_LOCALE);
            } catch (ex) {
                DBG_ERROR("self.register.getSalesSupportInfo = " + ex.message);
            }
        }else{
            DBG_ERROR("NOT TV");
        }
    };
    self.register.setAlexaLanguageCode = function(str){
        if (Config.tv) {
            try {
                self.model.setControlType(AvsModelDefines.TV_API_AVS_CTRL_ACTION_TYPE_SET_LANG_LOCAL, str);
            } catch (ex) {
                DBG_ERROR("model.avs.setAlexaLanguageCode = " + ex.message);
            }
        }
    };
    self.register.onAlexaCurLanguageChanged = function(){
    };

//*******************register part end***********************

//*****************renderDisplayCard part********************
    /**
     * interface to show display card
     */
    self.renderDisplayCard = {};
    /**
     * notify pages to show display card
     * @param template_info the content in display card
     */
    self.renderDisplayCard.notifyShowDisplayCard = function (template_info) {
        //TODO: need to push submodule of display card
        if (UI.isLoadingModule) {
            DBG_ERROR("submodule is loading, ignore this msg");
            return;
        }
        clearTimeout(avsIdleTimeout);
        var sub_name = UI.getCurrSubModule().name;
        if (sub_name == "bodyTemplate1"
            || sub_name == "bodyTemplate2"
            || sub_name == "listTemplate"
            || sub_name == "weatherTemplate") {
            UI.popSubModule();
        }
        var module_name = UI.getCurrModule().name;
        if (module_name == "launcher"
            || module_name == "setting") {
            if (!!window[module_name]) {
                window[module_name].popSelf(true);
            }
        }
        liveTV.clearLiveTVStandby();
        switch (template_info.type) {
            case self.TEMPLATE_NAME.BODYTEMPLATE1:
                UI.pushSubModule("Alexa", "bodyTemplate1", true, template_info);
                self.logReport.reportSuccess(self.logReport.CONST.NAMESPACE_TEMPLATE, self.logReport.CONST.NAME_TEMPLATE1);
                break;
            case self.TEMPLATE_NAME.BODYTEMPLATE2:
                UI.pushSubModule("Alexa", "bodyTemplate2", true, template_info);
                self.logReport.reportSuccess(self.logReport.CONST.NAMESPACE_TEMPLATE, self.logReport.CONST.NAME_TEMPLATE2);
                break;
            case self.TEMPLATE_NAME.LISTTEMPLATE1:
                UI.pushSubModule("Alexa", "listTemplate", true, template_info);
                self.logReport.reportSuccess(self.logReport.CONST.NAMESPACE_TEMPLATE, self.logReport.CONST.NAME_LIST);
                break;
            case self.TEMPLATE_NAME.WEATHERTEMPLATE:
                UI.pushSubModule("Alexa", "weatherTemplate", true, template_info);
                self.logReport.reportSuccess(self.logReport.CONST.NAMESPACE_TEMPLATE, self.logReport.CONST.NAME_WEATHER);
                break;
            default:
                DBG_ERROR("notifyShowDisplayCard error type = " + template_info.type);
                break;
        }

    };

    /**
     * parse the Template info
     * @param json json object of Template info
     * @returns {*} Template info object
     */
    var parseTemplateInfo = function (json) {
        if (!json.directive.payload) {
            return null;
        }
        var template = {};
        template.directive = json.directive.header.name;
        if (template.directive === "RenderTemplate") {
            template.type = json.directive.payload.type;
            if (json.directive.payload.title.mainTitle) {
                template.mainTitle = json.directive.payload.title.mainTitle;
            } else {
                template.mainTitle = "";
            }
            if (json.directive.payload.title.subTitle) {
                template.subTitle = json.directive.payload.title.subTitle;
            } else {
                template.subTitle = "";
            }
            template.skillIcon = parseImageInfo(json.directive.payload.skillIcon, {
                width: 144,
                size: self.IMAGE_SIZE.XSMALL
            });
            if (json.directive.payload.textField) {
                template.textField = json.directive.payload.textField;
            } else {
                template.textField = "";
            }
            template.image = parseImageInfo(json.directive.payload.image, {width: 477, size: self.IMAGE_SIZE.SMALL});
            var item = null;
            var i = 0;
            if (template.type === self.TEMPLATE_NAME.LISTTEMPLATE1) {
                template.leftTextField = [];
                template.rightTextField = [];
                if (json.directive.payload.listItems) {
                    for (i = 0; i < json.directive.payload.listItems.length; i++) {
                        item = json.directive.payload.listItems[i];
                        template.leftTextField.push(item.leftTextField);
                        template.rightTextField.push(item.rightTextField);
                    }
                }
            } else if (template.type === self.TEMPLATE_NAME.WEATHERTEMPLATE) {
                template.currentWeather = json.directive.payload.currentWeather;
                template.description = json.directive.payload.description;
                template.currentWeatherIcon = parseImageInfo(json.directive.payload.currentWeatherIcon, {
                    width: 477,
                    size: self.IMAGE_SIZE.SMALL
                });
                if (json.directive.payload.highTemperature) {
                    template.highTemperature = {
                        value: json.directive.payload.highTemperature.value,
                        arrow: parseImageInfo(json.directive.payload.highTemperature.arrow)
                    };
                }
                if (json.directive.payload.lowTemperature) {
                    template.lowTemperature = {
                        value: json.directive.payload.lowTemperature.value,
                        arrow: parseImageInfo(json.directive.payload.lowTemperature.arrow)
                    };
                }
                template.weatherForecast = [];
                if (json.directive.payload.weatherForecast) {
                    for (i = 0; i < json.directive.payload.weatherForecast.length; i++) {
                        item = json.directive.payload.weatherForecast[i];
                        template.weatherForecast.push({
                            date: item.date,
                            day: item.day,
                            highTemperature: item.highTemperature,
                            lowTemperature: item.lowTemperature,
                            image: parseImageInfo(item.image)
                        });
                    }
                }

            }
        } else if (template.directive === "RenderPlayerInfo") {
            //do nothing here
        }

        return template;
    };
    /**
     * parse the image url
     * @param imageInfo image list
     * @param options
     * @returns {string} image url
     */
    var parseImageInfo = function (imageInfo, options) {
        if (!imageInfo || !imageInfo.sources) {
            return "";
        }
        options = options || {size: self.IMAGE_SIZE.MEDIUM};
        if (!options.size) {
            options.size = self.IMAGE_SIZE.MEDIUM;
        }
        var image_url = "";
        var images = imageInfo.sources;
        var size_dst = 1000;
        for (var i = 0; i < images.length; i++) {
            if (!images[i]) {
                continue;
            }
            if (options.width && images[i].widthPixels) {
                var dst = Math.abs(options.width - images[i].widthPixels);
                if (size_dst > dst) {
                    size_dst = dst;
                    image_url = images[i].url;
                }
            } else if (options.size === images[i].size) {
                image_url = images[i].url;
                break;
            }
        }
        return image_url;
    };
//***************renderDisplayCard part end******************

//**********************setting part*************************
    /**
     * interface for menu settings
     */
    self.setting = {};
    self.setting.setEnabled = function (flag) {
        if (!flag) {
            Hiwebsocket.disconnect();
            setTimeout(self.audioPlayer.closePlayer, 500);
        }
        self.model.setAlexaEnable(flag);
        // if (self.model.getHisLoginStatus() == 1) {
        //     self.model.setControlType(AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_HIAVS_REPORT_ENABLE_FLAG, !!flag ? 1 : 0);
        // }
    };
    self.setting.getEnabled = function () {
        return self.model.getAlexaEnable();
    };
    self.setting.notifyNetworkChanged = function (flag) {
        self.model.setControlType(AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_NOTIFY_NET_STATUS, flag);
        AvsMusic.sendJsonMessage(JSON.stringify({network: !!flag ? "connect" : "disconnect"}));
    };
    self.setting.syncStatus = function () {
        self.model.setControlType(AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_HIAVS_GET_SERVICE_INFO);
    };
    self.setting.syncVoiceSupportType = function () {
        try {
            var voiceControl = model.avs.getVoiceControl();
            // 0: none
            // 1: only support avg
            // 2: only support avs
            // 3: support avg & avs
            DBG_ERROR("AVSClient.setting.syncVoiceSupportType:" + voiceControl);
            if (voiceControl % 2 === 1) {
                avg_support = true
            }
            if (Math.floor(voiceControl / 2) === 1) {
                avs_support = true;
            }
            var avsCountryList = AVSClient.register.getCountryList();
            if( _getIndex(avsCountryList, GLOBAL.CURRENT_COUNTRY) == -1){
                avg_support = false;
                avs_support = false;
            }
        } catch (ex) {
            DBG_ERROR("AVSClient.setting.syncVoiceSupportType err:" + ex.message);
        }
    }
    self.setting.supportAvsCountry = function(cou){
        try {
            var avsCountryList = AVSClient.register.getCountryList();
            //var avsCountryList = ["USA","CAN","PRI"];
            if(_getIndex(avsCountryList, cou) == -1){
                return false;
            }
            else{
                return true;
            }
        } catch (ex) {
            DBG_ERROR("self.setting.supportAvsCountry err:" + ex.message);
            return false;
        }
    };
    self.register.getCountryList = function(){
        var avsCountrySource = [];
        try{
            if(isFileExist("hiAvsService/alexaCouList.json",1)){
                DBG_ERROR("tvSideCountryList file exist");
                var tvSideCountryList = readFileFromNative("hiAvsService/alexaCouList.json", 1);
                if(!tv){
                    tvSideCountryList = {
                        "resultCode" : 0,
                        "statList" : [
                            {
                                "languageId" : 1,
                                "languageName" : "English",
                                "statCode" : "CAN",
                                "statName" : "加拿大",
                                "suffix" : "ca"
                            },
                            {
                                "languageId" : 1,
                                "languageName" : "English",
                                "statCode" : "USA",
                                "statName" : "美国",
                                "suffix" : "us"
                            },
                            {
                                "languageId" : 1,
                                "languageName" : "English",
                                "statCode" : "USA",
                                "statName" : "美国",
                                "suffix" : "us"
                            }
                        ],
                        "updatetimeStamp" : 1523865479
                    }
                }
                DBG_ERROR("tvSideCountryList is " + objToString(tvSideCountryList));
                if(null == tvSideCountryList){
                    DBG_ERROR("tvSideCountryList file is null");
                    avsCountrySource = [];
                    return avsCountrySource;
                }
                var avsCountryList = tvSideCountryList;
                var type = typeof tvSideCountryList;
                if(type == "string"){
                    DBG_INFO("tvSideLangList is a string");
                    try{
                        avsCountryList = JSON.parse(tvSideCountryList);
                    }catch(e){
                        DBG_ERROR("failed to parse msg");
                    }
                }
                for(var i = 0; i < avsCountryList.statList.length; i++){
                    avsCountrySource.push(avsCountryList.statList[i].statCode);
                }
                DBG_ERROR("avsCountryList is" + objToString(avsCountryList));
                return avsCountrySource;
            }else{
                DBG_ERROR("tvSideCountryList file  not exist ");
                avsCountrySource = [];
                return avsCountrySource;
            }
        }catch (e) {
            DBG_ERROR(ex.message);
            avsCountrySource = [];
            return avsCountrySource;
        }
    }
//********************setting part end***********************

//***********************speech part*************************
    /**
     * interface for speech control
     */
    self.speech = {};
    self.speech._isShown = function () {
        var ret = UI.getGhostModule("voiceService");
        AvsMusic.sendJsonMessage(JSON.stringify({voiceChrome: !!ret ? "show" : "hide"}));

    };
    self.speech.notifyOtherModuleChromeShown = function () {
        try {
            //notify music card
            AvsMusic.sendJsonMessage(JSON.stringify({voiceChrome: "show"}));
            //notify sound model to mute
            model.sound.setMuteByDecFlag(1);
        } catch (ex) {
            DBG_ERROR("AVSClient notifyOtherModuleChromeShown: ex=" + ex.message);
        }
    };
    self.speech.notifyOtherModuleChromeHiden = function () {
        try {
            //notify music card
            AvsMusic.sendJsonMessage(JSON.stringify({voiceChrome: "hide"}));
            //notify sound model to unmute
            model.sound.setMuteByDecFlag(0);
        } catch (ex) {
            DBG_ERROR("AVSClient notifyOtherModuleChromeHiden: ex=" + ex.message);
        }
    };
    /**
     * play the speech
     * api for pages
     */
    self.speech.play = function () {
        self.model.setControlType(AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_START);
    };
    /**
     * stop the speech
     * api for pages
     */
    self.speech.stop = function () {
        self.model.setControlType(AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_STOP);
    };
    /**
     * cancel the speech
     * api for pages
     */
    self.speech.cancel = function () {
        self.model.setControlType(AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_CANCEL);
    };
    /**
     * cancel the speech
     * api for pages
     */
    self.speech.cancelAlarm = function () {
        self.model.setControlType(AvsModelDefines.ENUM_SL2_TVAPI_AVS_CTRL_TYPE_CANCEL_ALARM);
    };
    /**
     * notify voice chrome the speech status changed
     * @param state
     */
    var avsIdleTimeout = null;
    self.speech.onSpeechStateChanged = function (state) {
        DBG_INFO("AVSClient.speech.onSpeechStateChanged state = " + state);
        switch (state) {
            case AvsModelDefines.ENUM_SL2_TVAPI_AVS_RECOG_STATE_IDLE:
                if (!!UI.getGhostModule("voiceService")) {
                    UI.popGhostModule("voiceService");
                }
                clearTimeout(avsIdleTimeout);
                avsIdleTimeout = setTimeout(function(){
                    var sub_name = UI.getCurrSubModule().name;
                    if (sub_name == "bodyTemplate1"
                        || sub_name == "bodyTemplate2"
                        || sub_name == "listTemplate"
                        || sub_name == "weatherTemplate") {
                        UI.popSubModule();
                    }
                },5000);
                break;
            case -1:
                if (!!UI.getGhostModule("voiceService")) {
                    UI.popGhostModule("voiceService");
                }
                UI.clearAllSubModule("setting");
                self.register.logout("amazon");
                openMsgBoxByType(MsgBoxType.AVS_AMAZON_EXPIRED);
                self.logReport.reportFailure(self.logReport.CONST.ERR_CODE_AMAZONEXPIRED, self.logReport.CONST.ERR_TYPE_USING);
                break;
            default:
                if (!UI.getGhostModule("voiceService")) {
                    UI.pushGhostModule("Alexa", "voiceService");
                }
                UIObserver.publishMessage(UIObserver.MESSAGE_NAME.AVS_ONSPEECHSTATECHANGED, state);
                break;
        }
    };
//*********************speech part end***********************

//********************tvController part***********************
    var getEvent = function(json){
        var actualJSON = json, type = typeof json;
        if (type == "string") {
            try{
                actualJSON = JSON.parse(json);
            }catch(e){
                DBG_ERROR("failed to parse event");
            }
        }
        if (!actualJSON.notification || !actualJSON.notification.event) {
            DBG_ERROR("failed to parse elements of notification");
            return null;
        }
        return actualJSON.notification.event;
    };
    var getHeader = function (json) {
        var actualJSON = json, type = typeof json;
        if (type == "string") {
            try{
                actualJSON = JSON.parse(json);
            }catch(e){
                DBG_ERROR("failed to parse header");
            }
        }
        if (!actualJSON.directive || !actualJSON.directive.header) {
            DBG_ERROR("failed to parse elements of header");
            return null;
        }
        return actualJSON.directive.header;
    };

    var getNameSpace = function (json) {
        var actualJSON = json, type = typeof json;
        if (type == "string") {
            try{
                actualJSON = JSON.parse(json);
            }catch(e){
                DBG_ERROR("failed to parse nameSpace");
            }
        }
        if (!actualJSON.directive || !actualJSON.directive.header || !actualJSON.directive.header.namespace) {
            return null;
        }
        return actualJSON.directive.header.namespace;
    };

    var getPayload = function (json) {
        var actualJSON = json, type = typeof json;
        if (type == "string") {
            try{
                actualJSON = JSON.parse(json);
            }catch(e){
                DBG_ERROR("failed to parse payload");
            }
        }
        if (!actualJSON.directive) {
            DBG_ERROR("failed to parse elements of payload ");
            return null;
        }
        return actualJSON.directive.payload;
    };
    var isNumberOrDash = function (str) {
        for(var ilen=0; ilen<str.length; ilen++){
            if(str.charAt(ilen) < '0' || str.charAt(ilen) > '9' ) {
                if((str.charAt(ilen)!='-'))
                    return false;
            }
        }
        return true;
    };
    /**
     * interface to control the device
     */
    self.tvController = {
        derepFlag: false,  //for dereplication within a short time
        derepTimer: 0,
        tempMsg: "",
        shortTimeValue: 2000,
        AVGMute:false
    };
    /**
     * turn off TV
     * @param power_info
     */
    self.tvController.powerController = function (power_info) {
        var name = getHeader(power_info).name;
        DBG_INFO("powerController name is: " + name);
        if ("TurnOff" == name) {
            try {
                switchOffTV(1); //1: power off
            } catch (e) {
                DBG_ERROR("model.system.SwitchOffTv error: " + e.message);
            }
            self.logReport.reportSuccess(self.logReport.CONST.NAMESPACE_POWER, self.logReport.CONST.NAME_TURNOFF);
        }
    };
    /**
     * change channel
     * @param channel_info
     */
    self.tvController.channelController = function (channel_info) {
        var name = getHeader(channel_info).name;
        DBG_INFO("channelController name is: " + name);
        var payload = getPayload(channel_info);
        if ("ChangeChannel" == name) {
            if (payload.channel && payload.channel.number) {
                DBG_INFO("channel number is: " + payload.channel.number);
                try {
                    DBG_INFO("changeByChannelNumber");
                    liveTV.changeByChannelNumber(payload.channel.number);
                    self.logReport.reportSuccess(self.logReport.CONST.NAMESPACE_CHANNEL, self.logReport.CONST.NAME_CHANGECHANNEL);
                } catch (e) {
                    DBG_ERROR("failed to change channel by number: " + e.message);
                }
            } else if (payload.channelMetadata && payload.channelMetadata.name) {
                DBG_INFO("channelMetadata name is: " + payload.channelMetadata.name);
                if(isNumberOrDash(payload.channelMetadata.name)){
                    try {
                        DBG_INFO("we think the name is number"); //for example 6-1
                        liveTV.changeByChannelNumber(payload.channelMetadata.name);
                        self.logReport.reportSuccess(self.logReport.CONST.NAMESPACE_CHANNEL, self.logReport.CONST.NAME_CHANGECHANNEL);
                    } catch (e) {
                        DBG_ERROR("failed to change channel by number: " + e.message);
                    }
                }else{
                    try {
                        DBG_INFO("changeChannelByName");
                        liveTV.changeChannelByName(payload.channelMetadata.name);
                        self.logReport.reportSuccess(self.logReport.CONST.NAMESPACE_CHANNEL, self.logReport.CONST.NAME_CHANGECHANNEL);
                    } catch (e) {
                        DBG_ERROR("failed to change channel by name: " + e.message);
                    }
                }
            } else {
                DBG_ERROR("callSign  affiliateCallSign  uri are not supported");
                return;
            }
        } else if ("SkipChannels" == name) {
            if (payload.channelCount) {
                DBG_ERROR("channel count is: " + payload.channelCount);
                liveTV.jumpOver(payload.channelCount);
                self.logReport.reportSuccess(self.logReport.CONST.NAMESPACE_CHANNEL, self.logReport.CONST.NAME_SKIPCHANNELS);
            }
        }
    };
    /**
     * change input source
     * @param inputSource_info
     */
    self.tvController.inputController = function (inputSource_info) {
        var name = getHeader(inputSource_info).name;
        DBG_INFO("inputController name is: " + name);
        if ("SelectInput" == name) {
            var uid = -1;
            var input = getPayload(inputSource_info).input.toLowerCase().replace(/[^a-z0-9]/g, ""); //first to lowerCase and then extract a-z and 0-9
            DBG_INFO("input is: " + input);
            if (input.indexOf("anyviewcast") >= 0) {
                DBG_ALWAYS("switch to any view cast: " + input);
                startAnyViewCastByVoice();
                return;
            }
            if (input.indexOf("xumo") >= 0) {
                DBG_ALWAYS("switch to xumo: " + input);
                startOttByVoice(input);
                return;
            }
            var inputsData = initAllInputsData();
            var renameTemp = "";
            for (var i = 0; i < inputsData.sourceList.length; i++) {
                renameTemp = inputsData.sourceList[i].rename.toLowerCase().replace(/[^a-z0-9]/g, "");//first to lowerCase and then extract a-z and 0-9
                DBG_ERROR("inputsData.sourceList[i].rename is: " + renameTemp);
                if (input.length == renameTemp.length) {
                    //input is"HDMI 1"  inputsData.sourceList[i].rename is "HDMI 1"
                    if (input == renameTemp) {
                        uid = inputsData.sourceList[i].id;
                    }
                } else if (input.length < renameTemp.length) {
                    //input is"HDMI 1"  inputsData.sourceList[i].rename is "HDMI 1 one"
                    if (renameTemp.indexOf(input) >= 0) {
                        uid = inputsData.sourceList[i].id;
                    }
                } else {
                    //input is"HDMI 1 one"  inputsData.sourceList[i].rename is "HDMI 1"
                    if (input.indexOf(renameTemp) >= 0) {
                        uid = inputsData.sourceList[i].id;
                    }
                }
            }
            DBG_INFO("uid is: " + uid);
            if ((uid > 7) || (uid < 0)) {
                DBG_ERROR("Do not support input source: " + input);
                return;
            }
            try {
                DBG_ERROR("inputController enter uid: " + uid);
                if (checkIsAppOn()) {
                    DBG_ERROR("app is on");
                    changeSourceTo(uid);
                    openLiveTVModule([Msg.WAIT_SOURCE_CHANGE, 1]);
                } else {
                    UI.popAllModule();
                    changeSourceTo(uid);
                    openLiveTVModule([Msg.WAIT_SOURCE_CHANGE, 1]);
                }
            } catch (e) {
                DBG_ERROR("changeSourceTo error: " + e.message);
            }
            self.logReport.reportSuccess(self.logReport.CONST.NAMESPACE_INPUT, self.logReport.CONST.NAME_SELECTINPUT);
        }
    };
    /**
     * change output source
     * @param outputSource_info
     */
    self.tvController.outputController = function (outputSource_info) {
        var name = getHeader(outputSource_info).name;
        if ("SelectOutput" == name) {
            DBG_ALWAYS("output source is not supported now");
        }
    };
    /**
     * record controller
     * @param record_info
     */
    self.tvController.recordController = function (record_info) {
        var name = getHeader(record_info).name;
        if ("StartRecording" == name) {
            //model.pvr.startRecord();  //pvr maybe not supported in NA market
        } else if ("StopRecording" == name) {
            //model.pvr.stopRecord();
        }
    };

    self.tvController.speaker = {};
    self.tvController.speaker.messageID = "";
    /**
     * change volume
     * @param volume_info
     */
    self.tvController.speaker.processVolumeDirective = function (volume_info, isAVG) {
        var name = getHeader(volume_info).name;
        DBG_INFO("speaker name is: " + name);
        var value = 0;
        self.tvController.speaker.messageID = getHeader(volume_info).messageId;
        if ("SetVolume" == name) {
            value = getPayload(volume_info).volume;
            try {
                if (value > 100) value = 100;
                DBG_INFO("volume value is: " + value);
                if (1 == model.sound.getMainMute()) {
                    DBG_ERROR("the state of TV is mute");
                    model.sound.setMainMute(0); //unmute
                }
                model.sound.setMainVolume(value);
                self.logReport.reportSuccess(self.logReport.CONST.NAMESPACE_SPEAKER, self.logReport.CONST.NAME_SETVOLUME);
            } catch (e) {
                DBG_ERROR("model.sound.setMainVolume error: " + e.message);
            }

        } else if ("AdjustVolume" == name) {
            var currentVolume = 0, lastVolume = 0;
            value = getPayload(volume_info).volume;
            try {
                //GLOBAL.SPEAKER_STATE = tv ? model.sound.getTvSpeaker() : 1;
                if (isCECByPass()) {
                    DBG_ALWAYS("AdjustVolume to ARC");
                    if (value >= 0) {
                        DBG_ALWAYS("volume up");
                        //sendKeyToCEC(CONST.KEY.VK_VOLUME_UP);
                        model.system.setKeyToDfb(guijs.SYSCMD_VOLUME_UP);
                    } else {
                        //sendKeyToCEC(CONST.KEY.VK_VOLUME_DOWN);
                        model.system.setKeyToDfb(guijs.SYSCMD_VOLUME_DOWN);
                    }
                } else {
                    DBG_ALWAYS("AdjustVolume to TV");
                    currentVolume = parseInt(model.sound.getMainVolume());
                    DBG_INFO("AdjustVolume value is: " + value);
                    DBG_INFO("currentVolume value is: " + currentVolume);
                    lastVolume = currentVolume + value;
                    if (lastVolume > 100) lastVolume = 100;
                    if (lastVolume < 0) lastVolume = 0;
                    if (1 == model.sound.getMainMute()) {
                        DBG_ERROR("the state of TV is mute");
                        model.sound.setMainMute(0); //unmute
                    }
                    model.sound.setMainVolume(lastVolume);
                }
                self.logReport.reportSuccess(self.logReport.CONST.NAMESPACE_SPEAKER, self.logReport.CONST.NAME_ADJUSTVOLUME);
            } catch (e) {
                DBG_ERROR("model.sound.setMainVolume error: " + e.message);
            }
        } else if ("SetMute" == name) {
            value = getPayload(volume_info).mute;
            try {
                DBG_INFO("SetMute value is: " + value);
                //GLOBAL.SPEAKER_STATE = tv ? model.sound.getTvSpeaker() : 1;
                if (isCECByPass()) {
                    DBG_ALWAYS("SetMute to ARC");
                    if (value) {
                        DBG_ALWAYS("SetMute to ARC mute");
                        //model.cec.sendKeyToCEC(0x65, UI.keyState); //mute   TODO maybe affect some ARC
                        if(isAVG){
                            self.tvController.AVGMute = true;
                        }
                        model.system.setKeyToDfb(guijs.SYSCMD_MUTE);
                    } else {
                        DBG_ALWAYS("SetMute to ARC unmute");
                        //model.cec.sendKeyToCEC(0x66, UI.keyState); //unmute
                        if(isAVG){
                            self.tvController.AVGMute = false;
                        }
                        model.system.setKeyToDfb(guijs.SYSCMD_MUTE);
                    }
                } else {
                    DBG_ALWAYS("SetMute to TV");
                    if (value) {
                        if(isAVG){
                            self.tvController.AVGMute = true;
                        }
                        model.sound.setMainMute(1); // mute
                    } else {
                        if(isAVG){
                            self.tvController.AVGMute = false;
                        }
                        model.sound.setMainMute(0); //unmute
                    }
                }
                self.logReport.reportSuccess(self.logReport.CONST.NAMESPACE_SPEAKER, self.logReport.CONST.NAME_SETMUTE);
            } catch (e) {
                DBG_ERROR("model.sound.setMainMute: " + e.message);
            }
        }
    };
    /**
     * volume & mute changed
     * @param event_info
     */
    self.tvController.speaker.sendEvent = function (event_info) {
        var eventJSON = {}, eventStr = "";
        eventJSON.event = {};
        eventJSON.event.header = {};
        eventJSON.event.payload = {};
        eventJSON.event.header.namespace = "Speaker";
        eventJSON.event.header.messageId = self.tvController.speaker.messageID;
        if ("MuteChanged") {
            eventJSON.event.header.name = "MuteChanged";
        } else if ("VolumeChanged") {
            eventJSON.event.header.name = "VolumeChanged";
        }
        try {
            eventJSON.event.payload.volume = parseInt(model.sound.getMainVolume());
            eventJSON.event.payload.mute = parseInt(model.sound.getMainMute());
        } catch (e) {
            DBG_ERROR("failed to get MainVolume MainMute");
        }

        eventStr = JSON.stringify(eventJSON);
    };

    self.tvController.stepSpeaker = {};
    self.tvController.stepSpeaker.processVolumeDirective = function (volume_info) {
        var name = getHeader(volume_info).name;
        DBG_INFO("stepSpeaker name is: " + name);
        var value = 0;
        if ("AdjustVolume" == name) {
            var currentVolume = 0, lastVolume = 0;
            value = getPayload(volume_info).volumeSteps;
            try {
                //GLOBAL.SPEAKER_STATE = tv ? model.sound.getTvSpeaker() : 1;
                if (isCECByPass()) {
                    DBG_ALWAYS("AdjustVolume to ARC");
                    if (value >= 0) {
                        DBG_ALWAYS("volume up");
                        //sendKeyToCEC(CONST.KEY.VK_VOLUME_UP);
                        model.system.setKeyToDfb(guijs.SYSCMD_VOLUME_UP);
                    } else {
                        //sendKeyToCEC(CONST.KEY.VK_VOLUME_DOWN);
                        model.system.setKeyToDfb(guijs.SYSCMD_VOLUME_DOWN);
                    }
                } else {
                    DBG_ALWAYS("AdjustVolume to TV");
                    currentVolume = parseInt(model.sound.getMainVolume());
                    DBG_INFO("AdjustVolume value is: " + value);
                    DBG_INFO("currentVolume value is: " + currentVolume);
                    lastVolume = currentVolume + value;
                    if (lastVolume > 100) lastVolume = 100;
                    if (lastVolume < 0) lastVolume = 0;
                    if (1 == model.sound.getMainMute()) {
                        DBG_ERROR("the state of TV is mute");
                        model.sound.setMainMute(0); //unmute
                    }
                    model.sound.setMainVolume(lastVolume);
                }
                self.logReport.reportSuccess(self.logReport.CONST.NAMESPACE_STEPSPEAKER, self.logReport.CONST.NAME_ADJUSTVOLUME);
            } catch (e) {
                DBG_ERROR("model.sound.setMainVolume error: " + e.message);
            }
        } else if ("SetMute" == name) {
            value = getPayload(volume_info).mute;
            try {
                DBG_INFO("SetMute value is: " + value);
                //GLOBAL.SPEAKER_STATE = tv ? model.sound.getTvSpeaker() : 1;
                if (isCECByPass()) {
                    DBG_ALWAYS("SetMute to ARC");
                    if (value) {
                        //model.cec.sendKeyToCEC(0x65, UI.keyState); //mute
                        model.system.setKeyToDfb(guijs.SYSCMD_MUTE);
                    } else {
                        //.cec.sendKeyToCEC(0x66, UI.keyState); //unmute
                        model.system.setKeyToDfb(guijs.SYSCMD_MUTE);
                    }
                } else {
                    DBG_ALWAYS("SetMute to TV");
                    if (value) {
                        model.sound.setMainMute(1); // mute
                    } else {
                        model.sound.setMainMute(0); //unmute
                    }
                }
                self.logReport.reportSuccess(self.logReport.CONST.NAMESPACE_STEPSPEAKER, self.logReport.CONST.NAME_SETMUTE);
            } catch (e) {
                DBG_ERROR("model.sound.setMainMute: " + e.message);
            }
        }
    };

    /**
     * send settings's update to AVS
     * @param setting_array: an array which contain objects
     */
    self.tvController.settings = {};
    self.tvController.settings.sendEvent = function (setting_array) {
        var eventJSON = {}, eventStr = "";
        eventJSON.event = {};
        eventJSON.event.header = {};
        eventJSON.event.payload = {};
        eventJSON.event.header.namespace = "Settings";
        eventJSON.event.header.name = "SettingsUpdated";
        eventJSON.event.header.messageId = Date.now();
        eventJSON.event.payload.settings = setting_array;

        eventStr = JSON.stringify(eventJSON);
    };

    self.tvController.system = {};
    self.tvController.system.SynchronizeState = function (synchronize_info) {
        var eventJSON = {}, eventStr = "";
        eventJSON.context = [];
        eventJSON.event = {};
        eventJSON.event.header = {};
        eventJSON.event.payload = {};
        eventJSON.event.header.namespace = "System";
        eventJSON.event.header.name = "SynchronizeState";
        eventJSON.event.header.messageId = Date.now();//TODO
        eventStr = JSON.stringify(eventJSON);
    };
    /**
     * send UserInactivity Report hourly
     *
     */
    self.tvController.system.inactivityTimer = setInterval(function () {
        var eventJSON = {}, eventStr = "";
        eventJSON.event = {};
        eventJSON.event.header = {};
        eventJSON.event.payload = {};
        eventJSON.event.header.namespace = "System";
        eventJSON.event.header.name = "UserInactivityReport";
        eventJSON.event.header.messageId = Date.now();
        eventJSON.event.payload.inactiveTimeInSeconds = 30 * 60 * 1000; //TODO
        eventStr = JSON.stringify(eventJSON);
    }, 3600000); //1 hour

    /**
     * Reset UserInactivity Timer
     * @param resetInactivity_info  directive
     */
    self.tvController.system.processResetUserInactivity = function (resetInactivity_info) {
        DBG_INFO("processResetUserInactivity enter");
        var name = getHeader(resetInactivity_info).name;
        if ("ResetUserInactivity" == name) {
            //TODO
        }
    };

    /**
     * SetEndpoint
     * @param endPoint_info  directive
     */
    self.tvController.system.processSetEndpoint = function (endPoint_info) {
        DBG_INFO("processSetEndpoint enter");
        var name = getHeader(endPoint_info).name;
        if ("SetEndpoint" == name) {
            //TODO
        }
    };

    self.tvController.playbackController = function (playback_info) {
        var name = getHeader(playback_info).name;
        DBG_INFO("playbackController name is: " + name);
        switch (name) {
            case "Play":
                if (GLOBAL.MEDIA_STARTUP_FLAG) {
                    //UI.send_key_to_dfb(guijs.SYSCMD_PLAY);
                    hiMedia.funcForAVS("play");
                } else {
                    //sendAM(":am,opera4x,key:virtualKey=Play");
                    UI.send_key_to_dfb(guijs.SYSCMD_PLAY);
                }
                self.logReport.reportSuccess(self.logReport.CONST.NAMESPACE_PLAYBACK, self.logReport.CONST.NAME_PLAY);
                break;
            case "Stop":
                if (GLOBAL.MEDIA_STARTUP_FLAG) {
                    //UI.send_key_to_dfb(guijs.SYSCMD_STOP);
                    hiMedia.funcForAVS("stop");
                } else {
                    //sendAM(":am,opera4x,key:virtualKey=Stop");
                    UI.send_key_to_dfb(guijs.SYSCMD_STOP);
                }
                self.logReport.reportSuccess(self.logReport.CONST.NAMESPACE_PLAYBACK, self.logReport.CONST.NAME_STOP);
                break;
            case "Pause":
                if (GLOBAL.MEDIA_STARTUP_FLAG) {
                    //UI.send_key_to_dfb(guijs.SYSCMD_PAUSE);
                    hiMedia.funcForAVS("pause");
                } else {
                    //sendAM(":am,opera4x,key:virtualKey=Pause");
                    UI.send_key_to_dfb(guijs.SYSCMD_PAUSE);
                }
                self.logReport.reportSuccess(self.logReport.CONST.NAMESPACE_PLAYBACK, self.logReport.CONST.NAME_PAUSE);
                break;
            case "StartOver":
                if (GLOBAL.MEDIA_STARTUP_FLAG) {
                    //hiMedia.funcForAVS("seek", 0);
                    hiMedia.funcForAVS("startOver");
                } else {
                    DBG_ERROR("App do not support StartOver");
                }
                self.logReport.reportSuccess(self.logReport.CONST.NAMESPACE_PLAYBACK, self.logReport.CONST.NAME_STARTOVER);
                break;
            case "Previous":
                if (GLOBAL.MEDIA_STARTUP_FLAG) {
                    hiMedia.funcForAVS("pre");
                } else {
                    //sendAM(":am,opera4x,key:virtualKey=Previous");
                    UI.send_key_to_dfb(guijs.SYSCMD_LAST);
                }
                self.logReport.reportSuccess(self.logReport.CONST.NAMESPACE_PLAYBACK, self.logReport.CONST.NAME_PREVIOUS);
                break;
            case "Next":
                if (GLOBAL.MEDIA_STARTUP_FLAG) {
                    hiMedia.funcForAVS("next");
                } else {
                    //sendAM(":am,opera4x,key:virtualKey=Next");
                    UI.send_key_to_dfb(guijs.SYSCMD_NEXT);
                }
                self.logReport.reportSuccess(self.logReport.CONST.NAMESPACE_PLAYBACK, self.logReport.CONST.NAME_NEXT);
                break;
            case "Rewind":
                if (GLOBAL.MEDIA_STARTUP_FLAG) {
                    //UI.send_key_to_dfb(guijs.SYSCMD_FAST_BKW);
                    hiMedia.funcForAVS("fastbwd");
                } else {
                    //sendAM(":am,opera4x,key:virtualKey=Rewind");
                    UI.send_key_to_dfb(guijs.SYSCMD_FAST_BKW);
                }
                self.logReport.reportSuccess(self.logReport.CONST.NAMESPACE_PLAYBACK, self.logReport.CONST.NAME_REWIND);
                break;
            case "FastForward":
                if (GLOBAL.MEDIA_STARTUP_FLAG) {
                    //UI.send_key_to_dfb(guijs.SYSCMD_FAST_FWD);
                    hiMedia.funcForAVS("fastfwd");
                } else {
                    //sendAM(":am,opera4x,key:virtualKey=FastForward");
                    UI.send_key_to_dfb(guijs.SYSCMD_FAST_FWD);
                }
                self.logReport.reportSuccess(self.logReport.CONST.NAMESPACE_PLAYBACK, self.logReport.CONST.NAME_FASTFORWARD);
                break;
            default :
                DBG_ERROR("command is not supported");
                break;
        }
    };

    self.tvController.RemoteVideoPlayer = function (remote_info) {
        var valueArray, name = getHeader(remote_info).name;
        DBG_INFO("RemoteVideoPlayer name is: " + name);
        var values = "", i = 0;
        if ("SearchAndPlay" == name) {
            valueArray = getPayload(remote_info).entities;
            for (i = 0; i < valueArray.length; i++) {
                if ((0 != i) && (valueArray[i - 1].value == valueArray[i].value)) continue; //avoid adjoining value are same
                values += valueArray[i].value;
                values += " "; // space as separator
            }
            values = values.substring(0, values.length - 1);  //delete last space character
            DBG_INFO("SearchAndPlay values is: " + values);
            startSearchAppByVoice(values);
            self.logReport.reportSuccess(self.logReport.CONST.NAMESPACE_VIDEO, self.logReport.CONST.NAME_SEARCHANDPLAY);
        } else if ("SearchAndDisplayResults" == name) {
            values = "";
            valueArray = getPayload(remote_info).entities;
            for (i = 0; i < valueArray.length; i++) {
                if ((0 != i) && (valueArray[i - 1].value == valueArray[i].value)) continue; //avoid adjoining value are same
                values += valueArray[i].value;
                values += " "; // space as separator
            }
            values = values.substring(0, values.length - 1);  //delete last space character
            DBG_INFO("SearchAndDisplayResults values is: " + values);
            startSearchAppByVoice(values);
            self.logReport.reportSuccess(self.logReport.CONST.NAMESPACE_VIDEO, self.logReport.CONST.NAME_SEARCHANDDISPLAYRESULTS);
        }
    };

    self.tvController.launcher = function (launcher_info) {
        var name = getHeader(launcher_info).name;
        DBG_INFO("launcher name is: " + name);
        if ("LaunchTarget" == name) {
            var payloadName = getPayload(launcher_info).name;
            var identifier = getPayload(launcher_info).identifier;
            DBG_ALWAYS("launcher payloadName is: " + payloadName);
            DBG_ALWAYS("launcher identifier is: " + identifier);
            var appName = payloadName.toLowerCase().replace(" ", "");
            if (appName.indexOf("setting") >= 0) {
                DBG_ALWAYS("start setting");
                UI.base.onkey_SETTINGS();
            } else if (appName.indexOf("mediaplayer") >= 0) {
                DBG_ALWAYS("start himedia");
                UI.popAllModule();
                startThirdPartyApp(null, APPNAME.HIMEDIA, CMDType.HISENSEPAGE, CMDMethod.MENU, false, 0xFFFFFF);
            } else {
                DBG_ALWAYS("start app");
                startAppByVoice(payloadName);
            }
        }
    };
    self.tvController.seekController = function (playback_info) {
        var name = getHeader(playback_info).name;
        DBG_INFO("seekController name is: " + name);
        if("AdjustSeekPosition" == name){
            var payloadMSeconds = getPayload(playback_info).deltaPositionMilliseconds;
            if (GLOBAL.MEDIA_STARTUP_FLAG) {
                DBG_ERROR("hiMedia.funcForAVS seek: " + payloadMSeconds/1000);
                hiMedia.funcForAVS("seek",payloadMSeconds/1000);
            }else{
                DBG_ERROR("seekController only support DMP");

            }
            self.logReport.reportSuccess(self.logReport.CONST.NAME_ADJUSTSEEKPOSITION, self.logReport.CONST.NAMESPACE_SEEK);
        }
    };

    self.tvController.processManageMsg = function (str) {
        var event = getEvent(str);
        DBG_INFO("event is: " + event);
        switch (event) {
            case "deRegistered":
                AVSClient.register.logout("hisense");
                Hisense.File.delete("hisenseUI/avsRegister", 1);
                // Hisense.File.delete("hisenseUI/disVoiceChrome", 1);
                openMsgBoxByType(MsgBoxType.AVS_DEVICE_DEREGISTERED);
                break;
            case "NameReplaced":
                openMsgBoxByType(MsgBoxType.AVS_DEVICE_REPLACE);
                break;
            case "PasswdChanged":
            case "AccountDeleted":
                AVSClient.register.logout("hisense");
                Hisense.File.delete("hisenseUI/avsRegister", 1);
                // Hisense.File.delete("hisenseUI/disVoiceChrome", 1);
                openMsgBoxByType(MsgBoxType.AVS_HIS_EXPIRED);
                break;
            default :
                DBG_ERROR("The event is not supported: " + event);
                break;
        }
    };
    self.tvController.processDirective = function (str) {
        var nameSpace = getNameSpace(str);
        DBG_INFO("nameSpace is: " + nameSpace);

        if (self.tvController.derepFlag) {
            if (self.tvController.tempMsg == nameSpace) {
                DBG_ALWAYS("a same msg coming within a short time");
                return;
            }
        }
        self.tvController.derepFlag = true; //begin to dereplication
        self.tvController.derepTimer = setTimeout(function () {
            self.tvController.derepFlag = false;  // cancel to dereplication
            clearTimeout(self.tvController.derepTimer);
            self.tvController.derepTimer = 0;
        }, self.tvController.shortTimeValue);  // 2 seconds elapsed
        self.tvController.tempMsg = nameSpace;

        switch (nameSpace) {
            case "Alexa.PowerController":
                self.tvController.powerController(str);
                break;
            case "Alexa.Speaker":
                self.tvController.speaker.processVolumeDirective(str, true);
                break;
            case "Alexa.StepSpeaker":
                self.tvController.stepSpeaker.processVolumeDirective(str);
                break;
            case "Alexa.PlaybackController":
                self.tvController.playbackController(str);
                break;
            case "Alexa.InputController":
                self.tvController.inputController(str);
                break;
            case "Alexa.ChannelController":
                self.tvController.channelController(str);
                break;
            case "Alexa.RemoteVideoPlayer":
                self.tvController.RemoteVideoPlayer(str);
                break;
            case "Alexa.Launcher":
                self.tvController.launcher(str);
                break;
            case "Alexa.SeekController":
                self.tvController.seekController(str);
                break;
            default :
                DBG_ERROR("The nameSpace is not supported: " + nameSpace);
                break;
        }
    };

//******************tvController part end*********************

//********************log report part*************************
    self.logReport = {
        event_success_code: 240002,
        event_failure_code: 240003,
        capability: "2017072001",
        logstamp: 55,
        version: "1.0"
    };
    self.logReport.CONST = {

        //error code
        ERR_CODE_BTRCUNPAIR: 0,
        ERR_CODE_INITNETERROR: 1,
        ERR_CODE_REGISTERERR: 2,
        ERR_CODE_AMAZONEXPIRED: 1,
        ERR_CODE_USINGNETERROR: 3,
        ERR_CODE_PRESSTOOSHORT: 4,
        ERR_CODE_SERVICEERR: 5,

        //error type
        ERR_TYPE_INIT: "init",
        ERR_TYPE_USING: "using",
        //name
        NAME_TEMPLATE1: "BodyTemplate1",
        NAME_TEMPLATE2: "BodyTemplate2",
        NAME_LIST: "ListTemplate1",
        NAME_WEATHER: "WeatherTemplate",
        NAME_MUSIC: "MusicCard",
        NAME_SETVOLUME: "SetVolume",
        NAME_ADJUSTVOLUME: "AdjustVolume",
        NAME_SETMUTE: "SetMute",
        NAME_TURNOFF: "TurnOff",
        NAME_PLAY: "Play",
        NAME_STOP: "Stop",
        NAME_PAUSE: "Pause",
        NAME_STARTOVER: "StartOver",
        NAME_PREVIOUS: "Previous",
        NAME_NEXT: "Next",
        NAME_REWIND: "Rewind",
        NAME_FASTFORWARD: "FastForward",
        NAME_SELECTINPUT: "SelectInput",
        NAME_CHANGECHANNEL: "ChangeChannel",
        NAME_SKIPCHANNELS: "SkipChannels",
        NAME_SEARCHANDPLAY: "SearchAndPlay",
        NAME_SEARCHANDDISPLAYRESULTS: "SearchAndDisplayResults",

        //namespace
        NAMESPACE_TEMPLATE: "RenderTemplate",
        NAMESPACE_PLAYER: "RenderPlayerInfo",
        NAMESPACE_SPEAKER: "Speaker",
        NAMESPACE_POWER: "PowerController",
        NAMESPACE_STEPSPEAKER: "StepSpeaker",
        NAMESPACE_PLAYBACK: "PlaybackController",
        NAMESPACE_INPUT: "InputController",
        NAMESPACE_CHANNEL: "ChannelController",
        NAMESPACE_VIDEO: "RemoteVideoPlayer"
    };
    var getCapability = function () {
        var obj = tv ? Hisense.File.read("capabilitycode.txt", 1) : 0;
        try {
            if (obj && "none" != obj && "" != obj && 2 != obj && '2' != obj) {
                return obj;
            }
        } catch (e) {
            DBG_ERROR("uso_util.getCapability:" + e.message);
            return "2017072001";
        }
        return "2017072001";

    };
    self.logReport.capability = getCapability();
    self.logReport.reportSuccess = function (namespace, name) {
        LGReport.AVSControlSuccess(name, namespace, self.logReport.capability, self.logReport.event_success_code, self.logReport.logstamp, self.logReport.version);
    };
    self.logReport.reportFailure = function (err_code, err_type) {
        LGReport.AVSControlFail(err_code, err_type, self.logReport.capability, self.logReport.event_failure_code, self.logReport.logstamp, self.logReport.version)
    };
//******************log report part end***********************

//**********************model part***************************
    /**
     * modeljs adapter
     */
    self.model = {
        setControlType: function (status, param) {
            DBG_ERROR("model.avs.setControlType status = " + status);
            if (Config.tv) {
                try {
                    model.avs.setControlType(status, !!param ? param + "" : "0");
                } catch (ex) {
                    DBG_ERROR("model.avs.setControlType error = " + ex.message);
                }
            }
        },
        onVoiceChromeStatusChanged: function (state) {
            self.speech.onSpeechStateChanged(state);
        },
        onVoiceChromeError: function (err) {
            self.speech.onSpeechStateChanged(-1 * err);
        },
        onAlarmReceived: function (state) {
            if (state == 1) {
                self.speech.onSpeechStateChanged(AvsModelDefines.ENUM_SL2_TVAPI_AVS_RECOG_STATE_ALARM);
            }
        },
        onHisDeviceInfoReceived: function (str) {
            DBG_ERROR("onHisDeviceInfoReceived info=" + str);
            if (!str || !str.length) {
                return;
            }
            var info;
            try {
                info = JSON.parse(str);
            } catch (ex) {
                DBG_ERROR("onHisDeviceInfoReceived err=" + ex.message);
                return;
            }
            if (typeof info.resultCode == "number" && info.resultCode == 1) {
                DBG_INFO("err_msg:" + info.errorDesc);
                if (info.errorCode = 212004) {
                    DBG_INFO("device has been kicked out");
                    self.register.setIsReplaced(true);
                }
            }
            //Deprecated
            // var info = JSON.parse(str);
            // if (typeof info.resultCode == "number" && info.resultCode == 0) {
            //     if (!!info.deviceName && info.deviceName.length > 0) {
            //         //sync alexa enable flag on device from hisense cloud
            //         if (info.VSEnable != self.model.getAlexaEnable()) {
            //             self.model.setAlexaEnable(info.VSEnable);
            //             if (info.VSEnable == 0) {
            //                 openMsgBoxByType(MsgBoxType.AVS_HIS_EXPIRED);
            //             }
            //         }
            //     }
            // }
        },
        onDirectiveReceive: function (directive_string) {
            //FIXME: change this log to info
            DBG_ERROR("onDirectiveReceive template_info = " + objToString(directive_string));
            if (!Config.tv) {
                // directive_string =
                //     "{\"directive\":{\"header\":{\"namespace\":\"TemplateRuntime\",\"name\":\"RenderTemplate\",\"messageId\":\"310b42f2-e5a7-42fd-8e06-e58cfac567f5\",\"dialogRequestId\":\"8728ff2a-1d9a-49e3-8d1f-46dc840cff4f\"},\"payload\":{\"type\":\"BodyTemplate2\",\"token\":\"57339c08-36e2-4b26-ac8a-3d1831f1214f\",\"title\":{\"subTitle\":\"Wikipedia\",\"mainTitle\":\"Who is the Alabama?\"},\"textField\":\"Alabama is a state in the southeastern region of the United States.\",\"image\":{\"sources\":[{\"size\":\"SMALL\",\"url\":\"https://m.media-amazon.com/images/S/com.evi.images-irs/73/737c9d7e1af3d08e56bd896239254ee9._UL600_.png\"},{\"size\":\"MEDIUM\",\"url\":\"https://m.media-amazon.com/images/S/com.evi.images-irs/73/737c9d7e1af3d08e56bd896239254ee9._UX1024_SY600_.png\"},{\"size\":\"LARGE\",\"url\":\"http://ecx.images-amazon.com/images/S/com.evi.images-irs/73/737c9d7e1af3d08e56bd896239254ee9._UX1440_SY810_.png\"}]}}}}"
                //weather
                directive_string = '{"directive":{"header":{"namespace":"TemplateRuntime","name":"RenderTemplate","messageId":"f0b862bf-1473-46f9-8164-7ce51f069c23","dialogRequestId":"ebb2f488-3f03-4ea0-ba2d-5446064637ff"},"payload":{"type":"WeatherTemplate","token":"9ddb7ef3-dfb9-4f25-a6c8-8647ebc735c8","lowTemperature":{"value":"53掳","arrow":{"contentDescription":"Down arrow","sources":[{"widthPixels":88,"darkBackgroundUrl":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/small/currentWeatherIcon/down_bb.png","size":"SMALL","heightPixels":80,"url":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/small/currentWeatherIcon/down.png"},{"widthPixels":256,"darkBackgroundUrl":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/medium/currentWeatherIcon/down_bb.png","size":"MEDIUM","heightPixels":233,"url":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/medium/currentWeatherIcon/down.png"},{"widthPixels":305,"darkBackgroundUrl":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/large/currentWeatherIcon/down_bb.png","size":"LARGE","heightPixels":278,"url":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/large/currentWeatherIcon/down.png"}]}},"title":{"subTitle":"Thursday, August 24, 2017","mainTitle":"Seattle, WA"},"currentWeatherIcon":{"contentDescription":"Cloudy","sources":[{"widthPixels":88,"darkBackgroundUrl":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/small/currentWeatherIcon/cloudy_bb.png","size":"SMALL","heightPixels":80,"url":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/small/currentWeatherIcon/cloudy.png"},{"widthPixels":256,"darkBackgroundUrl":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/medium/currentWeatherIcon/cloudy_bb.png","size":"MEDIUM","heightPixels":233,"url":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/medium/currentWeatherIcon/cloudy.png"},{"widthPixels":305,"darkBackgroundUrl":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/large/currentWeatherIcon/cloudy_bb.png","size":"LARGE","heightPixels":278,"url":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/large/currentWeatherIcon/cloudy.png"}]},"weatherForecast":[{"highTemperature":"72掳","date":"Aug 25","lowTemperature":"54掳","image":{"contentDescription":"Sunny","sources":[{"widthPixels":44,"darkBackgroundUrl":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/small/weatherForecast/sunny_bb.png","size":"SMALL","heightPixels":40,"url":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/small/weatherForecast/sunny.png"},{"widthPixels":88,"darkBackgroundUrl":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/medium/weatherForecast/sunny_bb.png","size":"MEDIUM","heightPixels":80,"url":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/medium/weatherForecast/sunny.png"},{"widthPixels":132,"darkBackgroundUrl":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/large/weatherForecast/sunny_bb.png","size":"LARGE","heightPixels":123,"url":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/large/weatherForecast/sunny.png"}]},"day":"Fri"},{"highTemperature":"77掳","date":"Aug 26","lowTemperature":"58掳","image":{"contentDescription":"Sunny","sources":[{"widthPixels":44,"darkBackgroundUrl":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/small/weatherForecast/sunny_bb.png","size":"SMALL","heightPixels":40,"url":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/small/weatherForecast/sunny.png"},{"widthPixels":88,"darkBackgroundUrl":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/medium/weatherForecast/sunny_bb.png","size":"MEDIUM","heightPixels":80,"url":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/medium/weatherForecast/sunny.png"},{"widthPixels":132,"darkBackgroundUrl":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/large/weatherForecast/sunny_bb.png","size":"LARGE","heightPixels":123,"url":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/large/weatherForecast/sunny.png"}]},"day":"Sat"},{"highTemperature":"80掳","date":"Aug 27","lowTemperature":"59掳","image":{"contentDescription":"Partly cloudy","sources":[{"widthPixels":44,"darkBackgroundUrl":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/small/weatherForecast/partly_cloudy_bb.png","size":"SMALL","heightPixels":40,"url":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/small/weatherForecast/partly_cloudy.png"},{"widthPixels":88,"darkBackgroundUrl":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/medium/weatherForecast/partly_cloudy_bb.png","size":"MEDIUM","heightPixels":80,"url":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/medium/weatherForecast/partly_cloudy.png"},{"widthPixels":132,"darkBackgroundUrl":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/large/weatherForecast/partly_cloudy_bb.png","size":"LARGE","heightPixels":123,"url":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/large/weatherForecast/partly_cloudy.png"}]},"day":"Sun"},{"highTemperature":"81掳","date":"Aug 28","lowTemperature":"60掳","image":{"contentDescription":"Sunny","sources":[{"widthPixels":44,"darkBackgroundUrl":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/small/weatherForecast/sunny_bb.png","size":"SMALL","heightPixels":40,"url":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/small/weatherForecast/sunny.png"},{"widthPixels":88,"darkBackgroundUrl":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/medium/weatherForecast/sunny_bb.png","size":"MEDIUM","heightPixels":80,"url":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/medium/weatherForecast/sunny.png"},{"widthPixels":132,"darkBackgroundUrl":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/large/weatherForecast/sunny_bb.png","size":"LARGE","heightPixels":123,"url":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/large/weatherForecast/sunny.png"}]},"day":"Mon"},{"highTemperature":"85掳","date":"Aug 29","lowTemperature":"61掳","image":{"contentDescription":"Partly cloudy","sources":[{"widthPixels":44,"darkBackgroundUrl":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/small/weatherForecast/partly_cloudy_bb.png","size":"SMALL","heightPixels":40,"url":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/small/weatherForecast/partly_cloudy.png"},{"widthPixels":88,"darkBackgroundUrl":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/medium/weatherForecast/partly_cloudy_bb.png","size":"MEDIUM","heightPixels":80,"url":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/medium/weatherForecast/partly_cloudy.png"},{"widthPixels":132,"darkBackgroundUrl":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/large/weatherForecast/partly_cloudy_bb.png","size":"LARGE","heightPixels":123,"url":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/large/weatherForecast/partly_cloudy.png"}]},"day":"Tue"},{"highTemperature":"80掳","date":"Aug 30","lowTemperature":"60掳","image":{"contentDescription":"Partly cloudy","sources":[{"widthPixels":44,"darkBackgroundUrl":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/small/weatherForecast/partly_cloudy_bb.png","size":"SMALL","heightPixels":40,"url":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/small/weatherForecast/partly_cloudy.png"},{"widthPixels":88,"darkBackgroundUrl":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/medium/weatherForecast/partly_cloudy_bb.png","size":"MEDIUM","heightPixels":80,"url":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/medium/weatherForecast/partly_cloudy.png"},{"widthPixels":132,"darkBackgroundUrl":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/small/weatherForecast/partly_cloudy_bb.png","size":"LARGE","heightPixels":123,"url":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/large/weatherForecast/partly_cloudy.png"}]},"day":"Wed"},{"highTemperature":"77掳","date":"Aug 31","lowTemperature":"62掳","image":{"contentDescription":"Partly cloudy","sources":[{"widthPixels":44,"darkBackgroundUrl":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/small/weatherForecast/partly_cloudy_bb.png","size":"SMALL","heightPixels":40,"url":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/small/weatherForecast/partly_cloudy.png"},{"widthPixels":88,"darkBackgroundUrl":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/medium/weatherForecast/partly_cloudy_bb.png","size":"MEDIUM","heightPixels":80,"url":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/medium/weatherForecast/partly_cloudy.png"},{"widthPixels":132,"darkBackgroundUrl":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/large/weatherForecast/partly_cloudy_bb.png","size":"LARGE","heightPixels":123,"url":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/large/weatherForecast/partly_cloudy.png"}]},"day":"Thu"}],"description":"Intervals of clouds and sun","highTemperature":{"value":"69掳","arrow":{"contentDescription":"Up arrow","sources":[{"widthPixels":88,"darkBackgroundUrl":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/small/currentWeatherIcon/up_bb.png","size":"SMALL","heightPixels":80,"url":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/small/currentWeatherIcon/up.png"},{"widthPixels":256,"darkBackgroundUrl":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/medium/currentWeatherIcon/up_bb.png","size":"MEDIUM","heightPixels":233,"url":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/medium/currentWeatherIcon/up.png"},{"widthPixels":305,"darkBackgroundUrl":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/large/currentWeatherIcon/up_bb.png","size":"LARGE","heightPixels":278,"url":"https://images-na.ssl-images-amazon.com/images/G/01/alexa/avs/gui/large/currentWeatherIcon/up.png"}]}},"currentWeather":"62掳"}}}'
            }
            var json = JSON.parse(directive_string);
            if (!json) {
                DBG_ERROR("onDirectiveReceive json is null!");
                return;
            }
            if (!json.directive || !json.directive.header) {
                DBG_ERROR("onDirectiveReceive json directive or header is null!");
                return;
            }
            switch (json.directive.header.namespace) {
                case self.DIRECTIVE_NAMESPACE.TEMPLATERUNTIME:
                    var template_obj = parseTemplateInfo(json);
                    if (!template_obj) {
                        DBG_ERROR("parseTemplateInfo error");
                        return;
                    }
                    if (template_obj.directive === "RenderTemplate") {
                        self.renderDisplayCard.notifyShowDisplayCard(template_obj);
                    } else if (template_obj.directive === "RenderPlayerInfo") {
                        //do not need to parse the player info, only pass this value to audio player
                        self.audioPlayer.notifyMusicCard(directive_string);
                    } else {
                        DBG_ERROR("AVSClient.model.onDirectiveReceive error template info");
                    }
                    break;
                case self.DIRECTIVE_NAMESPACE.AUDIOPLAYER:
                    self.audioPlayer.notifyMusicPlay(directive_string);
                    break;
                case self.DIRECTIVE_NAMESPACE.SPEAKER:
                    if(!self.tvController.AVGMute) {
                        self.tvController.speaker.processVolumeDirective(directive_string, false);
                    }else{
                        self.tvController.AVGMute = false;
                    }
                    break;
                default:
                    DBG_ERROR("AVSClient.model.onDirectiveReceive error namespace info");
                    break;
            }
        },
        onAuthInfoReceived: function (info) {
            DBG_INFO("AVSClient.model.onAuthCodeReceived info = " + info);
            var info_obj = JSON.parse(info);
            var register_url = "";
            var register_code = "";
            var register_expire_time = 0;
            if (!!info_obj) {
                register_url = info_obj.authUrl;
                register_code = info_obj.dynAuthCode;
                register_expire_time = parseInt(info_obj.expiredTime); //sec
            }
            self.register.onAuthInfoReceived(register_url, register_code, register_expire_time);
            UIObserver.publishMessage(UIObserver.MESSAGE_NAME.AVS_ONAMAMESSAGECHANGED, register_url, register_code, register_expire_time);

        },
        onAuthResultReceived: function (err) {
            DBG_INFO("AVSClient.model.onAuthResultReceived err = " + err);
            if (!Config.tv) {
                err = 0;
            }
            self.register.onRegisterResult(err);
        },
        getLoginStatus: function () {
            var status = false;
            if (Config.tv) {
                try {
                    status = model.avs.getLoginStatus();
                } catch (ex) {
                    DBG_ERROR("model.avs.getLoginStatus error = " + ex.message);
                }

            }
            DBG_INFO("getLoginStatus[" + status + "]");
            return status;
        },
        onLoginStatusReceived: function (status) {
            DBG_INFO("AVSClient.model.onLoginStatusReceived status = " + status);
            self.register.onLoginStatusReceived(status);
        },
        onUserProfileReceived: function (info) {
            DBG_INFO("AVSClient.model.onUserProfileReceived status = " + info);
            self.register.onUserProfileReceived(info);
        },
        getAlexaEnable: function () {
            var ret = false;
            if (Config.tv) {
                try {
                    ret = model.avs.getAlexaEnable();
                } catch (ex) {
                    DBG_ERROR("model.avs.getAlexaEnable error = " + ex.message);
                }
            }
            return ret;
        },
        getLoginStep: function () {
            var step = 0;
            if (Config.tv) {
                try {
                    step = model.avs.getLoginStep();
                } catch (ex) {
                    DBG_ERROR("model.avs.getLoginStep error = " + ex.message);
                }
            }
            return step;
        },
        setLoginStep: function (step) {
            if (Config.tv) {
                try {
                    model.avs.setLoginStep(step);
                } catch (ex) {
                    DBG_ERROR("model.avs.setLoginStep error = " + ex.message);
                }
            }
        },
        setAlexaEnable: function (flag) {
            if (Config.tv) {
                try {
                    model.avs.setAlexaEnable(!!flag ? 1 : 0);
                } catch (ex) {
                    DBG_ERROR("model.avs.setAlexaEnable error = " + ex.message);
                }
            }
        },
        getBTRCSupport: function () {
            var ret = false;
            if (Config.tv) {
                try {
                    ret = (model.avs.getBTRCSupport() ? true : false);
                } catch (ex) {
                    DBG_ERROR("model.avs.setAlexaEnable error = " + ex.message);
                }
            } else {
                ret = true;
            }
            return ret;
        },

        onHisenseTokenReceived: function (token) {
            DBG_INFO("onHisenseTokenReceived token=" + token);
            Hiwebsocket.onMessage = self.model.onHisenseMessage;
            Hiwebsocket.onReconnect = self.model.onReconnect;
            Hiwebsocket.createWebSocket(token);

            // Deprecated
            // try {
            //     //sync status from hisense cloud
            //     self.setting.syncStatus();
            //     self.register.updateRegisterStatus("hisense");
            //     self.register.updateRegisterStatus("amazon");
            // } catch (ex) {
            //     DBG_ERROR("register the modeljs listeners err = " + ex.message);
            // }
        },
        onHisenseMessage: function (msg_str) {
            DBG_INFO("self.model.onHisenseMessage msg_str = " + msg_str);
            var type = typeof msg_str, msgContent, actualStr = msg_str;
            var msgType = 0;
            if (type == "string") {
                DBG_INFO("msg_str is a string");
                try{
                actualStr = JSON.parse(msg_str);
                }catch(e){
                    DBG_ERROR("failed to parse msg");
                }
            }
            msgType = actualStr.msgType;
            msgContent = actualStr.msgContent;
            DBG_INFO("msgType is = " + msgType);
            DBG_INFO("msgContent is = " + msgContent);
            switch (msgType){
                case 2100: //manage msg : deRegistered, NameReplaced, PasswdChanged AccountDeleted
                    self.tvController.processManageMsg(msgContent);
                    break;
                case 2016: //AVG Directive
                    self.tvController.processDirective(msgContent);
                    break;
                default :
                    DBG_ERROR("the type is not supported now");
                    break;
            }
        },
        onReconnect: function () {
            DBG_INFO("AVS onReconnect");
            var url = "";
            if (Config.tv) {
                try {
                    url = model.avs.getSystemToken()
                } catch (ex) {
                    DBG_ERROR("model.avs.setAlexaEnable error = " + ex.message);
                }
            } else {
                url = "abcdedfgh";
            }
            Hiwebsocket.reconnect(url);
        },
        onHisenseAuthInfoReceived: function (info) {
            DBG_INFO("AVSClient.model.onHisenseAuthInfoReceived info = " + info);
            self.register.onHisenseAuthInfoReceived(info);
        },
        onHisenseAuthResultReceived: function (err) {
            DBG_INFO("AVSClient.model.onHisenseAuthResultReceived err = " + err);
            if (!Config.tv) {
                err = 0;
            }
            self.register.onHisRegisterResult(err);
        },
        getHisLoginStatus: function () {
            var status = false;
            if (Config.tv) {
                try {
                    status = model.avs.getHisLoginStatus();
                } catch (ex) {
                    DBG_ERROR("model.avs.getHisLoginStatus error = " + ex.message);
                }
            }
            DBG_INFO("getHisLoginStatus[" + status + "]");
            return status;
        },
        onHisLoginStatusReceived: function (status) {
            DBG_ERROR("AVSClient.model.onHisLoginStatusReceived status = " + status);
            self.register.onHisLoginStatusReceived(status);
        },
        onHisUserProfileReceived: function (info) {
            DBG_INFO("AVSClient.model.onHisUserProfileReceived status = " + info);
            self.register.onHisUserProfileReceived(info);
        },
        onHisDeviceReportResult: function (result) {
            DBG_INFO("AVSClient.model.onHisDeviceReportResult result[" + result + "], 0(OK);1(dup_name);2(Failed)");
            self.register.onHisDeviceReportResult(result);
        },
        onGetResetPasswordUrl: function (url) {
            DBG_INFO("AVSClient.model.onGetResetPasswordUrl result[" + url + "]");
            if (typeof self.register.onGetResetPasswordUrl === "function") {
                self.register.onGetResetPasswordUrl(url);
            }
            self.register.onGetResetPasswordUrl = null;
        },
        onPullCloudMsgReceived:function(msg_str){
            // var info = {"result":{"devMsg":"{\n   \"notification\" : {\n      \"event\" : \"NameReplaced\"\n   }\n}\n","MsgSeq":13806}};
            DBG_ERROR("onPullCloudMsgReceived result" + msg_str );
            var type = typeof msg_str,  actualStr = msg_str;
            if (type == "string") {
                DBG_INFO("msg_str is a string");
                try{
                    actualStr = JSON.parse(msg_str);
                }catch(e){
                    DBG_ERROR("failed to parse msg");
                }
            }
            var actualJSON ;
            if(!!actualStr.result.devMsg){
                actualJSON = actualStr.result.devMsg;
            }else if(!!actualStr.result.custMsg){
                actualJSON = actualStr.result.custMsg;
            }else{
                DBG_ERROR("can not support");
                return;
            }
            DBG_ERROR("actualJSON is " + actualJSON);
            var event = getEvent(actualJSON);
            switch (event) {
                case "PasswdChanged":
                case "AccountDeleted":
                    AVSClient.register.logout("hisense");
                    Hisense.File.delete("hisenseUI/avsRegister", 1);
                    writeFileToNative('hiAvsService/MsgSeq.txt', objToString(actualStr.result.MsgSeq), 1);
                    openMsgBoxByType(MsgBoxType.AVS_HIS_EXPIRED);
                    break;
                case "deRegistered":
                    AVSClient.register.logout("hisense");
                    Hisense.File.delete("hisenseUI/avsRegister", 1);
                    writeFileToNative('hiAvsService/MsgSeq.txt', objToString(actualStr.result.MsgSeq), 1);
                    openMsgBoxByType(MsgBoxType.AVS_DEVICE_DEREGISTERED);
                    break;
                case "NameReplaced":
                    writeFileToNative('hiAvsService/MsgSeq.txt', objToString(actualStr.result.MsgSeq), 1);
                    openMsgBoxByType(MsgBoxType.AVS_DEVICE_REPLACE);
                    break;
                default :
                    DBG_ERROR("The event is not supported: " + event);
                    break;
            }
        },

        //底层监听到数据发送到UI层
        onAlexaCurLanguageChanged:function (result) {
            /*if (typeof self.register.onAlexaCurLanguageChanged == "function") {
                DBG_ERROR("!!!!!!!!!!!CurLan"+"+"+result);
                self.register.onAlexaCurLanguageChanged(result);
            }
            self.register.onAlexaCurLanguageChanged = null;*/
            DBG_ERROR("ONCULANGUAGE is " + result);
            UIObserver.publishMessage(UIObserver.MESSAGE_NAME.AVS_ONCULANGUAGE, result);
        },
    onSetAlexaLanguageResult:function(result){
        DBG_ERROR("result is " + result);
        UIObserver.publishMessage(UIObserver.MESSAGE_NAME.AVS_ONSETALEXALANGUAGERESULT, result);
    },
        /*setAlexaLanguageCode: function (str) {
            if (Config.tv) {
                try {
                    model.avs.setControlType(AvsModelDefines.TV_API_AVS_CTRL_ACTION_TYPE_SET_LANG_LOCAL, str);
                } catch (ex) {
                    DBG_ERROR("model.avs.setAlexaLanguageCode = " + ex.message);
                }
            }
        },*/
    };

    //register the modeljs listeners
    if (Config.tv) {
        // try {
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AVS_RECOG_STATE, self.model.onVoiceChromeStatusChanged);
        //     UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AVS_RECOG_ERRCODE, self.model.onVoiceChromeError);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AVS_DISPLAY_CARDS, self.model.onDirectiveReceive);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AVS_ONPULLCLOUDMSGRECEIVED, self.model.onPullCloudMsgReceived);



        //languageList 获取到数据，进行回调
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AVS_CUR_LANGUAGE,self.model.onAlexaCurLanguageChanged);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AVS_LANGUAGE_RESULT,self.model.onSetAlexaLanguageResult);

        //     //register
        //     UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AVS_AUTH_CODE, self.model.onAuthInfoReceived);
        //     UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AVS_AUTH_RESULT, self.model.onAuthResultReceived);
        //     UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AVS_LOGIN_STATUS, self.model.onLoginStatusReceived);
        //     UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AVS_USER_PROFILE, self.model.onUserProfileReceived);
        //     UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AVS_HIAUTH_TOKEN, self.model.onHisenseTokenReceived);
        //     UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AVS_HIAUTH_INFO, self.model.onHisenseAuthInfoReceived);
        //     UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AVS_HIAUTH_RESULT, self.model.onHisenseAuthResultReceived);
        //     UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AVS_HILOGIN_STATUS, self.model.onHisLoginStatusReceived);
        //     UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AVS_HIUSER_PROFILE, self.model.onHisUserProfileReceived);
        //     UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AVS_HIDEV_REPORT, self.model.onHisDeviceReportResult);
        //     UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AVS_ALARM_FLAG, self.model.onAlarmReceived);
        //     UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.AVS_HIDEV_INFO, self.model.onHisDeviceInfoReceived);
        //
        // } catch (ex) {
        //     DBG_ERROR("register the modeljs listeners err = " + ex.message);
        // }
        self.AVS_Messages = {};
        // self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_RECOGNITION_STATE_NOTIFY = 378;
        // self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_DISPLAY_CARDS_NOTIFY =  379;
        self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_RECOGNITION_ERROR_CODE_NOTIFY = 380;
        self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_AUTH_CODE_NOTIFY = 381;
        self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_AUTH_RESULT_NOTIFY = 382;
        self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_LOGIN_STATUS_NOTIFY = 383;
        self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_USER_PROFILE_NOTIFY = 384;
        self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_HIAUTH_TOKEN_NOTIFY = 385;
        self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_HIAUTH_INFO_NOTIFY = 386;
        self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_HIAUTH_RESULT_NOTIFY = 387;
        self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_HILOGIN_STATUS_NOTIFY = 388;
        self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_HIUSER_PROFILE_NOTIFY = 389;
        self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_HIREPORT_DEVINFO_RESULT_NOTIFY = 390;
        self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_ALARM_FLAG_NOTIFY = 391;
        self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_REPLACE_DEV_STATUS_NOTIFY = 392;
        self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_HIDEV_INFO_NOTIFY = 393;
        self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_RESET_PWD_URL_NOTIFY = 394;

        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.MESSAGE_ID_CHANGED, function (id) {
            DBG_ERROR("AVSClient: MESSAGE_ID[" + id + "]");
            var params = model.message.getMessageparams();
            DBG_ERROR("AVSClient: MESSAGE_PARAMS[" + objToString(params) + "]");
            switch (id) {
                // case self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_RECOGNITION_STATE_NOTIFY:
                //     self.model.onVoiceChromeStatusChanged(parseInt(params[0]));
                //     break;
                // case self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_DISPLAY_CARDS_NOTIFY:
                //     self.model.onDirectiveReceive(params[0]);
                //     break;
                case self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_RECOGNITION_ERROR_CODE_NOTIFY:
                    self.model.onVoiceChromeError(parseInt(params[0]));
                    break;
                case self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_AUTH_CODE_NOTIFY:
                    self.model.onAuthInfoReceived(params[0]);
                    break;
                case self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_AUTH_RESULT_NOTIFY:
                    self.model.onAuthResultReceived(parseInt(params[0]));
                    break;
                case self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_LOGIN_STATUS_NOTIFY:
                    self.model.onLoginStatusReceived(parseInt(params[0]));
                    break;
                case self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_USER_PROFILE_NOTIFY:
                    self.model.onUserProfileReceived(params[0]);
                    break;
                case self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_HIAUTH_TOKEN_NOTIFY:
                    self.model.onHisenseTokenReceived(params[0]);
                    break;
                case self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_HIAUTH_INFO_NOTIFY:
                    self.model.onHisenseAuthInfoReceived(params[0]);
                    break;
                case self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_HIAUTH_RESULT_NOTIFY:
                    self.model.onHisenseAuthResultReceived(parseInt(params[0]));
                    break;
                case self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_HILOGIN_STATUS_NOTIFY:
                    self.model.onHisLoginStatusReceived(parseInt(params[0]));
                    break;
                case self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_HIUSER_PROFILE_NOTIFY:
                    self.model.onHisUserProfileReceived(params[0]);
                    break;
                case self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_HIREPORT_DEVINFO_RESULT_NOTIFY:
                case self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_REPLACE_DEV_STATUS_NOTIFY:
                    self.model.onHisDeviceReportResult(parseInt(params[0]));
                    break;
                case self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_ALARM_FLAG_NOTIFY:
                    self.model.onAlarmReceived(parseInt(params[0]));
                    break;
                case self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_HIDEV_INFO_NOTIFY:
                    self.model.onHisDeviceInfoReceived(params[0]);
                    break;
                case self.AVS_Messages.SL2_TVAPI_MESSAGE_ID_AVS_RESET_PWD_URL_NOTIFY:
                    self.model.onGetResetPasswordUrl(params[0]);
                    break;
            }
        })
    }
    self.register.getLoginStep = self.model.getLoginStep;
    self.register.setLoginStep = self.model.setLoginStep;

//********************model part end*************************
    /**********************************************************/

    /**************************************************************/
})(AVSClient);
