// Init
UI.moduleBuilder['setting']['wifiWpsPush'] = function(){

    var mainPanelData = {
        wifiWpsPushDialogBgImg:UI['bg_overlay'],
        wifiWpsPushImg:UI.window_bg,
        wifiWpsPushLoadImg:"setting/ic_wps.png",
        wifiWpsPushToastBgImg : "toast/Toast_bg2.png",
        wifiWpsPushToastImg:"setting/ic_not_connected.png",
        wifiWpsPushCancelBtnImg:UI.item_bg,
        wifiWpsPushName:"[SE0171]",//"WPS"
        wifiWpsPushText1:"[SE3011]",//"Within 2 minutes, press the button labeled ‘WPS’ or the symbol below."
        wifiWpsPushCancelBtnText:"[GE0008]"//Cancel
    };
    var template = Util.readJson("module/setting/wifiWpsPush.json");
    var wifiWpsPush = SubModule.create(mainPanelData, template);
    var wifiWpsPushCancelBtn = UI.getItem(wifiWpsPush, "wifiWpsPushCancelBtn");

    var wifiWpsPushPercentBar = UI.getItem(wifiWpsPush, "wifiWpsPushPercentBar");
    var wifiWpsPushPercentImg = UI.getItem(wifiWpsPushPercentBar, "wifiWpsPushPercentImg");
    var wifiWpsPushPercentText = UI.getItem(wifiWpsPushPercentBar, "wifiWpsPushPercentText");

    var wifiWpsPushToast = UI.getItem(wifiWpsPush, "wifiWpsPushToast");
    var wifiWpsPushToastImg = UI.getItem(wifiWpsPushToast, "wifiWpsPushToastImg");
    var wifiWpsPushToastText = UI.getItem(wifiWpsPushToast, "wifiWpsPushToastText");
    var wifiWpsPushText1 = UI.getItem(wifiWpsPush, "wifiWpsPushText1");
    wifiWpsPushText1.children[0].lineHeight = 50;
    wifiWpsPushText1.children[0].lineWidth = 804;

    wifiWpsPush.showTimeout = 0;
    wifiWpsPush.connPercent = 0;
    wifiWpsPush.PBCConnTimer = 0;
    wifiWpsPush.noAutoClose = true;
    wifiWpsPush.needStopWpsConnect = 0;

    var HIDE = 0;
    var SHOW = 1;

    var LANGUAGE = {
        "ConnectSuccess":"[SE0165]", //Connected successfully
        "ConnectFail":"[SE0166]" //Failed to connect. Please try again
    };
    Percent.create(wifiWpsPushPercentImg, wifiWpsPushPercentText, 0);
    wifiWpsPush.onPush =  function(){
        wifiWpsPush.PBCConnTimer = setInterval(wpsSetPushTimerOut,1200);
        if(tv == true){
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_LINK_CHANGED, wpsSetPushConnStateCallBack);
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_CHANGED, wpsNetworkAvailableCallBack);
            model.network.WpsConnectPBC();
            wifiWpsPush.needStopWpsConnect = 1;
        }
    }
    wifiWpsPush.onShow =  function(){
        try{
            wifiWpsPush.connPercent = 0;
            wifiWpsPushPercentImg.setPercent(0);
            wifiWpsPushPercentText.alpha = 0;
            wifiWpsPush.connPercent = 0;
            showWifiWpsPushConnectToast(HIDE,null,null);
//            UI.setText(wifiWpsPushText1,"Within 2 minutes, press the button labeled ‘WPS’ or the symbol below.");
            UI.focusTo(wifiWpsPushCancelBtn);
            wifiWpsPush.currFocus = UI.getItem(wifiWpsPush, "wifiWpsPushCancelBtn");
        }
        catch (ex){
            DBG_ERROR(ex.message);
        }
    };
    wifiWpsPush.currFocus = UI.getItem(wifiWpsPush, "wifiWpsPushCancelBtn");

    function wpsSetPushTimerOut(){
        if(wifiWpsPush.connPercent > 100){
            clearTimeout(wifiWpsPush.PBCConnTimer);
            var networkAvailable = model.network.getEnumNetworkAvailable();
            DBG_ERROR("wpsSetPushTimerOut:networkAailable="+networkAvailable);
            if(networkAvailable == 1){
                showWifiWpsPushConnectToast(SHOW,LANGUAGE.ConnectSuccess,"setting/wifi/ic_success.png");
            }else{
                showWifiWpsPushConnectToast(SHOW,LANGUAGE.ConnectFail,"setting/wifi/ic_failure.png");
            }
        }else{
            wifiWpsPush.connPercent = wifiWpsPush.connPercent+1;
            wifiWpsPushPercentImg.plus();
        }
    }

    function wpsSetPushConnStateCallBack(state){
        DBG_ERROR("wpsSetPushConnStateCallBack:state="+state);
        try{
        switch (state){
            case 0:
                wifiWpsPush.needStopWpsConnect = 0;
                break;
            case 10:
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_LINK_CHANGED, wpsSetPushConnStateCallBack);
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_CHANGED, wpsNetworkAvailableCallBack);
                wifiWpsPush.needStopWpsConnect = 0;
                clearTimeout(wifiWpsPush.PBCConnTimer);
                var networkAvailable = model.network.getEnumNetworkAvailable();
                DBG_ERROR("wpsSetPushConnStateCallBack:networkAailable="+networkAvailable);
                if(networkAvailable == 1){
                    showWifiWpsPushConnectToast(SHOW,LANGUAGE.ConnectSuccess,"setting/wifi/ic_success.png");
                }else{
                    showWifiWpsPushConnectToast(SHOW,LANGUAGE.ConnectFail,"setting/wifi/ic_failure.png");
                }
                break;
            case 7://WPS ERROR
                clearTimeout(wifiWpsPush.PBCConnTimer);
                showWifiWpsPushConnectToast(SHOW,LANGUAGE.ConnectFail,"setting/wifi/ic_failure.png");
            default :
                break;
        }
        }catch(e){
            DBG_ERROR("wpsSetPushConnStateCallBack:"+ e.message);
        }
    }
    function wpsNetworkAvailableCallBack(val){
        DBG_ERROR("wpsNetworkAvailableCallBack:"+val);
        if(1 == val){
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_LINK_CHANGED, wpsSetPushConnStateCallBack);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_CHANGED, wpsNetworkAvailableCallBack);
            showWifiWpsPushConnectToast(SHOW,LANGUAGE.ConnectSuccess,"setting/wifi/ic_success.png");
        }
    }
    wifiWpsPushCancelBtn.onkey_ENTER = function () {
//        showWifiWpsPushConnectToast(HIDE,null,null);
//        clearTimeout(wifiWpsPush.showTimeout);
        UI.popSubModule();
    };

    function showWifiWpsPushConnectToast(alpha,text,img){
        wifiWpsPushToast.alpha = alpha;
        if(img!=null && alpha == SHOW){
            UI.setImage(wifiWpsPushToastImg,img);
        }
        if(text!=null && alpha == SHOW){
            UI.setText(wifiWpsPushToastText,text);
        }
        UI.updateStage();
        clearTimeout(wifiWpsPush.showTimeout);
        if(alpha == SHOW){
            wifiWpsPush.showTimeout = setTimeout(function(){showWifiWpsPushConnectToast(HIDE,666,null)},5000);
        }
        if(text==666){
            UI.popSubModule();
        }
    }

//    wifiWpsPush.onExit = function(){
//        DBG_ALWAYS("wifiWpsPush.onExit");
//        if(tv){
//            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_LINK_CHANGED,wpsSetPushConnStateCallBack);
//        }
////        showWifiWpsPushConnectToast(HIDE,null,null);
//        clearTimeout(wifiWpsPush.showTimeout);
//        clearTimeout(wifiWpsPush.PBCConnTimer);
//    };

    wifiWpsPush.onPop = function(){
        DBG_ALWAYS("wifiWpsPush.onPop");
        if(tv){
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_LINK_CHANGED,wpsSetPushConnStateCallBack);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_CHANGED, wpsNetworkAvailableCallBack);
            if(wifiWpsPush.needStopWpsConnect != 0){
                model.network.WpsConnectStop();
            }
        }
//        showWifiWpsPushConnectToast(HIDE,null,null);
        clearTimeout(wifiWpsPush.showTimeout);
        clearTimeout(wifiWpsPush.PBCConnTimer);
    };

   
};

