// Init
UI.moduleBuilder['setting']['wifiWpsPin'] = function(){

    var mainPanelData = {
        wifiWpsPinDialogBgImg:UI['bg_overlay'],
        wifiWpsPinImg:UI.window_bg,
        wifiWpsPinToastBgImg : "toast/Toast_bg2.png",
        wifiWpsPinToastImg:"setting/ic_not_connected.png",
        wifiWpsPinCancelBtnImg:UI.item_bg,
        wifiWpsPinName:"[SE0961]",//"WPS"
        wifiWpsPinText1:"[SE3010]",//"Within 2 minutes, enter the PIN that appears on your router."
        wifiWpsPinCancelBtnText:"[GE0008]"//Cancel
    };
    var template = Util.readJson("module/setting/wifiWpsPin.json");
    var wifiWpsPin = SubModule.create(mainPanelData, template);
    var wifiWpsPinPercentBar = UI.getItem(wifiWpsPin, "wifiWpsPinPercentBar");
    var wifiWpsPinPercentImg = UI.getItem(wifiWpsPinPercentBar, "wifiWpsPinPercentImg");
    var wifiWpsPinPercentText = UI.getItem(wifiWpsPinPercentBar, "wifiWpsPinPercentText");
    var wifiWpsPinCancelBtn = UI.getItem(wifiWpsPin, "wifiWpsPinCancelBtn");
    var wifiWpsPinToast = UI.getItem(wifiWpsPin, "wifiWpsPinToast");
    var wifiWpsPinToastImg = UI.getItem(wifiWpsPinToast, "wifiWpsPinToastImg");
    var wifiWpsPinToastText = UI.getItem(wifiWpsPinToast, "wifiWpsPinToastText");

    var wifiWpsPinWord = UI.getItem(wifiWpsPin, "wifiWpsPinWord");

    var wifiWpsPinText1 = UI.getItem(wifiWpsPin, "wifiWpsPinText1");
    wifiWpsPinText1.children[0].lineHeight = 50;
    wifiWpsPinText1.children[0].lineWidth = 804;
    wifiWpsPin.noAutoClose = true;

    wifiWpsPin.connPercent = 0;
    wifiWpsPin.pinConnTimer = 0;
    wifiWpsPin.showTimeout = 0;
    wifiWpsPin.needStopWpsConnect = 0;

    var HIDE = 0;
    var SHOW = 1;

    var LANGUAGE = {
        "ConnectSuccess":"[SE0165]", //Connected successfully
        "ConnectFail":"[SE0166]" //Failed to connect. Please try again
    };
    Percent.create(wifiWpsPinPercentImg, wifiWpsPinPercentText, 0);
    wifiWpsPin.onPush =  function(){
        try{
            if(tv == false){
                wifiWpsPin.pinCode = "123456";
            }else{
                wifiWpsPin.pinCode = model.network.getWpsPinCode();
                wifiWpsPin.needStopWpsConnect = 1;
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_PIN_CODE_CHANGED, onWpsPinCodeCallBack);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_LINK_CHANGED, wpsSetPinConnStateCallBack);
                UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_CHANGED, pinNetworkAvailableCallBack);
                model.network.WpsConnectPIN();

            }
            UI.setText(wifiWpsPinWord,wifiWpsPin.pinCode);
        }catch (ex){
            DBG_ERROR("settingInitSetNetPinDialog:"+ex.message);
        }
        wifiWpsPin.pinConnTimer = setInterval(wpsSetPinTimerOut,1200);
    }
    wifiWpsPin.onShow =  function(){
        try{
            UI.focusTo(wifiWpsPinCancelBtn);
            wifiWpsPin.currFocus = UI.getItem(wifiWpsPin, "wifiWpsPinCancelBtn");
            wifiWpsPin.connPercent = 0;
            wifiWpsPinPercentImg.setPercent(0);
            wifiWpsPinPercentText.alpha = 0;
            showWifiWpsPinConnectToast(HIDE,null,null);
//            UI.setText(wifiWpsPinText1,"Within 2 minutes, enter the PIN that appears on your router.");

        }
        catch (ex){
            DBG_ERROR(ex.message);
        }
    };
    wifiWpsPin.currFocus = UI.getItem(wifiWpsPin, "wifiWpsPinCancelBtn");

    wifiWpsPinCancelBtn.onkey_ENTER = function () {
//        showWifiWpsPinConnectToast(HIDE,null,null);
//        clearTimeout(wifiWpsPin.showTimeout);
        UI.popSubModule();
    };

    function wpsSetPinTimerOut(){
        if(wifiWpsPin.connPercent > 100){
            clearTimeout(wifiWpsPin.pinConnTimer);
            var networkAvailable = tv ? model.network.getEnumNetworkAvailable():0;
            DBG_ERROR("wpsSetPinTimerOut:networkAailable="+networkAvailable);
            if(1 == networkAvailable){
                showWifiWpsPinConnectToast(SHOW,LANGUAGE.ConnectSuccess,"setting/wifi/ic_success.png");
            }else{
                showWifiWpsPinConnectToast(SHOW,LANGUAGE.ConnectFail,"setting/wifi/ic_failure.png");
            }

        }else{
            wifiWpsPin.connPercent = wifiWpsPin.connPercent+1;
            wifiWpsPinPercentImg.plus();
        }
    }
    /*pin code on change*/
    function onWpsPinCodeCallBack(pinCode){
        DBG_ALWAYS("onWpsPinCodeCallBack:"+pinCode);
        wifiWpsPin.pinCode = pinCode;
        UI.setText(wifiWpsPinWord,wifiWpsPin.pinCode);
    }

    function wpsSetPinConnStateCallBack(state){
        DBG_ERROR("settingNetSetPinConnStateCallBack:state="+state);
        try{
        switch (state){
            case 0:
                wifiWpsPin.needStopWpsConnect = 0;
                break;
            case 10:
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_LINK_CHANGED, wpsSetPinConnStateCallBack);
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_CHANGED, pinNetworkAvailableCallBack);
                wifiWpsPin.needStopWpsConnect = 0;
                var networkAvailable = model.network.getEnumNetworkAvailable();
                DBG_ERROR("settingNetSetPinConnStateCallBack:networkAailable="+networkAvailable);
                clearTimeout(wifiWpsPin.pinConnTimer);
                if(networkAvailable == 1){
                    showWifiWpsPinConnectToast(SHOW,LANGUAGE.ConnectSuccess,"setting/wifi/ic_success.png");
                }else{
                    showWifiWpsPinConnectToast(SHOW,LANGUAGE.ConnectFail,"setting/wifi/ic_failure.png");
                }
                break;
            case 7://WPS ERROR
                clearTimeout(wifiWpsPin.pinConnTimer);
                showWifiWpsPinConnectToast(SHOW,LANGUAGE.ConnectFail,"setting/wifi/ic_failure.png");
                break;
            default :
                break;
        }
        }catch(e){
            DBG_ERROR("settingNetSetPinConnStateCallBack:"+ e.message);
        }
    }
    function pinNetworkAvailableCallBack(val){
        DBG_ERROR("pinNetworkAvailableCallBack:"+val);
        if(1 == val){
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_LINK_CHANGED, wpsSetPinConnStateCallBack);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_CHANGED, pinNetworkAvailableCallBack);
            showWifiWpsPinConnectToast(SHOW,LANGUAGE.ConnectSuccess,"setting/wifi/ic_success.png");
        }
    }
    function showWifiWpsPinConnectToast(alpha,text,img){
        wifiWpsPinToast.alpha = alpha;
        if(img!=null && alpha == SHOW){
            UI.setImage(wifiWpsPinToastImg,img);
        }
        if(text!=null && alpha == SHOW){
            UI.setText(wifiWpsPinToastText,text);
        }
        UI.updateStage();
        clearTimeout(wifiWpsPin.showTimeout);
        if(alpha == SHOW){
            wifiWpsPin.showTimeout = setTimeout(function(){showWifiWpsPinConnectToast(HIDE,666,null)},5000);
        }
        if(text==666){
            UI.popSubModule();
        }
    }

//    wifiWpsPin.onExit = function(){
//        DBG_ALWAYS("wifiWpsPin.onExit");
//        if(tv){
//            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_LINK_CHANGED,wpsSetPinConnStateCallBack);
//        }
////        showWifiWpsPinConnectToast(HIDE,null,null);
//        clearTimeout(wifiWpsPin.showTimeout);
//        clearTimeout(wifiWpsPin.pinConnTimer);
//    };

    wifiWpsPin.onPop = function(){
        DBG_ALWAYS("wifiWpsPin.onPop");
        if(tv){
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_LINK_CHANGED,wpsSetPinConnStateCallBack);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_PIN_CODE_CHANGED,onWpsPinCodeCallBack);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_CHANGED, pinNetworkAvailableCallBack);
            if(wifiWpsPin.needStopWpsConnect != 0){
                DBG_ERROR("stop wps connect");
                model.network.WpsConnectStop();
            }
        }
//        showWifiWpsPinConnectToast(HIDE,null,null);
        clearTimeout(wifiWpsPin.showTimeout);
        clearTimeout(wifiWpsPin.pinConnTimer);
    }

};

