UI.moduleBuilder['setting']['storeModeSettingMenu'] = function(){

    var sellerMenuData = {
        menuchip_bg: GLOBAL.IMAGE_LIST.MENU_CHIP_BG,
        AutoPlayBackSetUp_bg: UI.item_bg,
        AutoPlayBackSetUpText:"[OT0316]",//Auto Playback Setup
//        VIDAAFeatureDemo_bg: UI.item_bg,
        EposSwitchImg1:UI.item_bg,
        EposSwitchTitle:"[OT0499]",//E-Pos Switch
        BuiltInVideoSwitchImg1:UI.item_bg,
        BuiltInVideoSwitchTitle:"[OT0500]",//Build-in Video Switch
        AutoPlayBackSetUpText: "[OT0316]",
        MCTitle:"[OT0498]"
    };
    var sellerMenuPriorityData = ["[SE3269]", "[SE3270]"];  //Built-in Video, Current Signal Input
    var isAppOn = false;
    var template = Util.readJson("module/setting/storeModeSettingMenu.json");
    var storeModeSettingMenu = SubModule.create(sellerMenuData, template);
    var AutoPlayBackSetUpContainer = UI.getItem(storeModeSettingMenu, "AutoPlayBackSetUpContainer");
    var AutoPlayBackSetUp = UI.getItem(AutoPlayBackSetUpContainer, "AutoPlayBackSetUp");
//    var VIDAAFeatureDemo =  UI.getItem(AutoPlayBackSetUpContainer, "VIDAAFeatureDemo");
    var EposSwitch = UI.getItem(AutoPlayBackSetUpContainer, "EposSwitch");
    var EposSwitchButtonImg = UI.getItem(EposSwitch, "EposSwitchButtonImg");
    var BuiltInVideoSwitch = UI.getItem(AutoPlayBackSetUpContainer, "BuiltInVideoSwitch");
    var BuiltInVideoButtonImg = UI.getItem(BuiltInVideoSwitch, "BuiltInVideoButtonImg");
    var MCList = UI.getItem(storeModeSettingMenu, "MCList");
    var crntChips = [];
    var allChips = ["[OT0501]", "[OT0502]", "[SE3271]", "[OT0315]"];//Build-in Video Update,E-Pos Update,AQ & PQ Adjust,Mall Logo,
    var updateTimer = null;
    UI.addMask(AutoPlayBackSetUpContainer, 800, 610, 50, 6);
    UI.setView(AutoPlayBackSetUpContainer, 800, 610,50,6);
    UI.addScrollbar(AutoPlayBackSetUpContainer, 6);
    switchBar_common(AutoPlayBackSetUpContainer, "EposSwitch", "EposSwitchButtonImg");
    switchBar_common(AutoPlayBackSetUpContainer, "BuiltInVideoSwitch", "BuiltInVideoButtonImg");

    function checkMenuChiplist(subModule) {
        crntChips = [SELLERCHIPS.VIDEO_UPDATE];
        crntChips.push(SELLERCHIPS.EPOS_UPDATE);
        //crntChips.push(SELLERCHIPS.AQ_PQ_ADJUST);
        crntChips.push(SELLERCHIPS.MALL_LOGO);
    }

    function switchBar_common(submodule, groupname, pic_switch_name, txt_switch_name) {
        try {
            var switchBar = UI.getItem(submodule, groupname);
            var switchComp = UI.getItem(switchBar, pic_switch_name);
            Switch.create(switchComp, true);
            UI.updateStage();
            switchBar.onFocus = function () {
                switchComp.onFocus();
                UI.updateStage();
                return true;
            };
            switchBar.onkey_ENTER = function () {
                switchMove();
            };
            switchBar.onkey_LEFT = function () {
                switchMove();
            }
            switchBar.onkey_RIGHT = function () {
                switchMove();
            }
            function switchMove() {
                try {
                    switchComp.switch();
                    UI.updateStage();
                    switch (groupname) {
                        case "EposSwitch":
                            setEposSwitchStatus(switchComp.flag);
//                            eposSwitch(switchComp.flag);
                            break;
                        case "BuiltInVideoSwitch":
                            setVideoSwitchStatus(switchComp.flag);
//                            eposPageData.operateData.isDMPPlaying = switchComp.flag;
                            break;
                        default:
                            break;
                    }
                }
                catch (ex) {
                    DBG_ERROR(ex.message);
                }
            }
        }
        catch (e) {
            DBG_ERROR("Switchbar_common func is error");
        }
    }
    function createMenuChipList() {

        try {
            checkMenuChiplist(storeModeSettingMenu);
            var gridInfo = {
                template: "sellerchipTile",
                direction: CONST.GIRD_DIRECTION.H,
                breakNum: 1,
                distanceY: 6,
                distanceX: 0,
                container: MCList
            };
            var allArray = [];
            for (var i = 0; i < crntChips.length; i++) {
                allArray.push(
                    {
                        chip_bg: UI.item_bg,
                        chipText: allChips[crntChips[i]],
                        name: "SCHIP" + crntChips[i]
                    }
                )
            }
            removeLiveTVShape(MCList);
            MCList.removeAllChildren();
            MCList.initSequence = [];
            Gird.create(allArray, gridInfo);
            storeModeSettingMenu.currFocus = AutoPlayBackSetUp;
            //selectBar_common(MCList, "SCHIP" + crntChips[1], "chipOp", sellerMenuPriorityData, "PriorityList");
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }
    BuiltInVideoSwitch.onkey_DOWN = function(){
        UI.focusTo(UI.getItem(MCList, "SCHIP" + crntChips[0]));
        return false;
    };

    storeModeSettingMenu.onPush = function () {
        createMenuChipList();
        initSwitchData();
    };
    storeModeSettingMenu.onPop = function () {
        DBG_ONXX("storeModeSettingMenu", "onPop");
        createjs.Tween.removeTweens(UI.base.cursor);
        UI.base.cursor.alpha = 0;
    }
//    VIDAAFeatureDemo.onkey_ENTER = function () {
//        //
//    }
    AutoPlayBackSetUp.onkey_ENTER = function () {
        UI.popSubModule();
        UI.pushSubModule("setting", "storeModeEposSetup", true);
        //UI.pushSubModule("EposMessage", "InitiateStoreModePage", true);
    }
    storeModeSettingMenu.onkey_ENTER = function (focus) {
        var ind = parseInt(focus.name.split("SCHIP")[1]);
        switch (ind) {
            case  SELLERCHIPS.VIDEO_UPDATE:
//               if(DiskList.length == 0){
//                   GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.STORE_MODE_NO_USB_TIP;
//                   UI.pushGhostModule("setting", "SettingSysToast");
//               }else{
//                   UI.pushSubModule("setting", "storeModeUpdate", true,{"update":"video"});
//               }
                UI.pushSubModule("setting", "storeModeUpdate", true,{"update":"video"});

                break;
            case  SELLERCHIPS.EPOS_UPDATE:
//                if(DiskList.length == 0){
//                    GLOBAL.CURRENT_TOAST_TYPE = TOASTTYPE.STORE_MODE_NO_USB_TIP;
//                    UI.pushGhostModule("setting", "SettingSysToast");
//                }else{
//                    UI.pushSubModule("setting", "storeModeUpdate", true,{"update":"picture"});
//                }
                UI.pushSubModule("setting", "storeModeUpdate", true,{"update":"picture"});
                break;
            //case  SELLERCHIPS.AQ_PQ_ADJUST:
            //    UI.popSubModule();
            //    DBG_INFO('CHIPS.SYSTEM_SETTING');
            //    UI.pushSubModule("setting", "mainPanel", true, "storeModeSettingMenu", storeModeSettingMenu.param);
            //    break;
            case  SELLERCHIPS.MALL_LOGO:
                UI.pushSubModule("setting", "storeModeMallLogo", true);
                break;
            default:
                DBG_ERROR("do not have this chip[" + ind + "].");
                break;
        }
    }

    storeModeSettingMenu.onkey_BACKSPACE = function () {
        UI.clearAllSubModule("setting");
        DBG_INFO("storeModeSettingMenu.caller is:[" + storeModeSettingMenu.caller + "].");
        if(checkIsAppOn())
        {
            registerKeyCodesForApp();
            return;
        }
        if(storeModeSettingMenu.caller == "liveTVCtrl" || storeModeSettingMenu.caller == "blank"){
            openLiveTVModule();
            return;
        }
    }

    function initSwitchData() {
        try {
            var storeModeEposSwitchStatus =  getEposSwitchStatus();
            EposSwitchButtonImg.setSwitch(storeModeEposSwitchStatus);
            var storeModeVideoSwitchStatus = getVideoSwitchStatus();
            BuiltInVideoButtonImg.setSwitch(storeModeVideoSwitchStatus);
            UI.updateStage();

        } catch (ex) {
            DBG_ERROR(ex.message)
        }
    }
    function getEposSwitchStatus(){
        try{
            var storeModeEposSwitch = readFileFromNative('hisenseUI/storeModeEposSwitch.txt', 1);
            DBG_INFO("getEposSwitchStatus:"+storeModeEposSwitch);
            if(null == storeModeEposSwitch){
                DBG_ERROR("getEposSwitchStatus:not set epos switch,return 1");
                return 1;
            }else if(storeModeEposSwitch == "open"){
                return 1;
            }else{
                return 0;
            }

        }catch (ex){
            DBG_ERROR("getEposSwitchStatus:"+ex.message);
        }

    }
    function setEposSwitchStatus(status){
        try{
            if(status){
                var result = writeFileToNative('hisenseUI/storeModeEposSwitch.txt', "open", 1);
            }else{
                var result = writeFileToNative('hisenseUI/storeModeEposSwitch.txt', "close", 1);
            }
            DBG_INFO("setEposSwitchStatus:result"+result);
            if(checkIsAppOn() && appControl.getCurrentAPPName() == APPNAME.EPOS){
//                    appControl.stopCurrentApp();
                modeljs.sendAppMessage("opera4x",'{"type":"APPMessage","source":"launcher","status":"eposSwitchChange"}');
            }
        }catch (ex){
            DBG_ERROR("setEposSwitchStatus:"+ex.message);
        }
    }
    function getVideoSwitchStatus(){
        try{
            var storeModeVideoSwitch = readFileFromNative('hisenseUI/storeModeVideoSwitch.txt', 1);
            DBG_INFO("getVideoSwitchStatus:"+storeModeVideoSwitch);
            if(null == storeModeVideoSwitch){
                DBG_ERROR("getVideoSwitchStatus:not set video switch,return 1");
                return 1;
            }else if(storeModeVideoSwitch == "open"){
                return 1;
            }else{
                return 0;
            }
        }catch (ex){
            DBG_ERROR("getVideoSwitchStatus:"+ex.message);
        }

    }
    function setVideoSwitchStatus(status){
        try{
            if(status){
                writeFileToNative('hisenseUI/storeModeVideoSwitch.txt', "open", 1);
//                localStorage.setItem("storeModeVideoSwitchStatus",1);
            }else{
                writeFileToNative('hisenseUI/storeModeVideoSwitch.txt', "close", 1);
//                localStorage.setItem("storeModeVideoSwitchStatus",0);
            }
            if(checkIsAppOn() && appControl.getCurrentAPPName() == APPNAME.EPOS){
//                    appControl.stopCurrentApp();
                modeljs.sendAppMessage("opera4x",'{"type":"APPMessage","source":"launcher","status":"videoSwitchChange"}');
            }
//            DBG_INFO("setVideoSwitchStatus:"+localStorage.getItem("storeModeVideoSwitchStatus"));
        }catch (ex){
            DBG_ERROR("setVideoSwitchStatus:"+ex.message);
        }

    }

};


