// Init
(function(){

    var slideIconsData = {
        //img_0 : "setting/pic/bright.JPG",
        //img_1 : "setting/pic/color.JPG",
        //img_2 : "setting/pic/tint.JPG",
        //img_3 : "setting/pic/sharpness.JPG",
        //img_4 : "setting/pic/contrast.JPG"
    };
    var template = Util.readJson("module/setting/roll.json");
    var slideIcons = SubModule.create(slideIconsData, template);

    slideIcons.currFocus = UI.getItem(slideIcons, "roll_0");
})();

// Actions
(function(){

    // 图像设置5项联动的实现
    var slideIcons = UI.getSubModule("slideIcons");

    // 取得5个图标对象
    var icon1 = UI.getItem(slideIcons, "roll_0");
    var icon2 = UI.getItem(slideIcons, "roll_1");
    var icon3 = UI.getItem(slideIcons, "roll_2");
    var icon4 = UI.getItem(slideIcons, "roll_3");
    var icon5 = UI.getItem(slideIcons, "roll_4");

    // 声明一个数组来管理这5个图标，用于动态设置按下上下键后图标的动画和前后顺序
    var iconArray = [icon1, icon2, icon3, icon4, icon5];

    slideIcons.onkey_UP = function() {

        // 按上键后，弹出数组末尾图标并添加到数组开头，iconArray[2]为被选图标
        iconArray.unshift(iconArray.pop());

        // 5个图标分别执行各自的动画，动画部分使用方法请参考CreateJS API TweenJS的部分
        // 对于iconArray[2]，动画执行中途，使用call方法调用了自定义的switchLayer方法进行了前后顺序的变换
        UI.getTween(iconArray[2]).to({y:20}, 200, UI.ease.quadOut).call(switchLayer, [iconArray]).to({y:100, scaleX:1, scaleY:1}, 200, UI.ease.quadIn);
        UI.getTween(iconArray[1]).to({y:50, scaleX:0.9, scaleY:0.9}, 400);
        UI.getTween(iconArray[3]).to({y:150, scaleX:0.9, scaleY:0.9}, 400);
        UI.getTween(iconArray[4]).to({y:200, scaleX:0.8, scaleY:0.8}, 400);
        UI.getTween(iconArray[0]).to({y:0, scaleX:0.8, scaleY:0.8}, 400);

    };

    slideIcons.onkey_DOWN = function() {

        // 按下键后，弹出数组开头图标并添加到数组末尾，iconArray[2]为被选图标
        iconArray.push(iconArray.shift());

        // 5个图标分别执行各自的动画，动画部分使用方法请参考CreateJS API TweenJS的部分
        // 对于iconArray[2]，动画执行中途，使用call方法调用了自定义的switchLayer方法进行了前后顺序的变换
        UI.getTween(iconArray[2]).to({y:180}, 200).call(switchLayer, [iconArray]).to({y:100, scaleX:1, scaleY:1}, 200);
        UI.getTween(iconArray[1]).to({y:50, scaleX:0.9, scaleY:0.9}, 400);
        UI.getTween(iconArray[3]).to({y:150, scaleX:0.9, scaleY:0.9}, 400);
        UI.getTween(iconArray[4]).to({y:200, scaleX:0.8, scaleY:0.8}, 400);
        UI.getTween(iconArray[0]).to({y:0, scaleX:0.8, scaleY:0.8}, 400);
    };

    // CreateJS中Container有children属性，是一个数组，包含所有子元素。图像绘制时，是以该数组的顺序绘制的
    // 后添加的图片会覆盖在先添加的图片上面，形成一个前后层的顺序
    // 所以如果想更改图片绘制的前后顺序，就要更改Container.children数组的顺序，可以调用UI.moveTo方法来更改
    function switchLayer(iconArray) {
        UI.moveTo(iconArray[2], 4);
        UI.moveTo(iconArray[1], 3);
        UI.moveTo(iconArray[3], 2);
        UI.moveTo(iconArray[4], 1);
        UI.moveTo(iconArray[0], 0);
    }

})();