/**
 * Created by manli1 on 2016-4-26.
 */
UI.moduleBuilder['setting']['picOverScanAdjust'] = function(){
    var picOverScanData = {
        bg: "setting/pic/pic_mode_bg.png",
        onImg:"setting/pic/mode/"+ GLOBAL.LAUNCHER_BRAND +"/OverScan_On.png",
        offImg:"setting/pic/mode/OverScan_Off.png",
        onOrOffBG: UI.btn_normal_bg,
        disable_bg: UI.disable_bg,
        onOrOffSwitch:"setting/pic/mode/OverScan_On.png"
    };
    var template = Util.readJsonObject("module/setting/picOverScanAdjust.json");
    var picOverScan = SubModule.create(picOverScanData, template);
    var title = UI.getItem(picOverScan, "title");
    var description = UI.getItem(picOverScan, "description");
    var switchBar = UI.getItem(picOverScan, "onOrOff");
    var isOn;
    var TtsOnOff=["[GE0006]", "[GE0005]"];//["Off", "On"],

    picOverScan.onPush = function(){
        if(PictureConfig.picOnOffSign == PicSignDefine.picOnOffSign.PIC_OVER_SCAN){
            UI.setText(description, "[SE0525]");
            UI.setText(title, "[SE0524]", false);
        }else if(PictureConfig.picOnOffSign == PicSignDefine.picOnOffSign.PIC_LOCAL_DIMMING){
            UI.setText(description, "[SE1070]");
            UI.setText(title, "[SE0972]", false);
        }
        picOverScan.currFocus = UI.getItem(picOverScan, "onOrOff");
    };
    picOverScan.onShow = function () {
        if(PictureConfig.picOnOffSign == PicSignDefine.picOnOffSign.PIC_OVER_SCAN){
            isOn = tv ? model.video.getOverscan() : 1;
            DBG_INFO("model.video.getOverscan(): " + isOn);
        }else if(PictureConfig.picOnOffSign == PicSignDefine.picOnOffSign.PIC_LOCAL_DIMMING){
            isOn = tv ? model.video.getEnumLocalDimming() : 0;
            DBG_INFO("model.video.getEnumLocalDimming(): " + isOn);
        }
        UI.setVoiceStr(switchBar,TtsOnOff[isOn]);//UI.callTTS();第一次不播报
        setOverscanImage(isOn);
        picOverScan.alpha = 1;
        if (switchBar.selectedItem) {
            switchBar.selectedItem.removeChild(selectedFlg, true);
            switchBar.selectedItem = UI.getItem(picOverScan, UI.getCurrFocus().name);
        }
        UI.getCurrFocus().addChild(selectedFlg);
        switchBar.selectedItem = UI.getItem(picOverScan, UI.getCurrFocus().name);
        UI.updateStage();
    };
    var selectedFlg = new PIXI.Graphics();
    selectedFlg.beginFill(OEMFunction.getInstance().getBrandColor()).drawRect(0, 152, 295, 8);
    selectedFlg.doFlip = true;

    switchBar.onkey_LEFT = switchBar.onkey_RIGHT = switchBar.onkey_ENTER =function () {
        DBG_INFO("picOverScan.switchBar.onkey_LEFT");
        setOverscanValue ();
    };
    function setOverscanValue (){
        DBG_INFO("isOn: " + isOn);
        isOn = isOn ?  0 : 1;
        if(PictureConfig.picOnOffSign == PicSignDefine.picOnOffSign.PIC_OVER_SCAN){
            tv && model.video.setOverscan(isOn);
            DBG_INFO("model.video.setOverscan(): " + isOn);
        }else if(PictureConfig.picOnOffSign == PicSignDefine.picOnOffSign.PIC_LOCAL_DIMMING){
            tv && model.video.setEnumLocalDimming(isOn);
            DBG_INFO("model.video.setEnumLocalDimming(): " + isOn);
        }
        UI.callTTS(TtsOnOff[isOn]);
        setOverscanImage(isOn);
        UI.updateStage();
    }
    function setOverscanImage(val){
        if(val){
            UI.setImage(picOverScan.currFocus.children[1], picOverScanData.onImg);
        }else{
            UI.setImage(picOverScan.currFocus.children[1], picOverScanData.offImg);
        }
    }
};