// Init
UI.moduleBuilder['setting']['picBal2Pot10Pot'] = function(){
    var initData = {
        fullBg: "setting/dialog_bg.png",
        dialogBg: UI.window_bg
    };
    var template = Util.readJson("module/setting/picBal2Pot10Pot.json");
    var picBal2Pot10Pot = SubModule.create(initData, template);
    picBal2Pot10Pot.noAutoClose = true;
    picBal2Pot10Pot.operateData = {
        "picBal2Pot10PotList": [
            {
                "name": "[SE0496]",
                "flag": false
            },
            {
                "name": "[SE0512]",
                "flag": false
            }
        ],
        "curIndex": 0
    };


    // 初始化Grid控件
    // 取得目标锚点
    var picBal2Pot10PotList = UI.getItem(picBal2Pot10Pot, "picBal2Pot10PotList");

    // Grid的配置信息JSON
    var info = {
        // 每个图标使用的模板名
        template: "DialogListItem",
        // V表示竖向排列，H表示横向排列
        direction: CONST.GIRD_DIRECTION.H,
        // 每隔几个图标就换行
        breakNum: 1,
        // 每隔图标之间的距离
        distanceX: 0,
        distanceY: 20,
        // 要将此Grid添加到哪个锚点位置上
        container: picBal2Pot10PotList
    };

    // 声明一个初始化用数组，将数据配置好
    var array = [];
    for (var i = 0; i < picBal2Pot10Pot.operateData.picBal2Pot10PotList.length; i++) {
        array.push(
            {
                ItemName: picBal2Pot10Pot.operateData.picBal2Pot10PotList[i].name,
                tileBg: UI.item_bg,
                name: "item" + i,
                isFlag: "setting/ic_radiobutton_normal.png"
            }
        )
    }
    // 调用Grid.create方法生成Gird并添加到锚点位置上
    Gird.create(array, info);


    picBal2Pot10Pot.currFocus = UI.getItem(picBal2Pot10PotList, "item" + picBal2Pot10Pot.operateData.curIndex);

    picBal2Pot10Pot.onPush = function () {
        PicBal2Pot10PotPageInit();
        UI.getCurrModule().currFocus = picBal2Pot10Pot.currFocus = UI.getItem(picBal2Pot10PotList, "item" + picBal2Pot10Pot.operateData.curIndex);
        UI.updateStage();
    };

    picBal2Pot10Pot.onShow = function () {
        for (var i = 0; i < picBal2Pot10PotList.initSequence.length; i++) {
            UI.setImage(picBal2Pot10PotList.children[i].children[2], "setting/ic_radiobutton_normal.png");
        }
        UI.focusTo(UI.getItem(picBal2Pot10PotList, "item" + picBal2Pot10Pot.operateData.curIndex));
        UI.setImage(picBal2Pot10Pot.currFocus.children[2], OEMFunction.getInstance().getBrandSelectFocusImage());
    };

    function PicBal2Pot10PotPageInit() {
        try {
            picBal2Pot10Pot.operateData.curIndex = tv ? model.video.getWhiteBalanceTenTwoPointsMode() : 0;
            DBG_INFO('model.video.getWhiteBalanceTenTwoPointsMode(): ' + picBal2Pot10Pot.operateData.curIndex);
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
    }


    picBal2Pot10PotList.onkey_ENTER = function (focus) {
        var index = picBal2Pot10PotList.initSequence.indexOf(focus);
        tv && model.video.setWhiteBalanceTenTwoPointsMode(index);
        DBG_INFO('model.video.setWhiteBalanceTenTwoPointsMode(' + index + ')');
        if (0 == index && picBal2Pot10Pot.caller.name == 'picPanelBal2Pot' ||
            1 == index && picBal2Pot10Pot.caller.name == 'picPanelBal10Pot'
        ) {
            UI.popSubModule();
            return true;
        } else {
            UI.popSubModule();
            UI.popSubModule();
            UI.getSubModule("picExpert").alpha = 0;

            1 == index && UI.pushSubModule("setting", "picPanelBal10Pot", true);
            0 == index && UI.pushSubModule("setting", "picPanelBal2Pot", true);
        }
    };

};