// Init
UI.moduleBuilder['setting']['picBacklightAdjust'] = function(){
    try {
        var initData = {
            bg: "setting/pic/Picture_mode_bg_percent.png",
            percentBG: "setting/pic/Picture_mode_bg_percent.png",
            onImg:"setting/pic/mode/"+ GLOBAL.LAUNCHER_BRAND +"/OverScan_On.png",
            offImg:"setting/pic/mode/OverScan_Off.png",
            UpArrow: "setting/pic/card_wheel/UpArrow.png",
            DownArrow: "setting/pic/card_wheel/DownArrow.png",
            cardWheelBg: {color: getCardWheelColor()},
            cardWheelShadow: "setting/pic/card_wheel/shadow_top.png",
            cardWheelIcon_0: "setting/pic/card_wheel/local_dimming.png",
            cardWheelIcon_1: "setting/pic/card_wheel/backlight_level.png",
            cardWheelIcon_2: "setting/pic/card_wheel/automatic_light_sensor.png",
            cardWheelIcon_3: "setting/pic/card_wheel/minimum_backlight.png"
        };
        var template = Util.readJsonObject("module/setting/picBacklightAdjust.json");

        try {
            var localDimmingSupport = tv ? model.video.getLocalDimmingExist() : 1;
            DBG_INFO('model.video.getLocalDimmingExist(): ' + localDimmingSupport);
        } catch (ex) {
            DBG_ERROR(ex.message);
        }

        var picBacklightAdjustCfg = {
            DynamicBacklightControl: {
                title: localDimmingSupport ? '[SE0972]' : '[SE0470]',
                description: localDimmingSupport ? '[SE1070]' : '[SE0471] ',//SE1070 : "Adjust the backlight by sections according to the changes in the image and increase the contrast",
                array: [
                    {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/off.png", tileTxt: "[GE0006]"},
                    {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/low.png", tileTxt: "[GE0003]"},
                    {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/medium.png", tileTxt: "[GE0002]"},
                    {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/high.png", tileTxt: "[GE0001]"}
                ]
            },
            picLocalDimmingOnOff: {
                title: '[SE0972]',
                description: '[SE1070]',
                array: [
                    {tileBg: UI.btn_normal_bg, tileImg: initData.onImg, Info:"[SE1070]"}//"Off"
                ]
            },
            AutomaticLightSensor: {
                title: '[SE3134]',
                description: '[SE2894]',
                array: [
                    {tileBg: UI.btn_normal_bg, tileImg: initData.onImg} //"setting/pic/mode/on.png"}
//                    {tileBg: UI.btn_normal_bg, tileImg: "setting/pic/mode/off.png", tileTxt: "[GE0006]"}
                ]
            }
        };
        var LocalDimmingType = {
            DynamicBacklightControl:0,
            LocalDimmingAll:1,
            LocalDimmingOnOff:2
        };
        var TtsOnOff=["[GE0006]", "[GE0005]"];//["Off", "On"],
        try {
            if(LocalDimmingType.LocalDimmingOnOff==localDimmingSupport){
                picBacklightAdjustCfg.DynamicBacklightControl = picBacklightAdjustCfg.picLocalDimmingOnOff;
            }
        } catch (ex) {
            DBG_ERROR(ex.message);
        }

        template.picBacklightAdjust.items.DynamicBacklightControl.items.title.value = picBacklightAdjustCfg.DynamicBacklightControl.title;
        template.picBacklightAdjust.items.DynamicBacklightControl.items.description.value = picBacklightAdjustCfg.DynamicBacklightControl.description;
        template.picBacklightAdjust.items.AutomaticLightSensor.items.title.value = picBacklightAdjustCfg.AutomaticLightSensor.title;
        template.picBacklightAdjust.items.AutomaticLightSensor.items.description.value = picBacklightAdjustCfg.AutomaticLightSensor.description;

        template.picBacklightAdjust.items.BacklightLevel.position.y = 1500;
        template.picBacklightAdjust.items.AutomaticLightSensor.position.y = 1500;
        template.picBacklightAdjust.items.MinimumBacklight.position.y = 1500;

        var cardWheel = {
            "type": 0,
            "position": {
                "x": 30,
                "y": 20
            },
            "items": {}
        };

        var cardWheelItem = {
            "type": 0,
            "position": {
                "x": 0,
                "y": 124
            },
            "navigation": {
                "leftTo": null,
                "rightTo": null,
                "upTo": null,
                "downTo": null
            },
            "items": {
                "cardWheelBg": {
                    "type": 7,
                    "bound": {
                        "w": 230,
                        "h": 160
                    },
                    "position": {
                        "x": 0,
                        "y": 0
                    }
                },
                "cardWheelShadow": {
                    "type": 7,
                    "bound": {
                        "w": 280,
                        "h": 200
                    },
                    "position": {
                        "x": -30,
                        "y": -20
                    }
                },
                "cardWheelIcon": {
                    "type": 7,
                    "bound": {
                        "w": 72,
                        "h": 72
                    },
                    "position": {
                        "x": 79,
                        "y": 44
                    }
                }
            }
        };

        var cardWheelItemIndexVec = [{y: 0}, {y: 95}, {y: 190}, {y: 95}];
        for (var i = 0; i < cardWheelItemIndexVec.length; i++) {
            var cardWheelItemTemp = getObjCopy(cardWheelItem);
            cardWheelItemTemp.position.y = cardWheelItemIndexVec[i].y;
            cardWheelItemTemp.items['cardWheelIcon_' + i] = getObjCopy(cardWheelItemTemp.items.cardWheelIcon);
            delete (cardWheelItemTemp.items.cardWheelIcon);
            cardWheel.items["cardWheel_" + i] = cardWheelItemTemp;

        }
        template.picBacklightAdjust.items['cardWheel'] = cardWheel;

        var picBacklightAdjust = SubModule.create(initData, template);

        var DynamicBacklightControl = UI.getItem(picBacklightAdjust, "DynamicBacklightControl");
        var DynamicBacklightControlGrid = UI.getItem(DynamicBacklightControl, "grid");
        var DynamicBacklightControlArray = [];
        for (var i = 0; i < picBacklightAdjustCfg.DynamicBacklightControl.array.length; i++) {
            DynamicBacklightControlArray.push({tileBg: picBacklightAdjustCfg.DynamicBacklightControl.array[i].tileBg,
                tileImg: picBacklightAdjustCfg.DynamicBacklightControl.array[i].tileImg,
                tileTxt: picBacklightAdjustCfg.DynamicBacklightControl.array[i].tileTxt,
                name: "DynamicBacklightControl" + i
            });
        }
        var DynamicBacklightControlInfo;
        if(LocalDimmingType.LocalDimmingOnOff==localDimmingSupport){
            DynamicBacklightControlInfo = {
                template: "picModeNewTileSecond",
                direction: CONST.GIRD_DIRECTION.V,
                breakNum: 1,
                distanceX: 20,
                distanceY: 0,
                container: DynamicBacklightControlGrid
            };
        }else{
            DynamicBacklightControlInfo = {
                template: "picModeNewTile",
                direction: CONST.GIRD_DIRECTION.V,
                breakNum: 1,
                distanceX: 20,
                distanceY: 0,
                container: DynamicBacklightControlGrid
            };
        }
        Gird.create(DynamicBacklightControlArray, DynamicBacklightControlInfo);
        UI.addMask(DynamicBacklightControlGrid, 1760, 180, 40, 30);
        UI.setView(DynamicBacklightControlGrid, 1760, 180);

        var AutomaticLightSensor = UI.getItem(picBacklightAdjust, "AutomaticLightSensor");
        var AutomaticLightSensorGrid = UI.getItem(AutomaticLightSensor, "grid");
        var AutomaticLightSensorArray = [];
        for (var i = 0; i < picBacklightAdjustCfg.AutomaticLightSensor.array.length; i++) {
            AutomaticLightSensorArray.push(picBacklightAdjustCfg.AutomaticLightSensor.array[i]);
        }
        var AutomaticLightSensorInfo = {
            template: "picModeNewTileSecond",
            direction: CONST.GIRD_DIRECTION.V,
            breakNum: 1,
            distanceX: 20,
            distanceY: 0,
            container: AutomaticLightSensorGrid
        };
        Gird.create(AutomaticLightSensorArray, AutomaticLightSensorInfo);
        UI.addMask(AutomaticLightSensorGrid, 1760, 180, 40, 30);
        UI.setView(AutomaticLightSensorGrid, 1760, 180);

        picBacklightAdjust.onPush = function () {
            try {
                DBG_INFO('picBacklightAdjust.onPush');
                var CmpVec = [DynamicBacklightControl, AutomaticLightSensor, BacklightLevel, MinimumBacklight];

                for (var i = 0; i < CmpVec.length; i++) {
                    CmpVec[i].alpha = 0;
                    CmpVec[i].y = 0;
                }
                cardWheelObj.init();
                getPicBacklightModelValue();

                //放到PicBacklightAdjustPageData.backlightVal 已经初始化之后
                setOnkeyLeftRightFunc(BacklightLevel, BacklightLevelCmp, PicBacklightAdjustPageData.backlightVal);
                setOnkeyLeftRightFunc(MinimumBacklight, MinimumBacklightCmp, PicBacklightAdjustPageData.minimumBacklightVal);

                SetPercentEnable(MinimumBacklight, PicBacklightAdjustPageData.ecoSensorOn);
                MinimumBacklightCmp.setCmpEnable(PicBacklightAdjustPageData.ecoSensorOn);   // eco on-> mini enable;
                if (localDimmingSupport!=2) {
                    BacklightLevelCmp.setCmpEnable((PicBacklightAdjustPageData.dynamicBacklightVal != 0) ? 0 : 1);
                } else {
                    var localDimmingONOFFtmp = tv ? model.video.getEnumLocalDimming() : 1;
                    BacklightLevelCmp.setCmpEnable((localDimmingONOFFtmp != 0) ? 0 : 1);
                }

                if(LocalDimmingType.LocalDimmingOnOff==localDimmingSupport){
                    picBacklightAdjust.currFocus = UI.getItem(DynamicBacklightControlGrid, "DynamicBacklightControl0");

                }else {
                    picBacklightAdjust.currFocus = UI.getItem(DynamicBacklightControlGrid, "DynamicBacklightControl" + PicBacklightAdjustPageData.dynamicBacklightVal);

                }

                if (PicBacklightAdjustPageData.isHDRFlag) {
                    AutomaticLightSensorGrid.alpha = 0.26;
                }
                UI.updateStage();
            } catch (ex) {
                DBG_ERROR(ex.message);
            }

        };

        picBacklightAdjust.onShow = function () {
            try {
                DBG_INFO('picBacklightAdjust.onShow');

                var normalCfg = {y: 0 + 175, alpha: 1};
                UI.getItem(picBacklightAdjust, PictureConfig.PicBacklightSign).alpha = 1;
                UI.getItem(picBacklightAdjust, PictureConfig.PicBacklightSign).y = normalCfg.y;

                if (DynamicBacklightControlGrid.selectedItem) {
                    DynamicBacklightControlGrid.selectedItem.removeChild(DynamicSelectedFlag, true);
                }
                if(LocalDimmingType.LocalDimmingOnOff==localDimmingSupport){
                    DynamicBacklightControlGrid.selectedItem = UI.getItem(DynamicBacklightControlGrid, "DynamicBacklightControl0");
                    UI.getItem(DynamicBacklightControlGrid, "DynamicBacklightControl0").addChild(DynamicSelectedFlag);
                }else{
                    DynamicBacklightControlGrid.selectedItem = UI.getItem(DynamicBacklightControlGrid, "DynamicBacklightControl" + PicBacklightAdjustPageData.dynamicBacklightVal);
                    UI.getItem(DynamicBacklightControlGrid, "DynamicBacklightControl" + PicBacklightAdjustPageData.dynamicBacklightVal).addChild(DynamicSelectedFlag);
                }
                if (AutomaticLightSensorGrid.selectedItem) {
                    AutomaticLightSensorGrid.selectedItem.removeChild(EcoSensorSelectedFlag, true);
                }
                AutomaticLightSensorGrid.selectedItem = UI.getItem(AutomaticLightSensorGrid, "picModeNewTileSecond" + PicBacklightAdjustPageData.ecoSensorVal);
                UI.getItem(AutomaticLightSensorGrid, "picModeNewTileSecond0").addChild(EcoSensorSelectedFlag);

            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };

        var PicBacklightAdjustPageData = {
            DynamicVec:["[GE0006]","[GE0003]","[SE0052]","[GE0001]"],
            OnOffVec:["[GE0006]","[GE0005]"],
            localDimmingOn: 0,
            ecoSensorOn:0,
            isHDRFlag: 0,

            dynamicBacklightVal: 0,
            ecoSensorVal: 0,
            backlightVal: 0,
            minimumBacklightVal: 0
        };
        var lastFocusName;
        var DynamicLastFocusName;
        var SensorLastFocusName;

        function getPicBacklightModelValue() {
            try {
                if (localDimmingSupport == LocalDimmingType.DynamicBacklightControl) {
                    var dynamicBacklightValTmp = tv ? model.video.getDynamicBacklight() : 2;
                    DBG_INFO("model.video.getDynamicBacklight(): " + dynamicBacklightValTmp);
                } else {
                    var localDimmingTmp = tv ? model.video.getEnumLocalDimming() : 1;
                    DBG_INFO('model.video.getEnumLocalDimming(): ' + localDimmingTmp);
                }
                if(LocalDimmingType.LocalDimmingOnOff==localDimmingSupport){
                    PicBacklightAdjustPageData.dynamicBacklightVal = 0;
                    PicBacklightAdjustPageData.localDimmingOn = localDimmingTmp;
                    UI.setVoiceStr(DynamicBacklightControlGrid.initSequence[0],TtsOnOff[PicBacklightAdjustPageData.localDimmingOn]);
                    setLocalDimmingOnOff(DynamicBacklightControlGrid.children[0].children[1] ,PicBacklightAdjustPageData.localDimmingOn);
                }else{
                    PicBacklightAdjustPageData.dynamicBacklightVal =
                        (localDimmingSupport == LocalDimmingType.DynamicBacklightControl) ?
                            dynamicBacklightValTmp : localDimmingTmp;
//                            LocalDimmingToUI(dynamicBacklightValTmp) : LocalDimmingToUI(localDimmingTmp);
                }
                
//                var brand = tv ? model.system.getCurBrand(): "shp";
                if (GLOBAL.LAUNCHER_BRAND == "shp"){
                    picBacklightAdjustCfg.DynamicBacklightControl.title = "[SE2891]";
                    UI.setText(UI.getItem(DynamicBacklightControl, "title"), picBacklightAdjustCfg.DynamicBacklightControl.title);
                    DBG_INFO("AdvancedAquoMotionEnhancement.name = " + picBacklightAdjustCfg.DynamicBacklightControl.title)
                }

                PicBacklightAdjustPageData.backlightVal = tv ? model.video.getBacklight() : 17;// 0~100
                DBG_INFO("model.video.getBacklight(): " + PicBacklightAdjustPageData.backlightVal);
                BacklightLevelCmp.setPercentNoVoice(PicBacklightAdjustPageData.backlightVal);


                var ecoSensorValTmp = tv ? model.video.getEcoSensor() : 0;
                DBG_INFO("model.video.getEcoSensor(): " + ecoSensorValTmp);
                PicBacklightAdjustPageData.ecoSensorOn = ecoSensorValTmp;
                setLocalDimmingOnOff(AutomaticLightSensorGrid.children[0].children[1],PicBacklightAdjustPageData.ecoSensorOn);

                PicBacklightAdjustPageData.minimumBacklightVal = tv ? model.video.getMinimumBacklight() : 18;
                DBG_INFO("model.video.getMinimumBacklight(): " + PicBacklightAdjustPageData.minimumBacklightVal);
                MinimumBacklightCmp.setPercentNoVoice(PicBacklightAdjustPageData.minimumBacklightVal);

                PicBacklightAdjustPageData.isHDRFlag = tv ? model.video.getHdrFlag() : 0;
                DBG_INFO("model.video.getHdrFlag(): " + PicBacklightAdjustPageData.isHDRFlag);

            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        }

        function setLocalDimmingOnOff(target, isOn){
            if(isOn){
                UI.setImage(target, initData.onImg, false);
            }else{
                UI.setImage(target, initData.offImg, false);
            }
        }

        function SetPercentEnable(disableItem, isEnable){
            if(!isEnable){
                DBG_INFO("disableItem: " + disableItem.name + "hide");
                UI.getItem(disableItem, 'percentBarText').alpha=0.26;
//                UI.setTextColor(UI.getItem(disableItem, 'percentBarText'), '0x85888d');
            }else{
                DBG_INFO("disableItem: " + disableItem.name + "show");
                UI.getItem(disableItem, 'percentBarText').alpha=1;
//                UI.setTextColor(UI.getItem(disableItem, 'percentBarText'), '0xF2F2F2');
            }
        }

        var BacklightLevel = UI.getItem(picBacklightAdjust, "BacklightLevel");
        var BacklightLevelCmp = UI.getItem(BacklightLevel, "percentBarLine");
        var BacklightLevelTxt = UI.getItem(BacklightLevel, "percentBarText");

        var MinimumBacklight = UI.getItem(picBacklightAdjust, "MinimumBacklight");
        var MinimumBacklightCmp = UI.getItem(MinimumBacklight, "percentBarLine");
        var MinimumBacklightTxt = UI.getItem(MinimumBacklight, "percentBarText");

        function CardWheelFunc() {
            var self = this;
            var cardWheelVec = [];
            self.cardWheelVec = cardWheelVec;
            var cardWheelLength = 4;
            for (var i = 0; i < cardWheelLength; i++) {
                self.cardWheelVec.push(UI.getItem(picBacklightAdjust, "cardWheel_" + i));
            }
            var posYVec = [0 + 80, 95 + 80, 190 + 80, 95 + 80];
            var DelayTimeData = {
                Time_0: 0,
                Time_400: 400
            };
            var ToVecNumeber = {
                Vec0: 0,
                Vec1: 1,
                Vec2: 2
            };
            var ToYPosition = {
                Y_57: 57,
                Y_80: 80,
                Y_105: 105
            };

            self.setHeadIdx = function (idx) {
                try {
                    DBG_INFO('self.setHeadIdx: ' + idx);
                    for (var i = 0; i < idx; i++) {
                        cardWheelVec.unshift(cardWheelVec.pop());
                    }
                    getTweenTime(ToVecNumeber.Vec1,DelayTimeData.Time_0,ToYPosition.Y_80);
                    switchLayer(cardWheelVec)
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
            };

            self.init = function () {
                var picBacklightAdjustSignVec = ['DynamicBacklightControl', 'BacklightLevel',
                    'AutomaticLightSensor', 'MinimumBacklight'];
                var idx = picBacklightAdjustSignVec.indexOf(PictureConfig.PicBacklightSign);
                DBG_INFO("PictureConfig.PicBacklightSign "+ PictureConfig.PicBacklightSign);
                cardWheelVec = [];
                for (var i = 0; i < cardWheelLength; i++) {
                    cardWheelVec.push(UI.getItem(picBacklightAdjust, "cardWheel_" + i));
                }
                self.setHeadIdx(({0: 1, 1: 0, 2: 3, 3: 2}[idx]));
            };
            function switchLayer(cardWheelVec) {
                UI.moveTo(cardWheelVec[1], 3);
                UI.moveTo(cardWheelVec[2], 2);
                UI.moveTo(cardWheelVec[3], 1);
                UI.moveTo(cardWheelVec[0], 0);
            }
            self.keyUp = function () {
                cardWheelVec.unshift(cardWheelVec.pop());
                getTweenTime(ToVecNumeber.Vec0,DelayTimeData.Time_400,ToYPosition.Y_57);
            };
            self.keyDown = function () {
                cardWheelVec.push(cardWheelVec.shift());
                getTweenTime(ToVecNumeber.Vec2,DelayTimeData.Time_400,ToYPosition.Y_105);
            };

            function getTweenTime(number,time,position) {
                DBG_INFO('posYVec['+number + '] ' + 'delayTime:' + time + ' toPosition:' + position);
                UI.getTween(cardWheelVec[1]).to({y: posYVec[number], alpha: 1}, time/2, UI.ease.quadOut).call(switchLayer, [cardWheelVec]).to({
                    y: posYVec[1]
                }, time/2, UI.ease.quadIn);
                UI.getTween(UI.getItem(cardWheelVec[1],"cardWheelIcon_"+cardWheelVec[1].name.substr(10))).to({y: position}, time/2,UI.ease.quadOut).to({y:ToYPosition.Y_80,alpha: 1},time/2,UI.ease.quadIn);
                UI.getTween(UI.getItem(cardWheelVec[1],"cardWheelIcon_"+cardWheelVec[1].name.substr(10)).scale).to({x: 1, y: 1});

                UI.getTween(cardWheelVec[2]).to({y: posYVec[2], alpha: 0.8}, time);
                UI.getTween(UI.getItem(cardWheelVec[2],"cardWheelIcon_"+cardWheelVec[2].name.substr(10))).to({y: 105, alpha: 0.8}, 100);
                UI.getTween(UI.getItem(cardWheelVec[2],"cardWheelIcon_"+cardWheelVec[2].name.substr(10)).scale).to({x: 0.67, y: 0.67});
                UI.getTween(cardWheelVec[0]).to({y: posYVec[0], alpha: 0.8}, time);
                UI.getTween(UI.getItem(cardWheelVec[0],"cardWheelIcon_"+cardWheelVec[0].name.substr(10))).to({y: 57, alpha: 0.8}, 100);
                UI.getTween(UI.getItem(cardWheelVec[0],"cardWheelIcon_"+cardWheelVec[0].name.substr(10)).scale).to({x: 0.67, y: 0.67});


                UI.getTween(cardWheelVec[3]).to({y: posYVec[3], alpha: 0}, 0);
                UI.getTween(UI.getItem(cardWheelVec[3],"cardWheelIcon_"+cardWheelVec[3].name.substr(10))).to({y: 80, alpha: 0}, 100);
                UI.getTween(UI.getItem(cardWheelVec[3],"cardWheelIcon_"+cardWheelVec[3].name.substr(10)).scale).to({x: 1, y: 1});
            }

        }

        var cardWheelObj = new CardWheelFunc();
        
        Percent.create(BacklightLevelCmp, BacklightLevelTxt, PicBacklightAdjustPageData.backlightVal, 0, 100);
        Percent.create(MinimumBacklightCmp, MinimumBacklightTxt, PicBacklightAdjustPageData.minimumBacklightVal, 0, 20, ({
            0: true,
            1: false
        }[PicBacklightAdjustPageData.ecoSensorOn]));

        var DynamicSelectedFlag= new PIXI.Graphics();
        DynamicSelectedFlag.beginFill(OEMFunction.getInstance().getBrandColor()).drawRect(0, 152, 295, 8);
        var EcoSensorSelectedFlag = new PIXI.Graphics();
        EcoSensorSelectedFlag.beginFill(OEMFunction.getInstance().getBrandColor()).drawRect(0, 152, 295, 8);
        DynamicBacklightControlGrid.onFocus = function (focus) {
            setting.onNormal(focus);
            DBG_INFO("DynamicBacklightControlGrid.onFocus");
            var currFocus = picBacklightAdjust.currFocus;
            DynamicLastFocusName = currFocus.name;
            if (!DynamicBacklightControlGrid.selectedItem) {
                currFocus.addChild(DynamicSelectedFlag);
                DynamicBacklightControlGrid.selectedItem = UI.getItem(DynamicBacklightControlGrid, currFocus.name);
            }
            var TtsStr;
            var index;
            if (localDimmingSupport == LocalDimmingType.LocalDimmingOnOff){
                var curFocusIdx = PicBacklightAdjustPageData.localDimmingOn;
                TtsStr=PicBacklightAdjustPageData.OnOffVec[curFocusIdx];
                index=0;
            }else{
                index = eval(picBacklightAdjust.currFocus.name.substr(23));
                TtsStr=PicBacklightAdjustPageData.DynamicVec[index];
            }
            UI.setVoiceStr(DynamicBacklightControlGrid.initSequence[index],
                    picBacklightAdjustCfg.DynamicBacklightControl.title + TtsStr);
            UI.updateStage();
            return true;
        };
        DynamicBacklightControlGrid.onNormal = function (focus) {
            DBG_INFO("DynamicBacklightControlGrid.onNormal");
            if (GLOBAL.HICONTRAST) {
                UI.base.toNormalContrast(UI.getItem(DynamicBacklightControlGrid, DynamicLastFocusName));
            }
            return true;
        };
        function LocalDimmingToUI(Tmp){
            var val;
            switch (localDimmingSupport){
                case LocalDimmingType.DynamicBacklightControl:
                    val = {0: 3, 1: 2, 2: 1, 3: 0}[Tmp];
                    break;
                case LocalDimmingType.LocalDimmingAll:
                    val = {0: 3, 1: 2, 2: 1, 3: 0}[Tmp];
                    break;
                case LocalDimmingType.LocalDimmingOnOff:
                    val = Tmp;
                    break;
                default:
                    DBG_ERROR("localDimmingSupport ERR");
                    break;
            }
            return val;
        }

        function LocalDimmingToBottom(val){
            var Idx;
            switch (localDimmingSupport){
                case LocalDimmingType.DynamicBacklightControl:
                    Idx = {0: 3, 1: 2, 2: 1, 3: 0}[val];
                    break;
                case LocalDimmingType.LocalDimmingAll:
                    Idx = {0: 3, 1: 2, 2: 1, 3: 0}[val];
                    break;
                case LocalDimmingType.LocalDimmingOnOff:
                    Idx = val;
                    break;
                default:
                    DBG_ERROR("localDimmingSupport ERR");
                    break;
            }
            return Idx;
        }

        var logReportModeVec={
            "DynamicBacklightControl":["Off","Low","Middle","High"],
            "LocalDimming":["Off","Low","Middle","High"],
            "LocalDimmingOnOff":["Off","On"]
        };
        var logReportStr="";

        DynamicBacklightControlGrid.onkey_ENTER = function () {
            var currFocus = picBacklightAdjust.currFocus;
            if (DynamicBacklightControlGrid.selectedItem) {
                DynamicBacklightControlGrid.selectedItem.removeChild(DynamicSelectedFlag, true);
                DynamicBacklightControlGrid.selectedItem = UI.getItem(DynamicBacklightControlGrid, currFocus.name);
            }
            var curFocusIdx;
            if (localDimmingSupport == LocalDimmingType.DynamicBacklightControl) {
                currFocus.addChildAt(DynamicSelectedFlag,currFocus.children.length-2);
                PicBacklightAdjustPageData.dynamicBacklightVal = parseInt(currFocus.name.substr(23));
                curFocusIdx = PicBacklightAdjustPageData.dynamicBacklightVal;
                tv && model.video.setDynamicBacklight(curFocusIdx);
                BacklightLevelCmp.setCmpEnable((curFocusIdx != 0) ? 0 : 1);
                logReportStr="Dynamic Backlight Control";
                DBG_INFO("logReportModeVec.DynamicBacklightControl:"+logReportModeVec.DynamicBacklightControl[curFocusIdx]);
                try {
                    LGReport.GTSETItem(logReportStr, logReportModeVec.DynamicBacklightControl[curFocusIdx]);
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
                DBG_INFO('model.video.setDynamicBacklight(' + curFocusIdx + ')');
            } else if (localDimmingSupport == LocalDimmingType.LocalDimmingAll){
                currFocus.addChildAt(DynamicSelectedFlag,currFocus.children.length-2);
                PicBacklightAdjustPageData.dynamicBacklightVal = parseInt(currFocus.name.substr(23));
                curFocusIdx = PicBacklightAdjustPageData.dynamicBacklightVal;//LocalDimmingToBottom(PicBacklightAdjustPageData.dynamicBacklightVal);
                tv && model.video.setEnumLocalDimming(curFocusIdx);
                DBG_INFO('model.video.setEnumLocalDimming(' + curFocusIdx + ')');
                BacklightLevelCmp.setCmpEnable((curFocusIdx != 0) ? 0 : 1);
                logReportStr="Local Dimming";
                DBG_INFO("logReportModeVec.LocalDimming:"+logReportModeVec.LocalDimming[curFocusIdx]);
                try {
                    LGReport.GTSETItem(logReportStr, logReportModeVec.LocalDimming[curFocusIdx]);
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
            }else if (localDimmingSupport == LocalDimmingType.LocalDimmingOnOff){
                currFocus.addChild(DynamicSelectedFlag);
                curFocusIdx = PicBacklightAdjustPageData.localDimmingOn;
                curFocusIdx = curFocusIdx ? 0 : 1;
                PicBacklightAdjustPageData.localDimmingOn = curFocusIdx;
                tv && model.video.setEnumLocalDimming(curFocusIdx);
                DBG_INFO('model.video.setEnumLocalDimming(' + curFocusIdx + ')');
                UI.setVoiceStr(DynamicBacklightControlGrid.initSequence[0],TtsOnOff[PicBacklightAdjustPageData.localDimmingOn]);
                setLocalDimmingOnOff(DynamicBacklightControlGrid.children[0].children[1],curFocusIdx);
                BacklightLevelCmp.setCmpEnable((curFocusIdx != 0) ? 0 : 1);
                logReportStr="Local Dimming";
                DBG_INFO("logReportModeVec.LocalDimming:"+logReportModeVec.LocalDimmingOnOff[curFocusIdx]);
                try {
                    LGReport.GTSETItem(logReportStr, logReportModeVec.LocalDimmingOnOff[curFocusIdx]);
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
            }
            UI.updateStage();
        };

        if(localDimmingSupport == LocalDimmingType.LocalDimmingOnOff){
            DynamicBacklightControlGrid.onkey_LEFT = DynamicBacklightControlGrid.onkey_RIGHT = DynamicBacklightControlGrid.onkey_ENTER;
        }

        AutomaticLightSensorGrid.onFocus = function () {
            DBG_INFO("AutomaticLightSensorGrid.onFocus");
            var currFocus = picBacklightAdjust.currFocus;
            SensorLastFocusName = currFocus.name;
            if (!AutomaticLightSensorGrid.selectedItem) {
                currFocus.addChild(EcoSensorSelectedFlag);
                AutomaticLightSensorGrid.selectedItem = UI.getItem(AutomaticLightSensorGrid, currFocus.name);
            }
            var curFocusIdx = PicBacklightAdjustPageData.ecoSensorOn;
            UI.setVoiceStr(AutomaticLightSensorGrid.initSequence[0],
                    picBacklightAdjustCfg.AutomaticLightSensor.title + PicBacklightAdjustPageData.OnOffVec[curFocusIdx]);
            UI.updateStage();
            return true;
        };

        AutomaticLightSensorGrid.onkey_LEFT = AutomaticLightSensorGrid.onkey_RIGHT = AutomaticLightSensorGrid.onkey_ENTER = function () {
            if (!PicBacklightAdjustPageData.isHDRFlag) {
                var currFocus = picBacklightAdjust.currFocus;
                if (AutomaticLightSensorGrid.selectedItem) {
                    AutomaticLightSensorGrid.selectedItem.removeChild(EcoSensorSelectedFlag, true);
                    AutomaticLightSensorGrid.selectedItem = UI.getItem(AutomaticLightSensorGrid, currFocus.name);
                }
                currFocus.addChild(EcoSensorSelectedFlag);
//            currFocus.addChildAt(EcoSensorSelectedFlag,currFocus.children.length-2);
                PicBacklightAdjustPageData.ecoSensorVal = 0;
                var curFocusIdx = ({0: 1, 1: 0}[PicBacklightAdjustPageData.ecoSensorOn]);
                PicBacklightAdjustPageData.ecoSensorOn = curFocusIdx;
                tv && model.video.setEcoSensor(curFocusIdx);
                DBG_INFO('model.video.setEcoSensor(' + curFocusIdx + ')');
                UI.setVoiceStr(AutomaticLightSensorGrid.initSequence[0],TtsOnOff[PicBacklightAdjustPageData.ecoSensorOn]);
                setLocalDimmingOnOff(AutomaticLightSensorGrid.children[0].children[1],curFocusIdx);
                SetPercentEnable(MinimumBacklight, curFocusIdx);
                MinimumBacklightCmp.setCmpEnable(curFocusIdx);   // eco on-> mini enable;
                UI.updateStage();
            }
        };

        AutomaticLightSensorGrid.setOff = function () {
            try {
                DBG_INFO('AutomaticLightSensorGrid.setOff');
                if (PicBacklightAdjustPageData.ecoSensorOn == 0) {
                    return;
                }
                PicBacklightAdjustPageData.ecoSensorOn = 0;
                if (AutomaticLightSensorGrid.selectedItem) {
                    AutomaticLightSensorGrid.selectedItem.removeChild(EcoSensorSelectedFlag, true);
                    AutomaticLightSensorGrid.selectedItem = UI.getItem(AutomaticLightSensorGrid, 'picModeNewTileSecond' + PicBacklightAdjustPageData.ecoSensorVal);
                }
                UI.getItem(AutomaticLightSensorGrid, 'picModeNewTileSecond' + PicBacklightAdjustPageData.ecoSensorVal).addChild(EcoSensorSelectedFlag);
                setLocalDimmingOnOff(AutomaticLightSensorGrid.children[0].children[1],PicBacklightAdjustPageData.ecoSensorOn);
                SetPercentEnable(MinimumBacklight, PicBacklightAdjustPageData.ecoSensorOn);
                MinimumBacklightCmp.setCmpEnable(PicBacklightAdjustPageData.ecoSensorOn);   // eco on-> mini enable;
                tv && model.video.setEcoSensor(PicBacklightAdjustPageData.ecoSensorOn);
                DBG_INFO('model.video.setEcoSensor(' + PicBacklightAdjustPageData.ecoSensorOn + ')');
                UI.updateStage();
            } catch (ex) {
                DBG_ERROR(ex.message);
            }
        };

        function setOnkeyUpDownFunc(cmpOri, cmpUpTo, cmpDownTo) {
            var topCfg = {y: -100 + 175, alpha: 0};
            var normalCfg = {y: 0 + 175, alpha: 1};
            var btmCfg = {y: 100 + 175, alpha: 0};

            cmpOri.onkey_UP = function (focus) {
                try {
                    DBG_INFO(cmpOri.name + ".onkey_UP");
                    UI.getTween(cmpOri).to(btmCfg, 300);
                    UI.getTween(cmpUpTo).to(topCfg, 0).to(normalCfg, 400);

                    var lastFocusName;
                    if (cmpUpTo.name == "BacklightLevel" || cmpUpTo.name == "MinimumBacklight") {
                        picBacklightAdjust.currFocus = cmpUpTo;
                        TTSCall(cmpUpTo);
                    } else {//mode to mode
                        if (cmpUpTo.name == "DynamicBacklightControl") {
                            lastFocusName = localDimmingSupport == LocalDimmingType.LocalDimmingOnOff
                                ? "DynamicBacklightControl" + PicBacklightAdjustPageData.dynamicBacklightVal
                                :"DynamicBacklightControl" + PicBacklightAdjustPageData.dynamicBacklightVal;
                            if(localDimmingSupport == LocalDimmingType.LocalDimmingOnOff){
                                UI.setVoiceStr(DynamicBacklightControlGrid.initSequence[0],TtsOnOff[PicBacklightAdjustPageData.localDimmingOn]);
                            }
                            picBacklightAdjust.currFocus = UI.getItem(DynamicBacklightControlGrid, lastFocusName);
                            UI.focusTo(UI.getItem(DynamicBacklightControlGrid, lastFocusName));
                        } else if (cmpUpTo.name == "AutomaticLightSensor") {
                            lastFocusName = "picModeNewTileSecond" + PicBacklightAdjustPageData.ecoSensorVal;
                            UI.setVoiceStr(AutomaticLightSensorGrid.initSequence[0],TtsOnOff[PicBacklightAdjustPageData.ecoSensorOn]);
                            picBacklightAdjust.currFocus = UI.getItem(AutomaticLightSensorGrid, lastFocusName);
                            UI.focusTo(UI.getItem(AutomaticLightSensorGrid, lastFocusName));
                        } else {
                            DBG_INFO(cmpOri.name + ".onkey_UP ERROR");
                        }
                    }
                    PictureConfig.PicBacklightSign = cmpUpTo.name;
                    DBG_INFO("PictureConfig.PicBacklightSign"+cmpUpTo.name);
                    cardWheelObj.keyUp();
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
            };

            cmpOri.onkey_DOWN = function (focus) {
                try {
                    DBG_INFO(cmpOri.name + ".onkey_DOWN");
                    UI.getTween(cmpOri).to(topCfg, 300);
                    UI.getTween(cmpDownTo).to(btmCfg, 0).to(normalCfg, 400);

                    if (cmpDownTo.name == "BacklightLevel" || cmpDownTo.name == "MinimumBacklight") {
                        picBacklightAdjust.currFocus = cmpDownTo;
                        TTSCall(cmpDownTo);
                    } else {//mode to mode
                        if (cmpDownTo.name == "DynamicBacklightControl") {
                            lastFocusName = localDimmingSupport == LocalDimmingType.LocalDimmingOnOff
                                ? "DynamicBacklightControl" + PicBacklightAdjustPageData.dynamicBacklightVal
                                :"DynamicBacklightControl" + PicBacklightAdjustPageData.dynamicBacklightVal;
                            if(localDimmingSupport == LocalDimmingType.LocalDimmingOnOff){
                                UI.setVoiceStr(DynamicBacklightControlGrid.initSequence[0],TtsOnOff[PicBacklightAdjustPageData.localDimmingOn]);
                            }
                            picBacklightAdjust.currFocus = UI.getItem(DynamicBacklightControlGrid, lastFocusName);
                            UI.focusTo(UI.getItem(DynamicBacklightControlGrid, lastFocusName));
                        } else if (cmpDownTo.name == "AutomaticLightSensor") {
                            lastFocusName = "picModeNewTileSecond" + PicBacklightAdjustPageData.ecoSensorVal;
                            UI.setVoiceStr(AutomaticLightSensorGrid.initSequence[0],TtsOnOff[PicBacklightAdjustPageData.ecoSensorOn])
                            picBacklightAdjust.currFocus = UI.getItem(AutomaticLightSensorGrid, lastFocusName);
                            UI.focusTo(UI.getItem(AutomaticLightSensorGrid, lastFocusName));
                        } else {
                            DBG_INFO(cmpOri.name + ".onkey_UP ERROR");
                        }
                    }
                    PictureConfig.PicBacklightSign = cmpDownTo.name;
                    DBG_INFO("PictureConfig.PicBacklightSign"+cmpDownTo.name);
                    cardWheelObj.keyDown();
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
            };
        }

        function TTSCall(cmpTo){
            if (cmpTo.name == "BacklightLevel"){
                UI.callTTS("[SE3131]"+eval("PicBacklightAdjustPageData.backlightVal") + " ");
                DBG_INFO("UI.callTTS: "+ "[SE3131]"+eval("PicBacklightAdjustPageData.backlightVal") + " ");
            }else{
                UI.callTTS("[SE0475]"+eval("PicBacklightAdjustPageData.minimumBacklightVal") + " ");
                DBG_INFO("UI.callTTS: "+ "[SE0475]"+eval("PicBacklightAdjustPageData.minimumBacklightVal") + " ");
            }
        }


        setOnkeyUpDownFunc(DynamicBacklightControl, MinimumBacklight, BacklightLevel);
        setOnkeyUpDownFunc(BacklightLevel, DynamicBacklightControl, AutomaticLightSensor);
        setOnkeyUpDownFunc(AutomaticLightSensor, BacklightLevel, MinimumBacklight);
        setOnkeyUpDownFunc(MinimumBacklight, AutomaticLightSensor, DynamicBacklightControl);


        function setOnkeyLeftRightFunc(bar, comp, val) {
            function setModelValue(name, val) {
                switch (name) {
                    case "BacklightLevel":
                        tv && model.video.setBacklight(val);
                        DBG_INFO("model.video.setBacklight(" + val + ")");
                        PicBacklightAdjustPageData.backlightVal=val;
                        break;
                    case "MinimumBacklight":
                        tv && model.video.setMinimumBacklight(val);
                        DBG_INFO("model.video.setMinimumBacklight(" + val + ")");
                        PicBacklightAdjustPageData.minimumBacklightVal=val;
                        break;
                    default:
                        DBG_ERROR('setModelValue Error[name error]');
                        break;
                }
            }

            bar.onkey_LEFT = function () {
                try {
                    DBG_INFO(bar.name + ".onkey_LEFT");
                    if (false == comp.getCmpEnable()) {
                        return;
                    }
                    val -= 1;
                    var minVal = 0;
                    val < minVal && (val = minVal);
                    comp.setPercent(val);
                    setModelValue(bar.name, val);
                    if ("BacklightLevel" == bar.name) {
                        AutomaticLightSensorGrid.setOff();
                    }
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
            };
            bar.onkey_RIGHT = function () {
                try {
                    DBG_INFO(bar.name + ".onkey_RIGHT");
                    if (false == comp.getCmpEnable()) {
                        return;
                    }
                    val += 1;
                    var maxVal = 100;
                    if (bar.name == "MinimumBacklight") {
                        maxVal = 20
                    }
                    val > maxVal && (val = maxVal);
                    comp.setPercent(val);
                    setModelValue(bar.name, val);
                    if ("BacklightLevel" == bar.name) {
                        AutomaticLightSensorGrid.setOff();
                    }
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
            };
            bar.onFocus = function () {
                return false;
            };
            bar.onNormal = function () {
                if (GLOBAL.HICONTRAST) {
                    UI.base.toNormalContrast(UI.getItem(DynamicBacklightControlGrid, DynamicLastFocusName));
                    UI.base.toNormalContrast(UI.getItem(AutomaticLightSensorGrid, SensorLastFocusName));
                }
                return true;
            }
        }

        function setOnkeyEnterFunc(cmp){
            cmp.onkey_ENTER = function (focus) {
                return false;
            }
        }
        setOnkeyEnterFunc(BacklightLevel);
        setOnkeyEnterFunc(MinimumBacklight);

    } catch (ex) {
        DBG_ERROR(ex.message);
    }
};