// Init
UI.moduleBuilder['setting']['networkTest'] = function(){

    var HIDE = 0;
    var SHOW = 1;

    var LANGUAGE = {
        "Connecting":"[SE0625]", //Testing, please wait……
        "ConnectSuccess":"[OT0430]", //"Connected successfully. If you have any problem using online services, please contact your internet provider.",
        "ConnectFail":"[SE0166]", //Failed to connect. Please try again
        "wiredConnectFail":"[OT0432]", //"No Ethernet connectivity is established. Please try wireless connection, or check your IP settings.",
        "wirelessConnectFail":"[OT0431]" //"A wireless connection was not established. Make sure your router is within 10 feet or use a cable.",

    };
    var mainPanelData = {
        networkTestBgImg:"",
        networkTestBg:UI.back_bg,
        networkTestCancelImg:UI.btn_normal_bg,
        "networkTestTVImg":"setting/wifi/ic_tv.png",
        "networkTestLine1Img":"setting/wifi/line_150x8.png",
        "light1":"setting/wifi/light_75x8.png",
        "networkTestLocalResultImg":"setting/wifi/ic_success_36x36.png",
        "networkTestRouterImg":"setting/wifi/ic_router.png",
        "networkTestLine2Img":"setting/wifi/line_150x8.png",
        "light2":"setting/wifi/light_75x8.png",
        "networkTestInternetResultImg":"setting/wifi/ic_wrong.png",
        "networkTestInternetImg":"setting/wifi/ic_internet.png",
        networkTestTitle1:"[SE0623]", //Network Test
        networkTestCancelText:"[GE0008]"//"Cancel"
    };
    var template = Util.readJson("module/setting/networkTest.json");
    var networkTest = SubModule.create(mainPanelData, template);
    var networkTestPageGrp = UI.getItem(networkTest,"networkTestPageGrp");
    var networkTestCancelBtn = UI.getItem(networkTestPageGrp,"networkTestCancelBtn");
    var networkTestStatusGrp = UI.getItem(networkTestPageGrp,"networkTestStatusGrp");

    var networkTestCancelText = UI.getItem(networkTestCancelBtn,"networkTestCancelText");
    var networkTestLight1Group = UI.getItem(networkTestStatusGrp,"networkTestLight1Group");
    var light1 = UI.getItem(networkTestLight1Group,"light1");
    var networkTestLocalResultImg = UI.getItem(networkTestStatusGrp,"networkTestLocalResultImg");
    var networkTestLight2Group = UI.getItem(networkTestStatusGrp,"networkTestLight2Group");
    var light2 = UI.getItem(networkTestLight2Group,"light2");
    var networkTestInternetResultImg = UI.getItem(networkTestStatusGrp,"networkTestInternetResultImg");

    var networkTestText = UI.getItem(networkTestPageGrp,"networkTestText");

    networkTest.noAutoClose = true;
//    networkTest.networkLocalTestTimer = 0;
    networkTest.networkInternetTestTimer = 0;
    var networkType = NetWorkType.ETHER;
    networkTest.onPush =  function(){
        networkTestLocalResultImg.alpha = 0;
        networkTestInternetResultImg.alpha = 0;
        light1.alpha = 0;
        light2.alpha = 0;
        networkTestText.alpha = 0;
        UI.setText(networkTestCancelText,"[GE0008]");
        var networkMainPanel = UI.getSubModule("networkMainPanel");
        if(networkMainPanel){
            networkMainPanel.alpha = 0;
        }
        var localAvailable =tv ? model.network.getEnumNetworkAvailable() : 1;
        networkType = tv ? model.network.getEnumNetworking() : NetWorkType.ETHER;
        if(localAvailable != 0){
            networkLocalConnectFresh();
            UI.setVoiceStr(networkTestCancelBtn,LANGUAGE.Connecting+" "+"[GE0008]");
        }else{
            networkLocalDisconnectFresh();
            switch (networkType){
                case NetWorkType.ETHER:
                    UI.setVoiceStr(networkTestCancelBtn,LANGUAGE.wiredConnectFail+" "+"[GE0007]");
                    break;
                case NetWorkType.WIRELESS:
                    UI.setVoiceStr(networkTestCancelBtn,LANGUAGE.wirelessConnectFail+" "+"[GE0007]");
                    break;
                default :
                    UI.setVoiceStr(networkTestCancelBtn,LANGUAGE.ConnectFail+" "+"[GE0007]");
                    break;
            }
        }
        networkTest.currFocus = UI.getItem(networkTest, "networkTestCancelBtn");
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_CHANGED, networkTestLocalStateChanged);
    };

    networkTest.onShow =  function(){

    };
    networkTest.currFocus = UI.getItem(networkTest, "networkTestCancelBtn");
    function networkLocalDisconnectFresh(){
        UI.setImage(networkTestLocalResultImg,"setting/wifi/ic_wrong.png");
        UI.setImage(networkTestInternetResultImg,"setting/wifi/ic_wrong.png");
        switch (networkType){
            case NetWorkType.ETHER:
                UI.setText(networkTestText,LANGUAGE.wiredConnectFail);
                break;
            case NetWorkType.WIRELESS:
                UI.setText(networkTestText,LANGUAGE.wirelessConnectFail);
                break;
            default :
                UI.setText(networkTestText,LANGUAGE.ConnectFail);
                break;
        }
        UI.setText(networkTestCancelText,"[GE0007]");
        networkTestLocalResultImg.alpha = 1;
        networkTestInternetResultImg.alpha = 1;
        networkTestText.alpha = 1;
    }
    function networkLocalConnectFresh(){
        UI.setImage(networkTestLocalResultImg,"setting/wifi/ic_success_36x36.png");
        networkTestLocalResultImg.alpha = 1;
        networkStartTest();
    }
    function networkTestLocalStateChanged(val){
        DBG_ERROR("networkTestLocalStateChanged:"+val);
        if(val == 0){
            networkLocalDisconnectFresh();
            switch (networkType){
                case NetWorkType.ETHER:
                    UI.callTTS(LANGUAGE.wiredConnectFail+" "+"[GE0007]");
                    break;
                case NetWorkType.WIRELESS:
                    UI.callTTS(LANGUAGE.wirelessConnectFail+" "+"[GE0007]");
                    break;
                default :
                    UI.callTTS(LANGUAGE.ConnectFail+" "+"[GE0007]");
                    break;
            }
        }else{
            networkLocalConnectFresh();
            UI.callTTS(LANGUAGE.Connecting+" "+"[GE0008]");
        }
    }
    function networkStartTest(){
        if(tv){
            var testState = model.network.getEnumTestState();
            if(testState != 0){
                DBG_ERROR("networkStartTest:internet is testing!!!");
                model.network.TestStop();
            }
            DBG_ERROR("networkStartTest:"+testState);
            model.network.TestStart();
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_TEST_STATE_CHANGED, testStateChangeCallBack);
        }
        light2.alpha = 1;
        doSlideAnimation(light2);
        UI.setText(networkTestText,LANGUAGE.Connecting);
        networkTestText.alpha = 1;
        clearTimeout(networkTest.networkInternetTestTimer);
        networkTest.networkInternetTestTimer = setTimeout(networkInternetTimeout,10000);
    }
    function doSlideAnimation(target) {
        target.x = 75;
        createjs.Tween.removeTweens(target);
        createjs.Tween.removeTweens(target.scale);
        target.scale.x = 1;
        target.scale.y = 1;

        UI.getTween(target, true, true).to({x: target.x + 38}, 1800, UI.ease.linear).call(function (nextIndex) {
            doSlideAnimation(target);
        });
    }

    function networkInternetTimeout(){
        clearTimeout(networkTest.networkInternetTestTimer);
        light2.alpha = 0;
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_TEST_STATE_CHANGED,testStateChangeCallBack);
        if(tv){
            model.network.TestStop();
            var interAvailable = model.network.getEnumExternalNetworkAvailable();
            DBG_ERROR("networkInternetTimeout:internetAvailable:"+interAvailable);
        }else{
            var interAvailable = 0;
        }
        if(interAvailable != 0){
            UI.setImage(networkTestInternetResultImg,"setting/wifi/ic_success_36x36.png");
            UI.setText(networkTestText,LANGUAGE.ConnectSuccess);
            UI.setText(networkTestCancelText,"[GE0007]");
            UI.callTTS(LANGUAGE.ConnectSuccess+" "+"[GE0007]");
        }else{
            UI.setImage(networkTestInternetResultImg,"setting/wifi/ic_wrong.png");
            UI.setText(networkTestCancelText,"[GE0007]");
            switch (networkType){
                case NetWorkType.ETHER:
                    UI.setText(networkTestText,LANGUAGE.wiredConnectFail);
                    UI.callTTS(LANGUAGE.wiredConnectFail+" "+"[GE0007]");
                    break;
                case NetWorkType.WIRELESS:
                    UI.setText(networkTestText,LANGUAGE.wirelessConnectFail);
                    UI.callTTS(LANGUAGE.wirelessConnectFail+" "+"[GE0007]");
                    break;
                default :
                    UI.setText(networkTestText,LANGUAGE.ConnectFail);
                    UI.callTTS(LANGUAGE.ConnectFail+" "+"[GE0007]");
                    break;
            }
        }
        networkTestText.alpha = 1;
        networkTestInternetResultImg.alpha = 1;
    }
    function testStateChangeCallBack(state){
        DBG_INFO("testStateChangeCallBack:state="+state);
        switch (state){
            case 0:
                break;
            case 1:
                break;
            case 2:
                networkInternetTimeout();
                break;
            case 3:
                networkInternetTimeout();
                break;
            default :
                networkInternetTimeout();
                break;
        }
    }
    networkTestCancelBtn.onkey_ENTER = function(){
        UI.popSubModule();
    };
    networkTest.onPop = function(){
        clearTimeout(networkTest.networkInternetTestTimer);
        if(tv == true){
            model.network.TestStop();
        }
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_TEST_STATE_CHANGED,testStateChangeCallBack);
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_CHANGED,networkTestLocalStateChanged);
    };
};
//PIXI.loader.add(
//    [
//        themeDir + "setting/wifi/ic_tv.png",
//        themeDir + "setting/wifi/line_150x8.png",
//        themeDir + "setting/wifi/light_75x8.png",
//        themeDir + "setting/wifi/ic_success_36x36.png",
//        themeDir + "setting/wifi/ic_router.png",
//        themeDir + "setting/wifi/light_75x8.png",
//        themeDir + "setting/wifi/ic_internet.png"
//    ]
//);
//PIXI.loader.load();
