// Init
UI.moduleBuilder['setting']['networkIpSet'] = function(){

    var HIDE = 0;
    var SHOW = 1;

    var LANGUAGE = {
        "Success":"[PI0005]",
        "Fail":"[PI0006]"
    };
    var mainPanelData = {
        networkIpSetSheetImg:UI.setting_bg,
        networkIpImg:"setting/ic_network_154x154.png",
        ipModeImg1:UI.btn_normal_bg,
        ipModeLeftImg:"setting/ic_leftarrow_focused.png",
        ipModeRightImg:"setting/ic_rightarrow_focused.png",
        networkIpToastBgImg:"toast/Toast_bg2.png",
        networkIpToastImg:"setting/wifi/ic_not_connected.png",
        networkIpLoadingBg:UI['bg_overlay'],
        networkIpLoadingContentBg:UI.window_bg,
        networkIpLoadingImg:"setting/wifi/ic_loading_01.png",
        networkIpLoadingText:"[SE0607]",
        ipAddressImg :UI.btn_normal_bg,
        ipMaskImg :UI.btn_normal_bg,
        ipGatewayImg :UI.btn_normal_bg,
        ipDNS1Img :UI.btn_normal_bg,
        ipDNS2Img :UI.btn_normal_bg,
        ipSaveImg :UI.btn_normal_bg,
        ipAddress1:"setting/wifi/ip_input.png",
        ipAddress2:"setting/wifi/ip_input.png",
        ipAddress3:"setting/wifi/ip_input.png",
        ipAddress4:"setting/wifi/ip_input.png",
        ipMask1:"setting/wifi/ip_input.png",
        ipMask2:"setting/wifi/ip_input.png",
        ipMask3:"setting/wifi/ip_input.png",
        ipMask4:"setting/wifi/ip_input.png",
        ipGateway1:"setting/wifi/ip_input.png",
        ipGateway2:"setting/wifi/ip_input.png",
        ipGateway3:"setting/wifi/ip_input.png",
        ipGateway4:"setting/wifi/ip_input.png",
        ip1DNS1:"setting/wifi/ip_input.png",
        ip1DNS2:"setting/wifi/ip_input.png",
        ip1DNS3:"setting/wifi/ip_input.png",
        ip1DNS4:"setting/wifi/ip_input.png",
        ip2DNS1:"setting/wifi/ip_input.png",
        ip2DNS2:"setting/wifi/ip_input.png",
        ip2DNS3:"setting/wifi/ip_input.png",
        ip2DNS4:"setting/wifi/ip_input.png",
        networkIpTitle2:"[SE0119]",//"Network",
        networkIpTitle3:"[SE2944]",//"IP Setting"
        networkIpSetModeTitle:"[SE0617]",//IP Setting mode
        networkIpSetAddressTitle:"[SE0175]",   //IP Address
        networkIpSetMaskTitle:"[SE0176]",  //Netmask
        networkIpSetGatewayTitle:"[SE0177]",  //Gateway
        networkIpSetDNS1Title:"[SE0178]",  //DNS Server 1
        networkIpSetDNS2Title:"[SE0179]",  //DNS Server 2
        networkIpSetSaveTitle:"[SE0187]"  //connect
//        ipAddress1 :UI.item_bg

    };
    var template = Util.readJson("module/setting/networkIpSet.json");
    var networkIpSet = SubModule.create(mainPanelData, template);
    var networkIpGrp = UI.getItem(networkIpSet,"networkIpGrp");
    var networkIpSetMode = UI.getItem(networkIpGrp,"networkIpSetMode");
    var networkIpSetModeText = UI.getItem(networkIpSetMode,"networkIpSetModeText");
    var networkIpToast = UI.getItem(networkIpSet,"networkIpToast");
    var networkIpToastImg = UI.getItem(networkIpToast,"networkIpToastImg");
    var networkIpToastText = UI.getItem(networkIpToast,"networkIpToastText");
    var networkIpLoadingGrp = UI.getItem(networkIpSet,"networkIpLoadingGrp");
    var networkIpLoadingContentGp = UI.getItem(networkIpLoadingGrp,"networkIpLoadingContentGp");
    var networkIpLoadingImg = UI.getItem(networkIpLoadingContentGp,"networkIpLoadingImg");

    var NWSheetImg = UI.getItem(networkIpSet,"networkIpSetSheetImg");
    NWSheetImg.doFlip = true;

    var networkIpToastBgImg = UI.getItem(networkIpToast,"networkIpToastBgImg");
    networkIpToastBgImg.doFlip = true;
    var networkIpSetIpAddress = UI.getItem(networkIpGrp,"networkIpSetIpAddress");
    var networkIpSetIpAddressBox = UI.getItem(networkIpSetIpAddress,"networkIpSetIpAddressBox");
    networkIpSetIpAddressBox.noRTL = true;
    var ipAddress1 = UI.getItem(networkIpSetIpAddressBox,"ipAddress1");
    var ipAddress2 = UI.getItem(networkIpSetIpAddressBox,"ipAddress2");
    var ipAddress3 = UI.getItem(networkIpSetIpAddressBox,"ipAddress3");
    var ipAddress4 = UI.getItem(networkIpSetIpAddressBox,"ipAddress4");

    var networkIpSetIpMask = UI.getItem(networkIpGrp,"networkIpSetIpMask");
    var networkIpSetIpMaskBox = UI.getItem(networkIpSetIpMask,"networkIpSetIpMaskBox");
    networkIpSetIpMaskBox.noRTL = true;
    var ipMask1 = UI.getItem(networkIpSetIpMaskBox,"ipMask1");
    var ipMask2 = UI.getItem(networkIpSetIpMaskBox,"ipMask2");
    var ipMask3 = UI.getItem(networkIpSetIpMaskBox,"ipMask3");
    var ipMask4 = UI.getItem(networkIpSetIpMaskBox,"ipMask4");

    var networkIpSetIpGateway = UI.getItem(networkIpGrp,"networkIpSetIpGateway");
    var networkIpSetIpGatewayBox = UI.getItem(networkIpSetIpGateway,"networkIpSetIpGatewayBox");
    networkIpSetIpGatewayBox.noRTL = true;
    var ipGateway1 = UI.getItem(networkIpSetIpGatewayBox,"ipGateway1");
    var ipGateway2 = UI.getItem(networkIpSetIpGatewayBox,"ipGateway2");
    var ipGateway3 = UI.getItem(networkIpSetIpGatewayBox,"ipGateway3");
    var ipGateway4 = UI.getItem(networkIpSetIpGatewayBox,"ipGateway4");

    var networkIpSetIpDNS1 = UI.getItem(networkIpGrp,"networkIpSetIpDNS1");
    var networkIpSetIpDNS1Box = UI.getItem(networkIpSetIpDNS1,"networkIpSetIpDNS1Box");
    networkIpSetIpDNS1Box.noRTL = true;
    var ip1DNS1 = UI.getItem(networkIpSetIpDNS1Box,"ip1DNS1");
    var ip1DNS2 = UI.getItem(networkIpSetIpDNS1Box,"ip1DNS2");
    var ip1DNS3 = UI.getItem(networkIpSetIpDNS1Box,"ip1DNS3");
    var ip1DNS4 = UI.getItem(networkIpSetIpDNS1Box,"ip1DNS4");

    var networkIpSetIpDNS2 = UI.getItem(networkIpGrp,"networkIpSetIpDNS2");
    var networkIpSetIpDNS2Box = UI.getItem(networkIpSetIpDNS2,"networkIpSetIpDNS2Box");
    networkIpSetIpDNS2Box.noRTL = true;
    var ip2DNS1 = UI.getItem(networkIpSetIpDNS2Box,"ip2DNS1");
    var ip2DNS2 = UI.getItem(networkIpSetIpDNS2Box,"ip2DNS2");
    var ip2DNS3 = UI.getItem(networkIpSetIpDNS2Box,"ip2DNS3");
    var ip2DNS4 = UI.getItem(networkIpSetIpDNS2Box,"ip2DNS4");

    var networkIpSetIpSave = UI.getItem(networkIpGrp,"networkIpSetIpSave");
    var networkTypeList = ["[SE0173]", "[SE0016]"]; // DHCP [SE0173] Manual [SE0016]
    Select.create(networkIpSetModeText, networkTypeList);

    networkIpSet.ipConfigType = 0;
    networkIpSet.oriIpConfigType = 0;
    networkIpSet.ipAddress = "";
    networkIpSet.subnet_Mask = "";
    networkIpSet.default_Gateway = "";
    networkIpSet.primary_DNS = "";
    networkIpSet.secondary_DNS = "";
    networkIpSet.clearFlag = 1;
    networkIpSet.curInputflag = 0;
    networkIpSet.curInputIndex = 0;
    networkIpSet.ipList = [];
    networkIpSet.showFrom = 0;
    networkIpSet.timeout = 0;

    networkIpSet.noAutoClose = true;
    networkIpSet.testTimeout = 0;
    var NumInfo = {
        initVal : "",
        min : 0,
        max : 9999,
        fontSize : 36,
        align: "center",
        color : 0xFFFFFF
    };
    NumberInput.create(ipAddress1, NumInfo, onIpAddress1NumChanged);
    NumberInput.create(ipAddress2, NumInfo, onIpAddress2NumChanged);
    NumberInput.create(ipAddress3, NumInfo, onIpAddress3NumChanged);
    NumberInput.create(ipAddress4, NumInfo, onIpAddress4NumChanged);

    NumberInput.create(ipMask1, NumInfo, onMask1NumChanged);
    NumberInput.create(ipMask2, NumInfo, onMask2NumChanged);
    NumberInput.create(ipMask3, NumInfo, onMask3NumChanged);
    NumberInput.create(ipMask4, NumInfo, onMask4NumChanged);

    NumberInput.create(ipGateway1, NumInfo, onGateway1NumChanged);
    NumberInput.create(ipGateway2, NumInfo, onGateway2NumChanged);
    NumberInput.create(ipGateway3, NumInfo, onGateway3NumChanged);
    NumberInput.create(ipGateway4, NumInfo, onGateway4NumChanged);

    NumberInput.create(ip1DNS1, NumInfo, on1DNS1NumChanged);
    NumberInput.create(ip1DNS2, NumInfo, on1DNS2NumChanged);
    NumberInput.create(ip1DNS3, NumInfo, on1DNS3NumChanged);
    NumberInput.create(ip1DNS4, NumInfo, on1DNS4NumChanged);

    NumberInput.create(ip2DNS1, NumInfo, on2DNS1NumChanged);
    NumberInput.create(ip2DNS2, NumInfo, on2DNS2NumChanged);
    NumberInput.create(ip2DNS3, NumInfo, on2DNS3NumChanged);
    NumberInput.create(ip2DNS4, NumInfo, on2DNS4NumChanged);

    networkIpSet.onPush = function(){
        networkIpLoadingGrp.alpha = 0;
    }
    networkIpSet.onShow =  function(){
        try{
            try{
                var networkConfigPanel = UI.getSubModule("networkConfigPanel");
                if(!!networkConfigPanel){
                    networkConfigPanel.alpha = 0;
                }
            }catch (ex){
                DBG_ERROR("networkIpSet.onShow "+ex.message);
            }
            DBG_INFO("networkIpSet.onShow!!!!!!!!!!!!!!!!!:"+ networkIpSet.showFrom);
            networkIpSettingShowToast(HIDE,null,null);
            if(networkIpSet.showFrom == 1){ //from input panel
                saveIpList();
                refreshFocusTo();
                networkIpSet.showIpAddress();
                return;
            }
            networkIpSet.curInputflag = 0;
            networkIpSet.curInputIndex = 0;
            networkIpSet.ipList = [];
            networkIpSet.showFrom = 0;
            getAndShowIpAddress();
            networkIpSet.clearFlag = 1;
            networkIpSet.oriIpConfigType = networkIpSet.ipConfigType;
            UI.focusTo(networkIpSetMode);
            networkIpSet.currFocus = UI.getItem(networkIpSet, "networkIpSetMode");
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_CHANGED, networkIpSetStatusChanged);

        }
        catch (ex){
            DBG_ERROR(ex.message);
        }
    };

    networkIpSetMode.onFocus = function(){
        UI.setTextColor(networkIpSetMode.children[1],"rgba(255,255,255,1.0)");
        UI.setTextColor(networkIpSetModeText,"rgba(255,255,255,1.0)");
        return true;
    };
    networkIpSetMode.onNormal = function(){
        UI.setTextColor(networkIpSetMode.children[1],"rgba(255,255,255,0.6)");
        UI.setTextColor(networkIpSetModeText,"rgba(255,255,255,0.6)");
        return true;
    };

    networkIpSetIpSave.onFocus = function(){
        UI.setTextColor(networkIpSetIpSave.children[1],"rgba(255,255,255,1.0)");
        return true;
    };
    networkIpSetIpSave.onNormal = function(){
        UI.setTextColor(networkIpSetIpSave.children[1],"rgba(255,255,255,0.6)");
        return true;
    };

    function getAndShowIpAddress(){
        var ipConfigType = tv?model.network.getEnumIp_config():0;
        networkIpSet.ipConfigType = ipConfigType;
        DBG_INFO("ipConfigType:"+networkIpSet.ipConfigType);
        networkIpSet.ipAddress = tv?model.network.getIp_address():"172.168.1.100";
        networkIpSet.subnet_Mask = tv?model.network.getSubnet_mask():"255.255.255.0";
        networkIpSet.default_Gateway = tv?model.network.getGateway():"172.168.1.1";
        networkIpSet.primary_DNS = tv?model.network.getDns_server_1():"172.168.1.130";
        networkIpSet.secondary_DNS = tv?model.network.getDns_server_2():"172.168.1.131";
        if(ipConfigType == NetWorkIpConfig.DHCP){
            networkIpSet.setIpInputDisable(true);
        }else{
            networkIpSet.setIpInputDisable(false);
        }
        networkIpSet.showIpAddress();
    }
    networkIpSet.showIpAddress = function (){
        DBG_INFO("showIpAddress:"+networkIpSet.ipAddress);
        DBG_INFO("showIpAddress:"+networkIpSet.subnet_Mask);
        DBG_INFO("showIpAddress:"+networkIpSet.default_Gateway);
        DBG_INFO("showIpAddress:"+networkIpSet.primary_DNS);
        DBG_INFO("showIpAddress:"+networkIpSet.secondary_DNS);
        var ipAddrArray = networkIpSet.ipAddress.split(".");
        for(var i = 0; i < 4; i++){
            if(!ipAddrArray[i]){
                ipAddrArray[i] = "0";
            }
        }

        ipAddress1.setText(ipAddrArray[0]+'');
        ipAddress2.setText(ipAddrArray[1]+'');
        ipAddress3.setText(ipAddrArray[2]+'');
        ipAddress4.setText(ipAddrArray[3]+'');
        networkIpSet.ipAddress = ipAddrArray[0]+"."+ipAddrArray[1]+"."+ipAddrArray[2]+"."+ipAddrArray[3];

        var subnetMaskArray = networkIpSet.subnet_Mask.split(".");
        for(i = 0; i < 4; i++){
            if(!subnetMaskArray[i]){
                subnetMaskArray[i] = "0";
            }
        }
        ipMask1.setText(subnetMaskArray[0]+'');
        ipMask2.setText(subnetMaskArray[1]+'');
        ipMask3.setText(subnetMaskArray[2]+'');
        ipMask4.setText(subnetMaskArray[3]+'');
        networkIpSet.subnet_Mask = subnetMaskArray[0]+"."+subnetMaskArray[1]+"."+subnetMaskArray[2]+"."+subnetMaskArray[3];

        var default_GatewayArray = networkIpSet.default_Gateway.split(".");
        for(i = 0; i < 4; i++){
            if(!default_GatewayArray[i]){
                default_GatewayArray[i] = "0";
            }
        }
        ipGateway1.setText(default_GatewayArray[0]+'');
        ipGateway2.setText(default_GatewayArray[1]+'');
        ipGateway3.setText(default_GatewayArray[2]+'');
        ipGateway4.setText(default_GatewayArray[3]+'');
        networkIpSet.default_Gateway = default_GatewayArray[0]+"."+default_GatewayArray[1]+"."+default_GatewayArray[2]+"."+default_GatewayArray[3];

        var primary_DNSArray = networkIpSet.primary_DNS.split(".");
        for(i = 0; i < 4; i++){
            if(!primary_DNSArray[i]){
                primary_DNSArray[i] = "0";
            }
        }
        ip1DNS1.setText(primary_DNSArray[0]+'');
        ip1DNS2.setText(primary_DNSArray[1]+'');
        ip1DNS3.setText(primary_DNSArray[2]+'');
        ip1DNS4.setText(primary_DNSArray[3]+'');
        networkIpSet.primary_DNS = primary_DNSArray[0]+"."+primary_DNSArray[1]+"."+primary_DNSArray[2]+"."+primary_DNSArray[3];

        var secondary_DNSArray = networkIpSet.secondary_DNS.split(".");
        for(i = 0; i < 4; i++){
            if(!secondary_DNSArray[i]){
                secondary_DNSArray[i] = "0";
            }
        }
        ip2DNS1.setText(secondary_DNSArray[0]+'');
        ip2DNS2.setText(secondary_DNSArray[1]+'');
        ip2DNS3.setText(secondary_DNSArray[2]+'');
        ip2DNS4.setText(secondary_DNSArray[3]+'');
        networkIpSet.secondary_DNS = secondary_DNSArray[0]+"."+secondary_DNSArray[1]+"."+secondary_DNSArray[2]+"."+secondary_DNSArray[3];

        UI.updateStage();
    };
    networkIpSet.setIpInputDisable = function (attr){
        if(attr){
            networkIpSet.ipConfigType = NetWorkIpConfig.DHCP;
//            networkIpSet.ipAddress = "172.168.1.100";
//            networkIpSet.subnet_Mask = "255.255.255.0";
//            networkIpSet.default_Gateway = "172.168.1.1";
//            networkIpSet.primary_DNS = "172.168.1.130";
//            networkIpSet.secondary_DNS = "172.168.1.131";

            networkIpSetIpAddress.alpha = 0.3;
            ipAddress1.disable = true;
            ipAddress2.disable = true;
            ipAddress3.disable = true;
            ipAddress4.disable = true;

            networkIpSetIpMask.alpha = 0.3;
            ipMask1.disable = true;
            ipMask2.disable = true;
            ipMask3.disable = true;
            ipMask4.disable = true;

            networkIpSetIpGateway.alpha = 0.3;
            ipGateway1.disable = true;
            ipGateway2.disable = true;
            ipGateway3.disable = true;
            ipGateway4.disable = true;

            networkIpSetIpDNS1.alpha = 0.3;
            ip1DNS1.disable = true;
            ip1DNS2.disable = true;
            ip1DNS3.disable = true;
            ip1DNS4.disable = true;

            networkIpSetIpDNS2.alpha = 0.3;
            ip2DNS1.disable = true;
            ip2DNS2.disable = true;
            ip2DNS3.disable = true;
            ip2DNS4.disable = true;

//            networkIpSetIpSave.alpha = 0.5;
//            networkIpSetIpSave.disable = true;

//            UI.setText(networkIpSetModeText,"DHCP");
            networkIpSetModeText.selectCurrent(networkIpSet.ipConfigType);
        }else{
            networkIpSet.ipConfigType = NetWorkIpConfig.MANUAL;
//
//            networkIpSet.ipAddress = "172.168.1.102";
//            networkIpSet.subnet_Mask = "255.255.255.0";
//            networkIpSet.default_Gateway = "172.168.1.1";
//            networkIpSet.primary_DNS = "172.168.1.130";
//            networkIpSet.secondary_DNS = "172.168.1.131";

            networkIpSetIpAddress.alpha = 1;
            ipAddress1.disable = false;
            ipAddress2.disable = false;
            ipAddress3.disable = false;
            ipAddress4.disable = false;

            networkIpSetIpMask.alpha = 1;
            ipMask1.disable = false;
            ipMask2.disable = false;
            ipMask3.disable = false;
            ipMask4.disable = false;

            networkIpSetIpGateway.alpha = 1;
            ipGateway1.disable = false;
            ipGateway2.disable = false;
            ipGateway3.disable = false;
            ipGateway4.disable = false;

            networkIpSetIpDNS1.alpha = 1;
            ip1DNS1.disable = false;
            ip1DNS2.disable = false;
            ip1DNS3.disable = false;
            ip1DNS4.disable = false;

            networkIpSetIpDNS2.alpha = 1;
            ip2DNS1.disable = false;
            ip2DNS2.disable = false;
            ip2DNS3.disable = false;
            ip2DNS4.disable = false;

//            networkIpSetIpSave.alpha = 1;
//            networkIpSetIpSave.disable = false;

//            UI.setText(networkIpSetModeText,"Manual");
            networkIpSetModeText.selectCurrent(networkIpSet.ipConfigType);
        }
    };


    networkIpSetMode.onkey_RIGHT = function() {
//        if(networkIpSet.ipConfigType == NetWorkIpConfig.DHCP){
//            networkIpSet.setIpInputDisable(false);
//        }else{
//            networkIpSet.setIpInputDisable(true);
//        }
        networkIpSetModeText.selectNext();
        var index = networkTypeList.indexOf(networkIpSetModeText.selected);
        DBG_INFO("networkIpSetModeText:"+index);
        networkIpSet.ipConfigType = index;
        if(networkIpSet.ipConfigType == NetWorkIpConfig.DHCP){
            networkIpSet.setIpInputDisable(true);
        }else{
            networkIpSet.setIpInputDisable(false);
        }
        networkIpSet.showIpAddress();
        DBG_ALWAYS("setEnumIp_config:"+networkIpSet.ipConfigType);
//        if (tv)model.network.setEnumIp_config(networkIpSet.ipConfigType);
    };
    networkIpSetMode.onkey_LEFT = function() {
//        if(networkIpSet.ipConfigType == NetWorkIpConfig.DHCP){
//            networkIpSet.setIpInputDisable(false);
//        }else{
//            networkIpSet.setIpInputDisable(true);
//        }
        networkIpSetModeText.selectPrev();
        var index = networkTypeList.indexOf(networkIpSetModeText.selected);
        DBG_INFO("networkIpSetModeText:"+index);
        networkIpSet.ipConfigType = index;
        if(networkIpSet.ipConfigType == NetWorkIpConfig.DHCP){
            networkIpSet.setIpInputDisable(true);
        }else{
            networkIpSet.setIpInputDisable(false);
        }
        networkIpSet.showIpAddress();

//        if (tv)model.network.setEnumIp_config(networkIpSet.ipConfigType);
    };

    networkIpSetMode.onkey_DOWN = function(){
        if(networkIpSet.ipConfigType == NetWorkIpConfig.DHCP){
            UI.focusTo(networkIpSetIpSave);
        }else{
            UI.focusTo(ipAddress1);
        }
    };

    function getIpList(){
        networkIpSet.ipList[0] = networkIpSet.ipAddress;
        networkIpSet.ipList[1] = networkIpSet.subnet_Mask;
        networkIpSet.ipList[2] = networkIpSet.default_Gateway;
        networkIpSet.ipList[3] = networkIpSet.primary_DNS;
        networkIpSet.ipList[4] = networkIpSet.secondary_DNS;
    }

    function saveIpList(){
        networkIpSet.ipAddress = networkIpSet.ipList[0];
        networkIpSet.subnet_Mask = networkIpSet.ipList[1];
        networkIpSet.default_Gateway = networkIpSet.ipList[2];
        networkIpSet.primary_DNS = networkIpSet.ipList[3];
        networkIpSet.secondary_DNS = networkIpSet.ipList[4];
    }

    function refreshFocusTo(){
        switch (networkIpSet.curInputflag){
            case 0:  //ip
                switch(networkIpSet.curInputIndex){
                    case 0:
                        UI.focusTo(ipAddress1);
                        break;
                    case 1:
                        UI.focusTo(ipAddress2);
                        break;
                    case 2:
                        UI.focusTo(ipAddress3);
                        break;
                    case 3:
                        UI.focusTo(ipAddress4);
                        break;
                }
                break;
            case 1:  //mask
                switch(networkIpSet.curInputIndex){
                    case 0:
                        UI.focusTo(ipMask1);
                        break;
                    case 1:
                        UI.focusTo(ipMask2);
                        break;
                    case 2:
                        UI.focusTo(ipMask3);
                        break;
                    case 3:
                        UI.focusTo(ipMask4);
                        break;
                }
                break;
            case 2:  //gateway
                switch(networkIpSet.curInputIndex){
                    case 0:
                        UI.focusTo(ipGateway1);
                        break;
                    case 1:
                        UI.focusTo(ipGateway2);
                        break;
                    case 2:
                        UI.focusTo(ipGateway3);
                        break;
                    case 3:
                        UI.focusTo(ipGateway4);
                        break;
                }
                break;
            case 3:  //dns1
                switch(networkIpSet.curInputIndex){
                    case 0:
                        UI.focusTo(ip1DNS1);
                        break;
                    case 1:
                        UI.focusTo(ip1DNS2);
                        break;
                    case 2:
                        UI.focusTo(ip1DNS3);
                        break;
                    case 3:
                        UI.focusTo(ip1DNS4);
                        break;
                }
                break;
            case 4:  //dns2
                switch(networkIpSet.curInputIndex){
                    case 0:
                        UI.focusTo(ip2DNS1);
                        break;
                    case 1:
                        UI.focusTo(ip2DNS2);
                        break;
                    case 2:
                        UI.focusTo(ip2DNS3);
                        break;
                    case 3:
                        UI.focusTo(ip2DNS4);
                        break;
                }
                break;
        }
    }

    function onIpAddress1NumChanged(txt) {
//        ipAddress1.updateCache();
        UI.updateStage();
        networkIpChangedInput(txt.text,ipAddress1,ipAddress2);
    }
    function onIpAddress2NumChanged(txt) {
//        ipAddress1.updateCache();
        UI.updateStage();
        networkIpChangedInput(txt.text,ipAddress2,ipAddress3);
    }
    function onIpAddress3NumChanged(txt) {
//        ipAddress1.updateCache();
        UI.updateStage();
        networkIpChangedInput(txt.text,ipAddress3,ipAddress4);
    }
    function onIpAddress4NumChanged(txt) {
//        ipAddress1.updateCache();
        UI.updateStage();
        networkIpChangedInput(txt.text,ipAddress4,ipMask1);
    }
    function onMask1NumChanged(txt) {
//        ipAddress1.updateCache();
        UI.updateStage();
        networkIpChangedInput(txt.text,ipMask1,ipMask2);
    }
    function onMask2NumChanged(txt) {
//        ipAddress1.updateCache();
        UI.updateStage();
        networkIpChangedInput(txt.text,ipMask2,ipMask3);
    }
    function onMask3NumChanged(txt) {
//        ipAddress1.updateCache();
        UI.updateStage();
        networkIpChangedInput(txt.text,ipMask3,ipMask4);
    }
    function onMask4NumChanged(txt) {
//        ipAddress1.updateCache();
        UI.updateStage();
        networkIpChangedInput(txt.text,ipMask4,ipGateway1);
    }
    function onGateway1NumChanged(txt) {
//        ipAddress1.updateCache();
        UI.updateStage();
        networkIpChangedInput(txt.text,ipGateway1,ipGateway2);
    }
    function onGateway2NumChanged(txt) {
//        ipAddress1.updateCache();
        UI.updateStage();
        networkIpChangedInput(txt.text,ipGateway2,ipGateway3);
    }
    function onGateway3NumChanged(txt) {
//        ipAddress1.updateCache();
        UI.updateStage();
        networkIpChangedInput(txt.text,ipGateway3,ipGateway4);
    }
    function onGateway4NumChanged(txt) {
//        ipAddress1.updateCache();
        UI.updateStage();
        networkIpChangedInput(txt.text,ipGateway4,ip1DNS1);
    }
    function on1DNS1NumChanged(txt) {
//        ipAddress1.updateCache();
        UI.updateStage();
        networkIpChangedInput(txt.text,ip1DNS1,ip1DNS2);
    }
    function on1DNS2NumChanged(txt) {
//        ipAddress1.updateCache();
        UI.updateStage();
        networkIpChangedInput(txt.text,ip1DNS2,ip1DNS3);
    }
    function on1DNS3NumChanged(txt) {
//        ipAddress1.updateCache();
        UI.updateStage();
        networkIpChangedInput(txt.text,ip1DNS3,ip1DNS4);
    }
    function on1DNS4NumChanged(txt) {
//        ipAddress1.updateCache();
        UI.updateStage();
        networkIpChangedInput(txt.text,ip1DNS4,ip2DNS1);
    }
    function on2DNS1NumChanged(txt) {
//        ipAddress1.updateCache();
        UI.updateStage();
        networkIpChangedInput(txt.text,ip2DNS1,ip2DNS2);
    }
    function on2DNS2NumChanged(txt) {
//        ipAddress1.updateCache();
        UI.updateStage();
        networkIpChangedInput(txt.text,ip2DNS2,ip2DNS3);
    }
    function on2DNS3NumChanged(txt) {
//        ipAddress1.updateCache();
        UI.updateStage();
        networkIpChangedInput(txt.text,ip2DNS3,ip2DNS4);
    }
    function on2DNS4NumChanged(txt) {
//        ipAddress1.updateCache();
        UI.updateStage();
        networkIpChangedInput(txt.text,ip2DNS4,null);
    }

    function networkIpChangedInput(txt,id,rightTo) {
        try {
            DBG_INFO("clearFlag:" + networkIpSet.clearFlag);
            DBG_INFO("crt txt:" + txt);
            if (networkIpSet.clearFlag == 1) {
                if (!!txt) {
                    var currInputVal = parseInt(txt, 10) % 10;
                } else {
                    var currInputVal = 0;
                }
                networkIpSet.clearFlag = 0;
//                id.children[1].text = currInputVal;
                id.setText(currInputVal);
                DBG_INFO("txt:" + currInputVal);
            } else {
                if (!!txt) {
                    var currInputVal = parseInt(txt, 10);
                } else {
                    var currInputVal = 0;
                }
                DBG_INFO("crt txt:" + currInputVal);
                if (currInputVal >= 100 && currInputVal <= 255) {
                    DBG_INFO("crt txt: 100 255");
//                    id.children[1].text = currInputVal;
                    id.setText(currInputVal);
                    if (!!rightTo) {
                        UI.focusTo(rightTo);
                        networkIpSet.clearFlag = 1;
                    }

                } else if (currInputVal > 255 && currInputVal < 1000) {
                    DBG_INFO("crt txt: 255 1000");
                    var currValue = parseInt(currInputVal / 10);
                    var nextValue = currInputVal % 10;
//                    id.children[1].text = currValue;
                    id.setText(currValue);
                    if (!!rightTo) {
//                        rightTo.children[1].text = nextValue;
                        rightTo.setText(nextValue);
                        UI.focusTo(rightTo);
                    }
                } else if (currInputVal > 1000) {
                    DBG_INFO("crt txt: > 1000");
                    var currValue = parseInt(currInputVal / 10);
                    var nextValue = currInputVal % 10;
//                    id.children[1].text = currValue;
                    id.setText(currValue);
                    if (!!rightTo) {
//                        rightTo.children[1].text = nextValue;
                        rightTo.setText(nextValue);
                        UI.focusTo(rightTo);
                    }
                } else {
                    DBG_INFO("crt txt: default");
//                    id.children[1].text = currInputVal;
                    id.setText(currInputVal);
                }
            }
            networkIpSettingRecordInfo();
        } catch (ex) {
            DBG_ERROR("settingNetSetIpSetInputOnChange:" + ex.message);
        }
        UI.updateStage();
    }

    ipAddress1.onkey_LEFT = function() {
        if(GLOBAL.RTL){
            UI.focusTo(ipAddress2);
            netSetEtherClearFlag();
        }
    };

    ipAddress1.onkey_RIGHT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ipAddress2);
            netSetEtherClearFlag();
        }
    };

    ipAddress1.onkey_DOWN = function() {
        UI.focusTo(ipMask1);
        netSetEtherClearFlag();
    };
    ipAddress1.onkey_UP = function() {
        UI.focusTo(networkIpSetMode);
        netSetEtherClearFlag();
    };

    ipAddress2.onkey_RIGHT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ipAddress3);
        }else{
            UI.focusTo(ipAddress1);
        }
        netSetEtherClearFlag();
    };

    ipAddress2.onkey_DOWN = function() {
        UI.focusTo(ipMask2);
        netSetEtherClearFlag();
    };
    ipAddress2.onkey_UP = function() {
        UI.focusTo(networkIpSetMode);
        netSetEtherClearFlag();
    };
    ipAddress2.onkey_LEFT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ipAddress1);
        }else{
            UI.focusTo(ipAddress3);
        }
        netSetEtherClearFlag();
    };

    ipAddress3.onkey_RIGHT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ipAddress4);
        }else{
            UI.focusTo(ipAddress2);
        }
        netSetEtherClearFlag();
    };
    ipAddress3.onkey_DOWN = function() {
        UI.focusTo(ipMask3);
        netSetEtherClearFlag();
    };
    ipAddress3.onkey_UP = function() {
        UI.focusTo(networkIpSetMode);
        netSetEtherClearFlag();
    };
    ipAddress3.onkey_LEFT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ipAddress2);
        }else{
            UI.focusTo(ipAddress4);
        }
        netSetEtherClearFlag();
    };

    ipAddress4.onkey_RIGHT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ipMask1);
        }else{
            UI.focusTo(ipAddress3);
        }
        netSetEtherClearFlag();
    };
    ipAddress4.onkey_DOWN = function() {
        UI.focusTo(ipMask4);
        netSetEtherClearFlag();
    };
    ipAddress4.onkey_UP = function() {
        UI.focusTo(networkIpSetMode);
        netSetEtherClearFlag();
    };
    ipAddress4.onkey_LEFT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ipAddress3);
        }else{
            UI.focusTo(ipMask1);
        }
        netSetEtherClearFlag();
    };

    ipMask1.onkey_RIGHT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ipMask2);
        }else{
            UI.focusTo(ipAddress4);
        }
        netSetEtherClearFlag();
    };
    ipMask1.onkey_DOWN = function() {
        UI.focusTo(ipGateway1);
        netSetEtherClearFlag();
    };
    ipMask1.onkey_UP = function() {
        UI.focusTo(ipAddress1);
        netSetEtherClearFlag();
    };
    ipMask1.onkey_LEFT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ipAddress4);
        }else{
            UI.focusTo(ipMask2);
        }
        netSetEtherClearFlag();
    };

    ipMask2.onkey_RIGHT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ipMask3);
        }else{
            UI.focusTo(ipMask1);
        }
        netSetEtherClearFlag();
    };
    ipMask2.onkey_DOWN = function() {
        UI.focusTo(ipGateway2);
        netSetEtherClearFlag();
    };
    ipMask2.onkey_UP = function() {
        UI.focusTo(ipAddress2);
        netSetEtherClearFlag();
    };
    ipMask2.onkey_LEFT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ipMask1);
        }else{
            UI.focusTo(ipMask3);
        }
        netSetEtherClearFlag();
    };

    ipMask3.onkey_RIGHT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ipMask4);
        }else{
            UI.focusTo(ipMask2);
        }
        netSetEtherClearFlag();
    };
    ipMask3.onkey_DOWN = function() {
        UI.focusTo(ipGateway3);
        netSetEtherClearFlag();
    };
    ipMask3.onkey_UP = function() {
        UI.focusTo(ipAddress3);
        netSetEtherClearFlag();
    };
    ipMask3.onkey_LEFT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ipMask2);
        }else{
            UI.focusTo(ipMask4);
        }
        netSetEtherClearFlag();
    };

    ipMask4.onkey_RIGHT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ipGateway1);
        }else{
            UI.focusTo(ipMask3);
        }
        netSetEtherClearFlag();
    };
    ipMask4.onkey_DOWN = function() {
        UI.focusTo(ipGateway4);
        netSetEtherClearFlag();
    };
    ipMask4.onkey_UP = function() {
        UI.focusTo(ipAddress4);
        netSetEtherClearFlag();
    };
    ipMask4.onkey_LEFT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ipMask3);
        }else{
            UI.focusTo(ipGateway1);
        }
        netSetEtherClearFlag();
    };

    ipGateway1.onkey_RIGHT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ipGateway2);
        }else{
            UI.focusTo(ipMask4);
        }
        netSetEtherClearFlag();
    };
    ipGateway1.onkey_DOWN = function() {
        UI.focusTo(ip1DNS1);
        netSetEtherClearFlag();
    };
    ipGateway1.onkey_UP = function() {
        UI.focusTo(ipMask1);
        netSetEtherClearFlag();
    };
    ipGateway1.onkey_LEFT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ipMask4);
        }else{
            UI.focusTo(ipGateway2);
        }
        netSetEtherClearFlag();
    };

    ipGateway2.onkey_RIGHT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ipGateway3);
        }else{
            UI.focusTo(ipGateway1);
        }
        netSetEtherClearFlag();
    };
    ipGateway2.onkey_DOWN = function() {
        UI.focusTo(ip1DNS2);
        netSetEtherClearFlag();
    };
    ipGateway2.onkey_UP = function() {
        UI.focusTo(ipMask2);
        netSetEtherClearFlag();
    };
    ipGateway2.onkey_LEFT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ipGateway1);
        }else{
            UI.focusTo(ipGateway3);
        }
        netSetEtherClearFlag();
    };

    ipGateway3.onkey_RIGHT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ipGateway4);
        }else{
            UI.focusTo(ipGateway2);
        }
        netSetEtherClearFlag();
    };
    ipGateway3.onkey_DOWN = function() {
        UI.focusTo(ip1DNS3);
        netSetEtherClearFlag();
    };
    ipGateway3.onkey_UP = function() {
        UI.focusTo(ipMask3);
        netSetEtherClearFlag();
    };
    ipGateway3.onkey_LEFT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ipGateway2);
        }else{
            UI.focusTo(ipGateway4);
        }
        netSetEtherClearFlag();
    };

    ipGateway4.onkey_RIGHT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ip1DNS1);
        }else{
            UI.focusTo(ipGateway3);
        }
        netSetEtherClearFlag();
    };
    ipGateway4.onkey_DOWN = function() {
        UI.focusTo(ip1DNS4);
        netSetEtherClearFlag();
    };
    ipGateway4.onkey_UP = function() {
        UI.focusTo(ipMask4);
        netSetEtherClearFlag();
    };
    ipGateway4.onkey_LEFT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ipGateway3);
        }else{
            UI.focusTo(ip1DNS1);
        }
        netSetEtherClearFlag();
    };

    ip1DNS1.onkey_RIGHT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ip1DNS2);
        }else{
            UI.focusTo(ipGateway4);
        }
        netSetEtherClearFlag();
    };
    ip1DNS1.onkey_DOWN = function() {
        UI.focusTo(ip2DNS1);
        netSetEtherClearFlag();
    };
    ip1DNS1.onkey_UP = function() {
        UI.focusTo(ipGateway1);
        netSetEtherClearFlag();
    };
    ip1DNS1.onkey_LEFT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ipGateway4);
        }else{
            UI.focusTo(ip1DNS2);
        }
        netSetEtherClearFlag();
    };

    ip1DNS2.onkey_RIGHT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ip1DNS3);
        }else{
            UI.focusTo(ip1DNS1);
        }
        netSetEtherClearFlag();
    };
    ip1DNS2.onkey_DOWN = function() {
        UI.focusTo(ip2DNS2);
        netSetEtherClearFlag();
    };
    ip1DNS2.onkey_UP = function() {
        UI.focusTo(ipGateway2);
        netSetEtherClearFlag();
    };
    ip1DNS2.onkey_LEFT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ip1DNS1);
        }else{
            UI.focusTo(ip1DNS3);
        }
        netSetEtherClearFlag();
    };

    ip1DNS3.onkey_RIGHT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ip1DNS4);
        }else{
            UI.focusTo(ip1DNS2);
        }
        netSetEtherClearFlag();
    };
    ip1DNS3.onkey_DOWN = function() {
        UI.focusTo(ip2DNS3);
        netSetEtherClearFlag();
    };
    ip1DNS3.onkey_UP = function() {
        UI.focusTo(ipGateway3);
        netSetEtherClearFlag();
    };
    ip1DNS3.onkey_LEFT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ip1DNS2);
        }else{
            UI.focusTo(ip1DNS4);
        }
        netSetEtherClearFlag();
    };

    ip1DNS4.onkey_RIGHT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ip2DNS1);
        }else{
            UI.focusTo(ip1DNS3);
        }
        netSetEtherClearFlag();
    };
    ip1DNS4.onkey_DOWN = function() {
        UI.focusTo(ip2DNS4);
        netSetEtherClearFlag();
    };
    ip1DNS4.onkey_UP = function() {
        UI.focusTo(ipGateway4);
        netSetEtherClearFlag();
    };
    ip1DNS4.onkey_LEFT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ip1DNS3);
        }else{
            UI.focusTo(ip2DNS1);
        }
        netSetEtherClearFlag();
    };

    ip2DNS1.onkey_RIGHT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ip2DNS2);
        }else{
            UI.focusTo(ip1DNS4);
        }
        netSetEtherClearFlag();
    };
    ip2DNS1.onkey_DOWN = function() {
        UI.focusTo(networkIpSetIpSave);
        netSetEtherClearFlag();
    };
    ip2DNS1.onkey_UP = function() {
        UI.focusTo(ip1DNS1);
        netSetEtherClearFlag();
    };
    ip2DNS1.onkey_LEFT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ip1DNS4);
        }else{
            UI.focusTo(ip2DNS2);
        }
        netSetEtherClearFlag();
    };

    ip2DNS2.onkey_RIGHT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ip2DNS3);
        }else{
            UI.focusTo(ip2DNS1);
        }
        netSetEtherClearFlag();
    };
    ip2DNS2.onkey_DOWN = function() {
        UI.focusTo(networkIpSetIpSave);
        netSetEtherClearFlag();
    };
    ip2DNS2.onkey_UP = function() {
        UI.focusTo(ip1DNS2);
        netSetEtherClearFlag();
    };
    ip2DNS2.onkey_LEFT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ip2DNS1);
        }else{
            UI.focusTo(ip2DNS3);
        }
        netSetEtherClearFlag();
    };

    ip2DNS3.onkey_RIGHT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ip2DNS4);
        }else{
            UI.focusTo(ip2DNS2);
        }
        netSetEtherClearFlag();
    };
    ip2DNS3.onkey_DOWN = function() {
        UI.focusTo(networkIpSetIpSave);
        netSetEtherClearFlag();
    };
    ip2DNS3.onkey_UP = function() {
        UI.focusTo(ip1DNS3);
        netSetEtherClearFlag();
    };
    ip2DNS3.onkey_LEFT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ip2DNS2);
        }else{
            UI.focusTo(ip2DNS4);
        }
        netSetEtherClearFlag();
    };

    ip2DNS4.onkey_RIGHT = function() {
        if(GLOBAL.RTL){
            UI.focusTo(ip2DNS3);
            netSetEtherClearFlag();
        }
    };

    ip2DNS4.onkey_DOWN = function() {
        UI.focusTo(networkIpSetIpSave);
        netSetEtherClearFlag();
    };
    ip2DNS4.onkey_UP = function() {
        UI.focusTo(ip1DNS4);
        netSetEtherClearFlag();
    };
    ip2DNS4.onkey_LEFT = function() {
        if(!GLOBAL.RTL){
            UI.focusTo(ip2DNS3);
            netSetEtherClearFlag();
        }
    };

    ipAddress1.onkey_ENTER = function() {
        getIpList();
        networkIpSet.curInputflag = 0;
        networkIpSet.curInputIndex = 0;
        UI.pushSubModule("setting", "NetIpInputPanel", true);
    };
    ipAddress2.onkey_ENTER = function() {
        getIpList();
        networkIpSet.curInputflag = 0; //0 ip 1 mask 2 gateway 3 dns1 4 dns2
        networkIpSet.curInputIndex = 1; // focus
        UI.pushSubModule("setting", "NetIpInputPanel", true);
    };
    ipAddress3.onkey_ENTER = function() {
        getIpList();
        networkIpSet.curInputflag = 0;
        networkIpSet.curInputIndex = 2;
        UI.pushSubModule("setting", "NetIpInputPanel", true);
    };
    ipAddress4.onkey_ENTER = function() {
        getIpList();
        networkIpSet.curInputflag = 0;
        networkIpSet.curInputIndex = 3;
        UI.pushSubModule("setting", "NetIpInputPanel", true);
    };

    ipMask1.onkey_ENTER = function() {
        getIpList();
        networkIpSet.curInputflag = 1; //0 ip 1 mask 2 gateway 3 dns1 4 dns2
        networkIpSet.curInputIndex = 0; // focus
        UI.pushSubModule("setting", "NetIpInputPanel", true);
    };
    ipMask2.onkey_ENTER = function() {
        getIpList();
        networkIpSet.curInputflag = 1; //0 ip 1 mask 2 gateway 3 dns1 4 dns2
        networkIpSet.curInputIndex = 1; // focus
        UI.pushSubModule("setting", "NetIpInputPanel", true);
    };
    ipMask3.onkey_ENTER = function() {
        getIpList();
        networkIpSet.curInputflag = 1; //0 ip 1 mask 2 gateway 3 dns1 4 dns2
        networkIpSet.curInputIndex = 2; // focus
        UI.pushSubModule("setting", "NetIpInputPanel", true);
    };
    ipMask4.onkey_ENTER = function() {
        getIpList();
        networkIpSet.curInputflag = 1; //0 ip 1 mask 2 gateway 3 dns1 4 dns2
        networkIpSet.curInputIndex = 3; // focus
        UI.pushSubModule("setting", "NetIpInputPanel", true);
    };

    ipGateway1.onkey_ENTER = function() {
        getIpList();
        networkIpSet.curInputflag = 2; //0 ip 1 mask 2 gateway 3 dns1 4 dns2
        networkIpSet.curInputIndex = 0; // focus
        UI.pushSubModule("setting", "NetIpInputPanel", true);
    };
    ipGateway2.onkey_ENTER = function() {
        getIpList();
        networkIpSet.curInputflag = 2; //0 ip 1 mask 2 gateway 3 dns1 4 dns2
        networkIpSet.curInputIndex = 1; // focus
        UI.pushSubModule("setting", "NetIpInputPanel", true);
    };
    ipGateway3.onkey_ENTER = function() {
        getIpList();
        networkIpSet.curInputflag = 2; //0 ip 1 mask 2 gateway 3 dns1 4 dns2
        networkIpSet.curInputIndex = 2; // focus
        UI.pushSubModule("setting", "NetIpInputPanel", true);
    };
    ipGateway4.onkey_ENTER = function() {
        getIpList();
        networkIpSet.curInputflag = 2; //0 ip 1 mask 2 gateway 3 dns1 4 dns2
        networkIpSet.curInputIndex = 3; // focus
        UI.pushSubModule("setting", "NetIpInputPanel", true);
    };


    ip1DNS1.onkey_ENTER = function() {
        getIpList();
        networkIpSet.curInputflag = 3; //0 ip 1 mask 2 gateway 3 dns1 4 dns2
        networkIpSet.curInputIndex = 0; // focus
        UI.pushSubModule("setting", "NetIpInputPanel", true);
    };
    ip1DNS2.onkey_ENTER = function() {
        getIpList();
        networkIpSet.curInputflag = 3; //0 ip 1 mask 2 gateway 3 dns1 4 dns2
        networkIpSet.curInputIndex = 1; // focus
        UI.pushSubModule("setting", "NetIpInputPanel", true);
    };
    ip1DNS3.onkey_ENTER = function() {
        getIpList();
        networkIpSet.curInputflag = 3; //0 ip 1 mask 2 gateway 3 dns1 4 dns2
        networkIpSet.curInputIndex = 2; // focus
        UI.pushSubModule("setting", "NetIpInputPanel", true);
    };

    ip1DNS4.onkey_ENTER = function() {
        getIpList();
        networkIpSet.curInputflag = 3; //0 ip 1 mask 2 gateway 3 dns1 4 dns2
        networkIpSet.curInputIndex = 3; // focus
        UI.pushSubModule("setting", "NetIpInputPanel", true);
    };

    ip2DNS1.onkey_ENTER = function() {
        getIpList();
        networkIpSet.curInputflag = 4; //0 ip 1 mask 2 gateway 3 dns1 4 dns2
        networkIpSet.curInputIndex = 0; // focus
        UI.pushSubModule("setting", "NetIpInputPanel", true);
    };
    ip2DNS2.onkey_ENTER = function() {
        getIpList();
        networkIpSet.curInputflag = 4; //0 ip 1 mask 2 gateway 3 dns1 4 dns2
        networkIpSet.curInputIndex = 1; // focus
        UI.pushSubModule("setting", "NetIpInputPanel", true);
    };
    ip2DNS3.onkey_ENTER = function() {
        getIpList();
        networkIpSet.curInputflag = 4; //0 ip 1 mask 2 gateway 3 dns1 4 dns2
        networkIpSet.curInputIndex = 2; // focus
        UI.pushSubModule("setting", "NetIpInputPanel", true);
    };
    ip2DNS4.onkey_ENTER = function() {
        getIpList();
        networkIpSet.curInputflag = 4; //0 ip 1 mask 2 gateway 3 dns1 4 dns2
        networkIpSet.curInputIndex = 3; // focus
        UI.pushSubModule("setting", "NetIpInputPanel", true);
    };


    function netSetEtherClearFlag(){
        networkIpSet.clearFlag = 1;
    }

    function networkIpSettingRecordInfo(){
        var txt = "";
        networkIpSet.ipAddress = "";

        txt = ipAddress1.txt.text;
        networkIpSet.ipAddress = txt + ".";
        txt = ipAddress2.txt.text;
        networkIpSet.ipAddress = networkIpSet.ipAddress + txt + ".";
        txt = ipAddress3.txt.text;
        networkIpSet.ipAddress = networkIpSet.ipAddress + txt + ".";
        txt = ipAddress4.txt.text;
        networkIpSet.ipAddress = networkIpSet.ipAddress + txt;
//        DBG_INFO("ipaddress:" + networkIpSet.ipAddress);

        networkIpSet.subnet_Mask = "";
        txt = ipMask1.txt.text;
        networkIpSet.subnet_Mask = txt + ".";
        txt = ipMask2.txt.text;
        networkIpSet.subnet_Mask = networkIpSet.subnet_Mask + txt + ".";
        txt = ipMask3.txt.text;
        networkIpSet.subnet_Mask = networkIpSet.subnet_Mask + txt + ".";
        txt = ipMask4.txt.text;
        networkIpSet.subnet_Mask = networkIpSet.subnet_Mask + txt;
//        DBG_INFO("subnet_Maspek:" +networkIpSet.subnet_Mask);

        networkIpSet.default_Gateway = "";
        txt = ipGateway1.txt.text;
        networkIpSet.default_Gateway = txt + ".";
        txt = ipGateway2.txt.text;
        networkIpSet.default_Gateway = networkIpSet.default_Gateway + txt + ".";
        txt = ipGateway3.txt.text;
        networkIpSet.default_Gateway = networkIpSet.default_Gateway + txt + ".";
        txt = ipGateway4.txt.text;
        networkIpSet.default_Gateway = networkIpSet.default_Gateway + txt;

//        DBG_INFO("default_Gateway:" + networkIpSet.default_Gateway);

        networkIpSet.primary_DNS = "";
        txt = ip1DNS1.txt.text;
        networkIpSet.primary_DNS = txt + ".";
        txt = ip1DNS2.txt.text;
        networkIpSet.primary_DNS = networkIpSet.primary_DNS + txt + ".";
        txt = ip1DNS3.txt.text;
        networkIpSet.primary_DNS = networkIpSet.primary_DNS + txt + ".";
        txt = ip1DNS4.txt.text;
        networkIpSet.primary_DNS = networkIpSet.primary_DNS + txt;
//        DBG_INFO("primary_DNS:" + networkIpSet.primary_DNS);


        networkIpSet.secondary_DNS = "";
        txt = ip2DNS1.txt.text;
        networkIpSet.secondary_DNS = txt + ".";
        txt = ip2DNS2.txt.text;
        networkIpSet.secondary_DNS = networkIpSet.secondary_DNS + txt + ".";
        txt = ip2DNS3.txt.text;
        networkIpSet.secondary_DNS = networkIpSet.secondary_DNS + txt + ".";
        txt = ip2DNS4.txt.text;
        networkIpSet.secondary_DNS = networkIpSet.secondary_DNS + txt;

//        DBG_INFO("secondary_DNS:" + networkIpSet.secondary_DNS);
    }
    networkIpSetIpSave.onkey_UP = function(){
        if(!!networkIpSet.testTimeout){
            return;
        }
        if(networkIpSet.ipConfigType == NetWorkIpConfig.DHCP){
            UI.focusTo(networkIpSetMode);
        }else{
            UI.focusTo(ip2DNS4);
        }

    };
    networkIpSetIpSave.onkey_ENTER = function(){
        try {
            if(!!networkIpSet.testTimeout){
                return;
            }
            DBG_INFO("settingNetSet" + networkIpSet.ipConfigType);
            if (tv)model.network.setEnumIp_config(networkIpSet.ipConfigType);

            networkIpSettingShowToast(HIDE,null,null);
            if (networkIpSet.ipConfigType == NetWorkIpConfig.MANUAL) {
                networkIpSettingRecordInfo();
                DBG_INFO("ipaddress:" + networkIpSet.ipAddress);
                DBG_INFO("subnet_Maspek:" +networkIpSet.subnet_Mask);
                DBG_INFO("default_Gateway:" + networkIpSet.default_Gateway);
                DBG_INFO("primary_DNS:" + networkIpSet.primary_DNS);
                DBG_INFO("secondary_DNS:" + networkIpSet.secondary_DNS);
                if (tv == true) {
                    model.network.setEnumIp_config(networkIpSet.ipConfigType);
                    model.network.setIp_address(networkIpSet.ipAddress);
                    model.network.setSubnet_mask(networkIpSet.subnet_Mask);
                    model.network.setGateway(networkIpSet.default_Gateway);
                    model.network.setDns_server_1(networkIpSet.primary_DNS);
                    model.network.setDns_server_2(networkIpSet.secondary_DNS);
                    if(model.network.getEnumNetworking() == NetWorkType.ETHER){
                        model.network.WiredSet();
                    }else if(model.network.getEnumNetworking() == NetWorkType.WIRELESS){
                        model.network.WirelessSet();
                    }
                }
            } else { //DHCP
                if (tv == true) {
                    model.network.setEnumIp_config(networkIpSet.ipConfigType);
                    if(model.network.getEnumNetworking() == NetWorkType.ETHER){
                        if (model.network.getEnumNetworkAvailable() == 1 && networkIpSet.ipConfigType == networkIpSet.oriIpConfigType) {
                            DBG_INFO("networkIpSetIpSave.onkey_ENTER:do not need to set ethernet!!");
                        } else {
                            model.network.WiredSet();
                        }
                        model.network.WiredSet();
                    }else if(model.network.getEnumNetworking() == NetWorkType.WIRELESS){
                        model.network.WirelessSet();
                    }
                }
            }
            networkIpLoadingGrp.alpha = 1;
            UI.callTTS("[SE0607]");
            UI.getTween(networkIpLoadingImg, true, true).to({rotation: networkIpLoadingImg.rotation + Math.PI*2}, 3000);
            clearTimeout(networkIpSet.testTimeout);
            networkIpSet.testTimeout = setTimeout(networkIpSettingTest, 10000);

        } catch (ex) {
            DBG_INFO("settingNetSetEtherIpSetRecordIpInfo:" + ex.message);
        }

    };

    function networkIpSettingTest() {
        var networkAvailable = tv ? model.network.getEnumNetworkAvailable() : 0;
        createjs.Tween.removeTweens(networkIpLoadingImg);
        networkIpLoadingImg.rotation = 0;
        networkIpLoadingGrp.alpha = 0;
        DBG_ERROR("networkIpSettingTest:networkAvailable = "+networkAvailable);
        if(networkAvailable == 1){
            networkIpSettingShowToast(SHOW,LANGUAGE.Success,"setting/wifi/ic_success.png");
            UI.callTTS(LANGUAGE.Success,0);
        }else{
            networkIpSettingShowToast(SHOW,LANGUAGE.Fail,"setting/wifi/ic_failure.png");
            UI.callTTS(LANGUAGE.Fail,0);
        }
        networkIpSet.testTimeout = null;
//        if (networkIpSet.ipConfigType == 0) {
//            return;
//        }
//        var ip = '';
//        var mask = '';
//        var gateway = '';
//        var dns1 = '';
//        var dns2 = '';
//        ip = tv?model.network.getIp_address():networkIpSet.ipAddress;
//        mask = tv?model.network.getSubnet_mask():networkIpSet.subnet_Mask;
//        gateway = tv?model.network.getGateway():networkIpSet.default_Gateway;
//        dns1 = tv?model.network.getDns_server_1():networkIpSet.primary_DNS;
//        dns2 = tv?model.network.getDns_server_2():networkIpSet.secondary_DNS;
//        DBG_INFO(networkIpSet.ipAddress + "======" + ip);
//        DBG_INFO(networkIpSet.subnet_Mask + "======" + mask);
//        DBG_INFO(networkIpSet.default_Gateway + "======" + gateway);
//        DBG_INFO(networkIpSet.primary_DNS + "======" + dns1);
//        DBG_INFO(networkIpSet.secondary_DNS + "======" + dns2);
//        if (networkIpSet.ipAddress == ip
//            && networkIpSet.subnet_Mask == mask
//            && networkIpSet.default_Gateway == gateway
//            && networkIpSet.primary_DNS == dns1
//            && networkIpSet.secondary_DNS == dns2) {
//            networkIpSettingShowToast(SHOW,LANGUAGE.Success,"setting/wifi/ic_success.png");
//        } else {
//            networkIpSettingShowToast(SHOW,LANGUAGE.Fail,"setting/wifi/ic_failure.png");
//        }
    }
    function networkIpSettingShowToast(alpha,text,img){
        networkIpToast.alpha = alpha;
        if(img!=null){
            UI.setImage(networkIpToastImg,img);
        }
        if(text!=null){
            UI.setText(networkIpToastText,text);
        }
        UI.updateStage();
        clearTimeout(networkIpSet.timeout);
        if(alpha == SHOW){
            networkIpSet.timeout = setTimeout(function(){networkIpSettingShowToast(HIDE,null,null)},3000);
        }
    }
    function networkIpSetStatusChanged(val){
        DBG_INFO("networkIpSetStatusChanged:available="+val);
        getAndShowIpAddress();
        if(!!networkIpSet.testTimeout){
            DBG_ERROR("onNetworkConfigStatusChanged:available"+val);
            if(val == 1){
                clearTimeout(networkIpSet.testTimeout);
                createjs.Tween.removeTweens(networkIpLoadingImg);
                networkIpLoadingImg.rotation = 0;
                networkIpLoadingGrp.alpha = 0;
                networkIpSettingShowToast(SHOW,LANGUAGE.Success,"setting/wifi/ic_success.png");
                UI.callTTS(LANGUAGE.Success);
                networkIpSet.testTimeout = null;
            }
        }
    }
    function netSetEtherIpStateCallBack(state){
        DBG_ALWAYS("netSetEtherIpStateCallBack:"+state);
        switch (state){
            case 3://idle
                var currConfigType = networkIpSet.ipConfigType;
                getAndShowIpAddress();
                networkIpSet.oriIpConfigType = networkIpSet.ipConfigType;
                if(currConfigType != opData.ipConfigType){
                    DBG_ALWAYS("settingNetSetEtherIpNetworkOnChange:"+currConfigType+","+opData.ipConfigType);
                    networkIpSet.ipConfigType = currConfigType;
                }
                break;
            case 4://update
                break;
            case 9://not available
                break;
            default :
                break;
        }
    }

    networkIpSet.onkey_BACKSPACE = function() {
        networkIpSet.showFrom = 0;
        UI.popSubModule();
    };
    networkIpSet.onPop = function(){
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_CHANGED,networkIpSetStatusChanged);
        networkIpSet.showFrom = 0;
        clearTimeout(networkIpSet.timeout);
        networkIpSet.timeout = null;
        clearTimeout(networkIpSet.testTimeout);
        networkIpSet.testTimeout = null;
    }

};