// Init
UI.moduleBuilder['setting']['networkConfigType'] = function(){

    var mainPanelData = {
        networkConfigTypeDialogBgImg: UI['bg_overlay'],
        networkConfigTypeName:"[SE0598]",///Connection Type
        networkConfigTypeImg: UI.window_bg

    };
    var template = Util.readJson("module/setting/networkConfigType.json");
    var networkConfigType = SubModule.create(mainPanelData, template);
    var networkConfigTypeList = UI.getItem(networkConfigType, "networkConfigTypeList");
    networkConfigType.networkTypeList = ["[SE0159]", "[SE0600]", "[GE0006]"];
    networkConfigType.index = 0;
    var array = [];
    for (var i = 0; i < networkConfigType.networkTypeList.length; i++) {
        array.push({});
        array[i].name = "networkConfigTypeId" + i;
        array[i].wifiAuthTypeItemImg = UI.item_bg;
        array[i].wifiAuthTypeName = networkConfigType.networkTypeList[i];
        array[i].wifiAuthTypeFlag = "setting/ic_radiobutton_normal.png"
    }
    var info = {
        template: "wifi_authtype",
        direction: CONST.GIRD_DIRECTION.H,
        breakNum: 1,
        distanceX: 0,
        distanceY: 20,
        container: networkConfigTypeList
    };
    networkConfigTypeList.removeAllChildren();
    UI.resetViewPos(networkConfigTypeList);
    UI.removeScrollbar(networkConfigTypeList);
    UI.removeView(networkConfigTypeList);
    UI.removeMask(networkConfigTypeList);
    Gird.create(array, info);
    UI.addMask(networkConfigTypeList, 820, 676, 50, 10);
    UI.setView(networkConfigTypeList, 820, 676);
    UI.addScrollbar(networkConfigTypeList);
    networkConfigType.FirstFocus = UI.getItem(networkConfigTypeList,"networkConfigTypeId0");

    networkConfigType.onShow = function () {
        try {
            for(var i=0;i<3;i++){
                var  target = UI.getItem(networkConfigTypeList,"networkConfigTypeId"+i);
                UI.setImage(target.children[2], "setting/ic_radiobutton_normal.png");
            }
            var networkConfigPanel = UI.getSubModule("networkConfigPanel");
            DBG_INFO("networkConfigType.onShow:"+networkConfigPanel.crtConnection);
            var  obj = UI.getItem(networkConfigTypeList,"networkConfigTypeId0");
            if(networkConfigPanel.crtConnection == NetWorkType.ETHER){
                networkConfigType.FirstFocus = UI.getItem(networkConfigTypeList,"networkConfigTypeId0");
                obj = UI.getItem(networkConfigTypeList,"networkConfigTypeId0");
                networkConfigType.index = 0;
            }else if(networkConfigPanel.crtConnection == NetWorkType.WIRELESS){
                networkConfigType.FirstFocus = UI.getItem(networkConfigTypeList,"networkConfigTypeId1");
                obj = UI.getItem(networkConfigTypeList,"networkConfigTypeId1");
                networkConfigType.index = 1;
            }else if(networkConfigPanel.crtConnection == NetWorkType.OFF){
                networkConfigType.FirstFocus = UI.getItem(networkConfigTypeList,"networkConfigTypeId2");
                obj = UI.getItem(networkConfigTypeList,"networkConfigTypeId2");
                networkConfigType.index = 2;
            }
            UI.setImage(obj.children[2], "setting/"+GLOBAL.LAUNCHER_BRAND+"/ic_radiobutton_focused.png");
            networkConfigType.currFocus = UI.getItem(networkConfigTypeList,"networkConfigTypeId0");
            UI.focusTo(networkConfigType.FirstFocus);
        }

        catch (ex) {
            DBG_ERROR(ex.message);
        }
    };
    function ConfigTypeSetNetworkEther(){
        if(tv){
            if(model.network.getEnumNetworking() == NetWorkType.OFF){
                model.network.setEnumNetworking(NetWorkType.ETHER);
                model.network.setEnumIp_config(NetWorkIpConfig.DHCP);
                model.network.WiredSet();
            }else if(model.network.getEnumNetworking() == NetWorkType.WIRELESS){
                model.network.setEnumNetworking(NetWorkType.ETHER);
                model.network.setEnumIp_config(NetWorkIpConfig.DHCP);
                model.network.WiredSet();
            }
        }
    }

    function ConfigTypeSetNetworkWireless(){
        if(tv){
            model.network.setEnumNetworking(NetWorkType.WIRELESS);
            model.network.setEnumIp_config(NetWorkIpConfig.DHCP);
            model.network.WirelessSet();
        }
    }
    function ConfigTypeSetNetworkOff(){
        if (tv){
            model.network.setEnumNetworking(NetWorkType.OFF);
        }
    }

    networkConfigTypeList.onkey_ENTER = function (focus) {
        var index = networkConfigTypeList.initSequence.indexOf(focus);
        DBG_INFO("networkConfigTypeList!!!!"+index);
        if(networkConfigType.index == index){
            UI.popSubModule();
        }else{
            var networkConfigPanel = UI.getSubModule("networkConfigPanel");
            DBG_ALWAYS("networkConfigTypeList:"+networkConfigPanel.openFromPwd );
            networkConfigPanel.openFromPwd = 4;
            if(index == 0){
                ConfigTypeSetNetworkEther();
            }else if(index == 1){
                ConfigTypeSetNetworkWireless();
            }else if(index == 2){
                ConfigTypeSetNetworkOff();
            }
            UI.popSubModule();
        }
    };

//
//    wifiWpsPinCancelBtn.onkey_ENTER = function () {
//        showWifiWpsPinConnectToast(HIDE,null,null);
//        clearTimeout(wifiWpsPin.showTimeout);
//        UI.popSubModule();
//    };


//    wifiWpsPin.onExit = function(){
//        DBG_ALWAYS("wifiWpsPin !!!!!!!!!!!!!!!");
//        showWifiWpsPinConnectToast(HIDE,null,null);
//        clearTimeout(wifiWpsPin.showTimeout);
//        clearTimeout(wifiWpsPin.pinConnTimer);
//    };
//
//    wifiWpsPin.onPop = function(){
//        DBG_ALWAYS("wifiWpsPin !!!!!!!!!!!!!!!");
//        showWifiWpsPinConnectToast(HIDE,null,null);
//        clearTimeout(wifiWpsPin.showTimeout);
//        clearTimeout(wifiWpsPin.pinConnTimer);
//    }
};

