// Init
UI.moduleBuilder['setting']['networkConfigPanel'] = function(){

    var HIDE = 0;
    var SHOW = 1;
    var GRAY = 0.6;
    var SUCCESS = 0;
    var FAIL = 1;
    var WRONG_PWD =2;
    var LANGUAGE = {
        "Ether":"[SE0159]",
        "Wireless":"[SE0600]",
        "Off":"[GE0006]",
        "Connecting":"[SE0607]", //Connecting, please wait……
        "Connected":"[SE0399]",
        "Disconnected":"[SE0400]",
        "Searching":"[SE0603]", //Network searching, please wait……
        "ConnectSuccess":"[SE0165]", //Connected successfully
        "WrongPassword":"[SE1376]",//Password incorrect!
        "ConnectFail":"[SE0166]", //Failed to connect. Please try again
        "NoWirelessModule":"[OT0015]",//"Wireless module is not inserted, insert the wireless module",
        "NoResult":"[SE2528]" //No Result

    };
    var mainPanelData = {
        networkConfigSheetBgImg:UI.back_bg,
        networkConfigTypeImg:UI.btn_normal_bg,
        networkConnectImg2:"setting/ic_success.png",
        networkConnectImg:"setting/ic_loading1.png",
        wifiListBgImg :"setting/wifi/list_bg.png",
//        networkConnectTypeGrp1Img:UI.btn_normal_bg,
//        networkConnectTypeGrp2Img:UI.btn_normal_bg,
        networkConfigIpSetImg:UI.btn_normal_bg,
        networkToastBgImg : "toast/Toast_bg2.png",
        networkToastImg:"setting/wifi/ic_not_connected.png",
        refreshBtnBgImg:UI.btn_normal_bg,
        addBtnBgImg:UI.btn_normal_bg,
        advanceBtnBgImg:UI.btn_normal_bg,
        loadingImg:"setting/wifi/ic_loading_01.png",
        connectImg:"setting/wifiConnect.png",
        lockImg1:"setting/wifi/wifi_1_lock_normal.png",
        lockImg2:"setting/wifi/wifi_2_lock_normal.png",
        lockImg3:"setting/wifi/wifi_3_lock_normal.png",
        lockImg4:"setting/wifi/wifi_4_lock_normal.png",
        lockImg5:"setting/wifi/wifi_1_normal.png",
        lockImg6:"setting/wifi/wifi_2_normal.png",
        lockImg7:"setting/wifi/wifi_3_normal.png",
        lockImg8:"setting/wifi/wifi_4_normal.png",
        networkConfigTitle1:"[OT0011]", //Network Configuration
        ConnectionType:"[SE0598]", //Connection Type
        refreshBtnText:"[SE1301]",  //Refresh
        addBtnText:"[GE0016]",  //Add
        advanceBtnText:"[SE0037]",//"Advanced Settings"
        networkConfigIpSetText:"[SE0172]" //IP Setting
//        wifiBgImg: UI.window_bg
    };
    var template = Util.readJson("module/setting/networkConfigPanel.json");
    var networkConfigPanel = SubModule.create(mainPanelData, template);
    var networkConnectStatusGrp = UI.getItem(networkConfigPanel,"networkConnectStatusGrp");
    var networkConnectImg = UI.getItem(networkConnectStatusGrp, "networkConnectImg");
    var networkConnectText = UI.getItem(networkConnectStatusGrp,"networkConnectText");
//    var networkConnectTypeGrp1 = UI.getItem(networkConfigPanel,"networkConnectTypeGrp1");
//    var networkConnectTypeGrp2 = UI.getItem(networkConfigPanel,"networkConnectTypeGrp2");
    networkConnectImg.pivot.x = 64;
    networkConnectImg.pivot.y = 64;
    var networkConfigIpSetBtn = UI.getItem(networkConfigPanel,"networkConfigIpSetBtn");
    var networkWifiListGrp = UI.getItem(networkConfigPanel,"networkWifiListGrp");

    var networkConfigTypeBtn = UI.getItem(networkConfigPanel, "networkConfigTypeBtn");
    var networkConfigTypeText = UI.getItem(networkConfigTypeBtn,"networkConfigTypeText");
    var networkToast = UI.getItem(networkConfigPanel, "networkToast");
    var networkToastImg = UI.getItem(networkToast, "networkToastImg");
    var networkToastText = UI.getItem(networkToast, "networkToastText");

    var networkToastBgImg = UI.getItem(networkToast, "networkToastBgImg");
    networkToastBgImg.doFlip = true;
//    var networkConnectTypeGrp1Text = UI.getItem(networkConfigPanel,"networkConnectTypeGrp1Text");
//    var networkConnectTypeGrp2Text = UI.getItem(networkConfigPanel,"networkConnectTypeGrp2Text");
    var wifiList = UI.getItem(networkWifiListGrp,"wifiList");
    var refreshBtn = UI.getItem(networkWifiListGrp,"refreshBtn");
    var addBtn = UI.getItem(networkWifiListGrp,"addBtn");
    var advanceBtn = UI.getItem(networkWifiListGrp,"advanceBtn");

    networkConfigPanel.netAvailableFlag = 1;
/***** DBTAG 20161011 MARK  *****/
    networkConfigPanel.wifiSecurityType = [" ","WEP", "WPA", "WPA2", "WEP", "WPA", "WPA2","802.1x","WPA/WPA2"];
/***** DBTAG --END  *****/
    networkConfigPanel.connectTimer = 0;
    networkConfigPanel.wifiApSearchTimer = 0;
    networkConfigPanel.showTimeout = 0;
    networkConfigPanel.switchNetTimeout = 0;

    networkConfigPanel.crtConnection = 0;
    networkConfigPanel.WifiNum=0;
    networkConfigPanel.WifiList=[];
    networkConfigPanel.wifiSetType = 0;
    networkConfigPanel.currIdx = 0;
    networkConfigPanel.currBeginIdx = 0;
    networkConfigPanel.currSSIDName = "";
    networkConfigPanel.currSecType = 0;
    networkConfigPanel.currAuthType = 0;
    networkConfigPanel.currSignal = 0;
    networkConfigPanel.currPassword = "";
    networkConfigPanel.manualAddSSID = "";
    networkConfigPanel.wifiSearState = 0;
    networkConfigPanel.isLoading = false;
    networkConfigPanel.networkTypeList = ["[SE0159]","[SE0600]","[GE0006]"];
    networkConfigPanel.connWifiPara = {};
    networkConfigPanel.connWifiPara.SSID = "";
    networkConfigPanel.connWifiPara.secType = 0;
    networkConfigPanel.connWifiPara.authType = 0;
    networkConfigPanel.connWifiPara.connPassword = "";
    networkConfigPanel.showLoading = false;
    networkConfigPanel.loadingTimeoutBig = 0;

    Select.create(networkConfigTypeText, networkConfigPanel.networkTypeList);
    networkConfigTypeText.selectCurrent(0);

    networkConfigPanel.connWifiPara = {
        "connState":0,
        "connSSID":"1113",
        "connAuthType":0,
        "connSecType":0,
        "connPassword":""
    };
    networkConfigPanel.oldSelectedIndex = 0;
    networkConfigPanel.connectIndex = 0;

    networkConfigPanel.openFromPwd = 0;
    networkConfigPanel.noAutoClose = true;

    networkConfigPanel.onPush =  function(){
        var networkMainPanel = UI.getSubModule("networkMainPanel");
        if(networkMainPanel){
            networkMainPanel.alpha = 0;
        }
        initNetworkConfig(null);
    };
    function initNetworkConfig(from){
        setNetworkIpSetBtnAlpha(HIDE,null);
        var NetStatus = tv ? model.network.getEnumNetworkAvailable() : 1; //1 success  0 fail

        showWifiConnectToast(HIDE,null,null);
        networkConfigPanel.oldSelectedIndex = 0;
        networkConfigPanel.oldTypeIndex = 0;
        DBG_ALWAYS("getEnumNetworkAvailable:" + NetStatus);
        var networkType = tv?model.network.getEnumNetworking():NetWorkType.ETHER;
        DBG_ALWAYS("getEnumNetworking:" + networkType);
        networkConfigPanel.crtConnection = networkType;
        networkConfigPanel.netAvailableFlag = NetStatus;

        if(networkType == NetWorkType.ETHER){

//            setNetworkConfigType(LANGUAGE.Ether);
            networkConfigTypeText.selectCurrent(0);
            if(from!=null){
                setConnectStatusGrpAlpha(SHOW,LANGUAGE.Connecting,"setting/ic_loading1.png");
                clearTimeout(networkConfigPanel.switchNetTimeout);
                networkConfigPanel.switchNetTimeout = setTimeout(ethernetConnectTimeout,13000);
            }else{
                setNetworkIpSetBtnAlpha(SHOW,null);
                if(networkConfigPanel.netAvailableFlag == NetWorkConnect.CONNECT){
                    setConnectStatusGrpAlpha(SHOW,LANGUAGE.Connected,"setting/ic_success.png");
                }else{
                    setConnectStatusGrpAlpha(SHOW,LANGUAGE.Disconnected,"setting/ic_failure.png");
                }
            }

        }else if(networkType == NetWorkType.WIRELESS){
            networkConfigTypeText.selectCurrent(1);
            setNetworkIpSetBtnAlpha(HIDE,null);
            setConnectStatusGrpAlpha(SHOW,LANGUAGE.Searching,"setting/ic_loading1.png");
//            setTimeout(startWifiScan(),150);
            startWifiScan();
        }else{
            networkConfigPanel.crtConnection = NetWorkType.OFF;
            networkConfigTypeText.selectCurrent(2);
            setNetworkIpSetBtnAlpha(HIDE,null);
            setConnectStatusGrpAlpha(HIDE,null,null);
        }
        setNetworkWifiListGrpAlpha(HIDE);
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_CHANGED, onNetworkConfigStatusChanged);
        UI.focusTo(networkConfigTypeBtn);
        networkConfigPanel.currFocus = UI.getItem(networkConfigPanel, "networkConfigTypeBtn");
    }
    networkConfigPanel.onShow =  function(){
        try{
            DBG_ERROR("networkConfigPanel.openFromPwd:" + networkConfigPanel.openFromPwd);
            networkConfigPanel.alpha = 1;
            if(networkConfigPanel.openFromPwd == 2){
                startConnectWifi();
                networkConfigPanel.openFromPwd = 0;
                return;
            }else if(networkConfigPanel.openFromPwd == 1){
                networkConfigPanel.openFromPwd = 0;
                return;
            }else if(networkConfigPanel.openFromPwd == 3){
                networkConfigPanel.openFromPwd = 0;
                addWifiToList();
                return;
            }else if(networkConfigPanel.openFromPwd == 4){
                networkConfigPanel.openFromPwd = 0;
                initNetworkConfig(0);
                return;
            }
        }
        catch (ex){
            DBG_ERROR(ex.message);
        }
    };
    networkConfigPanel.currFocus = UI.getItem(networkConfigPanel, "networkConfigTypeBtn");
    function onNetworkConfigStatusChanged(val){
        DBG_INFO("onNetworkConfigStatusChanged:"+val);
        networkConfigPanel.netAvailableFlag = val;
        if(networkConfigPanel.crtConnection == NetWorkType.ETHER){
            showEthernetNetworkStatus(val);
        }else if(networkConfigPanel.crtConnection == NetWorkType.WIRELESS){
            if(networkConfigPanel.WifiList.length>0 && networkWifiListGrp.alpha == 1){
                if(val == NetWorkConnect.CONNECT){
                    var currSSID = tv?model.network.getSsid():"1112";
                    for (var i=0; i < networkConfigPanel.WifiList.length; i++) {
                        if(networkConfigPanel.WifiList[i].wifiName == currSSID){
                            networkConfigPanel.connectIndex = i;
                            networkConfigPanel.connWifiPara.connSSID = currSSID;
                            if(!networkConfigPanel.showLoading){
                                networkConfigSetWifiItemStatus(2);
                            }
                            networkConfigPanel.connWifiPara.connAuthType = networkConfigPanel.WifiList[i].wifiAuthType;
                            networkConfigPanel.connWifiPara.connSecType =  networkConfigPanel.WifiList[i].wifiSecType;
                            networkConfigPanel.connWifiPara.connPassword = model.network.getEncryptionPassphrase();
                            break;
                        }
                    }
                }else{
                    if(!networkConfigPanel.showLoading){
                        networkConfigSetWifiItemStatus(1);
                    }
                }
            }
        }
    }

    function setNetworkIpSetBtnAlpha(alpha,text){
        networkConfigIpSetBtn.alpha = alpha;
        if(text!=null){
        }
        UI.getTween(UI).wait(1000);
    }

    function setConnectStatusGrpAlpha(alpha,text,img){
        networkConnectStatusGrp.alpha = alpha;
        if(text!=null){
            UI.setText(networkConnectText,text);
            if(alpha == SHOW){
                UI.callTTS(text);
            }
        }
        if(img!=null){
            clearTimeout(networkConfigPanel.loadingTimeoutBig);
            UI.setImage(networkConnectImg,img);
            if(img == "setting/ic_loading1.png"){
//                UI.registerKeyCodes([CONST.KEY.VK_BACK]);
                networkConfigPanel.isLoading = true;
                networkConfigPanel.loadingTimeoutBig = setTimeout(function() {
                    UI.getTween(networkConnectImg, true, true).to({rotation: networkConnectImg.rotation + Math.PI*2}, 3000);
                },600);
            }else{
                createjs.Tween.removeTweens(networkConnectImg);
                networkConnectImg.rotation = 0;
                networkConfigPanel.isLoading = false;
//                UI.registerKeyCodes(null);
            }
        }
        if(alpha == HIDE){
            createjs.Tween.removeTweens(networkConnectImg);
            networkConnectImg.rotation = 0;
            networkConfigPanel.isLoading = false;
//            UI.registerKeyCodes(null);
        }
        UI.getTween(UI).wait(1000);
    }

    function setNetworkWifiListGrpAlpha(alpha){
        networkWifiListGrp.alpha = alpha;
        UI.getTween(UI).wait(1000);
    }

    function showWifiConnectToast(alpha,text,img){
        networkToast.alpha = alpha;
        if(img!=null){
            UI.setImage(networkToastImg,img);
        }
        if(text!=null){
            UI.setText(networkToastText,text);
        }
        UI.updateStage();
        clearTimeout(networkConfigPanel.showTimeout);
        if(alpha == SHOW){
            UI.callTTS(text);
            networkConfigPanel.showTimeout = setTimeout(function(){showWifiConnectToast(HIDE,null,null)},3000);
        }
    }
    function ethernetConnectTimeout(){
        DBG_ERROR("ethernetConnectTimeout");
        networkConfigPanel.netAvailableFlag = tv ? model.network.getEnumNetworkAvailable() : 1;
        if(networkConfigPanel.netAvailableFlag == NetWorkConnect.CONNECT){
            setConnectStatusGrpAlpha(SHOW,LANGUAGE.Connected,"setting/ic_success.png");
        }else{
            setConnectStatusGrpAlpha(SHOW,LANGUAGE.Disconnected,"setting/ic_failure.png");
        }
        setNetworkIpSetBtnAlpha(SHOW,null);
    }

    function showEthernetNetworkStatus(val){
        networkConfigPanel.netAvailableFlag = val;

        if(networkConfigPanel.netAvailableFlag == NetWorkConnect.CONNECT){
            setConnectStatusGrpAlpha(SHOW,LANGUAGE.Connected,"setting/ic_success.png");
            setNetworkIpSetBtnAlpha(SHOW,null);
        }else{
            var linkState = model.network.getEnumLink();
            DBG_ERROR("showEthernetNetworkStatus:"+linkState);
            if(linkState != 1 && linkState != 2){
                setConnectStatusGrpAlpha(SHOW,LANGUAGE.Disconnected,"setting/ic_failure.png");
                setNetworkIpSetBtnAlpha(SHOW,null);
            }
        }
    }

    function setNetworkEther(){
/***** DBTAG20161012 MARK *****/
        if(tv){
            if(model.network.getEnumNetworking() == NetWorkType.OFF){
                model.network.setEnumNetworking(NetWorkType.ETHER);
                model.network.setEnumIp_config(NetWorkIpConfig.DHCP);
                model.network.WiredSet();
            }
        }
        if(tv){
            if(model.network.getEnumNetworking() == NetWorkType.WIRELESS){
                model.network.setEnumNetworking(NetWorkType.ETHER);
                model.network.setEnumIp_config(NetWorkIpConfig.DHCP);
                model.network.WiredSet();
            }
        }
        clearTimeout(networkConfigPanel.switchNetTimeout);
        networkConfigPanel.switchNetTimeout = setTimeout(ethernetConnectTimeout,13000);
    }
    networkConfigTypeBtn.onFocus = function(focus){
//        UI.moveCursor(UI.adjustView());
//        UI.getTween(focus).to({scaleX:1.00, scaleY:1.00}, 200, UI.ease.quartOut);
//        UI.getTween(UI.base.cursor, false).to({scaleX:1.00, scaleY:1.00}, 200, UI.ease.quartOut);
//        UI.getTween(UI.base.cursor, false).to({alpha:1}, 500, UI.ease.quartOut);
//        UI.moveTop(focus);
//        UI.base.runText(focus);
        return true;
    };
    networkConfigTypeBtn.onNormal = function(){
        return true;
    };

    wifiList.onFocus = function(focus){
        createjs.Tween.removeTweens(UI.base.cursor);
        UI.moveCursor(UI.adjustView());
        UI.getTween(focus.scale).to({x:1.00, y:1.00}, 200, UI.ease.quartOut);
        UI.getTween(UI.base.cursor).to({alpha:1}, 500, UI.ease.quartOut);
        UI.moveTop(focus);
        if (GLOBAL.HICONTRAST) {
            UI.base.toHiContrast(focus);
        }
        if(GLOBAL.TTS){
            if (focus.voiceStr) {
                UI.callTTS(focus.voiceStr);
            } else {
                UI.callTTS(UI.base.getVoiceStr(focus))
            }
        }
        return false;
    };
    wifiList.onNormal = function(){
        return true;
    };

    networkConfigTypeBtn.onkey_ENTER = function () {
        if(networkConfigPanel.isLoading){
            return;
        }
        DBG_INFO("networkConfigTypeBtn.onkey_ENTER:"+networkConfigPanel.crtConnection);
//        setConnectStatusGrpAlpha(HIDE,null,null);
//        setNetworkIpSetBtnAlpha(HIDE,null);
//        setNetworkWifiListGrpAlpha(HIDE);
        clearTimeout(networkConfigPanel.wifiApSearchTimer);
        networkConfigPanel.protected = false;
        clearTimeout(networkConfigPanel.switchNetTimeout);
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_ACCESS_POINTS_SEARCH_CHANGED,SearchWifiResultCallBack); ;
        if(tv && model.network.getEnumAccess_pointsSearch() == 1){
            model.network.setEnumAccess_pointsSearch(0);
        }
        networkConfigPanel.openFromPwd = 0;
        UI.pushSubModule("setting", "networkConfigType", true);
        return false;
    };
    networkConfigTypeBtn.onkey_DOWN = function(){
        if(networkConfigIpSetBtn.alpha == 1){
            UI.focusTo(networkConfigIpSetBtn);
        }
        if(networkWifiListGrp.alpha == 1){
//            if(networkConfigPanel.WifiList.length>0){
//                UI.focusTo(networkConfigPanel.wifiFirstFocus);
//            }else{
//                UI.focusTo(refreshBtn);
//            }
            UI.focusTo(advanceBtn);
        }
    };
    networkConfigTypeBtn.onkey_RIGHT = function() {
        if(networkConfigPanel.isLoading){
            return;
        }
        networkConfigTypeText.selectNext();
        var index = networkConfigPanel.networkTypeList.indexOf(networkConfigTypeText.selected);
        if(index == 2 && networkConfigPanel.crtConnection == NetWorkType.OFF){
            setNetworkType(0);
            networkConfigTypeText.selectCurrent(0);
        }else{
            setNetworkType(index);
        }

    };
    networkConfigTypeBtn.onkey_LEFT = function() {
        if(networkConfigPanel.isLoading){
            return;
        }
        networkConfigTypeText.selectPrev();
        var index = networkConfigPanel.networkTypeList.indexOf(networkConfigTypeText.selected);
        if(index == 0 && networkConfigPanel.crtConnection == NetWorkType.ETHER){
            setNetworkType(2);
            networkConfigTypeText.selectCurrent(2);
        }else{
            setNetworkType(index);
        }
    };
    function setNetworkType(index){
        clearShowForSwitchNetwork();
        if(index == 0){
            networkConfigPanel.crtConnection = NetWorkType.ETHER;
            setConnectStatusGrpAlpha(SHOW,LANGUAGE.Connecting,"setting/ic_loading1.png");
            setNetworkEther();
        }else if(index == 1){
            networkConfigPanel.crtConnection = NetWorkType.WIRELESS;
            setConnectStatusGrpAlpha(SHOW,LANGUAGE.Searching,"setting/ic_loading1.png");
            startWifiScan();
        }else if(index == 2){
            networkConfigPanel.crtConnection = NetWorkType.OFF;
            if (tv){
                if(model.network.getEnumNetworking() != NetWorkType.OFF){
                    model.network.setEnumNetworking(NetWorkType.OFF);
                }
            }
            setConnectStatusGrpAlpha(HIDE,null,null);
            setNetworkIpSetBtnAlpha(HIDE,null);
        }
    }

    function clearShowForSwitchNetwork(){
        setConnectStatusGrpAlpha(HIDE,null,null);
        setNetworkIpSetBtnAlpha(HIDE,null);
        setNetworkWifiListGrpAlpha(HIDE);
        clearTimeout(networkConfigPanel.wifiApSearchTimer);
        networkConfigPanel.protected = false;
        clearTimeout(networkConfigPanel.switchNetTimeout);
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_ACCESS_POINTS_SEARCH_CHANGED,SearchWifiResultCallBack); ;
        if(tv && model.network.getEnumAccess_pointsSearch() == 1){
            model.network.setEnumAccess_pointsSearch(0);
        }
    }

    networkConfigIpSetBtn.onkey_ENTER = function (focus) {
//        networkConfigPanel.alpha = 0;
        UI.pushSubModule("setting", "networkIpSet", true);
        return false;
    };
    refreshBtn.onkey_UP = function(){
        if(networkConfigPanel.WifiList.length>0){
            var lastID = networkConfigPanel.WifiList.length -1;
            var tailFocus = "wifiNameId"+lastID;
            networkConfigPanel.tailFocus = UI.getItem(wifiList,tailFocus);
            UI.focusTo(networkConfigPanel.tailFocus);
        }
    };
    refreshBtn.onkey_ENTER = function(){
        setNetworkWifiListGrpAlpha(0.05);
        UI.base.cursor.alpha = 0.1;
        setConnectStatusGrpAlpha(SHOW,LANGUAGE.Searching,"setting/ic_loading1.png");
        UI.updateStage();
        startWifiScan();
    };

    addBtn.onkey_UP = function(){
        if(networkConfigPanel.WifiList.length>0){
            var lastID = networkConfigPanel.WifiList.length -1;
            var tailFocus = "wifiNameId"+lastID;
            networkConfigPanel.tailFocus = UI.getItem(wifiList,tailFocus);
            UI.focusTo(networkConfigPanel.tailFocus);
        }
    };
    addBtn.onkey_ENTER = function(){
        DBG_INFO("!!!!!!!!!!!!!");
        UI.pushSubModule("setting", "wifiAdd", true);
        return false;
    };
    advanceBtn.onkey_DOWN = function(){
        if(networkWifiListGrp.alpha == 1){
            if(networkConfigPanel.WifiList.length>0){
                UI.focusTo(networkConfigPanel.wifiFirstFocus);
            }else{
                UI.focusTo(refreshBtn);
            }
        }
    };

    advanceBtn.onkey_UP = function(){
//        if(networkConfigPanel.WifiList.length>0){
//            var lastID = networkConfigPanel.WifiList.length -1;
//            var tailFocus = "wifiNameId"+lastID;
//            networkConfigPanel.tailFocus = UI.getItem(wifiList,tailFocus);
//            UI.focusTo(networkConfigPanel.tailFocus);
//        }
        UI.focusTo(networkConfigTypeBtn);
    };
    advanceBtn.onkey_ENTER = function(){
        UI.pushSubModule("setting", "wifiAdvanced", true);
        return false;
    };

    wifiList.onkey_ENTER = function (focus) {
        if(networkWifiListGrp.alpha == 0 || networkConfigPanel.isLoading){
            return;
        }
        var index = wifiList.initSequence.indexOf(focus);
        DBG_INFO("wifiList!!!!"+index);
        networkConfigPanel.connectIndex = index;
        if(tv){
            var currSSID = model.network.getSsid();
            networkConfigPanel.netAvailableFlag = model.network.getEnumNetworkAvailable();
            if(currSSID == networkConfigPanel.WifiList[index].wifiName && networkConfigPanel.netAvailableFlag == NetWorkConnect.CONNECT){
//                return;
            }
        }else{
            networkConfigPanel.currSecType = 0;
        }
//        networkConfigPanel.wifiSetType = 0;
        var selectWifiPare = networkConfigPanel.WifiList[index];
        setWifiCurrentPare(selectWifiPare.wifiName,selectWifiPare.wifiSecType,selectWifiPare.wifiAuthType,selectWifiPare.wifiSignal);
        try{
            if(tv == true){
                model.network.setLink_quality(parseInt(networkConfigPanel.currSignal));
            }
            DBG_ERROR("settingNetSetWifiListEnterHandler:"+networkConfigPanel.currSecType);
            setWifiConnPare();
            if(networkConfigPanel.currSecType == 0){
                startConnectWifi();
            }else{
                UI.pushSubModule("setting", "wifiPwdInput", true);
                return false;
            }
        }catch (ex){
            DBG_ERROR("settingNetSetWifiListEnterHandler:"+ex.message);
        }
    };
    function startConnectWifi(){
        showWifiConnectToast(HIDE,null,null);
        DBG_ERROR("setting3rdNetworkConfigConnectWifi name:"+networkConfigPanel.currSSIDName);
        DBG_ERROR("setting3rdNetworkConfigConnectWifi pwd:"+networkConfigPanel.currPassword);
        DBG_ERROR("setting3rdNetworkConfigConnectWifi sec:"+networkConfigPanel.currSecType);
        DBG_ERROR("setting3rdNetworkConfigConnectWifi auth:"+networkConfigPanel.currAuthType);
//        UI.base.cursor.alpha = 0.2;
//        setNetworkWifiListGrpAlpha(0.4);
//        setConnectStatusGrpAlpha(SHOW,LANGUAGE.Connecting,"setting/ic_loading1.png");
//        UI.updateStage();
        networkConfigSetWifiItemStatus(0);
/***** DBTAG20161011 MARK *****/
        if(tv){
            model.network.setEnumIp_config(0);
            model.network.setSsid(networkConfigPanel.currSSIDName);
            model.network.setEnumEncryption(parseInt(networkConfigPanel.currAuthType));
            model.network.setEncryptionPassphrase(networkConfigPanel.currPassword);
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_LINK_CHANGED, wifiLinkCallBack);//            model.network.WirelessSet(0,networkConfigPanel.currSSIDName,networkConfigPanel.currPassword,networkConfigPanel.currSecType,networkConfigPanel.currAuthType);
            model.network.WirelessSet();
/***** DBTAG--END *****/

            clearTimeout(networkConfigPanel.connectTimer);
            networkConfigPanel.connectTimer = setTimeout(connectWifiTimeout,25000);
        }else{
            clearTimeout(networkConfigPanel.connectTimer);
            networkConfigPanel.connectTimer = setTimeout(connectWifiTimeout,3000);
        }

    };
    function wifiLinkCallBack(LinkState){
        DBG_ERROR("wifiLinkCallBack:LinkState="+LinkState);

        switch (LinkState){
            case 1://applying setting
            case 2://connecting
            case 0:
                break;
            case 10:
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_LINK_CHANGED,wifiLinkCallBack);
                clearTimeout(networkConfigPanel.connectTimer);
                var networkAvailable = model.network.getEnumNetworkAvailable();
                DBG_ERROR("wizardWifiLinkChangeCallBack:networkAailable="+networkAvailable);
                networkConfigSetWifiItemStatus(2);
                showWifiConnectToast(SHOW,LANGUAGE.ConnectSuccess,"setting/ic_success.png");
                break;
            case 3://password error
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_LINK_CHANGED,wifiLinkCallBack);
//                model.network.WirelessCancel();
                clearTimeout(networkConfigPanel.connectTimer);
                networkConfigSetWifiItemStatus(1);
                showWifiConnectToast(SHOW,LANGUAGE.WrongPassword,"setting/wifi/ic_not_connected.png");
                break;
            default :
                clearTimeout(networkConfigPanel.connectTimer);
                networkConfigSetWifiItemStatus(1);
                showWifiConnectToast(SHOW,LANGUAGE.ConnectFail,"setting/ic_failure.png");
                break;
        }

    };

    function connectWifiTimeout(){
        DBG_INFO("connectWifiTimeout!!!!"+networkConfigPanel.connectIndex);
        var networkAvailable = tv ? model.network.getEnumNetworkAvailable() : 0;
        DBG_ERROR("connectWifiTimeout:networkAailable="+networkAvailable);
        if(networkAvailable == 1){
            networkConfigSetWifiItemStatus(2);
            showWifiConnectToast(SHOW,LANGUAGE.ConnectSuccess,"setting/ic_success.png");
        }else{
            UI.base.cursor.alpha = 1;
            if(tv) model.network.WirelessCancel();
            networkConfigSetWifiItemStatus(1);
            showWifiConnectToast(SHOW,LANGUAGE.ConnectFail,"setting/ic_failure.png");
            setConnectStatusGrpAlpha(HIDE,null,null);
        }
    };
    function setWifiConnPare(){
        try{
            networkConfigPanel.connWifiPara.SSID = networkConfigPanel.currSSIDName;
            networkConfigPanel.connWifiPara.secType = networkConfigPanel.currSecType;
            networkConfigPanel.connWifiPara.authType = networkConfigPanel.currAuthType;
            if(tv){
                networkConfigPanel.netAvailableFlag = model.network.getEnumNetworkAvailable();
            }
            var currSSID = tv?model.network.getSsid():"123";
            if(networkConfigPanel.netAvailableFlag == NetWorkConnect.CONNECT &&
                networkConfigPanel.currSSIDName == currSSID){
                if(networkConfigPanel.connWifiPara.connPassword == "")
                {
                    networkConfigPanel.connWifiPara.connPassword = model.network.getEncryptionPassphrase();
                    DBG_ERROR("connPassword:"+networkConfigPanel.connWifiPara.connPassword);
                }
            }else{
                networkConfigPanel.connWifiPara.connPassword = "";
            }
        }catch (ex){
            DBG_ERROR("getSettingNetSetWifiPageConnPare:"+ex.message);
        }
    };
    function setWifiCurrentPare(SSID,secType,authType,signal){
        DBG_ERROR("setWizardNetSetWifiSetPageConnPare:"+SSID+","+secType+","+authType+","+signal);
        networkConfigPanel.currSSIDName = SSID;
        networkConfigPanel.currSecType = secType;
        networkConfigPanel.currAuthType = authType;
        networkConfigPanel.currSignal = signal;

    };

    function startWifiScan(){
        DBG_ALWAYS("startWifiScan!!!!");
        if(tv){
            var currNetworkType = model.network.getEnumNetworking();
            if(currNetworkType == NetWorkType.OFF || NetWorkType.ETHER == currNetworkType){
                model.network.setEnumNetworking(NetWorkType.WIRELESS);
                model.network.setEnumIp_config(NetWorkIpConfig.DHCP);
                model.network.WirelessSet();
            }
            sendSearchWifiCmdToService();
            clearTimeout(networkConfigPanel.wifiApSearchTimer);
            networkConfigPanel.protected = true;
            networkConfigPanel.wifiApSearchTimer = setTimeout(searchWifiTimeout,15000);
        }else{
            getWifiResultList();
            networkConfigPanel.wifiApSearchTimer = setTimeout(showWifiList,3000);
        }
    };
    function sendSearchWifiCmdToService(){
        try{
            if(tv == false){
                networkConfigPanel.wifiSearState = 1;
            }else{
                var searchState = model.network.getEnumAccess_pointsSearch();/* 0:off,1:please wait,2:access points found,3:no access points found*/
                DBG_ERROR("sendSearchWifiCmdToService:"+searchState);
                if(searchState != 1){
                    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_ACCESS_POINTS_SEARCH_CHANGED, SearchWifiResultCallBack);
                    model.network.setEnumAccess_pointsSearch(1);
                }
                networkConfigPanel.wifiSearState = 1;
            }
        }catch (ex){
            DBG_ERROR("sendSearchWifiCmdToService"+ex.message);
        }
    };
    function SearchWifiResultCallBack(searchState){
        try{
//        var searchState = model.network.getEnumAccess_pointsSearch();
            DBG_ERROR("SearchWifiResultCallBack searchState="+searchState);
            UI.base.cursor.alpha = 1;
            switch (searchState){
                case 1://wait
                    networkConfigPanel.wifiSearState = 1;
                    break;
                case 2://accesspoint found
                    UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_ACCESS_POINTS_SEARCH_CHANGED,SearchWifiResultCallBack);
                    networkConfigPanel.wifiSearState = 2;
                    clearTimeout(networkConfigPanel.wifiApSearchTimer);
                    getWifiResultList();
                    showWifiList();
                    networkConfigPanel.protected = false;
                    break;
                case 3://not found
                    UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_ACCESS_POINTS_SEARCH_CHANGED,SearchWifiResultCallBack);
                    networkConfigPanel.wifiSearState = 3;
                    clearTimeout(networkConfigPanel.wifiApSearchTimer);
                    setNetworkWifiListGrpAlpha(HIDE);
                    UI.focusTo(networkConfigTypeBtn);
                    networkConfigPanel.currFocus = UI.getItem(networkConfigPanel, "networkConfigTypeBtn");
                    setConnectStatusGrpAlpha(SHOW,LANGUAGE.NoResult,"setting/ic_not_connected.png");
                    networkConfigPanel.protected = false;
                    break;
                default://other
                    UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_ACCESS_POINTS_SEARCH_CHANGED,SearchWifiResultCallBack);
                    networkConfigPanel.wifiSearState = 3;
                    clearTimeout(networkConfigPanel.wifiApSearchTimer);
                    setNetworkWifiListGrpAlpha(HIDE);
                    UI.focusTo(networkConfigTypeBtn);
                    networkConfigPanel.currFocus = UI.getItem(networkConfigPanel, "networkConfigTypeBtn");
                    setConnectStatusGrpAlpha(SHOW,LANGUAGE.NoResult,"setting/ic_not_connected.png");
                    networkConfigPanel.protected = false;
                    break;
            }
        }catch (ex){
            DBG_ERROR("SearchWifiResultCallBack:"+ex.message);
        }

    };
    function networkSortWifiList(){
        DBG_ALWAYS("setSettingNetSetWifiSetPageConnState:");
        if(tv == true){
            networkConfigPanel.netAvailableFlag = model.network.getEnumNetworkAvailable();
            DBG_ALWAYS("setSettingNetSetWifiSetPageConnState:netAvailable="+networkConfigPanel.netAvailableFlag);
            if(networkConfigPanel.netAvailableFlag == NetWorkConnect.CONNECT){
                var currSSID = model.network.getSsid();
                networkConfigPanel.connWifiPara.connSSID = currSSID;
                //networkConfigPanel.connWifiPara.connAuthType = model.network.getEnumAuthentication();
                networkConfigPanel.connWifiPara.connAuthType = model.network.getEnumEncryption();
                networkConfigPanel.connWifiPara.connSecType =  model.network.getEnumEncryption();
                networkConfigPanel.connWifiPara.connPassword = model.network.getEncryptionPassphrase();
            }
        }else{
            networkConfigPanel.netAvailableFlag = 0;
            var currSSID = networkConfigPanel.connWifiPara.connSSID;
        }
        if(networkConfigPanel.netAvailableFlag == NetWorkConnect.CONNECT){
            for(var i = 0; i < networkConfigPanel.WifiNum; i++){
                if(currSSID == networkConfigPanel.WifiList[i].wifiName){
                    var itemData = networkConfigPanel.WifiList[i];
                    networkConfigPanel.WifiList.splice(i,1);
                    networkConfigPanel.WifiList.unshift(itemData);
                    break;
                }
            }
            if(i == networkConfigPanel.WifiNum){
                //not in list, add network
                DBG_ALWAYS("setSettingNetSetWifiSetPageConnState:not found in list,may manual add");
                var itemData = {};
                itemData.wifiName = networkConfigPanel.connWifiPara.connSSID;
                itemData.wifiSecType = networkConfigPanel.connWifiPara.connSecType;
                itemData.wifiAuthType = networkConfigPanel.connWifiPara.connAuthType;
                if(tv){
                    itemData.wifiSignal =  model.network.getlink_signal_1();
                }else{
                    itemData.wifiSignal = 100;
                }
                if(networkConfigPanel.WifiList[0].wifiName == networkConfigPanel.manualAddSSID){
                    networkConfigPanel.manualAddSSID = itemData.connSSID;
                    networkConfigPanel.WifiList[0] = itemData;
                }else{
                    networkConfigPanel.manualAddSSID = itemData.connSSID;
                    networkConfigPanel.WifiList.unshift(itemData);
                }
            }
        }else{

        }
    }
    function addWifiToList(){
        for(var i = 0;i<networkConfigPanel.WifiList.length;i++){
            if(networkConfigPanel.currSSIDName == networkConfigPanel.WifiList[i].wifiName){
                var currSSID = networkConfigPanel.connWifiPara.connSSID;
                networkConfigPanel.netAvailableFlag = tv?model.network.getEnumNetworkAvailable():1;
                networkConfigPanel.currIdx = i;
                networkConfigPanel.connectIndex = i;
                var wifiFirstFocus = UI.getItem(wifiList,"wifiNameId"+networkConfigPanel.connectIndex);
                UI.focusTo(wifiFirstFocus);
                networkConfigPanel.currFocus = UI.getItem(wifiList,"wifiNameId"+networkConfigPanel.connectIndex);
                if(currSSID == networkConfigPanel.currSSIDName && networkConfigPanel.netAvailableFlag == NetWorkConnect.CONNECT){
                    return;
                }else{
                    startConnectWifi();
                    return;
                }
            }
        }
        var itemData = {};
        itemData.wifiName = networkConfigPanel.currSSIDName;
        itemData.wifiSecType =networkConfigPanel.currSecType;
        itemData.wifiAuthType = networkConfigPanel.currAuthType;
/***** DBTAG MARK *****/
        if(networkConfigPanel.openFromPwd == 2){
            itemData.wifiSignal = 100;
        }else{
            itemData.wifiSignal =  tv?model.network.getlink_signal_1():0;
        }
        DBG_INFO("itemData.wifiSignal: " + itemData.wifiSignal);
/***** DBTAG END *****/
        networkConfigPanel.WifiList.unshift(itemData);
//        data.operateData.manualAddSSID = itemData.wifiName;
        showWifiList();
        networkConfigPanel.currIdx = 0;
        networkConfigPanel.connectIndex = 0;
        startConnectWifi();
    }
    function showWifiList(){
        DBG_INFO("showWifiList!!!!");
        try{
            clearTimeout(networkConfigPanel.wifiApSearchTimer);
            networkConfigPanel.protected = false;
            UI.base.cursor.alpha = 1;
//            getWifiResultList();
//            networkSortWifiList();
            setConnectStatusGrpAlpha(HIDE,null,null);
            setNetworkWifiListGrpAlpha(SHOW);
            var array = [];
            for (var i=0; i < networkConfigPanel.WifiList.length; i++) {
                array.push({});
                array[i].name = "wifiNameId" + i;
                array[i].wifiItemImg = "setting/wifi/wifi_list.png";
                var level = getWifiSignalLevel(networkConfigPanel.WifiList[i].wifiSignal);
                if(networkConfigPanel.WifiList[i].wifiSecType != 0){
                    array[i].lockImg = "setting/wifi/wifi_"+level+"_lock_normal.png";
                }else{
                    array[i].lockImg = "setting/wifi/wifi_"+level+"_normal.png";
                }
                array[i].connectImg = "setting/wifiConnect.png";
                if(networkConfigPanel.netAvailableFlag == NetWorkConnect.CONNECT){
                    if(networkConfigPanel.WifiList[i].wifiName == networkConfigPanel.connWifiPara.connSSID){
//                        array[i].connectImg = "setting/wifiConnect.png";
                        networkConfigPanel.oldSelectedIndex = i;
                        networkConfigPanel.connectIndex = i;
                    }
                }
//                else{
//                    array[i].connectImg = "setting/blank.png";
//                }

                array[i].wifiApName = networkConfigPanel.WifiList[i].wifiName;
                array[i].wifiSecType = networkConfigPanel.wifiSecurityType[networkConfigPanel.WifiList[i].wifiSecType];
            }
            var info = {
                template: "wifi_item",
                direction: CONST.GIRD_DIRECTION.H,
                breakNum: 1,
                distanceX: 0,
                distanceY: 0,
                container: wifiList
            };
            wifiList.removeAllChildren(true);
            UI.resetViewPos(wifiList);
//            UI.removeScrollbar(wifiList);
            UI.removeView(wifiList);
            UI.removeMask(wifiList);
            Gird.create(array, info);
            UI.addMask(wifiList, 1150, 385, 40);
            UI.setView(wifiList, 1150, 390);
            if(networkConfigPanel.WifiList.length>6){
//                UI.addScrollbar(wifiList);
//                UI.remove(wifiList);
            }
            networkConfigPanel.wifiFirstFocus = UI.getItem(wifiList,"wifiNameId0");
            for(var i=0; i < networkConfigPanel.WifiList.length; i++){
                UI.getItem(wifiList,"wifiNameId"+i).children[0].isBg = true;
//                UI.getItem(wifiList,"wifiNameId"+i).isBg = true;
            }
            UI.focusTo(networkConfigPanel.wifiFirstFocus);
            DBG_ALWAYS("showWifiList:"+networkConfigPanel.connectIndex);
            if(networkConfigPanel.netAvailableFlag == NetWorkConnect.CONNECT){
                var  target = UI.getItem(wifiList,"wifiNameId"+networkConfigPanel.connectIndex);
                target.children[4].alpha = 1;
               // wifiList.children[networkConfigPanel.connectIndex].children[4].alpha = 1;
                UI.updateStage();
            }
            networkConfigPanel.currFocus = UI.getItem(wifiList,"wifiNameId0");

        }catch(e){
            DBG_ALWAYS("showWifiList catch"+e.stack);
        }
    };
    function getWifiResultList(){
        networkConfigPanel.WifiNum = 0;
        networkConfigPanel.currIdx = 0;
        networkConfigPanel.currBeginIdx = 0;
        networkConfigPanel.WifiList = [];
        networkConfigPanel.manualAddSSID = "";
        if(!tv){
            var itemData1 = {
                "wifiName":"~!\\x@#$%^&*()_+{}|:\"",
                "wifiSecType":15,
                "wifiAuthType":0,
                "wifiSignal":1
            }
            var itemData2 = {
                "wifiName":"1112",
                "wifiSecType":15,
                "wifiAuthType":0,
                "wifiSignal":100
            }
            var itemData3 = {
                "wifiName":"1113",
                "wifiSecType":0,
                "wifiAuthType":0,
                "wifiSignal":1
            }
            var itemData4 = {
                "wifiName":"11134",
                "wifiSecType":20,
                "wifiAuthType":0,
                "wifiSignal":1
            }
            var itemData5 = {
                "wifiName":"11145",
                "wifiSecType":1,
                "wifiAuthType":0,
                "wifiSignal":1
            }
            var itemData6 = {
                "wifiName":"11166",
                "wifiSecType":1,
                "wifiAuthType":0,
                "wifiSignal":1
            }
            networkConfigPanel.WifiList.push(itemData1);
            networkConfigPanel.WifiList.push(itemData2);
            networkConfigPanel.WifiList.push(itemData3);
            networkConfigPanel.WifiList.push(itemData4);
            networkConfigPanel.WifiList.push(itemData5);
            networkConfigPanel.WifiList.push(itemData6);
            networkConfigPanel.WifiList.push(itemData5);
//            networkConfigPanel.WifiList.push(itemData6);
            networkConfigPanel.WifiNum = networkConfigPanel.WifiList.length;
            return;
        }
        networkConfigPanel.netAvailableFlag = model.network.getEnumNetworkAvailable();
        networkConfigPanel.connWifiPara = {};
//        if(networkConfigPanel.netAvailableFlag == 1){
//            networkConfigPanel.connWifiPara.connSSID = model.network.getSsid();
//            networkConfigPanel.connWifiPara.connAuthType = model.network.getEnumAuthentication();
//            networkConfigPanel.connWifiPara.connSecType =  model.network.getEnumEncryption();
//            networkConfigPanel.connWifiPara.connPassword = model.network.getEncryptionPassphrase();
//        }
        var wifiSSIDArray = model.network.getAccess_pointsSsid();
        var autoSearchWifiNetNum = 0;

       if(wifiSSIDArray!=null && wifiSSIDArray.length>0){
            autoSearchWifiNetNum = wifiSSIDArray.length;
        }

        DBG_ERROR("settingInitNetSetWifiSetPage:SSIDArray="+JSON.stringify(wifiSSIDArray));

        if(autoSearchWifiNetNum > 0){
            var SSIDArray = [];
            var securityArray = [];
            var authArray = [];
            var signalArray = [];
            SSIDArray = wifiSSIDArray;
            authArray = model.network.getAccess_pointsEncrypted();
            signalArray = model.network.getAccess_pointsSignal();
            for(var i = 0; i < autoSearchWifiNetNum; i++){
                if(SSIDArray[i].length > 0){
                    var itemData = {
                        "wifiName":"",
                        "wifiSecType":1,
                        "wifiAuthType":0,
                        "wifiSignal":1
                    }
                    itemData.wifiName = SSIDArray[i];
//                    itemData.wifiSecType = securityArray[i];
                    itemData.wifiSecType = authArray[i];
                    itemData.wifiAuthType = authArray[i];
                    itemData.wifiSignal = signalArray[i];
                    DBG_ERROR("settingInitNetSetWifiSetPage:"+itemData.wifiName+","+itemData.wifiSecType+","+itemData.wifiAuthType+","+itemData.wifiSignal);
                    if(networkConfigPanel.netAvailableFlag == NetWorkConnect.CONNECT && networkConfigPanel.connWifiPara.connSSID == itemData.wifiName){
                        networkConfigPanel.WifiList.unshift(itemData);
                    }else{
                        networkConfigPanel.WifiList.push(itemData);
                    }
                }else{
                    DBG_ALWAYS("settingInitNetSetWifiSetPage:search num is 0");
                }
            }
            if(networkConfigPanel.netAvailableFlag == NetWorkConnect.CONNECT){
                networkConfigPanel.connWifiPara.connSSID = SSIDArray[0];
//                networkConfigPanel.connWifiPara.connAuthType = securityArray[0];
                networkConfigPanel.connWifiPara.connAuthType = authArray[0];
                networkConfigPanel.connWifiPara.connSecType =  authArray[0];
                networkConfigPanel.connWifiPara.connPassword = model.network.getEncryptionPassphrase();
            }
            networkConfigPanel.WifiNum = networkConfigPanel.WifiList.length;
            DBG_ERROR("settingInitNetSetWifiSetPage:networkConfigPanel.autoSearchWifiNetNum="+networkConfigPanel.WifiNum)
        }else{
            setConnectStatusGrpAlpha(SHOW,LANGUAGE.NoResult,"setting/ic_not_connected.png");
        }
    };

    function getWifiSignalLevel(signal){
        var level = 1;
        if(signal <= 25){
            level = 1;
        }else if(signal > 25 && signal <= 50){
            level = 2;
        }else if(signal > 50 && signal <= 75){
            level = 3;
        }else{
            level = 4;
        }
        return level;
    }
    function searchWifiTimeout(){
        try{
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_ACCESS_POINTS_SEARCH_CHANGED,SearchWifiResultCallBack);
            networkConfigPanel.wifiSearState = 3;
            UI.base.cursor.alpha = 0.1;
            if(tv == true){
                if(model.network.getEnumAccess_pointsSearch() == 1){
                    DBG_ERROR("searchWifiTimeout:searching!!");
                    model.network.setEnumAccess_pointsSearch(0);
                }
                var wifiSSIDArray = model.network.getAccess_pointsSsid();
                var autoSearchWifiNetNum = 0;

                if(wifiSSIDArray!=null && wifiSSIDArray.length >0){
                    autoSearchWifiNetNum = wifiSSIDArray.length;
                }
                DBG_ERROR("searchWifiTimeout:autoSearchWifiNetNum!!"+autoSearchWifiNetNum);
                if(autoSearchWifiNetNum>0){
                    getWifiResultList();
                    showWifiList();
                }else{
                    setNetworkWifiListGrpAlpha(HIDE);
                    UI.focusTo(networkConfigTypeBtn);
                    networkConfigPanel.currFocus = UI.getItem(networkConfigPanel, "networkConfigTypeBtn");
                    setConnectStatusGrpAlpha(SHOW,LANGUAGE.NoResult,"setting/ic_not_connected.png");
                }
            }else{
                setNetworkWifiListGrpAlpha(HIDE);
                UI.focusTo(networkConfigTypeBtn);
                networkConfigPanel.currFocus = UI.getItem(networkConfigPanel, "networkConfigTypeBtn");
                setConnectStatusGrpAlpha(SHOW,LANGUAGE.NoWirelessModule,"setting/ic_not_connected.png");
            }
            DBG_ERROR("searchWifiTimeout:cancel protected");
            networkConfigPanel.protected = false;
        }catch (ex){
            DBG_ERROR("searchWifiTimeout:"+ex.message);
            networkConfigPanel.protected = false;
        }

    };
    function networkConfigSetWifiItemStatus(edit){
        try{
            DBG_ERROR("networkConfigSetWifiItemStatus:"+edit);
            DBG_INFO("oldSelectedIndex:"+networkConfigPanel.oldSelectedIndex);
            DBG_INFO("connectIndex:"+networkConfigPanel.connectIndex);
            var oldIdx = networkConfigPanel.oldSelectedIndex;
            var idx = networkConfigPanel.connectIndex;
            var  target = UI.getItem(wifiList,"wifiNameId"+idx);
            var  oldTarget = UI.getItem(wifiList,"wifiNameId"+oldIdx);
            if(oldIdx != idx){
                createjs.Tween.removeTweens(oldTarget.children[1].children[0]);
                oldTarget.children[1].children[0].rotation = 0;
                var level = getWifiSignalLevel(networkConfigPanel.WifiList[oldIdx].wifiSignal);
                var lockImg = "";
                if(networkConfigPanel.WifiList[oldIdx].wifiSecType != 0){
                    lockImg = "setting/wifi/wifi_"+level+"_lock_normal.png";
                }else{
                    lockImg = "setting/wifi/wifi_"+level+"_normal.png";
                }
                UI.setImage(oldTarget.children[1],lockImg);
                oldTarget.children[4].alpha = 0;
            }else{
                target.children[4].alpha = 0;
            }
            if(edit == 0){
                UI.setImage(target.children[1],"setting/wifi/ic_loading_01.png");
                target.children[1].children[0].pivot.x = 24;
                target.children[1].children[0].pivot.y = 24;
                target.children[1].children[0].x = 24;
                target.children[1].children[0].y = 24;
                networkConfigPanel.isLoading = true;
                networkConfigPanel.showLoading = true;
                UI.getTween(target.children[1].children[0], true, true).to({rotation: target.children[1].children[0].rotation + Math.PI*2}, 3000);
            }else if(edit == 1 || edit == 2){
                if(edit == 1){
                    var level = getWifiSignalLevel(networkConfigPanel.WifiList[idx].wifiSignal);
                }else{
                    var currSignal = tv ? model.network.getlink_signal_1() : 0;
                    DBG_ERROR("networkConfigSetWifiItemStatus:"+currSignal);
                    var level = getWifiSignalLevel(currSignal);
                }
                if(networkConfigPanel.showLoading){
                    networkConfigPanel.showLoading = false;
                    //target.children[1].children[0].setBounds(0, 0, 48, 48);
//                    target.children[1].children[0].x = target.children[1].children[0].x - 24;
//                    target.children[1].children[0].y = target.children[1].children[0].y - 24;
                    target.children[1].children[0].pivot.x = 24;
                    target.children[1].children[0].pivot.y = 24;
                    target.children[1].children[0].x = 24;
                    target.children[1].children[0].y = 24;
                }
                var lockImg = "";
                if(networkConfigPanel.WifiList[idx].wifiSecType != 0){
                    lockImg = "setting/wifi/wifi_"+level+"_lock_normal.png";
                }else{
                    lockImg = "setting/wifi/wifi_"+level+"_normal.png";
                }
                UI.setImage(target.children[1],lockImg);
                createjs.Tween.removeTweens(target.children[1].children[0]);
                target.children[1].children[0].rotation = 0;

                if(edit == 2){
                    target.children[4].alpha = 1;
                }
                networkConfigPanel.isLoading = false;
                networkConfigPanel.showLoading = false;
                networkConfigPanel.oldSelectedIndex = networkConfigPanel.connectIndex;
            }
            UI.updateStage();
        }catch(e){
            DBG_ERROR("networkConfigSetWifiItemStatus:"+ e.message);
            UI.updateStage();
        }
    }
    networkConfigPanel.onPop = function(){
        DBG_ERROR("networkConfigPanel  onPop  !!!!!!!!!!!!!!!");
        showWifiConnectToast(HIDE,null,null);
        clearTimeout(networkConfigPanel.switchNetTimeout);
        clearTimeout(networkConfigPanel.showTimeout);
        clearTimeout(networkConfigPanel.wifiApSearchTimer);
        networkConfigPanel.protected = false;
        clearTimeout(networkConfigPanel.connectTimer);
        clearTimeout(networkConfigPanel.loadingTimeoutBig);
        networkConfigPanel.openFromPwd = 0;
        networkConfigPanel.isLoading = false;
        if(tv){
//            UI.registerKeyCodes(null);
            if(model.network.getEnumAccess_pointsSearch() == 1){
                DBG_ERROR("searchWifiTimeout:searching!!1111");
                model.network.setEnumAccess_pointsSearch(0);
                UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_ACCESS_POINTS_SEARCH_CHANGED,SearchWifiResultCallBack);
            }
            DBG_ERROR("searchWifiTimeout:searching!!");
            model.network.setEnumAccess_pointsSearch(0);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_LINK_CHANGED,wifiLinkCallBack);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_ACCESS_POINTS_SEARCH_CHANGED,SearchWifiResultCallBack);
//            model.network.WirelessCancel();
        }
        UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.NETWORK_CHANGED, onNetworkConfigStatusChanged);
    };
//    networkConfigPanel.onExit = function(){
//
//    };
    networkConfigPanel.onkey_BACKSPACE= function(){
        if(!!networkConfigPanel.param && networkConfigPanel.param.caller.toString()){
            if(networkConfigPanel.param.caller.toString() == "notificationToast"){
                UI.popAllModule();
                openLiveTVModule();
            }

        }else{
            return true;
        }
    }

};


