/**
 * Created by jiangbo1 on 2016/2/26.
 */

(function () {

    var menuChipData = {
        menuchip_bg: UI.window_bg,
        MCTitle: "Menu Function"
    };

    var template = Util.readJson("module/setting/appMenuChip.json");
    var appMenuChip = SubModule.create(menuChipData, template);

    var MCList = UI.getItem(appMenuChip, "MCList");
    var crntChips = [];
    var allChips = ["[SE0003]", "[SE0059]", "[SE0461]", "[SS0024]"];//PIC_MODE SND_MODE_ICON ASPECT_ICON SYSTEM_SETTING_ICON
    var imgList = [
        GLOBAL.IMAGE_LIST.PIC_MODE_ICON,
        GLOBAL.IMAGE_LIST.SND_MODE_ICON,
        GLOBAL.IMAGE_LIST.ASPECT_ICON,
        GLOBAL.IMAGE_LIST.SYSTEM_SETTING_ICON
    ];
    var crntChannel;
    function createMenuChipList() {


       crntChips = [APP_CHIPS.PIC_MODE, APP_CHIPS.SND_MODE, APP_CHIPS.ASPECT, APP_CHIPS.SYSTEM_SETTING];


        var gridInfo = {
            template: "chipTile",
            direction: CONST.GIRD_DIRECTION.H,
            breakNum: 1,
            distanceY: 6,
            distanceX: 0,
            container: MCList
        };
        var allArray = [];
        for (var i = 0; i < crntChips.length; i++) {
            allArray.push(
                {
                    chip_bg: UI.item_bg,
                    chipIcon: imgList[crntChips[i]],
                    chipText: allChips[crntChips[i]],
                    name: "CHIP" + crntChips[i]
                }
            )
        }
        //removeLiveTVShape(MCList);
        MCList.removeAllChildren();
        MCList.initSequence = [];
        Gird.create(allArray, gridInfo);
        UI.addMask(MCList, 480, 540, 20, 10);
        UI.setView(MCList, 480, 540);
    //    UI.addScrollbar(MCList);

        for (var i = 0; i < MCList.initSequence.length; i++) {
            MCList.initSequence[i].alpha = 0.6;
        }
        appMenuChip.currFocus = UI.getItem(MCList, "CHIP" + crntChips[0]);
    }

    appMenuChip.onFocus = function (focus) {
        DBG_ONXX("appMenuChip", "onFocus");
      //  liveTVTimeoutCallTTS(focus);
      //  onFocusLiveTVTarget(focus, 1.05, 500);
        return true;
    };

    appMenuChip.onNormal = function (focus) {
     //   UI.getTween(focus, true).to({scaleX: 1, scaleY: 1, alpha: 0.6}, 500, UI.ease.quartOut);
      //  UI.getTween(UI.base.cursor, true).to({scaleX: 1, scaleY: 1, alpha: 0}, 500, UI.ease.quartOut);
        return true;
    };
    appMenuChip.onPush = function () {
        createMenuChipList();
        UI.registerKeyCodes(null);
        UI.setKeyGroup(7);
    };
    appMenuChip.onPop = function(){
        DBG_ONXX("appMenuChip", "onPop");
      //  UI.getTween(UI.base.cursor, true).set({scaleX: 1, scaleY: 1, alpha: 0});
      //  UI.clearLiveTVMenuTimeout();
    }

    appMenuChip.onkey_ENTER = function (focus) {
        var ind = parseInt(focus.name.split("CHIP")[1]);
        switch (ind) {
            case APP_CHIPS.PIC_MODE:
                UI.popSubModule();
                DBG_INFO('CHIPS.PIC_MODE');
                UI.pushModule('setting');
                PictureConfig.picModeSign = PicSignDefine.PicModeSign.PIC_MODE;
                UI.pushSubModule("setting", "picMode", true,"appMenuChip");
                break;
            case APP_CHIPS.SND_MODE:
                UI.popSubModule();
                DBG_INFO('CHIPS.SND_MODE');
                UI.pushSubModule("setting", "AudioMode", true, "appMenuChip");
                break;
            case APP_CHIPS.ASPECT:
                UI.popSubModule();
                DBG_INFO('CHIPS.ASPECT');
                UI.pushModule('setting');
                PictureConfig.picModeSign = PicSignDefine.PicModeSign.PIC_ASPECT_RATIO;
                UI.pushSubModule("setting", "picMode", true, "appMenuChip");
                break;
            case APP_CHIPS.SYSTEM_SETTING:
                UI.popSubModule();
                DBG_INFO('CHIPS.SYSTEM_SETTING');
                UI.pushSubModule("setting", "mainPanel", true,"appMenuChip");
                break;
            default:
                DBG_ERROR("do not have this chip[" + ind + "].");
                break;
        }
    }

    appMenuChip.onkey_BACKSPACE=function(){
        UI.clearAllSubModule("setting");
        appControl.focusCurrentApp();
    }

})();