// Init
UI.moduleBuilder['setting']['accessibility_page'] =function() {


    var accessibilitypage_Data = {
        global_bg: UI.setting_bg,
        normal_bg: UI.btn_normal_bg,
        pic: "setting/" + GLOBAL.LAUNCHER_BRAND + "/ic_accessibility_154x154.png"
    };
    var template = Util.readJson("module/setting/accessibility_page.json");
    var accessibility_page = SubModule.create(accessibilitypage_Data, template);
    var helpInfoTxt = {
        Video_Description_group: '[SE3022]',//"Choose to leave the video description feature On or Off",
        Audio_Menu_Prompts_group: '[SE3023]',//"Choose to leave the Audio Menu Prompts On or Off",
        Audio_Menu_Prompts_Settings_group: '[SE3214]',//Adjust settings for the Menu Audio function.
        High_Contrast_Menu_group: '[SE3024]',//"Choose to leave the high contrast menu On or Off",
        Caption_Control_group: '[SE3025]',//"Choose to leave Closed Captioning On or Off",
        Closed_Caption_Settings_group: '[SE3026]'//"Adjust Closed Caption Settings to your preference."
    };
    var AccessibilityPageItemContent = {
        Video_Description_group: '[SE3027]',//"Video Description",
        Audio_Menu_Prompts_group: '[SE3028]',//"Menu Audio",
        Audio_Menu_Prompts_Settings_group: '[SE3029]',//'Menu Audio Settings',
        High_Contrast_Menu_group: '[SE3030]',//"High Contrast Menu",
        Caption_Control_group: '[SE0741]',//"Closed Caption",
        Closed_Caption_Settings_group: '[SE3032]',//"Closed Caption Settings"
    };
    //--translate var caption_control_array=["CC Off","CC On","CC on when mute"];---//
    var caption_control_array = ["[SE0832]", "[SE0831]", "[SE0833]"];
    var caption_control_arrayIndex = 0;
    var left_content_title = '[SE3021]';//["Accessibility"];
    //--------translate----------------//    ;
    var module_CCS = UI.getItem(accessibility_page, "Closed_Caption_Settings_group");
    var module_AudioMPS = UI.getItem(accessibility_page, "Audio_Menu_Prompts_Settings_group");
    var caption_control = UI.getItem(accessibility_page, "Caption_Control_group");
    var Group_array = ["Caption_Control_group", "Video_Description_group", "Audio_Menu_Prompts_group", 'Audio_Menu_Prompts_Settings_group', "High_Contrast_Menu_group", "Closed_Caption_Settings_group"];
    var Closed_Caption_Settings_text = UI.getItem(module_CCS, "group_name");
    var Audio_Menu_Prompts_Settings_text = UI.getItem(module_AudioMPS, "group_name");
    var curDisplayItems = [],curNotDisplayItemsContainer = [],sortByDisplayItemsContainer=[],sortByDisplayItems = [];
    var defaultFocus = caption_control;
    accessibility_page.currFocus = defaultFocus;

    accessibility_page.onShow = function () {
        accessibility_page.alpha = 1;
        var mainPanelStr = "mainPanel";
        if (UI.getCurrSubModule().caller == mainPanelStr) {
            if (UI.getSubModule(mainPanelStr)) {
                UI.getSubModule(mainPanelStr).alpha = 0;
            } else {
                DBG_ERROR('getSubModule(mainPanelStr) is null ');
            }

        }
        if(curDisplayItems.indexOf("Video_Description_group") > -1){

            initSwitchData(accessibility_page, "Video_Description_group", "pic_video");
        }

        if(curDisplayItems.indexOf("Audio_Menu_Prompts_group") > -1){

            initSwitchData(accessibility_page, "Audio_Menu_Prompts_group", "pic_audio");
        }

        if(curDisplayItems.indexOf("High_Contrast_Menu_group") > -1){

            initSwitchData(accessibility_page, "High_Contrast_Menu_group", "pic_high_contrast");
        }

        if(curDisplayItems.indexOf("Caption_Control_group") > -1){

            InitCaptionSelectData(get_dataSelectedFromBM, caption_control_DisableFunc);
        }

        if(curDisplayItems.indexOf("Audio_Menu_Prompts_group") > -1){

            audioMenuPromptsDisableOrNot();
        }

        initTitleContent();

        if (UI.isExistModule('launcher')) {
            UI.hideModule(launcher);
        }
    };

    accessibility_page.onExit = function () {
        accessibility_page.alpha = 0;
    }

    caption_control.onkey_ENTER = function () {
        UI.pushSubModule("setting", "CC", true, setting);
    }

    accessibility_page.onPush = function () {
        curDisplayItemHandler();
        accessibility_page.currFocus = defaultFocus;

    }
    accessibility_page.onPop=function(){
        if(UI.getCurrSubModule().caller && UI.getCurrSubModule().caller.name == "mainPanel"){
            UI.getCurrSubModule().caller.alpha=1;
        }
    }

    accessibility_page.onkey_BACKSPACE = function () {
        UI.popSubModule();
    }

    function curDisplayItemHandler(){
        var curItemArray=['Caption_Control_group','Video_Description_group','Audio_Menu_Prompts_group',
            'High_Contrast_Menu_group','Closed_Caption_Settings_group','Audio_Menu_Prompts_Settings_group'];
        curDisplayItems = [], curNotDisplayItemsContainer = [], sortByDisplayItems=[], sortByDisplayItemsContainer = [];

        if(GLOBAL.TUNER_AVAILIBALE){
            curDisplayItems.push(curItemArray[0]);
            curDisplayItems.push(curItemArray[1]);
            curDisplayItems.push(curItemArray[4]);

        }
        if(enableAudioMPS()){
            curDisplayItems.push(curItemArray[2]);
            curDisplayItems.push(curItemArray[5]);
        }
        curDisplayItems.push(curItemArray[3]);

        for(var i=0; i < curItemArray.length; i++){
            if(curDisplayItems.indexOf(curItemArray[i])>-1){
                sortByDisplayItemsContainer.push(UI.getItem(accessibility_page ,curItemArray[i]));
                sortByDisplayItems.push(curItemArray[i]);
            }else{
                curNotDisplayItemsContainer.push(UI.getItem(accessibility_page ,curItemArray[i]));
            }
        }
        if(!sortByDisplayItemsContainer.length){
            DBG_ERROR('sortByDisplayItemsContainer  is error:'+sortByDisplayItemsContainer);
        }
        defaultFocus=sortByDisplayItemsContainer[0];

        for(var i=0; i < curNotDisplayItemsContainer.length; i++){
            curNotDisplayItemsContainer[i].alpha = 0;
            curNotDisplayItemsContainer[i].downTo = '';
            curNotDisplayItemsContainer[i].upTo = '';
        }
        var initPositionY=sortByDisplayItemsContainer[0].getBounds().height/2;

        for(var i=0 ; i < sortByDisplayItemsContainer.length ;i++){
            sortByDisplayItemsContainer[i].alpha = 1;
            sortByDisplayItemsContainer[i].y = initPositionY +144*i;

            if(i == 0){
                sortByDisplayItemsContainer[i].upTo= '';
            }
            if (i < sortByDisplayItemsContainer.length-1){
                sortByDisplayItemsContainer[Math.min(i+1,sortByDisplayItemsContainer.length-1)].upTo=sortByDisplayItems[i];
            }
            if(i == sortByDisplayItemsContainer.length-1){
                sortByDisplayItemsContainer[i].downTo = ''
            }else{
                sortByDisplayItemsContainer[i].downTo = sortByDisplayItems[Math.min(i+1,sortByDisplayItemsContainer.length-1)];
            }
        }
    }

    function initTitleContent() {
        try {
            for (var i = 0; i < Group_array.length; i++) {
                var TitleContent = UI.getItem(UI.getItem(accessibility_page, Group_array[i]), "group_name");
                UI.setText(TitleContent, AccessibilityPageItemContent[Group_array[i]]);
            }
        } catch ( ex ) {
            DBG_ERROR(ex.message)
        }
    }

    function enableAudioMPS(){
        return (GLOBAL.CURRENT_COUNTRY == 'CAN' ? false :true)
    }

    function audioMenuPromptsDisableOrNot() {

        var flag = tv ? model.tts.getI32SwitchStatus() : 0;
        Audio_Menu_PromptsDisableFunc(flag);
    }

    function InitCaptionSelectData( SetSelectDataFunc, callback ) {

        var selectBar = UI.getItem(accessibility_page, "Caption_Control_group");
        var selectComp = UI.getItem(selectBar, "text_CC");
        if (SetSelectDataFunc) {
            selectComp.selected = SetSelectDataFunc();
            var index = selectComp.values.indexOf(selectComp.selected);
            caption_control_arrayIndex = index;
            UI.setText(selectComp, SetSelectDataFunc());
        }
        if (callback) {
            callback()
        }

    }

    function get_dataSelectedFromBM() {
        var SetCcValue = null;
        try {
            SetCcValue = tv ? caption_control_array[model.closedcaption.getControl()] : caption_control_array[0];
            DBG_INFO('get_dataSelectedFromBM:' + SetCcValue);
        } catch ( ex ) {
            DBG_ERROR("get_dataSelected is error" + ex.message)
        }
        return SetCcValue;
    }

    function caption_control_DisableFunc() {
        if (0 == caption_control_arrayIndex) {
            Disable_common(accessibility_page, ["Closed_Caption_Settings_group"], true);
        }
        else {
            Disable_common(accessibility_page, ["Closed_Caption_Settings_group"], false);
        }
    }

    function getCurrFocusName() {
        return UI.getCurrFocus().name;
    }

    function setHelpInfo() {
        try {
            //var helpInfoTitle=UI.getItem(accessibility_page,"content_title");
            var helpInfoContent = UI.getItem(accessibility_page, "left_content");
            //var tempMod=UI.getItem(UI.getCurrModule().currFocus,"group_name");
            //UI.setText(helpInfoTitle,tempMod.children[0].text);
            UI.setText(helpInfoContent, helpInfoTxt[getCurrFocusName()]);
        } catch ( ex ) {
            DBG_ERROR("setHelpinfo is error:" + ex.message)
        }
    }

    function sendDataToBm( index ) {
        try {
            DBG_INFO('sendDataToBm:' + index);
            tv ? model.closedcaption.setControl(index) : 1;
        } catch ( ex ) {
            DBG_ERROR(ex.message);
        }
    }

    function Switchbar_common( submodule, groupname, pic_switch_name, txt_switch_name ) {
        try {
            var switchBar = UI.getItem(submodule, groupname);
            var switchBarText = UI.getItem(switchBar, txt_switch_name);
            var switchComp = UI.getItem(switchBar, pic_switch_name);
            Switch.create(switchComp, true);

            switchBar.onFocus = function () {
                setHelpInfo();
                switchComp.onFocus();
                UI.setTextColor(switchBarText, "rgba(255,255,255,1)");
                UI.updateStage();
                return true;
            };
            switchBar.onNormal = function () {
                switchComp.onNormal();
                return true;
            };
            switchBar.onkey_LEFT = switchBar.onkey_RIGHT =
                switchBar.onkey_ENTER = function ( focus ) {
                    switch (groupname) {
                        case "Video_Description_group":
                            switchComp.switch();
                            VideoDescriptionEnterHandler(switchComp.flag);
                            break;
                        case "Audio_Menu_Prompts_group":
                            AudioPromptsEnterHandler(switchComp.flag);
                            switchComp.switch();
                            break;
                        case "High_Contrast_Menu_group":
                            switchComp.switch();
                            HighControlEnterHandler(switchComp.flag);
                            if (switchComp.flag) {
                                UI.base.toHiContrast(focus);
                            } else {
                                UI.base.toNormalContrast(focus);
                            }
                            break;
                        default:
                            break;
                    }
                };
            UI.updateStage();
        }
        catch ( ex ) {
            DBG_ERROR("Switchbar_common func is error" + ex.message);
        }
    }

    function Selectbar_common( submodule, group_name, title_select_txt, content_select_txt, item_value_arrary, callback, SetSelectDataFunc ) {
        try {
            var selectBar = UI.getItem(submodule, group_name);
            var selectBarText = UI.getItem(selectBar, title_select_txt);
            var selectComp = UI.getItem(selectBar, content_select_txt);
            Select.create(selectComp, item_value_arrary);
            if (SetSelectDataFunc) {
                selectComp.selected = SetSelectDataFunc();
                var index = selectComp.values.indexOf(selectComp.selected);
                caption_control_arrayIndex = index;
                UI.setText(selectComp, SetSelectDataFunc())
                //selectComp.children[0].text=SetSelectDataFunc();
                //selectBar.updateCache();
                UI.updateStage();
            }
            if (callback) {
                callback()
            }
            var index = selectComp.values.indexOf(selectComp.selected);
            Audio_Menu_PromptsDisableFunc(index);
            selectBar.onFocus = function () {
                setHelpInfo();
                UI.updateStage();
                return true;
            };
            selectBar.onNormal = function () {
                return true;
            };
            selectBar.onkey_RIGHT = function () {
                selectComp.selectNext();
                var index = selectComp.values.indexOf(selectComp.selected);
                caption_control_arrayIndex = index;
                sendDataToBm(index);
                if (callback) callback();//handle the key_right
            };
            selectBar.onkey_LEFT = function () {
                selectComp.selectPrev();
                var index = selectComp.values.indexOf(selectComp.selected);
                caption_control_arrayIndex = index;
                sendDataToBm(index);
                if (callback)callback();//handle the key_left
            };
        }
        catch ( ex ) {
            DBG_ERROR("Selectbar_common func is error" + ex.message);
        }
    }

    function AudioPromptsEnterHandler( flag ) {
        var type = flag == true ? 0 : 1;
        Audio_Menu_PromptsDisableFunc(type);
        DBG_INFO("Audio type:" + type);
        setTTSSwitch(type);
    }

    function Audio_Menu_PromptsDisableFunc( flag ) {
        if (parseInt(flag) == 0) {
            Disable_common(accessibility_page, ["Audio_Menu_Prompts_Settings_group"], true);
        } else {
            Disable_common(accessibility_page, ["Audio_Menu_Prompts_Settings_group"], false);
        }
    }

    function VideoDescriptionEnterHandler( flag ) {
        var type = flag == true ? 1 : 0;
        setVideoDescription(type);
    }

    function initialize(){
        try {
            var set_left_content_title = UI.getItem(UI.getItem(accessibility_page, "Group_left"), "content_title");
            UI.setText(set_left_content_title, left_content_title);

            module_CCS.onkey_ENTER = function () {
                UI.lastPopedSub = accessibility_page;
                UI.pushSubModule("setting", "accessibilityDetail", true, "accessibility_page");
                accessibility_page.alpha = 0;
            };
            module_CCS.onFocus = function () {
                setHelpInfo();
                UI.setTextColor(Closed_Caption_Settings_text, "#FFFFFF");
                UI.updateStage();
                return true;
            };
            module_CCS.onNormal = function () {
                return true;
            };

             module_AudioMPS.onkey_ENTER = function () {
                UI.pushSubModule("setting", "AudioMenuPromptsSetting", true);
                accessibility_page.alpha = 0;
            };
            module_AudioMPS.onFocus = function () {
                setHelpInfo();
                UI.setTextColor(Audio_Menu_Prompts_Settings_text, "#FFFFFF");
                UI.updateStage();
                return true;
            };
            module_AudioMPS.onNormal = function () {
                return true;
            };

            Switchbar_common(accessibility_page, "Video_Description_group", "pic_video", "group_name");
            Switchbar_common(accessibility_page, "Audio_Menu_Prompts_group", "pic_audio", "group_name");
            Switchbar_common(accessibility_page, "High_Contrast_Menu_group", "pic_high_contrast", "group_name");
            Selectbar_common(accessibility_page, "Caption_Control_group", "group_name", "text_CC", caption_control_array, caption_control_DisableFunc, get_dataSelectedFromBM);

        } catch ( ex ) {
            DBG_ERROR(ex.stack);
        }
    }

    initialize();

}
