/**
 * Created by jiaguili on 16-3-8.
 */
UI.moduleBuilder['setting']['SettingSysToast'] = function(){

    var initData = {
        "SettingSysToastBgImg" : "toast/Toast_bg2.png",
        "SettingSysToastImg":"setting/wifi/ic_not_connected.png",
        "SettingSysToastText":"failure"
    };
    var operateData = {
        "datatype": 0,
        "datalist": [
            {

                "id":TOASTTYPE.PWDCHECK,
                "content": "[SE0836]"//"Invalid password. Please re-enter"

            },
            {
                "id":TOASTTYPE.INPUTCHECK,
                "content": "[OT0007]"//"Input value is invalid, please try again!"


            },
            {
                "id":TOASTTYPE.TVNAMETIP,
                "content":"[OT0034]"// "The customized device name requires restart to take effect."

            },
            {
                "id":TOASTTYPE.VCHIPTIP,
                "content":"[SE0719]"//"The current channel does not have Open V-chip data."
            },
            {
                "id":TOASTTYPE.UNAVIALIBLETIP,
                "content":"[OT0006]"//"This feature is currently unavailable!"
            },
            {
                "id":TOASTTYPE.CHAGPWDTIP,
                "content":"[SE0728]"//"The new PIN number is not correct, still use the original PIN number."
            },
            {
                "id":TOASTTYPE.SCANCHLTIP,
                "content":"[OT0031]"//"No channel information. Please scan channels."
            },
            {
                "id":TOASTTYPE.ADDCHLTIP,
                "content":"[TV0145]"//"You've already added this channel."
            },
            {
                "id":TOASTTYPE.FEATRUETIP,
                "content":"[SE1679]" // "Feature not available",
            },
            {
                "id":TOASTTYPE.SUBTITLETIP,
                "content":"[SE0444]"//No Subtitle
            },
            {
                "id":TOASTTYPE.TELETEXTTIP,
                "content":"[SE2500]"//"No Teletext"
            },
            {
                "id":TOASTTYPE.READCHLTIP,
                "content":"[TV0121]"//"Reading the channel list. Please try again later",
            },
            {
                "id":TOASTTYPE.MEMCTIP,
                "content":"Not support memc"
            },
            {
                "id":TOASTTYPE.UPDATESUCESSTIP,
                "content":"[SE3274]" //Success to update
            },
            {
                "id":TOASTTYPE.NOUSBTIP,
                "content":"[SE3275]"//No USB device detected
            },
            {
                "id":TOASTTYPE.NOVODEPTIP,
                "content":"[SE3276]"// No update file found
            },
            {
                "id":TOASTTYPE.VEDIOLATGETIP,
                "content":"[SE3277]" //File size is too big to update
            },
            {
                "id":TOASTTYPE.SYSERRORTIP,
                "content":"[SE3278]" //System error
            },
	        {
                "id":TOASTTYPE.WAKEBYLANTIP,
                "content":"[SE3249]"//Wake on LAN and Wake on WLAN has been turned on.
            },
            {
                "id":TOASTTYPE.CHNL_NOT_FOUND,
                "content":"[SE2003]"//"Channel not found."
            },
            {
                "id":TOASTTYPE.MHL_CONNECT,
                "content":"[SE3247]"//"Mobile device connected via MHL."
            },
 			{
                "id":TOASTTYPE.AUDIO_LANGUAGE_TIP,
                "content":"No Audio Language"//"No audio language"
            },
            {
                "id":TOASTTYPE.PROGRAM_UNAVAIABLE,
                "content":"Programme not available."
            },
            {
                "id":TOASTTYPE.CHANNEL_ISEMPTY,
                "content":"Selected channel list is empty."
            },
            {
                "id":TOASTTYPE.CHANNEL_NOTFOUND,
                "content":"Channel not found."
            },
            {
                "id":TOASTTYPE.PLAYER_NOTFOUND,
                "content":"Player not found."
            },
            {
                "id":TOASTTYPE.RECORDLIST_NOTFOUND,
                "content":"[SE0378]"
            },
            {
                "id":TOASTTYPE.DATEINPUT_INVALID,
                "content":"[OT0403]"
            },
            {
                "id":TOASTTYPE.REMOVE_HDD,
                "content":"[OT0419]"
            },
            {
                "id":TOASTTYPE.APP_START_SYSLOADING_TIP,
                "content":"[SE3409]"
            },
            {
                "id":TOASTTYPE.STORE_MODE_MALL_LOGO_SUCCESS,
                "content":"[SE3731]"//The mall logo has been uploaded successfully.
            },
            {
                "id":TOASTTYPE.STORE_MODE_NO_USB_TIP,
                "content": "[SE3699]"//No USB device is found. Make sure your device is connected.
            },
            {
                "id":TOASTTYPE.STOREMODE_NOVODEPTIP,
                "content": "No upgrade package detected."
            },
            {
                "id":TOASTTYPE.BLUETOOTH_REMOTE_UNPAIRED,
                "content": "Bluetooth remote control unpaired."
            },
            {
                "id":TOASTTYPE.BLUETOOTH_REMOTE_DISCONNECT,
                "content": "Bluetooth remote control disconnect."
            }

        ]

    }
    var template = Util.readJson("module/setting/SettingSysToast.json");
    var SettingSysToast = SubModule.create(initData, template);
    var SettingSysToastText=UI.getItem(SettingSysToast,"SettingSysToastText");
    var SettingSysToastBgImg=UI.getItem(SettingSysToast,"SettingSysToastBgImg");
    SettingSysToast.operateData=operateData;
    SettingSysToast.operateData.timer=null;
    SettingSysToastBgImg.doFlip=true;
    SettingSysToast.onPush = function () {
        if (!!SettingSysToast && !!SettingSysToast.param && (typeof SettingSysToast.param) == "string") {
            UI.setText(SettingSysToastText, SettingSysToast.param);
            UI.callTTS(SettingSysToast.param);
        }
        else {
            var index = _getIndexById(SettingSysToast.operateData.datalist, GLOBAL.CURRENT_TOAST_TYPE);
            if (index < 0) {
                index = 0;
                DBG_ERROR("THE INDEX ERROR");
            }
            UI.setText(SettingSysToastText, SettingSysToast.operateData.datalist[index].content);
           if(GLOBAL.CURRENT_TOAST_TYPE==TOASTTYPE.DATEINPUT_INVALID)
           {
               UI.callTTS(SettingSysToast.operateData.datalist[index].content,0,false,false);

           }
            else {
               UI.callTTS(SettingSysToast.operateData.datalist[index].content);

           }

        }
        UI.getTween(UI).wait(1500);
//        var bound=SettingSysToastText.children[0].getBounds();
//        if(bound.height<89)
//        {
//            SettingSysToastText.y=115+(111-bound.height)/2;
//        }
//        else{
//            SettingSysToastText.y=115.5;
//        }
        setTimeout(function(){
           UI.popGhostModule("SettingSysToast");
        },3000);
    }
    SettingSysToast.onPop=function(){
    }
};