/**
 * Created by jiaguili on 16-1-29.
 */
UI.moduleBuilder['setting']['SettingSysSoundTest'] = function () {

    var initData = {
        "title": "[SE3595]",// "Upgrade",
        //"text1": "Test Failed",
        "text2": "[SE3716]",//"Please listen to the sound section carefully.Can you still hear the problem in this sound test?",
        //"text3": "Speaker: TV Speaker",
        //"text4": "Volume: [Default volume]",
        "btn1text": "[TV0086]",//""Next time",
        "btn2text": "[TV0087]",//""Next time",//
        "btn3text": "[SE3717]",//"Play again",//
        "pencentimg": "setting/sys/pic_music.png",
        "sheetImg1": UI['bg_overlay'],
        "bgImg1": UI.window_bg,
        "btn1bgImg": UI.item_bg,
        "btn2bgImg": UI.item_bg,
        "btn3bgImg": UI.item_bg
    };
    var operateData = {
        "datatype": 0,
        "isback": false,
        "currPercent": 0,
        "curTimeLong": 0,
        "musicCurrentTime": 0,
        "volume": 20,
        "speakMode": 0,
        "playCount":0,

    }
    var template = Util.readJson("module/setting/SettingSysSoundTest.json");
    var SettingSysSoundTest = SubModule.create(initData, template);
    SettingSysSoundTest.currFocus = UI.getItem(SettingSysSoundTest, "btn2");
    SettingSysSoundTest.operateData = operateData;
    var btn1 = UI.getItem(SettingSysSoundTest, "btn1");
    var btn2 = UI.getItem(SettingSysSoundTest, "btn2");
    var btn3 = UI.getItem(SettingSysSoundTest, "btn3");
    var title = UI.getItem(SettingSysSoundTest, "title");
    var text3 = UI.getItem(SettingSysSoundTest, "text3");
    var text4 = UI.getItem(SettingSysSoundTest, "text4");
    var contentinfo = UI.getItem(SettingSysSoundTest, "text2");
    var pencentimg1 = UI.getItem(SettingSysSoundTest, "pencentimg1");
    //  contentinfo.children[0].lineHeight = 50;
    contentinfo.children[0].lineWidth = 820;
    SettingSysSoundTest.noAutoClose = true;
    LabelValue.create(text3, "[SE0072]", "36px SourceSansPro-Light", 0xFFFFFF);//Speaker
    LabelValue.create(text4, "[SE1929]", "36px SourceSansPro-Light", 0xFFFFFF);
    var CirclePercent = function (target, percent, min, max) {

        target.percent = percent;
        target.max = max;
        target.redraw = function (g) {
            g.currentPath = false;
            g.clear();
            if(GLOBAL.UI_BRAND == "his" || GLOBAL.UI_BRAND == "Hisense"){
                g.lineStyle(9, 0x05a5bd, 1);
            }
            else {
                g.lineStyle(9, 0xbb2071, 1);
            }
            if (!GLOBAL.RTL) {
                g.arc(90, 90, 74, Math.PI * 3 / 2, Math.PI * 3 / 2 + Math.PI * 2 * (target.percent / 100), false);
            }
            else {
                g.arc(90, 90, 74, Math.PI * 3 / 2 - 2 * Math.PI, Math.PI * 3 / 2 + Math.PI * 2 * (target.percent / 100), true);
            }
        };
        target.removeAllChildren();
        var shape = new PIXI.Graphics();
        target.addChild(shape);
        target.redraw(shape);
        //txt.children[0].text = percent;
        UI.updateStage();

        target.setPercent = function (percent) {
            target.percent = percent;
            this.redraw(shape);
            //txt.children[0].text = percent;
            UI.updateStage();
        };
        target.setMax = function (max) {
            target.max = max;
            this.redraw(shape);
            UI.updateStage();
        }
    };

    SettingSysSoundTest.onPush = function () {
        UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.VOLUME_CHANGED, onVolumeChanged);
        SettingSysSoundTest.operateData.playCount=0;
        try {

            SettingSysSoundTest.operateData.speakMode = tv ? model.sound.getSpeakerArc() : 0;
            SettingSysSoundTest.operateData.volume = model.sound.getMainVolume();
            model.sound.setSpeakerArc(1);
            model.sound.setMainVolume(20);
            model.sound.setMainMute(0);
            DBG_ERROR("speakMode" + SettingSysSoundTest.operateData.speakMode);
            DBG_ERROR("volume" + SettingSysSoundTest.operateData.volume);
        } catch (ex) {
            DBG_ERROR(ex.message);
        }
        text3.setValue( "[SE2751]");
        text4.setValue( "20");
        CirclePercent(pencentimg1, 0, 100);
        pencentimg1.setPercent(operateData.currPercent);
        SettingSysSoundTest.currFocus = UI.getItem(SettingSysSoundTest, "btn1");
        startToPlayMusic();
    }
    function startToPlayMusic() {
        try {
            var musicPath =  "file:///opt/hisenseUI/html/hisenseUI/module/FTE/wizard_bg.mp3";
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_STATE_CHANGED, onMpCtrlStatchanged);
            UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_CURRENT_TIME_CHANGED, onMPlaytimeChanged);

            //model.mpctrl.onMpCtrlStatchanged = onMpCtrlStatchanged;//listening state
            //model.mpctrl.onMpCtrlPlaytimeCurrentchanged = onMPlaytimeChanged;//progress
            pauseDTV();
            setTimeout(function () {
                model.mpctrl.PlayMedia(musicPath, null, null, null, null, null, 8, null, null, null);
            }, 1000);
        } catch (ex) {
            DBG_ERROR("[onMPlaytimeChanged]" + ex.message);
        }
    }

    function onMpCtrlStatchanged(value) {

        var nState = parseInt(value[2]);
        DBG_ERROR("onMpCtrlStatchanged " + nState);
        switch(nState){
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PLAYING:
                break;
            case  MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PAUSE:
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PREPARED:
                if( SettingSysSoundTest.operateData.playCount==0) {
                try {
                    model.mpctrl.MpCtrl(1);
                        SettingSysSoundTest.operateData.playCount = 1;
                } catch (ex) {
                    DBG_ERROR(ex.message);
                }
                operateData.curTimeLong =model.mpctrl.getMpCtrlPlaytimeTotal();
                    DBG_INFO("operateData.curTimeLong"+operateData.curTimeLong)
                }
                else {
                    DBG_INFO("discard the state")
                }
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_AUTO_STOP:
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PLAY_DONE:
                DBG_INFO("play video done");
                break;
            case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_AUDIO_UNPLAYABLE:
            case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_VIDEO_UNPLAYABLE:
            case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_NOT_SUPPORT_FILE:
            case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_MEDIA_LOST:
                break;
            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_SEEK_DONE:
                break;
            default:
                break;
        }
//        DBG_INFO(" status changed " + value);
//        switch (value) {
//            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_IDLE:
//                break;
//            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PREPARING:
//                break;
//            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PREPARED:
//                break;
//            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PLAYING:
//                break;
//            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PAUSE:
//                break;
//            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_STOP:
//                break;
//            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_RELEASING:
//                DBG_INFO("play video releasing");
//
//                break;
//            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PREPARE_DONE:
//                try {
//                    DBG_INFO("fte play music now");
//                    model.mpctrl.PlayNow();
//                }
//                catch (ex) {
//                    DBG_INFO(" onMpCtrlStatchanged: " + ex.message);
//                }
//                break;
//            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_AUTO_STOP:
////                try{
//////                    model.mpctrl.StopMpctrl(null);//�Զ�ֹͣ���������ֹͣ�ӿ�
////                    DBG_INFO("play music auto stop and repeat play");
////                    setTimeout(function () {
////                        var musicPath = "file:///3rd_rw/UI/module/FTE/wizard_bg.mp3";
////                        model.mpctrl.PlayMusic(musicPath);
////                    }, 200);
////                }catch(ex){
////                    DBG_INFO("fte onMpCtrlStatchanged: " + ex.message);
////                }
//                break;
//            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_STATE_PLAY_DONE:
//                DBG_INFO("play video done");
//                operateData.curTimeLong = model.mpctrl.getMpCtrlPlaytimeTotal();
//                //todo ����ȡ��loadingȦ
//                break;
//            case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_AUDIO_UNPLAYABLE:
//            case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_VIDEO_UNPLAYABLE:
//            case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_NOT_SUPPORT_FILE:
//            case MpCtrlModelDefines.HS_PLAYER_PLAY_ERROR_MEDIA_LOST:
//                break;
//            case MpCtrlModelDefines.SL2_TVAPI_I32_MPCTRL_ENUM_SEEK_DONE:
//                break;
//            default:
//                break;
//        }
    }

    function onMPlaytimeChanged(value) {
        try {
            DBG_INFO("onMPlaytimeChanged:" + value);
            operateData.musicCurrentTime = value;

            pencentimg1.setPercent(operateData.musicCurrentTime * 100 / operateData.curTimeLong);
        } catch (ex) {
            DBG_ERROR("[onMPlaytimeChanged]" + ex.message);
        }


    }

    SettingSysSoundTest.onPop = function () {
        try {
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_STATE_CHANGED, onMpCtrlStatchanged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.MPCTRL_CURRENT_TIME_CHANGED, onMPlaytimeChanged);
            UIObserver.unsubscribeMessage(UIObserver.MESSAGE_NAME.VOLUME_CHANGED, onVolumeChanged);
            model.mpctrl.MpCtrl(3);
            model.sound.setSpeakerArc(SettingSysSoundTest.operateData.speakMode);
            model.sound.setMainVolume(SettingSysSoundTest.operateData.volume);
            SettingSysSoundTest.operateData.playCount=0;

            resumeDTV();
        } catch (ex) {
            DBG_ERROR( ex.message);
        }
    }

   function onVolumeChanged(value){
       DBG_ERROR("onVolumeChanged"+value);
       text4.setValue(value);

   }
    btn1.onkey_ENTER = function () {
        UI.popSubModule();
        setting.sysdata.curDiagnosisType = 1;
        UI.pushSubModule("setting", "SettingSysPicTestFail", true);
    }
    btn2.onkey_ENTER = function () {
        UI.popSubModule();
        setting.sysdata.curDiagnosisType = 1;
        UI.pushSubModule("setting", "SettingSysPicTestOk", true);
    }
    btn3.onkey_ENTER = function () {
        try {
            pencentimg1.setPercent(0);
            SettingSysSoundTest.operateData.playCount=0;
            var musicPath = "file:///opt/hisenseUI/html/hisenseUI/module/FTE/wizard_bg.mp3";
            model.mpctrl.PlayMedia(musicPath, null, null, null, null, null, 8, null, null, null);
        } catch (ex) {
            DBG_ERROR( ex.message);
        }
        //todo restart the music
    }
    SettingSysSoundTest.onkey_BACKSPACE = function () {
        UI.popSubModule();
    }
};