UI.moduleBuilder['setting']['LayoutToast'] = function(){

    var LayoutToastData = {
        LayoutBg:"setting/bg_pad.png",
        LayoutPlayBtn:"setting/bt_core_normal.png",
        RewindBtn:"setting/bt_rewind_normal.png",
        FastForwardBtn:"setting/bt_fastforward_normal.png",
        EndBtn:"setting/bt_end_normal.png"
    };
    var template = Util.readJson("module/setting/LayoutToast.json");
    var LayoutToast = SubModule.create(LayoutToastData, template);
    var LayoutPlayBtn = UI.getItem(LayoutToast, "LayoutPlayBtn");
    var FastForwardBtn = UI.getItem(LayoutToast, "FastForwardBtn");
    var RewindBtn = UI.getItem(LayoutToast, "RewindBtn");
    var EndBtn = UI.getItem(LayoutToast, "EndBtn");
    var Current_btn = LayoutPlayBtn;
    var LayoutBg = UI.getItem(LayoutToast, "LayoutBg");
    var pause_flag = false;
    var keyState = 0;
    UIObserver.subscribeMessage(UIObserver.MESSAGE_NAME.KEY_RELEASE, SendDfbKey);
    function SendDfbKey(){
        DBG_ERROR("6666666666666");
        DBG_ERROR("keyState is :" + keyState);
        if(Current_btn){
            if(keyState == 1){
                UI.send_key_to_dfb(guijs.SYSCMD_FAST_BKW);
            }else if(keyState == 2){
                UI.send_key_to_dfb(guijs.SYSCMD_FAST_FWD);
            }else if(keyState == 3){
                try{
                    UI.popGhostModule("LayoutToast");
                    APPMODULE.LayoutToast = null;
                }catch(e){
                    DBG_ERROR(e.message)
                }
                UI.send_key_to_dfb(guijs.SYSCMD_STOP);
            }else if(keyState == 4){
                UI.send_key_to_dfb(guijs.SYSCMD_PLAY);
            }else if(keyState == 5){
                UI.send_key_to_dfb(guijs.SYSCMD_PAUSE);
            }
        }
        keyState = 0;
    }
    LayoutToast.onPush = function () {
        UI.setImage(LayoutBg,"setting/bg_pad.png");
        UI.setImage(LayoutPlayBtn,"setting/bt_core_normal.png");
        UI.setImage(RewindBtn, "setting/bt_rewind_normal.png");
        UI.setImage(FastForwardBtn, "setting/bt_fastforward_normal.png");
        UI.setImage(EndBtn, "setting/bt_end_normal.png");
        UI.popGhostModule("KeypadToast");
        APPMODULE.KpadToast = null;
        if(GLOBAL.TTS){
            UI.callTTS("play");
        }
        UI.updateStage();
        if(checkIsAppOn()&& UI.getCurrModule().name=="base"){
            DBG_INFO("checkIsAppOn is right and currmodule name is:" + UI.getCurrModule().name);
            registerKeyCodesForKeypad();
        }
        UI.setPlayPadTimeout(autoExitPlayPad, 15 * 1000);
    };

    LayoutToast.onPop = function () {
        if(checkIsAppOn()&& UI.getCurrModule().name=="base"){
            registerKeyCodesForApp();
        }
        keyState = 0;
        UI.clearPlayPadTimeout();
    };

    function autoExitPlayPad(){
        APPMODULE.LayoutToast = null;
        UI.popGhostModule("LayoutToast");
    }

    LayoutToast.onkey_BACKSPACE = LayoutToast.onkey_ESCAPE = function () {
        UI.popGhostModule("LayoutToast");
        APPMODULE.LayoutToast = null;
        if(checkIsAppOn()&& UI.getCurrModule().name=="base"){
            registerKeyCodesForApp();
        }
    };

    LayoutToast.onkey_LEFT = function () {
        keyState = 1;
        if(GLOBAL.TTS){
            UI.callTTS("rewind");
        }
        UI.setImage(LayoutPlayBtn,"setting/bt_core_normal.png");
        UI.setImage(RewindBtn, "setting/bt_rewind_pressed.png");
        UI.setImage(FastForwardBtn, "setting/bt_fastforward_normal.png");
        UI.setImage(EndBtn, "setting/bt_end_normal.png");
        setTimeout(function() {
            UI.setImage(RewindBtn, "setting/bt_rewind_normal.png");
        },200);
        UI.updateStage();
    };

    LayoutToast.onkey_RIGHT = function () {
        keyState = 2;
        if(GLOBAL.TTS){
            UI.callTTS("fastforward");
        }
        UI.setImage(LayoutPlayBtn,"setting/bt_core_normal.png");
        UI.setImage(RewindBtn, "setting/bt_rewind_normal.png");
        UI.setImage(FastForwardBtn, "setting/bt_fastforward_pressed.png");
        UI.setImage(EndBtn, "setting/bt_end_normal.png");
        setTimeout(function() {
            UI.setImage(FastForwardBtn, "setting/bt_fastforward_normal.png");
        },200);
        UI.updateStage();
    };

    LayoutToast.onkey_DOWN = function () {
        keyState = 3;
        if(GLOBAL.TTS){
            UI.callTTS("end");
        }
        UI.setImage(LayoutPlayBtn,"setting/bt_core_normal.png");
        UI.setImage(RewindBtn, "setting/bt_rewind_normal.png");
        UI.setImage(FastForwardBtn, "setting/bt_fastforward_normal.png");
        UI.setImage(EndBtn, "setting/bt_end_pressed.png");
        setTimeout(function() {
            UI.setImage(EndBtn, "setting/bt_end_normal.png");
        },200);
        //if(Current_btn){
        //    UI.popGhostModule("LayoutToast");
        //    APPMODULE.LayoutToast = null;
        //    //tv?UI.send_key_to_dfb(guijs.SYSCMD_STOP):DBG_INFO("3");
        //}
        UI.updateStage();
    };

    LayoutToast.changePlayStatus = function (flag){
        UI.setImage(LayoutPlayBtn,"setting/bt_core_pressed.png");
        UI.setImage(RewindBtn, "setting/bt_rewind_normal.png");
        UI.setImage(FastForwardBtn, "setting/bt_fastforward_normal.png");
        UI.setImage(EndBtn, "setting/bt_end_normal.png");
        setTimeout(function() {
            UI.setImage(LayoutPlayBtn, "setting/bt_core_normal.png");
        },200);
        if(flag){
            keyState = 4;
            if(GLOBAL.TTS){
                UI.callTTS("play");
            }
            pause_flag = false;
        }else{
            keyState = 5;
            if(GLOBAL.TTS){
                UI.callTTS("pause");
            }
            pause_flag = true;
        }
        UI.updateStage();
    }

    LayoutToast.changePlayStatusForMedia = function (flag){
        if(flag){
            pause_flag = false;
        }else{
            pause_flag = true;
        }
        UI.updateStage();
    }

    LayoutToast.onkey_ENTER =  function () {
        UI.setImage(LayoutPlayBtn,"setting/bt_core_normal.png");
        LayoutToast.changePlayStatus (pause_flag);
    };
};

PIXI.loader.add([
    themeDir + "setting/bt_core_pressed.png",
    themeDir + "setting/bt_core_normal.png",
    themeDir + "setting/bt_end_normal.png",
    themeDir + "setting/bt_end_pressed.png",
    themeDir + "setting/bt_rewind_normal.png",
    themeDir + "setting/bt_rewind_pressed.png",
    themeDir + "setting/bt_fastforward_pressed.png",
    themeDir + "setting/bt_fastforward_normal.png"
]);
PIXI.loader.load();